/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.content.res.Resources;
import android.net.NetworkUtils;
import android.text.BidiFormatter;
import android.text.TextUtils;
import java.util.Locale;

public final class Formatter {
    public static final int FLAG_SHORTER = 1;
    public static final int FLAG_CALCULATE_ROUNDED = 2;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final int MILLIS_PER_MINUTE = 60000;

    private static String bidiWrap(Context context, String source) {
        Locale locale = context.getResources().getConfiguration().locale;
        if (TextUtils.getLayoutDirectionFromLocale(locale) == 1) {
            return BidiFormatter.getInstance(true).unicodeWrap(source);
        }
        return source;
    }

    public static String formatFileSize(Context context, long sizeBytes) {
        if (context == null) {
            return "";
        }
        BytesResult res = Formatter.formatBytes(context.getResources(), sizeBytes, 0);
        return Formatter.bidiWrap(context, context.getString(17039866, res.value, res.units));
    }

    public static String formatShortFileSize(Context context, long sizeBytes) {
        if (context == null) {
            return "";
        }
        BytesResult res = Formatter.formatBytes(context.getResources(), sizeBytes, 1);
        return Formatter.bidiWrap(context, context.getString(17039866, res.value, res.units));
    }

    public static BytesResult formatBytes(Resources res, long sizeBytes, int flags) {
        String roundFormat;
        int roundFactor;
        boolean isNegative = sizeBytes < 0L;
        float result = isNegative ? (float)(-sizeBytes) : (float)sizeBytes;
        int suffix = 17039579;
        long mult = 1L;
        if (result > 900.0f) {
            suffix = 17040072;
            mult = 1000L;
            result /= 1000.0f;
        }
        if (result > 900.0f) {
            suffix = 17040253;
            mult *= 1000L;
            result /= 1000.0f;
        }
        if (result > 900.0f) {
            suffix = 17039907;
            mult *= 1000L;
            result /= 1000.0f;
        }
        if (result > 900.0f) {
            suffix = 17040869;
            mult *= 1000L;
            result /= 1000.0f;
        }
        if (result > 900.0f) {
            suffix = 17040593;
            mult *= 1000L;
            result /= 1000.0f;
        }
        if (mult == 1L || result >= 100.0f) {
            roundFactor = 1;
            roundFormat = "%.0f";
        } else if (result < 1.0f) {
            roundFactor = 100;
            roundFormat = "%.2f";
        } else if (result < 10.0f) {
            if ((flags & 1) != 0) {
                roundFactor = 10;
                roundFormat = "%.1f";
            } else {
                roundFactor = 100;
                roundFormat = "%.2f";
            }
        } else if ((flags & 1) != 0) {
            roundFactor = 1;
            roundFormat = "%.0f";
        } else {
            roundFactor = 100;
            roundFormat = "%.2f";
        }
        if (isNegative) {
            result = -result;
        }
        String roundedString = String.format(roundFormat, Float.valueOf(result));
        long roundedBytes = (flags & 2) == 0 ? 0L : (long)Math.round(result * (float)roundFactor) * mult / (long)roundFactor;
        String units = res.getString(suffix);
        return new BytesResult(roundedString, units, roundedBytes);
    }

    @Deprecated
    public static String formatIpAddress(int ipv4Address) {
        return NetworkUtils.intToInetAddress(ipv4Address).getHostAddress();
    }

    public static String formatShortElapsedTime(Context context, long millis) {
        long secondsLong = millis / 1000L;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        if (secondsLong >= 86400L) {
            days = (int)(secondsLong / 86400L);
            secondsLong -= (long)(days * 86400);
        }
        if (secondsLong >= 3600L) {
            hours = (int)(secondsLong / 3600L);
            secondsLong -= (long)(hours * 3600);
        }
        if (secondsLong >= 60L) {
            minutes = (int)(secondsLong / 60L);
            secondsLong -= (long)(minutes * 60);
        }
        int seconds = (int)secondsLong;
        if (days >= 2) {
            return context.getString(17039779, days += (hours + 12) / 24);
        }
        if (days > 0) {
            if (hours == 1) {
                return context.getString(17039777, days, hours);
            }
            return context.getString(17039778, days, hours);
        }
        if (hours >= 2) {
            return context.getString(17039782, hours += (minutes + 30) / 60);
        }
        if (hours > 0) {
            if (minutes == 1) {
                return context.getString(17039780, hours, minutes);
            }
            return context.getString(17039781, hours, minutes);
        }
        if (minutes >= 2) {
            return context.getString(17039786, minutes += (seconds + 30) / 60);
        }
        if (minutes > 0) {
            if (seconds == 1) {
                return context.getString(17039784, minutes, seconds);
            }
            return context.getString(17039785, minutes, seconds);
        }
        if (seconds == 1) {
            return context.getString(17039787, seconds);
        }
        return context.getString(17039788, seconds);
    }

    public static String formatShortElapsedTimeRoundingUpToMinutes(Context context, long millis) {
        long minutesRoundedUp = (millis + 60000L - 1L) / 60000L;
        if (minutesRoundedUp == 0L) {
            return context.getString(17039786, 0);
        }
        if (minutesRoundedUp == 1L) {
            return context.getString(17039783, 1);
        }
        return Formatter.formatShortElapsedTime(context, minutesRoundedUp * 60000L);
    }

    public static class BytesResult {
        public final String value;
        public final String units;
        public final long roundedBytes;

        public BytesResult(String value, String units, long roundedBytes) {
            this.value = value;
            this.units = units;
            this.roundedBytes = roundedBytes;
        }
    }
}

