/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.content.Context;
import android.graphics.Rect;
import android.icu.text.CaseMap;
import android.icu.text.Edits;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.TransformationMethod2;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import java.util.Locale;

public class AllCapsTransformationMethod
implements TransformationMethod2 {
    private static final String TAG = "AllCapsTransformationMethod";
    private boolean mEnabled;
    private Locale mLocale;

    public AllCapsTransformationMethod(Context context) {
        this.mLocale = context.getResources().getConfiguration().getLocales().get(0);
    }

    @Override
    public CharSequence getTransformation(CharSequence source, View view) {
        Object[] spans;
        if (!this.mEnabled) {
            Log.w(TAG, "Caller did not enable length changes; not transforming text");
            return source;
        }
        if (source == null) {
            return null;
        }
        Locale locale = null;
        if (view instanceof TextView) {
            locale = ((TextView)view).getTextLocale();
        }
        if (locale == null) {
            locale = this.mLocale;
        }
        if (!(source instanceof Spanned)) {
            return CaseMap.toUpper().apply(locale, source, new StringBuilder(), null);
        }
        Edits edits = new Edits();
        SpannableStringBuilder result = CaseMap.toUpper().apply(locale, source, new SpannableStringBuilder(), edits);
        if (!edits.hasChanges()) {
            return source;
        }
        Edits.Iterator iterator = edits.getFineIterator();
        Spanned spanned = (Spanned)source;
        int sourceLength = source.length();
        for (Object span : spans = spanned.getSpans(0, sourceLength, Object.class)) {
            int sourceStart = spanned.getSpanStart(span);
            int sourceEnd = spanned.getSpanEnd(span);
            int flags = spanned.getSpanFlags(span);
            int destStart = sourceStart == sourceLength ? result.length() : AllCapsTransformationMethod.mapToDest(iterator, sourceStart);
            int destEnd = sourceEnd == sourceLength ? result.length() : AllCapsTransformationMethod.mapToDest(iterator, sourceEnd);
            result.setSpan(span, destStart, destEnd, flags);
        }
        return result;
    }

    private static int mapToDest(Edits.Iterator iterator, int sourceIndex) {
        iterator.findSourceIndex(sourceIndex);
        if (sourceIndex == iterator.sourceIndex()) {
            return iterator.destinationIndex();
        }
        if (iterator.hasChange()) {
            return iterator.destinationIndex() + iterator.newLength();
        }
        return iterator.destinationIndex() + (sourceIndex - iterator.sourceIndex());
    }

    @Override
    public void onFocusChanged(View view, CharSequence sourceText, boolean focused, int direction, Rect previouslyFocusedRect) {
    }

    @Override
    public void setLengthChangesAllowed(boolean allowLengthChanges) {
        this.mEnabled = allowLengthChanges;
    }
}

