/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.LauncherIcons;

public class IconDrawableFactory {
    protected final Context mContext;
    protected final PackageManager mPm;
    protected final UserManager mUm;
    protected final LauncherIcons mLauncherIcons;
    protected final boolean mEmbedShadow;
    public static final int[] CORP_BADGE_COLORS = new int[]{17170712, 17170713, 17170714};

    private IconDrawableFactory(Context context, boolean embedShadow) {
        this.mContext = context;
        this.mPm = context.getPackageManager();
        this.mUm = context.getSystemService(UserManager.class);
        this.mLauncherIcons = new LauncherIcons(context);
        this.mEmbedShadow = embedShadow;
    }

    protected boolean needsBadging(ApplicationInfo appInfo, int userId) {
        return appInfo.isInstantApp() || this.mUm.isManagedProfile(userId);
    }

    public Drawable getBadgedIcon(ApplicationInfo appInfo) {
        return this.getBadgedIcon(appInfo, UserHandle.getUserId(appInfo.uid));
    }

    public Drawable getBadgedIcon(ApplicationInfo appInfo, int userId) {
        return this.getBadgedIcon(appInfo, appInfo, userId);
    }

    public Drawable getBadgedIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo, int userId) {
        Drawable icon = this.mPm.loadUnbadgedItemIcon(itemInfo, appInfo);
        if (!this.mEmbedShadow && !this.needsBadging(appInfo, userId)) {
            return icon;
        }
        icon = this.mLauncherIcons.wrapIconDrawableWithShadow(icon);
        if (appInfo.isInstantApp()) {
            int badgeColor = Resources.getSystem().getColor(17170596, null);
            icon = this.mLauncherIcons.getBadgedDrawable(icon, 17302386, badgeColor);
        }
        if (this.mUm.isManagedProfile(userId)) {
            icon = this.mLauncherIcons.getBadgedDrawable(icon, 17302324, IconDrawableFactory.getUserBadgeColor(this.mUm, userId));
        }
        return icon;
    }

    public static int getUserBadgeColor(UserManager um, int userId) {
        int badge = um.getManagedProfileBadge(userId);
        if (badge < 0) {
            badge = 0;
        }
        int resourceId = CORP_BADGE_COLORS[badge % CORP_BADGE_COLORS.length];
        return Resources.getSystem().getColor(resourceId, null);
    }

    public static IconDrawableFactory newInstance(Context context) {
        return new IconDrawableFactory(context, true);
    }

    public static IconDrawableFactory newInstance(Context context, boolean embedShadow) {
        return new IconDrawableFactory(context, embedShadow);
    }
}

