/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.PrintWriter;

public class MergedConfiguration
implements Parcelable {
    private Configuration mGlobalConfig = new Configuration();
    private Configuration mOverrideConfig = new Configuration();
    private Configuration mMergedConfig = new Configuration();
    public static final Parcelable.Creator<MergedConfiguration> CREATOR = new Parcelable.Creator<MergedConfiguration>(){

        @Override
        public MergedConfiguration createFromParcel(Parcel in) {
            return new MergedConfiguration(in);
        }

        public MergedConfiguration[] newArray(int size) {
            return new MergedConfiguration[size];
        }
    };

    public MergedConfiguration() {
    }

    public MergedConfiguration(Configuration globalConfig, Configuration overrideConfig) {
        this.setConfiguration(globalConfig, overrideConfig);
    }

    public MergedConfiguration(Configuration globalConfig) {
        this.setGlobalConfiguration(globalConfig);
    }

    public MergedConfiguration(MergedConfiguration mergedConfiguration) {
        this.setConfiguration(mergedConfiguration.getGlobalConfiguration(), mergedConfiguration.getOverrideConfiguration());
    }

    private MergedConfiguration(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mGlobalConfig, flags);
        dest.writeParcelable(this.mOverrideConfig, flags);
        dest.writeParcelable(this.mMergedConfig, flags);
    }

    public void readFromParcel(Parcel source) {
        this.mGlobalConfig = (Configuration)source.readParcelable(Configuration.class.getClassLoader());
        this.mOverrideConfig = (Configuration)source.readParcelable(Configuration.class.getClassLoader());
        this.mMergedConfig = (Configuration)source.readParcelable(Configuration.class.getClassLoader());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void setConfiguration(Configuration globalConfig, Configuration overrideConfig) {
        this.mGlobalConfig.setTo(globalConfig);
        this.mOverrideConfig.setTo(overrideConfig);
        this.updateMergedConfig();
    }

    public void setGlobalConfiguration(Configuration globalConfig) {
        this.mGlobalConfig.setTo(globalConfig);
        this.updateMergedConfig();
    }

    public void setOverrideConfiguration(Configuration overrideConfig) {
        this.mOverrideConfig.setTo(overrideConfig);
        this.updateMergedConfig();
    }

    public void setTo(MergedConfiguration config) {
        this.setConfiguration(config.mGlobalConfig, config.mOverrideConfig);
    }

    public void unset() {
        this.mGlobalConfig.unset();
        this.mOverrideConfig.unset();
        this.updateMergedConfig();
    }

    public Configuration getGlobalConfiguration() {
        return this.mGlobalConfig;
    }

    public Configuration getOverrideConfiguration() {
        return this.mOverrideConfig;
    }

    public Configuration getMergedConfiguration() {
        return this.mMergedConfig;
    }

    private void updateMergedConfig() {
        this.mMergedConfig.setTo(this.mGlobalConfig);
        this.mMergedConfig.updateFrom(this.mOverrideConfig);
    }

    public String toString() {
        return "{mGlobalConfig=" + this.mGlobalConfig + " mOverrideConfig=" + this.mOverrideConfig + "}";
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "mGlobalConfig=" + this.mGlobalConfig);
        pw.println(prefix + "mOverrideConfig=" + this.mOverrideConfig);
    }
}

