/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.text.style.AccessibilityClickableSpan;
import android.text.style.ClickableSpan;
import android.util.LongSparseArray;
import android.view.MagnificationSpec;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import com.android.internal.os.SomeArgs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

final class AccessibilityInteractionController {
    private static final boolean ENFORCE_NODE_TREE_CONSISTENT = false;
    private final ArrayList<AccessibilityNodeInfo> mTempAccessibilityNodeInfoList = new ArrayList();
    private final Handler mHandler;
    private final ViewRootImpl mViewRootImpl;
    private final AccessibilityNodePrefetcher mPrefetcher;
    private final long mMyLooperThreadId;
    private final int mMyProcessId;
    private final ArrayList<View> mTempArrayList = new ArrayList();
    private final Point mTempPoint = new Point();
    private final Rect mTempRect = new Rect();
    private final Rect mTempRect1 = new Rect();
    private final Rect mTempRect2 = new Rect();
    private AddNodeInfosForViewId mAddNodeInfosForViewId;

    public AccessibilityInteractionController(ViewRootImpl viewRootImpl) {
        Looper looper = viewRootImpl.mHandler.getLooper();
        this.mMyLooperThreadId = looper.getThread().getId();
        this.mMyProcessId = Process.myPid();
        this.mHandler = new PrivateHandler(looper);
        this.mViewRootImpl = viewRootImpl;
        this.mPrefetcher = new AccessibilityNodePrefetcher();
    }

    private void scheduleMessage(Message message, int interrogatingPid, long interrogatingTid) {
        if (interrogatingPid == this.mMyProcessId && interrogatingTid == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(interrogatingTid).setSameThreadMessage(message);
        } else {
            this.mHandler.sendMessage(message);
        }
    }

    private boolean isShown(View view) {
        return view.mAttachInfo != null && view.mAttachInfo.mWindowVisibility == 0 && view.isShown();
    }

    public void findAccessibilityNodeInfoByAccessibilityIdClientThread(long accessibilityNodeId, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec, Bundle arguments) {
        Message message = this.mHandler.obtainMessage();
        message.what = 2;
        message.arg1 = flags;
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        args.argi2 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi3 = interactionId;
        args.arg1 = callback;
        args.arg2 = spec;
        args.arg3 = interactiveRegion;
        args.arg4 = arguments;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAccessibilityNodeInfoByAccessibilityIdUiThread(Message message) {
        int flags = message.arg1;
        SomeArgs args = (SomeArgs)message.obj;
        int accessibilityViewId = args.argi1;
        int virtualDescendantId = args.argi2;
        int interactionId = args.argi3;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        MagnificationSpec spec = (MagnificationSpec)args.arg2;
        Region interactiveRegion = (Region)args.arg3;
        Bundle arguments = (Bundle)args.arg4;
        args.recycle();
        ArrayList<AccessibilityNodeInfo> infos = this.mTempAccessibilityNodeInfoList;
        infos.clear();
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
            View root = null;
            root = accessibilityViewId == 0x7FFFFFFE ? this.mViewRootImpl.mView : this.findViewByAccessibilityId(accessibilityViewId);
            if (root != null && this.isShown(root)) {
                this.mPrefetcher.prefetchAccessibilityNodeInfos(root, virtualDescendantId, flags, infos, arguments);
            }
        }
        finally {
            this.updateInfosForViewportAndReturnFindNodeResult(infos, callback, interactionId, spec, interactiveRegion);
        }
    }

    public void findAccessibilityNodeInfosByViewIdClientThread(long accessibilityNodeId, String viewId, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 3;
        message.arg1 = flags;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = interactionId;
        args.arg1 = callback;
        args.arg2 = spec;
        args.arg3 = viewId;
        args.arg4 = interactiveRegion;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAccessibilityNodeInfosByViewIdUiThread(Message message) {
        int flags = message.arg1;
        int accessibilityViewId = message.arg2;
        SomeArgs args = (SomeArgs)message.obj;
        int interactionId = args.argi1;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        MagnificationSpec spec = (MagnificationSpec)args.arg2;
        String viewId = (String)args.arg3;
        Region interactiveRegion = (Region)args.arg4;
        args.recycle();
        ArrayList<AccessibilityNodeInfo> infos = this.mTempAccessibilityNodeInfoList;
        infos.clear();
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
            View root = null;
            root = accessibilityViewId != 0x7FFFFFFE ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
            if (root != null) {
                int resolvedViewId = root.getContext().getResources().getIdentifier(viewId, null, null);
                if (resolvedViewId <= 0) {
                    return;
                }
                if (this.mAddNodeInfosForViewId == null) {
                    this.mAddNodeInfosForViewId = new AddNodeInfosForViewId();
                }
                this.mAddNodeInfosForViewId.init(resolvedViewId, infos);
                root.findViewByPredicate(this.mAddNodeInfosForViewId);
                this.mAddNodeInfosForViewId.reset();
            }
        }
        finally {
            this.updateInfosForViewportAndReturnFindNodeResult(infos, callback, interactionId, spec, interactiveRegion);
        }
    }

    public void findAccessibilityNodeInfosByTextClientThread(long accessibilityNodeId, String text, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 4;
        message.arg1 = flags;
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = text;
        args.arg2 = callback;
        args.arg3 = spec;
        args.argi1 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        args.argi2 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi3 = interactionId;
        args.arg4 = interactiveRegion;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAccessibilityNodeInfosByTextUiThread(Message message) {
        int flags = message.arg1;
        SomeArgs args = (SomeArgs)message.obj;
        String text = (String)args.arg1;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg2;
        MagnificationSpec spec = (MagnificationSpec)args.arg3;
        int accessibilityViewId = args.argi1;
        int virtualDescendantId = args.argi2;
        int interactionId = args.argi3;
        Region interactiveRegion = (Region)args.arg4;
        args.recycle();
        List<AccessibilityNodeInfo> infos = null;
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
            View root = null;
            root = accessibilityViewId != 0x7FFFFFFE ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
            if (root != null && this.isShown(root)) {
                AccessibilityNodeProvider provider = root.getAccessibilityNodeProvider();
                if (provider != null) {
                    infos = provider.findAccessibilityNodeInfosByText(text, virtualDescendantId);
                } else if (virtualDescendantId == -1) {
                    ArrayList<View> foundViews = this.mTempArrayList;
                    foundViews.clear();
                    root.findViewsWithText(foundViews, text, 7);
                    if (!foundViews.isEmpty()) {
                        infos = this.mTempAccessibilityNodeInfoList;
                        infos.clear();
                        int viewCount = foundViews.size();
                        for (int i = 0; i < viewCount; ++i) {
                            View foundView = foundViews.get(i);
                            if (!this.isShown(foundView)) continue;
                            provider = foundView.getAccessibilityNodeProvider();
                            if (provider != null) {
                                List<AccessibilityNodeInfo> infosFromProvider = provider.findAccessibilityNodeInfosByText(text, -1);
                                if (infosFromProvider == null) continue;
                                infos.addAll(infosFromProvider);
                                continue;
                            }
                            infos.add(foundView.createAccessibilityNodeInfo());
                        }
                    }
                }
            }
        }
        finally {
            this.updateInfosForViewportAndReturnFindNodeResult(infos, callback, interactionId, spec, interactiveRegion);
        }
    }

    public void findFocusClientThread(long accessibilityNodeId, int focusType, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 5;
        message.arg1 = flags;
        message.arg2 = focusType;
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = interactionId;
        args.argi2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        args.argi3 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.arg1 = callback;
        args.arg2 = spec;
        args.arg3 = interactiveRegion;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findFocusUiThread(Message message) {
        int flags = message.arg1;
        int focusType = message.arg2;
        SomeArgs args = (SomeArgs)message.obj;
        int interactionId = args.argi1;
        int accessibilityViewId = args.argi2;
        int virtualDescendantId = args.argi3;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        MagnificationSpec spec = (MagnificationSpec)args.arg2;
        Region interactiveRegion = (Region)args.arg3;
        args.recycle();
        AccessibilityNodeInfo focused = null;
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
            View root = null;
            root = accessibilityViewId != 0x7FFFFFFE ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
            if (root == null || !this.isShown(root)) return;
            switch (focusType) {
                case 2: {
                    View host = this.mViewRootImpl.mAccessibilityFocusedHost;
                    if (host == null) return;
                    if (!ViewRootImpl.isViewDescendantOf(host, root)) {
                        return;
                    } else if (!this.isShown(host)) {
                        return;
                    } else {
                        AccessibilityNodeProvider provider = host.getAccessibilityNodeProvider();
                        if (provider != null) {
                            if (this.mViewRootImpl.mAccessibilityFocusedVirtualView == null) return;
                            focused = AccessibilityNodeInfo.obtain(this.mViewRootImpl.mAccessibilityFocusedVirtualView);
                            return;
                        } else {
                            if (virtualDescendantId != -1) return;
                            focused = host.createAccessibilityNodeInfo();
                            return;
                        }
                    }
                }
                case 1: {
                    View target = root.findFocus();
                    if (target == null) return;
                    if (!this.isShown(target)) {
                        return;
                    } else {
                        AccessibilityNodeProvider provider = target.getAccessibilityNodeProvider();
                        if (provider != null) {
                            focused = provider.findFocus(focusType);
                        }
                        if (focused != null) return;
                        focused = target.createAccessibilityNodeInfo();
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown focus type: " + focusType);
                }
            }
        }
        finally {
            this.updateInfoForViewportAndReturnFindNodeResult(focused, callback, interactionId, spec, interactiveRegion);
        }
    }

    public void focusSearchClientThread(long accessibilityNodeId, int direction, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 6;
        message.arg1 = flags;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        SomeArgs args = SomeArgs.obtain();
        args.argi2 = direction;
        args.argi3 = interactionId;
        args.arg1 = callback;
        args.arg2 = spec;
        args.arg3 = interactiveRegion;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void focusSearchUiThread(Message message) {
        int flags = message.arg1;
        int accessibilityViewId = message.arg2;
        SomeArgs args = (SomeArgs)message.obj;
        int direction = args.argi2;
        int interactionId = args.argi3;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        MagnificationSpec spec = (MagnificationSpec)args.arg2;
        Region interactiveRegion = (Region)args.arg3;
        args.recycle();
        AccessibilityNodeInfo next = null;
        try {
            View nextView;
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
            View root = null;
            root = accessibilityViewId != 0x7FFFFFFE ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
            if (root != null && this.isShown(root) && (nextView = root.focusSearch(direction)) != null) {
                next = nextView.createAccessibilityNodeInfo();
            }
        }
        finally {
            this.updateInfoForViewportAndReturnFindNodeResult(next, callback, interactionId, spec, interactiveRegion);
        }
    }

    public void performAccessibilityActionClientThread(long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid) {
        Message message = this.mHandler.obtainMessage();
        message.what = 1;
        message.arg1 = flags;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi2 = action;
        args.argi3 = interactionId;
        args.arg1 = callback;
        args.arg2 = arguments;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAccessibilityActionUiThread(Message message) {
        int flags = message.arg1;
        int accessibilityViewId = message.arg2;
        SomeArgs args = (SomeArgs)message.obj;
        int virtualDescendantId = args.argi1;
        int action = args.argi2;
        int interactionId = args.argi3;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        Bundle arguments = (Bundle)args.arg2;
        args.recycle();
        boolean succeeded = false;
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null || this.mViewRootImpl.mStopped || this.mViewRootImpl.mPausedForTransition) {
                return;
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
            View target = null;
            target = accessibilityViewId != 0x7FFFFFFE ? this.findViewByAccessibilityId(accessibilityViewId) : this.mViewRootImpl.mView;
            if (target != null && this.isShown(target)) {
                if (action == 16908647) {
                    succeeded = this.handleClickableSpanActionUiThread(target, virtualDescendantId, arguments);
                } else {
                    AccessibilityNodeProvider provider = target.getAccessibilityNodeProvider();
                    if (provider != null) {
                        succeeded = provider.performAction(virtualDescendantId, action, arguments);
                    } else if (virtualDescendantId == -1) {
                        succeeded = target.performAccessibilityAction(action, arguments);
                    }
                }
            }
        }
        finally {
            try {
                this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                callback.setPerformAccessibilityActionResult(succeeded, interactionId);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private View findViewByAccessibilityId(int accessibilityId) {
        View root = this.mViewRootImpl.mView;
        if (root == null) {
            return null;
        }
        Object foundView = root.findViewByAccessibilityId(accessibilityId);
        if (foundView != null && !this.isShown((View)foundView)) {
            return null;
        }
        return foundView;
    }

    private void applyAppScaleAndMagnificationSpecIfNeeded(List<AccessibilityNodeInfo> infos, MagnificationSpec spec) {
        if (infos == null) {
            return;
        }
        float applicationScale = this.mViewRootImpl.mAttachInfo.mApplicationScale;
        if (this.shouldApplyAppScaleAndMagnificationSpec(applicationScale, spec)) {
            int infoCount = infos.size();
            for (int i = 0; i < infoCount; ++i) {
                AccessibilityNodeInfo info = infos.get(i);
                this.applyAppScaleAndMagnificationSpecIfNeeded(info, spec);
            }
        }
    }

    private void adjustIsVisibleToUserIfNeeded(List<AccessibilityNodeInfo> infos, Region interactiveRegion) {
        if (interactiveRegion == null || infos == null) {
            return;
        }
        int infoCount = infos.size();
        for (int i = 0; i < infoCount; ++i) {
            AccessibilityNodeInfo info = infos.get(i);
            this.adjustIsVisibleToUserIfNeeded(info, interactiveRegion);
        }
    }

    private void adjustIsVisibleToUserIfNeeded(AccessibilityNodeInfo info, Region interactiveRegion) {
        if (interactiveRegion == null || info == null) {
            return;
        }
        Rect boundsInScreen = this.mTempRect;
        info.getBoundsInScreen(boundsInScreen);
        if (interactiveRegion.quickReject(boundsInScreen)) {
            info.setVisibleToUser(false);
        }
    }

    private void applyAppScaleAndMagnificationSpecIfNeeded(AccessibilityNodeInfo info, MagnificationSpec spec) {
        Bundle extras;
        Parcelable[] textLocations;
        if (info == null) {
            return;
        }
        float applicationScale = this.mViewRootImpl.mAttachInfo.mApplicationScale;
        if (!this.shouldApplyAppScaleAndMagnificationSpec(applicationScale, spec)) {
            return;
        }
        Rect boundsInParent = this.mTempRect;
        Rect boundsInScreen = this.mTempRect1;
        info.getBoundsInParent(boundsInParent);
        info.getBoundsInScreen(boundsInScreen);
        if (applicationScale != 1.0f) {
            boundsInParent.scale(applicationScale);
            boundsInScreen.scale(applicationScale);
        }
        if (spec != null) {
            boundsInParent.scale(spec.scale);
            boundsInScreen.scale(spec.scale);
            boundsInScreen.offset((int)spec.offsetX, (int)spec.offsetY);
        }
        info.setBoundsInParent(boundsInParent);
        info.setBoundsInScreen(boundsInScreen);
        if (info.hasExtras() && (textLocations = (extras = info.getExtras()).getParcelableArray("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY")) != null) {
            for (int i = 0; i < textLocations.length; ++i) {
                RectF textLocation = (RectF)textLocations[i];
                textLocation.scale(applicationScale);
                if (spec == null) continue;
                textLocation.scale(spec.scale);
                textLocation.offset(spec.offsetX, spec.offsetY);
            }
        }
        if (spec != null) {
            View.AttachInfo attachInfo = this.mViewRootImpl.mAttachInfo;
            if (attachInfo.mDisplay == null) {
                return;
            }
            float scale = attachInfo.mApplicationScale * spec.scale;
            Rect visibleWinFrame = this.mTempRect1;
            visibleWinFrame.left = (int)((float)attachInfo.mWindowLeft * scale + spec.offsetX);
            visibleWinFrame.top = (int)((float)attachInfo.mWindowTop * scale + spec.offsetY);
            visibleWinFrame.right = (int)((float)visibleWinFrame.left + (float)this.mViewRootImpl.mWidth * scale);
            visibleWinFrame.bottom = (int)((float)visibleWinFrame.top + (float)this.mViewRootImpl.mHeight * scale);
            attachInfo.mDisplay.getRealSize(this.mTempPoint);
            int displayWidth = this.mTempPoint.x;
            int displayHeight = this.mTempPoint.y;
            Rect visibleDisplayFrame = this.mTempRect2;
            visibleDisplayFrame.set(0, 0, displayWidth, displayHeight);
            if (!visibleWinFrame.intersect(visibleDisplayFrame)) {
                visibleDisplayFrame.setEmpty();
            }
            if (!visibleWinFrame.intersects(boundsInScreen.left, boundsInScreen.top, boundsInScreen.right, boundsInScreen.bottom)) {
                info.setVisibleToUser(false);
            }
        }
    }

    private boolean shouldApplyAppScaleAndMagnificationSpec(float appScale, MagnificationSpec spec) {
        return appScale != 1.0f || spec != null && !spec.isNop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInfosForViewportAndReturnFindNodeResult(List<AccessibilityNodeInfo> infos, IAccessibilityInteractionConnectionCallback callback, int interactionId, MagnificationSpec spec, Region interactiveRegion) {
        try {
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
            this.applyAppScaleAndMagnificationSpecIfNeeded(infos, spec);
            this.adjustIsVisibleToUserIfNeeded(infos, interactiveRegion);
            callback.setFindAccessibilityNodeInfosResult(infos, interactionId);
            if (infos != null) {
                infos.clear();
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.recycleMagnificationSpecAndRegionIfNeeded(spec, interactiveRegion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInfoForViewportAndReturnFindNodeResult(AccessibilityNodeInfo info, IAccessibilityInteractionConnectionCallback callback, int interactionId, MagnificationSpec spec, Region interactiveRegion) {
        try {
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
            this.applyAppScaleAndMagnificationSpecIfNeeded(info, spec);
            this.adjustIsVisibleToUserIfNeeded(info, interactiveRegion);
            callback.setFindAccessibilityNodeInfoResult(info, interactionId);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.recycleMagnificationSpecAndRegionIfNeeded(spec, interactiveRegion);
        }
    }

    private void recycleMagnificationSpecAndRegionIfNeeded(MagnificationSpec spec, Region region) {
        if (Process.myPid() != Binder.getCallingPid()) {
            if (spec != null) {
                spec.recycle();
            }
        } else if (region != null) {
            region.recycle();
        }
    }

    private boolean handleClickableSpanActionUiThread(View view, int virtualDescendantId, Bundle arguments) {
        Object span = arguments.getParcelable("android.view.accessibility.action.ACTION_ARGUMENT_ACCESSIBLE_CLICKABLE_SPAN");
        if (!(span instanceof AccessibilityClickableSpan)) {
            return false;
        }
        AccessibilityNodeInfo infoWithSpan = null;
        AccessibilityNodeProvider provider = view.getAccessibilityNodeProvider();
        if (provider != null) {
            infoWithSpan = provider.createAccessibilityNodeInfo(virtualDescendantId);
        } else if (virtualDescendantId == -1) {
            infoWithSpan = view.createAccessibilityNodeInfo();
        }
        if (infoWithSpan == null) {
            return false;
        }
        ClickableSpan clickableSpan = ((AccessibilityClickableSpan)span).findClickableSpan(infoWithSpan.getOriginalText());
        if (clickableSpan != null) {
            clickableSpan.onClick(view);
            return true;
        }
        return false;
    }

    private final class AddNodeInfosForViewId
    implements Predicate<View> {
        private int mViewId = -1;
        private List<AccessibilityNodeInfo> mInfos;

        private AddNodeInfosForViewId() {
        }

        public void init(int viewId, List<AccessibilityNodeInfo> infos) {
            this.mViewId = viewId;
            this.mInfos = infos;
        }

        public void reset() {
            this.mViewId = -1;
            this.mInfos = null;
        }

        @Override
        public boolean test(View view) {
            if (view.getId() == this.mViewId && AccessibilityInteractionController.this.isShown(view)) {
                this.mInfos.add(view.createAccessibilityNodeInfo());
            }
            return false;
        }
    }

    private class PrivateHandler
    extends Handler {
        private static final int MSG_PERFORM_ACCESSIBILITY_ACTION = 1;
        private static final int MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_ACCESSIBILITY_ID = 2;
        private static final int MSG_FIND_ACCESSIBILITY_NODE_INFOS_BY_VIEW_ID = 3;
        private static final int MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_TEXT = 4;
        private static final int MSG_FIND_FOCUS = 5;
        private static final int MSG_FOCUS_SEARCH = 6;

        public PrivateHandler(Looper looper) {
            super(looper);
        }

        @Override
        public String getMessageName(Message message) {
            int type = message.what;
            switch (type) {
                case 1: {
                    return "MSG_PERFORM_ACCESSIBILITY_ACTION";
                }
                case 2: {
                    return "MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_ACCESSIBILITY_ID";
                }
                case 3: {
                    return "MSG_FIND_ACCESSIBILITY_NODE_INFOS_BY_VIEW_ID";
                }
                case 4: {
                    return "MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_TEXT";
                }
                case 5: {
                    return "MSG_FIND_FOCUS";
                }
                case 6: {
                    return "MSG_FOCUS_SEARCH";
                }
            }
            throw new IllegalArgumentException("Unknown message type: " + type);
        }

        @Override
        public void handleMessage(Message message) {
            int type = message.what;
            switch (type) {
                case 2: {
                    AccessibilityInteractionController.this.findAccessibilityNodeInfoByAccessibilityIdUiThread(message);
                    break;
                }
                case 1: {
                    AccessibilityInteractionController.this.performAccessibilityActionUiThread(message);
                    break;
                }
                case 3: {
                    AccessibilityInteractionController.this.findAccessibilityNodeInfosByViewIdUiThread(message);
                    break;
                }
                case 4: {
                    AccessibilityInteractionController.this.findAccessibilityNodeInfosByTextUiThread(message);
                    break;
                }
                case 5: {
                    AccessibilityInteractionController.this.findFocusUiThread(message);
                    break;
                }
                case 6: {
                    AccessibilityInteractionController.this.focusSearchUiThread(message);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message type: " + type);
                }
            }
        }
    }

    private class AccessibilityNodePrefetcher {
        private static final int MAX_ACCESSIBILITY_NODE_INFO_BATCH_SIZE = 50;
        private final ArrayList<View> mTempViewList = new ArrayList();

        private AccessibilityNodePrefetcher() {
        }

        public void prefetchAccessibilityNodeInfos(View view, int virtualViewId, int fetchFlags, List<AccessibilityNodeInfo> outInfos, Bundle arguments) {
            String extraDataRequested;
            AccessibilityNodeProvider provider = view.getAccessibilityNodeProvider();
            String string2 = extraDataRequested = arguments == null ? null : arguments.getString("android.view.accessibility.AccessibilityNodeInfo.extra_data_requested");
            if (provider == null) {
                AccessibilityNodeInfo root = view.createAccessibilityNodeInfo();
                if (root != null) {
                    if (extraDataRequested != null) {
                        view.addExtraDataToAccessibilityNodeInfo(root, extraDataRequested, arguments);
                    }
                    outInfos.add(root);
                    if ((fetchFlags & 1) != 0) {
                        this.prefetchPredecessorsOfRealNode(view, outInfos);
                    }
                    if ((fetchFlags & 2) != 0) {
                        this.prefetchSiblingsOfRealNode(view, outInfos);
                    }
                    if ((fetchFlags & 4) != 0) {
                        this.prefetchDescendantsOfRealNode(view, outInfos);
                    }
                }
            } else {
                AccessibilityNodeInfo root = provider.createAccessibilityNodeInfo(virtualViewId);
                if (root != null) {
                    if (extraDataRequested != null) {
                        provider.addExtraDataToAccessibilityNodeInfo(virtualViewId, root, extraDataRequested, arguments);
                    }
                    outInfos.add(root);
                    if ((fetchFlags & 1) != 0) {
                        this.prefetchPredecessorsOfVirtualNode(root, view, provider, outInfos);
                    }
                    if ((fetchFlags & 2) != 0) {
                        this.prefetchSiblingsOfVirtualNode(root, view, provider, outInfos);
                    }
                    if ((fetchFlags & 4) != 0) {
                        this.prefetchDescendantsOfVirtualNode(root, provider, outInfos);
                    }
                }
            }
        }

        private void enforceNodeTreeConsistent(List<AccessibilityNodeInfo> nodes) {
            AccessibilityNodeInfo root;
            LongSparseArray<AccessibilityNodeInfo> nodeMap = new LongSparseArray<AccessibilityNodeInfo>();
            int nodeCount = nodes.size();
            for (int i = 0; i < nodeCount; ++i) {
                AccessibilityNodeInfo node = nodes.get(i);
                nodeMap.put(node.getSourceNodeId(), node);
            }
            AccessibilityNodeInfo parent = root = (AccessibilityNodeInfo)nodeMap.valueAt(0);
            while (parent != null) {
                root = parent;
                parent = (AccessibilityNodeInfo)nodeMap.get(parent.getParentNodeId());
            }
            AccessibilityNodeInfo accessFocus = null;
            AccessibilityNodeInfo inputFocus = null;
            HashSet<AccessibilityNodeInfo> seen = new HashSet<AccessibilityNodeInfo>();
            LinkedList<AccessibilityNodeInfo> fringe = new LinkedList<AccessibilityNodeInfo>();
            fringe.add(root);
            while (!fringe.isEmpty()) {
                AccessibilityNodeInfo current = (AccessibilityNodeInfo)fringe.poll();
                if (!seen.add(current)) {
                    throw new IllegalStateException("Duplicate node: " + current + " in window:" + ((AccessibilityInteractionController)AccessibilityInteractionController.this).mViewRootImpl.mAttachInfo.mAccessibilityWindowId);
                }
                if (current.isAccessibilityFocused()) {
                    if (accessFocus != null) {
                        throw new IllegalStateException("Duplicate accessibility focus:" + current + " in window:" + ((AccessibilityInteractionController)AccessibilityInteractionController.this).mViewRootImpl.mAttachInfo.mAccessibilityWindowId);
                    }
                    accessFocus = current;
                }
                if (current.isFocused()) {
                    if (inputFocus != null) {
                        throw new IllegalStateException("Duplicate input focus: " + current + " in window:" + ((AccessibilityInteractionController)AccessibilityInteractionController.this).mViewRootImpl.mAttachInfo.mAccessibilityWindowId);
                    }
                    inputFocus = current;
                }
                int childCount = current.getChildCount();
                for (int j = 0; j < childCount; ++j) {
                    long childId = current.getChildId(j);
                    AccessibilityNodeInfo child = (AccessibilityNodeInfo)nodeMap.get(childId);
                    if (child == null) continue;
                    fringe.add(child);
                }
            }
            for (int j = nodeMap.size() - 1; j >= 0; --j) {
                AccessibilityNodeInfo info = (AccessibilityNodeInfo)nodeMap.valueAt(j);
                if (seen.contains(info)) continue;
                throw new IllegalStateException("Disconnected node: " + info);
            }
        }

        private void prefetchPredecessorsOfRealNode(View view, List<AccessibilityNodeInfo> outInfos) {
            ViewParent parent = view.getParentForAccessibility();
            while (parent instanceof View && outInfos.size() < 50) {
                View parentView = (View)((Object)parent);
                AccessibilityNodeInfo info = parentView.createAccessibilityNodeInfo();
                if (info != null) {
                    outInfos.add(info);
                }
                parent = parent.getParentForAccessibility();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prefetchSiblingsOfRealNode(View current, List<AccessibilityNodeInfo> outInfos) {
            ViewParent parent = current.getParentForAccessibility();
            if (parent instanceof ViewGroup) {
                ViewGroup parentGroup = (ViewGroup)parent;
                ArrayList<View> children = this.mTempViewList;
                children.clear();
                try {
                    parentGroup.addChildrenForAccessibility(children);
                    int childCount = children.size();
                    for (int i = 0; i < childCount; ++i) {
                        if (outInfos.size() >= 50) {
                            return;
                        }
                        View child = children.get(i);
                        if (child.getAccessibilityViewId() == current.getAccessibilityViewId() || !AccessibilityInteractionController.this.isShown(child)) continue;
                        AccessibilityNodeInfo info = null;
                        AccessibilityNodeProvider provider = child.getAccessibilityNodeProvider();
                        info = provider == null ? child.createAccessibilityNodeInfo() : provider.createAccessibilityNodeInfo(-1);
                        if (info == null) continue;
                        outInfos.add(info);
                    }
                }
                finally {
                    children.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prefetchDescendantsOfRealNode(View root, List<AccessibilityNodeInfo> outInfos) {
            if (!(root instanceof ViewGroup)) {
                return;
            }
            HashMap<View, AccessibilityNodeInfo> addedChildren = new HashMap<View, AccessibilityNodeInfo>();
            ArrayList<View> children = this.mTempViewList;
            children.clear();
            try {
                root.addChildrenForAccessibility(children);
                int childCount = children.size();
                for (int i = 0; i < childCount; ++i) {
                    AccessibilityNodeInfo info;
                    if (outInfos.size() >= 50) {
                        return;
                    }
                    View child = children.get(i);
                    if (!AccessibilityInteractionController.this.isShown(child)) continue;
                    AccessibilityNodeProvider provider = child.getAccessibilityNodeProvider();
                    if (provider == null) {
                        info = child.createAccessibilityNodeInfo();
                        if (info == null) continue;
                        outInfos.add(info);
                        addedChildren.put(child, null);
                        continue;
                    }
                    info = provider.createAccessibilityNodeInfo(-1);
                    if (info == null) continue;
                    outInfos.add(info);
                    addedChildren.put(child, info);
                }
            }
            finally {
                children.clear();
            }
            if (outInfos.size() < 50) {
                for (Map.Entry entry : addedChildren.entrySet()) {
                    View addedChild = (View)entry.getKey();
                    AccessibilityNodeInfo virtualRoot = (AccessibilityNodeInfo)entry.getValue();
                    if (virtualRoot == null) {
                        this.prefetchDescendantsOfRealNode(addedChild, outInfos);
                        continue;
                    }
                    AccessibilityNodeProvider provider = addedChild.getAccessibilityNodeProvider();
                    this.prefetchDescendantsOfVirtualNode(virtualRoot, provider, outInfos);
                }
            }
        }

        private void prefetchPredecessorsOfVirtualNode(AccessibilityNodeInfo root, View providerHost, AccessibilityNodeProvider provider, List<AccessibilityNodeInfo> outInfos) {
            int initialResultSize = outInfos.size();
            long parentNodeId = root.getParentNodeId();
            int accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(parentNodeId);
            while (accessibilityViewId != Integer.MAX_VALUE) {
                if (outInfos.size() >= 50) {
                    return;
                }
                int virtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(parentNodeId);
                if (virtualDescendantId != -1 || accessibilityViewId == providerHost.getAccessibilityViewId()) {
                    AccessibilityNodeInfo parent = provider.createAccessibilityNodeInfo(virtualDescendantId);
                    if (parent == null) {
                        int currentResultSize = outInfos.size();
                        for (int i = currentResultSize - 1; i >= initialResultSize; --i) {
                            outInfos.remove(i);
                        }
                        return;
                    }
                    outInfos.add(parent);
                    parentNodeId = parent.getParentNodeId();
                    accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(parentNodeId);
                    continue;
                }
                this.prefetchPredecessorsOfRealNode(providerHost, outInfos);
                return;
            }
        }

        private void prefetchSiblingsOfVirtualNode(AccessibilityNodeInfo current, View providerHost, AccessibilityNodeProvider provider, List<AccessibilityNodeInfo> outInfos) {
            long parentNodeId = current.getParentNodeId();
            int parentAccessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(parentNodeId);
            int parentVirtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(parentNodeId);
            if (parentVirtualDescendantId != -1 || parentAccessibilityViewId == providerHost.getAccessibilityViewId()) {
                AccessibilityNodeInfo parent = provider.createAccessibilityNodeInfo(parentVirtualDescendantId);
                if (parent != null) {
                    int childCount = parent.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        int childVirtualDescendantId;
                        AccessibilityNodeInfo child;
                        if (outInfos.size() >= 50) {
                            return;
                        }
                        long childNodeId = parent.getChildId(i);
                        if (childNodeId == current.getSourceNodeId() || (child = provider.createAccessibilityNodeInfo(childVirtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(childNodeId))) == null) continue;
                        outInfos.add(child);
                    }
                }
            } else {
                this.prefetchSiblingsOfRealNode(providerHost, outInfos);
            }
        }

        private void prefetchDescendantsOfVirtualNode(AccessibilityNodeInfo root, AccessibilityNodeProvider provider, List<AccessibilityNodeInfo> outInfos) {
            int initialOutInfosSize = outInfos.size();
            int childCount = root.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                if (outInfos.size() >= 50) {
                    return;
                }
                long childNodeId = root.getChildId(i);
                AccessibilityNodeInfo child = provider.createAccessibilityNodeInfo(AccessibilityNodeInfo.getVirtualDescendantId(childNodeId));
                if (child == null) continue;
                outInfos.add(child);
            }
            if (outInfos.size() < 50) {
                int addedChildCount = outInfos.size() - initialOutInfosSize;
                for (int i = 0; i < addedChildCount; ++i) {
                    AccessibilityNodeInfo child = outInfos.get(initialOutInfosSize + i);
                    this.prefetchDescendantsOfVirtualNode(child, provider, outInfos);
                }
            }
        }
    }
}

