/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Log;
import android.view.IWindow;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import com.android.internal.util.IntPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AccessibilityManager {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityManager";
    public static final int STATE_FLAG_ACCESSIBILITY_ENABLED = 1;
    public static final int STATE_FLAG_TOUCH_EXPLORATION_ENABLED = 2;
    public static final int STATE_FLAG_HIGH_TEXT_CONTRAST_ENABLED = 4;
    public static final int DALTONIZER_DISABLED = -1;
    public static final int DALTONIZER_SIMULATE_MONOCHROMACY = 0;
    public static final int DALTONIZER_CORRECT_DEUTERANOMALY = 12;
    public static final int AUTOCLICK_DELAY_DEFAULT = 600;
    public static final String ACTION_CHOOSE_ACCESSIBILITY_BUTTON = "com.android.internal.intent.action.CHOOSE_ACCESSIBILITY_BUTTON";
    static final Object sInstanceSync = new Object();
    private static AccessibilityManager sInstance;
    private final Object mLock = new Object();
    private IAccessibilityManager mService;
    final int mUserId;
    final Handler mHandler;
    final Handler.Callback mCallback;
    boolean mIsEnabled;
    int mRelevantEventTypes = -1;
    boolean mIsTouchExplorationEnabled;
    boolean mIsHighTextContrastEnabled;
    private final ArrayMap<AccessibilityStateChangeListener, Handler> mAccessibilityStateChangeListeners = new ArrayMap();
    private final ArrayMap<TouchExplorationStateChangeListener, Handler> mTouchExplorationStateChangeListeners = new ArrayMap();
    private final ArrayMap<HighTextContrastChangeListener, Handler> mHighTextContrastStateChangeListeners = new ArrayMap();
    private final ArrayMap<AccessibilityServicesStateChangeListener, Handler> mServicesStateChangeListeners = new ArrayMap();
    private final IAccessibilityManagerClient.Stub mClient = new IAccessibilityManagerClient.Stub(){

        @Override
        public void setState(int state) {
            AccessibilityManager.this.mHandler.obtainMessage(1, state, 0).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyServicesStateChanged() {
            ArrayMap listeners;
            Object object = AccessibilityManager.this.mLock;
            synchronized (object) {
                if (AccessibilityManager.this.mServicesStateChangeListeners.isEmpty()) {
                    return;
                }
                listeners = new ArrayMap(AccessibilityManager.this.mServicesStateChangeListeners);
            }
            int numListeners = listeners.size();
            for (int i = 0; i < numListeners; ++i) {
                AccessibilityServicesStateChangeListener listener = (AccessibilityServicesStateChangeListener)AccessibilityManager.this.mServicesStateChangeListeners.keyAt(i);
                ((Handler)AccessibilityManager.this.mServicesStateChangeListeners.valueAt(i)).post(() -> listener.onAccessibilityServicesStateChanged(AccessibilityManager.this));
            }
        }

        @Override
        public void setRelevantEventTypes(int eventTypes) {
            AccessibilityManager.this.mRelevantEventTypes = eventTypes;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityManager getInstance(Context context) {
        Object object = sInstanceSync;
        synchronized (object) {
            if (sInstance == null) {
                int userId = Binder.getCallingUid() == 1000 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS") == 0 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0 ? -2 : UserHandle.myUserId();
                sInstance = new AccessibilityManager(context, null, userId);
            }
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityManager(Context context, IAccessibilityManager service, int userId) {
        this.mCallback = new MyCallback();
        this.mHandler = new Handler(context.getMainLooper(), this.mCallback);
        this.mUserId = userId;
        Object object = this.mLock;
        synchronized (object) {
            this.tryConnectToServiceLocked(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessibilityManager(Handler handler, IAccessibilityManager service, int userId) {
        this.mCallback = new MyCallback();
        this.mHandler = handler;
        this.mUserId = userId;
        Object object = this.mLock;
        synchronized (object) {
            this.tryConnectToServiceLocked(service);
        }
    }

    public IAccessibilityManagerClient getClient() {
        return this.mClient;
    }

    public Handler.Callback getCallback() {
        return this.mCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTouchExplorationEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsTouchExplorationEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHighTextContrastEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsHighTextContrastEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAccessibilityEvent(AccessibilityEvent event) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
            if (!this.mIsEnabled) {
                Looper myLooper = Looper.myLooper();
                if (myLooper == Looper.getMainLooper()) {
                    throw new IllegalStateException("Accessibility off. Did you forget to check that?");
                }
                Log.e(LOG_TAG, "AccessibilityEvent sent with accessibility disabled");
                return;
            }
            if ((event.getEventType() & this.mRelevantEventTypes) == 0) {
                return;
            }
            userId = this.mUserId;
        }
        try {
            event.setEventTime(SystemClock.uptimeMillis());
            long identityToken = Binder.clearCallingIdentity();
            service.sendAccessibilityEvent(event, userId);
            Binder.restoreCallingIdentity(identityToken);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error during sending " + event + " ", re);
        }
        finally {
            event.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
            if (!this.mIsEnabled) {
                Looper myLooper = Looper.myLooper();
                if (myLooper == Looper.getMainLooper()) {
                    throw new IllegalStateException("Accessibility off. Did you forget to check that?");
                }
                Log.e(LOG_TAG, "Interrupt called with accessibility disabled");
                return;
            }
            userId = this.mUserId;
        }
        try {
            service.interrupt(userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while requesting interrupt from all services. ", re);
        }
    }

    @Deprecated
    public List<ServiceInfo> getAccessibilityServiceList() {
        List<AccessibilityServiceInfo> infos = this.getInstalledAccessibilityServiceList();
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        int infoCount = infos.size();
        for (int i = 0; i < infoCount; ++i) {
            AccessibilityServiceInfo info = infos.get(i);
            services.add(info.getResolveInfo().serviceInfo);
        }
        return Collections.unmodifiableList(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList() {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return Collections.emptyList();
            }
            userId = this.mUserId;
        }
        List<AccessibilityServiceInfo> services = null;
        try {
            services = service.getInstalledAccessibilityServiceList(userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", re);
        }
        if (services != null) {
            return Collections.unmodifiableList(services);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackTypeFlags) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return Collections.emptyList();
            }
            userId = this.mUserId;
        }
        List<AccessibilityServiceInfo> services = null;
        try {
            services = service.getEnabledAccessibilityServiceList(feedbackTypeFlags, userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while obtaining the installed AccessibilityServices. ", re);
        }
        if (services != null) {
            return Collections.unmodifiableList(services);
        }
        return Collections.emptyList();
    }

    public boolean addAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
        this.addAccessibilityStateChangeListener(listener, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessibilityStateChangeListener(AccessibilityStateChangeListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessibilityStateChangeListeners.put(listener, handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mAccessibilityStateChangeListeners.indexOfKey(listener);
            this.mAccessibilityStateChangeListeners.remove(listener);
            return index >= 0;
        }
    }

    public boolean addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
        this.addTouchExplorationStateChangeListener(listener, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTouchExplorationStateChangeListeners.put(listener, handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mTouchExplorationStateChangeListeners.indexOfKey(listener);
            this.mTouchExplorationStateChangeListeners.remove(listener);
            return index >= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessibilityServicesStateChangeListener(AccessibilityServicesStateChangeListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mServicesStateChangeListeners.put(listener, handler == null ? this.mHandler : handler);
        }
    }

    public void removeAccessibilityServicesStateChangeListener(AccessibilityServicesStateChangeListener listener) {
        this.mServicesStateChangeListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighTextContrastStateChangeListener(HighTextContrastChangeListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHighTextContrastStateChangeListeners.put(listener, handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHighTextContrastStateChangeListener(HighTextContrastChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHighTextContrastStateChangeListeners.remove(listener);
        }
    }

    public boolean isAccessibilityVolumeStreamActive() {
        List<AccessibilityServiceInfo> serviceInfos = this.getEnabledAccessibilityServiceList(-1);
        for (int i = 0; i < serviceInfos.size(); ++i) {
            if ((serviceInfos.get((int)i).flags & 0x80) == 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendFingerprintGesture(int keyCode) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.sendFingerprintGesture(keyCode);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private void setStateLocked(int stateFlags) {
        boolean enabled = (stateFlags & 1) != 0;
        boolean touchExplorationEnabled = (stateFlags & 2) != 0;
        boolean highTextContrastEnabled = (stateFlags & 4) != 0;
        boolean wasEnabled = this.mIsEnabled;
        boolean wasTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
        boolean wasHighTextContrastEnabled = this.mIsHighTextContrastEnabled;
        this.mIsEnabled = enabled;
        this.mIsTouchExplorationEnabled = touchExplorationEnabled;
        this.mIsHighTextContrastEnabled = highTextContrastEnabled;
        if (wasEnabled != enabled) {
            this.notifyAccessibilityStateChanged();
        }
        if (wasTouchExplorationEnabled != touchExplorationEnabled) {
            this.notifyTouchExplorationStateChanged();
        }
        if (wasHighTextContrastEnabled != highTextContrastEnabled) {
            this.notifyHighTextContrastStateChanged();
        }
    }

    public AccessibilityServiceInfo getInstalledServiceInfoWithComponentName(ComponentName componentName) {
        List<AccessibilityServiceInfo> installedServiceInfos = this.getInstalledAccessibilityServiceList();
        if (installedServiceInfos == null || componentName == null) {
            return null;
        }
        for (int i = 0; i < installedServiceInfos.size(); ++i) {
            if (!componentName.equals(installedServiceInfos.get(i).getComponentName())) continue;
            return installedServiceInfos.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAccessibilityInteractionConnection(IWindow windowToken, IAccessibilityInteractionConnection connection) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return -1;
            }
            userId = this.mUserId;
        }
        try {
            return service.addAccessibilityInteractionConnection(windowToken, connection, userId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while adding an accessibility interaction connection. ", re);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessibilityInteractionConnection(IWindow windowToken) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.removeAccessibilityInteractionConnection(windowToken);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while removing an accessibility interaction connection. ", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAccessibilityShortcut() {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.performAccessibilityShortcut();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error performing accessibility shortcut. ", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAccessibilityButtonClicked() {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.notifyAccessibilityButtonClicked();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while dispatching accessibility button click", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAccessibilityButtonVisibilityChanged(boolean shown) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.notifyAccessibilityButtonVisibilityChanged(shown);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while dispatching accessibility button visibility change", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPictureInPictureActionReplacingConnection(IAccessibilityInteractionConnection connection) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.setPictureInPictureActionReplacingConnection(connection);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error setting picture in picture action replacement", re);
        }
    }

    private IAccessibilityManager getServiceLocked() {
        if (this.mService == null) {
            this.tryConnectToServiceLocked(null);
        }
        return this.mService;
    }

    private void tryConnectToServiceLocked(IAccessibilityManager service) {
        if (service == null) {
            IBinder iBinder = ServiceManager.getService("accessibility");
            if (iBinder == null) {
                return;
            }
            service = IAccessibilityManager.Stub.asInterface(iBinder);
        }
        try {
            long userStateAndRelevantEvents = service.addClient(this.mClient, this.mUserId);
            this.setStateLocked(IntPair.first(userStateAndRelevantEvents));
            this.mRelevantEventTypes = IntPair.second(userStateAndRelevantEvents);
            this.mService = service;
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "AccessibilityManagerService is dead", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAccessibilityStateChanged() {
        ArrayMap<AccessibilityStateChangeListener, Handler> listeners;
        boolean isEnabled;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAccessibilityStateChangeListeners.isEmpty()) {
                return;
            }
            isEnabled = this.mIsEnabled;
            listeners = new ArrayMap<AccessibilityStateChangeListener, Handler>(this.mAccessibilityStateChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            AccessibilityStateChangeListener listener = this.mAccessibilityStateChangeListeners.keyAt(i);
            this.mAccessibilityStateChangeListeners.valueAt(i).post(() -> listener.onAccessibilityStateChanged(isEnabled));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTouchExplorationStateChanged() {
        ArrayMap<TouchExplorationStateChangeListener, Handler> listeners;
        boolean isTouchExplorationEnabled;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTouchExplorationStateChangeListeners.isEmpty()) {
                return;
            }
            isTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
            listeners = new ArrayMap<TouchExplorationStateChangeListener, Handler>(this.mTouchExplorationStateChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            TouchExplorationStateChangeListener listener = this.mTouchExplorationStateChangeListeners.keyAt(i);
            this.mTouchExplorationStateChangeListeners.valueAt(i).post(() -> listener.onTouchExplorationStateChanged(isTouchExplorationEnabled));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyHighTextContrastStateChanged() {
        ArrayMap<HighTextContrastChangeListener, Handler> listeners;
        boolean isHighTextContrastEnabled;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHighTextContrastStateChangeListeners.isEmpty()) {
                return;
            }
            isHighTextContrastEnabled = this.mIsHighTextContrastEnabled;
            listeners = new ArrayMap<HighTextContrastChangeListener, Handler>(this.mHighTextContrastStateChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            HighTextContrastChangeListener listener = this.mHighTextContrastStateChangeListeners.keyAt(i);
            this.mHighTextContrastStateChangeListeners.valueAt(i).post(() -> listener.onHighTextContrastStateChanged(isHighTextContrastEnabled));
        }
    }

    public static boolean isAccessibilityButtonSupported() {
        Resources res = Resources.getSystem();
        return res.getBoolean(17956998);
    }

    private final class MyCallback
    implements Handler.Callback {
        public static final int MSG_SET_STATE = 1;

        private MyCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    int state = message.arg1;
                    Object object = AccessibilityManager.this.mLock;
                    synchronized (object) {
                        AccessibilityManager.this.setStateLocked(state);
                        break;
                    }
                }
            }
            return true;
        }
    }

    public static interface HighTextContrastChangeListener {
        public void onHighTextContrastStateChanged(boolean var1);
    }

    public static interface AccessibilityServicesStateChangeListener {
        public void onAccessibilityServicesStateChanged(AccessibilityManager var1);
    }

    public static interface TouchExplorationStateChangeListener {
        public void onTouchExplorationStateChanged(boolean var1);
    }

    public static interface AccessibilityStateChangeListener {
        public void onAccessibilityStateChanged(boolean var1);
    }
}

