/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Parcelable;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import java.util.ArrayList;
import java.util.List;

public class AccessibilityRecord {
    private static final int UNDEFINED = -1;
    private static final int PROPERTY_CHECKED = 1;
    private static final int PROPERTY_ENABLED = 2;
    private static final int PROPERTY_PASSWORD = 4;
    private static final int PROPERTY_FULL_SCREEN = 128;
    private static final int PROPERTY_SCROLLABLE = 256;
    private static final int PROPERTY_IMPORTANT_FOR_ACCESSIBILITY = 512;
    private static final int GET_SOURCE_PREFETCH_FLAGS = 7;
    private static final int MAX_POOL_SIZE = 10;
    private static final Object sPoolLock = new Object();
    private static AccessibilityRecord sPool;
    private static int sPoolSize;
    private AccessibilityRecord mNext;
    private boolean mIsInPool;
    boolean mSealed;
    int mBooleanProperties = 0;
    int mCurrentItemIndex = -1;
    int mItemCount = -1;
    int mFromIndex = -1;
    int mToIndex = -1;
    int mScrollX = -1;
    int mScrollY = -1;
    int mMaxScrollX = -1;
    int mMaxScrollY = -1;
    int mAddedCount = -1;
    int mRemovedCount = -1;
    AccessibilityNodeInfo mSourceNode;
    int mSourceWindowId = -1;
    CharSequence mClassName;
    CharSequence mContentDescription;
    CharSequence mBeforeText;
    Parcelable mParcelableData;
    final List<CharSequence> mText = new ArrayList<CharSequence>();
    int mConnectionId = -1;

    AccessibilityRecord() {
    }

    public void setSource(View source) {
        this.setSource(source, -1);
    }

    public void setSource(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        boolean important = true;
        this.mSourceWindowId = -1;
        this.clearSourceNode();
        if (root != null) {
            if (virtualDescendantId == -1 || virtualDescendantId == Integer.MAX_VALUE || virtualDescendantId == -1) {
                important = root.isImportantForAccessibility();
                this.mSourceNode = root.createAccessibilityNodeInfo();
            } else {
                AccessibilityNodeProvider provider = root.getAccessibilityNodeProvider();
                if (provider != null) {
                    this.mSourceNode = provider.createAccessibilityNodeInfo(virtualDescendantId);
                }
            }
            this.mSourceWindowId = root.getAccessibilityWindowId();
        }
        this.setBooleanProperty(512, important);
    }

    public void setSource(AccessibilityNodeInfo info) {
        this.enforceNotSealed();
        this.clearSourceNode();
        this.mSourceWindowId = -1;
        if (info != null) {
            this.mSourceNode = AccessibilityNodeInfo.obtain(info);
            this.setBooleanProperty(512, this.mSourceNode.isImportantForAccessibility());
            this.mSourceWindowId = info.getWindowId();
        }
    }

    public AccessibilityNodeInfo getSource() {
        this.enforceSealed();
        if (this.mSourceNode != null) {
            return AccessibilityNodeInfo.obtain(this.mSourceNode);
        }
        return null;
    }

    public void setWindowId(int windowId) {
        this.mSourceWindowId = windowId;
    }

    public int getWindowId() {
        return this.mSourceWindowId;
    }

    public boolean isChecked() {
        return this.getBooleanProperty(1);
    }

    public void setChecked(boolean isChecked) {
        this.enforceNotSealed();
        this.setBooleanProperty(1, isChecked);
    }

    public boolean isEnabled() {
        return this.getBooleanProperty(2);
    }

    public void setEnabled(boolean isEnabled) {
        this.enforceNotSealed();
        this.setBooleanProperty(2, isEnabled);
    }

    public boolean isPassword() {
        return this.getBooleanProperty(4);
    }

    public void setPassword(boolean isPassword) {
        this.enforceNotSealed();
        this.setBooleanProperty(4, isPassword);
    }

    public boolean isFullScreen() {
        return this.getBooleanProperty(128);
    }

    public void setFullScreen(boolean isFullScreen) {
        this.enforceNotSealed();
        this.setBooleanProperty(128, isFullScreen);
    }

    public boolean isScrollable() {
        return this.getBooleanProperty(256);
    }

    public void setScrollable(boolean scrollable) {
        this.enforceNotSealed();
        this.setBooleanProperty(256, scrollable);
    }

    public boolean isImportantForAccessibility() {
        return this.getBooleanProperty(512);
    }

    public int getItemCount() {
        return this.mItemCount;
    }

    public void setItemCount(int itemCount) {
        this.enforceNotSealed();
        this.mItemCount = itemCount;
    }

    public int getCurrentItemIndex() {
        return this.mCurrentItemIndex;
    }

    public void setCurrentItemIndex(int currentItemIndex) {
        this.enforceNotSealed();
        this.mCurrentItemIndex = currentItemIndex;
    }

    public int getFromIndex() {
        return this.mFromIndex;
    }

    public void setFromIndex(int fromIndex) {
        this.enforceNotSealed();
        this.mFromIndex = fromIndex;
    }

    public int getToIndex() {
        return this.mToIndex;
    }

    public void setToIndex(int toIndex) {
        this.enforceNotSealed();
        this.mToIndex = toIndex;
    }

    public int getScrollX() {
        return this.mScrollX;
    }

    public void setScrollX(int scrollX) {
        this.enforceNotSealed();
        this.mScrollX = scrollX;
    }

    public int getScrollY() {
        return this.mScrollY;
    }

    public void setScrollY(int scrollY) {
        this.enforceNotSealed();
        this.mScrollY = scrollY;
    }

    public int getMaxScrollX() {
        return this.mMaxScrollX;
    }

    public void setMaxScrollX(int maxScrollX) {
        this.enforceNotSealed();
        this.mMaxScrollX = maxScrollX;
    }

    public int getMaxScrollY() {
        return this.mMaxScrollY;
    }

    public void setMaxScrollY(int maxScrollY) {
        this.enforceNotSealed();
        this.mMaxScrollY = maxScrollY;
    }

    public int getAddedCount() {
        return this.mAddedCount;
    }

    public void setAddedCount(int addedCount) {
        this.enforceNotSealed();
        this.mAddedCount = addedCount;
    }

    public int getRemovedCount() {
        return this.mRemovedCount;
    }

    public void setRemovedCount(int removedCount) {
        this.enforceNotSealed();
        this.mRemovedCount = removedCount;
    }

    public CharSequence getClassName() {
        return this.mClassName;
    }

    public void setClassName(CharSequence className) {
        this.enforceNotSealed();
        this.mClassName = className;
    }

    public List<CharSequence> getText() {
        return this.mText;
    }

    public CharSequence getBeforeText() {
        return this.mBeforeText;
    }

    public void setBeforeText(CharSequence beforeText) {
        this.enforceNotSealed();
        this.mBeforeText = beforeText == null ? null : beforeText.subSequence(0, beforeText.length());
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public void setContentDescription(CharSequence contentDescription) {
        this.enforceNotSealed();
        this.mContentDescription = contentDescription == null ? null : contentDescription.subSequence(0, contentDescription.length());
    }

    public Parcelable getParcelableData() {
        return this.mParcelableData;
    }

    public void setParcelableData(Parcelable parcelableData) {
        this.enforceNotSealed();
        this.mParcelableData = parcelableData;
    }

    public long getSourceNodeId() {
        return this.mSourceNode != null ? this.mSourceNode.getSourceNodeId() : -1L;
    }

    public void setConnectionId(int connectionId) {
        this.enforceNotSealed();
        this.mConnectionId = connectionId;
        if (this.mSourceNode != null) {
            this.mSourceNode.setConnectionId(this.mConnectionId);
        }
    }

    public void setSealed(boolean sealed) {
        this.mSealed = sealed;
        if (this.mSourceNode != null) {
            this.mSourceNode.setSealed(sealed);
        }
    }

    boolean isSealed() {
        return this.mSealed;
    }

    void enforceSealed() {
        if (!this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a not sealed instance.");
        }
    }

    void enforceNotSealed() {
        if (this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a sealed instance.");
        }
    }

    private boolean getBooleanProperty(int property) {
        return (this.mBooleanProperties & property) == property;
    }

    private void setBooleanProperty(int property, boolean value) {
        this.mBooleanProperties = value ? (this.mBooleanProperties |= property) : (this.mBooleanProperties &= ~property);
    }

    public static AccessibilityRecord obtain(AccessibilityRecord record) {
        AccessibilityRecord clone = AccessibilityRecord.obtain();
        clone.init(record);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityRecord obtain() {
        Object object = sPoolLock;
        synchronized (object) {
            if (sPool != null) {
                AccessibilityRecord record = sPool;
                sPool = AccessibilityRecord.sPool.mNext;
                --sPoolSize;
                record.mNext = null;
                record.mIsInPool = false;
                return record;
            }
            return new AccessibilityRecord();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        if (this.mIsInPool) {
            throw new IllegalStateException("Record already recycled!");
        }
        this.clear();
        Object object = sPoolLock;
        synchronized (object) {
            if (sPoolSize <= 10) {
                this.mNext = sPool;
                sPool = this;
                this.mIsInPool = true;
                ++sPoolSize;
            }
        }
    }

    void init(AccessibilityRecord record) {
        this.mSealed = record.mSealed;
        this.mBooleanProperties = record.mBooleanProperties;
        this.mCurrentItemIndex = record.mCurrentItemIndex;
        this.mItemCount = record.mItemCount;
        this.mFromIndex = record.mFromIndex;
        this.mToIndex = record.mToIndex;
        this.mScrollX = record.mScrollX;
        this.mScrollY = record.mScrollY;
        this.mMaxScrollX = record.mMaxScrollX;
        this.mMaxScrollY = record.mMaxScrollY;
        this.mAddedCount = record.mAddedCount;
        this.mRemovedCount = record.mRemovedCount;
        this.mClassName = record.mClassName;
        this.mContentDescription = record.mContentDescription;
        this.mBeforeText = record.mBeforeText;
        this.mParcelableData = record.mParcelableData;
        this.mText.addAll(record.mText);
        this.mSourceWindowId = record.mSourceWindowId;
        if (record.mSourceNode != null) {
            this.mSourceNode = AccessibilityNodeInfo.obtain(record.mSourceNode);
        }
        this.mConnectionId = record.mConnectionId;
    }

    void clear() {
        this.mSealed = false;
        this.mBooleanProperties = 0;
        this.mCurrentItemIndex = -1;
        this.mItemCount = -1;
        this.mFromIndex = -1;
        this.mToIndex = -1;
        this.mScrollX = -1;
        this.mScrollY = -1;
        this.mMaxScrollX = -1;
        this.mMaxScrollY = -1;
        this.mAddedCount = -1;
        this.mRemovedCount = -1;
        this.mClassName = null;
        this.mContentDescription = null;
        this.mBeforeText = null;
        this.mParcelableData = null;
        this.mText.clear();
        this.clearSourceNode();
        this.mSourceWindowId = -1;
        this.mConnectionId = -1;
    }

    private void clearSourceNode() {
        if (this.mSourceNode != null) {
            this.mSourceNode.recycle();
            this.mSourceNode = null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" [ ClassName: " + this.mClassName);
        builder.append("; Text: " + this.mText);
        builder.append("; ContentDescription: " + this.mContentDescription);
        builder.append("; ItemCount: " + this.mItemCount);
        builder.append("; CurrentItemIndex: " + this.mCurrentItemIndex);
        builder.append("; IsEnabled: " + this.getBooleanProperty(2));
        builder.append("; IsPassword: " + this.getBooleanProperty(4));
        builder.append("; IsChecked: " + this.getBooleanProperty(1));
        builder.append("; IsFullScreen: " + this.getBooleanProperty(128));
        builder.append("; Scrollable: " + this.getBooleanProperty(256));
        builder.append("; BeforeText: " + this.mBeforeText);
        builder.append("; FromIndex: " + this.mFromIndex);
        builder.append("; ToIndex: " + this.mToIndex);
        builder.append("; ScrollX: " + this.mScrollX);
        builder.append("; ScrollY: " + this.mScrollY);
        builder.append("; MaxScrollX: " + this.mMaxScrollX);
        builder.append("; MaxScrollY: " + this.mMaxScrollY);
        builder.append("; AddedCount: " + this.mAddedCount);
        builder.append("; RemovedCount: " + this.mRemovedCount);
        builder.append("; ParcelableData: " + this.mParcelableData);
        builder.append(" ]");
        return builder.toString();
    }
}

