/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

final class LangId {
    private final long mModelPtr;

    LangId(int fd) {
        this.mModelPtr = LangId.nativeNew(fd);
    }

    public ClassificationResult[] findLanguages(String text) {
        return LangId.nativeFindLanguages(this.mModelPtr, text);
    }

    public void close() {
        LangId.nativeClose(this.mModelPtr);
    }

    private static native long nativeNew(int var0);

    private static native ClassificationResult[] nativeFindLanguages(long var0, String var2);

    private static native void nativeClose(long var0);

    static {
        System.loadLibrary("textclassifier");
    }

    static final class ClassificationResult {
        final String mLanguage;
        final float mScore;

        ClassificationResult(String language, float score) {
            this.mLanguage = language;
            this.mScore = score;
        }
    }
}

