/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.textclassifier.EntityConfidence;
import com.android.internal.util.Preconditions;
import java.util.List;

public final class TextClassification {
    static final TextClassification EMPTY = new Builder().build();
    private final String mText;
    private final Drawable mIcon;
    private final String mLabel;
    private final Intent mIntent;
    private final View.OnClickListener mOnClickListener;
    private final EntityConfidence<String> mEntityConfidence;
    private final List<String> mEntities;
    private int mLogType;

    private TextClassification(String text, Drawable icon, String label, Intent intent, View.OnClickListener onClickListener, EntityConfidence<String> entityConfidence, int logType) {
        this.mText = text;
        this.mIcon = icon;
        this.mLabel = label;
        this.mIntent = intent;
        this.mOnClickListener = onClickListener;
        this.mEntityConfidence = new EntityConfidence<String>(entityConfidence);
        this.mEntities = this.mEntityConfidence.getEntities();
        this.mLogType = logType;
    }

    public String getText() {
        return this.mText;
    }

    public int getEntityCount() {
        return this.mEntities.size();
    }

    public String getEntity(int index) {
        return this.mEntities.get(index);
    }

    public float getConfidenceScore(String entity) {
        return this.mEntityConfidence.getConfidenceScore(entity);
    }

    public Drawable getIcon() {
        return this.mIcon;
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public View.OnClickListener getOnClickListener() {
        return this.mOnClickListener;
    }

    public int getLogType() {
        return this.mLogType;
    }

    public String toString() {
        return String.format("TextClassification {text=%s, entities=%s, label=%s, intent=%s}", this.mText, this.mEntityConfidence, this.mLabel, this.mIntent);
    }

    public static View.OnClickListener createStartActivityOnClickListener(Context context, Intent intent) {
        Preconditions.checkArgument(context != null);
        Preconditions.checkArgument(intent != null);
        return v -> context.startActivity(intent);
    }

    public static final class Builder {
        private String mText;
        private Drawable mIcon;
        private String mLabel;
        private Intent mIntent;
        private View.OnClickListener mOnClickListener;
        private final EntityConfidence<String> mEntityConfidence = new EntityConfidence();
        private int mLogType;

        public Builder setText(String text) {
            this.mText = Preconditions.checkNotNull(text);
            return this;
        }

        public Builder setEntityType(String type, float confidenceScore) {
            this.mEntityConfidence.setEntityType(type, confidenceScore);
            return this;
        }

        public Builder setIcon(Drawable icon) {
            this.mIcon = icon;
            return this;
        }

        public Builder setLabel(String label) {
            this.mLabel = label;
            return this;
        }

        public Builder setIntent(Intent intent) {
            this.mIntent = intent;
            return this;
        }

        public Builder setLogType(int type) {
            this.mLogType = type;
            return this;
        }

        public Builder setOnClickListener(View.OnClickListener onClickListener) {
            this.mOnClickListener = onClickListener;
            return this;
        }

        public TextClassification build() {
            return new TextClassification(this.mText, this.mIcon, this.mLabel, this.mIntent, this.mOnClickListener, this.mEntityConfidence, this.mLogType);
        }
    }
}

