/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.textclassifier.LangId;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierImpl;
import android.view.textclassifier.TextLanguage;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class TextClassificationManager {
    private static final String LOG_TAG = "TextClassificationManager";
    private final Object mTextClassifierLock = new Object();
    private final Object mLangIdLock = new Object();
    private final Context mContext;
    private ParcelFileDescriptor mLangIdFd;
    private TextClassifier mTextClassifier;
    private LangId mLangId;

    public TextClassificationManager(Context context) {
        this.mContext = Preconditions.checkNotNull(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextClassifier getTextClassifier() {
        Object object = this.mTextClassifierLock;
        synchronized (object) {
            if (this.mTextClassifier == null) {
                this.mTextClassifier = new TextClassifierImpl(this.mContext);
            }
            return this.mTextClassifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextClassifier(TextClassifier textClassifier) {
        Object object = this.mTextClassifierLock;
        synchronized (object) {
            this.mTextClassifier = textClassifier;
        }
    }

    public List<TextLanguage> detectLanguages(CharSequence text) {
        Preconditions.checkArgument(text != null);
        try {
            if (text.length() > 0) {
                LangId.ClassificationResult[] results = this.getLanguageDetector().findLanguages(text.toString());
                TextLanguage.Builder tlBuilder = new TextLanguage.Builder(0, text.length());
                int size = results.length;
                for (int i = 0; i < size; ++i) {
                    tlBuilder.setLanguage(new Locale.Builder().setLanguageTag(results[i].mLanguage).build(), results[i].mScore);
                }
                return Collections.unmodifiableList(Arrays.asList(tlBuilder.build()));
            }
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error detecting languages for text. Returning empty result.", t);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LangId getLanguageDetector() throws FileNotFoundException {
        Object object = this.mLangIdLock;
        synchronized (object) {
            if (this.mLangId == null) {
                this.mLangIdFd = ParcelFileDescriptor.open(new File("/etc/textclassifier/textclassifier.langid.model"), 0x10000000);
                this.mLangId = new LangId(this.mLangIdFd.getFd());
            }
            return this.mLangId;
        }
    }
}

