/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.annotation.StringDef;
import android.os.LocaleList;
import android.view.textclassifier.LinksInfo;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextSelection;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface TextClassifier {
    public static final String TYPE_OTHER = "other";
    public static final String TYPE_EMAIL = "email";
    public static final String TYPE_PHONE = "phone";
    public static final String TYPE_ADDRESS = "address";
    public static final String TYPE_URL = "url";
    public static final TextClassifier NO_OP = new TextClassifier(){

        @Override
        public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, LocaleList defaultLocales) {
            return new TextSelection.Builder(selectionStartIndex, selectionEndIndex).build();
        }

        @Override
        public TextClassification classifyText(CharSequence text, int startIndex, int endIndex, LocaleList defaultLocales) {
            return TextClassification.EMPTY;
        }
    };

    public TextSelection suggestSelection(CharSequence var1, int var2, int var3, LocaleList var4);

    public TextClassification classifyText(CharSequence var1, int var2, int var3, LocaleList var4);

    default public LinksInfo getLinks(CharSequence text, int linkMask, LocaleList defaultLocales) {
        return LinksInfo.NO_OP;
    }

    default public void logEvent(String source, String event) {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @StringDef(value={"other", "email", "phone", "address", "url"})
    public static @interface EntityType {
    }
}

