/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.view.textclassifier.EntityConfidence;
import com.android.internal.util.Preconditions;
import java.util.List;
import java.util.Locale;

public final class TextLanguage {
    private final int mStartIndex;
    private final int mEndIndex;
    private final EntityConfidence<Locale> mLanguageConfidence;
    private final List<Locale> mLanguages;

    private TextLanguage(int startIndex, int endIndex, EntityConfidence<Locale> languageConfidence) {
        this.mStartIndex = startIndex;
        this.mEndIndex = endIndex;
        this.mLanguageConfidence = new EntityConfidence<Locale>(languageConfidence);
        this.mLanguages = this.mLanguageConfidence.getEntities();
    }

    public int getStartIndex() {
        return this.mStartIndex;
    }

    public int getEndIndex() {
        return this.mEndIndex;
    }

    public int getLanguageCount() {
        return this.mLanguages.size();
    }

    public Locale getLanguage(int index) {
        return this.mLanguages.get(index);
    }

    public float getConfidenceScore(Locale language) {
        return this.mLanguageConfidence.getConfidenceScore(language);
    }

    public String toString() {
        return String.format("TextLanguage {%d, %d, %s}", this.mStartIndex, this.mEndIndex, this.mLanguageConfidence);
    }

    public static final class Builder {
        private final int mStartIndex;
        private final int mEndIndex;
        private final EntityConfidence<Locale> mLanguageConfidence = new EntityConfidence();

        public Builder(int startIndex, int endIndex) {
            Preconditions.checkArgument(startIndex >= 0);
            Preconditions.checkArgument(endIndex > startIndex);
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
        }

        public Builder setLanguage(Locale locale, float confidenceScore) {
            this.mLanguageConfidence.setEntityType(locale, confidenceScore);
            return this;
        }

        public TextLanguage build() {
            return new TextLanguage(this.mStartIndex, this.mEndIndex, this.mLanguageConfidence);
        }
    }
}

