/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.ActivityThread;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.icu.util.Calendar;
import android.os.Handler;
import android.text.format.DateFormat;
import android.text.format.Time;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import libcore.icu.DateUtilsBridge;

@RemoteViews.RemoteView
public class DateTimeView
extends TextView {
    private static final int SHOW_TIME = 0;
    private static final int SHOW_MONTH_DAY_YEAR = 1;
    Date mTime;
    long mTimeMillis;
    int mLastDisplay = -1;
    java.text.DateFormat mLastFormat;
    private long mUpdateTimeMillis;
    private static final ThreadLocal<ReceiverInfo> sReceiverInfo = new ThreadLocal();
    private String mNowText;
    private boolean mShowRelativeTime;

    public DateTimeView(Context context) {
        this(context, null);
    }

    public DateTimeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DateTimeView, 0, 0);
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 0: {
                    boolean relative = a.getBoolean(i, false);
                    this.setShowRelativeTime(relative);
                }
            }
        }
        a.recycle();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ReceiverInfo ri = sReceiverInfo.get();
        if (ri == null) {
            ri = new ReceiverInfo();
            sReceiverInfo.set(ri);
        }
        ri.addView(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ReceiverInfo ri = sReceiverInfo.get();
        if (ri != null) {
            ri.removeView(this);
        }
    }

    @RemotableViewMethod
    public void setTime(long time) {
        Time t = new Time();
        t.set(time);
        this.mTimeMillis = t.toMillis(false);
        this.mTime = new Date(t.year - 1900, t.month, t.monthDay, t.hour, t.minute, 0);
        this.update();
    }

    @RemotableViewMethod
    public void setShowRelativeTime(boolean showRelativeTime) {
        this.mShowRelativeTime = showRelativeTime;
        this.updateNowText();
        this.update();
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int visibility) {
        boolean gotVisible = visibility != 8 && this.getVisibility() == 8;
        super.setVisibility(visibility);
        if (gotVisible) {
            this.update();
        }
    }

    void update() {
        java.text.DateFormat format;
        if (this.mTime == null || this.getVisibility() == 8) {
            return;
        }
        if (this.mShowRelativeTime) {
            this.updateRelativeTime();
            return;
        }
        Date time = this.mTime;
        Time t = new Time();
        t.set(this.mTimeMillis);
        t.second = 0;
        t.hour -= 12;
        long twelveHoursBefore = t.toMillis(false);
        t.hour += 12;
        long twelveHoursAfter = t.toMillis(false);
        t.hour = 0;
        t.minute = 0;
        long midnightBefore = t.toMillis(false);
        ++t.monthDay;
        long midnightAfter = t.toMillis(false);
        long nowMillis = System.currentTimeMillis();
        t.set(nowMillis);
        t.second = 0;
        nowMillis = t.normalize(false);
        int display = nowMillis >= midnightBefore && nowMillis < midnightAfter || nowMillis >= twelveHoursBefore && nowMillis < twelveHoursAfter ? 0 : 1;
        if (display == this.mLastDisplay && this.mLastFormat != null) {
            format = this.mLastFormat;
        } else {
            switch (display) {
                case 0: {
                    format = this.getTimeFormat();
                    break;
                }
                case 1: {
                    format = java.text.DateFormat.getDateInstance(3);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown display value: " + display);
                }
            }
            this.mLastFormat = format;
        }
        String text = format.format(this.mTime);
        this.setText(text);
        this.mUpdateTimeMillis = display == 0 ? (twelveHoursAfter > midnightAfter ? twelveHoursAfter : midnightAfter) : (this.mTimeMillis < nowMillis ? 0L : (twelveHoursBefore < midnightBefore ? twelveHoursBefore : midnightBefore));
    }

    private void updateRelativeTime() {
        long millisIncrease;
        String result;
        int count;
        boolean past;
        long now = System.currentTimeMillis();
        long duration = Math.abs(now - this.mTimeMillis);
        boolean bl = past = now >= this.mTimeMillis;
        if (duration < 60000L) {
            this.setText(this.mNowText);
            this.mUpdateTimeMillis = this.mTimeMillis + 60000L + 1L;
            return;
        }
        if (duration < 3600000L) {
            count = (int)(duration / 60000L);
            result = String.format(this.getContext().getResources().getQuantityString(past ? 18153484 : 18153485, count), count);
            millisIncrease = 60000L;
        } else if (duration < 86400000L) {
            count = (int)(duration / 3600000L);
            result = String.format(this.getContext().getResources().getQuantityString(past ? 18153480 : 18153481, count), count);
            millisIncrease = 3600000L;
        } else if (duration < 31449600000L) {
            TimeZone timeZone = TimeZone.getDefault();
            count = Math.max(Math.abs(DateTimeView.dayDistance(timeZone, this.mTimeMillis, now)), 1);
            result = String.format(this.getContext().getResources().getQuantityString(past ? 18153476 : 0x1150005, count), count);
            if (past || count != 1) {
                this.mUpdateTimeMillis = this.computeNextMidnight(timeZone);
                millisIncrease = -1L;
            } else {
                millisIncrease = 86400000L;
            }
        } else {
            count = (int)(duration / 31449600000L);
            result = String.format(this.getContext().getResources().getQuantityString(past ? 0x1150010 : 0x1150011, count), count);
            millisIncrease = 31449600000L;
        }
        if (millisIncrease != -1L) {
            this.mUpdateTimeMillis = past ? this.mTimeMillis + millisIncrease * (long)(count + 1) + 1L : this.mTimeMillis - millisIncrease * (long)count + 1L;
        }
        this.setText(result);
    }

    private long computeNextMidnight(TimeZone timeZone) {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(DateUtilsBridge.icuTimeZone(timeZone));
        c.add(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    @Override
    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateNowText();
        this.update();
    }

    private void updateNowText() {
        if (!this.mShowRelativeTime) {
            return;
        }
        this.mNowText = this.getContext().getResources().getString(17040331);
    }

    private static int dayDistance(TimeZone timeZone, long startTime, long endTime) {
        return Time.getJulianDay(endTime, timeZone.getOffset(endTime) / 1000) - Time.getJulianDay(startTime, timeZone.getOffset(startTime) / 1000);
    }

    private java.text.DateFormat getTimeFormat() {
        return DateFormat.getTimeFormat(this.getContext());
    }

    void clearFormatAndUpdate() {
        this.mLastFormat = null;
        this.update();
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.mShowRelativeTime) {
            String result;
            boolean past;
            long now = System.currentTimeMillis();
            long duration = Math.abs(now - this.mTimeMillis);
            boolean bl = past = now >= this.mTimeMillis;
            if (duration < 60000L) {
                result = this.mNowText;
            } else if (duration < 3600000L) {
                int count = (int)(duration / 60000L);
                result = String.format(this.getContext().getResources().getQuantityString(past ? 18153482 : 18153483, count), count);
            } else if (duration < 86400000L) {
                int count = (int)(duration / 3600000L);
                result = String.format(this.getContext().getResources().getQuantityString(past ? 18153478 : 18153479, count), count);
            } else if (duration < 31449600000L) {
                TimeZone timeZone = TimeZone.getDefault();
                int count = Math.max(Math.abs(DateTimeView.dayDistance(timeZone, this.mTimeMillis, now)), 1);
                result = String.format(this.getContext().getResources().getQuantityString(past ? 18153474 : 18153475, count), count);
            } else {
                int count = (int)(duration / 31449600000L);
                result = String.format(this.getContext().getResources().getQuantityString(past ? 18153486 : 18153487, count), count);
            }
            info.setText(result);
        }
    }

    public static void setReceiverHandler(Handler handler) {
        ReceiverInfo ri = sReceiverInfo.get();
        if (ri == null) {
            ri = new ReceiverInfo();
            sReceiverInfo.set(ri);
        }
        ri.setHandler(handler);
    }

    private static class ReceiverInfo {
        private final ArrayList<DateTimeView> mAttachedViews = new ArrayList();
        private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.TIME_TICK".equals(action) && System.currentTimeMillis() < this.getSoonestUpdateTime()) {
                    return;
                }
                this.updateAll();
            }
        };
        private final ContentObserver mObserver = new ContentObserver(new Handler()){

            @Override
            public void onChange(boolean selfChange) {
                this.updateAll();
            }
        };
        private Handler mHandler = new Handler();

        private ReceiverInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addView(DateTimeView v) {
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                boolean register = this.mAttachedViews.isEmpty();
                this.mAttachedViews.add(v);
                if (register) {
                    this.register(ReceiverInfo.getApplicationContextIfAvailable(v.getContext()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeView(DateTimeView v) {
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                this.mAttachedViews.remove(v);
                if (this.mAttachedViews.isEmpty()) {
                    this.unregister(ReceiverInfo.getApplicationContextIfAvailable(v.getContext()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateAll() {
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                int count = this.mAttachedViews.size();
                for (int i = 0; i < count; ++i) {
                    DateTimeView view = this.mAttachedViews.get(i);
                    view.post(() -> view.clearFormatAndUpdate());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getSoonestUpdateTime() {
            long result = Long.MAX_VALUE;
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                int count = this.mAttachedViews.size();
                for (int i = 0; i < count; ++i) {
                    long time = this.mAttachedViews.get(i).mUpdateTimeMillis;
                    if (time >= result) continue;
                    result = time;
                }
            }
            return result;
        }

        static final Context getApplicationContextIfAvailable(Context context) {
            Context ac = context.getApplicationContext();
            return ac != null ? ac : ActivityThread.currentApplication().getApplicationContext();
        }

        void register(Context context) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            context.registerReceiver(this.mReceiver, filter, null, this.mHandler);
        }

        void unregister(Context context) {
            context.unregisterReceiver(this.mReceiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setHandler(Handler handler) {
            this.mHandler = handler;
            ArrayList<DateTimeView> arrayList = this.mAttachedViews;
            synchronized (arrayList) {
                if (!this.mAttachedViews.isEmpty()) {
                    this.unregister(this.mAttachedViews.get(0).getContext());
                    this.register(this.mAttachedViews.get(0).getContext());
                }
            }
        }
    }
}

