/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.os.AsyncTask;
import android.os.LocaleList;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.view.ActionMode;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextSelection;
import android.widget.Editor;
import android.widget.TextView;
import com.android.internal.util.Preconditions;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class SelectionActionModeHelper {
    private static final int TIMEOUT_DURATION = 200;
    private final Editor mEditor;
    private final TextClassificationHelper mTextClassificationHelper;
    private TextClassification mTextClassification;
    private AsyncTask mTextClassificationAsyncTask;
    private final SelectionTracker mSelectionTracker;

    SelectionActionModeHelper(Editor editor) {
        this.mEditor = Preconditions.checkNotNull(editor);
        TextView textView = this.mEditor.getTextView();
        this.mTextClassificationHelper = new TextClassificationHelper(textView.getTextClassifier(), textView.getText(), 0, 1, textView.getTextLocales());
        this.mSelectionTracker = new SelectionTracker(textView.getTextClassifier());
    }

    public void startActionModeAsync(boolean adjustSelection) {
        this.cancelAsyncTask();
        if (this.isNoOpTextClassifier() || !this.hasSelection()) {
            this.startActionMode(null);
        } else {
            this.resetTextClassificationHelper(true);
            TextView tv = this.mEditor.getTextView();
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(tv, 200, adjustSelection ? this.mTextClassificationHelper::suggestSelection : this.mTextClassificationHelper::classifyText, this::startActionMode).execute(new Void[0]);
        }
    }

    public void invalidateActionModeAsync() {
        this.cancelAsyncTask();
        if (this.isNoOpTextClassifier() || !this.hasSelection()) {
            this.invalidateActionMode(null);
        } else {
            this.resetTextClassificationHelper(false);
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(this.mEditor.getTextView(), 200, this.mTextClassificationHelper::classifyText, this::invalidateActionMode).execute(new Void[0]);
        }
    }

    public void onSelectionAction() {
        this.mSelectionTracker.onSelectionAction(this.mTextClassificationHelper.getSelectionTag());
    }

    public boolean resetSelection(int textIndex) {
        if (this.mSelectionTracker.resetSelection(textIndex, this.mEditor, this.mTextClassificationHelper.getSelectionTag())) {
            this.invalidateActionModeAsync();
            return true;
        }
        return false;
    }

    public TextClassification getTextClassification() {
        return this.mTextClassification;
    }

    public void onDestroyActionMode() {
        this.mSelectionTracker.onSelectionDestroyed();
        this.cancelAsyncTask();
    }

    private void cancelAsyncTask() {
        if (this.mTextClassificationAsyncTask != null) {
            this.mTextClassificationAsyncTask.cancel(true);
            this.mTextClassificationAsyncTask = null;
        }
        this.mTextClassification = null;
    }

    private boolean isNoOpTextClassifier() {
        return this.mEditor.getTextView().getTextClassifier() == TextClassifier.NO_OP;
    }

    private boolean hasSelection() {
        TextView textView = this.mEditor.getTextView();
        return textView.getSelectionEnd() > textView.getSelectionStart();
    }

    private void startActionMode(SelectionResult result) {
        TextView textView = this.mEditor.getTextView();
        CharSequence text = textView.getText();
        this.mSelectionTracker.setOriginalSelection(textView.getSelectionStart(), textView.getSelectionEnd());
        if (result != null && text instanceof Spannable) {
            Selection.setSelection((Spannable)text, result.mStart, result.mEnd);
            this.mTextClassification = result.mClassification;
        } else {
            this.mTextClassification = null;
        }
        if (this.mEditor.startSelectionActionModeInternal()) {
            Editor.SelectionModifierCursorController controller = this.mEditor.getSelectionController();
            if (controller != null) {
                controller.show();
            }
            if (result != null) {
                this.mSelectionTracker.onSelectionStarted(result.mStart, result.mEnd, this.mTextClassificationHelper.getSelectionTag());
            }
        }
        this.mEditor.setRestartActionModeOnNextRefresh(false);
        this.mTextClassificationAsyncTask = null;
    }

    private void invalidateActionMode(SelectionResult result) {
        this.mTextClassification = result != null ? result.mClassification : null;
        ActionMode actionMode = this.mEditor.getTextActionMode();
        if (actionMode != null) {
            actionMode.invalidate();
        }
        TextView textView = this.mEditor.getTextView();
        this.mSelectionTracker.onSelectionUpdated(textView.getSelectionStart(), textView.getSelectionEnd(), this.mTextClassificationHelper.getSelectionTag());
        this.mTextClassificationAsyncTask = null;
    }

    private void resetTextClassificationHelper(boolean resetSelectionTag) {
        TextView textView = this.mEditor.getTextView();
        this.mTextClassificationHelper.reset(textView.getTextClassifier(), textView.getText(), textView.getSelectionStart(), textView.getSelectionEnd(), resetSelectionTag, textView.getTextLocales());
    }

    private static final class SelectionResult {
        private final int mStart;
        private final int mEnd;
        private final TextClassification mClassification;

        SelectionResult(int start, int end, TextClassification classification) {
            this.mStart = start;
            this.mEnd = end;
            this.mClassification = Preconditions.checkNotNull(classification);
        }
    }

    private static final class TextClassificationHelper {
        private static final int TRIM_DELTA = 120;
        private TextClassifier mTextClassifier;
        private String mText;
        private int mSelectionStart;
        private int mSelectionEnd;
        private LocaleList mLocales;
        private String mSelectionTag = "";
        private CharSequence mTrimmedText;
        private int mTrimStart;
        private int mRelativeStart;
        private int mRelativeEnd;
        private CharSequence mLastClassificationText;
        private int mLastClassificationSelectionStart;
        private int mLastClassificationSelectionEnd;
        private LocaleList mLastClassificationLocales;
        private SelectionResult mLastClassificationResult;

        TextClassificationHelper(TextClassifier textClassifier, CharSequence text, int selectionStart, int selectionEnd, LocaleList locales) {
            this.reset(textClassifier, text, selectionStart, selectionEnd, true, locales);
        }

        public void reset(TextClassifier textClassifier, CharSequence text, int selectionStart, int selectionEnd, boolean resetSelectionTag, LocaleList locales) {
            this.mTextClassifier = Preconditions.checkNotNull(textClassifier);
            this.mText = Preconditions.checkNotNull(text).toString();
            this.mLastClassificationText = null;
            Preconditions.checkArgument(selectionEnd > selectionStart);
            this.mSelectionStart = selectionStart;
            this.mSelectionEnd = selectionEnd;
            this.mLocales = locales;
            if (resetSelectionTag) {
                this.mSelectionTag = "";
            }
        }

        public SelectionResult classifyText() {
            if (!Objects.equals(this.mText, this.mLastClassificationText) || this.mSelectionStart != this.mLastClassificationSelectionStart || this.mSelectionEnd != this.mLastClassificationSelectionEnd || !Objects.equals(this.mLocales, this.mLastClassificationLocales)) {
                this.mLastClassificationText = this.mText;
                this.mLastClassificationSelectionStart = this.mSelectionStart;
                this.mLastClassificationSelectionEnd = this.mSelectionEnd;
                this.mLastClassificationLocales = this.mLocales;
                this.trimText();
                this.mLastClassificationResult = new SelectionResult(this.mSelectionStart, this.mSelectionEnd, this.mTextClassifier.classifyText(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd, this.mLocales));
            }
            return this.mLastClassificationResult;
        }

        public SelectionResult suggestSelection() {
            this.trimText();
            TextSelection sel = this.mTextClassifier.suggestSelection(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd, this.mLocales);
            this.mSelectionStart = Math.max(0, sel.getSelectionStartIndex() + this.mTrimStart);
            this.mSelectionEnd = Math.min(this.mText.length(), sel.getSelectionEndIndex() + this.mTrimStart);
            this.mSelectionTag = sel.getSourceClassifier();
            return this.classifyText();
        }

        String getSelectionTag() {
            return this.mSelectionTag;
        }

        private void trimText() {
            this.mTrimStart = Math.max(0, this.mSelectionStart - 120);
            int referenceEnd = Math.min(this.mText.length(), this.mSelectionEnd + 120);
            this.mTrimmedText = this.mText.subSequence(this.mTrimStart, referenceEnd);
            this.mRelativeStart = this.mSelectionStart - this.mTrimStart;
            this.mRelativeEnd = this.mSelectionEnd - this.mTrimStart;
        }
    }

    private static final class TextClassificationAsyncTask
    extends AsyncTask<Void, Void, SelectionResult> {
        private final int mTimeOutDuration;
        private final Supplier<SelectionResult> mSelectionResultSupplier;
        private final Consumer<SelectionResult> mSelectionResultCallback;
        private final TextView mTextView;
        private final String mOriginalText;

        TextClassificationAsyncTask(TextView textView, int timeOut, Supplier<SelectionResult> selectionResultSupplier, Consumer<SelectionResult> selectionResultCallback) {
            super(textView != null ? textView.getHandler() : null);
            this.mTextView = Preconditions.checkNotNull(textView);
            this.mTimeOutDuration = timeOut;
            this.mSelectionResultSupplier = Preconditions.checkNotNull(selectionResultSupplier);
            this.mSelectionResultCallback = Preconditions.checkNotNull(selectionResultCallback);
            this.mOriginalText = this.mTextView.getText().toString();
        }

        protected SelectionResult doInBackground(Void ... params) {
            Runnable onTimeOut = this::onTimeOut;
            this.mTextView.postDelayed(onTimeOut, this.mTimeOutDuration);
            SelectionResult result = this.mSelectionResultSupplier.get();
            this.mTextView.removeCallbacks(onTimeOut);
            return result;
        }

        @Override
        protected void onPostExecute(SelectionResult result) {
            result = TextUtils.equals(this.mOriginalText, this.mTextView.getText()) ? result : null;
            this.mSelectionResultCallback.accept(result);
        }

        private void onTimeOut() {
            if (this.getStatus() == AsyncTask.Status.RUNNING) {
                this.onPostExecute(null);
            }
            this.cancel(true);
        }
    }

    private static final class SelectionTracker {
        private static final String LOG_EVENT_MULTI_SELECTION = "textClassifier_multiSelection";
        private static final String LOG_EVENT_SINGLE_SELECTION = "textClassifier_singleSelection";
        private static final String LOG_EVENT_MULTI_SELECTION_ACTION = "textClassifier_multiSelection_action";
        private static final String LOG_EVENT_SINGLE_SELECTION_ACTION = "textClassifier_singleSelection_action";
        private static final String LOG_EVENT_MULTI_SELECTION_RESET = "textClassifier_multiSelection_reset";
        private static final String LOG_EVENT_MULTI_SELECTION_MODIFIED = "textClassifier_multiSelection_modified";
        private static final String LOG_EVENT_SINGLE_SELECTION_MODIFIED = "textClassifier_singleSelection_modified";
        private final TextClassifier mClassifier;
        private int mOriginalStart;
        private int mOriginalEnd;
        private int mSelectionStart;
        private int mSelectionEnd;
        private boolean mMultiSelection;
        private boolean mClassifierSelection;

        SelectionTracker(TextClassifier classifier) {
            this.mClassifier = classifier;
        }

        public void setOriginalSelection(int selectionStart, int selectionEnd) {
            this.mOriginalStart = selectionStart;
            this.mOriginalEnd = selectionEnd;
            this.resetSelectionFlags();
        }

        public void onSelectionStarted(int selectionStart, int selectionEnd, String logTag) {
            this.mClassifierSelection = !logTag.isEmpty();
            this.mSelectionStart = selectionStart;
            this.mSelectionEnd = selectionEnd;
            boolean bl = this.mMultiSelection = this.mSelectionStart != this.mOriginalStart || this.mSelectionEnd != this.mOriginalEnd;
            if (this.mMultiSelection) {
                this.mClassifier.logEvent(logTag, LOG_EVENT_MULTI_SELECTION);
            } else if (this.mClassifierSelection) {
                this.mClassifier.logEvent(logTag, LOG_EVENT_SINGLE_SELECTION);
            }
        }

        public void onSelectionUpdated(int selectionStart, int selectionEnd, String logTag) {
            boolean selectionChanged;
            boolean bl = selectionChanged = selectionStart != this.mSelectionStart || selectionEnd != this.mSelectionEnd;
            if (selectionChanged) {
                if (this.mMultiSelection) {
                    this.mClassifier.logEvent(logTag, LOG_EVENT_MULTI_SELECTION_MODIFIED);
                } else if (this.mClassifierSelection) {
                    this.mClassifier.logEvent(logTag, LOG_EVENT_SINGLE_SELECTION_MODIFIED);
                }
                this.resetSelectionFlags();
            }
        }

        public void onSelectionDestroyed() {
            this.resetSelectionFlags();
        }

        public void onSelectionAction(String logTag) {
            if (this.mMultiSelection) {
                this.mClassifier.logEvent(logTag, LOG_EVENT_MULTI_SELECTION_ACTION);
            } else if (this.mClassifierSelection) {
                this.mClassifier.logEvent(logTag, LOG_EVENT_SINGLE_SELECTION_ACTION);
            }
        }

        public boolean resetSelection(int textIndex, Editor editor, String logTag) {
            CharSequence text = editor.getTextView().getText();
            if (this.mMultiSelection && textIndex >= this.mSelectionStart && textIndex <= this.mSelectionEnd && text instanceof Spannable) {
                this.resetSelectionFlags();
                this.mClassifier.logEvent(logTag, LOG_EVENT_MULTI_SELECTION_RESET);
                return editor.selectCurrentWord();
            }
            return false;
        }

        private void resetSelectionFlags() {
            this.mMultiSelection = false;
            this.mClassifierSelection = false;
        }
    }
}

