/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.ims.ImsServiceProxy;
import android.telephony.ims.ImsServiceProxyCompat;
import com.android.ims.ImsCall;
import com.android.ims.ImsCallProfile;
import com.android.ims.ImsConfig;
import com.android.ims.ImsConfigListener;
import com.android.ims.ImsConnectionStateListener;
import com.android.ims.ImsEcbm;
import com.android.ims.ImsException;
import com.android.ims.ImsMultiEndpoint;
import com.android.ims.ImsReasonInfo;
import com.android.ims.ImsUt;
import com.android.ims.ImsUtInterface;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsConfig;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsRegistrationListener;
import com.android.ims.internal.IImsServiceController;
import com.android.ims.internal.IImsUt;
import com.android.ims.internal.ImsCallSession;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;

public class ImsManager {
    public static final String PROPERTY_DBG_VOLTE_AVAIL_OVERRIDE = "persist.dbg.volte_avail_ovr";
    public static final int PROPERTY_DBG_VOLTE_AVAIL_OVERRIDE_DEFAULT = 0;
    public static final String PROPERTY_DBG_VT_AVAIL_OVERRIDE = "persist.dbg.vt_avail_ovr";
    public static final int PROPERTY_DBG_VT_AVAIL_OVERRIDE_DEFAULT = 0;
    public static final String PROPERTY_DBG_WFC_AVAIL_OVERRIDE = "persist.dbg.wfc_avail_ovr";
    public static final int PROPERTY_DBG_WFC_AVAIL_OVERRIDE_DEFAULT = 0;
    public static final String PROPERTY_DBG_ALLOW_IMS_OFF_OVERRIDE = "persist.dbg.allow_ims_off";
    public static final int PROPERTY_DBG_ALLOW_IMS_OFF_OVERRIDE_DEFAULT = 0;
    private static final String IMS_SERVICE = "ims";
    public static final int INCOMING_CALL_RESULT_CODE = 101;
    public static final String EXTRA_CALL_ID = "android:imsCallID";
    public static final String ACTION_IMS_SERVICE_UP = "com.android.ims.IMS_SERVICE_UP";
    public static final String ACTION_IMS_SERVICE_DOWN = "com.android.ims.IMS_SERVICE_DOWN";
    public static final String ACTION_IMS_REGISTRATION_ERROR = "com.android.ims.REGISTRATION_ERROR";
    public static final String EXTRA_PHONE_ID = "android:phone_id";
    public static final String ACTION_IMS_INCOMING_CALL = "com.android.ims.IMS_INCOMING_CALL";
    public static final String EXTRA_SERVICE_ID = "android:imsServiceId";
    public static final String EXTRA_USSD = "android:ussd";
    public static final String EXTRA_IS_UNKNOWN_CALL = "android:isUnknown";
    private static final String TAG = "ImsManager";
    private static final boolean DBG = true;
    private static HashMap<Integer, ImsManager> sImsManagerInstances = new HashMap();
    private Context mContext;
    private CarrierConfigManager mConfigManager;
    private int mPhoneId;
    private final boolean mConfigDynamicBind;
    private ImsServiceProxyCompat mImsServiceProxy = null;
    private ImsServiceDeathRecipient mDeathRecipient = new ImsServiceDeathRecipient();
    private ImsUt mUt = null;
    private ImsConfig mConfig = null;
    private boolean mConfigUpdated = false;
    private ImsConfigListener mImsConfigListener;
    private ImsEcbm mEcbm = null;
    private ImsMultiEndpoint mMultiEndpoint = null;
    private Set<ImsServiceProxy.INotifyStatusChanged> mStatusCallbacks = new HashSet<ImsServiceProxy.INotifyStatusChanged>();
    private Set<ImsRegistrationListenerProxy> mRegistrationListeners = new HashSet<ImsRegistrationListenerProxy>();
    private static final String VOLTE_PROVISIONED_PROP = "net.lte.ims.volte.provisioned";
    private static final String WFC_PROVISIONED_PROP = "net.lte.ims.wfc.provisioned";
    private static final String VT_PROVISIONED_PROP = "net.lte.ims.vt.provisioned";
    private static final String DATA_ENABLED_PROP = "net.lte.ims.data.enabled";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final int MAX_RECENT_DISCONNECT_REASONS = 16;
    private ConcurrentLinkedDeque<ImsReasonInfo> mRecentDisconnectReasons = new ConcurrentLinkedDeque();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImsManager getInstance(Context context, int phoneId) {
        HashMap<Integer, ImsManager> hashMap = sImsManagerInstances;
        synchronized (hashMap) {
            if (sImsManagerInstances.containsKey(phoneId)) {
                return sImsManagerInstances.get(phoneId);
            }
            ImsManager mgr = new ImsManager(context, phoneId);
            sImsManagerInstances.put(phoneId, mgr);
            return mgr;
        }
    }

    public static boolean isEnhanced4gLteModeSettingEnabledByUser(Context context) {
        if (!ImsManager.getBooleanCarrierConfig(context, "editable_enhanced_4g_lte_bool")) {
            return true;
        }
        int enabled = Settings.Global.getInt(context.getContentResolver(), "volte_vt_enabled", 1);
        return enabled == 1;
    }

    public boolean isEnhanced4gLteModeSettingEnabledByUserForSlot() {
        if (!this.getBooleanCarrierConfigForSlot("editable_enhanced_4g_lte_bool")) {
            return true;
        }
        int enabled = Settings.Global.getInt(this.mContext.getContentResolver(), "volte_vt_enabled", 1);
        return enabled == 1;
    }

    public static void setEnhanced4gLteModeSetting(Context context, boolean enabled) {
        ImsManager imsManager;
        int value = enabled ? 1 : 0;
        Settings.Global.putInt(context.getContentResolver(), "volte_vt_enabled", value);
        if (ImsManager.isNonTtyOrTtyOnVolteEnabled(context) && (imsManager = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId())) != null) {
            try {
                imsManager.setAdvanced4GMode(enabled);
            }
            catch (ImsException imsException) {
                // empty catch block
            }
        }
    }

    public void setEnhanced4gLteModeSettingForSlot(boolean enabled) {
        int value = this.getBooleanCarrierConfigForSlot("editable_enhanced_4g_lte_bool") ? (enabled ? 1 : 0) : 1;
        try {
            int prevSetting = Settings.Global.getInt(this.mContext.getContentResolver(), "volte_vt_enabled");
            if (prevSetting == value) {
                return;
            }
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        Settings.Global.putInt(this.mContext.getContentResolver(), "volte_vt_enabled", value);
        if (this.isNonTtyOrTtyOnVolteEnabledForSlot()) {
            try {
                this.setAdvanced4GMode(enabled);
            }
            catch (ImsException imsException) {
                // empty catch block
            }
        }
    }

    public static boolean isNonTtyOrTtyOnVolteEnabled(Context context) {
        if (ImsManager.getBooleanCarrierConfig(context, "carrier_volte_tty_supported_bool")) {
            return true;
        }
        return Settings.Secure.getInt(context.getContentResolver(), "preferred_tty_mode", 0) == 0;
    }

    public boolean isNonTtyOrTtyOnVolteEnabledForSlot() {
        if (this.getBooleanCarrierConfigForSlot("carrier_volte_tty_supported_bool")) {
            return true;
        }
        return Settings.Secure.getInt(this.mContext.getContentResolver(), "preferred_tty_mode", 0) == 0;
    }

    public static boolean isVolteEnabledByPlatform(Context context) {
        if (SystemProperties.getInt(PROPERTY_DBG_VOLTE_AVAIL_OVERRIDE, 0) == 1) {
            return true;
        }
        return context.getResources().getBoolean(17956920) && ImsManager.getBooleanCarrierConfig(context, "carrier_volte_available_bool") && ImsManager.isGbaValid(context);
    }

    public boolean isVolteEnabledByPlatformForSlot() {
        if (SystemProperties.getInt(PROPERTY_DBG_VOLTE_AVAIL_OVERRIDE, 0) == 1) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956920) && this.getBooleanCarrierConfigForSlot("carrier_volte_available_bool") && this.isGbaValidForSlot();
    }

    public static boolean isVolteProvisionedOnDevice(Context context) {
        ImsManager mgr;
        if (ImsManager.getBooleanCarrierConfig(context, "carrier_volte_provisioning_required_bool") && (mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId())) != null) {
            return mgr.isVolteProvisioned();
        }
        return true;
    }

    public boolean isVolteProvisionedOnDeviceForSlot() {
        if (this.getBooleanCarrierConfigForSlot("carrier_volte_provisioning_required_bool")) {
            return this.isVolteProvisioned();
        }
        return true;
    }

    public static boolean isWfcProvisionedOnDevice(Context context) {
        ImsManager mgr;
        if (ImsManager.getBooleanCarrierConfig(context, "carrier_volte_provisioning_required_bool") && (mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId())) != null) {
            return mgr.isWfcProvisioned();
        }
        return true;
    }

    public boolean isWfcProvisionedOnDeviceForSlot() {
        if (this.getBooleanCarrierConfigForSlot("carrier_volte_provisioning_required_bool")) {
            return this.isWfcProvisioned();
        }
        return true;
    }

    public static boolean isVtProvisionedOnDevice(Context context) {
        ImsManager mgr;
        if (ImsManager.getBooleanCarrierConfig(context, "carrier_volte_provisioning_required_bool") && (mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId())) != null) {
            return mgr.isVtProvisioned();
        }
        return true;
    }

    public boolean isVtProvisionedOnDeviceForSlot() {
        if (this.getBooleanCarrierConfigForSlot("carrier_volte_provisioning_required_bool")) {
            return this.isVtProvisioned();
        }
        return true;
    }

    public static boolean isVtEnabledByPlatform(Context context) {
        if (SystemProperties.getInt(PROPERTY_DBG_VT_AVAIL_OVERRIDE, 0) == 1) {
            return true;
        }
        return context.getResources().getBoolean(17956921) && ImsManager.getBooleanCarrierConfig(context, "carrier_vt_available_bool") && ImsManager.isGbaValid(context);
    }

    public boolean isVtEnabledByPlatformForSlot() {
        if (SystemProperties.getInt(PROPERTY_DBG_VT_AVAIL_OVERRIDE, 0) == 1) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956921) && this.getBooleanCarrierConfigForSlot("carrier_vt_available_bool") && this.isGbaValidForSlot();
    }

    public static boolean isVtEnabledByUser(Context context) {
        int enabled = Settings.Global.getInt(context.getContentResolver(), "vt_ims_enabled", 1);
        return enabled == 1;
    }

    public boolean isVtEnabledByUserForSlot() {
        int enabled = Settings.Global.getInt(this.mContext.getContentResolver(), "vt_ims_enabled", 1);
        return enabled == 1;
    }

    public static void setVtSetting(Context context, boolean enabled) {
        int value = enabled ? 1 : 0;
        Settings.Global.putInt(context.getContentResolver(), "vt_ims_enabled", value);
        ImsManager imsManager = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (imsManager != null) {
            try {
                ImsConfig config = imsManager.getConfigInterface();
                config.setFeatureValue(1, 13, enabled ? 1 : 0, imsManager.mImsConfigListener);
                if (enabled) {
                    ImsManager.log("setVtSetting() : turnOnIms");
                    imsManager.turnOnIms();
                } else if (!(!ImsManager.isTurnOffImsAllowedByPlatform(context) || ImsManager.isVolteEnabledByPlatform(context) && ImsManager.isEnhanced4gLteModeSettingEnabledByUser(context))) {
                    ImsManager.log("setVtSetting() : imsServiceAllowTurnOff -> turnOffIms");
                    imsManager.turnOffIms();
                }
            }
            catch (ImsException e) {
                ImsManager.loge("setVtSetting(): ", e);
            }
        }
    }

    public void setVtSettingForSlot(boolean enabled) {
        int value = enabled ? 1 : 0;
        Settings.Global.putInt(this.mContext.getContentResolver(), "vt_ims_enabled", value);
        try {
            ImsConfig config = this.getConfigInterface();
            config.setFeatureValue(1, 13, enabled ? 1 : 0, this.mImsConfigListener);
            if (enabled) {
                ImsManager.log("setVtSettingForSlot() : turnOnIms");
                this.turnOnIms();
            } else if (!(!this.isVolteEnabledByPlatformForSlot() || this.isVolteEnabledByPlatformForSlot() && this.isEnhanced4gLteModeSettingEnabledByUserForSlot())) {
                ImsManager.log("setVtSettingForSlot() : imsServiceAllowTurnOff -> turnOffIms");
                this.turnOffIms();
            }
        }
        catch (ImsException e) {
            ImsManager.loge("setVtSettingForSlot(): ", e);
        }
    }

    private static boolean isTurnOffImsAllowedByPlatform(Context context) {
        if (SystemProperties.getInt(PROPERTY_DBG_ALLOW_IMS_OFF_OVERRIDE, 0) == 1) {
            return true;
        }
        return ImsManager.getBooleanCarrierConfig(context, "carrier_allow_turnoff_ims_bool");
    }

    private boolean isTurnOffImsAllowedByPlatformForSlot() {
        if (SystemProperties.getInt(PROPERTY_DBG_ALLOW_IMS_OFF_OVERRIDE, 0) == 1) {
            return true;
        }
        return this.getBooleanCarrierConfigForSlot("carrier_allow_turnoff_ims_bool");
    }

    public static boolean isWfcEnabledByUser(Context context) {
        int enabled = Settings.Global.getInt(context.getContentResolver(), "wfc_ims_enabled", ImsManager.getBooleanCarrierConfig(context, "carrier_default_wfc_ims_enabled_bool") ? 1 : 0);
        return enabled == 1;
    }

    public boolean isWfcEnabledByUserForSlot() {
        int enabled = Settings.Global.getInt(this.mContext.getContentResolver(), "wfc_ims_enabled", this.getBooleanCarrierConfigForSlot("carrier_default_wfc_ims_enabled_bool") ? 1 : 0);
        return enabled == 1;
    }

    public static void setWfcSetting(Context context, boolean enabled) {
        int value = enabled ? 1 : 0;
        Settings.Global.putInt(context.getContentResolver(), "wfc_ims_enabled", value);
        ImsManager imsManager = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (imsManager != null) {
            try {
                ImsConfig config = imsManager.getConfigInterface();
                config.setFeatureValue(2, 18, enabled ? 1 : 0, imsManager.mImsConfigListener);
                if (enabled) {
                    ImsManager.log("setWfcSetting() : turnOnIms");
                    imsManager.turnOnIms();
                } else if (!(!ImsManager.isTurnOffImsAllowedByPlatform(context) || ImsManager.isVolteEnabledByPlatform(context) && ImsManager.isEnhanced4gLteModeSettingEnabledByUser(context))) {
                    ImsManager.log("setWfcSetting() : imsServiceAllowTurnOff -> turnOffIms");
                    imsManager.turnOffIms();
                }
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                ImsManager.setWfcModeInternal(context, enabled ? ImsManager.getWfcMode(context, tm.isNetworkRoaming()) : 1);
            }
            catch (ImsException e) {
                ImsManager.loge("setWfcSetting(): ", e);
            }
        }
    }

    public void setWfcSettingForSlot(boolean enabled) {
        int value = enabled ? 1 : 0;
        Settings.Global.putInt(this.mContext.getContentResolver(), "wfc_ims_enabled", value);
        this.setWfcNonPersistentForSlot(enabled, this.getWfcModeForSlot());
    }

    public void setWfcNonPersistentForSlot(boolean enabled, int wfcMode) {
        int imsFeatureValue = enabled ? 1 : 0;
        int imsWfcModeFeatureValue = enabled ? wfcMode : 1;
        try {
            ImsConfig config = this.getConfigInterface();
            config.setFeatureValue(2, 18, imsFeatureValue, this.mImsConfigListener);
            if (enabled) {
                ImsManager.log("setWfcSettingForSlot() : turnOnIms");
                this.turnOnIms();
            } else if (!(!this.isTurnOffImsAllowedByPlatformForSlot() || this.isVolteEnabledByPlatformForSlot() && this.isEnhanced4gLteModeSettingEnabledByUserForSlot())) {
                ImsManager.log("setWfcSettingForSlot() : imsServiceAllowTurnOff -> turnOffIms");
                this.turnOffIms();
            }
            this.setWfcModeInternalForSlot(imsWfcModeFeatureValue);
        }
        catch (ImsException e) {
            ImsManager.loge("setWfcSettingForSlot(): ", e);
        }
    }

    public static int getWfcMode(Context context) {
        int setting = Settings.Global.getInt(context.getContentResolver(), "wfc_ims_mode", ImsManager.getIntCarrierConfig(context, "carrier_default_wfc_ims_mode_int"));
        ImsManager.log("getWfcMode - setting=" + setting);
        return setting;
    }

    public int getWfcModeForSlot() {
        int setting = Settings.Global.getInt(this.mContext.getContentResolver(), "wfc_ims_mode", this.getIntCarrierConfigForSlot("carrier_default_wfc_ims_mode_int"));
        ImsManager.log("getWfcMode - setting=" + setting);
        return setting;
    }

    public static void setWfcMode(Context context, int wfcMode) {
        ImsManager.log("setWfcMode - setting=" + wfcMode);
        Settings.Global.putInt(context.getContentResolver(), "wfc_ims_mode", wfcMode);
        ImsManager.setWfcModeInternal(context, wfcMode);
    }

    public void setWfcModeForSlot(int wfcMode) {
        ImsManager.log("setWfcModeForSlot - setting=" + wfcMode);
        Settings.Global.putInt(this.mContext.getContentResolver(), "wfc_ims_mode", wfcMode);
        this.setWfcModeInternalForSlot(wfcMode);
    }

    public static int getWfcMode(Context context, boolean roaming) {
        int setting = 0;
        if (!roaming) {
            setting = Settings.Global.getInt(context.getContentResolver(), "wfc_ims_mode", ImsManager.getIntCarrierConfig(context, "carrier_default_wfc_ims_mode_int"));
            ImsManager.log("getWfcMode - setting=" + setting);
        } else {
            setting = Settings.Global.getInt(context.getContentResolver(), "wfc_ims_roaming_mode", ImsManager.getIntCarrierConfig(context, "carrier_default_wfc_ims_roaming_mode_int"));
            ImsManager.log("getWfcMode (roaming) - setting=" + setting);
        }
        return setting;
    }

    public int getWfcModeForSlot(boolean roaming) {
        int setting = 0;
        if (!roaming) {
            setting = Settings.Global.getInt(this.mContext.getContentResolver(), "wfc_ims_mode", this.getIntCarrierConfigForSlot("carrier_default_wfc_ims_mode_int"));
            ImsManager.log("getWfcModeForSlot - setting=" + setting);
        } else {
            setting = Settings.Global.getInt(this.mContext.getContentResolver(), "wfc_ims_roaming_mode", this.getIntCarrierConfigForSlot("carrier_default_wfc_ims_roaming_mode_int"));
            ImsManager.log("getWfcModeForSlot (roaming) - setting=" + setting);
        }
        return setting;
    }

    public static void setWfcMode(Context context, int wfcMode, boolean roaming) {
        if (!roaming) {
            ImsManager.log("setWfcMode - setting=" + wfcMode);
            Settings.Global.putInt(context.getContentResolver(), "wfc_ims_mode", wfcMode);
        } else {
            ImsManager.log("setWfcMode (roaming) - setting=" + wfcMode);
            Settings.Global.putInt(context.getContentResolver(), "wfc_ims_roaming_mode", wfcMode);
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (roaming == tm.isNetworkRoaming()) {
            ImsManager.setWfcModeInternal(context, wfcMode);
        }
    }

    public void setWfcModeForSlot(int wfcMode, boolean roaming) {
        TelephonyManager tm;
        if (!roaming) {
            ImsManager.log("setWfcModeForSlot - setting=" + wfcMode);
            Settings.Global.putInt(this.mContext.getContentResolver(), "wfc_ims_mode", wfcMode);
        } else {
            ImsManager.log("setWfcModeForSlot (roaming) - setting=" + wfcMode);
            Settings.Global.putInt(this.mContext.getContentResolver(), "wfc_ims_roaming_mode", wfcMode);
        }
        int[] subIds = SubscriptionManager.getSubId(this.mPhoneId);
        int subId = -1;
        if (subIds != null && subIds.length >= 1) {
            subId = subIds[0];
        }
        if (roaming == (tm = (TelephonyManager)this.mContext.getSystemService("phone")).isNetworkRoaming(subId)) {
            this.setWfcModeInternalForSlot(wfcMode);
        }
    }

    private static void setWfcModeInternal(Context context, int wfcMode) {
        final ImsManager imsManager = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (imsManager != null) {
            final int value = wfcMode;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        imsManager.getConfigInterface().setProvisionedValue(27, value);
                    }
                    catch (ImsException imsException) {
                        // empty catch block
                    }
                }
            });
            thread.start();
        }
    }

    private void setWfcModeInternalForSlot(int wfcMode) {
        int value = wfcMode;
        Thread thread = new Thread(() -> {
            try {
                this.getConfigInterface().setProvisionedValue(27, value);
            }
            catch (ImsException imsException) {
                // empty catch block
            }
        });
        thread.start();
    }

    public static boolean isWfcRoamingEnabledByUser(Context context) {
        int enabled = Settings.Global.getInt(context.getContentResolver(), "wfc_ims_roaming_enabled", ImsManager.getBooleanCarrierConfig(context, "carrier_default_wfc_ims_roaming_enabled_bool") ? 1 : 0);
        return enabled == 1;
    }

    public boolean isWfcRoamingEnabledByUserForSlot() {
        int enabled = Settings.Global.getInt(this.mContext.getContentResolver(), "wfc_ims_roaming_enabled", this.getBooleanCarrierConfigForSlot("carrier_default_wfc_ims_roaming_enabled_bool") ? 1 : 0);
        return enabled == 1;
    }

    public static void setWfcRoamingSetting(Context context, boolean enabled) {
        Settings.Global.putInt(context.getContentResolver(), "wfc_ims_roaming_enabled", enabled ? 1 : 0);
        ImsManager imsManager = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        if (imsManager != null) {
            imsManager.setWfcRoamingSettingInternal(enabled);
        }
    }

    public void setWfcRoamingSettingForSlot(boolean enabled) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "wfc_ims_roaming_enabled", enabled ? 1 : 0);
        this.setWfcRoamingSettingInternal(enabled);
    }

    private void setWfcRoamingSettingInternal(boolean enabled) {
        int value = enabled ? 1 : 0;
        Thread thread = new Thread(() -> {
            try {
                this.getConfigInterface().setProvisionedValue(26, value);
            }
            catch (ImsException imsException) {
                // empty catch block
            }
        });
        thread.start();
    }

    public static boolean isWfcEnabledByPlatform(Context context) {
        if (SystemProperties.getInt(PROPERTY_DBG_WFC_AVAIL_OVERRIDE, 0) == 1) {
            return true;
        }
        return context.getResources().getBoolean(17956922) && ImsManager.getBooleanCarrierConfig(context, "carrier_wfc_ims_available_bool") && ImsManager.isGbaValid(context);
    }

    public boolean isWfcEnabledByPlatformForSlot() {
        if (SystemProperties.getInt(PROPERTY_DBG_WFC_AVAIL_OVERRIDE, 0) == 1) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17956922) && this.getBooleanCarrierConfigForSlot("carrier_wfc_ims_available_bool") && this.isGbaValidForSlot();
    }

    private static boolean isGbaValid(Context context) {
        if (ImsManager.getBooleanCarrierConfig(context, "carrier_ims_gba_required_bool")) {
            TelephonyManager telephonyManager = TelephonyManager.getDefault();
            String efIst = telephonyManager.getIsimIst();
            if (efIst == null) {
                ImsManager.loge("ISF is NULL");
                return true;
            }
            boolean result = efIst != null && efIst.length() > 1 && (2 & (byte)efIst.charAt(1)) != 0;
            ImsManager.log("GBA capable=" + result + ", ISF=" + efIst);
            return result;
        }
        return true;
    }

    private boolean isGbaValidForSlot() {
        if (this.getBooleanCarrierConfigForSlot("carrier_ims_gba_required_bool")) {
            TelephonyManager telephonyManager = TelephonyManager.getDefault();
            String efIst = telephonyManager.getIsimIst();
            if (efIst == null) {
                ImsManager.loge("isGbaValidForSlot - ISF is NULL");
                return true;
            }
            boolean result = efIst != null && efIst.length() > 1 && (2 & (byte)efIst.charAt(1)) != 0;
            ImsManager.log("isGbaValidForSlot - GBA capable=" + result + ", ISF=" + efIst);
            return result;
        }
        return true;
    }

    public static void onProvisionedValueChanged(Context context, int item, String value) {
        Rlog.d(TAG, "onProvisionedValueChanged: item=" + item + " val=" + value);
        ImsManager mgr = ImsManager.getInstance(context, SubscriptionManager.getDefaultVoicePhoneId());
        switch (item) {
            case 10: {
                mgr.setVolteProvisionedProperty(value.equals("1"));
                Rlog.d(TAG, "isVoLteProvisioned = " + mgr.isVolteProvisioned());
                break;
            }
            case 28: {
                mgr.setWfcProvisionedProperty(value.equals("1"));
                Rlog.d(TAG, "isWfcProvisioned = " + mgr.isWfcProvisioned());
                break;
            }
            case 11: {
                mgr.setVtProvisionedProperty(value.equals("1"));
                Rlog.d(TAG, "isVtProvisioned = " + mgr.isVtProvisioned());
            }
        }
    }

    private void updateProvisionedValues() {
        if (this.getBooleanCarrierConfigForSlot("carrier_volte_provisioning_required_bool")) {
            new AsyncUpdateProvisionedValues().execute(new Void[0]);
        }
    }

    public static void updateImsServiceConfig(Context context, int phoneId, boolean force) {
        if (!force && TelephonyManager.getDefault().getSimState() != 5) {
            ImsManager.log("updateImsServiceConfig: SIM not ready");
            return;
        }
        ImsManager imsManager = ImsManager.getInstance(context, phoneId);
        if (imsManager != null && (!imsManager.mConfigUpdated || force)) {
            try {
                imsManager.updateProvisionedValues();
                boolean isImsUsed = imsManager.updateVolteFeatureValue();
                isImsUsed |= imsManager.updateWfcFeatureAndProvisionedValues();
                if ((isImsUsed |= imsManager.updateVideoCallFeatureValue()) || !ImsManager.isTurnOffImsAllowedByPlatform(context)) {
                    ImsManager.log("updateImsServiceConfig: turnOnIms");
                    imsManager.turnOnIms();
                } else {
                    ImsManager.log("updateImsServiceConfig: turnOffIms");
                    imsManager.turnOffIms();
                }
                imsManager.mConfigUpdated = true;
            }
            catch (ImsException e) {
                ImsManager.loge("updateImsServiceConfig: ", e);
                imsManager.mConfigUpdated = false;
            }
        }
    }

    public void updateImsServiceConfigForSlot(boolean force) {
        if (!force && TelephonyManager.getDefault().getSimState() != 5) {
            ImsManager.log("updateImsServiceConfigForSlot: SIM not ready");
            return;
        }
        if (!this.mConfigUpdated || force) {
            try {
                this.updateProvisionedValues();
                boolean isImsUsed = this.updateVolteFeatureValue();
                isImsUsed |= this.updateWfcFeatureAndProvisionedValues();
                if ((isImsUsed |= this.updateVideoCallFeatureValue()) || !this.isTurnOffImsAllowedByPlatformForSlot()) {
                    ImsManager.log("updateImsServiceConfigForSlot: turnOnIms");
                    this.turnOnIms();
                } else {
                    ImsManager.log("updateImsServiceConfigForSlot: turnOffIms");
                    this.turnOffIms();
                }
                this.mConfigUpdated = true;
            }
            catch (ImsException e) {
                ImsManager.loge("updateImsServiceConfigForSlot: ", e);
                this.mConfigUpdated = false;
            }
        }
    }

    private boolean updateVolteFeatureValue() throws ImsException {
        boolean available = this.isVolteEnabledByPlatformForSlot();
        boolean enabled = this.isEnhanced4gLteModeSettingEnabledByUserForSlot();
        boolean isNonTty = this.isNonTtyOrTtyOnVolteEnabledForSlot();
        boolean isFeatureOn = available && enabled && isNonTty;
        ImsManager.log("updateVolteFeatureValue: available = " + available + ", enabled = " + enabled + ", nonTTY = " + isNonTty);
        this.getConfigInterface().setFeatureValue(0, 13, isFeatureOn ? 1 : 0, this.mImsConfigListener);
        return isFeatureOn;
    }

    private boolean updateVideoCallFeatureValue() throws ImsException {
        boolean available = this.isVtEnabledByPlatformForSlot();
        boolean enabled = this.isVtEnabledByUserForSlot();
        boolean isNonTty = this.isNonTtyOrTtyOnVolteEnabledForSlot();
        boolean isDataEnabled = this.isDataEnabled();
        boolean ignoreDataEnabledChanged = ImsManager.getBooleanCarrierConfig(this.mContext, "ignore_data_enabled_changed_for_video_calls");
        boolean isFeatureOn = available && enabled && isNonTty && (ignoreDataEnabledChanged || isDataEnabled);
        ImsManager.log("updateVideoCallFeatureValue: available = " + available + ", enabled = " + enabled + ", nonTTY = " + isNonTty + ", data enabled = " + isDataEnabled);
        this.getConfigInterface().setFeatureValue(1, 13, isFeatureOn ? 1 : 0, this.mImsConfigListener);
        return isFeatureOn;
    }

    private boolean updateWfcFeatureAndProvisionedValues() throws ImsException {
        boolean isNetworkRoaming = TelephonyManager.getDefault().isNetworkRoaming();
        boolean available = this.isWfcEnabledByPlatformForSlot();
        boolean enabled = this.isWfcEnabledByUserForSlot();
        int mode = this.getWfcModeForSlot(isNetworkRoaming);
        boolean roaming = this.isWfcRoamingEnabledByUserForSlot();
        boolean isFeatureOn = available && enabled;
        ImsManager.log("updateWfcFeatureAndProvisionedValues: available = " + available + ", enabled = " + enabled + ", mode = " + mode + ", roaming = " + roaming);
        this.getConfigInterface().setFeatureValue(2, 18, isFeatureOn ? 1 : 0, this.mImsConfigListener);
        if (!isFeatureOn) {
            mode = 1;
            roaming = false;
        }
        ImsManager.setWfcModeInternal(this.mContext, mode);
        this.setWfcRoamingSettingInternal(roaming);
        return isFeatureOn;
    }

    public ImsManager(Context context, int phoneId) {
        this.mContext = context;
        this.mPhoneId = phoneId;
        this.mConfigDynamicBind = this.mContext.getResources().getBoolean(17956935);
        this.mConfigManager = (CarrierConfigManager)context.getSystemService("carrier_config");
        this.createImsService();
    }

    public boolean isDynamicBinding() {
        return this.mConfigDynamicBind;
    }

    public boolean isServiceAvailable() {
        if (this.mImsServiceProxy == null) {
            this.createImsService();
        }
        return this.mImsServiceProxy.isBinderAlive();
    }

    public void setImsConfigListener(ImsConfigListener listener) {
        this.mImsConfigListener = listener;
    }

    public void addNotifyStatusChangedCallbackIfAvailable(ImsServiceProxy.INotifyStatusChanged c) throws ImsException {
        if (!this.mImsServiceProxy.isBinderAlive()) {
            throw new ImsException("Binder is not active!", 106);
        }
        if (c != null) {
            this.mStatusCallbacks.add(c);
        }
    }

    public int open(int serviceClass, PendingIntent incomingCallPendingIntent, ImsConnectionStateListener listener) throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        if (incomingCallPendingIntent == null) {
            throw new NullPointerException("incomingCallPendingIntent can't be null");
        }
        if (listener == null) {
            throw new NullPointerException("listener can't be null");
        }
        int result = 0;
        try {
            result = this.mImsServiceProxy.startSession(incomingCallPendingIntent, this.createRegistrationListenerProxy(serviceClass, listener));
        }
        catch (RemoteException e) {
            throw new ImsException("open()", e, 106);
        }
        if (result <= 0) {
            throw new ImsException("open()", result * -1);
        }
        return result;
    }

    public void addRegistrationListener(int serviceClass, ImsConnectionStateListener listener) throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        if (listener == null) {
            throw new NullPointerException("listener can't be null");
        }
        try {
            ImsRegistrationListenerProxy p = this.createRegistrationListenerProxy(serviceClass, listener);
            this.mRegistrationListeners.add(p);
            this.mImsServiceProxy.addRegistrationListener(p);
        }
        catch (RemoteException e) {
            throw new ImsException("addRegistrationListener()", e, 106);
        }
    }

    public void removeRegistrationListener(ImsConnectionStateListener listener) throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        if (listener == null) {
            throw new NullPointerException("listener can't be null");
        }
        try {
            Optional<ImsRegistrationListenerProxy> optionalProxy = this.mRegistrationListeners.stream().filter(l -> listener.equals(((ImsRegistrationListenerProxy)l).mListener)).findFirst();
            if (optionalProxy.isPresent()) {
                ImsRegistrationListenerProxy p = optionalProxy.get();
                this.mRegistrationListeners.remove(p);
                this.mImsServiceProxy.removeRegistrationListener(p);
            }
        }
        catch (RemoteException e) {
            throw new ImsException("removeRegistrationListener()", e, 106);
        }
    }

    public void close(int sessionId) throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            this.mImsServiceProxy.endSession(sessionId);
        }
        catch (RemoteException e) {
            throw new ImsException("close()", e, 106);
        }
        finally {
            this.mUt = null;
            this.mConfig = null;
            this.mEcbm = null;
            this.mMultiEndpoint = null;
        }
    }

    public ImsUtInterface getSupplementaryServiceConfiguration() throws ImsException {
        if (this.mUt == null || !this.mImsServiceProxy.isBinderAlive()) {
            this.checkAndThrowExceptionIfServiceUnavailable();
            try {
                IImsUt iUt = this.mImsServiceProxy.getUtInterface();
                if (iUt == null) {
                    throw new ImsException("getSupplementaryServiceConfiguration()", 801);
                }
                this.mUt = new ImsUt(iUt);
            }
            catch (RemoteException e) {
                throw new ImsException("getSupplementaryServiceConfiguration()", e, 106);
            }
        }
        return this.mUt;
    }

    public boolean isConnected(int serviceType, int callType) throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            return this.mImsServiceProxy.isConnected(serviceType, callType);
        }
        catch (RemoteException e) {
            throw new ImsException("isServiceConnected()", e, 106);
        }
    }

    public boolean isOpened() throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            return this.mImsServiceProxy.isOpened();
        }
        catch (RemoteException e) {
            throw new ImsException("isOpened()", e, 106);
        }
    }

    public ImsCallProfile createCallProfile(int sessionId, int serviceType, int callType) throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            return this.mImsServiceProxy.createCallProfile(sessionId, serviceType, callType);
        }
        catch (RemoteException e) {
            throw new ImsException("createCallProfile()", e, 106);
        }
    }

    public ImsCall makeCall(int sessionId, ImsCallProfile profile, String[] callees, ImsCall.Listener listener) throws ImsException {
        ImsManager.log("makeCall :: sessionId=" + sessionId + ", profile=" + profile);
        this.checkAndThrowExceptionIfServiceUnavailable();
        ImsCall call = new ImsCall(this.mContext, profile);
        call.setListener(listener);
        ImsCallSession session = this.createCallSession(sessionId, profile);
        if (callees != null && callees.length == 1) {
            call.start(session, callees[0]);
        } else {
            call.start(session, callees);
        }
        return call;
    }

    public ImsCall takeCall(int sessionId, Intent incomingCallIntent, ImsCall.Listener listener) throws ImsException {
        ImsManager.log("takeCall :: sessionId=" + sessionId + ", incomingCall=" + incomingCallIntent);
        this.checkAndThrowExceptionIfServiceUnavailable();
        if (incomingCallIntent == null) {
            throw new ImsException("Can't retrieve session with null intent", 101);
        }
        int incomingServiceId = ImsManager.getImsSessionId(incomingCallIntent);
        if (sessionId != incomingServiceId) {
            throw new ImsException("Service id is mismatched in the incoming call intent", 101);
        }
        String callId = ImsManager.getCallId(incomingCallIntent);
        if (callId == null) {
            throw new ImsException("Call ID missing in the incoming call intent", 101);
        }
        try {
            IImsCallSession session = this.mImsServiceProxy.getPendingCallSession(sessionId, callId);
            if (session == null) {
                throw new ImsException("No pending session for the call", 107);
            }
            ImsCall call = new ImsCall(this.mContext, session.getCallProfile());
            call.attachSession(new ImsCallSession(session));
            call.setListener(listener);
            return call;
        }
        catch (Throwable t) {
            throw new ImsException("takeCall()", t, 0);
        }
    }

    public ImsConfig getConfigInterface() throws ImsException {
        if (this.mConfig == null || !this.mImsServiceProxy.isBinderAlive()) {
            this.checkAndThrowExceptionIfServiceUnavailable();
            try {
                IImsConfig config = this.mImsServiceProxy.getConfigInterface();
                if (config == null) {
                    throw new ImsException("getConfigInterface()", 131);
                }
                this.mConfig = new ImsConfig(config, this.mContext);
            }
            catch (RemoteException e) {
                throw new ImsException("getConfigInterface()", e, 106);
            }
        }
        ImsManager.log("getConfigInterface(), mConfig= " + this.mConfig);
        return this.mConfig;
    }

    public void setUiTTYMode(Context context, int uiTtyMode, Message onComplete) throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            this.mImsServiceProxy.setUiTTYMode(uiTtyMode, onComplete);
        }
        catch (RemoteException e) {
            throw new ImsException("setTTYMode()", e, 106);
        }
        if (!this.getBooleanCarrierConfigForSlot("carrier_volte_tty_supported_bool")) {
            this.setAdvanced4GMode(uiTtyMode == 0 && this.isEnhanced4gLteModeSettingEnabledByUserForSlot());
        }
    }

    private ImsReasonInfo makeACopy(ImsReasonInfo imsReasonInfo) {
        Parcel p = Parcel.obtain();
        imsReasonInfo.writeToParcel(p, 0);
        p.setDataPosition(0);
        ImsReasonInfo clonedReasonInfo = ImsReasonInfo.CREATOR.createFromParcel(p);
        p.recycle();
        return clonedReasonInfo;
    }

    public ArrayList<ImsReasonInfo> getRecentImsDisconnectReasons() {
        ArrayList<ImsReasonInfo> disconnectReasons = new ArrayList<ImsReasonInfo>();
        for (ImsReasonInfo reason : this.mRecentDisconnectReasons) {
            disconnectReasons.add(this.makeACopy(reason));
        }
        return disconnectReasons;
    }

    public int getImsServiceStatus() throws ImsException {
        return this.mImsServiceProxy.getFeatureStatus();
    }

    private static boolean getBooleanCarrierConfig(Context context, String key) {
        CarrierConfigManager configManager = (CarrierConfigManager)context.getSystemService("carrier_config");
        PersistableBundle b = null;
        if (configManager != null) {
            b = configManager.getConfig();
        }
        if (b != null) {
            return b.getBoolean(key);
        }
        return CarrierConfigManager.getDefaultConfig().getBoolean(key);
    }

    private boolean getBooleanCarrierConfigForSlot(String key) {
        int[] subIds = SubscriptionManager.getSubId(this.mPhoneId);
        int subId = -1;
        if (subIds != null && subIds.length >= 1) {
            subId = subIds[0];
        }
        PersistableBundle b = null;
        if (this.mConfigManager != null) {
            b = this.mConfigManager.getConfigForSubId(subId);
        }
        if (b != null) {
            return b.getBoolean(key);
        }
        return CarrierConfigManager.getDefaultConfig().getBoolean(key);
    }

    private static int getIntCarrierConfig(Context context, String key) {
        CarrierConfigManager configManager = (CarrierConfigManager)context.getSystemService("carrier_config");
        PersistableBundle b = null;
        if (configManager != null) {
            b = configManager.getConfig();
        }
        if (b != null) {
            return b.getInt(key);
        }
        return CarrierConfigManager.getDefaultConfig().getInt(key);
    }

    private int getIntCarrierConfigForSlot(String key) {
        int[] subIds = SubscriptionManager.getSubId(this.mPhoneId);
        int subId = -1;
        if (subIds != null && subIds.length >= 1) {
            subId = subIds[0];
        }
        PersistableBundle b = null;
        if (this.mConfigManager != null) {
            b = this.mConfigManager.getConfigForSubId(subId);
        }
        if (b != null) {
            return b.getInt(key);
        }
        return CarrierConfigManager.getDefaultConfig().getInt(key);
    }

    private static String getCallId(Intent incomingCallIntent) {
        if (incomingCallIntent == null) {
            return null;
        }
        return incomingCallIntent.getStringExtra(EXTRA_CALL_ID);
    }

    private static int getImsSessionId(Intent incomingCallIntent) {
        if (incomingCallIntent == null) {
            return -1;
        }
        return incomingCallIntent.getIntExtra(EXTRA_SERVICE_ID, -1);
    }

    private void checkAndThrowExceptionIfServiceUnavailable() throws ImsException {
        if (this.mImsServiceProxy == null || !this.mImsServiceProxy.isBinderAlive()) {
            this.createImsService();
            if (this.mImsServiceProxy == null) {
                throw new ImsException("Service is unavailable", 106);
            }
        }
    }

    private void createImsService() {
        if (!this.mConfigDynamicBind) {
            Rlog.i(TAG, "Creating ImsService using ServiceManager");
            this.mImsServiceProxy = this.getServiceProxyCompat();
        } else {
            Rlog.i(TAG, "Creating ImsService using ImsResolver");
            this.mImsServiceProxy = this.getServiceProxy();
        }
    }

    private ImsServiceProxyCompat getServiceProxyCompat() {
        IBinder binder = ServiceManager.checkService(IMS_SERVICE);
        if (binder != null) {
            try {
                binder.linkToDeath(this.mDeathRecipient, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return new ImsServiceProxyCompat(this.mPhoneId, binder);
    }

    private ImsServiceProxy getServiceProxy() {
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        ImsServiceProxy serviceProxy = new ImsServiceProxy(this.mPhoneId, 1);
        serviceProxy.setStatusCallback(() -> this.mStatusCallbacks.forEach(ImsServiceProxy.INotifyStatusChanged::notifyStatusChanged));
        IImsServiceController b = tm.getImsServiceControllerAndListen(this.mPhoneId, 1, serviceProxy.getListener());
        if (b != null) {
            serviceProxy.setBinder(b.asBinder());
            serviceProxy.getFeatureStatus();
        } else {
            Rlog.w(TAG, "getServiceProxy: b is null! Phone Id: " + this.mPhoneId);
        }
        return serviceProxy;
    }

    private ImsCallSession createCallSession(int serviceId, ImsCallProfile profile) throws ImsException {
        try {
            return new ImsCallSession(this.mImsServiceProxy.createCallSession(serviceId, profile, null));
        }
        catch (RemoteException e) {
            Rlog.w(TAG, "CreateCallSession: Error, remote exception: " + e.getMessage());
            throw new ImsException("createCallSession()", e, 106);
        }
    }

    private ImsRegistrationListenerProxy createRegistrationListenerProxy(int serviceClass, ImsConnectionStateListener listener) {
        ImsRegistrationListenerProxy proxy = new ImsRegistrationListenerProxy(serviceClass, listener);
        return proxy;
    }

    private static void log(String s) {
        Rlog.d(TAG, s);
    }

    private static void loge(String s) {
        Rlog.e(TAG, s);
    }

    private static void loge(String s, Throwable t) {
        Rlog.e(TAG, s, t);
    }

    private void turnOnIms() throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            this.mImsServiceProxy.turnOnIms();
        }
        catch (RemoteException e) {
            throw new ImsException("turnOnIms() ", e, 106);
        }
    }

    private boolean isImsTurnOffAllowed() {
        return this.isTurnOffImsAllowedByPlatformForSlot() && (!this.isWfcEnabledByPlatformForSlot() || !this.isWfcEnabledByUserForSlot());
    }

    private void setLteFeatureValues(boolean turnOn) {
        ImsManager.log("setLteFeatureValues: " + turnOn);
        try {
            ImsConfig config = this.getConfigInterface();
            if (config != null) {
                config.setFeatureValue(0, 13, turnOn ? 1 : 0, this.mImsConfigListener);
                if (this.isVolteEnabledByPlatformForSlot()) {
                    boolean ignoreDataEnabledChanged = ImsManager.getBooleanCarrierConfig(this.mContext, "ignore_data_enabled_changed_for_video_calls");
                    boolean enableViLte = turnOn && this.isVtEnabledByUserForSlot() && (ignoreDataEnabledChanged || this.isDataEnabled());
                    config.setFeatureValue(1, 13, enableViLte ? 1 : 0, this.mImsConfigListener);
                }
            }
        }
        catch (ImsException e) {
            ImsManager.loge("setLteFeatureValues: exception ", e);
        }
    }

    private void setAdvanced4GMode(boolean turnOn) throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        if (turnOn) {
            this.setLteFeatureValues(turnOn);
            ImsManager.log("setAdvanced4GMode: turnOnIms");
            this.turnOnIms();
        } else {
            if (this.isImsTurnOffAllowed()) {
                ImsManager.log("setAdvanced4GMode: turnOffIms");
                this.turnOffIms();
            }
            this.setLteFeatureValues(turnOn);
        }
    }

    private void turnOffIms() throws ImsException {
        this.checkAndThrowExceptionIfServiceUnavailable();
        try {
            this.mImsServiceProxy.turnOffIms();
        }
        catch (RemoteException e) {
            throw new ImsException("turnOffIms() ", e, 106);
        }
    }

    private void addToRecentDisconnectReasons(ImsReasonInfo reason) {
        if (reason == null) {
            return;
        }
        while (this.mRecentDisconnectReasons.size() >= 16) {
            this.mRecentDisconnectReasons.removeFirst();
        }
        this.mRecentDisconnectReasons.addLast(reason);
    }

    public ImsEcbm getEcbmInterface(int serviceId) throws ImsException {
        if (this.mEcbm == null || !this.mImsServiceProxy.isBinderAlive()) {
            this.checkAndThrowExceptionIfServiceUnavailable();
            try {
                IImsEcbm iEcbm = this.mImsServiceProxy.getEcbmInterface();
                if (iEcbm == null) {
                    throw new ImsException("getEcbmInterface()", 901);
                }
                this.mEcbm = new ImsEcbm(iEcbm);
            }
            catch (RemoteException e) {
                throw new ImsException("getEcbmInterface()", e, 106);
            }
        }
        return this.mEcbm;
    }

    public ImsMultiEndpoint getMultiEndpointInterface(int serviceId) throws ImsException {
        if (this.mMultiEndpoint == null || !this.mImsServiceProxy.isBinderAlive()) {
            this.checkAndThrowExceptionIfServiceUnavailable();
            try {
                IImsMultiEndpoint iImsMultiEndpoint = this.mImsServiceProxy.getMultiEndpointInterface();
                if (iImsMultiEndpoint == null) {
                    throw new ImsException("getMultiEndpointInterface()", 902);
                }
                this.mMultiEndpoint = new ImsMultiEndpoint(iImsMultiEndpoint);
            }
            catch (RemoteException e) {
                throw new ImsException("getMultiEndpointInterface()", e, 106);
            }
        }
        return this.mMultiEndpoint;
    }

    public static void factoryReset(Context context) {
        Settings.Global.putInt(context.getContentResolver(), "volte_vt_enabled", 1);
        Settings.Global.putInt(context.getContentResolver(), "wfc_ims_enabled", ImsManager.getBooleanCarrierConfig(context, "carrier_default_wfc_ims_enabled_bool") ? 1 : 0);
        Settings.Global.putInt(context.getContentResolver(), "wfc_ims_mode", ImsManager.getIntCarrierConfig(context, "carrier_default_wfc_ims_mode_int"));
        Settings.Global.putInt(context.getContentResolver(), "wfc_ims_roaming_enabled", ImsManager.getBooleanCarrierConfig(context, "carrier_default_wfc_ims_roaming_enabled_bool") ? 1 : 0);
        Settings.Global.putInt(context.getContentResolver(), "vt_ims_enabled", 1);
        ImsManager.updateImsServiceConfig(context, SubscriptionManager.getDefaultVoicePhoneId(), true);
    }

    public void factoryResetSlot() {
        Settings.Global.putInt(this.mContext.getContentResolver(), "volte_vt_enabled", 1);
        Settings.Global.putInt(this.mContext.getContentResolver(), "wfc_ims_enabled", this.getBooleanCarrierConfigForSlot("carrier_default_wfc_ims_enabled_bool") ? 1 : 0);
        Settings.Global.putInt(this.mContext.getContentResolver(), "wfc_ims_mode", this.getIntCarrierConfigForSlot("carrier_default_wfc_ims_mode_int"));
        Settings.Global.putInt(this.mContext.getContentResolver(), "wfc_ims_roaming_enabled", this.getBooleanCarrierConfigForSlot("carrier_default_wfc_ims_roaming_enabled_bool") ? 1 : 0);
        Settings.Global.putInt(this.mContext.getContentResolver(), "vt_ims_enabled", 1);
        this.updateImsServiceConfigForSlot(true);
    }

    private boolean isDataEnabled() {
        return SystemProperties.getBoolean(DATA_ENABLED_PROP, true);
    }

    public void setDataEnabled(boolean enabled) {
        ImsManager.log("setDataEnabled: " + enabled);
        SystemProperties.set(DATA_ENABLED_PROP, enabled ? TRUE : FALSE);
    }

    private boolean isVolteProvisioned() {
        return SystemProperties.getBoolean(VOLTE_PROVISIONED_PROP, true);
    }

    private void setVolteProvisionedProperty(boolean provisioned) {
        SystemProperties.set(VOLTE_PROVISIONED_PROP, provisioned ? TRUE : FALSE);
    }

    private boolean isWfcProvisioned() {
        return SystemProperties.getBoolean(WFC_PROVISIONED_PROP, true);
    }

    private void setWfcProvisionedProperty(boolean provisioned) {
        SystemProperties.set(WFC_PROVISIONED_PROP, provisioned ? TRUE : FALSE);
    }

    private boolean isVtProvisioned() {
        return SystemProperties.getBoolean(VT_PROVISIONED_PROP, true);
    }

    private void setVtProvisionedProperty(boolean provisioned) {
        SystemProperties.set(VT_PROVISIONED_PROP, provisioned ? TRUE : FALSE);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ImsManager:");
        pw.println("  mPhoneId = " + this.mPhoneId);
        pw.println("  mConfigUpdated = " + this.mConfigUpdated);
        pw.println("  mImsServiceProxy = " + this.mImsServiceProxy);
        pw.println("  mDataEnabled = " + this.isDataEnabled());
        pw.println("  ignoreDataEnabledChanged = " + ImsManager.getBooleanCarrierConfig(this.mContext, "ignore_data_enabled_changed_for_video_calls"));
        pw.println("  isGbaValid = " + this.isGbaValidForSlot());
        pw.println("  isImsTurnOffAllowed = " + this.isImsTurnOffAllowed());
        pw.println("  isNonTtyOrTtyOnVolteEnabled = " + this.isNonTtyOrTtyOnVolteEnabledForSlot());
        pw.println("  isVolteEnabledByPlatform = " + this.isVolteEnabledByPlatformForSlot());
        pw.println("  isVolteProvisionedOnDevice = " + this.isVolteProvisionedOnDeviceForSlot());
        pw.println("  isEnhanced4gLteModeSettingEnabledByUser = " + this.isEnhanced4gLteModeSettingEnabledByUserForSlot());
        pw.println("  isVtEnabledByPlatform = " + this.isVtEnabledByPlatformForSlot());
        pw.println("  isVtEnabledByUser = " + this.isVtEnabledByUserForSlot());
        pw.println("  isWfcEnabledByPlatform = " + this.isWfcEnabledByPlatformForSlot());
        pw.println("  isWfcEnabledByUser = " + this.isWfcEnabledByUserForSlot());
        pw.println("  getWfcMode = " + this.getWfcModeForSlot());
        pw.println("  isWfcRoamingEnabledByUser = " + this.isWfcRoamingEnabledByUserForSlot());
        pw.println("  isVtProvisionedOnDevice = " + this.isVtProvisionedOnDeviceForSlot());
        pw.println("  isWfcProvisionedOnDevice = " + this.isWfcProvisionedOnDeviceForSlot());
        pw.flush();
    }

    private class ImsRegistrationListenerProxy
    extends IImsRegistrationListener.Stub {
        private int mServiceClass;
        private ImsConnectionStateListener mListener;

        public ImsRegistrationListenerProxy(int serviceClass, ImsConnectionStateListener listener) {
            this.mServiceClass = serviceClass;
            this.mListener = listener;
        }

        public boolean isSameProxy(int serviceClass) {
            return this.mServiceClass == serviceClass;
        }

        @Override
        @Deprecated
        public void registrationConnected() {
            ImsManager.log("registrationConnected ::");
            if (this.mListener != null) {
                this.mListener.onImsConnected(0);
            }
        }

        @Override
        @Deprecated
        public void registrationProgressing() {
            ImsManager.log("registrationProgressing ::");
            if (this.mListener != null) {
                this.mListener.onImsProgressing(0);
            }
        }

        @Override
        public void registrationConnectedWithRadioTech(int imsRadioTech) {
            ImsManager.log("registrationConnectedWithRadioTech :: imsRadioTech=" + imsRadioTech);
            if (this.mListener != null) {
                this.mListener.onImsConnected(imsRadioTech);
            }
        }

        @Override
        public void registrationProgressingWithRadioTech(int imsRadioTech) {
            ImsManager.log("registrationProgressingWithRadioTech :: imsRadioTech=" + imsRadioTech);
            if (this.mListener != null) {
                this.mListener.onImsProgressing(imsRadioTech);
            }
        }

        @Override
        public void registrationDisconnected(ImsReasonInfo imsReasonInfo) {
            ImsManager.log("registrationDisconnected :: imsReasonInfo" + imsReasonInfo);
            ImsManager.this.addToRecentDisconnectReasons(imsReasonInfo);
            if (this.mListener != null) {
                this.mListener.onImsDisconnected(imsReasonInfo);
            }
        }

        @Override
        public void registrationResumed() {
            ImsManager.log("registrationResumed ::");
            if (this.mListener != null) {
                this.mListener.onImsResumed();
            }
        }

        @Override
        public void registrationSuspended() {
            ImsManager.log("registrationSuspended ::");
            if (this.mListener != null) {
                this.mListener.onImsSuspended();
            }
        }

        @Override
        public void registrationServiceCapabilityChanged(int serviceClass, int event) {
            ImsManager.log("registrationServiceCapabilityChanged :: serviceClass=" + serviceClass + ", event=" + event);
            if (this.mListener != null) {
                this.mListener.onImsConnected(0);
            }
        }

        @Override
        public void registrationFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) {
            ImsManager.log("registrationFeatureCapabilityChanged :: serviceClass=" + serviceClass);
            if (this.mListener != null) {
                this.mListener.onFeatureCapabilityChanged(serviceClass, enabledFeatures, disabledFeatures);
            }
        }

        @Override
        public void voiceMessageCountUpdate(int count) {
            ImsManager.log("voiceMessageCountUpdate :: count=" + count);
            if (this.mListener != null) {
                this.mListener.onVoiceMessageCountChanged(count);
            }
        }

        @Override
        public void registrationAssociatedUriChanged(Uri[] uris) {
            ImsManager.log("registrationAssociatedUriChanged ::");
            if (this.mListener != null) {
                this.mListener.registrationAssociatedUriChanged(uris);
            }
        }

        @Override
        public void registrationChangeFailed(int targetAccessTech, ImsReasonInfo imsReasonInfo) {
            ImsManager.log("registrationChangeFailed :: targetAccessTech=" + targetAccessTech + ", imsReasonInfo=" + imsReasonInfo);
            if (this.mListener != null) {
                this.mListener.onRegistrationChangeFailed(targetAccessTech, imsReasonInfo);
            }
        }
    }

    private class ImsServiceDeathRecipient
    implements IBinder.DeathRecipient {
        private ImsServiceDeathRecipient() {
        }

        @Override
        public void binderDied() {
            ImsManager.this.mImsServiceProxy = null;
            ImsManager.this.mUt = null;
            ImsManager.this.mConfig = null;
            ImsManager.this.mEcbm = null;
            ImsManager.this.mMultiEndpoint = null;
        }
    }

    private class AsyncUpdateProvisionedValues
    extends AsyncTask<Void, Void, Void> {
        private AsyncUpdateProvisionedValues() {
        }

        protected Void doInBackground(Void ... params) {
            ImsManager.this.setVolteProvisionedProperty(false);
            ImsManager.this.setWfcProvisionedProperty(false);
            ImsManager.this.setVtProvisionedProperty(false);
            try {
                ImsConfig config = ImsManager.this.getConfigInterface();
                if (config != null) {
                    ImsManager.this.setVolteProvisionedProperty(this.getProvisionedBool(config, 10));
                    Rlog.d(ImsManager.TAG, "isVoLteProvisioned = " + ImsManager.this.isVolteProvisioned());
                    ImsManager.this.setWfcProvisionedProperty(this.getProvisionedBool(config, 28));
                    Rlog.d(ImsManager.TAG, "isWfcProvisioned = " + ImsManager.this.isWfcProvisioned());
                    ImsManager.this.setVtProvisionedProperty(this.getProvisionedBool(config, 11));
                    Rlog.d(ImsManager.TAG, "isVtProvisioned = " + ImsManager.this.isVtProvisioned());
                }
            }
            catch (ImsException ie) {
                Rlog.e(ImsManager.TAG, "AsyncUpdateProvisionedValues error: ", ie);
            }
            return null;
        }

        private boolean getProvisionedBool(ImsConfig config, int item) throws ImsException {
            return config.getProvisionedValue(item) == 1;
        }
    }
}

