/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.widget.ResolverDrawerLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccessibilityButtonChooserActivity
extends Activity {
    private static final String MAGNIFICATION_COMPONENT_ID = "com.android.server.accessibility.MagnificationController";
    private AccessibilityButtonTarget mMagnificationTarget = null;
    private List<AccessibilityButtonTarget> mTargets = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        String component;
        super.onCreate(savedInstanceState);
        this.setContentView(17367064);
        ResolverDrawerLayout rdl = (ResolverDrawerLayout)this.findViewById(0x1020200);
        if (rdl != null) {
            rdl.setOnDismissedListener(this::finish);
        }
        if (TextUtils.isEmpty(component = Settings.Secure.getString(this.getContentResolver(), "accessibility_button_target_component"))) {
            TextView prompt = (TextView)this.findViewById(16908649);
            prompt.setVisibility(0);
        }
        this.mMagnificationTarget = new AccessibilityButtonTarget(this, MAGNIFICATION_COMPONENT_ID, 17039420, 17302254);
        this.mTargets = AccessibilityButtonChooserActivity.getServiceAccessibilityButtonTargets(this);
        if (Settings.Secure.getInt(this.getContentResolver(), "accessibility_display_magnification_navbar_enabled", 0) == 1) {
            this.mTargets.add(this.mMagnificationTarget);
        }
        if (this.mTargets.size() < 2) {
            this.finish();
        }
        GridView gridview = (GridView)this.findViewById(16908648);
        gridview.setAdapter(new TargetAdapter());
        gridview.setOnItemClickListener((parent, view, position, id2) -> this.onTargetSelected(this.mTargets.get(position)));
    }

    private static List<AccessibilityButtonTarget> getServiceAccessibilityButtonTargets(Context context) {
        AccessibilityManager ams = (AccessibilityManager)context.getSystemService("accessibility");
        List<AccessibilityServiceInfo> services = ams.getEnabledAccessibilityServiceList(-1);
        if (services == null) {
            return Collections.emptyList();
        }
        ArrayList<AccessibilityButtonTarget> targets = new ArrayList<AccessibilityButtonTarget>(services.size());
        for (AccessibilityServiceInfo info : services) {
            if ((info.flags & 0x100) == 0) continue;
            targets.add(new AccessibilityButtonTarget(context, info));
        }
        return targets;
    }

    private void onTargetSelected(AccessibilityButtonTarget target) {
        Settings.Secure.putString(this.getContentResolver(), "accessibility_button_target_component", target.getId());
        this.finish();
    }

    private static class AccessibilityButtonTarget {
        public String mId;
        public CharSequence mLabel;
        public Drawable mDrawable;

        public AccessibilityButtonTarget(Context context, AccessibilityServiceInfo serviceInfo) {
            this.mId = serviceInfo.getComponentName().flattenToString();
            this.mLabel = serviceInfo.getResolveInfo().loadLabel(context.getPackageManager());
            this.mDrawable = serviceInfo.getResolveInfo().loadIcon(context.getPackageManager());
        }

        public AccessibilityButtonTarget(Context context, String id2, int labelResId, int iconRes) {
            this.mId = id2;
            this.mLabel = context.getText(labelResId);
            this.mDrawable = context.getDrawable(iconRes);
        }

        public String getId() {
            return this.mId;
        }

        public CharSequence getLabel() {
            return this.mLabel;
        }

        public Drawable getDrawable() {
            return this.mDrawable;
        }
    }

    private class TargetAdapter
    extends BaseAdapter {
        private TargetAdapter() {
        }

        @Override
        public int getCount() {
            return AccessibilityButtonChooserActivity.this.mTargets.size();
        }

        @Override
        public Object getItem(int position) {
            return null;
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            LayoutInflater inflater = AccessibilityButtonChooserActivity.this.getLayoutInflater();
            View root = inflater.inflate(0x1090019, parent, false);
            AccessibilityButtonTarget target = (AccessibilityButtonTarget)AccessibilityButtonChooserActivity.this.mTargets.get(position);
            ImageView iconView = (ImageView)root.findViewById(16908650);
            TextView labelView = (TextView)root.findViewById(16908651);
            iconView.setImageDrawable(target.getDrawable());
            labelView.setText(target.getLabel());
            return root;
        }
    }
}

