/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.IntDef;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.util.Slog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import java.util.Locale;

public final class NightDisplayController {
    private static final String TAG = "NightDisplayController";
    private static final boolean DEBUG = false;
    public static final int AUTO_MODE_DISABLED = 0;
    public static final int AUTO_MODE_CUSTOM = 1;
    public static final int AUTO_MODE_TWILIGHT = 2;
    private final Context mContext;
    private final int mUserId;
    private final ContentObserver mContentObserver;
    private Callback mCallback;

    public NightDisplayController(Context context) {
        this(context, ActivityManager.getCurrentUser());
    }

    public NightDisplayController(Context context, int userId) {
        this.mContext = context.getApplicationContext();
        this.mUserId = userId;
        this.mContentObserver = new ContentObserver(new Handler(Looper.getMainLooper())){

            @Override
            public void onChange(boolean selfChange, Uri uri) {
                String setting;
                super.onChange(selfChange, uri);
                String string2 = setting = uri == null ? null : uri.getLastPathSegment();
                if (setting != null) {
                    NightDisplayController.this.onSettingChanged(setting);
                }
            }
        };
    }

    public boolean isActivated() {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_activated", 0, this.mUserId) == 1;
    }

    public boolean setActivated(boolean activated) {
        if (this.isActivated() != activated) {
            Settings.Secure.putLongForUser(this.mContext.getContentResolver(), "night_display_last_activated_time", System.currentTimeMillis(), this.mUserId);
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_activated", activated ? 1 : 0, this.mUserId);
    }

    public Calendar getLastActivatedTime() {
        ContentResolver cr = this.mContext.getContentResolver();
        long lastActivatedTimeMillis = Settings.Secure.getLongForUser(cr, "night_display_last_activated_time", -1L, this.mUserId);
        if (lastActivatedTimeMillis < 0L) {
            return null;
        }
        Calendar lastActivatedTime = Calendar.getInstance();
        lastActivatedTime.setTimeInMillis(lastActivatedTimeMillis);
        return lastActivatedTime;
    }

    public int getAutoMode() {
        int autoMode = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_auto_mode", -1, this.mUserId);
        if (autoMode == -1) {
            autoMode = this.mContext.getResources().getInteger(17694762);
        }
        if (autoMode != 0 && autoMode != 1 && autoMode != 2) {
            Slog.e(TAG, "Invalid autoMode: " + autoMode);
            autoMode = 0;
        }
        return autoMode;
    }

    public boolean setAutoMode(int autoMode) {
        if (autoMode != 0 && autoMode != 1 && autoMode != 2) {
            throw new IllegalArgumentException("Invalid autoMode: " + autoMode);
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_auto_mode", autoMode, this.mUserId);
    }

    public LocalTime getCustomStartTime() {
        int startTimeValue = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_custom_start_time", -1, this.mUserId);
        if (startTimeValue == -1) {
            startTimeValue = this.mContext.getResources().getInteger(17694764);
        }
        return LocalTime.valueOf(startTimeValue);
    }

    public boolean setCustomStartTime(LocalTime startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("startTime cannot be null");
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_custom_start_time", startTime.toMillis(), this.mUserId);
    }

    public LocalTime getCustomEndTime() {
        int endTimeValue = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_custom_end_time", -1, this.mUserId);
        if (endTimeValue == -1) {
            endTimeValue = this.mContext.getResources().getInteger(17694763);
        }
        return LocalTime.valueOf(endTimeValue);
    }

    public boolean setCustomEndTime(LocalTime endTime) {
        if (endTime == null) {
            throw new IllegalArgumentException("endTime cannot be null");
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_custom_end_time", endTime.toMillis(), this.mUserId);
    }

    public int getColorTemperature() {
        int colorTemperature = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_color_temperature", -1, this.mUserId);
        if (colorTemperature == -1) {
            colorTemperature = this.getDefaultColorTemperature();
        }
        int minimumTemperature = this.getMinimumColorTemperature();
        int maximumTemperature = this.getMaximumColorTemperature();
        if (colorTemperature < minimumTemperature) {
            colorTemperature = minimumTemperature;
        } else if (colorTemperature > maximumTemperature) {
            colorTemperature = maximumTemperature;
        }
        return colorTemperature;
    }

    public boolean setColorTemperature(int colorTemperature) {
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_color_temperature", colorTemperature, this.mUserId);
    }

    public int getMinimumColorTemperature() {
        return this.mContext.getResources().getInteger(17694821);
    }

    public int getMaximumColorTemperature() {
        return this.mContext.getResources().getInteger(17694820);
    }

    public int getDefaultColorTemperature() {
        return this.mContext.getResources().getInteger(17694819);
    }

    private void onSettingChanged(String setting) {
        if (this.mCallback != null) {
            switch (setting) {
                case "night_display_activated": {
                    this.mCallback.onActivated(this.isActivated());
                    break;
                }
                case "night_display_auto_mode": {
                    this.mCallback.onAutoModeChanged(this.getAutoMode());
                    break;
                }
                case "night_display_custom_start_time": {
                    this.mCallback.onCustomStartTimeChanged(this.getCustomStartTime());
                    break;
                }
                case "night_display_custom_end_time": {
                    this.mCallback.onCustomEndTimeChanged(this.getCustomEndTime());
                    break;
                }
                case "night_display_color_temperature": {
                    this.mCallback.onColorTemperatureChanged(this.getColorTemperature());
                }
            }
        }
    }

    public void setListener(Callback callback) {
        Callback oldCallback = this.mCallback;
        if (oldCallback != callback) {
            this.mCallback = callback;
            if (callback == null) {
                this.mContext.getContentResolver().unregisterContentObserver(this.mContentObserver);
            } else if (oldCallback == null) {
                ContentResolver cr = this.mContext.getContentResolver();
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_activated"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_auto_mode"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_custom_start_time"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_custom_end_time"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_color_temperature"), false, this.mContentObserver, this.mUserId);
            }
        }
    }

    public static boolean isAvailable(Context context) {
        return context.getResources().getBoolean(17956976);
    }

    public static interface Callback {
        default public void onActivated(boolean activated) {
        }

        default public void onAutoModeChanged(int autoMode) {
        }

        default public void onCustomStartTimeChanged(LocalTime startTime) {
        }

        default public void onCustomEndTimeChanged(LocalTime endTime) {
        }

        default public void onColorTemperatureChanged(int colorTemperature) {
        }
    }

    public static class LocalTime {
        public final int hourOfDay;
        public final int minute;

        public LocalTime(int hourOfDay, int minute) {
            if (hourOfDay < 0 || hourOfDay > 23) {
                throw new IllegalArgumentException("Invalid hourOfDay: " + hourOfDay);
            }
            if (minute < 0 || minute > 59) {
                throw new IllegalArgumentException("Invalid minute: " + minute);
            }
            this.hourOfDay = hourOfDay;
            this.minute = minute;
        }

        public Calendar getDateTimeBefore(Calendar time) {
            Calendar c = Calendar.getInstance();
            c.set(1, time.get(1));
            c.set(6, time.get(6));
            c.set(11, this.hourOfDay);
            c.set(12, this.minute);
            c.set(13, 0);
            c.set(14, 0);
            if (c.after(time)) {
                c.add(5, -1);
            }
            return c;
        }

        public Calendar getDateTimeAfter(Calendar time) {
            Calendar c = Calendar.getInstance();
            c.set(1, time.get(1));
            c.set(6, time.get(6));
            c.set(11, this.hourOfDay);
            c.set(12, this.minute);
            c.set(13, 0);
            c.set(14, 0);
            if (c.before(time)) {
                c.add(5, 1);
            }
            return c;
        }

        private static LocalTime valueOf(int millis) {
            int hourOfDay = millis / 3600000 % 24;
            int minutes = millis / 60000 % 60;
            return new LocalTime(hourOfDay, minutes);
        }

        private int toMillis() {
            return this.hourOfDay * 3600000 + this.minute * 60000;
        }

        public String toString() {
            return String.format(Locale.US, "%02d:%02d", this.hourOfDay, this.minute);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    public static @interface AutoMode {
    }
}

