/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.drawable.RippleDrawable;
import android.os.Bundle;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;

public class PlatLogoActivity
extends Activity {
    public static final boolean REVEAL_THE_NAME = false;
    public static final boolean FINISH = false;
    FrameLayout mLayout;
    int mTapCount;
    int mKeyCount;
    PathInterpolator mInterpolator = new PathInterpolator(0.0f, 0.0f, 0.5f, 1.0f);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mLayout = new FrameLayout(this);
        this.setContentView(this.mLayout);
    }

    @Override
    public void onAttachedToWindow() {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        float dp = dm.density;
        int size = (int)(Math.min((float)Math.min(dm.widthPixels, dm.heightPixels), 600.0f * dp) - 100.0f * dp);
        final ImageView im = new ImageView(this);
        int pad = (int)(40.0f * dp);
        im.setPadding(pad, pad, pad, pad);
        im.setTranslationZ(20.0f);
        im.setScaleX(0.5f);
        im.setScaleY(0.5f);
        im.setAlpha(0.0f);
        im.setBackground(new RippleDrawable(ColorStateList.valueOf(-1), this.getDrawable(17302905), null));
        im.setClickable(true);
        im.setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View v) {
                im.setOnLongClickListener(new View.OnLongClickListener(){

                    @Override
                    public boolean onLongClick(View v) {
                        if (PlatLogoActivity.this.mTapCount < 5) {
                            return false;
                        }
                        ContentResolver cr = PlatLogoActivity.this.getContentResolver();
                        if (Settings.System.getLong(cr, "egg_mode", 0L) == 0L) {
                            try {
                                Settings.System.putLong(cr, "egg_mode", System.currentTimeMillis());
                            }
                            catch (RuntimeException e) {
                                Log.e("PlatLogoActivity", "Can't write settings", e);
                            }
                        }
                        im.post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    PlatLogoActivity.this.startActivity(new Intent("android.intent.action.MAIN").setFlags(0x10808000).addCategory("com.android.internal.category.PLATLOGO"));
                                }
                                catch (ActivityNotFoundException ex) {
                                    Log.e("PlatLogoActivity", "No more eggs.");
                                }
                            }
                        });
                        return true;
                    }
                });
                ++PlatLogoActivity.this.mTapCount;
            }
        });
        im.setFocusable(true);
        im.requestFocus();
        im.setOnKeyListener(new View.OnKeyListener(){

            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode != 4 && event.getAction() == 0) {
                    ++PlatLogoActivity.this.mKeyCount;
                    if (PlatLogoActivity.this.mKeyCount > 2) {
                        if (PlatLogoActivity.this.mTapCount > 5) {
                            im.performLongClick();
                        } else {
                            im.performClick();
                        }
                    }
                    return true;
                }
                return false;
            }
        });
        this.mLayout.addView((View)im, new FrameLayout.LayoutParams(size, size, 17));
        im.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setInterpolator(this.mInterpolator).setDuration(500L).setStartDelay(800L).start();
    }
}

