/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.resolver.IResolverRankerResult;
import android.service.resolver.IResolverRankerService;
import android.service.resolver.ResolverTarget;
import android.util.Log;
import com.android.internal.app.ResolverActivity;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class ResolverComparator
implements Comparator<ResolverActivity.ResolvedComponentInfo> {
    private static final String TAG = "ResolverComparator";
    private static final boolean DEBUG = false;
    private static final int NUM_OF_TOP_ANNOTATIONS_TO_USE = 3;
    private static final long USAGE_STATS_PERIOD = 604800000L;
    private static final long RECENCY_TIME_PERIOD = 43200000L;
    private static final float RECENCY_MULTIPLIER = 2.0f;
    private static final int RESOLVER_RANKER_SERVICE_RESULT = 0;
    private static final int RESOLVER_RANKER_RESULT_TIMEOUT = 1;
    private static final int CONNECTION_COST_TIMEOUT_MILLIS = 200;
    private static final int WATCHDOG_TIMEOUT_MILLIS = 500;
    private final Collator mCollator;
    private final boolean mHttp;
    private final PackageManager mPm;
    private final UsageStatsManager mUsm;
    private final Map<String, UsageStats> mStats;
    private final long mCurrentTime;
    private final long mSinceTime;
    private final LinkedHashMap<ComponentName, ResolverTarget> mTargetsDict = new LinkedHashMap();
    private final String mReferrerPackage;
    private final Object mLock = new Object();
    private ArrayList<ResolverTarget> mTargets;
    private String mContentType;
    private String[] mAnnotations;
    private String mAction;
    private IResolverRankerService mRanker;
    private ResolverRankerServiceConnection mConnection;
    private AfterCompute mAfterCompute;
    private Context mContext;
    private CountDownLatch mConnectSignal;
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    if (!ResolverComparator.this.mHandler.hasMessages(1)) break;
                    if (msg.obj != null) {
                        List receivedTargets = (List)msg.obj;
                        if (receivedTargets != null && ResolverComparator.this.mTargets != null && receivedTargets.size() == ResolverComparator.this.mTargets.size()) {
                            int size = ResolverComparator.this.mTargets.size();
                            for (int i = 0; i < size; ++i) {
                                ((ResolverTarget)ResolverComparator.this.mTargets.get(i)).setSelectProbability(((ResolverTarget)receivedTargets.get(i)).getSelectProbability());
                            }
                        } else {
                            Log.e(ResolverComparator.TAG, "Sizes of sent and received ResolverTargets diff.");
                        }
                    } else {
                        Log.e(ResolverComparator.TAG, "Receiving null prediction results.");
                    }
                    ResolverComparator.this.mHandler.removeMessages(1);
                    ResolverComparator.this.mAfterCompute.afterCompute();
                    break;
                }
                case 1: {
                    ResolverComparator.this.mHandler.removeMessages(0);
                    ResolverComparator.this.mAfterCompute.afterCompute();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    };

    public ResolverComparator(Context context, Intent intent, String referrerPackage, AfterCompute afterCompute) {
        this.mCollator = Collator.getInstance(context.getResources().getConfiguration().locale);
        String scheme = intent.getScheme();
        this.mHttp = "http".equals(scheme) || "https".equals(scheme);
        this.mReferrerPackage = referrerPackage;
        this.mAfterCompute = afterCompute;
        this.mContext = context;
        this.mPm = context.getPackageManager();
        this.mUsm = (UsageStatsManager)context.getSystemService("usagestats");
        this.mCurrentTime = System.currentTimeMillis();
        this.mSinceTime = this.mCurrentTime - 604800000L;
        this.mStats = this.mUsm.queryAndAggregateUsageStats(this.mSinceTime, this.mCurrentTime);
        this.mContentType = intent.getType();
        this.getContentAnnotations(intent);
        this.mAction = intent.getAction();
    }

    public void getContentAnnotations(Intent intent) {
        ArrayList<String> annotations = intent.getStringArrayListExtra("android.intent.extra.CONTENT_ANNOTATIONS");
        if (annotations != null) {
            int size = annotations.size();
            if (size > 3) {
                size = 3;
            }
            this.mAnnotations = new String[size];
            for (int i = 0; i < size; ++i) {
                this.mAnnotations[i] = annotations.get(i);
            }
        }
    }

    public void setCallBack(AfterCompute afterCompute) {
        this.mAfterCompute = afterCompute;
    }

    public void compute(List<ResolverActivity.ResolvedComponentInfo> targets) {
        this.reset();
        long recentSinceTime = this.mCurrentTime - 43200000L;
        float mostRecencyScore = 1.0f;
        float mostTimeSpentScore = 1.0f;
        float mostLaunchScore = 1.0f;
        float mostChooserScore = 1.0f;
        for (ResolverActivity.ResolvedComponentInfo resolvedComponentInfo : targets) {
            ResolverTarget resolverTarget = new ResolverTarget();
            this.mTargetsDict.put(resolvedComponentInfo.name, resolverTarget);
            UsageStats pkStats = this.mStats.get(resolvedComponentInfo.name.getPackageName());
            if (pkStats == null) continue;
            if (!resolvedComponentInfo.name.getPackageName().equals(this.mReferrerPackage) && !ResolverComparator.isPersistentProcess(resolvedComponentInfo)) {
                float recencyScore = Math.max(pkStats.getLastTimeUsed() - recentSinceTime, 0L);
                resolverTarget.setRecencyScore(recencyScore);
                if (recencyScore > mostRecencyScore) {
                    mostRecencyScore = recencyScore;
                }
            }
            float timeSpentScore = pkStats.getTotalTimeInForeground();
            resolverTarget.setTimeSpentScore(timeSpentScore);
            if (timeSpentScore > mostTimeSpentScore) {
                mostTimeSpentScore = timeSpentScore;
            }
            float launchScore = pkStats.mLaunchCount;
            resolverTarget.setLaunchScore(launchScore);
            if (launchScore > mostLaunchScore) {
                mostLaunchScore = launchScore;
            }
            float chooserScore = 0.0f;
            if (pkStats.mChooserCounts != null && this.mAction != null && pkStats.mChooserCounts.get(this.mAction) != null) {
                chooserScore = pkStats.mChooserCounts.get(this.mAction).getOrDefault(this.mContentType, 0).intValue();
                if (this.mAnnotations != null) {
                    int size = this.mAnnotations.length;
                    for (int i = 0; i < size; ++i) {
                        chooserScore += (float)pkStats.mChooserCounts.get(this.mAction).getOrDefault(this.mAnnotations[i], 0).intValue();
                    }
                }
            }
            resolverTarget.setChooserScore(chooserScore);
            if (!(chooserScore > mostChooserScore)) continue;
            mostChooserScore = chooserScore;
        }
        this.mTargets = new ArrayList<ResolverTarget>(this.mTargetsDict.values());
        for (ResolverTarget resolverTarget : this.mTargets) {
            float recency = resolverTarget.getRecencyScore() / mostRecencyScore;
            this.setFeatures(resolverTarget, recency * recency * 2.0f, resolverTarget.getLaunchScore() / mostLaunchScore, resolverTarget.getTimeSpentScore() / mostTimeSpentScore, resolverTarget.getChooserScore() / mostChooserScore);
            this.addDefaultSelectProbability(resolverTarget);
        }
        this.predictSelectProbabilities(this.mTargets);
    }

    @Override
    public int compare(ResolverActivity.ResolvedComponentInfo lhsp, ResolverActivity.ResolvedComponentInfo rhsp) {
        CharSequence sb;
        CharSequence sa;
        boolean rhsSpecific;
        boolean lhsSpecific;
        ResolveInfo lhs = lhsp.getResolveInfoAt(0);
        ResolveInfo rhs = rhsp.getResolveInfoAt(0);
        if (lhs.targetUserId != -2) {
            return rhs.targetUserId != -2 ? 0 : 1;
        }
        if (rhs.targetUserId != -2) {
            return -1;
        }
        if (this.mHttp && (lhsSpecific = ResolverActivity.isSpecificUriMatch(lhs.match)) != (rhsSpecific = ResolverActivity.isSpecificUriMatch(rhs.match))) {
            return lhsSpecific ? -1 : 1;
        }
        boolean lPinned = lhsp.isPinned();
        boolean rPinned = rhsp.isPinned();
        if (lPinned && !rPinned) {
            return -1;
        }
        if (!lPinned && rPinned) {
            return 1;
        }
        if (!lPinned && !rPinned && this.mStats != null) {
            ResolverTarget lhsTarget = this.mTargetsDict.get(new ComponentName(lhs.activityInfo.packageName, lhs.activityInfo.name));
            ResolverTarget rhsTarget = this.mTargetsDict.get(new ComponentName(rhs.activityInfo.packageName, rhs.activityInfo.name));
            int selectProbabilityDiff = Float.compare(rhsTarget.getSelectProbability(), lhsTarget.getSelectProbability());
            if (selectProbabilityDiff != 0) {
                return selectProbabilityDiff > 0 ? 1 : -1;
            }
        }
        if ((sa = lhs.loadLabel(this.mPm)) == null) {
            sa = lhs.activityInfo.name;
        }
        if ((sb = rhs.loadLabel(this.mPm)) == null) {
            sb = rhs.activityInfo.name;
        }
        return this.mCollator.compare(sa.toString().trim(), sb.toString().trim());
    }

    public float getScore(ComponentName name) {
        ResolverTarget target = this.mTargetsDict.get(name);
        if (target != null) {
            return target.getSelectProbability();
        }
        return 0.0f;
    }

    public void updateChooserCounts(String packageName, int userId, String action) {
        if (this.mUsm != null) {
            this.mUsm.reportChooserSelection(packageName, userId, this.mContentType, this.mAnnotations, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModel(ComponentName componentName) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRanker != null) {
                try {
                    int selectedPos = new ArrayList<ComponentName>(this.mTargetsDict.keySet()).indexOf(componentName);
                    if (selectedPos > 0) {
                        this.mRanker.train(this.mTargets, selectedPos);
                    }
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error in Train: " + e);
                }
            }
        }
    }

    public void destroy() {
        this.mHandler.removeMessages(0);
        this.mHandler.removeMessages(1);
        if (this.mConnection != null) {
            this.mContext.unbindService(this.mConnection);
            this.mConnection.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRanker(Context context) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnection != null && this.mRanker != null) {
                return;
            }
        }
        Intent intent = this.resolveRankerService();
        if (intent == null) {
            return;
        }
        this.mConnectSignal = new CountDownLatch(1);
        this.mConnection = new ResolverRankerServiceConnection(this.mConnectSignal);
        context.bindServiceAsUser(intent, this.mConnection, 1, UserHandle.SYSTEM);
    }

    private Intent resolveRankerService() {
        Intent intent = new Intent("android.service.resolver.ResolverRankerService");
        List<ResolveInfo> resolveInfos = this.mPm.queryIntentServices(intent, 0);
        for (ResolveInfo resolveInfo : resolveInfos) {
            ComponentName componentName;
            block5: {
                if (resolveInfo == null || resolveInfo.serviceInfo == null || resolveInfo.serviceInfo.applicationInfo == null) continue;
                componentName = new ComponentName(resolveInfo.serviceInfo.applicationInfo.packageName, resolveInfo.serviceInfo.name);
                try {
                    String perm = this.mPm.getServiceInfo((ComponentName)componentName, (int)0).permission;
                    if (!"android.permission.BIND_RESOLVER_RANKER_SERVICE".equals(perm)) {
                        Log.w(TAG, "ResolverRankerService " + componentName + " does not require" + " permission " + "android.permission.BIND_RESOLVER_RANKER_SERVICE" + " - this service will not be queried for ResolverComparator." + " add android:permission=\"" + "android.permission.BIND_RESOLVER_RANKER_SERVICE" + "\"" + " to the <service> tag for " + componentName + " in the manifest.");
                        continue;
                    }
                    if (0 != this.mPm.checkPermission("android.permission.PROVIDE_RESOLVER_RANKER_SERVICE", resolveInfo.serviceInfo.packageName)) {
                        Log.w(TAG, "ResolverRankerService " + componentName + " does not hold" + " permission " + "android.permission.PROVIDE_RESOLVER_RANKER_SERVICE" + " - this service will not be queried for ResolverComparator.");
                    }
                    break block5;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e(TAG, "Could not look up service " + componentName + "; component name not found");
                }
                continue;
            }
            intent.setComponent(componentName);
            return intent;
        }
        return null;
    }

    private void startWatchDog(int timeOutLimit) {
        if (this.mHandler == null) {
            Log.d(TAG, "Error: Handler is Null; Needs to be initialized.");
        }
        this.mHandler.sendEmptyMessageDelayed(1, timeOutLimit);
    }

    private void reset() {
        this.mTargetsDict.clear();
        this.mTargets = null;
        this.startWatchDog(500);
        this.initRanker(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void predictSelectProbabilities(List<ResolverTarget> targets) {
        if (this.mConnection == null) {
            return;
        }
        try {
            this.mConnectSignal.await(200L, TimeUnit.MILLISECONDS);
            Object object = this.mLock;
            synchronized (object) {
                if (this.mRanker != null) {
                    this.mRanker.predict(targets, this.mConnection.resolverRankerResult);
                    return;
                }
            }
        }
        catch (InterruptedException e) {
            Log.e(TAG, "Error in Wait for Service Connection.");
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in Predict: " + e);
        }
        this.mAfterCompute.afterCompute();
    }

    private void addDefaultSelectProbability(ResolverTarget target) {
        float sum = 2.5543f * target.getLaunchScore() + 2.8412f * target.getTimeSpentScore() + 0.269f * target.getRecencyScore() + 4.2222f * target.getChooserScore();
        target.setSelectProbability((float)(1.0 / (1.0 + Math.exp(1.6568f - sum))));
    }

    private void setFeatures(ResolverTarget target, float recencyScore, float launchScore, float timeSpentScore, float chooserScore) {
        target.setRecencyScore(recencyScore);
        target.setLaunchScore(launchScore);
        target.setTimeSpentScore(timeSpentScore);
        target.setChooserScore(chooserScore);
    }

    static boolean isPersistentProcess(ResolverActivity.ResolvedComponentInfo rci) {
        if (rci != null && rci.getCount() > 0) {
            return (rci.getResolveInfoAt((int)0).activityInfo.applicationInfo.flags & 8) != 0;
        }
        return false;
    }

    private class ResolverRankerServiceConnection
    implements ServiceConnection {
        private final CountDownLatch mConnectSignal;
        public final IResolverRankerResult resolverRankerResult = new IResolverRankerResult.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendResult(List<ResolverTarget> targets) throws RemoteException {
                Object object = ResolverComparator.this.mLock;
                synchronized (object) {
                    Message msg = Message.obtain();
                    msg.what = 0;
                    msg.obj = targets;
                    ResolverComparator.this.mHandler.sendMessage(msg);
                }
            }
        };

        public ResolverRankerServiceConnection(CountDownLatch connectSignal) {
            this.mConnectSignal = connectSignal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = ResolverComparator.this.mLock;
            synchronized (object) {
                ResolverComparator.this.mRanker = IResolverRankerService.Stub.asInterface(service);
                this.mConnectSignal.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = ResolverComparator.this.mLock;
            synchronized (object) {
                this.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Object object = ResolverComparator.this.mLock;
            synchronized (object) {
                ResolverComparator.this.mRanker = null;
            }
        }
    }

    public static interface AfterCompute {
        public void afterCompute();
    }
}

