/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.CancellationSignal;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.provider.DocumentsProvider;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.webkit.MimeTypeMap;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class FileSystemProvider
extends DocumentsProvider {
    private static final String TAG = "FileSystemProvider";
    private static final boolean LOG_INOTIFY = false;
    private String[] mDefaultProjection;
    @GuardedBy(value="mObservers")
    private final ArrayMap<File, DirectoryObserver> mObservers = new ArrayMap();
    private Handler mHandler;

    protected abstract File getFileForDocId(String var1, boolean var2) throws FileNotFoundException;

    protected abstract String getDocIdForFile(File var1) throws FileNotFoundException;

    protected abstract Uri buildNotificationUri(String var1);

    @Override
    public boolean onCreate() {
        throw new UnsupportedOperationException("Subclass should override this and call onCreate(defaultDocumentProjection)");
    }

    protected void onCreate(String[] defaultProjection) {
        this.mHandler = new Handler();
        this.mDefaultProjection = defaultProjection;
    }

    @Override
    public boolean isChildDocument(String parentDocId, String docId) {
        try {
            File parent = this.getFileForDocId(parentDocId).getCanonicalFile();
            File doc = this.getFileForDocId(docId).getCanonicalFile();
            return FileUtils.contains(parent, doc);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to determine if " + docId + " is child of " + parentDocId + ": " + e);
        }
    }

    protected final List<String> findDocumentPath(File parent, File doc) throws FileNotFoundException {
        if (!doc.exists()) {
            throw new FileNotFoundException(doc + " is not found.");
        }
        if (!FileUtils.contains(parent, doc)) {
            throw new FileNotFoundException(doc + " is not found under " + parent);
        }
        LinkedList<String> path = new LinkedList<String>();
        while (doc != null && FileUtils.contains(parent, doc)) {
            path.addFirst(this.getDocIdForFile(doc));
            doc = doc.getParentFile();
        }
        return path;
    }

    @Override
    public String createDocument(String docId, String mimeType, String displayName) throws FileNotFoundException {
        String childId;
        displayName = FileUtils.buildValidFatFilename(displayName);
        File parent = this.getFileForDocId(docId);
        if (!parent.isDirectory()) {
            throw new IllegalArgumentException("Parent document isn't a directory");
        }
        File file = FileUtils.buildUniqueFile(parent, mimeType, displayName);
        if ("vnd.android.document/directory".equals(mimeType)) {
            if (!file.mkdir()) {
                throw new IllegalStateException("Failed to mkdir " + file);
            }
            childId = this.getDocIdForFile(file);
            this.addFolderToMediaStore(this.getFileForDocId(childId, true));
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new IllegalStateException("Failed to touch " + file);
                }
                childId = this.getDocIdForFile(file);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to touch " + file + ": " + e);
            }
        }
        return childId;
    }

    private void addFolderToMediaStore(File visibleFolder) {
        if (visibleFolder != null) {
            assert (visibleFolder.isDirectory());
            ContentResolver resolver = this.getContext().getContentResolver();
            Uri uri = MediaStore.Files.getDirectoryUri("external");
            ContentValues values = new ContentValues();
            values.put("_data", visibleFolder.getAbsolutePath());
            resolver.insert(uri, values);
        }
    }

    @Override
    public String renameDocument(String docId, String displayName) throws FileNotFoundException {
        displayName = FileUtils.buildValidFatFilename(displayName);
        File before = this.getFileForDocId(docId);
        File after = FileUtils.buildUniqueFile(before.getParentFile(), displayName);
        File visibleFileBefore = this.getFileForDocId(docId, true);
        if (!before.renameTo(after)) {
            throw new IllegalStateException("Failed to rename to " + after);
        }
        String afterDocId = this.getDocIdForFile(after);
        this.moveInMediaStore(visibleFileBefore, this.getFileForDocId(afterDocId, true));
        if (!TextUtils.equals(docId, afterDocId)) {
            return afterDocId;
        }
        return null;
    }

    @Override
    public String moveDocument(String sourceDocumentId, String sourceParentDocumentId, String targetParentDocumentId) throws FileNotFoundException {
        File before = this.getFileForDocId(sourceDocumentId);
        File after = new File(this.getFileForDocId(targetParentDocumentId), before.getName());
        File visibleFileBefore = this.getFileForDocId(sourceDocumentId, true);
        if (after.exists()) {
            throw new IllegalStateException("Already exists " + after);
        }
        if (!before.renameTo(after)) {
            throw new IllegalStateException("Failed to move to " + after);
        }
        String docId = this.getDocIdForFile(after);
        this.moveInMediaStore(visibleFileBefore, this.getFileForDocId(docId, true));
        return docId;
    }

    private void moveInMediaStore(File oldVisibleFile, File newVisibleFile) {
        if (oldVisibleFile != null && newVisibleFile != null) {
            ContentResolver resolver = this.getContext().getContentResolver();
            Uri externalUri = newVisibleFile.isDirectory() ? MediaStore.Files.getDirectoryUri("external") : MediaStore.Files.getContentUri("external");
            ContentValues values = new ContentValues();
            values.put("_data", newVisibleFile.getAbsolutePath());
            String path = oldVisibleFile.getAbsolutePath();
            resolver.update(externalUri, values, "_data LIKE ? AND lower(_data)=lower(?)", new String[]{path, path});
        }
    }

    @Override
    public void deleteDocument(String docId) throws FileNotFoundException {
        File file = this.getFileForDocId(docId);
        File visibleFile = this.getFileForDocId(docId, true);
        boolean isDirectory = file.isDirectory();
        if (isDirectory) {
            FileUtils.deleteContents(file);
        }
        if (!file.delete()) {
            throw new IllegalStateException("Failed to delete " + file);
        }
        this.removeFromMediaStore(visibleFile, isDirectory);
    }

    private void removeFromMediaStore(File visibleFile, boolean isFolder) throws FileNotFoundException {
        if (visibleFile != null) {
            String path;
            ContentResolver resolver = this.getContext().getContentResolver();
            Uri externalUri = MediaStore.Files.getContentUri("external");
            if (isFolder) {
                path = visibleFile.getAbsolutePath() + "/";
                resolver.delete(externalUri, "_data LIKE ?1 AND lower(substr(_data,1,?2))=lower(?3)", new String[]{path + "%", Integer.toString(path.length()), path});
            }
            path = visibleFile.getAbsolutePath();
            resolver.delete(externalUri, "_data LIKE ?1 AND lower(_data)=lower(?2)", new String[]{path, path});
        }
    }

    @Override
    public Cursor queryDocument(String documentId, String[] projection) throws FileNotFoundException {
        MatrixCursor result = new MatrixCursor(this.resolveProjection(projection));
        this.includeFile(result, documentId, null);
        return result;
    }

    @Override
    public Cursor queryChildDocuments(String parentDocumentId, String[] projection, String sortOrder) throws FileNotFoundException {
        File parent = this.getFileForDocId(parentDocumentId);
        DirectoryCursor result = new DirectoryCursor(this.resolveProjection(projection), parentDocumentId, parent);
        for (File file : parent.listFiles()) {
            this.includeFile(result, null, file);
        }
        return result;
    }

    protected final Cursor querySearchDocuments(File folder, String query, String[] projection, Set<String> exclusion) throws FileNotFoundException {
        query = query.toLowerCase();
        MatrixCursor result = new MatrixCursor(this.resolveProjection(projection));
        LinkedList<File> pending = new LinkedList<File>();
        pending.add(folder);
        while (!pending.isEmpty() && result.getCount() < 24) {
            File file = (File)pending.removeFirst();
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    pending.add(child);
                }
            }
            if (!file.getName().toLowerCase().contains(query) || exclusion.contains(file.getAbsolutePath())) continue;
            this.includeFile(result, null, file);
        }
        return result;
    }

    @Override
    public String getDocumentType(String documentId) throws FileNotFoundException {
        File file = this.getFileForDocId(documentId);
        return FileSystemProvider.getTypeForFile(file);
    }

    @Override
    public ParcelFileDescriptor openDocument(String documentId, String mode, CancellationSignal signal) throws FileNotFoundException {
        File file = this.getFileForDocId(documentId);
        File visibleFile = this.getFileForDocId(documentId, true);
        int pfdMode = ParcelFileDescriptor.parseMode(mode);
        if (pfdMode == 0x10000000 || visibleFile == null) {
            return ParcelFileDescriptor.open(file, pfdMode);
        }
        try {
            return ParcelFileDescriptor.open(file, pfdMode, this.mHandler, e -> this.scanFile(visibleFile));
        }
        catch (IOException e2) {
            throw new FileNotFoundException("Failed to open for writing: " + e2);
        }
    }

    private void scanFile(File visibleFile) {
        Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        intent.setData(Uri.fromFile(visibleFile));
        this.getContext().sendBroadcast(intent);
    }

    @Override
    public AssetFileDescriptor openDocumentThumbnail(String documentId, Point sizeHint, CancellationSignal signal) throws FileNotFoundException {
        File file = this.getFileForDocId(documentId);
        return DocumentsContract.openImageThumbnail(file);
    }

    protected MatrixCursor.RowBuilder includeFile(MatrixCursor result, String docId, File file) throws FileNotFoundException {
        if (docId == null) {
            docId = this.getDocIdForFile(file);
        } else {
            file = this.getFileForDocId(docId);
        }
        int flags = 0;
        if (file.canWrite()) {
            if (file.isDirectory()) {
                flags |= 8;
                flags |= 4;
                flags |= 0x40;
                flags |= 0x100;
            } else {
                flags |= 2;
                flags |= 4;
                flags |= 0x40;
                flags |= 0x100;
            }
        }
        String mimeType = FileSystemProvider.getTypeForFile(file);
        String displayName = file.getName();
        if (mimeType.startsWith("image/")) {
            flags |= 1;
        }
        MatrixCursor.RowBuilder row = result.newRow();
        row.add("document_id", docId);
        row.add("_display_name", displayName);
        row.add("_size", file.length());
        row.add("mime_type", mimeType);
        row.add("flags", flags);
        long lastModified = file.lastModified();
        if (lastModified > 31536000000L) {
            row.add("last_modified", lastModified);
        }
        return row;
    }

    private static String getTypeForFile(File file) {
        if (file.isDirectory()) {
            return "vnd.android.document/directory";
        }
        return FileSystemProvider.getTypeForName(file.getName());
    }

    private static String getTypeForName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot >= 0) {
            String extension = name.substring(lastDot + 1).toLowerCase();
            String mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
            if (mime != null) {
                return mime;
            }
        }
        return "application/octet-stream";
    }

    protected final File getFileForDocId(String docId) throws FileNotFoundException {
        return this.getFileForDocId(docId, false);
    }

    private String[] resolveProjection(String[] projection) {
        return projection == null ? this.mDefaultProjection : projection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startObserving(File file, Uri notifyUri) {
        ArrayMap<File, DirectoryObserver> arrayMap = this.mObservers;
        synchronized (arrayMap) {
            DirectoryObserver observer = this.mObservers.get(file);
            if (observer == null) {
                observer = new DirectoryObserver(file, this.getContext().getContentResolver(), notifyUri);
                observer.startWatching();
                this.mObservers.put(file, observer);
            }
            observer.mRefCount++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopObserving(File file) {
        ArrayMap<File, DirectoryObserver> arrayMap = this.mObservers;
        synchronized (arrayMap) {
            DirectoryObserver observer = this.mObservers.get(file);
            if (observer == null) {
                return;
            }
            observer.mRefCount--;
            if (observer.mRefCount == 0) {
                this.mObservers.remove(file);
                observer.stopWatching();
            }
        }
    }

    private class DirectoryCursor
    extends MatrixCursor {
        private final File mFile;

        public DirectoryCursor(String[] columnNames, String docId, File file) {
            super(columnNames);
            Uri notifyUri = FileSystemProvider.this.buildNotificationUri(docId);
            this.setNotificationUri(FileSystemProvider.this.getContext().getContentResolver(), notifyUri);
            this.mFile = file;
            FileSystemProvider.this.startObserving(this.mFile, notifyUri);
        }

        @Override
        public void close() {
            super.close();
            FileSystemProvider.this.stopObserving(this.mFile);
        }
    }

    private static class DirectoryObserver
    extends FileObserver {
        private static final int NOTIFY_EVENTS = 4044;
        private final File mFile;
        private final ContentResolver mResolver;
        private final Uri mNotifyUri;
        private int mRefCount = 0;

        public DirectoryObserver(File file, ContentResolver resolver, Uri notifyUri) {
            super(file.getAbsolutePath(), 4044);
            this.mFile = file;
            this.mResolver = resolver;
            this.mNotifyUri = notifyUri;
        }

        @Override
        public void onEvent(int event, String path) {
            if ((event & 0xFCC) != 0) {
                this.mResolver.notifyChange(this.mNotifyUri, null, false);
            }
        }

        public String toString() {
            return "DirectoryObserver{file=" + this.mFile.getAbsolutePath() + ", ref=" + this.mRefCount + "}";
        }
    }
}

