/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.os.Environment;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IStorageManager;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.os.storage.VolumeInfo;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.content.NativeLibraryHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import libcore.io.IoUtils;

public class PackageHelper {
    public static final int RECOMMEND_INSTALL_INTERNAL = 1;
    public static final int RECOMMEND_INSTALL_EXTERNAL = 2;
    public static final int RECOMMEND_INSTALL_EPHEMERAL = 3;
    public static final int RECOMMEND_FAILED_INSUFFICIENT_STORAGE = -1;
    public static final int RECOMMEND_FAILED_INVALID_APK = -2;
    public static final int RECOMMEND_FAILED_INVALID_LOCATION = -3;
    public static final int RECOMMEND_FAILED_ALREADY_EXISTS = -4;
    public static final int RECOMMEND_MEDIA_UNAVAILABLE = -5;
    public static final int RECOMMEND_FAILED_INVALID_URI = -6;
    public static final int RECOMMEND_FAILED_VERSION_DOWNGRADE = -7;
    private static final boolean localLOGV = false;
    private static final String TAG = "PackageHelper";
    public static final int APP_INSTALL_AUTO = 0;
    public static final int APP_INSTALL_INTERNAL = 1;
    public static final int APP_INSTALL_EXTERNAL = 2;
    private static TestableInterface sDefaultTestableInterface = null;

    public static IStorageManager getStorageManager() throws RemoteException {
        IBinder service = ServiceManager.getService("mount");
        if (service != null) {
            return IStorageManager.Stub.asInterface(service);
        }
        Log.e(TAG, "Can't get storagemanager service");
        throw new RemoteException("Could not contact storagemanager service");
    }

    public static String createSdDir(long sizeBytes, String cid, String sdEncKey, int uid, boolean isExternal) {
        int sizeMb = (int)((sizeBytes + 0x100000L) / 0x100000L) + 1;
        try {
            IStorageManager storageManager = PackageHelper.getStorageManager();
            int rc = storageManager.createSecureContainer(cid, sizeMb, "ext4", sdEncKey, uid, isExternal);
            if (rc != 0) {
                Log.e(TAG, "Failed to create secure container " + cid);
                return null;
            }
            String cachePath = storageManager.getSecureContainerPath(cid);
            return cachePath;
        }
        catch (RemoteException e) {
            Log.e(TAG, "StorageManagerService running?");
            return null;
        }
    }

    public static boolean resizeSdDir(long sizeBytes, String cid, String sdEncKey) {
        int sizeMb = (int)((sizeBytes + 0x100000L) / 0x100000L) + 1;
        try {
            IStorageManager storageManager = PackageHelper.getStorageManager();
            int rc = storageManager.resizeSecureContainer(cid, sizeMb, sdEncKey);
            if (rc == 0) {
                return true;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "StorageManagerService running?");
        }
        Log.e(TAG, "Failed to create secure container " + cid);
        return false;
    }

    public static String mountSdDir(String cid, String key, int ownerUid) {
        return PackageHelper.mountSdDir(cid, key, ownerUid, true);
    }

    public static String mountSdDir(String cid, String key, int ownerUid, boolean readOnly) {
        try {
            int rc = PackageHelper.getStorageManager().mountSecureContainer(cid, key, ownerUid, readOnly);
            if (rc != 0) {
                Log.i(TAG, "Failed to mount container " + cid + " rc : " + rc);
                return null;
            }
            return PackageHelper.getStorageManager().getSecureContainerPath(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "StorageManagerService running?");
            return null;
        }
    }

    public static boolean unMountSdDir(String cid) {
        try {
            int rc = PackageHelper.getStorageManager().unmountSecureContainer(cid, true);
            if (rc != 0) {
                Log.e(TAG, "Failed to unmount " + cid + " with rc " + rc);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "StorageManagerService running?");
            return false;
        }
    }

    public static boolean renameSdDir(String oldId, String newId) {
        try {
            int rc = PackageHelper.getStorageManager().renameSecureContainer(oldId, newId);
            if (rc != 0) {
                Log.e(TAG, "Failed to rename " + oldId + " to " + newId + "with rc " + rc);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.i(TAG, "Failed ot rename  " + oldId + " to " + newId + " with exception : " + e);
            return false;
        }
    }

    public static String getSdDir(String cid) {
        try {
            return PackageHelper.getStorageManager().getSecureContainerPath(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get container path for " + cid + " with exception " + e);
            return null;
        }
    }

    public static String getSdFilesystem(String cid) {
        try {
            return PackageHelper.getStorageManager().getSecureContainerFilesystemPath(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get container path for " + cid + " with exception " + e);
            return null;
        }
    }

    public static boolean finalizeSdDir(String cid) {
        try {
            int rc = PackageHelper.getStorageManager().finalizeSecureContainer(cid);
            if (rc != 0) {
                Log.i(TAG, "Failed to finalize container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to finalize container " + cid + " with exception " + e);
            return false;
        }
    }

    public static boolean destroySdDir(String cid) {
        try {
            int rc = PackageHelper.getStorageManager().destroySecureContainer(cid, true);
            if (rc != 0) {
                Log.i(TAG, "Failed to destroy container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to destroy container " + cid + " with exception " + e);
            return false;
        }
    }

    public static String[] getSecureContainerList() {
        try {
            return PackageHelper.getStorageManager().getSecureContainerList();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get secure container list with exception" + e);
            return null;
        }
    }

    public static boolean isContainerMounted(String cid) {
        try {
            return PackageHelper.getStorageManager().isSecureContainerMounted(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to find out if container " + cid + " mounted");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long extractPublicFiles(File apkFile, File publicZipFile) throws IOException {
        ZipOutputStream publicZipOutStream;
        FileOutputStream fstr;
        if (publicZipFile == null) {
            fstr = null;
            publicZipOutStream = null;
        } else {
            fstr = new FileOutputStream(publicZipFile);
            publicZipOutStream = new ZipOutputStream(fstr);
            Log.d(TAG, "Extracting " + apkFile + " to " + publicZipFile);
        }
        long size = 0L;
        try {
            ZipFile privateZip = new ZipFile(apkFile.getAbsolutePath());
            try {
                for (ZipEntry zipEntry : Collections.list(privateZip.entries())) {
                    String zipEntryName = zipEntry.getName();
                    if (!"AndroidManifest.xml".equals(zipEntryName) && !"resources.arsc".equals(zipEntryName) && !zipEntryName.startsWith("res/")) continue;
                    size += zipEntry.getSize();
                    if (publicZipFile == null) continue;
                    PackageHelper.copyZipEntry(zipEntry, privateZip, publicZipOutStream);
                }
            }
            finally {
                try {
                    privateZip.close();
                }
                catch (IOException iOException) {}
            }
            if (publicZipFile != null) {
                publicZipOutStream.finish();
                publicZipOutStream.flush();
                FileUtils.sync(fstr);
                publicZipOutStream.close();
                FileUtils.setPermissions(publicZipFile.getAbsolutePath(), 420, -1, -1);
            }
        }
        finally {
            IoUtils.closeQuietly(publicZipOutStream);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyZipEntry(ZipEntry zipEntry, ZipFile inZipFile, ZipOutputStream outZipStream) throws IOException {
        byte[] buffer = new byte[4096];
        ZipEntry newEntry = zipEntry.getMethod() == 0 ? new ZipEntry(zipEntry) : new ZipEntry(zipEntry.getName());
        outZipStream.putNextEntry(newEntry);
        InputStream data = inZipFile.getInputStream(zipEntry);
        try {
            int num;
            while ((num = data.read(buffer)) > 0) {
                outZipStream.write(buffer, 0, num);
            }
            outZipStream.flush();
        }
        finally {
            IoUtils.closeQuietly(data);
        }
    }

    public static boolean fixSdPermissions(String cid, int gid, String filename) {
        try {
            int rc = PackageHelper.getStorageManager().fixPermissionsSecureContainer(cid, gid, filename);
            if (rc != 0) {
                Log.i(TAG, "Failed to fixperms container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to fixperms container " + cid + " with exception " + e);
            return false;
        }
    }

    private static synchronized TestableInterface getDefaultTestableInterface() {
        if (sDefaultTestableInterface == null) {
            sDefaultTestableInterface = new TestableInterface(){

                @Override
                public StorageManager getStorageManager(Context context) {
                    return context.getSystemService(StorageManager.class);
                }

                @Override
                public boolean getForceAllowOnExternalSetting(Context context) {
                    return Settings.Global.getInt(context.getContentResolver(), "force_allow_on_external", 0) != 0;
                }

                @Override
                public boolean getAllow3rdPartyOnInternalConfig(Context context) {
                    return context.getResources().getBoolean(17956869);
                }

                @Override
                public ApplicationInfo getExistingAppInfo(Context context, String packageName) {
                    ApplicationInfo existingInfo = null;
                    try {
                        existingInfo = context.getPackageManager().getApplicationInfo(packageName, 0x400000);
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                    return existingInfo;
                }

                @Override
                public File getDataDirectory() {
                    return Environment.getDataDirectory();
                }
            };
        }
        return sDefaultTestableInterface;
    }

    @Deprecated
    public static String resolveInstallVolume(Context context, String packageName, int installLocation, long sizeBytes, TestableInterface testInterface) throws IOException {
        PackageInstaller.SessionParams params = new PackageInstaller.SessionParams(-1);
        params.appPackageName = packageName;
        params.installLocation = installLocation;
        params.sizeBytes = sizeBytes;
        return PackageHelper.resolveInstallVolume(context, params, testInterface);
    }

    public static String resolveInstallVolume(Context context, PackageInstaller.SessionParams params) throws IOException {
        TestableInterface testableInterface = PackageHelper.getDefaultTestableInterface();
        return PackageHelper.resolveInstallVolume(context, params.appPackageName, params.installLocation, params.sizeBytes, testableInterface);
    }

    public static String resolveInstallVolume(Context context, PackageInstaller.SessionParams params, TestableInterface testInterface) throws IOException {
        boolean forceAllowOnExternal = testInterface.getForceAllowOnExternalSetting(context);
        boolean allow3rdPartyOnInternal = testInterface.getAllow3rdPartyOnInternalConfig(context);
        ApplicationInfo existingInfo = testInterface.getExistingAppInfo(context, params.appPackageName);
        boolean fitsOnInternal = testInterface.fitsOnInternalStorage(context, params);
        StorageManager storageManager = testInterface.getStorageManager(context);
        if (existingInfo != null && existingInfo.isSystemApp()) {
            if (fitsOnInternal) {
                return StorageManager.UUID_PRIVATE_INTERNAL;
            }
            throw new IOException("Not enough space on existing volume " + existingInfo.volumeUuid + " for system app " + params.appPackageName + " upgrade");
        }
        ArraySet<String> allCandidates = new ArraySet<String>();
        VolumeInfo bestCandidate = null;
        long bestCandidateAvailBytes = Long.MIN_VALUE;
        for (VolumeInfo vol : storageManager.getVolumes()) {
            boolean isInternalStorage = "private".equals(vol.id);
            if (vol.type != 1 || !vol.isMountedWritable() || isInternalStorage && !allow3rdPartyOnInternal) continue;
            long availBytes = storageManager.getAllocatableBytes(new File(vol.path), PackageHelper.translateAllocateFlags(params.installFlags));
            if (availBytes >= params.sizeBytes) {
                allCandidates.add(vol.fsUuid);
            }
            if (availBytes < bestCandidateAvailBytes) continue;
            bestCandidate = vol;
            bestCandidateAvailBytes = availBytes;
        }
        if (!forceAllowOnExternal && params.installLocation == 1) {
            if (existingInfo != null && !Objects.equals(existingInfo.volumeUuid, StorageManager.UUID_PRIVATE_INTERNAL)) {
                throw new IOException("Cannot automatically move " + params.appPackageName + " from " + existingInfo.volumeUuid + " to internal storage");
            }
            if (!allow3rdPartyOnInternal) {
                throw new IOException("Not allowed to install non-system apps on internal storage");
            }
            if (fitsOnInternal) {
                return StorageManager.UUID_PRIVATE_INTERNAL;
            }
            throw new IOException("Requested internal only, but not enough space");
        }
        if (existingInfo != null) {
            if (Objects.equals(existingInfo.volumeUuid, StorageManager.UUID_PRIVATE_INTERNAL) && fitsOnInternal) {
                return StorageManager.UUID_PRIVATE_INTERNAL;
            }
            if (allCandidates.contains(existingInfo.volumeUuid)) {
                return existingInfo.volumeUuid;
            }
            throw new IOException("Not enough space on existing volume " + existingInfo.volumeUuid + " for " + params.appPackageName + " upgrade");
        }
        if (bestCandidate != null) {
            return bestCandidate.fsUuid;
        }
        throw new IOException("No special requests, but no room on allowed volumes.  allow3rdPartyOnInternal? " + allow3rdPartyOnInternal);
    }

    public static boolean fitsOnInternal(Context context, PackageInstaller.SessionParams params) throws IOException {
        File target;
        StorageManager storage = context.getSystemService(StorageManager.class);
        return params.sizeBytes <= storage.getAllocatableBytes(target = Environment.getDataDirectory(), PackageHelper.translateAllocateFlags(params.installFlags));
    }

    public static boolean fitsOnExternal(Context context, PackageInstaller.SessionParams params) {
        StorageManager storage = context.getSystemService(StorageManager.class);
        StorageVolume primary = storage.getPrimaryVolume();
        return params.sizeBytes > 0L && !primary.isEmulated() && "mounted".equals(primary.getState()) && params.sizeBytes <= storage.getStorageBytesUntilLow(primary.getPathFile());
    }

    @Deprecated
    public static int resolveInstallLocation(Context context, String packageName, int installLocation, long sizeBytes, int installFlags) {
        PackageInstaller.SessionParams params = new PackageInstaller.SessionParams(-1);
        params.appPackageName = packageName;
        params.installLocation = installLocation;
        params.sizeBytes = sizeBytes;
        params.installFlags = installFlags;
        try {
            return PackageHelper.resolveInstallLocation(context, params);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static int resolveInstallLocation(Context context, PackageInstaller.SessionParams params) throws IOException {
        boolean checkBoth;
        int prefer;
        ApplicationInfo existingInfo = null;
        try {
            existingInfo = context.getPackageManager().getApplicationInfo(params.appPackageName, 0x400000);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        boolean ephemeral = false;
        if ((params.installFlags & 0x800) != 0) {
            prefer = 1;
            ephemeral = true;
            checkBoth = false;
        } else if ((params.installFlags & 0x10) != 0) {
            prefer = 1;
            checkBoth = false;
        } else if ((params.installFlags & 8) != 0) {
            prefer = 2;
            checkBoth = false;
        } else if (params.installLocation == 1) {
            prefer = 1;
            checkBoth = false;
        } else if (params.installLocation == 2) {
            prefer = 2;
            checkBoth = true;
        } else if (params.installLocation == 0) {
            prefer = existingInfo != null ? ((existingInfo.flags & 0x40000) != 0 ? 2 : 1) : 1;
            checkBoth = true;
        } else {
            prefer = 1;
            checkBoth = false;
        }
        boolean fitsOnInternal = false;
        if (checkBoth || prefer == 1) {
            fitsOnInternal = PackageHelper.fitsOnInternal(context, params);
        }
        boolean fitsOnExternal = false;
        if (checkBoth || prefer == 2) {
            fitsOnExternal = PackageHelper.fitsOnExternal(context, params);
        }
        if (prefer == 1) {
            if (fitsOnInternal) {
                return ephemeral ? 3 : 1;
            }
        } else if (prefer == 2 && fitsOnExternal) {
            return 2;
        }
        if (checkBoth) {
            if (fitsOnInternal) {
                return 1;
            }
            if (fitsOnExternal) {
                return 2;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateInstalledSize(PackageParser.PackageLite pkg, boolean isForwardLocked, String abiOverride) throws IOException {
        NativeLibraryHelper.Handle handle = null;
        try {
            handle = NativeLibraryHelper.Handle.create(pkg);
            long l = PackageHelper.calculateInstalledSize(pkg, handle, isForwardLocked, abiOverride);
            return l;
        }
        finally {
            IoUtils.closeQuietly(handle);
        }
    }

    public static long calculateInstalledSize(PackageParser.PackageLite pkg, NativeLibraryHelper.Handle handle, boolean isForwardLocked, String abiOverride) throws IOException {
        long sizeBytes = 0L;
        for (String codePath : pkg.getAllCodePaths()) {
            File codeFile = new File(codePath);
            sizeBytes += codeFile.length();
            if (!isForwardLocked) continue;
            sizeBytes += PackageHelper.extractPublicFiles(codeFile, null);
        }
        return sizeBytes += NativeLibraryHelper.sumNativeBinariesWithOverride(handle, abiOverride);
    }

    public static String replaceEnd(String str, String before, String after) {
        if (!str.endsWith(before)) {
            throw new IllegalArgumentException("Expected " + str + " to end with " + before);
        }
        return str.substring(0, str.length() - before.length()) + after;
    }

    public static int translateAllocateFlags(int installFlags) {
        if ((installFlags & 0x8000) != 0) {
            return 1;
        }
        return 0;
    }

    public static abstract class TestableInterface {
        public abstract StorageManager getStorageManager(Context var1);

        public abstract boolean getForceAllowOnExternalSetting(Context var1);

        public abstract boolean getAllow3rdPartyOnInternalConfig(Context var1);

        public abstract ApplicationInfo getExistingAppInfo(Context var1, String var2);

        public abstract File getDataDirectory();

        public boolean fitsOnInternalStorage(Context context, PackageInstaller.SessionParams params) throws IOException {
            File target;
            StorageManager storage = this.getStorageManager(context);
            return params.sizeBytes <= storage.getAllocatableBytes(target = this.getDataDirectory(), PackageHelper.translateAllocateFlags(params.installFlags));
        }
    }
}

