/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.palette;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.util.TimingLogger;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.palette.ColorCutQuantizer;
import com.android.internal.graphics.palette.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Palette {
    static final int DEFAULT_RESIZE_BITMAP_AREA = 12544;
    static final int DEFAULT_CALCULATE_NUMBER_COLORS = 16;
    static final float MIN_CONTRAST_TITLE_TEXT = 3.0f;
    static final float MIN_CONTRAST_BODY_TEXT = 4.5f;
    static final String LOG_TAG = "Palette";
    static final boolean LOG_TIMINGS = false;
    private final List<Swatch> mSwatches;
    private final List<Target> mTargets;
    private final Map<Target, Swatch> mSelectedSwatches;
    private final SparseBooleanArray mUsedColors;
    private final Swatch mDominantSwatch;
    static final Filter DEFAULT_FILTER = new Filter(){
        private static final float BLACK_MAX_LIGHTNESS = 0.05f;
        private static final float WHITE_MIN_LIGHTNESS = 0.95f;

        @Override
        public boolean isAllowed(int rgb, float[] hsl) {
            return !this.isWhite(hsl) && !this.isBlack(hsl) && !this.isNearRedILine(hsl);
        }

        private boolean isBlack(float[] hslColor) {
            return hslColor[2] <= 0.05f;
        }

        private boolean isWhite(float[] hslColor) {
            return hslColor[2] >= 0.95f;
        }

        private boolean isNearRedILine(float[] hslColor) {
            return hslColor[0] >= 10.0f && hslColor[0] <= 37.0f && hslColor[1] <= 0.82f;
        }
    };

    public static Builder from(Bitmap bitmap) {
        return new Builder(bitmap);
    }

    public static Palette from(List<Swatch> swatches) {
        return new Builder(swatches).generate();
    }

    @Deprecated
    public static Palette generate(Bitmap bitmap) {
        return Palette.from(bitmap).generate();
    }

    @Deprecated
    public static Palette generate(Bitmap bitmap, int numColors) {
        return Palette.from(bitmap).maximumColorCount(numColors).generate();
    }

    @Deprecated
    public static AsyncTask<Bitmap, Void, Palette> generateAsync(Bitmap bitmap, PaletteAsyncListener listener) {
        return Palette.from(bitmap).generate(listener);
    }

    @Deprecated
    public static AsyncTask<Bitmap, Void, Palette> generateAsync(Bitmap bitmap, int numColors, PaletteAsyncListener listener) {
        return Palette.from(bitmap).maximumColorCount(numColors).generate(listener);
    }

    Palette(List<Swatch> swatches, List<Target> targets) {
        this.mSwatches = swatches;
        this.mTargets = targets;
        this.mUsedColors = new SparseBooleanArray();
        this.mSelectedSwatches = new ArrayMap<Target, Swatch>();
        this.mDominantSwatch = this.findDominantSwatch();
    }

    public List<Swatch> getSwatches() {
        return Collections.unmodifiableList(this.mSwatches);
    }

    public List<Target> getTargets() {
        return Collections.unmodifiableList(this.mTargets);
    }

    public Swatch getVibrantSwatch() {
        return this.getSwatchForTarget(Target.VIBRANT);
    }

    public Swatch getLightVibrantSwatch() {
        return this.getSwatchForTarget(Target.LIGHT_VIBRANT);
    }

    public Swatch getDarkVibrantSwatch() {
        return this.getSwatchForTarget(Target.DARK_VIBRANT);
    }

    public Swatch getMutedSwatch() {
        return this.getSwatchForTarget(Target.MUTED);
    }

    public Swatch getLightMutedSwatch() {
        return this.getSwatchForTarget(Target.LIGHT_MUTED);
    }

    public Swatch getDarkMutedSwatch() {
        return this.getSwatchForTarget(Target.DARK_MUTED);
    }

    public int getVibrantColor(int defaultColor) {
        return this.getColorForTarget(Target.VIBRANT, defaultColor);
    }

    public int getLightVibrantColor(int defaultColor) {
        return this.getColorForTarget(Target.LIGHT_VIBRANT, defaultColor);
    }

    public int getDarkVibrantColor(int defaultColor) {
        return this.getColorForTarget(Target.DARK_VIBRANT, defaultColor);
    }

    public int getMutedColor(int defaultColor) {
        return this.getColorForTarget(Target.MUTED, defaultColor);
    }

    public int getLightMutedColor(int defaultColor) {
        return this.getColorForTarget(Target.LIGHT_MUTED, defaultColor);
    }

    public int getDarkMutedColor(int defaultColor) {
        return this.getColorForTarget(Target.DARK_MUTED, defaultColor);
    }

    public Swatch getSwatchForTarget(Target target) {
        return this.mSelectedSwatches.get(target);
    }

    public int getColorForTarget(Target target, int defaultColor) {
        Swatch swatch = this.getSwatchForTarget(target);
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    public Swatch getDominantSwatch() {
        return this.mDominantSwatch;
    }

    public int getDominantColor(int defaultColor) {
        return this.mDominantSwatch != null ? this.mDominantSwatch.getRgb() : defaultColor;
    }

    void generate() {
        int count = this.mTargets.size();
        for (int i = 0; i < count; ++i) {
            Target target = this.mTargets.get(i);
            target.normalizeWeights();
            this.mSelectedSwatches.put(target, this.generateScoredTarget(target));
        }
        this.mUsedColors.clear();
    }

    private Swatch generateScoredTarget(Target target) {
        Swatch maxScoreSwatch = this.getMaxScoredSwatchForTarget(target);
        if (maxScoreSwatch != null && target.isExclusive()) {
            this.mUsedColors.append(maxScoreSwatch.getRgb(), true);
        }
        return maxScoreSwatch;
    }

    private Swatch getMaxScoredSwatchForTarget(Target target) {
        float maxScore = 0.0f;
        Swatch maxScoreSwatch = null;
        int count = this.mSwatches.size();
        for (int i = 0; i < count; ++i) {
            Swatch swatch = this.mSwatches.get(i);
            if (!this.shouldBeScoredForTarget(swatch, target)) continue;
            float score = this.generateScore(swatch, target);
            if (maxScoreSwatch != null && !(score > maxScore)) continue;
            maxScoreSwatch = swatch;
            maxScore = score;
        }
        return maxScoreSwatch;
    }

    private boolean shouldBeScoredForTarget(Swatch swatch, Target target) {
        float[] hsl = swatch.getHsl();
        return hsl[1] >= target.getMinimumSaturation() && hsl[1] <= target.getMaximumSaturation() && hsl[2] >= target.getMinimumLightness() && hsl[2] <= target.getMaximumLightness() && !this.mUsedColors.get(swatch.getRgb());
    }

    private float generateScore(Swatch swatch, Target target) {
        int maxPopulation;
        float[] hsl = swatch.getHsl();
        float saturationScore = 0.0f;
        float luminanceScore = 0.0f;
        float populationScore = 0.0f;
        int n = maxPopulation = this.mDominantSwatch != null ? this.mDominantSwatch.getPopulation() : 1;
        if (target.getSaturationWeight() > 0.0f) {
            saturationScore = target.getSaturationWeight() * (1.0f - Math.abs(hsl[1] - target.getTargetSaturation()));
        }
        if (target.getLightnessWeight() > 0.0f) {
            luminanceScore = target.getLightnessWeight() * (1.0f - Math.abs(hsl[2] - target.getTargetLightness()));
        }
        if (target.getPopulationWeight() > 0.0f) {
            populationScore = target.getPopulationWeight() * ((float)swatch.getPopulation() / (float)maxPopulation);
        }
        return saturationScore + luminanceScore + populationScore;
    }

    private Swatch findDominantSwatch() {
        int maxPop = Integer.MIN_VALUE;
        Swatch maxSwatch = null;
        int count = this.mSwatches.size();
        for (int i = 0; i < count; ++i) {
            Swatch swatch = this.mSwatches.get(i);
            if (swatch.getPopulation() <= maxPop) continue;
            maxSwatch = swatch;
            maxPop = swatch.getPopulation();
        }
        return maxSwatch;
    }

    private static float[] copyHslValues(Swatch color2) {
        float[] newHsl = new float[3];
        System.arraycopy((float[])color2.getHsl(), (int)0, (float[])newHsl, (int)0, (int)3);
        return newHsl;
    }

    public static interface Filter {
        public boolean isAllowed(int var1, float[] var2);
    }

    public static final class Builder {
        private final List<Swatch> mSwatches;
        private final Bitmap mBitmap;
        private final List<Target> mTargets = new ArrayList<Target>();
        private int mMaxColors = 16;
        private int mResizeArea = 12544;
        private int mResizeMaxDimension = -1;
        private final List<Filter> mFilters = new ArrayList<Filter>();
        private Rect mRegion;

        public Builder(Bitmap bitmap) {
            if (bitmap == null || bitmap.isRecycled()) {
                throw new IllegalArgumentException("Bitmap is not valid");
            }
            this.mFilters.add(DEFAULT_FILTER);
            this.mBitmap = bitmap;
            this.mSwatches = null;
            this.mTargets.add(Target.LIGHT_VIBRANT);
            this.mTargets.add(Target.VIBRANT);
            this.mTargets.add(Target.DARK_VIBRANT);
            this.mTargets.add(Target.LIGHT_MUTED);
            this.mTargets.add(Target.MUTED);
            this.mTargets.add(Target.DARK_MUTED);
        }

        public Builder(List<Swatch> swatches) {
            if (swatches == null || swatches.isEmpty()) {
                throw new IllegalArgumentException("List of Swatches is not valid");
            }
            this.mFilters.add(DEFAULT_FILTER);
            this.mSwatches = swatches;
            this.mBitmap = null;
        }

        public Builder maximumColorCount(int colors) {
            this.mMaxColors = colors;
            return this;
        }

        @Deprecated
        public Builder resizeBitmapSize(int maxDimension) {
            this.mResizeMaxDimension = maxDimension;
            this.mResizeArea = -1;
            return this;
        }

        public Builder resizeBitmapArea(int area) {
            this.mResizeArea = area;
            this.mResizeMaxDimension = -1;
            return this;
        }

        public Builder clearFilters() {
            this.mFilters.clear();
            return this;
        }

        public Builder addFilter(Filter filter) {
            if (filter != null) {
                this.mFilters.add(filter);
            }
            return this;
        }

        public Builder setRegion(int left, int top, int right, int bottom) {
            if (this.mBitmap != null) {
                if (this.mRegion == null) {
                    this.mRegion = new Rect();
                }
                this.mRegion.set(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
                if (!this.mRegion.intersect(left, top, right, bottom)) {
                    throw new IllegalArgumentException("The given region must intersect with the Bitmap's dimensions.");
                }
            }
            return this;
        }

        public Builder clearRegion() {
            this.mRegion = null;
            return this;
        }

        public Builder addTarget(Target target) {
            if (!this.mTargets.contains(target)) {
                this.mTargets.add(target);
            }
            return this;
        }

        public Builder clearTargets() {
            if (this.mTargets != null) {
                this.mTargets.clear();
            }
            return this;
        }

        public Palette generate() {
            List<Swatch> swatches;
            TimingLogger logger = null;
            if (this.mBitmap != null) {
                Bitmap bitmap = this.scaleBitmapDown(this.mBitmap);
                if (logger != null) {
                    logger.addSplit("Processed Bitmap");
                }
                Rect region = this.mRegion;
                if (bitmap != this.mBitmap && region != null) {
                    double scale = (double)bitmap.getWidth() / (double)this.mBitmap.getWidth();
                    region.left = (int)Math.floor((double)region.left * scale);
                    region.top = (int)Math.floor((double)region.top * scale);
                    region.right = Math.min((int)Math.ceil((double)region.right * scale), bitmap.getWidth());
                    region.bottom = Math.min((int)Math.ceil((double)region.bottom * scale), bitmap.getHeight());
                }
                ColorCutQuantizer quantizer = new ColorCutQuantizer(this.getPixelsFromBitmap(bitmap), this.mMaxColors, this.mFilters.isEmpty() ? null : this.mFilters.toArray(new Filter[this.mFilters.size()]));
                if (bitmap != this.mBitmap) {
                    bitmap.recycle();
                }
                swatches = quantizer.getQuantizedColors();
                if (logger != null) {
                    logger.addSplit("Color quantization completed");
                }
            } else {
                swatches = this.mSwatches;
            }
            Palette p = new Palette(swatches, this.mTargets);
            p.generate();
            if (logger != null) {
                logger.addSplit("Created Palette");
                logger.dumpToLog();
            }
            return p;
        }

        public AsyncTask<Bitmap, Void, Palette> generate(final PaletteAsyncListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener can not be null");
            }
            return new AsyncTask<Bitmap, Void, Palette>(){

                protected Palette doInBackground(Bitmap ... params) {
                    try {
                        return this.generate();
                    }
                    catch (Exception e) {
                        Log.e(Palette.LOG_TAG, "Exception thrown during async generate", e);
                        return null;
                    }
                }

                @Override
                protected void onPostExecute(Palette colorExtractor) {
                    listener.onGenerated(colorExtractor);
                }
            }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, this.mBitmap);
        }

        private int[] getPixelsFromBitmap(Bitmap bitmap) {
            int bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            int[] pixels = new int[bitmapWidth * bitmapHeight];
            bitmap.getPixels(pixels, 0, bitmapWidth, 0, 0, bitmapWidth, bitmapHeight);
            if (this.mRegion == null) {
                return pixels;
            }
            int regionWidth = this.mRegion.width();
            int regionHeight = this.mRegion.height();
            int[] subsetPixels = new int[regionWidth * regionHeight];
            for (int row = 0; row < regionHeight; ++row) {
                System.arraycopy((int[])pixels, (int)((row + this.mRegion.top) * bitmapWidth + this.mRegion.left), (int[])subsetPixels, (int)(row * regionWidth), (int)regionWidth);
            }
            return subsetPixels;
        }

        private Bitmap scaleBitmapDown(Bitmap bitmap) {
            int maxDimension;
            double scaleRatio = -1.0;
            if (this.mResizeArea > 0) {
                int bitmapArea = bitmap.getWidth() * bitmap.getHeight();
                if (bitmapArea > this.mResizeArea) {
                    scaleRatio = Math.sqrt((double)this.mResizeArea / (double)bitmapArea);
                }
            } else if (this.mResizeMaxDimension > 0 && (maxDimension = Math.max(bitmap.getWidth(), bitmap.getHeight())) > this.mResizeMaxDimension) {
                scaleRatio = (double)this.mResizeMaxDimension / (double)maxDimension;
            }
            if (scaleRatio <= 0.0) {
                return bitmap;
            }
            return Bitmap.createScaledBitmap(bitmap, (int)Math.ceil((double)bitmap.getWidth() * scaleRatio), (int)Math.ceil((double)bitmap.getHeight() * scaleRatio), false);
        }
    }

    public static final class Swatch {
        private final int mRed;
        private final int mGreen;
        private final int mBlue;
        private final int mRgb;
        private final int mPopulation;
        private boolean mGeneratedTextColors;
        private int mTitleTextColor;
        private int mBodyTextColor;
        private float[] mHsl;

        public Swatch(int color2, int population) {
            this.mRed = Color.red(color2);
            this.mGreen = Color.green(color2);
            this.mBlue = Color.blue(color2);
            this.mRgb = color2;
            this.mPopulation = population;
        }

        Swatch(int red, int green, int blue, int population) {
            this.mRed = red;
            this.mGreen = green;
            this.mBlue = blue;
            this.mRgb = Color.rgb(red, green, blue);
            this.mPopulation = population;
        }

        Swatch(float[] hsl, int population) {
            this(ColorUtils.HSLToColor(hsl), population);
            this.mHsl = hsl;
        }

        public int getRgb() {
            return this.mRgb;
        }

        public float[] getHsl() {
            if (this.mHsl == null) {
                this.mHsl = new float[3];
            }
            ColorUtils.RGBToHSL(this.mRed, this.mGreen, this.mBlue, this.mHsl);
            return this.mHsl;
        }

        public int getPopulation() {
            return this.mPopulation;
        }

        public int getTitleTextColor() {
            this.ensureTextColorsGenerated();
            return this.mTitleTextColor;
        }

        public int getBodyTextColor() {
            this.ensureTextColorsGenerated();
            return this.mBodyTextColor;
        }

        private void ensureTextColorsGenerated() {
            if (!this.mGeneratedTextColors) {
                int lightBodyAlpha = ColorUtils.calculateMinimumAlpha(-1, this.mRgb, 4.5f);
                int lightTitleAlpha = ColorUtils.calculateMinimumAlpha(-1, this.mRgb, 3.0f);
                if (lightBodyAlpha != -1 && lightTitleAlpha != -1) {
                    this.mBodyTextColor = ColorUtils.setAlphaComponent(-1, lightBodyAlpha);
                    this.mTitleTextColor = ColorUtils.setAlphaComponent(-1, lightTitleAlpha);
                    this.mGeneratedTextColors = true;
                    return;
                }
                int darkBodyAlpha = ColorUtils.calculateMinimumAlpha(-16777216, this.mRgb, 4.5f);
                int darkTitleAlpha = ColorUtils.calculateMinimumAlpha(-16777216, this.mRgb, 3.0f);
                if (darkBodyAlpha != -1 && darkTitleAlpha != -1) {
                    this.mBodyTextColor = ColorUtils.setAlphaComponent(-16777216, darkBodyAlpha);
                    this.mTitleTextColor = ColorUtils.setAlphaComponent(-16777216, darkTitleAlpha);
                    this.mGeneratedTextColors = true;
                    return;
                }
                this.mBodyTextColor = lightBodyAlpha != -1 ? ColorUtils.setAlphaComponent(-1, lightBodyAlpha) : ColorUtils.setAlphaComponent(-16777216, darkBodyAlpha);
                this.mTitleTextColor = lightTitleAlpha != -1 ? ColorUtils.setAlphaComponent(-1, lightTitleAlpha) : ColorUtils.setAlphaComponent(-16777216, darkTitleAlpha);
                this.mGeneratedTextColors = true;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [RGB: #" + Integer.toHexString(this.getRgb()) + ']' + " [HSL: " + Arrays.toString(this.getHsl()) + ']' + " [Population: " + this.mPopulation + ']' + " [Title Text: #" + Integer.toHexString(this.getTitleTextColor()) + ']' + " [Body Text: #" + Integer.toHexString(this.getBodyTextColor()) + ']';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Swatch swatch = (Swatch)o;
            return this.mPopulation == swatch.mPopulation && this.mRgb == swatch.mRgb;
        }

        public int hashCode() {
            return 31 * this.mRgb + this.mPopulation;
        }
    }

    public static interface PaletteAsyncListener {
        public void onGenerated(Palette var1);
    }
}

