/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.hardware;

import android.content.Context;
import android.provider.Settings;
import android.text.TextUtils;

public class AmbientDisplayConfiguration {
    private final Context mContext;

    public AmbientDisplayConfiguration(Context context) {
        this.mContext = context;
    }

    public boolean enabled(int user) {
        return this.pulseOnNotificationEnabled(user) || this.pulseOnPickupEnabled(user) || this.pulseOnDoubleTapEnabled(user) || this.alwaysOnEnabled(user);
    }

    public boolean available() {
        return this.pulseOnNotificationAvailable() || this.pulseOnPickupAvailable() || this.pulseOnDoubleTapAvailable();
    }

    public boolean pulseOnNotificationEnabled(int user) {
        return this.boolSettingDefaultOn("doze_enabled", user) && this.pulseOnNotificationAvailable();
    }

    public boolean pulseOnNotificationAvailable() {
        return this.ambientDisplayAvailable();
    }

    public boolean pulseOnPickupEnabled(int user) {
        return this.boolSettingDefaultOn("doze_pulse_on_pick_up", user) && this.pulseOnPickupAvailable();
    }

    public boolean pulseOnPickupAvailable() {
        return this.mContext.getResources().getBoolean(17956928) && this.ambientDisplayAvailable();
    }

    public boolean pulseOnDoubleTapEnabled(int user) {
        return this.boolSettingDefaultOn("doze_pulse_on_double_tap", user) && this.pulseOnDoubleTapAvailable();
    }

    public boolean pulseOnDoubleTapAvailable() {
        return !TextUtils.isEmpty(this.doubleTapSensorType()) && this.ambientDisplayAvailable();
    }

    public String doubleTapSensorType() {
        return this.mContext.getResources().getString(17039649);
    }

    public boolean alwaysOnEnabled(int user) {
        return this.boolSettingDefaultOff("doze_always_on", user) && this.alwaysOnAvailable();
    }

    public boolean alwaysOnAvailable() {
        return false;
    }

    public String ambientDisplayComponent() {
        return this.mContext.getResources().getString(17039648);
    }

    private boolean ambientDisplayAvailable() {
        return !TextUtils.isEmpty(this.ambientDisplayComponent());
    }

    private boolean boolSettingDefaultOn(String name, int user) {
        return this.boolSetting(name, user, 1);
    }

    private boolean boolSettingDefaultOff(String name, int user) {
        return this.boolSetting(name, user, 0);
    }

    private boolean boolSetting(String name, int user, int def) {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), name, def, user) != 0;
    }
}

