/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.notification;

import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.RemoteException;
import android.provider.Settings;
import java.util.ArrayList;
import java.util.Arrays;

public class SystemNotificationChannels {
    public static String VIRTUAL_KEYBOARD = "VIRTUAL_KEYBOARD";
    public static String PHYSICAL_KEYBOARD = "PHYSICAL_KEYBOARD";
    public static String SECURITY = "SECURITY";
    public static String CAR_MODE = "CAR_MODE";
    public static String ACCOUNT = "ACCOUNT";
    public static String DEVELOPER = "DEVELOPER";
    public static String UPDATES = "UPDATES";
    public static String NETWORK_STATUS = "NETWORK_STATUS";
    public static String NETWORK_ALERTS = "NETWORK_ALERTS";
    public static String NETWORK_AVAILABLE = "NETWORK_AVAILABLE";
    public static String VPN = "VPN";
    public static String DEVICE_ADMIN = "DEVICE_ADMIN";
    public static String ALERTS = "ALERTS";
    public static String RETAIL_MODE = "RETAIL_MODE";
    public static String USB = "USB";
    public static String FOREGROUND_SERVICE = "FOREGROUND_SERVICE";

    public static void createAll(Context context) {
        NotificationManager nm = context.getSystemService(NotificationManager.class);
        ArrayList<NotificationChannel> channelsList = new ArrayList<NotificationChannel>();
        channelsList.add(new NotificationChannel(VIRTUAL_KEYBOARD, context.getString(17040317), 2));
        NotificationChannel physicalKeyboardChannel = new NotificationChannel(PHYSICAL_KEYBOARD, context.getString(17040311), 3);
        physicalKeyboardChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, Notification.AUDIO_ATTRIBUTES_DEFAULT);
        channelsList.add(physicalKeyboardChannel);
        channelsList.add(new NotificationChannel(SECURITY, context.getString(17040313), 2));
        channelsList.add(new NotificationChannel(CAR_MODE, context.getString(17040301), 2));
        channelsList.add(SystemNotificationChannels.newAccountChannel(context));
        channelsList.add(new NotificationChannel(DEVELOPER, context.getString(17040302), 2));
        channelsList.add(new NotificationChannel(UPDATES, context.getString(17040315), 2));
        channelsList.add(new NotificationChannel(NETWORK_STATUS, context.getString(17040310), 2));
        NotificationChannel networkAlertsChannel = new NotificationChannel(NETWORK_ALERTS, context.getString(17040308), 4);
        networkAlertsChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, Notification.AUDIO_ATTRIBUTES_DEFAULT);
        channelsList.add(networkAlertsChannel);
        channelsList.add(new NotificationChannel(NETWORK_AVAILABLE, context.getString(17040309), 2));
        channelsList.add(new NotificationChannel(VPN, context.getString(17040319), 2));
        channelsList.add(new NotificationChannel(DEVICE_ADMIN, context.getString(17040303), 2));
        NotificationChannel alertsChannel = new NotificationChannel(ALERTS, context.getString(17040299), 3);
        alertsChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, Notification.AUDIO_ATTRIBUTES_DEFAULT);
        channelsList.add(alertsChannel);
        channelsList.add(new NotificationChannel(RETAIL_MODE, context.getString(17040312), 2));
        channelsList.add(new NotificationChannel(USB, context.getString(17040316), 1));
        channelsList.add(new NotificationChannel(FOREGROUND_SERVICE, context.getString(17040305), 2));
        nm.createNotificationChannels(channelsList);
    }

    public static void createAccountChannelForPackage(String pkg, int uid, Context context) {
        INotificationManager iNotificationManager = NotificationManager.getService();
        try {
            iNotificationManager.createNotificationChannelsForPackage(pkg, uid, new ParceledListSlice<NotificationChannel>(Arrays.asList(SystemNotificationChannels.newAccountChannel(context))));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static NotificationChannel newAccountChannel(Context context) {
        return new NotificationChannel(ACCOUNT, context.getString(17040298), 2);
    }

    private SystemNotificationChannels() {
    }
}

