/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.os.BatteryStats;
import android.os.Bundle;
import android.os.MemoryFile;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseLongArray;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.BluetoothPowerCalculator;
import com.android.internal.os.CameraPowerCalculator;
import com.android.internal.os.CpuPowerCalculator;
import com.android.internal.os.FlashlightPowerCalculator;
import com.android.internal.os.MemoryPowerCalculator;
import com.android.internal.os.MobileRadioPowerCalculator;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.SensorPowerCalculator;
import com.android.internal.os.WakelockPowerCalculator;
import com.android.internal.os.WifiPowerCalculator;
import com.android.internal.os.WifiPowerEstimator;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class BatteryStatsHelper {
    static final boolean DEBUG = false;
    private static final String TAG = BatteryStatsHelper.class.getSimpleName();
    private static BatteryStats sStatsXfer;
    private static Intent sBatteryBroadcastXfer;
    private static ArrayMap<File, BatteryStats> sFileXfer;
    private final Context mContext;
    private final boolean mCollectBatteryBroadcast;
    private final boolean mWifiOnly;
    private IBatteryStats mBatteryInfo;
    private BatteryStats mStats;
    private Intent mBatteryBroadcast;
    private PowerProfile mPowerProfile;
    private String[] mSystemPackageArray;
    private String[] mServicepackageArray;
    private PackageManager mPackageManager;
    private final List<BatterySipper> mUsageList = new ArrayList<BatterySipper>();
    private final List<BatterySipper> mWifiSippers = new ArrayList<BatterySipper>();
    private final List<BatterySipper> mBluetoothSippers = new ArrayList<BatterySipper>();
    private final SparseArray<List<BatterySipper>> mUserSippers = new SparseArray();
    private final List<BatterySipper> mMobilemsppList = new ArrayList<BatterySipper>();
    private int mStatsType = 0;
    long mRawRealtimeUs;
    long mRawUptimeUs;
    long mBatteryRealtimeUs;
    long mBatteryUptimeUs;
    long mTypeBatteryRealtimeUs;
    long mTypeBatteryUptimeUs;
    long mBatteryTimeRemainingUs;
    long mChargeTimeRemainingUs;
    private long mStatsPeriod = 0L;
    private double mMaxPower = 1.0;
    private double mMaxRealPower = 1.0;
    private double mComputedPower;
    private double mTotalPower;
    private double mMinDrainedPower;
    private double mMaxDrainedPower;
    PowerCalculator mCpuPowerCalculator;
    PowerCalculator mWakelockPowerCalculator;
    MobileRadioPowerCalculator mMobileRadioPowerCalculator;
    PowerCalculator mWifiPowerCalculator;
    PowerCalculator mBluetoothPowerCalculator;
    PowerCalculator mSensorPowerCalculator;
    PowerCalculator mCameraPowerCalculator;
    PowerCalculator mFlashlightPowerCalculator;
    PowerCalculator mMemoryPowerCalculator;
    boolean mHasWifiPowerReporting = false;
    boolean mHasBluetoothPowerReporting = false;

    public static boolean checkWifiOnly(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return !cm.isNetworkSupported(0);
    }

    public static boolean checkHasWifiPowerReporting(BatteryStats stats, PowerProfile profile) {
        return stats.hasWifiActivityReporting() && profile.getAveragePower("wifi.controller.idle") != 0.0 && profile.getAveragePower("wifi.controller.rx") != 0.0 && profile.getAveragePower("wifi.controller.tx") != 0.0;
    }

    public static boolean checkHasBluetoothPowerReporting(BatteryStats stats, PowerProfile profile) {
        return stats.hasBluetoothActivityReporting() && profile.getAveragePower("bluetooth.controller.idle") != 0.0 && profile.getAveragePower("bluetooth.controller.rx") != 0.0 && profile.getAveragePower("bluetooth.controller.tx") != 0.0;
    }

    public BatteryStatsHelper(Context context) {
        this(context, true);
    }

    public BatteryStatsHelper(Context context, boolean collectBatteryBroadcast) {
        this(context, collectBatteryBroadcast, BatteryStatsHelper.checkWifiOnly(context));
    }

    public BatteryStatsHelper(Context context, boolean collectBatteryBroadcast, boolean wifiOnly) {
        this.mContext = context;
        this.mCollectBatteryBroadcast = collectBatteryBroadcast;
        this.mWifiOnly = wifiOnly;
        this.mPackageManager = context.getPackageManager();
        Resources resources = context.getResources();
        this.mSystemPackageArray = resources.getStringArray(0x1070011);
        this.mServicepackageArray = resources.getStringArray(0x1070010);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeStatsHistoryInFile(String fname) {
        ArrayMap<File, BatteryStats> arrayMap = sFileXfer;
        synchronized (arrayMap) {
            File path = BatteryStatsHelper.makeFilePath(this.mContext, fname);
            sFileXfer.put(path, this.getStats());
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(path);
                Parcel hist = Parcel.obtain();
                this.getStats().writeToParcelWithoutUids(hist, 0);
                byte[] histData = hist.marshall();
                fout.write(histData);
            }
            catch (IOException e) {
                Log.w(TAG, "Unable to write history to file", e);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BatteryStats statsFromFile(Context context, String fname) {
        ArrayMap<File, BatteryStats> arrayMap = sFileXfer;
        synchronized (arrayMap) {
            block15: {
                BatteryStats batteryStats;
                File path = BatteryStatsHelper.makeFilePath(context, fname);
                BatteryStats stats = sFileXfer.get(path);
                if (stats != null) {
                    return stats;
                }
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(path);
                    byte[] data = BatteryStatsHelper.readFully(fin);
                    Parcel parcel = Parcel.obtain();
                    parcel.unmarshall(data, 0, data.length);
                    parcel.setDataPosition(0);
                    batteryStats = BatteryStatsImpl.CREATOR.createFromParcel(parcel);
                }
                catch (IOException e) {
                    Log.w(TAG, "Unable to read history to file", e);
                    break block15;
                }
                return batteryStats;
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return BatteryStatsHelper.getStats(IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats")));
        }
    }

    public static void dropFile(Context context, String fname) {
        BatteryStatsHelper.makeFilePath(context, fname).delete();
    }

    private static File makeFilePath(Context context, String fname) {
        return new File(context.getFilesDir(), fname);
    }

    public void clearStats() {
        this.mStats = null;
    }

    public BatteryStats getStats() {
        if (this.mStats == null) {
            this.load();
        }
        return this.mStats;
    }

    public Intent getBatteryBroadcast() {
        if (this.mBatteryBroadcast == null && this.mCollectBatteryBroadcast) {
            this.load();
        }
        return this.mBatteryBroadcast;
    }

    public PowerProfile getPowerProfile() {
        return this.mPowerProfile;
    }

    public void create(BatteryStats stats) {
        this.mPowerProfile = new PowerProfile(this.mContext);
        this.mStats = stats;
    }

    public void create(Bundle icicle) {
        if (icicle != null) {
            this.mStats = sStatsXfer;
            this.mBatteryBroadcast = sBatteryBroadcastXfer;
        }
        this.mBatteryInfo = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mPowerProfile = new PowerProfile(this.mContext);
    }

    public void storeState() {
        sStatsXfer = this.mStats;
        sBatteryBroadcastXfer = this.mBatteryBroadcast;
    }

    public static String makemAh(double power) {
        if (power == 0.0) {
            return "0";
        }
        String format = power < 1.0E-5 ? "%.8f" : (power < 1.0E-4 ? "%.7f" : (power < 0.001 ? "%.6f" : (power < 0.01 ? "%.5f" : (power < 0.1 ? "%.4f" : (power < 1.0 ? "%.3f" : (power < 10.0 ? "%.2f" : (power < 100.0 ? "%.1f" : "%.0f")))))));
        return String.format(Locale.ENGLISH, format, power);
    }

    public void refreshStats(int statsType, int asUser) {
        SparseArray<UserHandle> users = new SparseArray<UserHandle>(1);
        users.put(asUser, new UserHandle(asUser));
        this.refreshStats(statsType, users);
    }

    public void refreshStats(int statsType, List<UserHandle> asUsers) {
        int n = asUsers.size();
        SparseArray<UserHandle> users = new SparseArray<UserHandle>(n);
        for (int i = 0; i < n; ++i) {
            UserHandle userHandle = asUsers.get(i);
            users.put(userHandle.getIdentifier(), userHandle);
        }
        this.refreshStats(statsType, users);
    }

    public void refreshStats(int statsType, SparseArray<UserHandle> asUsers) {
        this.refreshStats(statsType, asUsers, SystemClock.elapsedRealtime() * 1000L, SystemClock.uptimeMillis() * 1000L);
    }

    public void refreshStats(int statsType, SparseArray<UserHandle> asUsers, long rawRealtimeUs, long rawUptimeUs) {
        int i;
        this.getStats();
        this.mMaxPower = 0.0;
        this.mMaxRealPower = 0.0;
        this.mComputedPower = 0.0;
        this.mTotalPower = 0.0;
        this.mUsageList.clear();
        this.mWifiSippers.clear();
        this.mBluetoothSippers.clear();
        this.mUserSippers.clear();
        this.mMobilemsppList.clear();
        if (this.mStats == null) {
            return;
        }
        if (this.mCpuPowerCalculator == null) {
            this.mCpuPowerCalculator = new CpuPowerCalculator(this.mPowerProfile);
        }
        this.mCpuPowerCalculator.reset();
        if (this.mMemoryPowerCalculator == null) {
            this.mMemoryPowerCalculator = new MemoryPowerCalculator(this.mPowerProfile);
        }
        this.mMemoryPowerCalculator.reset();
        if (this.mWakelockPowerCalculator == null) {
            this.mWakelockPowerCalculator = new WakelockPowerCalculator(this.mPowerProfile);
        }
        this.mWakelockPowerCalculator.reset();
        if (this.mMobileRadioPowerCalculator == null) {
            this.mMobileRadioPowerCalculator = new MobileRadioPowerCalculator(this.mPowerProfile, this.mStats);
        }
        this.mMobileRadioPowerCalculator.reset(this.mStats);
        boolean hasWifiPowerReporting = BatteryStatsHelper.checkHasWifiPowerReporting(this.mStats, this.mPowerProfile);
        if (this.mWifiPowerCalculator == null || hasWifiPowerReporting != this.mHasWifiPowerReporting) {
            this.mWifiPowerCalculator = hasWifiPowerReporting ? new WifiPowerCalculator(this.mPowerProfile) : new WifiPowerEstimator(this.mPowerProfile);
            this.mHasWifiPowerReporting = hasWifiPowerReporting;
        }
        this.mWifiPowerCalculator.reset();
        boolean hasBluetoothPowerReporting = BatteryStatsHelper.checkHasBluetoothPowerReporting(this.mStats, this.mPowerProfile);
        if (this.mBluetoothPowerCalculator == null || hasBluetoothPowerReporting != this.mHasBluetoothPowerReporting) {
            this.mBluetoothPowerCalculator = new BluetoothPowerCalculator(this.mPowerProfile);
            this.mHasBluetoothPowerReporting = hasBluetoothPowerReporting;
        }
        this.mBluetoothPowerCalculator.reset();
        if (this.mSensorPowerCalculator == null) {
            this.mSensorPowerCalculator = new SensorPowerCalculator(this.mPowerProfile, (SensorManager)this.mContext.getSystemService("sensor"));
        }
        this.mSensorPowerCalculator.reset();
        if (this.mCameraPowerCalculator == null) {
            this.mCameraPowerCalculator = new CameraPowerCalculator(this.mPowerProfile);
        }
        this.mCameraPowerCalculator.reset();
        if (this.mFlashlightPowerCalculator == null) {
            this.mFlashlightPowerCalculator = new FlashlightPowerCalculator(this.mPowerProfile);
        }
        this.mFlashlightPowerCalculator.reset();
        this.mStatsType = statsType;
        this.mRawUptimeUs = rawUptimeUs;
        this.mRawRealtimeUs = rawRealtimeUs;
        this.mBatteryUptimeUs = this.mStats.getBatteryUptime(rawUptimeUs);
        this.mBatteryRealtimeUs = this.mStats.getBatteryRealtime(rawRealtimeUs);
        this.mTypeBatteryUptimeUs = this.mStats.computeBatteryUptime(rawUptimeUs, this.mStatsType);
        this.mTypeBatteryRealtimeUs = this.mStats.computeBatteryRealtime(rawRealtimeUs, this.mStatsType);
        this.mBatteryTimeRemainingUs = this.mStats.computeBatteryTimeRemaining(rawRealtimeUs);
        this.mChargeTimeRemainingUs = this.mStats.computeChargeTimeRemaining(rawRealtimeUs);
        this.mMinDrainedPower = (double)this.mStats.getLowDischargeAmountSinceCharge() * this.mPowerProfile.getBatteryCapacity() / 100.0;
        this.mMaxDrainedPower = (double)this.mStats.getHighDischargeAmountSinceCharge() * this.mPowerProfile.getBatteryCapacity() / 100.0;
        this.processAppUsage(asUsers);
        for (i = 0; i < this.mUsageList.size(); ++i) {
            BatterySipper bs = this.mUsageList.get(i);
            bs.computeMobilemspp();
            if (bs.mobilemspp == 0.0) continue;
            this.mMobilemsppList.add(bs);
        }
        for (i = 0; i < this.mUserSippers.size(); ++i) {
            List<BatterySipper> user = this.mUserSippers.valueAt(i);
            for (int j = 0; j < user.size(); ++j) {
                BatterySipper bs = user.get(j);
                bs.computeMobilemspp();
                if (bs.mobilemspp == 0.0) continue;
                this.mMobilemsppList.add(bs);
            }
        }
        Collections.sort(this.mMobilemsppList, new Comparator<BatterySipper>(){

            @Override
            public int compare(BatterySipper lhs, BatterySipper rhs) {
                return Double.compare(rhs.mobilemspp, lhs.mobilemspp);
            }
        });
        this.processMiscUsage();
        Collections.sort(this.mUsageList);
        if (!this.mUsageList.isEmpty()) {
            this.mMaxRealPower = this.mMaxPower = this.mUsageList.get((int)0).totalPowerMah;
            int usageListCount = this.mUsageList.size();
            for (int i2 = 0; i2 < usageListCount; ++i2) {
                this.mComputedPower += this.mUsageList.get((int)i2).totalPowerMah;
            }
        }
        this.mTotalPower = this.mComputedPower;
        if (this.mStats.getLowDischargeAmountSinceCharge() > 1) {
            double amount;
            if (this.mMinDrainedPower > this.mComputedPower) {
                amount = this.mMinDrainedPower - this.mComputedPower;
                this.mTotalPower = this.mMinDrainedPower;
                BatterySipper bs = new BatterySipper(BatterySipper.DrainType.UNACCOUNTED, null, amount);
                int index = Collections.binarySearch(this.mUsageList, bs);
                if (index < 0) {
                    index = -(index + 1);
                }
                this.mUsageList.add(index, bs);
                this.mMaxPower = Math.max(this.mMaxPower, amount);
            } else if (this.mMaxDrainedPower < this.mComputedPower) {
                amount = this.mComputedPower - this.mMaxDrainedPower;
                BatterySipper bs = new BatterySipper(BatterySipper.DrainType.OVERCOUNTED, null, amount);
                int index = Collections.binarySearch(this.mUsageList, bs);
                if (index < 0) {
                    index = -(index + 1);
                }
                this.mUsageList.add(index, bs);
                this.mMaxPower = Math.max(this.mMaxPower, amount);
            }
        }
        double hiddenPowerMah = this.removeHiddenBatterySippers(this.mUsageList);
        double totalRemainingPower = this.getTotalPower() - hiddenPowerMah;
        if (Math.abs(totalRemainingPower) > 0.001) {
            int size = this.mUsageList.size();
            for (int i3 = 0; i3 < size; ++i3) {
                BatterySipper sipper = this.mUsageList.get(i3);
                if (sipper.shouldHide) continue;
                sipper.proportionalSmearMah = hiddenPowerMah * ((sipper.totalPowerMah + sipper.screenPowerMah) / totalRemainingPower);
                sipper.sumPower();
            }
        }
    }

    private void processAppUsage(SparseArray<UserHandle> asUsers) {
        boolean forAllUsers = asUsers.get(-1) != null;
        this.mStatsPeriod = this.mTypeBatteryRealtimeUs;
        BatterySipper osSipper = null;
        SparseArray<? extends BatteryStats.Uid> uidStats = this.mStats.getUidStats();
        int NU = uidStats.size();
        for (int iu = 0; iu < NU; ++iu) {
            BatteryStats.Uid u = uidStats.valueAt(iu);
            BatterySipper app = new BatterySipper(BatterySipper.DrainType.APP, u, 0.0);
            this.mCpuPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mWakelockPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mMobileRadioPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mWifiPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mBluetoothPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mSensorPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mCameraPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mFlashlightPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            double totalPower = app.sumPower();
            if (totalPower == 0.0 && u.getUid() != 0) continue;
            int uid = app.getUid();
            int userId = UserHandle.getUserId(uid);
            if (uid == 1010) {
                this.mWifiSippers.add(app);
            } else if (uid == 1002) {
                this.mBluetoothSippers.add(app);
            } else if (!forAllUsers && asUsers.get(userId) == null && UserHandle.getAppId(uid) >= 10000) {
                List<BatterySipper> list = this.mUserSippers.get(userId);
                if (list == null) {
                    list = new ArrayList<BatterySipper>();
                    this.mUserSippers.put(userId, list);
                }
                list.add(app);
            } else {
                this.mUsageList.add(app);
            }
            if (uid != 0) continue;
            osSipper = app;
        }
        if (osSipper != null) {
            this.mWakelockPowerCalculator.calculateRemaining(osSipper, this.mStats, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            osSipper.sumPower();
        }
    }

    private void addPhoneUsage() {
        long phoneOnTimeMs = this.mStats.getPhoneOnTime(this.mRawRealtimeUs, this.mStatsType) / 1000L;
        double phoneOnPower = this.mPowerProfile.getAveragePower("radio.active") * (double)phoneOnTimeMs / 3600000.0;
        if (phoneOnPower != 0.0) {
            this.addEntry(BatterySipper.DrainType.PHONE, phoneOnTimeMs, phoneOnPower);
        }
    }

    private void addScreenUsage() {
        double power = 0.0;
        long screenOnTimeMs = this.mStats.getScreenOnTime(this.mRawRealtimeUs, this.mStatsType) / 1000L;
        power += (double)screenOnTimeMs * this.mPowerProfile.getAveragePower("screen.on");
        double screenFullPower = this.mPowerProfile.getAveragePower("screen.full");
        for (int i = 0; i < 5; ++i) {
            double screenBinPower = screenFullPower * (double)((float)i + 0.5f) / 5.0;
            long brightnessTime = this.mStats.getScreenBrightnessTime(i, this.mRawRealtimeUs, this.mStatsType) / 1000L;
            double p = screenBinPower * (double)brightnessTime;
            power += p;
        }
        if ((power /= 3600000.0) != 0.0) {
            this.addEntry(BatterySipper.DrainType.SCREEN, screenOnTimeMs, power);
        }
    }

    private void addRadioUsage() {
        BatterySipper radio = new BatterySipper(BatterySipper.DrainType.CELL, null, 0.0);
        this.mMobileRadioPowerCalculator.calculateRemaining(radio, this.mStats, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
        radio.sumPower();
        if (radio.totalPowerMah > 0.0) {
            this.mUsageList.add(radio);
        }
    }

    private void aggregateSippers(BatterySipper bs, List<BatterySipper> from, String tag) {
        for (int i = 0; i < from.size(); ++i) {
            BatterySipper wbs = from.get(i);
            bs.add(wbs);
        }
        bs.computeMobilemspp();
        bs.sumPower();
    }

    private void addIdleUsage() {
        double idlePowerMaMs;
        double suspendPowerMaMs = (double)(this.mTypeBatteryRealtimeUs / 1000L) * this.mPowerProfile.getAveragePower("cpu.idle");
        double totalPowerMah = (suspendPowerMaMs + (idlePowerMaMs = (double)(this.mTypeBatteryUptimeUs / 1000L) * this.mPowerProfile.getAveragePower("cpu.awake"))) / 3600000.0;
        if (totalPowerMah != 0.0) {
            this.addEntry(BatterySipper.DrainType.IDLE, this.mTypeBatteryRealtimeUs / 1000L, totalPowerMah);
        }
    }

    private void addWiFiUsage() {
        BatterySipper bs = new BatterySipper(BatterySipper.DrainType.WIFI, null, 0.0);
        this.mWifiPowerCalculator.calculateRemaining(bs, this.mStats, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
        this.aggregateSippers(bs, this.mWifiSippers, "WIFI");
        if (bs.totalPowerMah > 0.0) {
            this.mUsageList.add(bs);
        }
    }

    private void addBluetoothUsage() {
        BatterySipper bs = new BatterySipper(BatterySipper.DrainType.BLUETOOTH, null, 0.0);
        this.mBluetoothPowerCalculator.calculateRemaining(bs, this.mStats, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
        this.aggregateSippers(bs, this.mBluetoothSippers, "Bluetooth");
        if (bs.totalPowerMah > 0.0) {
            this.mUsageList.add(bs);
        }
    }

    private void addUserUsage() {
        for (int i = 0; i < this.mUserSippers.size(); ++i) {
            int userId = this.mUserSippers.keyAt(i);
            BatterySipper bs = new BatterySipper(BatterySipper.DrainType.USER, null, 0.0);
            bs.userId = userId;
            this.aggregateSippers(bs, this.mUserSippers.valueAt(i), "User");
            this.mUsageList.add(bs);
        }
    }

    private void addMemoryUsage() {
        BatterySipper memory = new BatterySipper(BatterySipper.DrainType.MEMORY, null, 0.0);
        this.mMemoryPowerCalculator.calculateRemaining(memory, this.mStats, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
        memory.sumPower();
        if (memory.totalPowerMah > 0.0) {
            this.mUsageList.add(memory);
        }
    }

    private void processMiscUsage() {
        this.addUserUsage();
        this.addPhoneUsage();
        this.addScreenUsage();
        this.addWiFiUsage();
        this.addBluetoothUsage();
        this.addMemoryUsage();
        this.addIdleUsage();
        if (!this.mWifiOnly) {
            this.addRadioUsage();
        }
    }

    private BatterySipper addEntry(BatterySipper.DrainType drainType, long time, double power) {
        BatterySipper bs = new BatterySipper(drainType, null, 0.0);
        bs.usagePowerMah = power;
        bs.usageTimeMs = time;
        bs.sumPower();
        this.mUsageList.add(bs);
        return bs;
    }

    public List<BatterySipper> getUsageList() {
        return this.mUsageList;
    }

    public List<BatterySipper> getMobilemsppList() {
        return this.mMobilemsppList;
    }

    public long getStatsPeriod() {
        return this.mStatsPeriod;
    }

    public int getStatsType() {
        return this.mStatsType;
    }

    public double getMaxPower() {
        return this.mMaxPower;
    }

    public double getMaxRealPower() {
        return this.mMaxRealPower;
    }

    public double getTotalPower() {
        return this.mTotalPower;
    }

    public double getComputedPower() {
        return this.mComputedPower;
    }

    public double getMinDrainedPower() {
        return this.mMinDrainedPower;
    }

    public double getMaxDrainedPower() {
        return this.mMaxDrainedPower;
    }

    public static byte[] readFully(FileInputStream stream) throws IOException {
        return BatteryStatsHelper.readFully(stream, stream.available());
    }

    public static byte[] readFully(FileInputStream stream, int avail) throws IOException {
        int pos = 0;
        byte[] data = new byte[avail];
        int amt;
        while ((amt = stream.read(data, pos, data.length - pos)) > 0) {
            avail = stream.available();
            if (avail <= data.length - (pos += amt)) continue;
            byte[] newData = new byte[pos + avail];
            System.arraycopy((byte[])data, (int)0, (byte[])newData, (int)0, (int)pos);
            data = newData;
        }
        return data;
    }

    public double removeHiddenBatterySippers(List<BatterySipper> sippers) {
        double proportionalSmearPowerMah = 0.0;
        BatterySipper screenSipper = null;
        for (int i = sippers.size() - 1; i >= 0; --i) {
            BatterySipper sipper = sippers.get(i);
            sipper.shouldHide = this.shouldHideSipper(sipper);
            if (sipper.shouldHide && sipper.drainType != BatterySipper.DrainType.OVERCOUNTED && sipper.drainType != BatterySipper.DrainType.SCREEN && sipper.drainType != BatterySipper.DrainType.UNACCOUNTED) {
                proportionalSmearPowerMah += sipper.totalPowerMah;
            }
            if (sipper.drainType != BatterySipper.DrainType.SCREEN) continue;
            screenSipper = sipper;
        }
        this.smearScreenBatterySipper(sippers, screenSipper);
        return proportionalSmearPowerMah;
    }

    public void smearScreenBatterySipper(List<BatterySipper> sippers, BatterySipper screenSipper) {
        long rawRealtimeMs = SystemClock.elapsedRealtime();
        long totalActivityTimeMs = 0L;
        SparseLongArray activityTimeArray = new SparseLongArray();
        int size = sippers.size();
        for (int i = 0; i < size; ++i) {
            BatteryStats.Uid uid = sippers.get((int)i).uidObj;
            if (uid == null) continue;
            long timeMs = this.getForegroundActivityTotalTimeMs(uid, rawRealtimeMs);
            activityTimeArray.put(uid.getUid(), timeMs);
            totalActivityTimeMs += timeMs;
        }
        if (totalActivityTimeMs >= 600000L) {
            double screenPowerMah = screenSipper.totalPowerMah;
            int size2 = sippers.size();
            for (int i = 0; i < size2; ++i) {
                BatterySipper sipper = sippers.get(i);
                sipper.screenPowerMah = screenPowerMah * (double)activityTimeArray.get(sipper.getUid(), 0L) / (double)totalActivityTimeMs;
            }
        }
    }

    public boolean shouldHideSipper(BatterySipper sipper) {
        BatterySipper.DrainType drainType = sipper.drainType;
        return drainType == BatterySipper.DrainType.IDLE || drainType == BatterySipper.DrainType.CELL || drainType == BatterySipper.DrainType.SCREEN || drainType == BatterySipper.DrainType.UNACCOUNTED || drainType == BatterySipper.DrainType.OVERCOUNTED || this.isTypeService(sipper) || this.isTypeSystem(sipper);
    }

    public boolean isTypeService(BatterySipper sipper) {
        String[] packages = this.mPackageManager.getPackagesForUid(sipper.getUid());
        if (packages == null) {
            return false;
        }
        for (String packageName : packages) {
            if (!ArrayUtils.contains(this.mServicepackageArray, packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeSystem(BatterySipper sipper) {
        int uid = sipper.uidObj == null ? -1 : sipper.getUid();
        sipper.mPackages = this.mPackageManager.getPackagesForUid(uid);
        if (uid >= 0 && uid < 10000) {
            return true;
        }
        if (sipper.mPackages != null) {
            for (String packageName : sipper.mPackages) {
                if (!ArrayUtils.contains(this.mSystemPackageArray, packageName)) continue;
                return true;
            }
        }
        return false;
    }

    public long getForegroundActivityTotalTimeMs(BatteryStats.Uid uid, long rawRealtimeMs) {
        BatteryStats.Timer timer = uid.getForegroundActivityTimer();
        if (timer != null) {
            return timer.getTotalTimeLocked(rawRealtimeMs, 0);
        }
        return 0L;
    }

    public void setPackageManager(PackageManager packageManager) {
        this.mPackageManager = packageManager;
    }

    public void setSystemPackageArray(String[] array2) {
        this.mSystemPackageArray = array2;
    }

    public void setServicePackageArray(String[] array2) {
        this.mServicepackageArray = array2;
    }

    private void load() {
        if (this.mBatteryInfo == null) {
            return;
        }
        this.mStats = BatteryStatsHelper.getStats(this.mBatteryInfo);
        if (this.mCollectBatteryBroadcast) {
            this.mBatteryBroadcast = this.mContext.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BatteryStatsImpl getStats(IBatteryStats service) {
        try {
            ParcelFileDescriptor pfd = service.getStatisticsStream();
            if (pfd == null) return new BatteryStatsImpl();
            try (ParcelFileDescriptor.AutoCloseInputStream fis = new ParcelFileDescriptor.AutoCloseInputStream(pfd);){
                BatteryStatsImpl stats;
                byte[] data = BatteryStatsHelper.readFully(fis, MemoryFile.getSize(pfd.getFileDescriptor()));
                Parcel parcel = Parcel.obtain();
                parcel.unmarshall(data, 0, data.length);
                parcel.setDataPosition(0);
                BatteryStatsImpl batteryStatsImpl = stats = BatteryStatsImpl.CREATOR.createFromParcel(parcel);
                return batteryStatsImpl;
            }
            catch (IOException e) {
                Log.w(TAG, "Unable to read statistics stream", e);
                return new BatteryStatsImpl();
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "RemoteException:", e);
        }
        return new BatteryStatsImpl();
    }

    static {
        sFileXfer = new ArrayMap();
    }
}

