/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import libcore.io.Libcore;

public class KernelCpuSpeedReader {
    private static final String TAG = "KernelCpuSpeedReader";
    private final String mProcFile;
    private final long[] mLastSpeedTimes;
    private final long[] mDeltaSpeedTimes;
    private final long mJiffyMillis;

    public KernelCpuSpeedReader(int cpuNumber, int numSpeedSteps) {
        this.mProcFile = String.format("/sys/devices/system/cpu/cpu%d/cpufreq/stats/time_in_state", cpuNumber);
        this.mLastSpeedTimes = new long[numSpeedSteps];
        this.mDeltaSpeedTimes = new long[numSpeedSteps];
        long jiffyHz = Libcore.os.sysconf(OsConstants._SC_CLK_TCK);
        this.mJiffyMillis = 1000L / jiffyHz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] readDelta() {
        StrictMode.ThreadPolicy policy = StrictMode.allowThreadDiskReads();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.mProcFile));){
            String line;
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
            for (int speedIndex = 0; speedIndex < this.mLastSpeedTimes.length && (line = reader.readLine()) != null; ++speedIndex) {
                splitter.setString(line);
                Long.parseLong(splitter.next());
                long time = Long.parseLong(splitter.next()) * this.mJiffyMillis;
                this.mDeltaSpeedTimes[speedIndex] = time < this.mLastSpeedTimes[speedIndex] ? time : time - this.mLastSpeedTimes[speedIndex];
                this.mLastSpeedTimes[speedIndex] = time;
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read cpu-freq: " + e.getMessage());
            Arrays.fill(this.mDeltaSpeedTimes, 0L);
        }
        finally {
            StrictMode.setThreadPolicy(policy);
        }
        return this.mDeltaSpeedTimes;
    }
}

