/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.util.Slog;
import android.util.SparseArray;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class KernelUidCpuFreqTimeReader {
    private static final String TAG = "KernelUidCpuFreqTimeReader";
    private static final String UID_TIMES_PROC_FILE = "/proc/uid_time_in_state";
    private long[] mCpuFreqs;
    private int mCpuFreqsCount;
    private SparseArray<long[]> mLastUidCpuFreqTimeMs = new SparseArray();
    private static final int TOTAL_READ_ERROR_COUNT = 5;
    private int mReadErrorCounter;
    private boolean mProcFileAvailable;

    public void readDelta(Callback callback) {
        if (!this.mProcFileAvailable && this.mReadErrorCounter >= 5) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(UID_TIMES_PROC_FILE));){
            this.readDelta(reader, callback);
            this.mProcFileAvailable = true;
        }
        catch (IOException e) {
            ++this.mReadErrorCounter;
            Slog.e(TAG, "Failed to read /proc/uid_time_in_state: " + e);
        }
    }

    public void removeUid(int uid) {
        this.mLastUidCpuFreqTimeMs.delete(uid);
    }

    public void readDelta(BufferedReader reader, Callback callback) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return;
        }
        this.readCpuFreqs(line, callback);
        while ((line = reader.readLine()) != null) {
            int index = line.indexOf(32);
            int uid = Integer.parseInt(line.substring(0, index - 1), 10);
            this.readTimesForUid(uid, line.substring(index + 1, line.length()), callback);
        }
    }

    private void readTimesForUid(int uid, String line, Callback callback) {
        String[] timesStr;
        int size;
        long[] uidTimeMs = this.mLastUidCpuFreqTimeMs.get(uid);
        if (uidTimeMs == null) {
            uidTimeMs = new long[this.mCpuFreqsCount];
            this.mLastUidCpuFreqTimeMs.put(uid, uidTimeMs);
        }
        if ((size = (timesStr = line.split(" ")).length) != uidTimeMs.length) {
            Slog.e(TAG, "No. of readings don't match cpu freqs, readings: " + size + " cpuFreqsCount: " + uidTimeMs.length);
            return;
        }
        long[] deltaUidTimeMs = new long[size];
        for (int i = 0; i < size; ++i) {
            long totalTimeMs = Long.parseLong(timesStr[i], 10) * 10L;
            deltaUidTimeMs[i] = totalTimeMs - uidTimeMs[i];
            uidTimeMs[i] = totalTimeMs;
        }
        if (callback != null) {
            callback.onUidCpuFreqTime(uid, deltaUidTimeMs);
        }
    }

    private void readCpuFreqs(String line, Callback callback) {
        if (this.mCpuFreqs == null) {
            String[] freqStr = line.split(" ");
            this.mCpuFreqsCount = freqStr.length - 1;
            this.mCpuFreqs = new long[this.mCpuFreqsCount];
            for (int i = 0; i < this.mCpuFreqsCount; ++i) {
                this.mCpuFreqs[i] = Long.parseLong(freqStr[i + 1], 10);
            }
        }
        if (callback != null) {
            callback.onCpuFreqs(this.mCpuFreqs);
        }
    }

    public static interface Callback {
        public void onCpuFreqs(long[] var1);

        public void onUidCpuFreqTime(int var1, long[] var2);
    }
}

