/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.provider.Settings;
import android.telephony.Rlog;
import android.util.LocalLog;
import com.android.internal.telephony.Phone;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;

public class CarrierActionAgent
extends Handler {
    private static final String LOG_TAG = "CarrierActionAgent";
    private static final boolean DBG = true;
    private static final boolean VDBG = Rlog.isLoggable("CarrierActionAgent", 2);
    public static final int CARRIER_ACTION_SET_METERED_APNS_ENABLED = 0;
    public static final int CARRIER_ACTION_SET_RADIO_ENABLED = 1;
    public static final int CARRIER_ACTION_RESET = 2;
    private final Phone mPhone;
    private RegistrantList mMeteredApnEnableRegistrants = new RegistrantList();
    private RegistrantList mRadioEnableRegistrants = new RegistrantList();
    private LocalLog mMeteredApnEnabledLog = new LocalLog(10);
    private LocalLog mRadioEnabledLog = new LocalLog(10);
    private Boolean mCarrierActionOnMeteredApnEnabled = true;
    private Boolean mCarrierActionOnRadioEnabled = true;
    private final SettingsObserver mSettingsObserver;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            String iccState = intent.getStringExtra("ss");
            if ("android.intent.action.SIM_STATE_CHANGED".equals(action)) {
                if (intent.getBooleanExtra("rebroadcastOnUnlock", false)) {
                    return;
                }
                if ("LOADED".equals(iccState) || "ABSENT".equals(iccState)) {
                    CarrierActionAgent.this.sendEmptyMessage(2);
                }
            }
        }
    };

    public CarrierActionAgent(Phone phone) {
        this.mPhone = phone;
        this.mPhone.getContext().registerReceiver(this.mReceiver, new IntentFilter("android.intent.action.SIM_STATE_CHANGED"));
        this.mSettingsObserver = new SettingsObserver();
        this.mPhone.getContext().getContentResolver().registerContentObserver(Settings.Global.getUriFor("airplane_mode_on"), false, this.mSettingsObserver);
        this.log("Creating CarrierActionAgent");
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.mCarrierActionOnMeteredApnEnabled = (boolean)((Boolean)msg.obj);
                this.log("SET_METERED_APNS_ENABLED: " + this.mCarrierActionOnMeteredApnEnabled);
                this.mMeteredApnEnabledLog.log("SET_METERED_APNS_ENABLED: " + this.mCarrierActionOnMeteredApnEnabled);
                this.mMeteredApnEnableRegistrants.notifyRegistrants(new AsyncResult(null, this.mCarrierActionOnMeteredApnEnabled, null));
                break;
            }
            case 1: {
                this.mCarrierActionOnRadioEnabled = (boolean)((Boolean)msg.obj);
                this.log("SET_RADIO_ENABLED: " + this.mCarrierActionOnRadioEnabled);
                this.mRadioEnabledLog.log("SET_RADIO_ENABLED: " + this.mCarrierActionOnRadioEnabled);
                this.mRadioEnableRegistrants.notifyRegistrants(new AsyncResult(null, this.mCarrierActionOnRadioEnabled, null));
                break;
            }
            case 2: {
                this.log("CARRIER_ACTION_RESET");
                this.carrierActionSetMeteredApnsEnabled(true);
                this.carrierActionSetRadioEnabled(true);
                this.mPhone.getCarrierSignalAgent().notifyCarrierSignalReceivers(new Intent("com.android.internal.telephony.CARRIER_SIGNAL_RESET"));
                break;
            }
            default: {
                this.loge("Unknown carrier action: " + msg.what);
            }
        }
    }

    public Object getCarrierActionValue(int action) {
        Object val = this.getCarrierAction(action);
        if (val == null) {
            throw new IllegalArgumentException("invalid carrier action: " + action);
        }
        return val;
    }

    public void carrierActionSetRadioEnabled(boolean enabled) {
        this.sendMessage(this.obtainMessage(1, enabled));
    }

    public void carrierActionSetMeteredApnsEnabled(boolean enabled) {
        this.sendMessage(this.obtainMessage(0, enabled));
    }

    private RegistrantList getRegistrantsFromAction(int action) {
        switch (action) {
            case 0: {
                return this.mMeteredApnEnableRegistrants;
            }
            case 1: {
                return this.mRadioEnableRegistrants;
            }
        }
        this.loge("Unsupported action: " + action);
        return null;
    }

    private Object getCarrierAction(int action) {
        switch (action) {
            case 0: {
                return this.mCarrierActionOnMeteredApnEnabled;
            }
            case 1: {
                return this.mCarrierActionOnRadioEnabled;
            }
        }
        this.loge("Unsupported action: " + action);
        return null;
    }

    public void registerForCarrierAction(int action, Handler h, int what, Object obj, boolean notifyNow) {
        Object carrierAction = this.getCarrierAction(action);
        if (carrierAction == null) {
            throw new IllegalArgumentException("invalid carrier action: " + action);
        }
        RegistrantList list = this.getRegistrantsFromAction(action);
        Registrant r = new Registrant(h, what, obj);
        list.add(r);
        if (notifyNow) {
            r.notifyRegistrant(new AsyncResult(null, carrierAction, null));
        }
    }

    public void unregisterForCarrierAction(Handler h, int action) {
        RegistrantList list = this.getRegistrantsFromAction(action);
        if (list == null) {
            throw new IllegalArgumentException("invalid carrier action: " + action);
        }
        list.remove(h);
    }

    public ContentObserver getContentObserver() {
        return this.mSettingsObserver;
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private void loge(String s) {
        Rlog.e(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private void logv(String s) {
        Rlog.v(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        pw.println(" mCarrierActionOnMeteredApnsEnabled Log:");
        ipw.increaseIndent();
        this.mMeteredApnEnabledLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        pw.println(" mCarrierActionOnRadioEnabled Log:");
        ipw.increaseIndent();
        this.mRadioEnabledLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
    }

    private class SettingsObserver
    extends ContentObserver {
        SettingsObserver() {
            super(null);
        }

        @Override
        public void onChange(boolean selfChange) {
            if (Settings.Global.getInt(CarrierActionAgent.this.mPhone.getContext().getContentResolver(), "airplane_mode_on", 0) != 0) {
                CarrierActionAgent.this.sendEmptyMessage(2);
            }
        }
    }
}

