/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.Phone;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CarrierSignalAgent {
    private static final String LOG_TAG = CarrierSignalAgent.class.getSimpleName();
    private static final boolean DBG = true;
    private static final boolean VDBG = Rlog.isLoggable(LOG_TAG, 2);
    private static final boolean WAKE = true;
    private static final boolean NO_WAKE = false;
    private static final String COMPONENT_NAME_DELIMITER = "\\s*:\\s*";
    private static final String CARRIER_SIGNAL_DELIMITER = "\\s*,\\s*";
    private final Phone mPhone;
    private final Map<String, List<ComponentName>> mCachedWakeSignalConfigs = new HashMap<String, List<ComponentName>>();
    private final Map<String, List<ComponentName>> mCachedNoWakeSignalConfigs = new HashMap<String, List<ComponentName>>();
    private final Set<String> mCarrierSignalList = new HashSet<String>(Arrays.asList("com.android.internal.telephony.CARRIER_SIGNAL_PCO_VALUE", "com.android.internal.telephony.CARRIER_SIGNAL_REDIRECTED", "com.android.internal.telephony.CARRIER_SIGNAL_REQUEST_NETWORK_FAILED", "com.android.internal.telephony.CARRIER_SIGNAL_RESET"));
    private final LocalLog mErrorLocalLog = new LocalLog(20);
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            CarrierSignalAgent.this.log("CarrierSignalAgent receiver action: " + action);
            if (action.equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                if (CarrierSignalAgent.this.mPhone.getIccCard() != null && IccCardConstants.State.ABSENT == CarrierSignalAgent.this.mPhone.getIccCard().getState()) {
                    CarrierSignalAgent.this.notifyCarrierSignalReceivers(new Intent("com.android.internal.telephony.CARRIER_SIGNAL_RESET"));
                }
                CarrierSignalAgent.this.loadCarrierConfig();
            }
        }
    };

    public CarrierSignalAgent(Phone phone) {
        this.mPhone = phone;
        this.loadCarrierConfig();
        this.mPhone.getContext().registerReceiver(this.mReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCarrierConfig() {
        CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        PersistableBundle b = null;
        if (configManager != null) {
            b = configManager.getConfig();
        }
        if (b != null) {
            Map<String, List<ComponentName>> map = this.mCachedWakeSignalConfigs;
            synchronized (map) {
                this.mCachedWakeSignalConfigs.clear();
                this.log("Loading carrier config: carrier_app_wake_signal_config");
                this.parseAndCache(b.getStringArray("carrier_app_wake_signal_config"), this.mCachedWakeSignalConfigs);
            }
            map = this.mCachedNoWakeSignalConfigs;
            synchronized (map) {
                this.mCachedNoWakeSignalConfigs.clear();
                this.log("Loading carrier config: carrier_app_no_wake_signal_config");
                this.parseAndCache(b.getStringArray("carrier_app_no_wake_signal_config"), this.mCachedNoWakeSignalConfigs);
            }
        }
    }

    private void parseAndCache(String[] configs, Map<String, List<ComponentName>> cachedConfigs) {
        if (!ArrayUtils.isEmpty(configs)) {
            for (String config : configs) {
                if (TextUtils.isEmpty(config)) continue;
                String[] splitStr = config.trim().split(COMPONENT_NAME_DELIMITER, 2);
                if (splitStr.length == 2) {
                    String[] signals;
                    ComponentName componentName = ComponentName.unflattenFromString(splitStr[0]);
                    if (componentName == null) {
                        this.loge("Invalid component name: " + splitStr[0]);
                        continue;
                    }
                    for (String s : signals = splitStr[1].split(CARRIER_SIGNAL_DELIMITER)) {
                        if (!this.mCarrierSignalList.contains(s)) {
                            this.loge("Invalid signal name: " + s);
                            continue;
                        }
                        List<ComponentName> componentList = cachedConfigs.get(s);
                        if (componentList == null) {
                            componentList = new ArrayList<ComponentName>();
                            cachedConfigs.put(s, componentList);
                        }
                        componentList.add(componentName);
                        if (!VDBG) continue;
                        this.logv("Add config {signal: " + s + " componentName: " + componentName + "}");
                    }
                    continue;
                }
                this.loge("invalid config format: " + config);
            }
        }
    }

    public boolean hasRegisteredReceivers(String action) {
        return this.mCachedWakeSignalConfigs.containsKey(action) || this.mCachedNoWakeSignalConfigs.containsKey(action);
    }

    private void broadcast(Intent intent, List<ComponentName> receivers, boolean wakeup) {
        PackageManager packageManager = this.mPhone.getContext().getPackageManager();
        for (ComponentName name : receivers) {
            Intent signal = new Intent(intent);
            signal.setComponent(name);
            if (wakeup && packageManager.queryBroadcastReceivers(signal, 65536).isEmpty()) {
                this.loge("Carrier signal receivers are configured but unavailable: " + signal.getComponent());
                return;
            }
            if (!wakeup && !packageManager.queryBroadcastReceivers(signal, 65536).isEmpty()) {
                this.loge("Runtime signals shouldn't be configured in Manifest: " + signal.getComponent());
                return;
            }
            signal.putExtra("subscription", this.mPhone.getSubId());
            signal.addFlags(0x10000000);
            if (!wakeup) {
                signal.setFlags(16);
            }
            try {
                this.mPhone.getContext().sendBroadcast(signal);
                this.log("Sending signal " + signal.getAction() + (signal.getComponent() != null ? " to the carrier signal receiver: " + signal.getComponent() : ""));
            }
            catch (ActivityNotFoundException e) {
                this.loge("Send broadcast failed: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCarrierSignalReceivers(Intent intent) {
        List<ComponentName> receiverList;
        Map<String, List<ComponentName>> map = this.mCachedWakeSignalConfigs;
        synchronized (map) {
            receiverList = this.mCachedWakeSignalConfigs.get(intent.getAction());
            if (!ArrayUtils.isEmpty(receiverList)) {
                this.broadcast(intent, receiverList, true);
            }
        }
        map = this.mCachedNoWakeSignalConfigs;
        synchronized (map) {
            receiverList = this.mCachedNoWakeSignalConfigs.get(intent.getAction());
            if (!ArrayUtils.isEmpty(receiverList)) {
                this.broadcast(intent, receiverList, false);
            }
        }
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private void loge(String s) {
        this.mErrorLocalLog.log(s);
        Rlog.e(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private void logv(String s) {
        Rlog.v(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        pw.println("mCachedWakeSignalConfigs:");
        ipw.increaseIndent();
        for (Map.Entry<String, List<ComponentName>> entry : this.mCachedWakeSignalConfigs.entrySet()) {
            pw.println("signal: " + entry.getKey() + " componentName list: " + entry.getValue());
        }
        ipw.decreaseIndent();
        pw.println("mCachedNoWakeSignalConfigs:");
        ipw.increaseIndent();
        for (Map.Entry<String, List<ComponentName>> entry : this.mCachedNoWakeSignalConfigs.entrySet()) {
            pw.println("signal: " + entry.getKey() + " componentName list: " + entry.getValue());
        }
        ipw.decreaseIndent();
        pw.println("error log:");
        ipw.increaseIndent();
        this.mErrorLocalLog.dump(fd, pw, args);
        ipw.decreaseIndent();
    }
}

