/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.MergeCursor;
import android.net.Uri;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.text.TextUtils;
import com.android.internal.telephony.IIccPhoneBook;
import com.android.internal.telephony.uicc.AdnRecord;
import java.util.List;

public class IccProvider
extends ContentProvider {
    private static final String TAG = "IccProvider";
    private static final boolean DBG = true;
    private static final String[] ADDRESS_BOOK_COLUMN_NAMES = new String[]{"name", "number", "emails", "_id"};
    protected static final int ADN = 1;
    protected static final int ADN_SUB = 2;
    protected static final int FDN = 3;
    protected static final int FDN_SUB = 4;
    protected static final int SDN = 5;
    protected static final int SDN_SUB = 6;
    protected static final int ADN_ALL = 7;
    protected static final String STR_TAG = "tag";
    protected static final String STR_NUMBER = "number";
    protected static final String STR_EMAILS = "emails";
    protected static final String STR_PIN2 = "pin2";
    private static final UriMatcher URL_MATCHER = new UriMatcher(-1);
    private SubscriptionManager mSubscriptionManager;

    @Override
    public boolean onCreate() {
        this.mSubscriptionManager = SubscriptionManager.from(this.getContext());
        return true;
    }

    @Override
    public Cursor query(Uri url, String[] projection, String selection, String[] selectionArgs, String sort) {
        this.log("query");
        switch (URL_MATCHER.match(url)) {
            case 1: {
                return this.loadFromEf(28474, SubscriptionManager.getDefaultSubscriptionId());
            }
            case 2: {
                return this.loadFromEf(28474, this.getRequestSubId(url));
            }
            case 3: {
                return this.loadFromEf(28475, SubscriptionManager.getDefaultSubscriptionId());
            }
            case 4: {
                return this.loadFromEf(28475, this.getRequestSubId(url));
            }
            case 5: {
                return this.loadFromEf(28489, SubscriptionManager.getDefaultSubscriptionId());
            }
            case 6: {
                return this.loadFromEf(28489, this.getRequestSubId(url));
            }
            case 7: {
                return this.loadAllSimContacts(28474);
            }
        }
        throw new IllegalArgumentException("Unknown URL " + url);
    }

    private Cursor loadAllSimContacts(int efType) {
        Cursor[] result;
        List<SubscriptionInfo> subInfoList = this.mSubscriptionManager.getActiveSubscriptionInfoList();
        if (subInfoList == null || subInfoList.size() == 0) {
            result = new Cursor[]{};
        } else {
            int subIdCount = subInfoList.size();
            result = new Cursor[subIdCount];
            for (int i = 0; i < subIdCount; ++i) {
                int subId = subInfoList.get(i).getSubscriptionId();
                result[i] = this.loadFromEf(efType, subId);
                Rlog.i(TAG, "ADN Records loaded for Subscription ::" + subId);
            }
        }
        return new MergeCursor(result);
    }

    @Override
    public String getType(Uri url) {
        switch (URL_MATCHER.match(url)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return "vnd.android.cursor.dir/sim-contact";
            }
        }
        throw new IllegalArgumentException("Unknown URL " + url);
    }

    @Override
    public Uri insert(Uri url, ContentValues initialValues) {
        int subId;
        int efType;
        String pin2 = null;
        this.log("insert");
        int match = URL_MATCHER.match(url);
        switch (match) {
            case 1: {
                efType = 28474;
                subId = SubscriptionManager.getDefaultSubscriptionId();
                break;
            }
            case 2: {
                efType = 28474;
                subId = this.getRequestSubId(url);
                break;
            }
            case 3: {
                efType = 28475;
                subId = SubscriptionManager.getDefaultSubscriptionId();
                pin2 = initialValues.getAsString(STR_PIN2);
                break;
            }
            case 4: {
                efType = 28475;
                subId = this.getRequestSubId(url);
                pin2 = initialValues.getAsString(STR_PIN2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + url);
            }
        }
        String tag = initialValues.getAsString(STR_TAG);
        String number = initialValues.getAsString(STR_NUMBER);
        boolean success = this.addIccRecordToEf(efType, tag, number, null, pin2, subId);
        if (!success) {
            return null;
        }
        StringBuilder buf = new StringBuilder("content://icc/");
        switch (match) {
            case 1: {
                buf.append("adn/");
                break;
            }
            case 2: {
                buf.append("adn/subId/");
                break;
            }
            case 3: {
                buf.append("fdn/");
                break;
            }
            case 4: {
                buf.append("fdn/subId/");
            }
        }
        buf.append(0);
        Uri resultUri = Uri.parse(buf.toString());
        this.getContext().getContentResolver().notifyChange(url, null);
        return resultUri;
    }

    private String normalizeValue(String inVal) {
        int len = inVal.length();
        if (len == 0) {
            this.log("len of input String is 0");
            return inVal;
        }
        String retVal = inVal;
        if (inVal.charAt(0) == '\'' && inVal.charAt(len - 1) == '\'') {
            retVal = inVal.substring(1, len - 1);
        }
        return retVal;
    }

    @Override
    public int delete(Uri url, String where, String[] whereArgs) {
        int subId;
        int efType;
        int match = URL_MATCHER.match(url);
        switch (match) {
            case 1: {
                efType = 28474;
                subId = SubscriptionManager.getDefaultSubscriptionId();
                break;
            }
            case 2: {
                efType = 28474;
                subId = this.getRequestSubId(url);
                break;
            }
            case 3: {
                efType = 28475;
                subId = SubscriptionManager.getDefaultSubscriptionId();
                break;
            }
            case 4: {
                efType = 28475;
                subId = this.getRequestSubId(url);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + url);
            }
        }
        this.log("delete");
        String tag = null;
        String number = null;
        Object emails = null;
        String pin2 = null;
        String[] tokens = where.split("AND");
        int n = tokens.length;
        while (--n >= 0) {
            String param = tokens[n];
            this.log("parsing '" + param + "'");
            String[] pair = param.split("=");
            if (pair.length != 2) {
                Rlog.e(TAG, "resolve: bad whereClause parameter: " + param);
                continue;
            }
            String key = pair[0].trim();
            String val = pair[1].trim();
            if (STR_TAG.equals(key)) {
                tag = this.normalizeValue(val);
                continue;
            }
            if (STR_NUMBER.equals(key)) {
                number = this.normalizeValue(val);
                continue;
            }
            if (STR_EMAILS.equals(key)) {
                emails = null;
                continue;
            }
            if (!STR_PIN2.equals(key)) continue;
            pin2 = this.normalizeValue(val);
        }
        if (efType == 3 && TextUtils.isEmpty(pin2)) {
            return 0;
        }
        boolean success = this.deleteIccRecordFromEf(efType, tag, number, emails, pin2, subId);
        if (!success) {
            return 0;
        }
        this.getContext().getContentResolver().notifyChange(url, null);
        return 1;
    }

    @Override
    public int update(Uri url, ContentValues values, String where, String[] whereArgs) {
        int subId;
        int efType;
        String pin2 = null;
        this.log("update");
        int match = URL_MATCHER.match(url);
        switch (match) {
            case 1: {
                efType = 28474;
                subId = SubscriptionManager.getDefaultSubscriptionId();
                break;
            }
            case 2: {
                efType = 28474;
                subId = this.getRequestSubId(url);
                break;
            }
            case 3: {
                efType = 28475;
                subId = SubscriptionManager.getDefaultSubscriptionId();
                pin2 = values.getAsString(STR_PIN2);
                break;
            }
            case 4: {
                efType = 28475;
                subId = this.getRequestSubId(url);
                pin2 = values.getAsString(STR_PIN2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + url);
            }
        }
        String tag = values.getAsString(STR_TAG);
        String number = values.getAsString(STR_NUMBER);
        Object emails = null;
        String newTag = values.getAsString("newTag");
        String newNumber = values.getAsString("newNumber");
        Object newEmails = null;
        boolean success = this.updateIccRecordInEf(efType, tag, number, newTag, newNumber, pin2, subId);
        if (!success) {
            return 0;
        }
        this.getContext().getContentResolver().notifyChange(url, null);
        return 1;
    }

    private MatrixCursor loadFromEf(int efType, int subId) {
        this.log("loadFromEf: efType=0x" + Integer.toHexString(efType).toUpperCase() + ", subscription=" + subId);
        List<AdnRecord> adnRecords = null;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                adnRecords = iccIpb.getAdnRecordsInEfForSubscriber(subId, efType);
            }
        }
        catch (RemoteException iccIpb) {
        }
        catch (SecurityException ex) {
            this.log(ex.toString());
        }
        if (adnRecords != null) {
            int N = adnRecords.size();
            MatrixCursor cursor = new MatrixCursor(ADDRESS_BOOK_COLUMN_NAMES, N);
            this.log("adnRecords.size=" + N);
            for (int i = 0; i < N; ++i) {
                this.loadRecord(adnRecords.get(i), cursor, i);
            }
            return cursor;
        }
        Rlog.w(TAG, "Cannot load ADN records");
        return new MatrixCursor(ADDRESS_BOOK_COLUMN_NAMES);
    }

    private boolean addIccRecordToEf(int efType, String name, String number, String[] emails, String pin2, int subId) {
        this.log("addIccRecordToEf: efType=0x" + Integer.toHexString(efType).toUpperCase() + ", name=" + Rlog.pii(TAG, (Object)name) + ", number=" + Rlog.pii(TAG, (Object)number) + ", emails=" + Rlog.pii(TAG, (Object)emails) + ", subscription=" + subId);
        boolean success = false;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                success = iccIpb.updateAdnRecordsInEfBySearchForSubscriber(subId, efType, "", "", name, number, pin2);
            }
        }
        catch (RemoteException iccIpb) {
        }
        catch (SecurityException ex) {
            this.log(ex.toString());
        }
        this.log("addIccRecordToEf: " + success);
        return success;
    }

    private boolean updateIccRecordInEf(int efType, String oldName, String oldNumber, String newName, String newNumber, String pin2, int subId) {
        this.log("updateIccRecordInEf: efType=0x" + Integer.toHexString(efType).toUpperCase() + ", oldname=" + Rlog.pii(TAG, (Object)oldName) + ", oldnumber=" + Rlog.pii(TAG, (Object)oldNumber) + ", newname=" + Rlog.pii(TAG, (Object)newName) + ", newnumber=" + Rlog.pii(TAG, (Object)newName) + ", subscription=" + subId);
        boolean success = false;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                success = iccIpb.updateAdnRecordsInEfBySearchForSubscriber(subId, efType, oldName, oldNumber, newName, newNumber, pin2);
            }
        }
        catch (RemoteException iccIpb) {
        }
        catch (SecurityException ex) {
            this.log(ex.toString());
        }
        this.log("updateIccRecordInEf: " + success);
        return success;
    }

    private boolean deleteIccRecordFromEf(int efType, String name, String number, String[] emails, String pin2, int subId) {
        this.log("deleteIccRecordFromEf: efType=0x" + Integer.toHexString(efType).toUpperCase() + ", name=" + Rlog.pii(TAG, (Object)name) + ", number=" + Rlog.pii(TAG, (Object)number) + ", emails=" + Rlog.pii(TAG, (Object)emails) + ", pin2=" + Rlog.pii(TAG, (Object)pin2) + ", subscription=" + subId);
        boolean success = false;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                success = iccIpb.updateAdnRecordsInEfBySearchForSubscriber(subId, efType, name, number, "", "", pin2);
            }
        }
        catch (RemoteException iccIpb) {
        }
        catch (SecurityException ex) {
            this.log(ex.toString());
        }
        this.log("deleteIccRecordFromEf: " + success);
        return success;
    }

    private void loadRecord(AdnRecord record, MatrixCursor cursor, int id2) {
        if (!record.isEmpty()) {
            Object[] contact = new Object[4];
            String alphaTag = record.getAlphaTag();
            String number = record.getNumber();
            this.log("loadRecord: " + alphaTag + ", " + Rlog.pii(TAG, (Object)number));
            contact[0] = alphaTag;
            contact[1] = number;
            String[] emails = record.getEmails();
            if (emails != null) {
                StringBuilder emailString = new StringBuilder();
                for (String email : emails) {
                    this.log("Adding email:" + Rlog.pii(TAG, (Object)email));
                    emailString.append(email);
                    emailString.append(",");
                }
                contact[2] = emailString.toString();
            }
            contact[3] = id2;
            cursor.addRow(contact);
        }
    }

    private void log(String msg) {
        Rlog.d(TAG, "[IccProvider] " + msg);
    }

    private int getRequestSubId(Uri url) {
        this.log("getRequestSubId url: " + url);
        try {
            return Integer.parseInt(url.getLastPathSegment());
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Unknown URL " + url);
        }
    }

    static {
        URL_MATCHER.addURI("icc", "adn", 1);
        URL_MATCHER.addURI("icc", "adn/subId/#", 2);
        URL_MATCHER.addURI("icc", "fdn", 3);
        URL_MATCHER.addURI("icc", "fdn/subId/#", 4);
        URL_MATCHER.addURI("icc", "sdn", 5);
        URL_MATCHER.addURI("icc", "sdn/subId/#", 6);
    }
}

