/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.hardware.radio.V1_0.ActivityStatsInfo;
import android.hardware.radio.V1_0.AppStatus;
import android.hardware.radio.V1_0.Call;
import android.hardware.radio.V1_0.CardStatus;
import android.hardware.radio.V1_0.CarrierRestrictions;
import android.hardware.radio.V1_0.CdmaBroadcastSmsConfigInfo;
import android.hardware.radio.V1_0.CellInfo;
import android.hardware.radio.V1_0.DataRegStateResult;
import android.hardware.radio.V1_0.GsmBroadcastSmsConfigInfo;
import android.hardware.radio.V1_0.IRadioResponse;
import android.hardware.radio.V1_0.LastCallFailCauseInfo;
import android.hardware.radio.V1_0.LceDataInfo;
import android.hardware.radio.V1_0.LceStatusInfo;
import android.hardware.radio.V1_0.NeighboringCell;
import android.hardware.radio.V1_0.RadioResponseInfo;
import android.hardware.radio.V1_0.SendSmsResult;
import android.hardware.radio.V1_0.SetupDataCallResult;
import android.hardware.radio.V1_0.VoiceRegStateResult;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemClock;
import android.service.carrier.CarrierIdentifier;
import android.telephony.ModemActivityInfo;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneNumberUtils;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.Base64;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.HardwareConfig;
import com.android.internal.telephony.LastCallFailCause;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.RILRequest;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import java.util.ArrayList;
import java.util.Collections;

public class RadioResponse
extends IRadioResponse.Stub {
    private static final int CDMA_BSI_NO_OF_INTS_STRUCT = 3;
    private static final int CDMA_BROADCAST_SMS_NO_OF_SERVICE_CATEGORIES = 31;
    RIL mRil;

    public RadioResponse(RIL ril) {
        this.mRil = ril;
    }

    static void sendMessageResponse(Message msg, Object ret) {
        if (msg != null) {
            AsyncResult.forMessage(msg, ret, null);
            msg.sendToTarget();
        }
    }

    @Override
    public void acknowledgeRequest(int serial) {
        this.mRil.processRequestAck(serial);
    }

    @Override
    public void getIccCardStatusResponse(RadioResponseInfo responseInfo, CardStatus cardStatus) {
        this.responseIccCardStatus(responseInfo, cardStatus);
    }

    @Override
    public void supplyIccPinForAppResponse(RadioResponseInfo responseInfo, int remainingAttempts) {
        this.responseInts(responseInfo, remainingAttempts);
    }

    @Override
    public void supplyIccPukForAppResponse(RadioResponseInfo responseInfo, int remainingAttempts) {
        this.responseInts(responseInfo, remainingAttempts);
    }

    @Override
    public void supplyIccPin2ForAppResponse(RadioResponseInfo responseInfo, int remainingAttempts) {
        this.responseInts(responseInfo, remainingAttempts);
    }

    @Override
    public void supplyIccPuk2ForAppResponse(RadioResponseInfo responseInfo, int remainingAttempts) {
        this.responseInts(responseInfo, remainingAttempts);
    }

    @Override
    public void changeIccPinForAppResponse(RadioResponseInfo responseInfo, int remainingAttempts) {
        this.responseInts(responseInfo, remainingAttempts);
    }

    @Override
    public void changeIccPin2ForAppResponse(RadioResponseInfo responseInfo, int remainingAttempts) {
        this.responseInts(responseInfo, remainingAttempts);
    }

    @Override
    public void supplyNetworkDepersonalizationResponse(RadioResponseInfo responseInfo, int retriesRemaining) {
        this.responseInts(responseInfo, retriesRemaining);
    }

    @Override
    public void getCurrentCallsResponse(RadioResponseInfo responseInfo, ArrayList<Call> calls) {
        this.responseCurrentCalls(responseInfo, calls);
    }

    @Override
    public void dialResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getIMSIForAppResponse(RadioResponseInfo responseInfo, String imsi) {
        this.responseString(responseInfo, imsi);
    }

    @Override
    public void hangupConnectionResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void hangupWaitingOrBackgroundResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void hangupForegroundResumeBackgroundResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void switchWaitingOrHoldingAndActiveResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void conferenceResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void rejectCallResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getLastCallFailCauseResponse(RadioResponseInfo responseInfo, LastCallFailCauseInfo fcInfo) {
        this.responseLastCallFailCauseInfo(responseInfo, fcInfo);
    }

    @Override
    public void getSignalStrengthResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.SignalStrength sigStrength) {
        this.responseSignalStrength(responseInfo, sigStrength);
    }

    @Override
    public void getVoiceRegistrationStateResponse(RadioResponseInfo responseInfo, VoiceRegStateResult voiceRegResponse) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, voiceRegResponse);
            }
            this.mRil.processResponseDone(rr, responseInfo, voiceRegResponse);
        }
    }

    @Override
    public void getDataRegistrationStateResponse(RadioResponseInfo responseInfo, DataRegStateResult dataRegResponse) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, dataRegResponse);
            }
            this.mRil.processResponseDone(rr, responseInfo, dataRegResponse);
        }
    }

    @Override
    public void getOperatorResponse(RadioResponseInfo responseInfo, String longName, String shortName, String numeric) {
        this.responseStrings(responseInfo, longName, shortName, numeric);
    }

    @Override
    public void setRadioPowerResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void sendDtmfResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void sendSmsResponse(RadioResponseInfo responseInfo, SendSmsResult sms) {
        this.responseSms(responseInfo, sms);
    }

    @Override
    public void sendSMSExpectMoreResponse(RadioResponseInfo responseInfo, SendSmsResult sms) {
        this.responseSms(responseInfo, sms);
    }

    @Override
    public void setupDataCallResponse(RadioResponseInfo responseInfo, SetupDataCallResult setupDataCallResult) {
        this.responseSetupDataCall(responseInfo, setupDataCallResult);
    }

    @Override
    public void iccIOForAppResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult iccIo) {
        this.responseIccIo(responseInfo, iccIo);
    }

    @Override
    public void sendUssdResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void cancelPendingUssdResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getClirResponse(RadioResponseInfo responseInfo, int n, int m) {
        this.responseInts(responseInfo, n, m);
    }

    @Override
    public void setClirResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getCallForwardStatusResponse(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.V1_0.CallForwardInfo> callForwardInfos) {
        this.responseCallForwardInfo(responseInfo, callForwardInfos);
    }

    @Override
    public void setCallForwardResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getCallWaitingResponse(RadioResponseInfo responseInfo, boolean enable, int serviceClass) {
        this.responseInts(responseInfo, enable ? 1 : 0, serviceClass);
    }

    @Override
    public void setCallWaitingResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void acknowledgeLastIncomingGsmSmsResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void acceptCallResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void deactivateDataCallResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getFacilityLockForAppResponse(RadioResponseInfo responseInfo, int response) {
        this.responseInts(responseInfo, response);
    }

    @Override
    public void setFacilityLockForAppResponse(RadioResponseInfo responseInfo, int retry) {
        this.responseInts(responseInfo, retry);
    }

    @Override
    public void setBarringPasswordResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getNetworkSelectionModeResponse(RadioResponseInfo responseInfo, boolean selection) {
        this.responseInts(responseInfo, selection ? 1 : 0);
    }

    @Override
    public void setNetworkSelectionModeAutomaticResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setNetworkSelectionModeManualResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getAvailableNetworksResponse(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.V1_0.OperatorInfo> networkInfos) {
        this.responseOperatorInfos(responseInfo, networkInfos);
    }

    @Override
    public void startDtmfResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void stopDtmfResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getBasebandVersionResponse(RadioResponseInfo responseInfo, String version) {
        this.responseString(responseInfo, version);
    }

    @Override
    public void separateConnectionResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setMuteResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getMuteResponse(RadioResponseInfo responseInfo, boolean enable) {
        this.responseInts(responseInfo, enable ? 1 : 0);
    }

    @Override
    public void getClipResponse(RadioResponseInfo responseInfo, int status) {
        this.responseInts(responseInfo, status);
    }

    @Override
    public void getDataCallListResponse(RadioResponseInfo responseInfo, ArrayList<SetupDataCallResult> dataCallResultList) {
        this.responseDataCallList(responseInfo, dataCallResultList);
    }

    public void sendOemRilRequestRawResponse(RadioResponseInfo responseInfo, ArrayList<Byte> var2) {
    }

    @Override
    public void setSuppServiceNotificationsResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void writeSmsToSimResponse(RadioResponseInfo responseInfo, int index) {
        this.responseInts(responseInfo, index);
    }

    @Override
    public void deleteSmsOnSimResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setBandModeResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getAvailableBandModesResponse(RadioResponseInfo responseInfo, ArrayList<Integer> bandModes) {
        this.responseIntArrayList(responseInfo, bandModes);
    }

    @Override
    public void sendEnvelopeResponse(RadioResponseInfo responseInfo, String commandResponse) {
        this.responseString(responseInfo, commandResponse);
    }

    @Override
    public void sendTerminalResponseToSimResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void handleStkCallSetupRequestFromSimResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void explicitCallTransferResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setPreferredNetworkTypeResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getPreferredNetworkTypeResponse(RadioResponseInfo responseInfo, int nwType) {
        this.mRil.mPreferredNetworkType = nwType;
        this.responseInts(responseInfo, nwType);
    }

    @Override
    public void getNeighboringCidsResponse(RadioResponseInfo responseInfo, ArrayList<NeighboringCell> cells) {
        this.responseCellList(responseInfo, cells);
    }

    @Override
    public void setLocationUpdatesResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setCdmaSubscriptionSourceResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setCdmaRoamingPreferenceResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getCdmaRoamingPreferenceResponse(RadioResponseInfo responseInfo, int type) {
        this.responseInts(responseInfo, type);
    }

    @Override
    public void setTTYModeResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getTTYModeResponse(RadioResponseInfo responseInfo, int mode) {
        this.responseInts(responseInfo, mode);
    }

    @Override
    public void setPreferredVoicePrivacyResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getPreferredVoicePrivacyResponse(RadioResponseInfo responseInfo, boolean enable) {
        this.responseInts(responseInfo, enable ? 1 : 0);
    }

    @Override
    public void sendCDMAFeatureCodeResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void sendBurstDtmfResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void sendCdmaSmsResponse(RadioResponseInfo responseInfo, SendSmsResult sms) {
        this.responseSms(responseInfo, sms);
    }

    @Override
    public void acknowledgeLastIncomingCdmaSmsResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getGsmBroadcastConfigResponse(RadioResponseInfo responseInfo, ArrayList<GsmBroadcastSmsConfigInfo> configs) {
        this.responseGmsBroadcastConfig(responseInfo, configs);
    }

    @Override
    public void setGsmBroadcastConfigResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setGsmBroadcastActivationResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getCdmaBroadcastConfigResponse(RadioResponseInfo responseInfo, ArrayList<CdmaBroadcastSmsConfigInfo> configs) {
        this.responseCdmaBroadcastConfig(responseInfo, configs);
    }

    @Override
    public void setCdmaBroadcastConfigResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setCdmaBroadcastActivationResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getCDMASubscriptionResponse(RadioResponseInfo responseInfo, String mdn, String hSid, String hNid, String min, String prl) {
        this.responseStrings(responseInfo, mdn, hSid, hNid, min, prl);
    }

    @Override
    public void writeSmsToRuimResponse(RadioResponseInfo responseInfo, int index) {
        this.responseInts(responseInfo, index);
    }

    @Override
    public void deleteSmsOnRuimResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getDeviceIdentityResponse(RadioResponseInfo responseInfo, String imei, String imeisv, String esn, String meid) {
        this.responseStrings(responseInfo, imei, imeisv, esn, meid);
    }

    @Override
    public void exitEmergencyCallbackModeResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getSmscAddressResponse(RadioResponseInfo responseInfo, String smsc) {
        this.responseString(responseInfo, smsc);
    }

    @Override
    public void setSmscAddressResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void reportSmsMemoryStatusResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void reportStkServiceIsRunningResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getCdmaSubscriptionSourceResponse(RadioResponseInfo responseInfo, int source) {
        this.responseInts(responseInfo, source);
    }

    @Override
    public void requestIsimAuthenticationResponse(RadioResponseInfo responseInfo, String response) {
        this.responseString(responseInfo, response);
    }

    @Override
    public void acknowledgeIncomingGsmSmsWithPduResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void sendEnvelopeWithStatusResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult iccIo) {
        this.responseIccIo(responseInfo, iccIo);
    }

    @Override
    public void getVoiceRadioTechnologyResponse(RadioResponseInfo responseInfo, int rat) {
        this.responseInts(responseInfo, rat);
    }

    @Override
    public void getCellInfoListResponse(RadioResponseInfo responseInfo, ArrayList<CellInfo> cellInfo) {
        this.responseCellInfoList(responseInfo, cellInfo);
    }

    @Override
    public void setCellInfoListRateResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setInitialAttachApnResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getImsRegistrationStateResponse(RadioResponseInfo responseInfo, boolean isRegistered, int ratFamily) {
        this.responseInts(responseInfo, isRegistered ? 1 : 0, ratFamily);
    }

    @Override
    public void sendImsSmsResponse(RadioResponseInfo responseInfo, SendSmsResult sms) {
        this.responseSms(responseInfo, sms);
    }

    @Override
    public void iccTransmitApduBasicChannelResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult result) {
        this.responseIccIo(responseInfo, result);
    }

    @Override
    public void iccOpenLogicalChannelResponse(RadioResponseInfo responseInfo, int channelId, ArrayList<Byte> selectResponse) {
        ArrayList<Integer> arr = new ArrayList<Integer>();
        arr.add(channelId);
        for (int i = 0; i < selectResponse.size(); ++i) {
            arr.add((int)selectResponse.get(i));
        }
        this.responseIntArrayList(responseInfo, arr);
    }

    @Override
    public void iccCloseLogicalChannelResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void iccTransmitApduLogicalChannelResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult result) {
        this.responseIccIo(responseInfo, result);
    }

    @Override
    public void nvReadItemResponse(RadioResponseInfo responseInfo, String result) {
        this.responseString(responseInfo, result);
    }

    @Override
    public void nvWriteItemResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void nvWriteCdmaPrlResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void nvResetConfigResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setUiccSubscriptionResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setDataAllowedResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getHardwareConfigResponse(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.V1_0.HardwareConfig> config) {
        this.responseHardwareConfig(responseInfo, config);
    }

    @Override
    public void requestIccSimAuthenticationResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult result) {
        this.responseICC_IOBase64(responseInfo, result);
    }

    @Override
    public void setDataProfileResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void requestShutdownResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void getRadioCapabilityResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.RadioCapability rc) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            RadioCapability ret = RIL.convertHalRadioCapability(rc, this.mRil);
            if (responseInfo.error == 6 || responseInfo.error == 2) {
                ret = this.mRil.makeStaticRadioCapability();
                responseInfo.error = 0;
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    @Override
    public void setRadioCapabilityResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.RadioCapability rc) {
        this.responseRadioCapability(responseInfo, rc);
    }

    @Override
    public void startLceServiceResponse(RadioResponseInfo responseInfo, LceStatusInfo statusInfo) {
        this.responseLceStatus(responseInfo, statusInfo);
    }

    @Override
    public void stopLceServiceResponse(RadioResponseInfo responseInfo, LceStatusInfo statusInfo) {
        this.responseLceStatus(responseInfo, statusInfo);
    }

    @Override
    public void pullLceDataResponse(RadioResponseInfo responseInfo, LceDataInfo lceInfo) {
        this.responseLceData(responseInfo, lceInfo);
    }

    @Override
    public void getModemActivityInfoResponse(RadioResponseInfo responseInfo, ActivityStatsInfo activityInfo) {
        this.responseActivityData(responseInfo, activityInfo);
    }

    @Override
    public void setAllowedCarriersResponse(RadioResponseInfo responseInfo, int numAllowed) {
        this.responseInts(responseInfo, numAllowed);
    }

    @Override
    public void getAllowedCarriersResponse(RadioResponseInfo responseInfo, boolean allAllowed, CarrierRestrictions carriers) {
        this.responseCarrierIdentifiers(responseInfo, allAllowed, carriers);
    }

    @Override
    public void sendDeviceStateResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setIndicationFilterResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    @Override
    public void setSimCardPowerResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private void responseIccCardStatus(RadioResponseInfo responseInfo, CardStatus cardStatus) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            IccCardStatus iccCardStatus = new IccCardStatus();
            iccCardStatus.setCardState(cardStatus.cardState);
            iccCardStatus.setUniversalPinState(cardStatus.universalPinState);
            iccCardStatus.mGsmUmtsSubscriptionAppIndex = cardStatus.gsmUmtsSubscriptionAppIndex;
            iccCardStatus.mCdmaSubscriptionAppIndex = cardStatus.cdmaSubscriptionAppIndex;
            iccCardStatus.mImsSubscriptionAppIndex = cardStatus.imsSubscriptionAppIndex;
            int numApplications = cardStatus.applications.size();
            if (numApplications > 8) {
                numApplications = 8;
            }
            iccCardStatus.mApplications = new IccCardApplicationStatus[numApplications];
            for (int i = 0; i < numApplications; ++i) {
                AppStatus rilAppStatus = cardStatus.applications.get(i);
                IccCardApplicationStatus appStatus = new IccCardApplicationStatus();
                appStatus.app_type = appStatus.AppTypeFromRILInt(rilAppStatus.appType);
                appStatus.app_state = appStatus.AppStateFromRILInt(rilAppStatus.appState);
                appStatus.perso_substate = appStatus.PersoSubstateFromRILInt(rilAppStatus.persoSubstate);
                appStatus.aid = rilAppStatus.aidPtr;
                appStatus.app_label = rilAppStatus.appLabelPtr;
                appStatus.pin1_replaced = rilAppStatus.pin1Replaced;
                appStatus.pin1 = appStatus.PinStateFromRILInt(rilAppStatus.pin1);
                appStatus.pin2 = appStatus.PinStateFromRILInt(rilAppStatus.pin2);
                iccCardStatus.mApplications[i] = appStatus;
            }
            this.mRil.riljLog("responseIccCardStatus: from HIDL: " + iccCardStatus);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, iccCardStatus);
            }
            this.mRil.processResponseDone(rr, responseInfo, iccCardStatus);
        }
    }

    private void responseInts(RadioResponseInfo responseInfo, int ... var) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (int i = 0; i < var.length; ++i) {
            ints.add(var[i]);
        }
        this.responseIntArrayList(responseInfo, ints);
    }

    private void responseIntArrayList(RadioResponseInfo responseInfo, ArrayList<Integer> var) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            int[] ret = new int[var.size()];
            for (int i = 0; i < var.size(); ++i) {
                ret[i] = var.get(i);
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseCurrentCalls(RadioResponseInfo responseInfo, ArrayList<Call> calls) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            int num = calls.size();
            ArrayList<DriverCall> dcCalls = new ArrayList<DriverCall>(num);
            for (int i = 0; i < num; ++i) {
                DriverCall dc = new DriverCall();
                dc.state = DriverCall.stateFromCLCC(calls.get((int)i).state);
                dc.index = calls.get((int)i).index;
                dc.TOA = calls.get((int)i).toa;
                dc.isMpty = calls.get((int)i).isMpty;
                dc.isMT = calls.get((int)i).isMT;
                dc.als = calls.get((int)i).als;
                dc.isVoice = calls.get((int)i).isVoice;
                dc.isVoicePrivacy = calls.get((int)i).isVoicePrivacy;
                dc.number = calls.get((int)i).number;
                dc.numberPresentation = DriverCall.presentationFromCLIP(calls.get((int)i).numberPresentation);
                dc.name = calls.get((int)i).name;
                dc.namePresentation = DriverCall.presentationFromCLIP(calls.get((int)i).namePresentation);
                if (calls.get((int)i).uusInfo.size() == 1) {
                    dc.uusInfo = new UUSInfo();
                    dc.uusInfo.setType(calls.get((int)i).uusInfo.get((int)0).uusType);
                    dc.uusInfo.setDcs(calls.get((int)i).uusInfo.get((int)0).uusDcs);
                    if (calls.get((int)i).uusInfo.get((int)0).uusData != null) {
                        byte[] userData = calls.get((int)i).uusInfo.get((int)0).uusData.getBytes();
                        dc.uusInfo.setUserData(userData);
                    } else {
                        this.mRil.riljLog("responseCurrentCalls: uusInfo data is null");
                    }
                    this.mRil.riljLogv(String.format("Incoming UUS : type=%d, dcs=%d, length=%d", dc.uusInfo.getType(), dc.uusInfo.getDcs(), dc.uusInfo.getUserData().length));
                    this.mRil.riljLogv("Incoming UUS : data (hex): " + IccUtils.bytesToHexString(dc.uusInfo.getUserData()));
                } else {
                    this.mRil.riljLogv("Incoming UUS : NOT present!");
                }
                dc.number = PhoneNumberUtils.stringFromStringAndTOA(dc.number, dc.TOA);
                dcCalls.add(dc);
                if (dc.isVoicePrivacy) {
                    this.mRil.mVoicePrivacyOnRegistrants.notifyRegistrants();
                    this.mRil.riljLog("InCall VoicePrivacy is enabled");
                    continue;
                }
                this.mRil.mVoicePrivacyOffRegistrants.notifyRegistrants();
                this.mRil.riljLog("InCall VoicePrivacy is disabled");
            }
            Collections.sort(dcCalls);
            if (num == 0 && this.mRil.mTestingEmergencyCall.getAndSet(false) && this.mRil.mEmergencyCallbackModeRegistrant != null) {
                this.mRil.riljLog("responseCurrentCalls: call ended, testing emergency call, notify ECM Registrants");
                this.mRil.mEmergencyCallbackModeRegistrant.notifyRegistrant();
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, dcCalls);
            }
            this.mRil.processResponseDone(rr, responseInfo, dcCalls);
        }
    }

    private void responseVoid(RadioResponseInfo responseInfo) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            Object ret = null;
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseString(RadioResponseInfo responseInfo, String str) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, str);
            }
            this.mRil.processResponseDone(rr, responseInfo, str);
        }
    }

    private void responseStrings(RadioResponseInfo responseInfo, String ... str) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < str.length; ++i) {
            strings.add(str[i]);
        }
        RadioResponse.responseStringArrayList(this.mRil, responseInfo, strings);
    }

    static void responseStringArrayList(RIL ril, RadioResponseInfo responseInfo, ArrayList<String> strings) {
        RILRequest rr = ril.processResponse(responseInfo);
        if (rr != null) {
            String[] ret = new String[strings.size()];
            for (int i = 0; i < strings.size(); ++i) {
                ret[i] = strings.get(i);
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            ril.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseLastCallFailCauseInfo(RadioResponseInfo responseInfo, LastCallFailCauseInfo fcInfo) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            LastCallFailCause ret = new LastCallFailCause();
            ret.causeCode = fcInfo.causeCode;
            ret.vendorCause = fcInfo.vendorCause;
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseSignalStrength(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.SignalStrength sigStrength) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            SignalStrength ret = RIL.convertHalSignalStrength(sigStrength);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseSms(RadioResponseInfo responseInfo, SendSmsResult sms) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            SmsResponse ret = new SmsResponse(sms.messageRef, sms.ackPDU, sms.errorCode);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseSetupDataCall(RadioResponseInfo responseInfo, SetupDataCallResult setupDataCallResult) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            DataCallResponse ret = RIL.convertDataCallResult(setupDataCallResult);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseIccIo(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult result) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            IccIoResult ret = new IccIoResult(result.sw1, result.sw2, result.simResponse);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseCallForwardInfo(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.V1_0.CallForwardInfo> callForwardInfos) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            CallForwardInfo[] ret = new CallForwardInfo[callForwardInfos.size()];
            for (int i = 0; i < callForwardInfos.size(); ++i) {
                ret[i] = new CallForwardInfo();
                ret[i].status = callForwardInfos.get((int)i).status;
                ret[i].reason = callForwardInfos.get((int)i).reason;
                ret[i].serviceClass = callForwardInfos.get((int)i).serviceClass;
                ret[i].toa = callForwardInfos.get((int)i).toa;
                ret[i].number = callForwardInfos.get((int)i).number;
                ret[i].timeSeconds = callForwardInfos.get((int)i).timeSeconds;
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private static String convertOpertatorInfoToString(int status) {
        if (status == 0) {
            return "unknown";
        }
        if (status == 1) {
            return "available";
        }
        if (status == 2) {
            return "current";
        }
        if (status == 3) {
            return "forbidden";
        }
        return "";
    }

    private void responseOperatorInfos(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.V1_0.OperatorInfo> networkInfos) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<OperatorInfo> ret = new ArrayList<OperatorInfo>();
            for (int i = 0; i < networkInfos.size(); ++i) {
                ret.add(new OperatorInfo(networkInfos.get((int)i).alphaLong, networkInfos.get((int)i).alphaShort, networkInfos.get((int)i).operatorNumeric, RadioResponse.convertOpertatorInfoToString(networkInfos.get((int)i).status)));
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseDataCallList(RadioResponseInfo responseInfo, ArrayList<SetupDataCallResult> dataCallResultList) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<DataCallResponse> dcResponseList = new ArrayList<DataCallResponse>();
            for (SetupDataCallResult dcResult : dataCallResultList) {
                dcResponseList.add(RIL.convertDataCallResult(dcResult));
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, dcResponseList);
            }
            this.mRil.processResponseDone(rr, responseInfo, dcResponseList);
        }
    }

    private void responseCellList(RadioResponseInfo responseInfo, ArrayList<NeighboringCell> cells) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<NeighboringCellInfo> ret = new ArrayList<NeighboringCellInfo>();
            int[] subId = SubscriptionManager.getSubId(this.mRil.mPhoneId);
            int radioType = ((TelephonyManager)this.mRil.mContext.getSystemService("phone")).getDataNetworkType(subId[0]);
            if (radioType != 0) {
                for (int i = 0; i < cells.size(); ++i) {
                    int rssi = cells.get((int)i).rssi;
                    String location = cells.get((int)i).cid;
                    NeighboringCellInfo cell = new NeighboringCellInfo(rssi, location, radioType);
                    ret.add(cell);
                }
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseGmsBroadcastConfig(RadioResponseInfo responseInfo, ArrayList<GsmBroadcastSmsConfigInfo> configs) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<SmsBroadcastConfigInfo> ret = new ArrayList<SmsBroadcastConfigInfo>();
            for (int i = 0; i < configs.size(); ++i) {
                ret.add(new SmsBroadcastConfigInfo(configs.get((int)i).fromServiceId, configs.get((int)i).toServiceId, configs.get((int)i).fromCodeScheme, configs.get((int)i).toCodeScheme, configs.get((int)i).selected));
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseCdmaBroadcastConfig(RadioResponseInfo responseInfo, ArrayList<CdmaBroadcastSmsConfigInfo> configs) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            int[] ret = null;
            int numServiceCategories = configs.size();
            if (numServiceCategories == 0) {
                int numInts = 94;
                ret = new int[numInts];
                ret[0] = 31;
                for (int i = 1; i < numInts; i += 3) {
                    ret[i + 0] = i / 3;
                    ret[i + 1] = 1;
                    ret[i + 2] = 0;
                }
            } else {
                int numInts = numServiceCategories * 3 + 1;
                ret = new int[numInts];
                ret[0] = numServiceCategories;
                int i = 1;
                int j = 0;
                while (j < configs.size()) {
                    ret[i] = configs.get((int)j).serviceCategory;
                    ret[i + 1] = configs.get((int)j).language;
                    ret[i + 2] = configs.get((int)j).selected ? 1 : 0;
                    ++j;
                    i += 3;
                }
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseCellInfoList(RadioResponseInfo responseInfo, ArrayList<CellInfo> cellInfo) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<android.telephony.CellInfo> ret = RIL.convertHalCellInfoList(cellInfo);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseActivityData(RadioResponseInfo responseInfo, ActivityStatsInfo activityInfo) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ModemActivityInfo ret = null;
            if (responseInfo.error == 0) {
                int sleepModeTimeMs = activityInfo.sleepModeTimeMs;
                int idleModeTimeMs = activityInfo.idleModeTimeMs;
                int[] txModeTimeMs = new int[5];
                for (int i = 0; i < 5; ++i) {
                    txModeTimeMs[i] = activityInfo.txmModetimeMs[i];
                }
                int rxModeTimeMs = activityInfo.rxModeTimeMs;
                ret = new ModemActivityInfo(SystemClock.elapsedRealtime(), sleepModeTimeMs, idleModeTimeMs, txModeTimeMs, rxModeTimeMs, 0);
            } else {
                ret = new ModemActivityInfo(0L, 0, 0, new int[5], 0, 0);
                responseInfo.error = 0;
            }
            RadioResponse.sendMessageResponse(rr.mResult, ret);
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseHardwareConfig(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.V1_0.HardwareConfig> config) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<HardwareConfig> ret = RIL.convertHalHwConfigList(config, this.mRil);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseICC_IOBase64(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult result) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            IccIoResult ret = new IccIoResult(result.sw1, result.sw2, !result.simResponse.equals("") ? Base64.decode(result.simResponse, 0) : (byte[])null);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseRadioCapability(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.RadioCapability rc) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            RadioCapability ret = RIL.convertHalRadioCapability(rc, this.mRil);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseLceStatus(RadioResponseInfo responseInfo, LceStatusInfo statusInfo) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            ret.add(statusInfo.lceStatus);
            ret.add(Byte.toUnsignedInt(statusInfo.actualIntervalMs));
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseLceData(RadioResponseInfo responseInfo, LceDataInfo lceInfo) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<Integer> ret = RIL.convertHalLceData(lceInfo, this.mRil);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void responseCarrierIdentifiers(RadioResponseInfo responseInfo, boolean allAllowed, CarrierRestrictions carriers) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<CarrierIdentifier> ret = new ArrayList<CarrierIdentifier>();
            for (int i = 0; i < carriers.allowedCarriers.size(); ++i) {
                String mcc = carriers.allowedCarriers.get((int)i).mcc;
                String mnc = carriers.allowedCarriers.get((int)i).mnc;
                String spn = null;
                String imsi = null;
                String gid1 = null;
                String gid2 = null;
                int matchType = carriers.allowedCarriers.get((int)i).matchType;
                String matchData = carriers.allowedCarriers.get((int)i).matchData;
                if (matchType == 1) {
                    spn = matchData;
                } else if (matchType == 2) {
                    imsi = matchData;
                } else if (matchType == 3) {
                    gid1 = matchData;
                } else if (matchType == 4) {
                    gid2 = matchData;
                }
                ret.add(new CarrierIdentifier(mcc, mnc, spn, imsi, gid1, gid2));
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }
}

