/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.database.Cursor;
import android.os.Build;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.HbpcdLookup;
import com.android.internal.telephony.Phone;
import java.util.ArrayList;
import java.util.HashMap;

public class SmsNumberUtils {
    private static final String TAG = "SmsNumberUtils";
    private static final boolean DBG = Build.IS_DEBUGGABLE;
    private static final String PLUS_SIGN = "+";
    private static final int NANP_SHORT_LENGTH = 7;
    private static final int NANP_MEDIUM_LENGTH = 10;
    private static final int NANP_LONG_LENGTH = 11;
    private static final int NANP_CC = 1;
    private static final String NANP_NDD = "1";
    private static final String NANP_IDD = "011";
    private static final int MIN_COUNTRY_AREA_LOCAL_LENGTH = 10;
    private static final int GSM_UMTS_NETWORK = 0;
    private static final int CDMA_HOME_NETWORK = 1;
    private static final int CDMA_ROAMING_NETWORK = 2;
    private static final int NP_NONE = 0;
    private static final int NP_NANP_BEGIN = 1;
    private static final int NP_NANP_LOCAL = 1;
    private static final int NP_NANP_AREA_LOCAL = 2;
    private static final int NP_NANP_NDD_AREA_LOCAL = 3;
    private static final int NP_NANP_NBPCD_CC_AREA_LOCAL = 4;
    private static final int NP_NANP_LOCALIDD_CC_AREA_LOCAL = 5;
    private static final int NP_NANP_NBPCD_HOMEIDD_CC_AREA_LOCAL = 6;
    private static final int NP_INTERNATIONAL_BEGIN = 100;
    private static final int NP_NBPCD_HOMEIDD_CC_AREA_LOCAL = 100;
    private static final int NP_HOMEIDD_CC_AREA_LOCAL = 101;
    private static final int NP_NBPCD_CC_AREA_LOCAL = 102;
    private static final int NP_LOCALIDD_CC_AREA_LOCAL = 103;
    private static final int NP_CC_AREA_LOCAL = 104;
    private static int[] ALL_COUNTRY_CODES = null;
    private static int MAX_COUNTRY_CODES_LENGTH;
    private static HashMap<String, ArrayList<String>> IDDS_MAPS;

    private static String formatNumber(Context context, String number, String activeMcc, int networkType) {
        if (number == null) {
            throw new IllegalArgumentException("number is null");
        }
        if (activeMcc == null || activeMcc.trim().length() == 0) {
            throw new IllegalArgumentException("activeMcc is null or empty!");
        }
        String networkPortionNumber = PhoneNumberUtils.extractNetworkPortion(number);
        if (networkPortionNumber == null || networkPortionNumber.length() == 0) {
            throw new IllegalArgumentException("Number is invalid!");
        }
        NumberEntry numberEntry = new NumberEntry(networkPortionNumber);
        ArrayList<String> allIDDs = SmsNumberUtils.getAllIDDs(context, activeMcc);
        int nanpState = SmsNumberUtils.checkNANP(numberEntry, allIDDs);
        if (DBG) {
            Rlog.d(TAG, "NANP type: " + SmsNumberUtils.getNumberPlanType(nanpState));
        }
        if (nanpState == 1 || nanpState == 2 || nanpState == 3) {
            return networkPortionNumber;
        }
        if (nanpState == 4) {
            if (networkType == 1 || networkType == 2) {
                return networkPortionNumber.substring(1);
            }
            return networkPortionNumber;
        }
        if (nanpState == 5) {
            if (networkType == 1) {
                return networkPortionNumber;
            }
            if (networkType == 0) {
                int iddLength = numberEntry.IDD != null ? numberEntry.IDD.length() : 0;
                return PLUS_SIGN + networkPortionNumber.substring(iddLength);
            }
            if (networkType == 2) {
                int iddLength = numberEntry.IDD != null ? numberEntry.IDD.length() : 0;
                return networkPortionNumber.substring(iddLength);
            }
        }
        int internationalState = SmsNumberUtils.checkInternationalNumberPlan(context, numberEntry, allIDDs, NANP_IDD);
        if (DBG) {
            Rlog.d(TAG, "International type: " + SmsNumberUtils.getNumberPlanType(internationalState));
        }
        String returnNumber = null;
        switch (internationalState) {
            case 100: {
                if (networkType != 0) break;
                returnNumber = networkPortionNumber.substring(1);
                break;
            }
            case 102: {
                returnNumber = NANP_IDD + networkPortionNumber.substring(1);
                break;
            }
            case 103: {
                if (networkType != 0 && networkType != 2) break;
                int iddLength = numberEntry.IDD != null ? numberEntry.IDD.length() : 0;
                returnNumber = NANP_IDD + networkPortionNumber.substring(iddLength);
                break;
            }
            case 104: {
                int countryCode = numberEntry.countryCode;
                if (SmsNumberUtils.inExceptionListForNpCcAreaLocal(numberEntry) || networkPortionNumber.length() < 11 || countryCode == 1) break;
                returnNumber = NANP_IDD + networkPortionNumber;
                break;
            }
            case 101: {
                returnNumber = networkPortionNumber;
                break;
            }
            default: {
                if (!networkPortionNumber.startsWith(PLUS_SIGN) || networkType != 1 && networkType != 2) break;
                returnNumber = networkPortionNumber.startsWith("+011") ? networkPortionNumber.substring(1) : NANP_IDD + networkPortionNumber.substring(1);
            }
        }
        if (returnNumber == null) {
            returnNumber = networkPortionNumber;
        }
        return returnNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getAllIDDs(Context context, String mcc) {
        ArrayList<String> allIDDs = IDDS_MAPS.get(mcc);
        if (allIDDs != null) {
            return allIDDs;
        }
        allIDDs = new ArrayList();
        String[] projection = new String[]{"IDD", "MCC"};
        String where = null;
        String[] selectionArgs = null;
        if (mcc != null) {
            where = "MCC=?";
            selectionArgs = new String[]{mcc};
        }
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(HbpcdLookup.MccIdd.CONTENT_URI, projection, where, selectionArgs, null);
            if (cursor.getCount() > 0) {
                while (cursor.moveToNext()) {
                    String idd = cursor.getString(0);
                    if (allIDDs.contains(idd)) continue;
                    allIDDs.add(idd);
                }
            }
        }
        IDDS_MAPS.put(mcc, allIDDs);
        if (DBG) {
            Rlog.d(TAG, "MCC = " + mcc + ", all IDDs = " + allIDDs);
        }
        return allIDDs;
    }

    private static int checkNANP(NumberEntry numberEntry, ArrayList<String> allIDDs) {
        boolean isNANP = false;
        String number = numberEntry.number;
        if (number.length() == 7) {
            char firstChar = number.charAt(0);
            if (firstChar >= '2' && firstChar <= '9') {
                isNANP = true;
                for (int i = 1; i < 7; ++i) {
                    char c = number.charAt(i);
                    if (PhoneNumberUtils.isISODigit(c)) continue;
                    isNANP = false;
                    break;
                }
            }
            if (isNANP) {
                return 1;
            }
        } else if (number.length() == 10) {
            if (SmsNumberUtils.isNANP(number)) {
                return 2;
            }
        } else if (number.length() == 11) {
            if (SmsNumberUtils.isNANP(number)) {
                return 3;
            }
        } else if (number.startsWith(PLUS_SIGN)) {
            if ((number = number.substring(1)).length() == 11) {
                if (SmsNumberUtils.isNANP(number)) {
                    return 4;
                }
            } else if (number.startsWith(NANP_IDD) && number.length() == 14 && SmsNumberUtils.isNANP(number = number.substring(3))) {
                return 6;
            }
        } else {
            for (String idd : allIDDs) {
                String number2;
                if (!number.startsWith(idd) || (number2 = number.substring(idd.length())) == null || !number2.startsWith(String.valueOf(1)) || !SmsNumberUtils.isNANP(number2)) continue;
                numberEntry.IDD = idd;
                return 5;
            }
        }
        return 0;
    }

    private static boolean isNANP(String number) {
        if (number.length() == 10 || number.length() == 11 && number.startsWith(NANP_NDD)) {
            if (number.length() == 11) {
                number = number.substring(1);
            }
            return PhoneNumberUtils.isNanp(number);
        }
        return false;
    }

    private static int checkInternationalNumberPlan(Context context, NumberEntry numberEntry, ArrayList<String> allIDDs, String homeIDD) {
        String number = numberEntry.number;
        int countryCode = -1;
        if (number.startsWith(PLUS_SIGN)) {
            String numberNoNBPCD = number.substring(1);
            if (numberNoNBPCD.startsWith(homeIDD)) {
                String numberCountryAreaLocal = numberNoNBPCD.substring(homeIDD.length());
                countryCode = SmsNumberUtils.getCountryCode(context, numberCountryAreaLocal);
                if (countryCode > 0) {
                    numberEntry.countryCode = countryCode;
                    return 100;
                }
            } else {
                countryCode = SmsNumberUtils.getCountryCode(context, numberNoNBPCD);
                if (countryCode > 0) {
                    numberEntry.countryCode = countryCode;
                    return 102;
                }
            }
        } else if (number.startsWith(homeIDD)) {
            String numberCountryAreaLocal = number.substring(homeIDD.length());
            countryCode = SmsNumberUtils.getCountryCode(context, numberCountryAreaLocal);
            if (countryCode > 0) {
                numberEntry.countryCode = countryCode;
                return 101;
            }
        } else {
            for (String exitCode : allIDDs) {
                String numberNoIDD;
                if (!number.startsWith(exitCode) || (countryCode = SmsNumberUtils.getCountryCode(context, numberNoIDD = number.substring(exitCode.length()))) <= 0) continue;
                numberEntry.countryCode = countryCode;
                numberEntry.IDD = exitCode;
                return 103;
            }
            if (!number.startsWith("0") && (countryCode = SmsNumberUtils.getCountryCode(context, number)) > 0) {
                numberEntry.countryCode = countryCode;
                return 104;
            }
        }
        return 0;
    }

    private static int getCountryCode(Context context, String number) {
        int countryCode = -1;
        if (number.length() >= 10) {
            int i;
            int[] allCCs = SmsNumberUtils.getAllCountryCodes(context);
            if (allCCs == null) {
                return countryCode;
            }
            int[] ccArray = new int[MAX_COUNTRY_CODES_LENGTH];
            for (i = 0; i < MAX_COUNTRY_CODES_LENGTH; ++i) {
                ccArray[i] = Integer.parseInt(number.substring(0, i + 1));
            }
            for (i = 0; i < allCCs.length; ++i) {
                int tempCC = allCCs[i];
                for (int j = 0; j < MAX_COUNTRY_CODES_LENGTH; ++j) {
                    if (tempCC != ccArray[j]) continue;
                    if (DBG) {
                        Rlog.d(TAG, "Country code = " + tempCC);
                    }
                    return tempCC;
                }
            }
        }
        return countryCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getAllCountryCodes(Context context) {
        if (ALL_COUNTRY_CODES != null) {
            return ALL_COUNTRY_CODES;
        }
        try (Cursor cursor = null;){
            String[] projection = new String[]{"Country_Code"};
            cursor = context.getContentResolver().query(HbpcdLookup.MccLookup.CONTENT_URI, projection, null, null, null);
            if (cursor.getCount() > 0) {
                ALL_COUNTRY_CODES = new int[cursor.getCount()];
                int i = 0;
                while (cursor.moveToNext()) {
                    int countryCode = cursor.getInt(0);
                    SmsNumberUtils.ALL_COUNTRY_CODES[i++] = countryCode;
                    int length = String.valueOf(countryCode).trim().length();
                    if (length <= MAX_COUNTRY_CODES_LENGTH) continue;
                    MAX_COUNTRY_CODES_LENGTH = length;
                }
            }
        }
        return ALL_COUNTRY_CODES;
    }

    private static boolean inExceptionListForNpCcAreaLocal(NumberEntry numberEntry) {
        int countryCode = numberEntry.countryCode;
        boolean result = numberEntry.number.length() == 12 && (countryCode == 7 || countryCode == 20 || countryCode == 65 || countryCode == 90);
        return result;
    }

    private static String getNumberPlanType(int state) {
        String numberPlanType = "Number Plan type (" + state + "): ";
        numberPlanType = state == 1 ? "NP_NANP_LOCAL" : (state == 2 ? "NP_NANP_AREA_LOCAL" : (state == 3 ? "NP_NANP_NDD_AREA_LOCAL" : (state == 4 ? "NP_NANP_NBPCD_CC_AREA_LOCAL" : (state == 5 ? "NP_NANP_LOCALIDD_CC_AREA_LOCAL" : (state == 6 ? "NP_NANP_NBPCD_HOMEIDD_CC_AREA_LOCAL" : (state == 100 ? "NP_NBPCD_HOMEIDD_CC_AREA_LOCAL" : (state == 101 ? "NP_HOMEIDD_CC_AREA_LOCAL" : (state == 102 ? "NP_NBPCD_CC_AREA_LOCAL" : (state == 103 ? "NP_LOCALIDD_CC_AREA_LOCAL" : (state == 104 ? "NP_CC_AREA_LOCAL" : "Unknown type"))))))))));
        return numberPlanType;
    }

    public static String filterDestAddr(Phone phone, String destAddr) {
        String networkMcc;
        int networkType;
        if (DBG) {
            Rlog.d(TAG, "enter filterDestAddr. destAddr=\"" + Rlog.pii(TAG, (Object)destAddr) + "\"");
        }
        if (destAddr == null || !PhoneNumberUtils.isGlobalPhoneNumber(destAddr)) {
            Rlog.w(TAG, "destAddr" + Rlog.pii(TAG, (Object)destAddr) + " is not a global phone number! Nothing changed.");
            return destAddr;
        }
        String networkOperator = TelephonyManager.from(phone.getContext()).getNetworkOperator(phone.getSubId());
        String result = null;
        if (SmsNumberUtils.needToConvert(phone) && (networkType = SmsNumberUtils.getNetworkType(phone)) != -1 && !TextUtils.isEmpty(networkOperator) && (networkMcc = networkOperator.substring(0, 3)) != null && networkMcc.trim().length() > 0) {
            result = SmsNumberUtils.formatNumber(phone.getContext(), destAddr, networkMcc, networkType);
        }
        if (DBG) {
            Rlog.d(TAG, "destAddr is " + (result != null ? "formatted." : "not formatted."));
            Rlog.d(TAG, "leave filterDestAddr, new destAddr=\"" + (result != null ? Rlog.pii(TAG, (Object)result) : Rlog.pii(TAG, (Object)destAddr)) + "\"");
        }
        return result != null ? result : destAddr;
    }

    private static int getNetworkType(Phone phone) {
        int networkType = -1;
        int phoneType = phone.getPhoneType();
        if (phoneType == 1) {
            networkType = 0;
        } else if (phoneType == 2) {
            networkType = SmsNumberUtils.isInternationalRoaming(phone) ? 2 : 1;
        } else if (DBG) {
            Rlog.w(TAG, "warning! unknown mPhoneType value=" + phoneType);
        }
        return networkType;
    }

    private static boolean isInternationalRoaming(Phone phone) {
        boolean internationalRoaming;
        String operatorIsoCountry = TelephonyManager.from(phone.getContext()).getNetworkCountryIsoForPhone(phone.getPhoneId());
        String simIsoCountry = TelephonyManager.from(phone.getContext()).getSimCountryIsoForPhone(phone.getPhoneId());
        boolean bl = internationalRoaming = !TextUtils.isEmpty(operatorIsoCountry) && !TextUtils.isEmpty(simIsoCountry) && !simIsoCountry.equals(operatorIsoCountry);
        if (internationalRoaming) {
            if ("us".equals(simIsoCountry)) {
                internationalRoaming = !"vi".equals(operatorIsoCountry);
            } else if ("vi".equals(simIsoCountry)) {
                internationalRoaming = !"us".equals(operatorIsoCountry);
            }
        }
        return internationalRoaming;
    }

    private static boolean needToConvert(Phone phone) {
        PersistableBundle bundle;
        CarrierConfigManager configManager = (CarrierConfigManager)phone.getContext().getSystemService("carrier_config");
        if (configManager != null && (bundle = configManager.getConfig()) != null) {
            return bundle.getBoolean("sms_requires_destination_number_conversion_bool");
        }
        return false;
    }

    private static boolean compareGid1(Phone phone, String serviceGid1) {
        String gid1 = phone.getGroupIdLevel1();
        boolean ret = true;
        if (TextUtils.isEmpty(serviceGid1)) {
            if (DBG) {
                Rlog.d(TAG, "compareGid1 serviceGid is empty, return " + ret);
            }
            return ret;
        }
        int gid_length = serviceGid1.length();
        if (gid1 == null || gid1.length() < gid_length || !gid1.substring(0, gid_length).equalsIgnoreCase(serviceGid1)) {
            if (DBG) {
                Rlog.d(TAG, " gid1 " + gid1 + " serviceGid1 " + serviceGid1);
            }
            ret = false;
        }
        if (DBG) {
            Rlog.d(TAG, "compareGid1 is " + (ret ? "Same" : "Different"));
        }
        return ret;
    }

    static {
        IDDS_MAPS = new HashMap();
    }

    private static class NumberEntry {
        public String number;
        public String IDD;
        public int countryCode;

        public NumberEntry(String number) {
            this.number = number;
        }
    }
}

