/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.BroadcastOptions;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IDeviceIdleController;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Telephony;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.SubscriptionManager;
import android.util.Log;
import com.android.internal.telephony.BlockChecker;
import com.android.internal.telephony.IWapPushManager;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.WspTypeDecoder;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.DeliveryInd;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.PduParser;
import com.google.android.mms.pdu.PduPersister;
import com.google.android.mms.pdu.ReadOrigInd;
import java.util.HashMap;

public class WapPushOverSms
implements ServiceConnection {
    private static final String TAG = "WAP PUSH";
    private static final boolean DBG = false;
    private final Context mContext;
    private IDeviceIdleController mDeviceIdleController;
    private String mWapPushManagerPackage;
    private volatile IWapPushManager mWapPushManager;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Rlog.d(WapPushOverSms.TAG, "Received broadcast " + intent.getAction());
            if ("android.intent.action.USER_UNLOCKED".equals(intent.getAction())) {
                new BindServiceThread(WapPushOverSms.this.mContext).start();
            }
        }
    };
    private static final String THREAD_ID_SELECTION = "m_id=? AND m_type=?";
    private static final String LOCATION_SELECTION = "m_type=? AND ct_l =?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindWapPushManagerService(Context context) {
        Intent intent = new Intent(IWapPushManager.class.getName());
        ComponentName comp = intent.resolveSystemService(context.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !context.bindService(intent, this, 1)) {
            Rlog.e(TAG, "bindService() for wappush manager failed");
        } else {
            WapPushOverSms wapPushOverSms = this;
            synchronized (wapPushOverSms) {
                this.mWapPushManagerPackage = comp.getPackageName();
            }
        }
    }

    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        this.mWapPushManager = IWapPushManager.Stub.asInterface(service);
    }

    @Override
    public void onServiceDisconnected(ComponentName name) {
        this.mWapPushManager = null;
    }

    public WapPushOverSms(Context context) {
        this.mContext = context;
        this.mDeviceIdleController = TelephonyComponentFactory.getInstance().getIDeviceIdleController();
        UserManager userManager = (UserManager)this.mContext.getSystemService("user");
        if (userManager.isUserUnlocked()) {
            this.bindWapPushManagerService(this.mContext);
        } else {
            IntentFilter userFilter = new IntentFilter();
            userFilter.addAction("android.intent.action.USER_UNLOCKED");
            context.registerReceiver(this.mBroadcastReceiver, userFilter);
        }
    }

    public void dispose() {
        if (this.mWapPushManager != null) {
            this.mContext.unbindService(this);
        } else {
            Rlog.e(TAG, "dispose: not bound to a wappush manager");
        }
    }

    private DecodedResult decodeWapPdu(byte[] pdu, InboundSmsHandler handler) {
        DecodedResult result = new DecodedResult();
        try {
            NotificationInd nInd;
            byte[] intentData;
            WspTypeDecoder pduDecoder;
            int index = 0;
            int transactionId = pdu[index++] & 0xFF;
            int pduType = pdu[index++] & 0xFF;
            int phoneId = handler.getPhone().getPhoneId();
            if (pduType != 6 && pduType != 7) {
                index = this.mContext.getResources().getInteger(17694856);
                if (index != -1) {
                    transactionId = pdu[index++] & 0xFF;
                    if ((pduType = pdu[index++] & 0xFF) != 6 && pduType != 7) {
                        result.statusCode = 1;
                        return result;
                    }
                } else {
                    result.statusCode = 1;
                    return result;
                }
            }
            if (!(pduDecoder = TelephonyComponentFactory.getInstance().makeWspTypeDecoder(pdu)).decodeUintvarInteger(index)) {
                result.statusCode = 2;
                return result;
            }
            int headerLength = (int)pduDecoder.getValue32();
            int headerStartIndex = index += pduDecoder.getDecodedDataLength();
            if (!pduDecoder.decodeContentType(index)) {
                result.statusCode = 2;
                return result;
            }
            String mimeType = pduDecoder.getValueString();
            long binaryContentType = pduDecoder.getValue32();
            index += pduDecoder.getDecodedDataLength();
            byte[] header = new byte[headerLength];
            System.arraycopy((byte[])pdu, (int)headerStartIndex, (byte[])header, (int)0, (int)header.length);
            if (mimeType != null && mimeType.equals("application/vnd.wap.coc")) {
                intentData = pdu;
            } else {
                int dataIndex = headerStartIndex + headerLength;
                intentData = new byte[pdu.length - dataIndex];
                System.arraycopy((byte[])pdu, (int)dataIndex, (byte[])intentData, (int)0, (int)intentData.length);
            }
            int[] subIds = SubscriptionManager.getSubId(phoneId);
            int subId = subIds != null && subIds.length > 0 ? subIds[0] : SmsManager.getDefaultSmsSubscriptionId();
            GenericPdu parsedPdu = null;
            try {
                parsedPdu = new PduParser(intentData, WapPushOverSms.shouldParseContentDisposition(subId)).parse();
            }
            catch (Exception e) {
                Rlog.e(TAG, "Unable to parse PDU: " + e.toString());
            }
            if (parsedPdu != null && parsedPdu.getMessageType() == 130 && (nInd = (NotificationInd)parsedPdu).getFrom() != null && BlockChecker.isBlocked(this.mContext, nInd.getFrom().getString())) {
                result.statusCode = 1;
                return result;
            }
            if (pduDecoder.seekXWapApplicationId(index, index + headerLength - 1)) {
                String contentType;
                index = (int)pduDecoder.getValue32();
                pduDecoder.decodeXWapApplicationId(index);
                String wapAppId = pduDecoder.getValueString();
                if (wapAppId == null) {
                    wapAppId = Integer.toString((int)pduDecoder.getValue32());
                }
                result.wapAppId = wapAppId;
                result.contentType = contentType = mimeType == null ? Long.toString(binaryContentType) : mimeType;
            }
            result.subId = subId;
            result.phoneId = phoneId;
            result.parsedPdu = parsedPdu;
            result.mimeType = mimeType;
            result.transactionId = transactionId;
            result.pduType = pduType;
            result.header = header;
            result.intentData = intentData;
            result.contentTypeParameters = pduDecoder.getContentParameters();
            result.statusCode = -1;
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            Rlog.e(TAG, "ignoring dispatchWapPdu() array index exception: " + aie);
            result.statusCode = 2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dispatchWapPdu(byte[] pdu, BroadcastReceiver receiver, InboundSmsHandler handler) {
        DecodedResult result = this.decodeWapPdu(pdu, handler);
        if (result.statusCode != -1) {
            return result.statusCode;
        }
        if (SmsManager.getDefault().getAutoPersisting()) {
            this.writeInboxMessage(result.subId, result.parsedPdu);
        }
        if (result.wapAppId != null) {
            try {
                boolean processFurther = true;
                IWapPushManager wapPushMan = this.mWapPushManager;
                if (wapPushMan != null) {
                    WapPushOverSms wapPushOverSms = this;
                    synchronized (wapPushOverSms) {
                        this.mDeviceIdleController.addPowerSaveTempWhitelistAppForMms(this.mWapPushManagerPackage, 0, "mms-mgr");
                    }
                    Intent intent = new Intent();
                    intent.putExtra("transactionId", result.transactionId);
                    intent.putExtra("pduType", result.pduType);
                    intent.putExtra("header", result.header);
                    intent.putExtra("data", result.intentData);
                    intent.putExtra("contentTypeParameters", result.contentTypeParameters);
                    SubscriptionManager.putPhoneIdAndSubIdExtra(intent, result.phoneId);
                    int procRet = wapPushMan.processMessage(result.wapAppId, result.contentType, intent);
                    if ((procRet & 1) > 0 && (procRet & 0x8000) == 0) {
                        processFurther = false;
                    }
                }
                if (!processFurther) {
                    return 1;
                }
            }
            catch (RemoteException processFurther) {
                // empty catch block
            }
        }
        if (result.mimeType == null) {
            return 2;
        }
        Intent intent = new Intent("android.provider.Telephony.WAP_PUSH_DELIVER");
        intent.setType(result.mimeType);
        intent.putExtra("transactionId", result.transactionId);
        intent.putExtra("pduType", result.pduType);
        intent.putExtra("header", result.header);
        intent.putExtra("data", result.intentData);
        intent.putExtra("contentTypeParameters", result.contentTypeParameters);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, result.phoneId);
        ComponentName componentName = SmsApplication.getDefaultMmsApplication(this.mContext, true);
        Bundle options = null;
        if (componentName != null) {
            intent.setComponent(componentName);
            try {
                long duration = this.mDeviceIdleController.addPowerSaveTempWhitelistAppForMms(componentName.getPackageName(), 0, "mms-app");
                BroadcastOptions bopts = BroadcastOptions.makeBasic();
                bopts.setTemporaryAppWhitelistDuration(duration);
                options = bopts.toBundle();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        handler.dispatchIntent(intent, WapPushOverSms.getPermissionForType(result.mimeType), WapPushOverSms.getAppOpsPermissionForIntent(result.mimeType), options, receiver, UserHandle.SYSTEM);
        return -1;
    }

    public boolean isWapPushForMms(byte[] pdu, InboundSmsHandler handler) {
        DecodedResult result = this.decodeWapPdu(pdu, handler);
        return result.statusCode == -1 && "application/vnd.wap.mms-message".equals(result.mimeType);
    }

    private static boolean shouldParseContentDisposition(int subId) {
        return SmsManager.getSmsManagerForSubscriptionId(subId).getCarrierConfigValues().getBoolean("supportMmsContentDisposition", true);
    }

    private void writeInboxMessage(int subId, GenericPdu pdu) {
        if (pdu == null) {
            Rlog.e(TAG, "Invalid PUSH PDU");
        }
        PduPersister persister = PduPersister.getPduPersister(this.mContext);
        int type = pdu.getMessageType();
        try {
            switch (type) {
                case 134: 
                case 136: {
                    long threadId = WapPushOverSms.getDeliveryOrReadReportThreadId(this.mContext, pdu);
                    if (threadId == -1L) {
                        Rlog.e(TAG, "Failed to find delivery or read report's thread id");
                        break;
                    }
                    Uri uri = persister.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI, true, true, null);
                    if (uri == null) {
                        Rlog.e(TAG, "Failed to persist delivery or read report");
                        break;
                    }
                    ContentValues values = new ContentValues(1);
                    values.put("thread_id", threadId);
                    if (SqliteWrapper.update(this.mContext, this.mContext.getContentResolver(), uri, values, null, null) != 1) {
                        Rlog.e(TAG, "Failed to update delivery or read report thread id");
                    }
                    break;
                }
                case 130: {
                    byte[] contentLocation;
                    NotificationInd nInd = (NotificationInd)pdu;
                    Bundle configs = SmsManager.getSmsManagerForSubscriptionId(subId).getCarrierConfigValues();
                    if (configs != null && configs.getBoolean("enabledTransID", false) && 61 == (contentLocation = nInd.getContentLocation())[contentLocation.length - 1]) {
                        byte[] transactionId = nInd.getTransactionId();
                        byte[] contentLocationWithId = new byte[contentLocation.length + transactionId.length];
                        System.arraycopy((byte[])contentLocation, (int)0, (byte[])contentLocationWithId, (int)0, (int)contentLocation.length);
                        System.arraycopy((byte[])transactionId, (int)0, (byte[])contentLocationWithId, (int)contentLocation.length, (int)transactionId.length);
                        nInd.setContentLocation(contentLocationWithId);
                    }
                    if (!WapPushOverSms.isDuplicateNotification(this.mContext, nInd)) {
                        Uri uri = persister.persist(pdu, Telephony.Mms.Inbox.CONTENT_URI, true, true, null);
                        if (uri == null) {
                            Rlog.e(TAG, "Failed to save MMS WAP push notification ind");
                        }
                        break;
                    }
                    Rlog.d(TAG, "Skip storing duplicate MMS WAP push notification ind: " + new String(nInd.getContentLocation()));
                    break;
                }
                default: {
                    Log.e(TAG, "Received unrecognized WAP Push PDU.");
                }
            }
        }
        catch (MmsException e) {
            Log.e(TAG, "Failed to save MMS WAP push data: type=" + type, e);
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Unexpected RuntimeException in persisting MMS WAP push data", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getDeliveryOrReadReportThreadId(Context context, GenericPdu pdu) {
        String messageId;
        if (pdu instanceof DeliveryInd) {
            messageId = new String(((DeliveryInd)pdu).getMessageId());
        } else if (pdu instanceof ReadOrigInd) {
            messageId = new String(((ReadOrigInd)pdu).getMessageId());
        } else {
            Rlog.e(TAG, "WAP Push data is neither delivery or read report type: " + pdu.getClass().getCanonicalName());
            return -1L;
        }
        try (Cursor cursor = null;){
            cursor = SqliteWrapper.query(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, new String[]{"thread_id"}, THREAD_ID_SELECTION, new String[]{DatabaseUtils.sqlEscapeString(messageId), Integer.toString(128)}, null);
            if (cursor != null && cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDuplicateNotification(Context context, NotificationInd nInd) {
        byte[] rawLocation = nInd.getContentLocation();
        if (rawLocation != null) {
            String location = new String(rawLocation);
            String[] selectionArgs = new String[]{location};
            try (Cursor cursor = null;){
                cursor = SqliteWrapper.query(context, context.getContentResolver(), Telephony.Mms.CONTENT_URI, new String[]{"_id"}, LOCATION_SELECTION, new String[]{Integer.toString(130), new String(rawLocation)}, null);
                if (cursor != null && cursor.getCount() > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public static String getPermissionForType(String mimeType) {
        String permission2 = "application/vnd.wap.mms-message".equals(mimeType) ? "android.permission.RECEIVE_MMS" : "android.permission.RECEIVE_WAP_PUSH";
        return permission2;
    }

    public static int getAppOpsPermissionForIntent(String mimeType) {
        int appOp = "application/vnd.wap.mms-message".equals(mimeType) ? 18 : 19;
        return appOp;
    }

    private final class DecodedResult {
        String mimeType;
        String contentType;
        int transactionId;
        int pduType;
        int phoneId;
        int subId;
        byte[] header;
        String wapAppId;
        byte[] intentData;
        HashMap<String, String> contentTypeParameters;
        GenericPdu parsedPdu;
        int statusCode;

        private DecodedResult() {
        }
    }

    private class BindServiceThread
    extends Thread {
        private final Context context;

        private BindServiceThread(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            WapPushOverSms.this.bindWapPushManagerService(this.context);
        }
    }
}

