/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.cat.AppInterface;
import com.android.internal.telephony.cat.BIPClientParams;
import com.android.internal.telephony.cat.CallSetupParams;
import com.android.internal.telephony.cat.CatCmdMessage;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.CatResponseMessage;
import com.android.internal.telephony.cat.CommandDetails;
import com.android.internal.telephony.cat.CommandParams;
import com.android.internal.telephony.cat.ComprehensionTlvTag;
import com.android.internal.telephony.cat.DTTZResponseData;
import com.android.internal.telephony.cat.DisplayTextParams;
import com.android.internal.telephony.cat.Duration;
import com.android.internal.telephony.cat.GetInkeyInputResponseData;
import com.android.internal.telephony.cat.Input;
import com.android.internal.telephony.cat.LanguageResponseData;
import com.android.internal.telephony.cat.LaunchBrowserParams;
import com.android.internal.telephony.cat.Menu;
import com.android.internal.telephony.cat.ResponseData;
import com.android.internal.telephony.cat.ResultCode;
import com.android.internal.telephony.cat.RilMessage;
import com.android.internal.telephony.cat.RilMessageDecoder;
import com.android.internal.telephony.cat.SelectItemResponseData;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccUtils;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Locale;

public class CatService
extends Handler
implements AppInterface {
    private static final boolean DBG = false;
    private static IccRecords mIccRecords;
    private static UiccCardApplication mUiccApplication;
    private static final Object sInstanceLock;
    private static CatService[] sInstance;
    private CommandsInterface mCmdIf;
    private Context mContext;
    private CatCmdMessage mCurrntCmd = null;
    private CatCmdMessage mMenuCmd = null;
    private RilMessageDecoder mMsgDecoder = null;
    private boolean mStkAppInstalled = false;
    private UiccController mUiccController;
    private IccCardStatus.CardState mCardState = IccCardStatus.CardState.CARDSTATE_ABSENT;
    protected static final int MSG_ID_SESSION_END = 1;
    protected static final int MSG_ID_PROACTIVE_COMMAND = 2;
    protected static final int MSG_ID_EVENT_NOTIFY = 3;
    protected static final int MSG_ID_CALL_SETUP = 4;
    static final int MSG_ID_REFRESH = 5;
    static final int MSG_ID_RESPONSE = 6;
    static final int MSG_ID_SIM_READY = 7;
    protected static final int MSG_ID_ICC_CHANGED = 8;
    protected static final int MSG_ID_ALPHA_NOTIFY = 9;
    static final int MSG_ID_RIL_MSG_DECODED = 10;
    private static final int MSG_ID_ICC_RECORDS_LOADED = 20;
    private static final int MSG_ID_ICC_REFRESH = 30;
    private static final int DEV_ID_KEYPAD = 1;
    private static final int DEV_ID_DISPLAY = 2;
    private static final int DEV_ID_UICC = 129;
    private static final int DEV_ID_TERMINAL = 130;
    private static final int DEV_ID_NETWORK = 131;
    static final String STK_DEFAULT = "Default Message";
    private HandlerThread mHandlerThread;
    private int mSlotId;

    private CatService(CommandsInterface ci, UiccCardApplication ca, IccRecords ir, Context context, IccFileHandler fh, UiccCard ic, int slotId) {
        if (ci == null || ca == null || ir == null || context == null || fh == null || ic == null) {
            throw new NullPointerException("Service: Input parameters must not be null");
        }
        this.mCmdIf = ci;
        this.mContext = context;
        this.mSlotId = slotId;
        this.mHandlerThread = new HandlerThread("Cat Telephony service" + slotId);
        this.mHandlerThread.start();
        this.mMsgDecoder = RilMessageDecoder.getInstance(this, fh, slotId);
        if (null == this.mMsgDecoder) {
            CatLog.d(this, "Null RilMessageDecoder instance");
            return;
        }
        this.mMsgDecoder.start();
        this.mCmdIf.setOnCatSessionEnd(this, 1, null);
        this.mCmdIf.setOnCatProactiveCmd(this, 2, null);
        this.mCmdIf.setOnCatEvent(this, 3, null);
        this.mCmdIf.setOnCatCallSetUp(this, 4, null);
        this.mCmdIf.registerForIccRefresh(this, 30, null);
        this.mCmdIf.setOnCatCcAlphaNotify(this, 9, null);
        mIccRecords = ir;
        mUiccApplication = ca;
        mIccRecords.registerForRecordsLoaded(this, 20, null);
        CatLog.d(this, "registerForRecordsLoaded slotid=" + this.mSlotId + " instance:" + this);
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 8, null);
        this.mStkAppInstalled = this.isStkAppInstalled();
        CatLog.d(this, "Running CAT service on Slotid: " + this.mSlotId + ". STK app installed:" + this.mStkAppInstalled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CatService getInstance(CommandsInterface ci, Context context, UiccCard ic, int slotId) {
        UiccCardApplication ca = null;
        IccFileHandler fh = null;
        IccRecords ir = null;
        if (ic != null && (ca = ic.getApplicationIndex(0)) != null) {
            fh = ca.getIccFileHandler();
            ir = ca.getIccRecords();
        }
        Object object = sInstanceLock;
        synchronized (object) {
            if (sInstance == null) {
                int simCount = TelephonyManager.getDefault().getSimCount();
                sInstance = new CatService[simCount];
                for (int i = 0; i < simCount; ++i) {
                    CatService.sInstance[i] = null;
                }
            }
            if (sInstance[slotId] == null) {
                if (ci == null || ca == null || ir == null || context == null || fh == null || ic == null) {
                    return null;
                }
                CatService.sInstance[slotId] = new CatService(ci, ca, ir, context, fh, ic, slotId);
            } else if (ir != null && mIccRecords != ir) {
                if (mIccRecords != null) {
                    mIccRecords.unregisterForRecordsLoaded(sInstance[slotId]);
                }
                mIccRecords = ir;
                mUiccApplication = ca;
                mIccRecords.registerForRecordsLoaded(sInstance[slotId], 20, null);
                CatLog.d(sInstance[slotId], "registerForRecordsLoaded slotid=" + slotId + " instance:" + sInstance[slotId]);
            }
            return sInstance[slotId];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = sInstanceLock;
        synchronized (object) {
            CatLog.d(this, "Disposing CatService object");
            mIccRecords.unregisterForRecordsLoaded(this);
            this.broadcastCardStateAndIccRefreshResp(IccCardStatus.CardState.CARDSTATE_ABSENT, null);
            this.mCmdIf.unSetOnCatSessionEnd(this);
            this.mCmdIf.unSetOnCatProactiveCmd(this);
            this.mCmdIf.unSetOnCatEvent(this);
            this.mCmdIf.unSetOnCatCallSetUp(this);
            this.mCmdIf.unSetOnCatCcAlphaNotify(this);
            this.mCmdIf.unregisterForIccRefresh(this);
            if (this.mUiccController != null) {
                this.mUiccController.unregisterForIccChanged(this);
                this.mUiccController = null;
            }
            this.mMsgDecoder.dispose();
            this.mMsgDecoder = null;
            this.mHandlerThread.quit();
            this.mHandlerThread = null;
            this.removeCallbacksAndMessages(null);
            if (sInstance != null) {
                if (SubscriptionManager.isValidSlotIndex(this.mSlotId)) {
                    CatService.sInstance[this.mSlotId] = null;
                } else {
                    CatLog.d(this, "error: invaild slot id: " + this.mSlotId);
                }
            }
        }
    }

    protected void finalize() {
        CatLog.d(this, "Service finalized");
    }

    private void handleRilMsg(RilMessage rilMsg) {
        if (rilMsg == null) {
            return;
        }
        CommandParams cmdParams = null;
        switch (rilMsg.mId) {
            case 3: {
                if (rilMsg.mResCode != ResultCode.OK || (cmdParams = (CommandParams)rilMsg.mData) == null) break;
                this.handleCommand(cmdParams, false);
                break;
            }
            case 2: {
                try {
                    cmdParams = (CommandParams)rilMsg.mData;
                }
                catch (ClassCastException e) {
                    CatLog.d(this, "Fail to parse proactive command");
                    if (this.mCurrntCmd == null) break;
                    this.sendTerminalResponse(this.mCurrntCmd.mCmdDet, ResultCode.CMD_DATA_NOT_UNDERSTOOD, false, 0, null);
                    break;
                }
                if (cmdParams == null) break;
                if (rilMsg.mResCode == ResultCode.OK) {
                    this.handleCommand(cmdParams, true);
                    break;
                }
                this.sendTerminalResponse(cmdParams.mCmdDet, rilMsg.mResCode, false, 0, null);
                break;
            }
            case 5: {
                cmdParams = (CommandParams)rilMsg.mData;
                if (cmdParams == null) break;
                this.handleCommand(cmdParams, false);
                break;
            }
            case 1: {
                this.handleSessionEnd();
                break;
            }
        }
    }

    private boolean isSupportedSetupEventCommand(CatCmdMessage cmdMsg) {
        boolean flag = true;
        block3: for (int eventVal : cmdMsg.getSetEventList().eventList) {
            CatLog.d(this, "Event: " + eventVal);
            switch (eventVal) {
                case 5: 
                case 7: {
                    continue block3;
                }
                default: {
                    flag = false;
                }
            }
        }
        return flag;
    }

    private void handleCommand(CommandParams cmdParams, boolean isProactiveCmd) {
        CatLog.d(this, cmdParams.getCommandType().name());
        if (isProactiveCmd && this.mUiccController != null) {
            this.mUiccController.addCardLog("ProactiveCommand mSlotId=" + this.mSlotId + " cmdParams=" + cmdParams);
        }
        CatCmdMessage cmdMsg = new CatCmdMessage(cmdParams);
        switch (cmdParams.getCommandType()) {
            case SET_UP_MENU: {
                this.mMenuCmd = this.removeMenu(cmdMsg.getMenu()) ? null : cmdMsg;
                ResultCode resultCode = cmdParams.mLoadIconFailed ? ResultCode.PRFRMD_ICON_NOT_DISPLAYED : ResultCode.OK;
                this.sendTerminalResponse(cmdParams.mCmdDet, resultCode, false, 0, null);
                break;
            }
            case DISPLAY_TEXT: {
                break;
            }
            case REFRESH: {
                cmdParams.mCmdDet.typeOfCommand = AppInterface.CommandType.SET_UP_IDLE_MODE_TEXT.value();
                break;
            }
            case SET_UP_IDLE_MODE_TEXT: {
                ResultCode resultCode = cmdParams.mLoadIconFailed ? ResultCode.PRFRMD_ICON_NOT_DISPLAYED : ResultCode.OK;
                this.sendTerminalResponse(cmdParams.mCmdDet, resultCode, false, 0, null);
                break;
            }
            case SET_UP_EVENT_LIST: {
                if (this.isSupportedSetupEventCommand(cmdMsg)) {
                    this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, null);
                    break;
                }
                this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.BEYOND_TERMINAL_CAPABILITY, false, 0, null);
                break;
            }
            case PROVIDE_LOCAL_INFORMATION: {
                switch (cmdParams.mCmdDet.commandQualifier) {
                    case 3: {
                        DTTZResponseData resp = new DTTZResponseData(null);
                        this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, resp);
                        break;
                    }
                    case 4: {
                        LanguageResponseData resp = new LanguageResponseData(Locale.getDefault().getLanguage());
                        this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, resp);
                        break;
                    }
                    default: {
                        this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, null);
                    }
                }
                return;
            }
            case LAUNCH_BROWSER: {
                if (((LaunchBrowserParams)cmdParams).mConfirmMsg.text == null || !((LaunchBrowserParams)cmdParams).mConfirmMsg.text.equals(STK_DEFAULT)) break;
                CharSequence message = this.mContext.getText(17040077);
                ((LaunchBrowserParams)cmdParams).mConfirmMsg.text = message.toString();
                break;
            }
            case SELECT_ITEM: 
            case GET_INPUT: 
            case GET_INKEY: {
                break;
            }
            case SEND_DTMF: 
            case SEND_SMS: 
            case SEND_SS: 
            case SEND_USSD: {
                if (((DisplayTextParams)cmdParams).mTextMsg.text == null || !((DisplayTextParams)cmdParams).mTextMsg.text.equals(STK_DEFAULT)) break;
                CharSequence message = this.mContext.getText(17040753);
                ((DisplayTextParams)cmdParams).mTextMsg.text = message.toString();
                break;
            }
            case PLAY_TONE: {
                break;
            }
            case SET_UP_CALL: {
                if (((CallSetupParams)cmdParams).mConfirmMsg.text == null || !((CallSetupParams)cmdParams).mConfirmMsg.text.equals(STK_DEFAULT)) break;
                CharSequence message = this.mContext.getText(17039414);
                ((CallSetupParams)cmdParams).mConfirmMsg.text = message.toString();
                break;
            }
            case OPEN_CHANNEL: 
            case CLOSE_CHANNEL: 
            case RECEIVE_DATA: 
            case SEND_DATA: {
                BIPClientParams cmd = (BIPClientParams)cmdParams;
                boolean noAlphaUsrCnf = false;
                try {
                    noAlphaUsrCnf = this.mContext.getResources().getBoolean(17957007);
                }
                catch (Resources.NotFoundException e) {
                    noAlphaUsrCnf = false;
                }
                if (cmd.mTextMsg.text == null && (cmd.mHasAlphaId || noAlphaUsrCnf)) {
                    CatLog.d(this, "cmd " + (Object)((Object)cmdParams.getCommandType()) + " with null alpha id");
                    if (isProactiveCmd) {
                        this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, null);
                    } else if (cmdParams.getCommandType() == AppInterface.CommandType.OPEN_CHANNEL) {
                        this.mCmdIf.handleCallSetupRequestFromSim(true, null);
                    }
                    return;
                }
                if (!this.mStkAppInstalled) {
                    CatLog.d(this, "No STK application found.");
                    if (isProactiveCmd) {
                        this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.BEYOND_TERMINAL_CAPABILITY, false, 0, null);
                        return;
                    }
                }
                if (!isProactiveCmd || cmdParams.getCommandType() != AppInterface.CommandType.CLOSE_CHANNEL && cmdParams.getCommandType() != AppInterface.CommandType.RECEIVE_DATA && cmdParams.getCommandType() != AppInterface.CommandType.SEND_DATA) break;
                this.sendTerminalResponse(cmdParams.mCmdDet, ResultCode.OK, false, 0, null);
                break;
            }
            default: {
                CatLog.d(this, "Unsupported command");
                return;
            }
        }
        this.mCurrntCmd = cmdMsg;
        this.broadcastCatCmdIntent(cmdMsg);
    }

    private void broadcastCatCmdIntent(CatCmdMessage cmdMsg) {
        Intent intent = new Intent("com.android.internal.stk.command");
        intent.putExtra("STK CMD", cmdMsg);
        intent.putExtra("SLOT_ID", this.mSlotId);
        intent.setComponent(AppInterface.getDefaultSTKApplication());
        CatLog.d(this, "Sending CmdMsg: " + cmdMsg + " on slotid:" + this.mSlotId);
        this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_STK_COMMANDS");
    }

    private void handleSessionEnd() {
        CatLog.d(this, "SESSION END on " + this.mSlotId);
        this.mCurrntCmd = this.mMenuCmd;
        Intent intent = new Intent("com.android.internal.stk.session_end");
        intent.putExtra("SLOT_ID", this.mSlotId);
        intent.setComponent(AppInterface.getDefaultSTKApplication());
        this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_STK_COMMANDS");
    }

    private void sendTerminalResponse(CommandDetails cmdDet, ResultCode resultCode, boolean includeAdditionalInfo, int additionalInfo, ResponseData resp) {
        if (cmdDet == null) {
            return;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        Input cmdInput = null;
        if (this.mCurrntCmd != null) {
            cmdInput = this.mCurrntCmd.geInput();
        }
        int tag = ComprehensionTlvTag.COMMAND_DETAILS.value();
        if (cmdDet.compRequired) {
            tag |= 0x80;
        }
        buf.write(tag);
        buf.write(3);
        buf.write(cmdDet.commandNumber);
        buf.write(cmdDet.typeOfCommand);
        buf.write(cmdDet.commandQualifier);
        tag = ComprehensionTlvTag.DEVICE_IDENTITIES.value();
        buf.write(tag);
        buf.write(2);
        buf.write(130);
        buf.write(129);
        tag = ComprehensionTlvTag.RESULT.value();
        if (cmdDet.compRequired) {
            tag |= 0x80;
        }
        buf.write(tag);
        int length = includeAdditionalInfo ? 2 : 1;
        buf.write(length);
        buf.write(resultCode.value());
        if (includeAdditionalInfo) {
            buf.write(additionalInfo);
        }
        if (resp != null) {
            resp.format(buf);
        } else {
            this.encodeOptionalTags(cmdDet, resultCode, cmdInput, buf);
        }
        byte[] rawData = buf.toByteArray();
        String hexString = IccUtils.bytesToHexString(rawData);
        this.mCmdIf.sendTerminalResponse(hexString, null);
    }

    private void encodeOptionalTags(CommandDetails cmdDet, ResultCode resultCode, Input cmdInput, ByteArrayOutputStream buf) {
        block7: {
            block6: {
                AppInterface.CommandType cmdType = AppInterface.CommandType.fromInt(cmdDet.typeOfCommand);
                if (cmdType == null) break block6;
                switch (cmdType) {
                    case GET_INKEY: {
                        if (resultCode.value() == ResultCode.NO_RESPONSE_FROM_USER.value() && cmdInput != null && cmdInput.duration != null) {
                            this.getInKeyResponse(buf, cmdInput);
                            break;
                        }
                        break block7;
                    }
                    case PROVIDE_LOCAL_INFORMATION: {
                        if (cmdDet.commandQualifier == 4 && resultCode.value() == ResultCode.OK.value()) {
                            this.getPliResponse(buf);
                            break;
                        }
                        break block7;
                    }
                    default: {
                        CatLog.d(this, "encodeOptionalTags() Unsupported Cmd details=" + cmdDet);
                        break;
                    }
                }
                break block7;
            }
            CatLog.d(this, "encodeOptionalTags() bad Cmd details=" + cmdDet);
        }
    }

    private void getInKeyResponse(ByteArrayOutputStream buf, Input cmdInput) {
        int tag = ComprehensionTlvTag.DURATION.value();
        buf.write(tag);
        buf.write(2);
        Duration.TimeUnit cfr_ignored_0 = cmdInput.duration.timeUnit;
        buf.write(Duration.TimeUnit.SECOND.value());
        buf.write(cmdInput.duration.timeInterval);
    }

    private void getPliResponse(ByteArrayOutputStream buf) {
        String lang = Locale.getDefault().getLanguage();
        if (lang != null) {
            int tag = ComprehensionTlvTag.LANGUAGE.value();
            buf.write(tag);
            ResponseData.writeLength(buf, lang.length());
            buf.write(lang.getBytes(), 0, lang.length());
        }
    }

    private void sendMenuSelection(int menuId, boolean helpRequired) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int tag = 211;
        buf.write(tag);
        buf.write(0);
        tag = 0x80 | ComprehensionTlvTag.DEVICE_IDENTITIES.value();
        buf.write(tag);
        buf.write(2);
        buf.write(1);
        buf.write(129);
        tag = 0x80 | ComprehensionTlvTag.ITEM_ID.value();
        buf.write(tag);
        buf.write(1);
        buf.write(menuId);
        if (helpRequired) {
            tag = ComprehensionTlvTag.HELP_REQUEST.value();
            buf.write(tag);
            buf.write(0);
        }
        byte[] rawData = buf.toByteArray();
        int len = rawData.length - 2;
        rawData[1] = (byte)len;
        String hexString = IccUtils.bytesToHexString(rawData);
        this.mCmdIf.sendEnvelope(hexString, null);
    }

    private void eventDownload(int event, int sourceId, int destinationId, byte[] additionalInfo, boolean oneShot) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int tag = 214;
        buf.write(tag);
        buf.write(0);
        tag = 0x80 | ComprehensionTlvTag.EVENT_LIST.value();
        buf.write(tag);
        buf.write(1);
        buf.write(event);
        tag = 0x80 | ComprehensionTlvTag.DEVICE_IDENTITIES.value();
        buf.write(tag);
        buf.write(2);
        buf.write(sourceId);
        buf.write(destinationId);
        switch (event) {
            case 5: {
                CatLog.d(sInstance, " Sending Idle Screen Available event download to ICC");
                break;
            }
            case 7: {
                CatLog.d(sInstance, " Sending Language Selection event download to ICC");
                tag = 0x80 | ComprehensionTlvTag.LANGUAGE.value();
                buf.write(tag);
                buf.write(2);
                break;
            }
        }
        if (additionalInfo != null) {
            for (byte b : additionalInfo) {
                buf.write(b);
            }
        }
        byte[] rawData = buf.toByteArray();
        int len = rawData.length - 2;
        rawData[1] = (byte)len;
        String hexString = IccUtils.bytesToHexString(rawData);
        CatLog.d(this, "ENVELOPE COMMAND: " + hexString);
        this.mCmdIf.sendEnvelope(hexString, null);
    }

    public static AppInterface getInstance() {
        int slotId = 0;
        SubscriptionController sControl = SubscriptionController.getInstance();
        if (sControl != null) {
            slotId = sControl.getSlotIndex(sControl.getDefaultSubId());
        }
        return CatService.getInstance(null, null, null, slotId);
    }

    public static AppInterface getInstance(int slotId) {
        return CatService.getInstance(null, null, null, slotId);
    }

    @Override
    public void handleMessage(Message msg) {
        CatLog.d(this, "handleMessage[" + msg.what + "]");
        switch (msg.what) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                AsyncResult ar;
                CatLog.d(this, "ril message arrived,slotid:" + this.mSlotId);
                String data = null;
                if (msg.obj != null && (ar = (AsyncResult)msg.obj) != null && ar.result != null) {
                    try {
                        data = (String)ar.result;
                    }
                    catch (ClassCastException e) {
                        break;
                    }
                }
                this.mMsgDecoder.sendStartDecodingMessageParams(new RilMessage(msg.what, data));
                break;
            }
            case 4: {
                this.mMsgDecoder.sendStartDecodingMessageParams(new RilMessage(msg.what, null));
                break;
            }
            case 20: {
                break;
            }
            case 10: {
                this.handleRilMsg((RilMessage)msg.obj);
                break;
            }
            case 6: {
                this.handleCmdResponse((CatResponseMessage)msg.obj);
                break;
            }
            case 8: {
                CatLog.d(this, "MSG_ID_ICC_CHANGED");
                this.updateIccAvailability();
                break;
            }
            case 30: {
                if (msg.obj != null) {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar != null && ar.result != null) {
                        this.broadcastCardStateAndIccRefreshResp(IccCardStatus.CardState.CARDSTATE_PRESENT, (IccRefreshResponse)ar.result);
                        break;
                    }
                    CatLog.d(this, "Icc REFRESH with exception: " + ar.exception);
                    break;
                }
                CatLog.d(this, "IccRefresh Message is null");
                break;
            }
            case 9: {
                CatLog.d(this, "Received CAT CC Alpha message from card");
                if (msg.obj != null) {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar != null && ar.result != null) {
                        this.broadcastAlphaMessage((String)ar.result);
                        break;
                    }
                    CatLog.d(this, "CAT Alpha message: ar.result is null");
                    break;
                }
                CatLog.d(this, "CAT Alpha message: msg.obj is null");
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognized CAT command: " + msg.what));
            }
        }
    }

    private void broadcastCardStateAndIccRefreshResp(IccCardStatus.CardState cardState, IccRefreshResponse iccRefreshState) {
        boolean cardPresent;
        Intent intent = new Intent("com.android.internal.stk.icc_status_change");
        boolean bl = cardPresent = cardState == IccCardStatus.CardState.CARDSTATE_PRESENT;
        if (iccRefreshState != null) {
            intent.putExtra("refresh_result", iccRefreshState.refreshResult);
            CatLog.d(this, "Sending IccResult with Result: " + iccRefreshState.refreshResult);
        }
        intent.putExtra("card_status", cardPresent);
        intent.setComponent(AppInterface.getDefaultSTKApplication());
        CatLog.d(this, "Sending Card Status: " + (Object)((Object)cardState) + " " + "cardPresent: " + cardPresent);
        this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_STK_COMMANDS");
    }

    private void broadcastAlphaMessage(String alphaString) {
        CatLog.d(this, "Broadcasting CAT Alpha message from card: " + alphaString);
        Intent intent = new Intent("com.android.internal.stk.alpha_notify");
        intent.addFlags(0x10000000);
        intent.putExtra("alpha_string", alphaString);
        intent.putExtra("SLOT_ID", this.mSlotId);
        intent.setComponent(AppInterface.getDefaultSTKApplication());
        this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_STK_COMMANDS");
    }

    @Override
    public synchronized void onCmdResponse(CatResponseMessage resMsg) {
        if (resMsg == null) {
            return;
        }
        Message msg = this.obtainMessage(6, resMsg);
        msg.sendToTarget();
    }

    private boolean validateResponse(CatResponseMessage resMsg) {
        boolean validResponse = false;
        if (resMsg.mCmdDet.typeOfCommand == AppInterface.CommandType.SET_UP_EVENT_LIST.value() || resMsg.mCmdDet.typeOfCommand == AppInterface.CommandType.SET_UP_MENU.value()) {
            CatLog.d(this, "CmdType: " + resMsg.mCmdDet.typeOfCommand);
            validResponse = true;
        } else if (this.mCurrntCmd != null) {
            validResponse = resMsg.mCmdDet.compareTo(this.mCurrntCmd.mCmdDet);
            CatLog.d(this, "isResponse for last valid cmd: " + validResponse);
        }
        return validResponse;
    }

    private boolean removeMenu(Menu menu2) {
        try {
            if (menu2.items.size() == 1 && menu2.items.get(0) == null) {
                return true;
            }
        }
        catch (NullPointerException e) {
            CatLog.d(this, "Unable to get Menu's items size");
            return true;
        }
        return false;
    }

    private void handleCmdResponse(CatResponseMessage resMsg) {
        if (!this.validateResponse(resMsg)) {
            return;
        }
        ResponseData resp = null;
        boolean helpRequired = false;
        CommandDetails cmdDet = resMsg.getCmdDetails();
        AppInterface.CommandType type = AppInterface.CommandType.fromInt(cmdDet.typeOfCommand);
        switch (resMsg.mResCode) {
            case HELP_INFO_REQUIRED: {
                helpRequired = true;
            }
            case OK: 
            case PRFRMD_WITH_PARTIAL_COMPREHENSION: 
            case PRFRMD_WITH_MISSING_INFO: 
            case PRFRMD_WITH_ADDITIONAL_EFS_READ: 
            case PRFRMD_ICON_NOT_DISPLAYED: 
            case PRFRMD_MODIFIED_BY_NAA: 
            case PRFRMD_LIMITED_SERVICE: 
            case PRFRMD_WITH_MODIFICATION: 
            case PRFRMD_NAA_NOT_ACTIVE: 
            case PRFRMD_TONE_NOT_PLAYED: 
            case LAUNCH_BROWSER_ERROR: 
            case TERMINAL_CRNTLY_UNABLE_TO_PROCESS: {
                switch (type) {
                    case SET_UP_MENU: {
                        helpRequired = resMsg.mResCode == ResultCode.HELP_INFO_REQUIRED;
                        this.sendMenuSelection(resMsg.mUsersMenuSelection, helpRequired);
                        return;
                    }
                    case SELECT_ITEM: {
                        resp = new SelectItemResponseData(resMsg.mUsersMenuSelection);
                        break;
                    }
                    case GET_INPUT: 
                    case GET_INKEY: {
                        Input input = this.mCurrntCmd.geInput();
                        if (!input.yesNo) {
                            if (helpRequired) break;
                            resp = new GetInkeyInputResponseData(resMsg.mUsersInput, input.ucs2, input.packed);
                            break;
                        }
                        resp = new GetInkeyInputResponseData(resMsg.mUsersYesNoSelection);
                        break;
                    }
                    case DISPLAY_TEXT: {
                        if (resMsg.mResCode == ResultCode.TERMINAL_CRNTLY_UNABLE_TO_PROCESS) {
                            resMsg.setAdditionalInfo(1);
                            break;
                        }
                        resMsg.mIncludeAdditionalInfo = false;
                        resMsg.mAdditionalInfo = 0;
                        break;
                    }
                    case LAUNCH_BROWSER: {
                        break;
                    }
                    case SET_UP_CALL: 
                    case OPEN_CHANNEL: {
                        this.mCmdIf.handleCallSetupRequestFromSim(resMsg.mUsersConfirm, null);
                        this.mCurrntCmd = null;
                        return;
                    }
                    case SET_UP_EVENT_LIST: {
                        if (5 == resMsg.mEventValue) {
                            this.eventDownload(resMsg.mEventValue, 2, 129, resMsg.mAddedInfo, false);
                        } else {
                            this.eventDownload(resMsg.mEventValue, 130, 129, resMsg.mAddedInfo, false);
                        }
                        return;
                    }
                }
                break;
            }
            case BACKWARD_MOVE_BY_USER: 
            case USER_NOT_ACCEPT: {
                if (type == AppInterface.CommandType.SET_UP_CALL || type == AppInterface.CommandType.OPEN_CHANNEL) {
                    this.mCmdIf.handleCallSetupRequestFromSim(false, null);
                    this.mCurrntCmd = null;
                    return;
                }
                resp = null;
                break;
            }
            case NO_RESPONSE_FROM_USER: 
            case UICC_SESSION_TERM_BY_USER: {
                resp = null;
                break;
            }
            default: {
                return;
            }
        }
        this.sendTerminalResponse(cmdDet, resMsg.mResCode, resMsg.mIncludeAdditionalInfo, resMsg.mAdditionalInfo, resp);
        this.mCurrntCmd = null;
    }

    private boolean isStkAppInstalled() {
        Intent intent = new Intent("com.android.internal.stk.command");
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> broadcastReceivers = pm.queryBroadcastReceivers(intent, 128);
        int numReceiver = broadcastReceivers == null ? 0 : broadcastReceivers.size();
        return numReceiver > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CommandsInterface ci, Context context, UiccCard ic) {
        UiccCardApplication ca = null;
        IccRecords ir = null;
        if (ic != null && (ca = ic.getApplicationIndex(0)) != null) {
            ir = ca.getIccRecords();
        }
        Object object = sInstanceLock;
        synchronized (object) {
            if (ir != null && mIccRecords != ir) {
                if (mIccRecords != null) {
                    mIccRecords.unregisterForRecordsLoaded(this);
                }
                CatLog.d(this, "Reinitialize the Service with SIMRecords and UiccCardApplication");
                mIccRecords = ir;
                mUiccApplication = ca;
                mIccRecords.registerForRecordsLoaded(this, 20, null);
                CatLog.d(this, "registerForRecordsLoaded slotid=" + this.mSlotId + " instance:" + this);
            }
        }
    }

    void updateIccAvailability() {
        if (null == this.mUiccController) {
            return;
        }
        IccCardStatus.CardState newState = IccCardStatus.CardState.CARDSTATE_ABSENT;
        UiccCard newCard = this.mUiccController.getUiccCard(this.mSlotId);
        if (newCard != null) {
            newState = newCard.getCardState();
        }
        IccCardStatus.CardState oldState = this.mCardState;
        this.mCardState = newState;
        CatLog.d(this, "New Card State = " + (Object)((Object)newState) + " " + "Old Card State = " + (Object)((Object)oldState));
        if (oldState == IccCardStatus.CardState.CARDSTATE_PRESENT && newState != IccCardStatus.CardState.CARDSTATE_PRESENT) {
            this.broadcastCardStateAndIccRefreshResp(newState, null);
        } else if (oldState != IccCardStatus.CardState.CARDSTATE_PRESENT && newState == IccCardStatus.CardState.CARDSTATE_PRESENT) {
            this.mCmdIf.reportStkServiceIsRunning(null);
        }
    }

    static {
        sInstanceLock = new Object();
        sInstance = null;
    }
}

