/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.util.Xml;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.cdma.EriInfo;
import com.android.internal.util.XmlUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class EriManager {
    private static final String LOG_TAG = "EriManager";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final int ERI_FROM_XML = 0;
    static final int ERI_FROM_FILE_SYSTEM = 1;
    static final int ERI_FROM_MODEM = 2;
    private Context mContext;
    private int mEriFileSource = 0;
    private boolean mIsEriFileLoaded;
    private EriFile mEriFile;
    private final Phone mPhone;

    public EriManager(Phone phone, Context context, int eriFileSource) {
        this.mPhone = phone;
        this.mContext = context;
        this.mEriFileSource = eriFileSource;
        this.mEriFile = new EriFile();
    }

    public void dispose() {
        this.mEriFile = new EriFile();
        this.mIsEriFileLoaded = false;
    }

    public void loadEriFile() {
        switch (this.mEriFileSource) {
            case 2: {
                this.loadEriFileFromModem();
                break;
            }
            case 1: {
                this.loadEriFileFromFileSystem();
                break;
            }
            default: {
                this.loadEriFileFromXml();
            }
        }
    }

    private void loadEriFileFromModem() {
    }

    private void loadEriFileFromFileSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEriFileFromXml() {
        XmlPullParser parser = null;
        FileInputStream stream = null;
        Resources r = this.mContext.getResources();
        try {
            Rlog.d(LOG_TAG, "loadEriFileFromXml: check for alternate file");
            stream = new FileInputStream(r.getString(17039461));
            parser = Xml.newPullParser();
            parser.setInput(stream, null);
            Rlog.d(LOG_TAG, "loadEriFileFromXml: opened alternate file");
        }
        catch (FileNotFoundException e) {
            Rlog.d(LOG_TAG, "loadEriFileFromXml: no alternate file");
            parser = null;
        }
        catch (XmlPullParserException e) {
            Rlog.d(LOG_TAG, "loadEriFileFromXml: no parser for alternate file");
            parser = null;
        }
        if (parser == null) {
            PersistableBundle b;
            String eriFile = null;
            CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
            if (configManager != null && (b = configManager.getConfigForSubId(this.mPhone.getSubId())) != null) {
                eriFile = b.getString("carrier_eri_file_name_string");
            }
            Rlog.d(LOG_TAG, "eriFile = " + eriFile);
            if (eriFile == null) {
                Rlog.e(LOG_TAG, "loadEriFileFromXml: Can't find ERI file to load");
                return;
            }
            try {
                parser = Xml.newPullParser();
                parser.setInput(this.mContext.getAssets().open(eriFile), null);
            }
            catch (IOException | XmlPullParserException e) {
                Rlog.e(LOG_TAG, "loadEriFileFromXml: no parser for " + eriFile + ". Exception = " + e.toString());
            }
        }
        try {
            XmlUtils.beginDocument(parser, "EriFile");
            this.mEriFile.mVersionNumber = Integer.parseInt(parser.getAttributeValue(null, "VersionNumber"));
            this.mEriFile.mNumberOfEriEntries = Integer.parseInt(parser.getAttributeValue(null, "NumberOfEriEntries"));
            this.mEriFile.mEriFileType = Integer.parseInt(parser.getAttributeValue(null, "EriFileType"));
            int parsedEriEntries = 0;
            while (true) {
                XmlUtils.nextElement(parser);
                String name = parser.getName();
                if (name == null) {
                    if (parsedEriEntries == this.mEriFile.mNumberOfEriEntries) break;
                    Rlog.e(LOG_TAG, "Error Parsing ERI file: " + this.mEriFile.mNumberOfEriEntries + " defined, " + parsedEriEntries + " parsed!");
                    break;
                }
                if (name.equals("CallPromptId")) {
                    int id2 = Integer.parseInt(parser.getAttributeValue(null, "Id"));
                    String text = parser.getAttributeValue(null, "CallPromptText");
                    if (id2 >= 0 && id2 <= 2) {
                        this.mEriFile.mCallPromptId[id2] = text;
                        continue;
                    }
                    Rlog.e(LOG_TAG, "Error Parsing ERI file: found" + id2 + " CallPromptId");
                    continue;
                }
                if (!name.equals("EriInfo")) continue;
                int roamingIndicator = Integer.parseInt(parser.getAttributeValue(null, "RoamingIndicator"));
                int iconIndex = Integer.parseInt(parser.getAttributeValue(null, "IconIndex"));
                int iconMode = Integer.parseInt(parser.getAttributeValue(null, "IconMode"));
                String eriText = parser.getAttributeValue(null, "EriText");
                int callPromptId = Integer.parseInt(parser.getAttributeValue(null, "CallPromptId"));
                int alertId = Integer.parseInt(parser.getAttributeValue(null, "AlertId"));
                ++parsedEriEntries;
                this.mEriFile.mRoamIndTable.put(roamingIndicator, new EriInfo(roamingIndicator, iconIndex, iconMode, eriText, callPromptId, alertId));
            }
            Rlog.d(LOG_TAG, "loadEriFileFromXml: eri parsing successful, file loaded. ver = " + this.mEriFile.mVersionNumber + ", # of entries = " + this.mEriFile.mNumberOfEriEntries);
            this.mIsEriFileLoaded = true;
        }
        catch (Exception e) {
            Rlog.e(LOG_TAG, "Got exception while loading ERI file.", e);
        }
        finally {
            if (parser instanceof XmlResourceParser) {
                ((XmlResourceParser)parser).close();
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public int getEriFileVersion() {
        return this.mEriFile.mVersionNumber;
    }

    public int getEriNumberOfEntries() {
        return this.mEriFile.mNumberOfEriEntries;
    }

    public int getEriFileType() {
        return this.mEriFile.mEriFileType;
    }

    public boolean isEriFileLoaded() {
        return this.mIsEriFileLoaded;
    }

    private EriInfo getEriInfo(int roamingIndicator) {
        if (this.mEriFile.mRoamIndTable.containsKey(roamingIndicator)) {
            return this.mEriFile.mRoamIndTable.get(roamingIndicator);
        }
        return null;
    }

    private EriDisplayInformation getEriDisplayInformation(int roamInd, int defRoamInd) {
        EriDisplayInformation ret;
        EriInfo eriInfo;
        if (this.mIsEriFileLoaded && (eriInfo = this.getEriInfo(roamInd)) != null) {
            EriDisplayInformation ret2 = new EriDisplayInformation(eriInfo.iconIndex, eriInfo.iconMode, eriInfo.eriText);
            return ret2;
        }
        block0 : switch (roamInd) {
            case 0: {
                ret = new EriDisplayInformation(0, 0, this.mContext.getText(17040709).toString());
                break;
            }
            case 1: {
                ret = new EriDisplayInformation(1, 0, this.mContext.getText(17040710).toString());
                break;
            }
            case 2: {
                ret = new EriDisplayInformation(2, 1, this.mContext.getText(17040714).toString());
                break;
            }
            case 3: {
                ret = new EriDisplayInformation(roamInd, 0, this.mContext.getText(17040715).toString());
                break;
            }
            case 4: {
                ret = new EriDisplayInformation(roamInd, 0, this.mContext.getText(17040716).toString());
                break;
            }
            case 5: {
                ret = new EriDisplayInformation(roamInd, 0, this.mContext.getText(17040717).toString());
                break;
            }
            case 6: {
                ret = new EriDisplayInformation(roamInd, 0, this.mContext.getText(17040718).toString());
                break;
            }
            case 7: {
                ret = new EriDisplayInformation(roamInd, 0, this.mContext.getText(17040719).toString());
                break;
            }
            case 8: {
                ret = new EriDisplayInformation(roamInd, 0, this.mContext.getText(17040720).toString());
                break;
            }
            case 9: {
                ret = new EriDisplayInformation(roamInd, 0, this.mContext.getText(17040721).toString());
                break;
            }
            case 10: {
                ret = new EriDisplayInformation(roamInd, 0, this.mContext.getText(17040711).toString());
                break;
            }
            case 11: {
                ret = new EriDisplayInformation(roamInd, 0, this.mContext.getText(17040712).toString());
                break;
            }
            case 12: {
                ret = new EriDisplayInformation(roamInd, 0, this.mContext.getText(17040713).toString());
                break;
            }
            default: {
                if (!this.mIsEriFileLoaded) {
                    Rlog.d(LOG_TAG, "ERI File not loaded");
                    if (defRoamInd > 2) {
                        ret = new EriDisplayInformation(2, 1, this.mContext.getText(17040714).toString());
                        break;
                    }
                    switch (defRoamInd) {
                        case 0: {
                            ret = new EriDisplayInformation(0, 0, this.mContext.getText(17040709).toString());
                            break block0;
                        }
                        case 1: {
                            ret = new EriDisplayInformation(1, 0, this.mContext.getText(17040710).toString());
                            break block0;
                        }
                        case 2: {
                            ret = new EriDisplayInformation(2, 1, this.mContext.getText(17040714).toString());
                            break block0;
                        }
                    }
                    ret = new EriDisplayInformation(-1, -1, "ERI text");
                    break;
                }
                eriInfo = this.getEriInfo(roamInd);
                EriInfo defEriInfo = this.getEriInfo(defRoamInd);
                if (eriInfo == null) {
                    if (defEriInfo == null) {
                        Rlog.e(LOG_TAG, "ERI defRoamInd " + defRoamInd + " not found in ERI file ...on");
                        ret = new EriDisplayInformation(0, 0, this.mContext.getText(17040709).toString());
                        break;
                    }
                    ret = new EriDisplayInformation(defEriInfo.iconIndex, defEriInfo.iconMode, defEriInfo.eriText);
                    break;
                }
                ret = new EriDisplayInformation(eriInfo.iconIndex, eriInfo.iconMode, eriInfo.eriText);
            }
        }
        return ret;
    }

    public int getCdmaEriIconIndex(int roamInd, int defRoamInd) {
        return this.getEriDisplayInformation((int)roamInd, (int)defRoamInd).mEriIconIndex;
    }

    public int getCdmaEriIconMode(int roamInd, int defRoamInd) {
        return this.getEriDisplayInformation((int)roamInd, (int)defRoamInd).mEriIconMode;
    }

    public String getCdmaEriText(int roamInd, int defRoamInd) {
        return this.getEriDisplayInformation((int)roamInd, (int)defRoamInd).mEriIconText;
    }

    class EriDisplayInformation {
        int mEriIconIndex;
        int mEriIconMode;
        String mEriIconText;

        EriDisplayInformation(int eriIconIndex, int eriIconMode, String eriIconText) {
            this.mEriIconIndex = eriIconIndex;
            this.mEriIconMode = eriIconMode;
            this.mEriIconText = eriIconText;
        }

        public String toString() {
            return "EriDisplayInformation: { IconIndex: " + this.mEriIconIndex + " EriIconMode: " + this.mEriIconMode + " EriIconText: " + this.mEriIconText + " }";
        }
    }

    class EriFile {
        int mVersionNumber = -1;
        int mNumberOfEriEntries = 0;
        int mEriFileType = -1;
        String[] mCallPromptId = new String[]{"", "", ""};
        HashMap<Integer, EriInfo> mRoamIndTable = new HashMap();

        EriFile() {
        }
    }
}

