/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.os.Handler;
import android.os.RegistrantList;
import android.util.Pair;

public class DataEnabledSettings {
    public static final int REASON_REGISTERED = 0;
    public static final int REASON_INTERNAL_DATA_ENABLED = 1;
    public static final int REASON_USER_DATA_ENABLED = 2;
    public static final int REASON_POLICY_DATA_ENABLED = 3;
    public static final int REASON_DATA_ENABLED_BY_CARRIER = 4;
    private boolean mInternalDataEnabled = true;
    private boolean mUserDataEnabled = true;
    private boolean mPolicyDataEnabled = true;
    private boolean mCarrierDataEnabled = true;
    private final RegistrantList mDataEnabledChangedRegistrants = new RegistrantList();

    public synchronized void setInternalDataEnabled(boolean enabled) {
        boolean prevDataEnabled = this.isDataEnabled();
        this.mInternalDataEnabled = enabled;
        if (prevDataEnabled != this.isDataEnabled()) {
            this.notifyDataEnabledChanged(!prevDataEnabled, 1);
        }
    }

    public synchronized boolean isInternalDataEnabled() {
        return this.mInternalDataEnabled;
    }

    public synchronized void setUserDataEnabled(boolean enabled) {
        boolean prevDataEnabled = this.isDataEnabled();
        this.mUserDataEnabled = enabled;
        if (prevDataEnabled != this.isDataEnabled()) {
            this.notifyDataEnabledChanged(!prevDataEnabled, 2);
        }
    }

    public synchronized boolean isUserDataEnabled() {
        return this.mUserDataEnabled;
    }

    public synchronized void setPolicyDataEnabled(boolean enabled) {
        boolean prevDataEnabled = this.isDataEnabled();
        this.mPolicyDataEnabled = enabled;
        if (prevDataEnabled != this.isDataEnabled()) {
            this.notifyDataEnabledChanged(!prevDataEnabled, 3);
        }
    }

    public synchronized boolean isPolicyDataEnabled() {
        return this.mPolicyDataEnabled;
    }

    public synchronized void setCarrierDataEnabled(boolean enabled) {
        boolean prevDataEnabled = this.isDataEnabled();
        this.mCarrierDataEnabled = enabled;
        if (prevDataEnabled != this.isDataEnabled()) {
            this.notifyDataEnabledChanged(!prevDataEnabled, 4);
        }
    }

    public synchronized boolean isCarrierDataEnabled() {
        return this.mCarrierDataEnabled;
    }

    public synchronized boolean isDataEnabled() {
        return this.mInternalDataEnabled && this.mUserDataEnabled && this.mPolicyDataEnabled && this.mCarrierDataEnabled;
    }

    private void notifyDataEnabledChanged(boolean enabled, int reason) {
        this.mDataEnabledChangedRegistrants.notifyResult(new Pair<Boolean, Integer>(enabled, reason));
    }

    public void registerForDataEnabledChanged(Handler h, int what, Object obj) {
        this.mDataEnabledChangedRegistrants.addUnique(h, what, obj);
        this.notifyDataEnabledChanged(this.isDataEnabled(), 0);
    }

    public void unregisterForDataEnabledChanged(Handler h) {
        this.mDataEnabledChangedRegistrants.remove(h);
    }
}

