/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.telephony.ServiceState;
import android.text.TextUtils;
import com.android.internal.telephony.dataconnection.ApnSetting;

public class DataProfile {
    static final int TYPE_COMMON = 0;
    static final int TYPE_3GPP = 1;
    static final int TYPE_3GPP2 = 2;
    public final int profileId;
    public final String apn;
    public final String protocol;
    public final int authType;
    public final String user;
    public final String password;
    public final int type;
    public final int maxConnsTime;
    public final int maxConns;
    public final int waitTime;
    public final boolean enabled;
    public final int supportedApnTypesBitmap;
    public final String roamingProtocol;
    public final int bearerBitmap;
    public final int mtu;
    public final String mvnoType;
    public final String mvnoMatchData;
    public final boolean modemCognitive;

    DataProfile(int profileId, String apn, String protocol, int authType, String user, String password, int type, int maxConnsTime, int maxConns, int waitTime, boolean enabled, int supportedApnTypesBitmap, String roamingProtocol, int bearerBitmap, int mtu, String mvnoType, String mvnoMatchData, boolean modemCognitive) {
        this.profileId = profileId;
        this.apn = apn;
        this.protocol = protocol;
        if (authType == -1) {
            authType = TextUtils.isEmpty(user) ? 0 : 3;
        }
        this.authType = authType;
        this.user = user;
        this.password = password;
        this.type = type;
        this.maxConnsTime = maxConnsTime;
        this.maxConns = maxConns;
        this.waitTime = waitTime;
        this.enabled = enabled;
        this.supportedApnTypesBitmap = supportedApnTypesBitmap;
        this.roamingProtocol = roamingProtocol;
        this.bearerBitmap = bearerBitmap;
        this.mtu = mtu;
        this.mvnoType = mvnoType;
        this.mvnoMatchData = mvnoMatchData;
        this.modemCognitive = modemCognitive;
    }

    public DataProfile(ApnSetting apn) {
        this(apn, apn.profileId);
    }

    public DataProfile(ApnSetting apn, int profileId) {
        this(profileId, apn.apn, apn.protocol, apn.authType, apn.user, apn.password, apn.bearerBitmask == 0 ? 0 : (ServiceState.bearerBitmapHasCdma(apn.bearerBitmask) ? 2 : 1), apn.maxConnsTime, apn.maxConns, apn.waitTime, apn.carrierEnabled, apn.typesBitmap, apn.roamingProtocol, apn.bearerBitmask, apn.mtu, apn.mvnoType, apn.mvnoMatchData, apn.modemCognitive);
    }

    public String toString() {
        return "DataProfile=" + this.profileId + "/" + this.apn + "/" + this.protocol + "/" + this.authType + "/" + this.user + "/" + this.password + "/" + this.type + "/" + this.maxConnsTime + "/" + this.maxConns + "/" + this.waitTime + "/" + this.enabled + "/" + this.supportedApnTypesBitmap + "/" + this.roamingProtocol + "/" + this.bearerBitmap + "/" + this.mtu + "/" + this.mvnoType + "/" + this.mvnoMatchData + "/" + this.modemCognitive;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataProfile)) {
            return false;
        }
        return o == this || this.toString().equals(o.toString());
    }
}

