/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.telephony.PhoneStateListener;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.dataconnection.ApnContext;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import com.android.internal.telephony.dataconnection.DataConnection;
import com.android.internal.telephony.dataconnection.DcAsyncChannel;
import com.android.internal.telephony.dataconnection.DcFailCause;
import com.android.internal.telephony.dataconnection.DcTesterDeactivateAll;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class DcController
extends StateMachine {
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private Phone mPhone;
    private DcTracker mDct;
    private DcTesterDeactivateAll mDcTesterDeactivateAll;
    ArrayList<DataConnection> mDcListAll = new ArrayList();
    private HashMap<Integer, DataConnection> mDcListActiveByCid = new HashMap();
    static final int DATA_CONNECTION_ACTIVE_PH_LINK_INACTIVE = 0;
    static final int DATA_CONNECTION_ACTIVE_PH_LINK_DORMANT = 1;
    static final int DATA_CONNECTION_ACTIVE_PH_LINK_UP = 2;
    static final int DATA_CONNECTION_ACTIVE_UNKNOWN = Integer.MAX_VALUE;
    private DccDefaultState mDccDefaultState = new DccDefaultState();
    TelephonyManager mTelephonyManager;
    private PhoneStateListener mPhoneStateListener;
    private volatile boolean mExecutingCarrierChange;

    private DcController(String name, Phone phone, DcTracker dct, Handler handler) {
        super(name, handler);
        this.setLogRecSize(300);
        this.log("E ctor");
        this.mPhone = phone;
        this.mDct = dct;
        this.addState(this.mDccDefaultState);
        this.setInitialState(this.mDccDefaultState);
        this.log("X ctor");
        this.mPhoneStateListener = new PhoneStateListener(handler.getLooper()){

            @Override
            public void onCarrierNetworkChange(boolean active) {
                DcController.this.mExecutingCarrierChange = active;
            }
        };
        this.mTelephonyManager = (TelephonyManager)phone.getContext().getSystemService("phone");
        if (this.mTelephonyManager != null) {
            this.mTelephonyManager.listen(this.mPhoneStateListener, 65536);
        }
    }

    public static DcController makeDcc(Phone phone, DcTracker dct, Handler handler) {
        DcController dcc = new DcController("Dcc", phone, dct, handler);
        dcc.start();
        return dcc;
    }

    void dispose() {
        this.log("dispose: call quiteNow()");
        if (this.mTelephonyManager != null) {
            this.mTelephonyManager.listen(this.mPhoneStateListener, 0);
        }
        this.quitNow();
    }

    void addDc(DataConnection dc) {
        this.mDcListAll.add(dc);
    }

    void removeDc(DataConnection dc) {
        this.mDcListActiveByCid.remove(dc.mCid);
        this.mDcListAll.remove(dc);
    }

    public void addActiveDcByCid(DataConnection dc) {
        if (dc.mCid < 0) {
            this.log("addActiveDcByCid dc.mCid < 0 dc=" + dc);
        }
        this.mDcListActiveByCid.put(dc.mCid, dc);
    }

    public DataConnection getActiveDcByCid(int cid) {
        return this.mDcListActiveByCid.get(cid);
    }

    void removeActiveDcByCid(DataConnection dc) {
        DataConnection removedDc = this.mDcListActiveByCid.remove(dc.mCid);
        if (removedDc == null) {
            this.log("removeActiveDcByCid removedDc=null dc=" + dc);
        }
    }

    boolean isExecutingCarrierChange() {
        return this.mExecutingCarrierChange;
    }

    private void lr(String s) {
        this.logAndAddLogRec(s);
    }

    @Override
    protected void log(String s) {
        Rlog.d(this.getName(), s);
    }

    @Override
    protected void loge(String s) {
        Rlog.e(this.getName(), s);
    }

    @Override
    protected String getWhatToString(int what) {
        String info = null;
        info = DataConnection.cmdToString(what);
        if (info == null) {
            info = DcAsyncChannel.cmdToString(what);
        }
        return info;
    }

    @Override
    public String toString() {
        return "mDcListAll=" + this.mDcListAll + " mDcListActiveByCid=" + this.mDcListActiveByCid;
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        super.dump(fd, pw, args);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mDcListAll=" + this.mDcListAll);
        pw.println(" mDcListActiveByCid=" + this.mDcListActiveByCid);
    }

    private class DccDefaultState
    extends State {
        private DccDefaultState() {
        }

        @Override
        public void enter() {
            ((DcController)DcController.this).mPhone.mCi.registerForRilConnected(DcController.this.getHandler(), 262149, null);
            ((DcController)DcController.this).mPhone.mCi.registerForDataCallListChanged(DcController.this.getHandler(), 262151, null);
            if (Build.IS_DEBUGGABLE) {
                DcController.this.mDcTesterDeactivateAll = new DcTesterDeactivateAll(DcController.this.mPhone, DcController.this, DcController.this.getHandler());
            }
        }

        @Override
        public void exit() {
            if (DcController.this.mPhone != null) {
                ((DcController)DcController.this).mPhone.mCi.unregisterForRilConnected(DcController.this.getHandler());
                ((DcController)DcController.this).mPhone.mCi.unregisterForDataCallListChanged(DcController.this.getHandler());
            }
            if (DcController.this.mDcTesterDeactivateAll != null) {
                DcController.this.mDcTesterDeactivateAll.dispose();
            }
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 262149: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        DcController.this.log("DccDefaultState: msg.what=EVENT_RIL_CONNECTED mRilVersion=" + ar.result);
                        break;
                    }
                    DcController.this.log("DccDefaultState: Unexpected exception on EVENT_RIL_CONNECTED");
                    break;
                }
                case 262151: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        this.onDataStateChanged((ArrayList)ar.result);
                        break;
                    }
                    DcController.this.log("DccDefaultState: EVENT_DATA_STATE_CHANGED: exception; likely radio not available, ignore");
                }
            }
            return true;
        }

        private void onDataStateChanged(ArrayList<DataCallResponse> dcsList) {
            DcController.this.lr("onDataStateChanged: dcsList=" + dcsList + " mDcListActiveByCid=" + DcController.this.mDcListActiveByCid);
            HashMap<Integer, DataCallResponse> dataCallResponseListByCid = new HashMap<Integer, DataCallResponse>();
            for (DataCallResponse dataCallResponse : dcsList) {
                dataCallResponseListByCid.put(dataCallResponse.cid, dataCallResponse);
            }
            ArrayList<DataConnection> dcsToRetry = new ArrayList<DataConnection>();
            for (DataConnection dc : DcController.this.mDcListActiveByCid.values()) {
                if (dataCallResponseListByCid.get(dc.mCid) != null) continue;
                DcController.this.log("onDataStateChanged: add to retry dc=" + dc);
                dcsToRetry.add(dc);
            }
            DcController.this.log("onDataStateChanged: dcsToRetry=" + dcsToRetry);
            ArrayList<ApnContext> arrayList = new ArrayList<ApnContext>();
            boolean isAnyDataCallDormant = false;
            boolean isAnyDataCallActive = false;
            for (DataCallResponse newState : dcsList) {
                DataConnection dc = (DataConnection)DcController.this.mDcListActiveByCid.get(newState.cid);
                if (dc == null) {
                    DcController.this.loge("onDataStateChanged: no associated DC yet, ignore");
                    continue;
                }
                if (dc.mApnContexts.size() == 0) {
                    DcController.this.loge("onDataStateChanged: no connected apns, ignore");
                } else {
                    DcController.this.log("onDataStateChanged: Found ConnId=" + newState.cid + " newState=" + newState.toString());
                    if (newState.active == 0) {
                        if (((DcController)DcController.this).mDct.isCleanupRequired.get()) {
                            arrayList.addAll(dc.mApnContexts.keySet());
                            ((DcController)DcController.this).mDct.isCleanupRequired.set(false);
                        } else {
                            DcFailCause failCause = DcFailCause.fromInt(newState.status);
                            if (failCause.isRestartRadioFail(DcController.this.mPhone.getContext(), DcController.this.mPhone.getSubId())) {
                                DcController.this.log("onDataStateChanged: X restart radio, failCause=" + (Object)((Object)failCause));
                                DcController.this.mDct.sendRestartRadio();
                            } else if (DcController.this.mDct.isPermanentFailure(failCause)) {
                                DcController.this.log("onDataStateChanged: inactive, add to cleanup list. failCause=" + (Object)((Object)failCause));
                                arrayList.addAll(dc.mApnContexts.keySet());
                            } else {
                                DcController.this.log("onDataStateChanged: inactive, add to retry list. failCause=" + (Object)((Object)failCause));
                                dcsToRetry.add(dc);
                            }
                        }
                    } else {
                        DataConnection.UpdateLinkPropertyResult result = dc.updateLinkProperty(newState);
                        if (result.oldLp.equals(result.newLp)) {
                            DcController.this.log("onDataStateChanged: no change");
                        } else if (result.oldLp.isIdenticalInterfaceName(result.newLp)) {
                            if (!(result.oldLp.isIdenticalDnses(result.newLp) && result.oldLp.isIdenticalRoutes(result.newLp) && result.oldLp.isIdenticalHttpProxy(result.newLp) && result.oldLp.isIdenticalAddresses(result.newLp))) {
                                LinkProperties.CompareResult<LinkAddress> car = result.oldLp.compareAddresses(result.newLp);
                                DcController.this.log("onDataStateChanged: oldLp=" + result.oldLp + " newLp=" + result.newLp + " car=" + car);
                                boolean needToClean = false;
                                block3: for (LinkAddress added : car.added) {
                                    for (LinkAddress removed : car.removed) {
                                        if (!NetworkUtils.addressTypeMatches(removed.getAddress(), added.getAddress())) continue;
                                        needToClean = true;
                                        continue block3;
                                    }
                                }
                                if (needToClean) {
                                    DcController.this.log("onDataStateChanged: addr change, cleanup apns=" + dc.mApnContexts + " oldLp=" + result.oldLp + " newLp=" + result.newLp);
                                    arrayList.addAll(dc.mApnContexts.keySet());
                                } else {
                                    DcController.this.log("onDataStateChanged: simple change");
                                    for (ApnContext apnContext : dc.mApnContexts.keySet()) {
                                        DcController.this.mPhone.notifyDataConnection("linkPropertiesChanged", apnContext.getApnType());
                                    }
                                }
                            } else {
                                DcController.this.log("onDataStateChanged: no changes");
                            }
                        } else {
                            arrayList.addAll(dc.mApnContexts.keySet());
                            DcController.this.log("onDataStateChanged: interface change, cleanup apns=" + dc.mApnContexts);
                        }
                    }
                }
                if (newState.active == 2) {
                    isAnyDataCallActive = true;
                }
                if (newState.active != 1) continue;
                isAnyDataCallDormant = true;
            }
            if (isAnyDataCallDormant && !isAnyDataCallActive) {
                DcController.this.log("onDataStateChanged: Data Activity updated to DORMANT. stopNetStatePoll");
                DcController.this.mDct.sendStopNetStatPoll(DctConstants.Activity.DORMANT);
            } else {
                DcController.this.log("onDataStateChanged: Data Activity updated to NONE. isAnyDataCallActive = " + isAnyDataCallActive + " isAnyDataCallDormant = " + isAnyDataCallDormant);
                if (isAnyDataCallActive) {
                    DcController.this.mDct.sendStartNetStatPoll(DctConstants.Activity.NONE);
                }
            }
            DcController.this.lr("onDataStateChanged: dcsToRetry=" + dcsToRetry + " apnsToCleanup=" + arrayList);
            for (ApnContext apnContext : arrayList) {
                DcController.this.mDct.sendCleanUpConnection(true, apnContext);
            }
            for (DataConnection dc : dcsToRetry) {
                DcController.this.log("onDataStateChanged: send EVENT_LOST_CONNECTION dc.mTag=" + dc.mTag);
                dc.sendMessage(262153, dc.mTag);
            }
        }
    }
}

