/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.ResultReceiver;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.text.BidiFormatter;
import android.text.SpannableStringBuilder;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.gsm.SsData;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GsmMmiCode
extends Handler
implements MmiCode {
    static final String LOG_TAG = "GsmMmiCode";
    static final int MAX_LENGTH_SHORT_CODE = 2;
    static final char END_OF_USSD_COMMAND = '#';
    static final String ACTION_ACTIVATE = "*";
    static final String ACTION_DEACTIVATE = "#";
    static final String ACTION_INTERROGATE = "*#";
    static final String ACTION_REGISTER = "**";
    static final String ACTION_ERASURE = "##";
    static final String SC_CLIP = "30";
    static final String SC_CLIR = "31";
    static final String SC_CFU = "21";
    static final String SC_CFB = "67";
    static final String SC_CFNRy = "61";
    static final String SC_CFNR = "62";
    static final String SC_CF_All = "002";
    static final String SC_CF_All_Conditional = "004";
    static final String SC_WAIT = "43";
    static final String SC_BAOC = "33";
    static final String SC_BAOIC = "331";
    static final String SC_BAOICxH = "332";
    static final String SC_BAIC = "35";
    static final String SC_BAICr = "351";
    static final String SC_BA_ALL = "330";
    static final String SC_BA_MO = "333";
    static final String SC_BA_MT = "353";
    static final String SC_PWD = "03";
    static final String SC_PIN = "04";
    static final String SC_PIN2 = "042";
    static final String SC_PUK = "05";
    static final String SC_PUK2 = "052";
    static final int EVENT_SET_COMPLETE = 1;
    static final int EVENT_GET_CLIR_COMPLETE = 2;
    static final int EVENT_QUERY_CF_COMPLETE = 3;
    static final int EVENT_USSD_COMPLETE = 4;
    static final int EVENT_QUERY_COMPLETE = 5;
    static final int EVENT_SET_CFF_COMPLETE = 6;
    static final int EVENT_USSD_CANCEL_COMPLETE = 7;
    GsmCdmaPhone mPhone;
    Context mContext;
    UiccCardApplication mUiccApplication;
    IccRecords mIccRecords;
    String mAction;
    String mSc;
    String mSia;
    String mSib;
    String mSic;
    String mPoundString;
    public String mDialingNumber;
    String mPwd;
    private boolean mIsPendingUSSD;
    private boolean mIsUssdRequest;
    private boolean mIsCallFwdReg;
    MmiCode.State mState = MmiCode.State.PENDING;
    CharSequence mMessage;
    private boolean mIsSsInfo = false;
    private ResultReceiver mCallbackReceiver;
    static Pattern sPatternSuppService = Pattern.compile("((\\*|#|\\*#|\\*\\*|##)(\\d{2,3})(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*)(\\*([^*#]*))?)?)?)?#)(.*)");
    static final int MATCH_GROUP_POUND_STRING = 1;
    static final int MATCH_GROUP_ACTION = 2;
    static final int MATCH_GROUP_SERVICE_CODE = 3;
    static final int MATCH_GROUP_SIA = 5;
    static final int MATCH_GROUP_SIB = 7;
    static final int MATCH_GROUP_SIC = 9;
    static final int MATCH_GROUP_PWD_CONFIRM = 11;
    static final int MATCH_GROUP_DIALING_NUMBER = 12;
    private static String[] sTwoDigitNumberPattern;

    public static GsmMmiCode newFromDialString(String dialString, GsmCdmaPhone phone, UiccCardApplication app) {
        return GsmMmiCode.newFromDialString(dialString, phone, app, null);
    }

    public static GsmMmiCode newFromDialString(String dialString, GsmCdmaPhone phone, UiccCardApplication app, ResultReceiver wrappedCallback) {
        GsmMmiCode ret = null;
        Matcher m = sPatternSuppService.matcher(dialString);
        if (m.matches()) {
            ret = new GsmMmiCode(phone, app);
            ret.mPoundString = GsmMmiCode.makeEmptyNull(m.group(1));
            ret.mAction = GsmMmiCode.makeEmptyNull(m.group(2));
            ret.mSc = GsmMmiCode.makeEmptyNull(m.group(3));
            ret.mSia = GsmMmiCode.makeEmptyNull(m.group(5));
            ret.mSib = GsmMmiCode.makeEmptyNull(m.group(7));
            ret.mSic = GsmMmiCode.makeEmptyNull(m.group(9));
            ret.mPwd = GsmMmiCode.makeEmptyNull(m.group(11));
            ret.mDialingNumber = GsmMmiCode.makeEmptyNull(m.group(12));
            ret.mCallbackReceiver = wrappedCallback;
            if (ret.mDialingNumber != null && ret.mDialingNumber.endsWith(ACTION_DEACTIVATE) && dialString.endsWith(ACTION_DEACTIVATE)) {
                ret = new GsmMmiCode(phone, app);
                ret.mPoundString = dialString;
            }
        } else if (dialString.endsWith(ACTION_DEACTIVATE)) {
            ret = new GsmMmiCode(phone, app);
            ret.mPoundString = dialString;
        } else if (GsmMmiCode.isTwoDigitShortCode(phone.getContext(), dialString)) {
            ret = null;
        } else if (GsmMmiCode.isShortCode(dialString, phone)) {
            ret = new GsmMmiCode(phone, app);
            ret.mDialingNumber = dialString;
        }
        return ret;
    }

    public static GsmMmiCode newNetworkInitiatedUssd(String ussdMessage, boolean isUssdRequest, GsmCdmaPhone phone, UiccCardApplication app) {
        GsmMmiCode ret = new GsmMmiCode(phone, app);
        ret.mMessage = ussdMessage;
        ret.mIsUssdRequest = isUssdRequest;
        if (isUssdRequest) {
            ret.mIsPendingUSSD = true;
            ret.mState = MmiCode.State.PENDING;
        } else {
            ret.mState = MmiCode.State.COMPLETE;
        }
        return ret;
    }

    public static GsmMmiCode newFromUssdUserInput(String ussdMessge, GsmCdmaPhone phone, UiccCardApplication app) {
        GsmMmiCode ret = new GsmMmiCode(phone, app);
        ret.mMessage = ussdMessge;
        ret.mState = MmiCode.State.PENDING;
        ret.mIsPendingUSSD = true;
        return ret;
    }

    public void processSsData(AsyncResult data) {
        Rlog.d(LOG_TAG, "In processSsData");
        this.mIsSsInfo = true;
        try {
            SsData ssData = (SsData)data.result;
            this.parseSsData(ssData);
        }
        catch (ClassCastException ex) {
            Rlog.e(LOG_TAG, "Class Cast Exception in parsing SS Data : " + ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(LOG_TAG, "Null Pointer Exception in parsing SS Data : " + ex);
        }
    }

    void parseSsData(SsData ssData) {
        CommandException ex = CommandException.fromRilErrno(ssData.result);
        this.mSc = this.getScStringFromScType(ssData.serviceType);
        this.mAction = this.getActionStringFromReqType(ssData.requestType);
        Rlog.d(LOG_TAG, "parseSsData msc = " + this.mSc + ", action = " + this.mAction + ", ex = " + ex);
        switch (ssData.requestType) {
            case SS_ACTIVATION: 
            case SS_DEACTIVATION: 
            case SS_REGISTRATION: 
            case SS_ERASURE: {
                if (ssData.result == 0 && ssData.serviceType.isTypeUnConditional()) {
                    boolean cffEnabled = (ssData.requestType == SsData.RequestType.SS_ACTIVATION || ssData.requestType == SsData.RequestType.SS_REGISTRATION) && this.isServiceClassVoiceorNone(ssData.serviceClass);
                    Rlog.d(LOG_TAG, "setVoiceCallForwardingFlag cffEnabled: " + cffEnabled);
                    if (this.mIccRecords != null) {
                        this.mPhone.setVoiceCallForwardingFlag(1, cffEnabled, null);
                        Rlog.d(LOG_TAG, "setVoiceCallForwardingFlag done from SS Info.");
                    } else {
                        Rlog.e(LOG_TAG, "setVoiceCallForwardingFlag aborted. sim records is null.");
                    }
                }
                this.onSetComplete(null, new AsyncResult(null, ssData.cfInfo, ex));
                break;
            }
            case SS_INTERROGATION: {
                if (ssData.serviceType.isTypeClir()) {
                    Rlog.d(LOG_TAG, "CLIR INTERROGATION");
                    this.onGetClirComplete(new AsyncResult(null, ssData.ssInfo, ex));
                    break;
                }
                if (ssData.serviceType.isTypeCF()) {
                    Rlog.d(LOG_TAG, "CALL FORWARD INTERROGATION");
                    this.onQueryCfComplete(new AsyncResult(null, ssData.cfInfo, ex));
                    break;
                }
                this.onQueryComplete(new AsyncResult(null, ssData.ssInfo, ex));
                break;
            }
            default: {
                Rlog.e(LOG_TAG, "Invaid requestType in SSData : " + (Object)((Object)ssData.requestType));
            }
        }
    }

    private String getScStringFromScType(SsData.ServiceType sType) {
        switch (sType) {
            case SS_CFU: {
                return SC_CFU;
            }
            case SS_CF_BUSY: {
                return SC_CFB;
            }
            case SS_CF_NO_REPLY: {
                return SC_CFNRy;
            }
            case SS_CF_NOT_REACHABLE: {
                return SC_CFNR;
            }
            case SS_CF_ALL: {
                return SC_CF_All;
            }
            case SS_CF_ALL_CONDITIONAL: {
                return SC_CF_All_Conditional;
            }
            case SS_CLIP: {
                return SC_CLIP;
            }
            case SS_CLIR: {
                return SC_CLIR;
            }
            case SS_WAIT: {
                return SC_WAIT;
            }
            case SS_BAOC: {
                return SC_BAOC;
            }
            case SS_BAOIC: {
                return SC_BAOIC;
            }
            case SS_BAOIC_EXC_HOME: {
                return SC_BAOICxH;
            }
            case SS_BAIC: {
                return SC_BAIC;
            }
            case SS_BAIC_ROAMING: {
                return SC_BAICr;
            }
            case SS_ALL_BARRING: {
                return SC_BA_ALL;
            }
            case SS_OUTGOING_BARRING: {
                return SC_BA_MO;
            }
            case SS_INCOMING_BARRING: {
                return SC_BA_MT;
            }
        }
        return "";
    }

    private String getActionStringFromReqType(SsData.RequestType rType) {
        switch (rType) {
            case SS_ACTIVATION: {
                return ACTION_ACTIVATE;
            }
            case SS_DEACTIVATION: {
                return ACTION_DEACTIVATE;
            }
            case SS_INTERROGATION: {
                return ACTION_INTERROGATE;
            }
            case SS_REGISTRATION: {
                return ACTION_REGISTER;
            }
            case SS_ERASURE: {
                return ACTION_ERASURE;
            }
        }
        return "";
    }

    private boolean isServiceClassVoiceorNone(int serviceClass) {
        return (serviceClass & 1) != 0 || serviceClass == 0;
    }

    private static String makeEmptyNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    private static boolean isEmptyOrNull(CharSequence s) {
        return s == null || s.length() == 0;
    }

    private static int scToCallForwardReason(String sc) {
        if (sc == null) {
            throw new RuntimeException("invalid call forward sc");
        }
        if (sc.equals(SC_CF_All)) {
            return 4;
        }
        if (sc.equals(SC_CFU)) {
            return 0;
        }
        if (sc.equals(SC_CFB)) {
            return 1;
        }
        if (sc.equals(SC_CFNR)) {
            return 3;
        }
        if (sc.equals(SC_CFNRy)) {
            return 2;
        }
        if (sc.equals(SC_CF_All_Conditional)) {
            return 5;
        }
        throw new RuntimeException("invalid call forward sc");
    }

    private static int siToServiceClass(String si) {
        if (si == null || si.length() == 0) {
            return 0;
        }
        int serviceCode = Integer.parseInt(si, 10);
        switch (serviceCode) {
            case 10: {
                return 13;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 4;
            }
            case 16: {
                return 8;
            }
            case 19: {
                return 5;
            }
            case 20: {
                return 48;
            }
            case 21: {
                return 160;
            }
            case 22: {
                return 80;
            }
            case 24: {
                return 16;
            }
            case 25: {
                return 32;
            }
            case 26: {
                return 17;
            }
            case 99: {
                return 64;
            }
        }
        throw new RuntimeException("unsupported MMI service code " + si);
    }

    private static int siToTime(String si) {
        if (si == null || si.length() == 0) {
            return 0;
        }
        return Integer.parseInt(si, 10);
    }

    static boolean isServiceCodeCallForwarding(String sc) {
        return sc != null && (sc.equals(SC_CFU) || sc.equals(SC_CFB) || sc.equals(SC_CFNRy) || sc.equals(SC_CFNR) || sc.equals(SC_CF_All) || sc.equals(SC_CF_All_Conditional));
    }

    static boolean isServiceCodeCallBarring(String sc) {
        String[] barringMMI;
        Resources resource = Resources.getSystem();
        if (sc != null && (barringMMI = resource.getStringArray(17235987)) != null) {
            for (String match : barringMMI) {
                if (!sc.equals(match)) continue;
                return true;
            }
        }
        return false;
    }

    static String scToBarringFacility(String sc) {
        if (sc == null) {
            throw new RuntimeException("invalid call barring sc");
        }
        if (sc.equals(SC_BAOC)) {
            return "AO";
        }
        if (sc.equals(SC_BAOIC)) {
            return "OI";
        }
        if (sc.equals(SC_BAOICxH)) {
            return "OX";
        }
        if (sc.equals(SC_BAIC)) {
            return "AI";
        }
        if (sc.equals(SC_BAICr)) {
            return "IR";
        }
        if (sc.equals(SC_BA_ALL)) {
            return "AB";
        }
        if (sc.equals(SC_BA_MO)) {
            return "AG";
        }
        if (sc.equals(SC_BA_MT)) {
            return "AC";
        }
        throw new RuntimeException("invalid call barring sc");
    }

    public GsmMmiCode(GsmCdmaPhone phone, UiccCardApplication app) {
        super(phone.getHandler().getLooper());
        this.mPhone = phone;
        this.mContext = phone.getContext();
        this.mUiccApplication = app;
        if (app != null) {
            this.mIccRecords = app.getIccRecords();
        }
    }

    @Override
    public MmiCode.State getState() {
        return this.mState;
    }

    @Override
    public CharSequence getMessage() {
        return this.mMessage;
    }

    @Override
    public Phone getPhone() {
        return this.mPhone;
    }

    @Override
    public void cancel() {
        if (this.mState == MmiCode.State.COMPLETE || this.mState == MmiCode.State.FAILED) {
            return;
        }
        this.mState = MmiCode.State.CANCELLED;
        if (this.mIsPendingUSSD) {
            this.mPhone.mCi.cancelPendingUssd(this.obtainMessage(7, this));
        } else {
            this.mPhone.onMMIDone(this);
        }
    }

    @Override
    public boolean isCancelable() {
        return this.mIsPendingUSSD;
    }

    boolean isMMI() {
        return this.mPoundString != null;
    }

    boolean isShortCode() {
        return this.mPoundString == null && this.mDialingNumber != null && this.mDialingNumber.length() <= 2;
    }

    @Override
    public String getDialString() {
        return this.mPoundString;
    }

    private static boolean isTwoDigitShortCode(Context context, String dialString) {
        Rlog.d(LOG_TAG, "isTwoDigitShortCode");
        if (dialString == null || dialString.length() > 2) {
            return false;
        }
        if (sTwoDigitNumberPattern == null) {
            sTwoDigitNumberPattern = context.getResources().getStringArray(17236040);
        }
        for (String dialnumber : sTwoDigitNumberPattern) {
            Rlog.d(LOG_TAG, "Two Digit Number Pattern " + dialnumber);
            if (!dialString.equals(dialnumber)) continue;
            Rlog.d(LOG_TAG, "Two Digit Number Pattern -true");
            return true;
        }
        Rlog.d(LOG_TAG, "Two Digit Number Pattern -false");
        return false;
    }

    private static boolean isShortCode(String dialString, GsmCdmaPhone phone) {
        if (dialString == null) {
            return false;
        }
        if (dialString.length() == 0) {
            return false;
        }
        if (PhoneNumberUtils.isLocalEmergencyNumber(phone.getContext(), dialString)) {
            return false;
        }
        return GsmMmiCode.isShortCodeUSSD(dialString, phone);
    }

    private static boolean isShortCodeUSSD(String dialString, GsmCdmaPhone phone) {
        if (dialString != null && dialString.length() <= 2) {
            if (phone.isInCall()) {
                return true;
            }
            if (dialString.length() != 2 || dialString.charAt(0) != '1') {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPinPukCommand() {
        return this.mSc != null && (this.mSc.equals(SC_PIN) || this.mSc.equals(SC_PIN2) || this.mSc.equals(SC_PUK) || this.mSc.equals(SC_PUK2));
    }

    public boolean isTemporaryModeCLIR() {
        return this.mSc != null && this.mSc.equals(SC_CLIR) && this.mDialingNumber != null && (this.isActivate() || this.isDeactivate());
    }

    public int getCLIRMode() {
        if (this.mSc != null && this.mSc.equals(SC_CLIR)) {
            if (this.isActivate()) {
                return 2;
            }
            if (this.isDeactivate()) {
                return 1;
            }
        }
        return 0;
    }

    boolean isActivate() {
        return this.mAction != null && this.mAction.equals(ACTION_ACTIVATE);
    }

    boolean isDeactivate() {
        return this.mAction != null && this.mAction.equals(ACTION_DEACTIVATE);
    }

    boolean isInterrogate() {
        return this.mAction != null && this.mAction.equals(ACTION_INTERROGATE);
    }

    boolean isRegister() {
        return this.mAction != null && this.mAction.equals(ACTION_REGISTER);
    }

    boolean isErasure() {
        return this.mAction != null && this.mAction.equals(ACTION_ERASURE);
    }

    public boolean isPendingUSSD() {
        return this.mIsPendingUSSD;
    }

    @Override
    public boolean isUssdRequest() {
        return this.mIsUssdRequest;
    }

    public boolean isSsInfo() {
        return this.mIsSsInfo;
    }

    @Override
    public void processCode() throws CallStateException {
        block44: {
            try {
                if (this.isShortCode()) {
                    Rlog.d(LOG_TAG, "processCode: isShortCode");
                    this.sendUssd(this.mDialingNumber);
                    break block44;
                }
                if (this.mDialingNumber != null) {
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_CLIP)) {
                    Rlog.d(LOG_TAG, "processCode: is CLIP");
                    if (this.isInterrogate()) {
                        this.mPhone.mCi.queryCLIP(this.obtainMessage(5, this));
                        break block44;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_CLIR)) {
                    Rlog.d(LOG_TAG, "processCode: is CLIR");
                    if (this.isActivate()) {
                        this.mPhone.mCi.setCLIR(1, this.obtainMessage(1, this));
                        break block44;
                    }
                    if (this.isDeactivate()) {
                        this.mPhone.mCi.setCLIR(2, this.obtainMessage(1, this));
                        break block44;
                    }
                    if (this.isInterrogate()) {
                        this.mPhone.mCi.getCLIR(this.obtainMessage(2, this));
                        break block44;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (GsmMmiCode.isServiceCodeCallForwarding(this.mSc)) {
                    Rlog.d(LOG_TAG, "processCode: is CF");
                    String dialingNumber = this.mSia;
                    int serviceClass = GsmMmiCode.siToServiceClass(this.mSib);
                    int reason = GsmMmiCode.scToCallForwardReason(this.mSc);
                    int time = GsmMmiCode.siToTime(this.mSic);
                    if (this.isInterrogate()) {
                        this.mPhone.mCi.queryCallForwardStatus(reason, serviceClass, dialingNumber, this.obtainMessage(3, this));
                    } else {
                        int cfAction;
                        if (this.isActivate()) {
                            if (GsmMmiCode.isEmptyOrNull(dialingNumber)) {
                                cfAction = 1;
                                this.mIsCallFwdReg = false;
                            } else {
                                cfAction = 3;
                                this.mIsCallFwdReg = true;
                            }
                        } else if (this.isDeactivate()) {
                            cfAction = 0;
                        } else if (this.isRegister()) {
                            cfAction = 3;
                        } else if (this.isErasure()) {
                            cfAction = 4;
                        } else {
                            throw new RuntimeException("invalid action");
                        }
                        int isSettingUnconditionalVoice = !(reason != 0 && reason != 4 || (serviceClass & 1) == 0 && serviceClass != 0) ? 1 : 0;
                        int isEnableDesired = cfAction == 1 || cfAction == 3 ? 1 : 0;
                        Rlog.d(LOG_TAG, "processCode: is CF setCallForward");
                        this.mPhone.mCi.setCallForward(cfAction, reason, serviceClass, dialingNumber, time, this.obtainMessage(6, isSettingUnconditionalVoice, isEnableDesired, this));
                    }
                    break block44;
                }
                if (GsmMmiCode.isServiceCodeCallBarring(this.mSc)) {
                    String password = this.mSia;
                    int serviceClass = GsmMmiCode.siToServiceClass(this.mSib);
                    String facility = GsmMmiCode.scToBarringFacility(this.mSc);
                    if (this.isInterrogate()) {
                        this.mPhone.mCi.queryFacilityLock(facility, password, serviceClass, this.obtainMessage(5, this));
                        break block44;
                    }
                    if (this.isActivate() || this.isDeactivate()) {
                        this.mPhone.mCi.setFacilityLock(facility, this.isActivate(), password, serviceClass, this.obtainMessage(1, this));
                        break block44;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_PWD)) {
                    String oldPwd = this.mSib;
                    String newPwd = this.mSic;
                    if (this.isActivate() || this.isRegister()) {
                        this.mAction = ACTION_REGISTER;
                        String facility = this.mSia == null ? "AB" : GsmMmiCode.scToBarringFacility(this.mSia);
                        if (newPwd.equals(this.mPwd)) {
                            this.mPhone.mCi.changeBarringPassword(facility, oldPwd, newPwd, this.obtainMessage(1, this));
                        } else {
                            this.handlePasswordError(17040350);
                        }
                        break block44;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.mSc != null && this.mSc.equals(SC_WAIT)) {
                    int serviceClass = GsmMmiCode.siToServiceClass(this.mSia);
                    if (this.isActivate() || this.isDeactivate()) {
                        this.mPhone.mCi.setCallWaiting(this.isActivate(), serviceClass, this.obtainMessage(1, this));
                        break block44;
                    }
                    if (this.isInterrogate()) {
                        this.mPhone.mCi.queryCallWaiting(serviceClass, this.obtainMessage(5, this));
                        break block44;
                    }
                    throw new RuntimeException("Invalid or Unsupported MMI Code");
                }
                if (this.isPinPukCommand()) {
                    String oldPinOrPuk = this.mSia;
                    String newPinOrPuk = this.mSib;
                    int pinLen = newPinOrPuk.length();
                    if (this.isRegister()) {
                        if (!newPinOrPuk.equals(this.mSic)) {
                            this.handlePasswordError(17040262);
                            break block44;
                        }
                        if (pinLen < 4 || pinLen > 8) {
                            this.handlePasswordError(17039990);
                            break block44;
                        }
                        if (this.mSc.equals(SC_PIN) && this.mUiccApplication != null && this.mUiccApplication.getState() == IccCardApplicationStatus.AppState.APPSTATE_PUK) {
                            this.handlePasswordError(17040276);
                            break block44;
                        }
                        if (this.mUiccApplication != null) {
                            Rlog.d(LOG_TAG, "processCode: process mmi service code using UiccApp sc=" + this.mSc);
                            if (this.mSc.equals(SC_PIN)) {
                                this.mUiccApplication.changeIccLockPassword(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                                break block44;
                            }
                            if (this.mSc.equals(SC_PIN2)) {
                                this.mUiccApplication.changeIccFdnPassword(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                                break block44;
                            }
                            if (this.mSc.equals(SC_PUK)) {
                                this.mUiccApplication.supplyPuk(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                                break block44;
                            }
                            if (this.mSc.equals(SC_PUK2)) {
                                this.mUiccApplication.supplyPuk2(oldPinOrPuk, newPinOrPuk, this.obtainMessage(1, this));
                                break block44;
                            }
                            throw new RuntimeException("uicc unsupported service code=" + this.mSc);
                        }
                        throw new RuntimeException("No application mUiccApplicaiton is null");
                    }
                    throw new RuntimeException("Ivalid register/action=" + this.mAction);
                }
                if (this.mPoundString != null) {
                    this.sendUssd(this.mPoundString);
                    break block44;
                }
                Rlog.d(LOG_TAG, "processCode: Invalid or Unsupported MMI Code");
                throw new RuntimeException("Invalid or Unsupported MMI Code");
            }
            catch (RuntimeException exc) {
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.mContext.getText(17040268);
                Rlog.d(LOG_TAG, "processCode: RuntimeException=" + exc);
                this.mPhone.onMMIDone(this);
            }
        }
    }

    private void handlePasswordError(int res) {
        this.mState = MmiCode.State.FAILED;
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        sb.append(this.mContext.getText(res));
        this.mMessage = sb;
        this.mPhone.onMMIDone(this);
    }

    public void onUssdFinished(String ussdMessage, boolean isUssdRequest) {
        if (this.mState == MmiCode.State.PENDING) {
            if (TextUtils.isEmpty(ussdMessage)) {
                Rlog.d(LOG_TAG, "onUssdFinished: no network provided message; using default.");
                this.mMessage = this.mContext.getText(17040267);
            } else {
                this.mMessage = ussdMessage;
            }
            this.mIsUssdRequest = isUssdRequest;
            if (!isUssdRequest) {
                this.mState = MmiCode.State.COMPLETE;
            }
            Rlog.d(LOG_TAG, "onUssdFinished: ussdMessage=" + ussdMessage);
            this.mPhone.onMMIDone(this);
        }
    }

    public void onUssdFinishedError() {
        if (this.mState == MmiCode.State.PENDING) {
            this.mState = MmiCode.State.FAILED;
            this.mMessage = this.mContext.getText(17040268);
            Rlog.d(LOG_TAG, "onUssdFinishedError");
            this.mPhone.onMMIDone(this);
        }
    }

    public void onUssdRelease() {
        if (this.mState == MmiCode.State.PENDING) {
            this.mState = MmiCode.State.COMPLETE;
            this.mMessage = null;
            Rlog.d(LOG_TAG, "onUssdRelease");
            this.mPhone.onMMIDone(this);
        }
    }

    public void sendUssd(String ussdMessage) {
        this.mIsPendingUSSD = true;
        this.mPhone.mCi.sendUSSD(ussdMessage, this.obtainMessage(4, this));
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSetComplete(msg, ar);
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null && msg.arg1 == 1) {
                    boolean cffEnabled;
                    boolean bl = cffEnabled = msg.arg2 == 1;
                    if (this.mIccRecords != null) {
                        this.mPhone.setVoiceCallForwardingFlag(1, cffEnabled, this.mDialingNumber);
                    }
                }
                this.onSetComplete(msg, ar);
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onGetClirComplete(ar);
                break;
            }
            case 3: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryCfComplete(ar);
                break;
            }
            case 5: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onQueryComplete(ar);
                break;
            }
            case 4: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) break;
                this.mState = MmiCode.State.FAILED;
                this.mMessage = this.getErrorMessage(ar);
                this.mPhone.onMMIDone(this);
                break;
            }
            case 7: {
                this.mPhone.onMMIDone(this);
            }
        }
    }

    private CharSequence getErrorMessage(AsyncResult ar) {
        if (ar.exception instanceof CommandException) {
            CommandException.Error err = ((CommandException)ar.exception).getCommandError();
            if (err == CommandException.Error.FDN_CHECK_FAILURE) {
                Rlog.i(LOG_TAG, "FDN_CHECK_FAILURE");
                return this.mContext.getText(17040270);
            }
            if (err == CommandException.Error.USSD_MODIFIED_TO_DIAL) {
                Rlog.i(LOG_TAG, "USSD_MODIFIED_TO_DIAL");
                return this.mContext.getText(17040848);
            }
            if (err == CommandException.Error.USSD_MODIFIED_TO_SS) {
                Rlog.i(LOG_TAG, "USSD_MODIFIED_TO_SS");
                return this.mContext.getText(17040849);
            }
            if (err == CommandException.Error.USSD_MODIFIED_TO_USSD) {
                Rlog.i(LOG_TAG, "USSD_MODIFIED_TO_USSD");
                return this.mContext.getText(17040850);
            }
            if (err == CommandException.Error.SS_MODIFIED_TO_DIAL) {
                Rlog.i(LOG_TAG, "SS_MODIFIED_TO_DIAL");
                return this.mContext.getText(17040845);
            }
            if (err == CommandException.Error.SS_MODIFIED_TO_USSD) {
                Rlog.i(LOG_TAG, "SS_MODIFIED_TO_USSD");
                return this.mContext.getText(17040847);
            }
            if (err == CommandException.Error.SS_MODIFIED_TO_SS) {
                Rlog.i(LOG_TAG, "SS_MODIFIED_TO_SS");
                return this.mContext.getText(17040846);
            }
        }
        return this.mContext.getText(17040268);
    }

    private CharSequence getScString() {
        if (this.mSc != null) {
            if (GsmMmiCode.isServiceCodeCallBarring(this.mSc)) {
                return this.mContext.getText(17039386);
            }
            if (GsmMmiCode.isServiceCodeCallForwarding(this.mSc)) {
                return this.mContext.getText(17039392);
            }
            if (this.mSc.equals(SC_CLIP)) {
                return this.mContext.getText(17039393);
            }
            if (this.mSc.equals(SC_CLIR)) {
                return this.mContext.getText(17039394);
            }
            if (this.mSc.equals(SC_PWD)) {
                return this.mContext.getText(17039407);
            }
            if (this.mSc.equals(SC_WAIT)) {
                return this.mContext.getText(17039400);
            }
            if (this.isPinPukCommand()) {
                return this.mContext.getText(17039406);
            }
        }
        return "";
    }

    private void onSetComplete(Message msg, AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            if (ar.exception instanceof CommandException) {
                CommandException.Error err = ((CommandException)ar.exception).getCommandError();
                if (err == CommandException.Error.PASSWORD_INCORRECT) {
                    if (this.isPinPukCommand()) {
                        if (this.mSc.equals(SC_PUK) || this.mSc.equals(SC_PUK2)) {
                            sb.append(this.mContext.getText(17039567));
                        } else {
                            sb.append(this.mContext.getText(17039566));
                        }
                        int attemptsRemaining = msg.arg1;
                        if (attemptsRemaining <= 0) {
                            Rlog.d(LOG_TAG, "onSetComplete: PUK locked, cancel as lock screen will handle this");
                            this.mState = MmiCode.State.CANCELLED;
                        } else if (attemptsRemaining > 0) {
                            Rlog.d(LOG_TAG, "onSetComplete: attemptsRemaining=" + attemptsRemaining);
                            sb.append(this.mContext.getResources().getQuantityString(18153492, attemptsRemaining, attemptsRemaining));
                        }
                    } else {
                        sb.append(this.mContext.getText(17040350));
                    }
                } else if (err == CommandException.Error.SIM_PUK2) {
                    sb.append(this.mContext.getText(17039566));
                    sb.append("\n");
                    sb.append(this.mContext.getText(17040277));
                } else if (err == CommandException.Error.REQUEST_NOT_SUPPORTED) {
                    if (this.mSc.equals(SC_PIN)) {
                        sb.append(this.mContext.getText(17039800));
                    }
                } else if (err == CommandException.Error.FDN_CHECK_FAILURE) {
                    Rlog.i(LOG_TAG, "FDN_CHECK_FAILURE");
                    sb.append(this.mContext.getText(17040270));
                } else if (err == CommandException.Error.MODEM_ERR) {
                    if (GsmMmiCode.isServiceCodeCallForwarding(this.mSc) && this.mPhone.getServiceState().getVoiceRoaming() && !this.mPhone.supports3gppCallForwardingWhileRoaming()) {
                        sb.append(this.mContext.getText(17040269));
                    } else {
                        sb.append(this.getErrorMessage(ar));
                    }
                } else {
                    sb.append(this.getErrorMessage(ar));
                }
            } else {
                sb.append(this.mContext.getText(17040268));
            }
        } else if (this.isActivate()) {
            this.mState = MmiCode.State.COMPLETE;
            if (this.mIsCallFwdReg) {
                sb.append(this.mContext.getText(17040768));
            } else {
                sb.append(this.mContext.getText(17040764));
            }
            if (this.mSc.equals(SC_CLIR)) {
                this.mPhone.saveClirSetting(1);
            }
        } else if (this.isDeactivate()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17040763));
            if (this.mSc.equals(SC_CLIR)) {
                this.mPhone.saveClirSetting(2);
            }
        } else if (this.isRegister()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17040768));
        } else if (this.isErasure()) {
            this.mState = MmiCode.State.COMPLETE;
            sb.append(this.mContext.getText(17040766));
        } else {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.mContext.getText(17040268));
        }
        this.mMessage = sb;
        Rlog.d(LOG_TAG, "onSetComplete mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private void onGetClirComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.getErrorMessage(ar));
        } else {
            int[] clirArgs = (int[])ar.result;
            switch (clirArgs[1]) {
                case 0: {
                    sb.append(this.mContext.getText(17040767));
                    this.mState = MmiCode.State.COMPLETE;
                    break;
                }
                case 1: {
                    sb.append(this.mContext.getText(17039391));
                    this.mState = MmiCode.State.COMPLETE;
                    break;
                }
                case 2: {
                    sb.append(this.mContext.getText(17040268));
                    this.mState = MmiCode.State.FAILED;
                    break;
                }
                case 3: {
                    switch (clirArgs[0]) {
                        default: {
                            sb.append(this.mContext.getText(17039390));
                            break;
                        }
                        case 1: {
                            sb.append(this.mContext.getText(17039390));
                            break;
                        }
                        case 2: {
                            sb.append(this.mContext.getText(17039389));
                        }
                    }
                    this.mState = MmiCode.State.COMPLETE;
                    break;
                }
                case 4: {
                    switch (clirArgs[0]) {
                        default: {
                            sb.append(this.mContext.getText(17039387));
                            break;
                        }
                        case 1: {
                            sb.append(this.mContext.getText(17039388));
                            break;
                        }
                        case 2: {
                            sb.append(this.mContext.getText(17039387));
                        }
                    }
                    this.mState = MmiCode.State.COMPLETE;
                }
            }
        }
        this.mMessage = sb;
        Rlog.d(LOG_TAG, "onGetClirComplete: mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private CharSequence serviceClassToCFString(int serviceClass) {
        switch (serviceClass) {
            case 1: {
                return this.mContext.getText(17040762);
            }
            case 2: {
                return this.mContext.getText(17040755);
            }
            case 4: {
                return this.mContext.getText(17040758);
            }
            case 8: {
                return this.mContext.getText(17040761);
            }
            case 16: {
                return this.mContext.getText(17040757);
            }
            case 32: {
                return this.mContext.getText(17040756);
            }
            case 64: {
                return this.mContext.getText(17040760);
            }
            case 128: {
                return this.mContext.getText(17040759);
            }
        }
        return null;
    }

    private CharSequence makeCFQueryResultMessage(CallForwardInfo info, int serviceClassMask) {
        boolean needTimeTemplate;
        String[] sources = new String[]{"{0}", "{1}", "{2}"};
        CharSequence[] destinations = new CharSequence[3];
        boolean bl = needTimeTemplate = info.reason == 2;
        CharSequence template = info.status == 1 ? (needTimeTemplate ? this.mContext.getText(17039603) : this.mContext.getText(17039602)) : (info.status == 0 && GsmMmiCode.isEmptyOrNull(info.number) ? this.mContext.getText(17039604) : (needTimeTemplate ? this.mContext.getText(17039606) : this.mContext.getText(17039605)));
        destinations[0] = this.serviceClassToCFString(info.serviceClass & serviceClassMask);
        destinations[1] = this.formatLtr(PhoneNumberUtils.stringFromStringAndTOA(info.number, info.toa));
        destinations[2] = Integer.toString(info.timeSeconds);
        if (info.reason == 0 && (info.serviceClass & serviceClassMask) == 1) {
            boolean cffEnabled;
            boolean bl2 = cffEnabled = info.status == 1;
            if (this.mIccRecords != null) {
                this.mPhone.setVoiceCallForwardingFlag(1, cffEnabled, info.number);
            }
        }
        return TextUtils.replace(template, sources, destinations);
    }

    private String formatLtr(String str) {
        BidiFormatter fmt = BidiFormatter.getInstance();
        return str == null ? str : fmt.unicodeWrap(str, TextDirectionHeuristics.LTR, true);
    }

    private void onQueryCfComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.getErrorMessage(ar));
        } else {
            CallForwardInfo[] infos = (CallForwardInfo[])ar.result;
            if (infos.length == 0) {
                sb.append(this.mContext.getText(17040763));
                if (this.mIccRecords != null) {
                    this.mPhone.setVoiceCallForwardingFlag(1, false, null);
                }
            } else {
                SpannableStringBuilder tb = new SpannableStringBuilder();
                for (int serviceClassMask = 1; serviceClassMask <= 128; serviceClassMask <<= 1) {
                    int s = infos.length;
                    for (int i = 0; i < s; ++i) {
                        if ((serviceClassMask & infos[i].serviceClass) == 0) continue;
                        tb.append(this.makeCFQueryResultMessage(infos[i], serviceClassMask));
                        tb.append("\n");
                    }
                }
                sb.append(tb);
            }
            this.mState = MmiCode.State.COMPLETE;
        }
        this.mMessage = sb;
        Rlog.d(LOG_TAG, "onQueryCfComplete: mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private void onQueryComplete(AsyncResult ar) {
        StringBuilder sb = new StringBuilder(this.getScString());
        sb.append("\n");
        if (ar.exception != null) {
            this.mState = MmiCode.State.FAILED;
            sb.append(this.getErrorMessage(ar));
        } else {
            int[] ints = (int[])ar.result;
            if (ints.length != 0) {
                if (ints[0] == 0) {
                    sb.append(this.mContext.getText(17040763));
                } else if (this.mSc.equals(SC_WAIT)) {
                    sb.append(this.createQueryCallWaitingResultMessage(ints[1]));
                } else if (GsmMmiCode.isServiceCodeCallBarring(this.mSc)) {
                    sb.append(this.createQueryCallBarringResultMessage(ints[0]));
                } else if (ints[0] == 1) {
                    sb.append(this.mContext.getText(17040764));
                } else {
                    sb.append(this.mContext.getText(17040268));
                }
            } else {
                sb.append(this.mContext.getText(17040268));
            }
            this.mState = MmiCode.State.COMPLETE;
        }
        this.mMessage = sb;
        Rlog.d(LOG_TAG, "onQueryComplete: mmi=" + this);
        this.mPhone.onMMIDone(this);
    }

    private CharSequence createQueryCallWaitingResultMessage(int serviceClass) {
        StringBuilder sb = new StringBuilder(this.mContext.getText(17040765));
        for (int classMask = 1; classMask <= 128; classMask <<= 1) {
            if ((classMask & serviceClass) == 0) continue;
            sb.append("\n");
            sb.append(this.serviceClassToCFString(classMask & serviceClass));
        }
        return sb;
    }

    private CharSequence createQueryCallBarringResultMessage(int serviceClass) {
        StringBuilder sb = new StringBuilder(this.mContext.getText(17040765));
        for (int classMask = 1; classMask <= 128; classMask <<= 1) {
            if ((classMask & serviceClass) == 0) continue;
            sb.append("\n");
            sb.append(this.serviceClassToCFString(classMask & serviceClass));
        }
        return sb;
    }

    @Override
    public ResultReceiver getUssdCallbackReceiver() {
        return this.mCallbackReceiver;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("GsmMmiCode {");
        sb.append("State=" + (Object)((Object)this.getState()));
        if (this.mAction != null) {
            sb.append(" action=" + this.mAction);
        }
        if (this.mSc != null) {
            sb.append(" sc=" + this.mSc);
        }
        if (this.mSia != null) {
            sb.append(" sia=" + Rlog.pii(LOG_TAG, (Object)this.mSia));
        }
        if (this.mSib != null) {
            sb.append(" sib=" + Rlog.pii(LOG_TAG, (Object)this.mSib));
        }
        if (this.mSic != null) {
            sb.append(" sic=" + Rlog.pii(LOG_TAG, (Object)this.mSic));
        }
        if (this.mPoundString != null) {
            sb.append(" poundString=" + Rlog.pii(LOG_TAG, (Object)this.mPoundString));
        }
        if (this.mDialingNumber != null) {
            sb.append(" dialingNumber=" + Rlog.pii(LOG_TAG, (Object)this.mDialingNumber));
        }
        if (this.mPwd != null) {
            sb.append(" pwd=" + Rlog.pii(LOG_TAG, (Object)this.mPwd));
        }
        if (this.mCallbackReceiver != null) {
            sb.append(" hasReceiver");
        }
        sb.append("}");
        return sb.toString();
    }
}

