/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.ResultReceiver;
import android.os.SystemProperties;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.UssdResponse;
import android.text.TextUtils;
import com.android.ims.ImsCallForwardInfo;
import com.android.ims.ImsEcbm;
import com.android.ims.ImsEcbmStateListener;
import com.android.ims.ImsException;
import com.android.ims.ImsManager;
import com.android.ims.ImsReasonInfo;
import com.android.ims.ImsSsInfo;
import com.android.ims.ImsUtInterface;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.imsphone.ImsExternalCallTracker;
import com.android.internal.telephony.imsphone.ImsPhoneBase;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import com.android.internal.telephony.imsphone.ImsPhoneMmiCode;
import com.android.internal.telephony.uicc.IccRecords;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class ImsPhone
extends ImsPhoneBase {
    private static final String LOG_TAG = "ImsPhone";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int EVENT_SET_CALL_BARRING_DONE = 45;
    private static final int EVENT_GET_CALL_BARRING_DONE = 46;
    private static final int EVENT_SET_CALL_WAITING_DONE = 47;
    private static final int EVENT_GET_CALL_WAITING_DONE = 48;
    private static final int EVENT_SET_CLIR_DONE = 49;
    private static final int EVENT_GET_CLIR_DONE = 50;
    private static final int EVENT_DEFAULT_PHONE_DATA_STATE_CHANGED = 51;
    private static final int EVENT_SERVICE_STATE_CHANGED = 52;
    private static final int EVENT_VOICE_CALL_ENDED = 53;
    static final int RESTART_ECM_TIMER = 0;
    static final int CANCEL_ECM_TIMER = 1;
    private static final int DEFAULT_ECM_EXIT_TIMER_VALUE = 300000;
    Phone mDefaultPhone;
    ImsPhoneCallTracker mCT;
    ImsExternalCallTracker mExternalCallTracker;
    private ArrayList<ImsPhoneMmiCode> mPendingMMIs = new ArrayList();
    private ServiceState mSS = new ServiceState();
    private String mLastDialString;
    private PowerManager.WakeLock mWakeLock;
    private Registrant mEcmExitRespRegistrant;
    private final RegistrantList mSilentRedialRegistrants = new RegistrantList();
    private boolean mImsRegistered = false;
    private boolean mRoaming = false;
    private RegistrantList mSsnRegistrants = new RegistrantList();
    private Runnable mExitEcmRunnable = new Runnable(){

        @Override
        public void run() {
            ImsPhone.this.exitEmergencyCallbackMode();
        }
    };
    private Uri[] mCurrentSubscriberUris;
    private ImsEcbmStateListener mImsEcbmStateListener = new ImsEcbmStateListener(){

        @Override
        public void onECBMEntered() {
            Rlog.d(ImsPhone.LOG_TAG, "onECBMEntered");
            ImsPhone.this.handleEnterEmergencyCallbackMode();
        }

        @Override
        public void onECBMExited() {
            Rlog.d(ImsPhone.LOG_TAG, "onECBMExited");
            ImsPhone.this.handleExitEmergencyCallbackMode();
        }
    };
    private BroadcastReceiver mResultReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (this.getResultCode() == -1) {
                CharSequence title = intent.getCharSequenceExtra("alertTitle");
                CharSequence messageAlert = intent.getCharSequenceExtra("alertMessage");
                CharSequence messageNotification = intent.getCharSequenceExtra("notificationMessage");
                Intent resultIntent = new Intent("android.intent.action.MAIN");
                resultIntent.setClassName("com.android.settings", "com.android.settings.Settings$WifiCallingSettingsActivity");
                resultIntent.putExtra("alertShow", true);
                resultIntent.putExtra("alertTitle", title);
                resultIntent.putExtra("alertMessage", messageAlert);
                PendingIntent resultPendingIntent = PendingIntent.getActivity(ImsPhone.this.mContext, 0, resultIntent, 0x8000000);
                Notification notification = new Notification.Builder(ImsPhone.this.mContext).setSmallIcon(17301642).setContentTitle(title).setContentText(messageNotification).setAutoCancel(true).setContentIntent(resultPendingIntent).setStyle(new Notification.BigTextStyle().bigText(messageNotification)).setChannelId("wfc").build();
                String notificationTag = "wifi_calling";
                boolean notificationId = true;
                NotificationManager notificationManager = (NotificationManager)ImsPhone.this.mContext.getSystemService("notification");
                notificationManager.notify("wifi_calling", 1, notification);
            }
        }
    };

    protected void setCurrentSubscriberUris(Uri[] currentSubscriberUris) {
        this.mCurrentSubscriberUris = currentSubscriberUris;
    }

    @Override
    public Uri[] getCurrentSubscriberUris() {
        return this.mCurrentSubscriberUris;
    }

    public ImsPhone(Context context, PhoneNotifier notifier, Phone defaultPhone) {
        this(context, notifier, defaultPhone, false);
    }

    public ImsPhone(Context context, PhoneNotifier notifier, Phone defaultPhone, boolean unitTestMode) {
        super(LOG_TAG, context, notifier, unitTestMode);
        this.mDefaultPhone = defaultPhone;
        this.mExternalCallTracker = TelephonyComponentFactory.getInstance().makeImsExternalCallTracker(this);
        this.mCT = TelephonyComponentFactory.getInstance().makeImsPhoneCallTracker(this);
        this.mCT.registerPhoneStateListener(this.mExternalCallTracker);
        this.mExternalCallTracker.setCallPuller(this.mCT);
        this.mSS.setStateOff();
        this.mPhoneId = this.mDefaultPhone.getPhoneId();
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, LOG_TAG);
        this.mWakeLock.setReferenceCounted(false);
        if (this.mDefaultPhone.getServiceStateTracker() != null) {
            this.mDefaultPhone.getServiceStateTracker().registerForDataRegStateOrRatChanged(this, 51, null);
        }
        this.updateDataServiceState();
        this.mDefaultPhone.registerForServiceStateChanged(this, 52, null);
    }

    @Override
    public void dispose() {
        Rlog.d(LOG_TAG, "dispose");
        this.mPendingMMIs.clear();
        this.mExternalCallTracker.tearDown();
        this.mCT.unregisterPhoneStateListener(this.mExternalCallTracker);
        this.mCT.unregisterForVoiceCallEnded(this);
        this.mCT.dispose();
        if (this.mDefaultPhone != null && this.mDefaultPhone.getServiceStateTracker() != null) {
            this.mDefaultPhone.getServiceStateTracker().unregisterForDataRegStateOrRatChanged(this);
            this.mDefaultPhone.unregisterForServiceStateChanged(this);
        }
    }

    @Override
    public ServiceState getServiceState() {
        return this.mSS;
    }

    void setServiceState(int state) {
        this.mSS.setVoiceRegState(state);
        this.updateDataServiceState();
    }

    @Override
    public CallTracker getCallTracker() {
        return this.mCT;
    }

    public ImsExternalCallTracker getExternalCallTracker() {
        return this.mExternalCallTracker;
    }

    public List<? extends ImsPhoneMmiCode> getPendingMmiCodes() {
        return this.mPendingMMIs;
    }

    @Override
    public void acceptCall(int videoState) throws CallStateException {
        this.mCT.acceptCall(videoState);
    }

    @Override
    public void rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    @Override
    public boolean canConference() {
        return this.mCT.canConference();
    }

    @Override
    public boolean canDial() {
        return this.mCT.canDial();
    }

    @Override
    public void conference() {
        this.mCT.conference();
    }

    @Override
    public void clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    @Override
    public boolean canTransfer() {
        return this.mCT.canTransfer();
    }

    @Override
    public void explicitCallTransfer() {
        this.mCT.explicitCallTransfer();
    }

    @Override
    public ImsPhoneCall getForegroundCall() {
        return this.mCT.mForegroundCall;
    }

    @Override
    public ImsPhoneCall getBackgroundCall() {
        return this.mCT.mBackgroundCall;
    }

    @Override
    public ImsPhoneCall getRingingCall() {
        return this.mCT.mRingingCall;
    }

    private boolean handleCallDeflectionIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        if (this.getRingingCall().getState() != Call.State.IDLE) {
            Rlog.d(LOG_TAG, "MmiCode 0: rejectCall");
            try {
                this.mCT.rejectCall();
            }
            catch (CallStateException e) {
                Rlog.d(LOG_TAG, "reject failed", e);
                this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.REJECT);
            }
        } else if (this.getBackgroundCall().getState() != Call.State.IDLE) {
            Rlog.d(LOG_TAG, "MmiCode 0: hangupWaitingOrBackground");
            try {
                this.mCT.hangup(this.getBackgroundCall());
            }
            catch (CallStateException e) {
                Rlog.d(LOG_TAG, "hangup failed", e);
            }
        }
        return true;
    }

    private void sendUssdResponse(String ussdRequest, CharSequence message, int returnCode, ResultReceiver wrappedCallback) {
        UssdResponse response = new UssdResponse(ussdRequest, message);
        Bundle returnData = new Bundle();
        returnData.putParcelable("USSD_RESPONSE", response);
        wrappedCallback.send(returnCode, returnData);
    }

    @Override
    public boolean handleUssdRequest(String ussdRequest, ResultReceiver wrappedCallback) throws CallStateException {
        if (this.mPendingMMIs.size() > 0) {
            Rlog.i(LOG_TAG, "handleUssdRequest: queue full: " + Rlog.pii(LOG_TAG, (Object)ussdRequest));
            this.sendUssdResponse(ussdRequest, null, -1, wrappedCallback);
            return true;
        }
        try {
            this.dialInternal(ussdRequest, 0, null, wrappedCallback);
        }
        catch (CallStateException cse) {
            if ("cs_fallback".equals(cse.getMessage())) {
                throw cse;
            }
            Rlog.w(LOG_TAG, "Could not execute USSD " + cse);
            this.sendUssdResponse(ussdRequest, null, -1, wrappedCallback);
        }
        catch (Exception e) {
            Rlog.w(LOG_TAG, "Could not execute USSD " + e);
            this.sendUssdResponse(ussdRequest, null, -1, wrappedCallback);
            return false;
        }
        return true;
    }

    private boolean handleCallWaitingIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        ImsPhoneCall call = this.getForegroundCall();
        try {
            if (len > 1) {
                Rlog.d(LOG_TAG, "not support 1X SEND");
                this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.HANGUP);
            } else if (call.getState() != Call.State.IDLE) {
                Rlog.d(LOG_TAG, "MmiCode 1: hangup foreground");
                this.mCT.hangup(call);
            } else {
                Rlog.d(LOG_TAG, "MmiCode 1: switchWaitingOrHoldingAndActive");
                this.mCT.switchWaitingOrHoldingAndActive();
            }
        }
        catch (CallStateException e) {
            Rlog.d(LOG_TAG, "hangup failed", e);
            this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.HANGUP);
        }
        return true;
    }

    private boolean handleCallHoldIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        if (len > 1) {
            Rlog.d(LOG_TAG, "separate not supported");
            this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.SEPARATE);
        } else {
            try {
                if (this.getRingingCall().getState() != Call.State.IDLE) {
                    Rlog.d(LOG_TAG, "MmiCode 2: accept ringing call");
                    this.mCT.acceptCall(2);
                } else {
                    Rlog.d(LOG_TAG, "MmiCode 2: switchWaitingOrHoldingAndActive");
                    this.mCT.switchWaitingOrHoldingAndActive();
                }
            }
            catch (CallStateException e) {
                Rlog.d(LOG_TAG, "switch failed", e);
                this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.SWITCH);
            }
        }
        return true;
    }

    private boolean handleMultipartyIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        Rlog.d(LOG_TAG, "MmiCode 3: merge calls");
        this.conference();
        return true;
    }

    private boolean handleEctIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len != 1) {
            return false;
        }
        Rlog.d(LOG_TAG, "MmiCode 4: not support explicit call transfer");
        this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.TRANSFER);
        return true;
    }

    private boolean handleCcbsIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        Rlog.i(LOG_TAG, "MmiCode 5: CCBS not supported!");
        this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.UNKNOWN);
        return true;
    }

    public void notifySuppSvcNotification(SuppServiceNotification suppSvc) {
        Rlog.d(LOG_TAG, "notifySuppSvcNotification: suppSvc = " + suppSvc);
        AsyncResult ar = new AsyncResult(null, suppSvc, null);
        this.mSsnRegistrants.notifyRegistrants(ar);
    }

    @Override
    public boolean handleInCallMmiCommands(String dialString) {
        if (!this.isInCall()) {
            return false;
        }
        if (TextUtils.isEmpty(dialString)) {
            return false;
        }
        boolean result = false;
        char ch = dialString.charAt(0);
        switch (ch) {
            case '0': {
                result = this.handleCallDeflectionIncallSupplementaryService(dialString);
                break;
            }
            case '1': {
                result = this.handleCallWaitingIncallSupplementaryService(dialString);
                break;
            }
            case '2': {
                result = this.handleCallHoldIncallSupplementaryService(dialString);
                break;
            }
            case '3': {
                result = this.handleMultipartyIncallSupplementaryService(dialString);
                break;
            }
            case '4': {
                result = this.handleEctIncallSupplementaryService(dialString);
                break;
            }
            case '5': {
                result = this.handleCcbsIncallSupplementaryService(dialString);
                break;
            }
        }
        return result;
    }

    @Override
    boolean isInCall() {
        Call.State foregroundCallState = this.getForegroundCall().getState();
        Call.State backgroundCallState = this.getBackgroundCall().getState();
        Call.State ringingCallState = this.getRingingCall().getState();
        return foregroundCallState.isAlive() || backgroundCallState.isAlive() || ringingCallState.isAlive();
    }

    @Override
    public boolean isInEcm() {
        return this.mDefaultPhone.isInEcm();
    }

    @Override
    public void setIsInEcm(boolean isInEcm) {
        this.mDefaultPhone.setIsInEcm(isInEcm);
    }

    public void notifyNewRingingConnection(Connection c) {
        this.mDefaultPhone.notifyNewRingingConnectionP(c);
    }

    void notifyUnknownConnection(Connection c) {
        this.mDefaultPhone.notifyUnknownConnectionP(c);
    }

    @Override
    public void notifyForVideoCapabilityChanged(boolean isVideoCapable) {
        this.mIsVideoCapable = isVideoCapable;
        this.mDefaultPhone.notifyForVideoCapabilityChanged(isVideoCapable);
    }

    @Override
    public Connection dial(String dialString, int videoState) throws CallStateException {
        return this.dialInternal(dialString, videoState, null, null);
    }

    @Override
    public Connection dial(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras) throws CallStateException {
        return this.dialInternal(dialString, videoState, intentExtras, null);
    }

    protected Connection dialInternal(String dialString, int videoState, Bundle intentExtras) throws CallStateException {
        return this.dialInternal(dialString, videoState, intentExtras, null);
    }

    private Connection dialInternal(String dialString, int videoState, Bundle intentExtras, ResultReceiver wrappedCallback) throws CallStateException {
        block7: {
            String newDialString = PhoneNumberUtils.stripSeparators(dialString);
            if (this.handleInCallMmiCommands(newDialString)) {
                return null;
            }
            if (this.mDefaultPhone.getPhoneType() == 2) {
                return this.mCT.dial(dialString, videoState, intentExtras);
            }
            String networkPortion = PhoneNumberUtils.extractNetworkPortionAlt(newDialString);
            ImsPhoneMmiCode mmi = ImsPhoneMmiCode.newFromDialString(networkPortion, this, wrappedCallback);
            Rlog.d(LOG_TAG, "dialInternal: dialing w/ mmi '" + mmi + "'...");
            if (mmi == null) {
                return this.mCT.dial(dialString, videoState, intentExtras);
            }
            if (mmi.isTemporaryModeCLIR()) {
                return this.mCT.dial(mmi.getDialingNumber(), mmi.getCLIRMode(), videoState, intentExtras);
            }
            if (!mmi.isSupportedOverImsPhone()) {
                Rlog.i(LOG_TAG, "dialInternal: USSD not supported by IMS; fallback to CS.");
                throw new CallStateException("cs_fallback");
            }
            this.mPendingMMIs.add(mmi);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            try {
                mmi.processCode();
            }
            catch (CallStateException cse) {
                if (!"cs_fallback".equals(cse.getMessage())) break block7;
                Rlog.i(LOG_TAG, "dialInternal: fallback to GSM required.");
                this.mPendingMMIs.remove(mmi);
                throw cse;
            }
        }
        return null;
    }

    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Rlog.e(LOG_TAG, "sendDtmf called with invalid character '" + c + "'");
        } else if (this.mCT.getState() == PhoneConstants.State.OFFHOOK) {
            this.mCT.sendDtmf(c, null);
        }
    }

    @Override
    public void startDtmf(char c) {
        if (!(PhoneNumberUtils.is12Key(c) || c >= 'A' && c <= 'D')) {
            Rlog.e(LOG_TAG, "startDtmf called with invalid character '" + c + "'");
        } else {
            this.mCT.startDtmf(c);
        }
    }

    @Override
    public void stopDtmf() {
        this.mCT.stopDtmf();
    }

    public void notifyIncomingRing() {
        Rlog.d(LOG_TAG, "notifyIncomingRing");
        AsyncResult ar = new AsyncResult(null, null, null);
        this.sendMessage(this.obtainMessage(14, ar));
    }

    @Override
    public void setMute(boolean muted) {
        this.mCT.setMute(muted);
    }

    @Override
    public void setUiTTYMode(int uiTtyMode, Message onComplete) {
        this.mCT.setUiTTYMode(uiTtyMode, onComplete);
    }

    @Override
    public boolean getMute() {
        return this.mCT.getMute();
    }

    @Override
    public PhoneConstants.State getState() {
        return this.mCT.getState();
    }

    private boolean isValidCommandInterfaceCFReason(int commandInterfaceCFReason) {
        switch (commandInterfaceCFReason) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private boolean isValidCommandInterfaceCFAction(int commandInterfaceCFAction) {
        switch (commandInterfaceCFAction) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private boolean isCfEnable(int action) {
        return action == 1 || action == 3;
    }

    private int getConditionFromCFReason(int reason) {
        switch (reason) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return -1;
    }

    private int getCFReasonFromCondition(int condition) {
        switch (condition) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 3;
    }

    private int getActionFromCFAction(int action) {
        switch (action) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message onComplete) {
        Rlog.d(LOG_TAG, "getCLIR");
        Message resp = this.obtainMessage(50, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.queryCLIR(resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    @Override
    public void setOutgoingCallerIdDisplay(int clirMode, Message onComplete) {
        Rlog.d(LOG_TAG, "setCLIR action= " + clirMode);
        Message resp = this.obtainMessage(49, clirMode, 0, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.updateCLIR(clirMode, resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    @Override
    public void getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        Rlog.d(LOG_TAG, "getCallForwardingOption reason=" + commandInterfaceCFReason);
        if (this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Rlog.d(LOG_TAG, "requesting call forwarding query.");
            Message resp = this.obtainMessage(13, onComplete);
            try {
                ImsUtInterface ut = this.mCT.getUtInterface();
                ut.queryCallForward(this.getConditionFromCFReason(commandInterfaceCFReason), null, resp);
            }
            catch (ImsException e) {
                this.sendErrorResponse(onComplete, e);
            }
        } else if (onComplete != null) {
            this.sendErrorResponse(onComplete);
        }
    }

    @Override
    public void setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int timerSeconds, Message onComplete) {
        this.setCallForwardingOption(commandInterfaceCFAction, commandInterfaceCFReason, dialingNumber, 1, timerSeconds, onComplete);
    }

    public void setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int serviceClass, int timerSeconds, Message onComplete) {
        Rlog.d(LOG_TAG, "setCallForwardingOption action=" + commandInterfaceCFAction + ", reason=" + commandInterfaceCFReason + " serviceClass=" + serviceClass);
        if (this.isValidCommandInterfaceCFAction(commandInterfaceCFAction) && this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Cf cf = new Cf(dialingNumber, commandInterfaceCFReason == 0, onComplete);
            Message resp = this.obtainMessage(12, this.isCfEnable(commandInterfaceCFAction) ? 1 : 0, 0, cf);
            try {
                ImsUtInterface ut = this.mCT.getUtInterface();
                ut.updateCallForward(this.getActionFromCFAction(commandInterfaceCFAction), this.getConditionFromCFReason(commandInterfaceCFReason), dialingNumber, serviceClass, timerSeconds, resp);
            }
            catch (ImsException e) {
                this.sendErrorResponse(onComplete, e);
            }
        } else if (onComplete != null) {
            this.sendErrorResponse(onComplete);
        }
    }

    @Override
    public void getCallWaiting(Message onComplete) {
        Rlog.d(LOG_TAG, "getCallWaiting");
        Message resp = this.obtainMessage(48, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.queryCallWaiting(resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    @Override
    public void setCallWaiting(boolean enable, Message onComplete) {
        this.setCallWaiting(enable, 1, onComplete);
    }

    public void setCallWaiting(boolean enable, int serviceClass, Message onComplete) {
        Rlog.d(LOG_TAG, "setCallWaiting enable=" + enable);
        Message resp = this.obtainMessage(47, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.updateCallWaiting(enable, serviceClass, resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    private int getCBTypeFromFacility(String facility) {
        if ("AO".equals(facility)) {
            return 2;
        }
        if ("OI".equals(facility)) {
            return 3;
        }
        if ("OX".equals(facility)) {
            return 4;
        }
        if ("AI".equals(facility)) {
            return 1;
        }
        if ("IR".equals(facility)) {
            return 5;
        }
        if ("AB".equals(facility)) {
            return 7;
        }
        if ("AG".equals(facility)) {
            return 8;
        }
        if ("AC".equals(facility)) {
            return 9;
        }
        return 0;
    }

    public void getCallBarring(String facility, Message onComplete) {
        Rlog.d(LOG_TAG, "getCallBarring facility=" + facility);
        Message resp = this.obtainMessage(46, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.queryCallBarring(this.getCBTypeFromFacility(facility), resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    public void setCallBarring(String facility, boolean lockState, String password, Message onComplete) {
        Rlog.d(LOG_TAG, "setCallBarring facility=" + facility + ", lockState=" + lockState);
        Message resp = this.obtainMessage(45, onComplete);
        int action = lockState ? 1 : 0;
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.updateCallBarring(this.getCBTypeFromFacility(facility), action, resp, null);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    @Override
    public void sendUssdResponse(String ussdMessge) {
        Rlog.d(LOG_TAG, "sendUssdResponse");
        ImsPhoneMmiCode mmi = ImsPhoneMmiCode.newFromUssdUserInput(ussdMessge, this);
        this.mPendingMMIs.add(mmi);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        mmi.sendUssd(ussdMessge);
    }

    public void sendUSSD(String ussdString, Message response) {
        this.mCT.sendUSSD(ussdString, response);
    }

    @Override
    public void cancelUSSD() {
        this.mCT.cancelUSSD();
    }

    private void sendErrorResponse(Message onComplete) {
        Rlog.d(LOG_TAG, "sendErrorResponse");
        if (onComplete != null) {
            AsyncResult.forMessage(onComplete, null, new CommandException(CommandException.Error.GENERIC_FAILURE));
            onComplete.sendToTarget();
        }
    }

    public void sendErrorResponse(Message onComplete, Throwable e) {
        Rlog.d(LOG_TAG, "sendErrorResponse");
        if (onComplete != null) {
            AsyncResult.forMessage(onComplete, null, this.getCommandException(e));
            onComplete.sendToTarget();
        }
    }

    private CommandException getCommandException(int code, String errorString) {
        Rlog.d(LOG_TAG, "getCommandException code= " + code + ", errorString= " + errorString);
        CommandException.Error error = CommandException.Error.GENERIC_FAILURE;
        switch (code) {
            case 801: {
                error = CommandException.Error.REQUEST_NOT_SUPPORTED;
                break;
            }
            case 821: {
                error = CommandException.Error.PASSWORD_INCORRECT;
                break;
            }
            case 802: {
                error = CommandException.Error.RADIO_NOT_AVAILABLE;
            }
        }
        return new CommandException(error, errorString);
    }

    private CommandException getCommandException(Throwable e) {
        CommandException ex = null;
        if (e instanceof ImsException) {
            ex = this.getCommandException(((ImsException)e).getCode(), e.getMessage());
        } else {
            Rlog.d(LOG_TAG, "getCommandException generic failure");
            ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
        }
        return ex;
    }

    private void onNetworkInitiatedUssd(ImsPhoneMmiCode mmi) {
        Rlog.d(LOG_TAG, "onNetworkInitiatedUssd");
        this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
    }

    void onIncomingUSSD(int ussdMode, String ussdMessage) {
        Rlog.d(LOG_TAG, "onIncomingUSSD ussdMode=" + ussdMode);
        boolean isUssdRequest = ussdMode == 1;
        boolean isUssdError = ussdMode != 0 && ussdMode != 1;
        ImsPhoneMmiCode found = null;
        int s = this.mPendingMMIs.size();
        for (int i = 0; i < s; ++i) {
            if (!this.mPendingMMIs.get(i).isPendingUSSD()) continue;
            found = this.mPendingMMIs.get(i);
            break;
        }
        if (found != null) {
            if (isUssdError) {
                found.onUssdFinishedError();
            } else {
                found.onUssdFinished(ussdMessage, isUssdRequest);
            }
        } else if (!isUssdError && ussdMessage != null) {
            ImsPhoneMmiCode mmi = ImsPhoneMmiCode.newNetworkInitiatedUssd(ussdMessage, isUssdRequest, this);
            this.onNetworkInitiatedUssd(mmi);
        }
    }

    public void onMMIDone(ImsPhoneMmiCode mmi) {
        Rlog.d(LOG_TAG, "onMMIDone: mmi=" + mmi);
        if (this.mPendingMMIs.remove(mmi) || mmi.isUssdRequest()) {
            ResultReceiver receiverCallback = mmi.getUssdCallbackReceiver();
            if (receiverCallback != null) {
                int returnCode = mmi.getState() == MmiCode.State.COMPLETE ? 100 : -1;
                this.sendUssdResponse(mmi.getDialString(), mmi.getMessage(), returnCode, receiverCallback);
            } else {
                Rlog.v(LOG_TAG, "onMMIDone: notifyRegistrants");
                this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            }
        }
    }

    @Override
    public ArrayList<Connection> getHandoverConnection() {
        ArrayList<Connection> connList = new ArrayList<Connection>();
        connList.addAll(this.getForegroundCall().mConnections);
        connList.addAll(this.getBackgroundCall().mConnections);
        connList.addAll(this.getRingingCall().mConnections);
        if (connList.size() > 0) {
            return connList;
        }
        return null;
    }

    @Override
    public void notifySrvccState(Call.SrvccState state) {
        this.mCT.notifySrvccState(state);
    }

    void initiateSilentRedial() {
        String result = this.mLastDialString;
        AsyncResult ar = new AsyncResult(null, result, null);
        if (ar != null) {
            this.mSilentRedialRegistrants.notifyRegistrants(ar);
        }
    }

    @Override
    public void registerForSilentRedial(Handler h, int what, Object obj) {
        this.mSilentRedialRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForSilentRedial(Handler h) {
        this.mSilentRedialRegistrants.remove(h);
    }

    @Override
    public void registerForSuppServiceNotification(Handler h, int what, Object obj) {
        this.mSsnRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler h) {
        this.mSsnRegistrants.remove(h);
    }

    @Override
    public int getSubId() {
        return this.mDefaultPhone.getSubId();
    }

    @Override
    public int getPhoneId() {
        return this.mDefaultPhone.getPhoneId();
    }

    private CallForwardInfo getCallForwardInfo(ImsCallForwardInfo info) {
        CallForwardInfo cfInfo = new CallForwardInfo();
        cfInfo.status = info.mStatus;
        cfInfo.reason = this.getCFReasonFromCondition(info.mCondition);
        cfInfo.serviceClass = 1;
        cfInfo.toa = info.mToA;
        cfInfo.number = info.mNumber;
        cfInfo.timeSeconds = info.mTimeSeconds;
        return cfInfo;
    }

    private CallForwardInfo[] handleCfQueryResult(ImsCallForwardInfo[] infos) {
        CallForwardInfo[] cfInfos = null;
        if (infos != null && infos.length != 0) {
            cfInfos = new CallForwardInfo[infos.length];
        }
        IccRecords r = this.mDefaultPhone.getIccRecords();
        if (infos == null || infos.length == 0) {
            if (r != null) {
                this.setVoiceCallForwardingFlag(r, 1, false, null);
            }
        } else {
            int s = infos.length;
            for (int i = 0; i < s; ++i) {
                if (infos[i].mCondition == 0 && r != null) {
                    this.setVoiceCallForwardingFlag(r, 1, infos[i].mStatus == 1, infos[i].mNumber);
                }
                cfInfos[i] = this.getCallForwardInfo(infos[i]);
            }
        }
        return cfInfos;
    }

    private int[] handleCbQueryResult(ImsSsInfo[] infos) {
        int[] cbInfos = new int[]{0};
        if (infos[0].mStatus == 1) {
            cbInfos[0] = 1;
        }
        return cbInfos;
    }

    private int[] handleCwQueryResult(ImsSsInfo[] infos) {
        int[] cwInfos = new int[2];
        cwInfos[0] = 0;
        if (infos[0].mStatus == 1) {
            cwInfos[0] = 1;
            cwInfos[1] = 1;
        }
        return cwInfos;
    }

    private void sendResponse(Message onComplete, Object result, Throwable e) {
        if (onComplete != null) {
            CommandException ex = null;
            if (e != null) {
                ex = this.getCommandException(e);
            }
            AsyncResult.forMessage(onComplete, result, ex);
            onComplete.sendToTarget();
        }
    }

    private void updateDataServiceState() {
        if (this.mSS != null && this.mDefaultPhone.getServiceStateTracker() != null && this.mDefaultPhone.getServiceStateTracker().mSS != null) {
            ServiceState ss = this.mDefaultPhone.getServiceStateTracker().mSS;
            this.mSS.setDataRegState(ss.getDataRegState());
            this.mSS.setRilDataRadioTechnology(ss.getRilDataRadioTechnology());
            Rlog.d(LOG_TAG, "updateDataServiceState: defSs = " + ss + " imsSs = " + this.mSS);
        }
    }

    @Override
    public void handleMessage(Message msg) {
        AsyncResult ar = (AsyncResult)msg.obj;
        Rlog.d(LOG_TAG, "handleMessage what=" + msg.what);
        switch (msg.what) {
            case 12: {
                IccRecords r = this.mDefaultPhone.getIccRecords();
                Cf cf = (Cf)ar.userObj;
                if (cf.mIsCfu && ar.exception == null && r != null) {
                    this.setVoiceCallForwardingFlag(r, 1, msg.arg1 == 1, cf.mSetCfNumber);
                }
                this.sendResponse(cf.mOnComplete, null, ar.exception);
                break;
            }
            case 13: {
                CallForwardInfo[] cfInfos = null;
                if (ar.exception == null) {
                    cfInfos = this.handleCfQueryResult((ImsCallForwardInfo[])ar.result);
                }
                this.sendResponse((Message)ar.userObj, cfInfos, ar.exception);
                break;
            }
            case 46: 
            case 48: {
                int[] ssInfos = null;
                if (ar.exception == null) {
                    if (msg.what == 46) {
                        ssInfos = this.handleCbQueryResult((ImsSsInfo[])ar.result);
                    } else if (msg.what == 48) {
                        ssInfos = this.handleCwQueryResult((ImsSsInfo[])ar.result);
                    }
                }
                this.sendResponse((Message)ar.userObj, ssInfos, ar.exception);
                break;
            }
            case 50: {
                Bundle ssInfo = (Bundle)ar.result;
                int[] clirInfo = null;
                if (ssInfo != null) {
                    clirInfo = ssInfo.getIntArray("queryClir");
                }
                this.sendResponse((Message)ar.userObj, clirInfo, ar.exception);
                break;
            }
            case 49: {
                if (ar.exception == null) {
                    this.saveClirSetting(msg.arg1);
                }
            }
            case 45: 
            case 47: {
                this.sendResponse((Message)ar.userObj, null, ar.exception);
                break;
            }
            case 51: {
                Rlog.d(LOG_TAG, "EVENT_DEFAULT_PHONE_DATA_STATE_CHANGED");
                this.updateDataServiceState();
                break;
            }
            case 52: {
                ar = (AsyncResult)msg.obj;
                ServiceState newServiceState = (ServiceState)ar.result;
                if (this.mRoaming == newServiceState.getRoaming()) break;
                Rlog.d(LOG_TAG, "Roaming state changed");
                this.updateRoamingState(newServiceState.getRoaming());
                break;
            }
            case 53: {
                Rlog.d(LOG_TAG, "Voice call ended. Handle pending updateRoamingState.");
                this.mCT.unregisterForVoiceCallEnded(this);
                boolean newRoaming = this.getCurrentRoaming();
                if (this.mRoaming == newRoaming) break;
                this.updateRoamingState(newRoaming);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    public ImsEcbmStateListener getImsEcbmStateListener() {
        return this.mImsEcbmStateListener;
    }

    @Override
    public boolean isInEmergencyCall() {
        return this.mCT.isInEmergencyCall();
    }

    private void sendEmergencyCallbackModeChange() {
        Intent intent = new Intent("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        intent.putExtra("phoneinECMState", this.isInEcm());
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.getPhoneId());
        ActivityManager.broadcastStickyIntent(intent, -1);
        Rlog.d(LOG_TAG, "sendEmergencyCallbackModeChange");
    }

    @Override
    public void exitEmergencyCallbackMode() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        Rlog.d(LOG_TAG, "exitEmergencyCallbackMode()");
        try {
            ImsEcbm ecbm = this.mCT.getEcbmInterface();
            ecbm.exitEmergencyCallbackMode();
        }
        catch (ImsException e) {
            e.printStackTrace();
        }
    }

    private void handleEnterEmergencyCallbackMode() {
        Rlog.d(LOG_TAG, "handleEnterEmergencyCallbackMode,mIsPhoneInEcmState= " + this.isInEcm());
        if (!this.isInEcm()) {
            this.setIsInEcm(true);
            this.sendEmergencyCallbackModeChange();
            long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
            this.postDelayed(this.mExitEcmRunnable, delayInMillis);
            this.mWakeLock.acquire();
        }
    }

    private void handleExitEmergencyCallbackMode() {
        Rlog.d(LOG_TAG, "handleExitEmergencyCallbackMode: mIsPhoneInEcmState = " + this.isInEcm());
        if (this.isInEcm()) {
            this.setIsInEcm(false);
        }
        this.removeCallbacks(this.mExitEcmRunnable);
        if (this.mEcmExitRespRegistrant != null) {
            this.mEcmExitRespRegistrant.notifyResult(Boolean.TRUE);
        }
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        this.sendEmergencyCallbackModeChange();
    }

    void handleTimerInEmergencyCallbackMode(int action) {
        switch (action) {
            case 1: {
                this.removeCallbacks(this.mExitEcmRunnable);
                ((GsmCdmaPhone)this.mDefaultPhone).notifyEcbmTimerReset(Boolean.TRUE);
                break;
            }
            case 0: {
                long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
                this.postDelayed(this.mExitEcmRunnable, delayInMillis);
                ((GsmCdmaPhone)this.mDefaultPhone).notifyEcbmTimerReset(Boolean.FALSE);
                break;
            }
            default: {
                Rlog.e(LOG_TAG, "handleTimerInEmergencyCallbackMode, unsupported action " + action);
            }
        }
    }

    @Override
    public void setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        this.mEcmExitRespRegistrant = new Registrant(h, what, obj);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler h) {
        this.mEcmExitRespRegistrant.clear();
    }

    public void onFeatureCapabilityChanged() {
        this.mDefaultPhone.getServiceStateTracker().onImsCapabilityChanged();
    }

    @Override
    public boolean isVolteEnabled() {
        return this.mCT.isVolteEnabled();
    }

    @Override
    public boolean isWifiCallingEnabled() {
        return this.mCT.isVowifiEnabled();
    }

    @Override
    public boolean isVideoEnabled() {
        return this.mCT.isVideoCallEnabled();
    }

    @Override
    public Phone getDefaultPhone() {
        return this.mDefaultPhone;
    }

    @Override
    public boolean isImsRegistered() {
        return this.mImsRegistered;
    }

    public void setImsRegistered(boolean value) {
        this.mImsRegistered = value;
    }

    @Override
    public void callEndCleanupHandOverCallIfAny() {
        this.mCT.callEndCleanupHandOverCallIfAny();
    }

    public void processDisconnectReason(ImsReasonInfo imsReasonInfo) {
        if (imsReasonInfo.mCode == 1000 && imsReasonInfo.mExtraMessage != null) {
            CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
            if (configManager == null) {
                Rlog.e(LOG_TAG, "processDisconnectReason: CarrierConfigManager is not ready");
                return;
            }
            PersistableBundle pb = configManager.getConfigForSubId(this.getSubId());
            if (pb == null) {
                Rlog.e(LOG_TAG, "processDisconnectReason: no config for subId " + this.getSubId());
                return;
            }
            String[] wfcOperatorErrorCodes = pb.getStringArray("wfc_operator_error_codes_string_array");
            if (wfcOperatorErrorCodes == null) {
                return;
            }
            String[] wfcOperatorErrorAlertMessages = this.mContext.getResources().getStringArray(17236064);
            String[] wfcOperatorErrorNotificationMessages = this.mContext.getResources().getStringArray(17236065);
            for (int i = 0; i < wfcOperatorErrorCodes.length; ++i) {
                char nextChar;
                int codeStringLength;
                char lastChar;
                String[] codes = wfcOperatorErrorCodes[i].split("\\|");
                if (codes.length != 2) {
                    Rlog.e(LOG_TAG, "Invalid carrier config: " + wfcOperatorErrorCodes[i]);
                    continue;
                }
                if (!imsReasonInfo.mExtraMessage.startsWith(codes[0]) || Character.isLetterOrDigit(lastChar = codes[0].charAt((codeStringLength = codes[0].length()) - 1)) && imsReasonInfo.mExtraMessage.length() > codeStringLength && Character.isLetterOrDigit(nextChar = imsReasonInfo.mExtraMessage.charAt(codeStringLength))) continue;
                CharSequence title = this.mContext.getText(17040956);
                int idx = Integer.parseInt(codes[1]);
                if (idx < 0 || idx >= wfcOperatorErrorAlertMessages.length || idx >= wfcOperatorErrorNotificationMessages.length) {
                    Rlog.e(LOG_TAG, "Invalid index: " + wfcOperatorErrorCodes[i]);
                    continue;
                }
                String messageAlert = imsReasonInfo.mExtraMessage;
                String messageNotification = imsReasonInfo.mExtraMessage;
                if (!wfcOperatorErrorAlertMessages[idx].isEmpty()) {
                    messageAlert = wfcOperatorErrorAlertMessages[idx];
                }
                if (!wfcOperatorErrorNotificationMessages[idx].isEmpty()) {
                    messageNotification = wfcOperatorErrorNotificationMessages[idx];
                }
                ImsManager.setWfcSetting(this.mContext, false);
                Intent intent = new Intent("com.android.ims.REGISTRATION_ERROR");
                intent.putExtra("alertTitle", title);
                intent.putExtra("alertMessage", (CharSequence)messageAlert);
                intent.putExtra("notificationMessage", (CharSequence)messageNotification);
                this.mContext.sendOrderedBroadcast(intent, null, this.mResultReceiver, null, -1, null, null);
                break;
            }
        }
    }

    @Override
    public boolean isUtEnabled() {
        return this.mCT.isUtEnabled();
    }

    @Override
    public void sendEmergencyCallStateChange(boolean callActive) {
        this.mDefaultPhone.sendEmergencyCallStateChange(callActive);
    }

    @Override
    public void setBroadcastEmergencyCallStateChanges(boolean broadcast) {
        this.mDefaultPhone.setBroadcastEmergencyCallStateChanges(broadcast);
    }

    public PowerManager.WakeLock getWakeLock() {
        return this.mWakeLock;
    }

    @Override
    public long getVtDataUsage() {
        return this.mCT.getVtDataUsage();
    }

    private void updateRoamingState(boolean newRoaming) {
        if (this.mCT.getState() == PhoneConstants.State.IDLE) {
            Rlog.d(LOG_TAG, "updateRoamingState now: " + newRoaming);
            this.mRoaming = newRoaming;
            ImsManager.setWfcMode(this.mContext, ImsManager.getWfcMode(this.mContext, newRoaming), newRoaming);
        } else {
            Rlog.d(LOG_TAG, "updateRoamingState postponed: " + newRoaming);
            this.mCT.registerForVoiceCallEnded(this, 53, null);
        }
    }

    private boolean getCurrentRoaming() {
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        return tm.isNetworkRoaming();
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ImsPhone extends:");
        super.dump(fd, pw, args);
        pw.flush();
        pw.println("ImsPhone:");
        pw.println("  mDefaultPhone = " + this.mDefaultPhone);
        pw.println("  mPendingMMIs = " + this.mPendingMMIs);
        pw.println("  mPostDialHandler = " + this.mPostDialHandler);
        pw.println("  mSS = " + this.mSS);
        pw.println("  mWakeLock = " + this.mWakeLock);
        pw.println("  mIsPhoneInEcmState = " + this.isInEcm());
        pw.println("  mEcmExitRespRegistrant = " + this.mEcmExitRespRegistrant);
        pw.println("  mSilentRedialRegistrants = " + this.mSilentRedialRegistrants);
        pw.println("  mImsRegistered = " + this.mImsRegistered);
        pw.println("  mRoaming = " + this.mRoaming);
        pw.println("  mSsnRegistrants = " + this.mSsnRegistrants);
        pw.flush();
    }

    private static class Cf {
        final String mSetCfNumber;
        final Message mOnComplete;
        final boolean mIsCfu;

        Cf(String cfNumber, boolean isCfu, Message onComplete) {
            this.mSetCfNumber = cfNumber;
            this.mIsCfu = isCfu;
            this.mOnComplete = onComplete;
        }
    }
}

