/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.Rlog;
import com.android.internal.telephony.uicc.IccUtils;
import java.util.Arrays;

public class PlmnActRecord
implements Parcelable {
    private static final String LOG_TAG = "PlmnActRecord";
    public static final int ACCESS_TECH_UTRAN = 32768;
    public static final int ACCESS_TECH_EUTRAN = 16384;
    public static final int ACCESS_TECH_GSM = 128;
    public static final int ACCESS_TECH_GSM_COMPACT = 64;
    public static final int ACCESS_TECH_CDMA2000_HRPD = 32;
    public static final int ACCESS_TECH_CDMA2000_1XRTT = 16;
    public static final int ACCESS_TECH_RESERVED = 16143;
    public static final int ENCODED_LENGTH = 5;
    public final String plmn;
    public final int accessTechs;
    private static final boolean VDBG = false;
    public static final Parcelable.Creator<PlmnActRecord> CREATOR = new Parcelable.Creator<PlmnActRecord>(){

        @Override
        public PlmnActRecord createFromParcel(Parcel source) {
            return new PlmnActRecord(source.readString(), source.readInt());
        }

        public PlmnActRecord[] newArray(int size) {
            return new PlmnActRecord[size];
        }
    };

    public PlmnActRecord(byte[] bytes, int offset) {
        this.plmn = IccUtils.bcdPlmnToString(bytes, offset);
        this.accessTechs = bytes[offset + 3] << 8 | bytes[offset + 4];
    }

    private PlmnActRecord(String plmn, int accessTechs) {
        this.plmn = plmn;
        this.accessTechs = accessTechs;
    }

    private String accessTechString() {
        if (this.accessTechs == 0) {
            return "NONE";
        }
        StringBuilder sb = new StringBuilder();
        if ((this.accessTechs & 0x8000) != 0) {
            sb.append("UTRAN|");
        }
        if ((this.accessTechs & 0x4000) != 0) {
            sb.append("EUTRAN|");
        }
        if ((this.accessTechs & 0x80) != 0) {
            sb.append("GSM|");
        }
        if ((this.accessTechs & 0x40) != 0) {
            sb.append("GSM_COMPACT|");
        }
        if ((this.accessTechs & 0x20) != 0) {
            sb.append("CDMA2000_HRPD|");
        }
        if ((this.accessTechs & 0x10) != 0) {
            sb.append("CDMA2000_1XRTT|");
        }
        if ((this.accessTechs & 0x3F0F) != 0) {
            sb.append(String.format("UNKNOWN:%x|", this.accessTechs & 0x3F0F));
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String toString() {
        return String.format("{PLMN=%s,AccessTechs=%s}", this.plmn, this.accessTechString());
    }

    public static PlmnActRecord[] getRecords(byte[] recordBytes) {
        if (recordBytes == null || recordBytes.length == 0 || recordBytes.length % 5 != 0) {
            Rlog.e(LOG_TAG, "Malformed PlmnActRecord, bytes: " + (recordBytes != null ? Arrays.toString(recordBytes) : null));
            return null;
        }
        int numRecords = recordBytes.length / 5;
        PlmnActRecord[] records = new PlmnActRecord[numRecords];
        for (int i = 0; i < numRecords; ++i) {
            records[i] = new PlmnActRecord(recordBytes, i * 5);
        }
        return records;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.plmn);
        dest.writeInt(this.accessTechs);
    }
}

