/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.UUID;
import libcore.util.Objects;

public class BitUtils {
    private BitUtils() {
    }

    public static boolean maskedEquals(long a, long b, long mask) {
        return (a & mask) == (b & mask);
    }

    public static boolean maskedEquals(byte a, byte b, byte mask) {
        return (a & mask) == (b & mask);
    }

    public static boolean maskedEquals(byte[] a, byte[] b, byte[] mask) {
        if (a == null || b == null) {
            return a == b;
        }
        Preconditions.checkArgument(a.length == b.length, "Inputs must be of same size");
        if (mask == null) {
            return Arrays.equals(a, b);
        }
        Preconditions.checkArgument(a.length == mask.length, "Mask must be of same size as inputs");
        for (int i = 0; i < mask.length; ++i) {
            if (BitUtils.maskedEquals(a[i], b[i], mask[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean maskedEquals(UUID a, UUID b, UUID mask) {
        if (mask == null) {
            return Objects.equal(a, b);
        }
        return BitUtils.maskedEquals(a.getLeastSignificantBits(), b.getLeastSignificantBits(), mask.getLeastSignificantBits()) && BitUtils.maskedEquals(a.getMostSignificantBits(), b.getMostSignificantBits(), mask.getMostSignificantBits());
    }

    public static int[] unpackBits(long val) {
        int size = Long.bitCount(val);
        int[] result = new int[size];
        int index = 0;
        int bitPos = 0;
        while (val > 0L) {
            if ((val & 1L) == 1L) {
                result[index++] = bitPos;
            }
            val >>= 1;
            ++bitPos;
        }
        return result;
    }

    public static long packBits(int[] bits) {
        long packed = 0L;
        for (int b : bits) {
            packed |= (long)(1 << b);
        }
        return packed;
    }
}

