/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.ContextThemeWrapper;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.menu.BaseMenuPresenter;
import com.android.internal.view.menu.IconMenuItemView;
import com.android.internal.view.menu.IconMenuView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuDialogHelper;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.util.ArrayList;

public class IconMenuPresenter
extends BaseMenuPresenter {
    private IconMenuItemView mMoreView;
    private int mMaxItems = -1;
    int mOpenSubMenuId;
    SubMenuPresenterCallback mSubMenuPresenterCallback = new SubMenuPresenterCallback();
    MenuDialogHelper mOpenSubMenu;
    private static final String VIEWS_TAG = "android:menu:icon";
    private static final String OPEN_SUBMENU_KEY = "android:menu:icon:submenu";

    public IconMenuPresenter(Context context) {
        super(new ContextThemeWrapper(context, 16974816), 17367147, 17367146);
    }

    @Override
    public void initForMenu(Context context, MenuBuilder menu2) {
        super.initForMenu(context, menu2);
        this.mMaxItems = -1;
    }

    @Override
    public void bindItemView(MenuItemImpl item, MenuView.ItemView itemView) {
        IconMenuItemView view = (IconMenuItemView)itemView;
        view.setItemData(item);
        view.initialize(item.getTitleForItemView(view), item.getIcon());
        view.setVisibility(item.isVisible() ? 0 : 8);
        view.setEnabled(view.isEnabled());
        view.setLayoutParams(view.getTextAppropriateLayoutParams());
    }

    @Override
    public boolean shouldIncludeItem(int childIndex, MenuItemImpl item) {
        ArrayList<MenuItemImpl> itemsToShow = this.mMenu.getNonActionItems();
        boolean fits = itemsToShow.size() == this.mMaxItems && childIndex < this.mMaxItems || childIndex < this.mMaxItems - 1;
        return fits && !item.isActionButton();
    }

    @Override
    protected void addItemView(View itemView, int childIndex) {
        IconMenuItemView v = (IconMenuItemView)itemView;
        IconMenuView parent = (IconMenuView)this.mMenuView;
        v.setIconMenuView(parent);
        v.setItemInvoker(parent);
        v.setBackgroundDrawable(parent.getItemBackgroundDrawable());
        super.addItemView(itemView, childIndex);
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenu) {
        if (!subMenu.hasVisibleItems()) {
            return false;
        }
        MenuDialogHelper helper = new MenuDialogHelper(subMenu);
        helper.setPresenterCallback(this.mSubMenuPresenterCallback);
        helper.show(null);
        this.mOpenSubMenu = helper;
        this.mOpenSubMenuId = subMenu.getItem().getItemId();
        super.onSubMenuSelected(subMenu);
        return true;
    }

    @Override
    public void updateMenuView(boolean cleared) {
        ArrayList<MenuItemImpl> itemsToShow;
        IconMenuView menuView = (IconMenuView)this.mMenuView;
        if (this.mMaxItems < 0) {
            this.mMaxItems = menuView.getMaxItems();
        }
        boolean needsMore = (itemsToShow = this.mMenu.getNonActionItems()).size() > this.mMaxItems;
        super.updateMenuView(cleared);
        if (needsMore && (this.mMoreView == null || this.mMoreView.getParent() != menuView)) {
            if (this.mMoreView == null) {
                this.mMoreView = menuView.createMoreItemView();
                this.mMoreView.setBackgroundDrawable(menuView.getItemBackgroundDrawable());
            }
            menuView.addView(this.mMoreView);
        } else if (!needsMore && this.mMoreView != null) {
            menuView.removeView(this.mMoreView);
        }
        menuView.setNumActualItemsShown(needsMore ? this.mMaxItems - 1 : itemsToShow.size());
    }

    @Override
    protected boolean filterLeftoverView(ViewGroup parent, int childIndex) {
        if (parent.getChildAt(childIndex) != this.mMoreView) {
            return super.filterLeftoverView(parent, childIndex);
        }
        return false;
    }

    public int getNumActualItemsShown() {
        return ((IconMenuView)this.mMenuView).getNumActualItemsShown();
    }

    public void saveHierarchyState(Bundle outState) {
        SparseArray<Parcelable> viewStates = new SparseArray<Parcelable>();
        if (this.mMenuView != null) {
            ((View)((Object)this.mMenuView)).saveHierarchyState(viewStates);
        }
        outState.putSparseParcelableArray(VIEWS_TAG, viewStates);
    }

    public void restoreHierarchyState(Bundle inState) {
        MenuItem item;
        int subMenuId;
        SparseArray<Parcelable> viewStates = inState.getSparseParcelableArray(VIEWS_TAG);
        if (viewStates != null) {
            ((View)((Object)this.mMenuView)).restoreHierarchyState(viewStates);
        }
        if ((subMenuId = inState.getInt(OPEN_SUBMENU_KEY, 0)) > 0 && this.mMenu != null && (item = this.mMenu.findItem(subMenuId)) != null) {
            this.onSubMenuSelected((SubMenuBuilder)item.getSubMenu());
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        if (this.mMenuView == null) {
            return null;
        }
        Bundle state = new Bundle();
        this.saveHierarchyState(state);
        if (this.mOpenSubMenuId > 0) {
            state.putInt(OPEN_SUBMENU_KEY, this.mOpenSubMenuId);
        }
        return state;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        this.restoreHierarchyState((Bundle)state);
    }

    class SubMenuPresenterCallback
    implements MenuPresenter.Callback {
        SubMenuPresenterCallback() {
        }

        @Override
        public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            IconMenuPresenter.this.mOpenSubMenuId = 0;
            if (IconMenuPresenter.this.mOpenSubMenu != null) {
                IconMenuPresenter.this.mOpenSubMenu.dismiss();
                IconMenuPresenter.this.mOpenSubMenu = null;
            }
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            if (subMenu != null) {
                IconMenuPresenter.this.mOpenSubMenuId = ((SubMenuBuilder)subMenu).getItem().getItemId();
            }
            return false;
        }
    }
}

