/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RemoteViews;

@RemoteViews.RemoteView
public class MediaNotificationView
extends FrameLayout {
    private final int mSmallImageSize;
    private final int mNotificationContentMarginEnd;
    private final int mNotificationContentImageMarginEnd;
    private ImageView mRightIcon;
    private View mActions;
    private View mHeader;
    private View mMainColumn;

    public MediaNotificationView(Context context) {
        this(context, null);
    }

    public MediaNotificationView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaNotificationView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean hasIcon;
        boolean bl = hasIcon = this.mRightIcon.getVisibility() != 8;
        if (!hasIcon) {
            this.resetHeaderIndention();
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int mode = View.MeasureSpec.getMode(widthMeasureSpec);
        boolean reMeasure = false;
        if (hasIcon && mode != 0) {
            ViewGroup.MarginLayoutParams params;
            int marginEnd;
            int fullHeight;
            int size = View.MeasureSpec.getSize(widthMeasureSpec);
            size -= this.mActions.getMeasuredWidth();
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mRightIcon.getLayoutParams();
            int imageEndMargin = layoutParams.getMarginEnd();
            if (layoutParams.width != (size = (size -= imageEndMargin) < (fullHeight = this.getMeasuredHeight()) ? this.mSmallImageSize : fullHeight) || layoutParams.height != size) {
                layoutParams.width = size;
                layoutParams.height = size;
                this.mRightIcon.setLayoutParams(layoutParams);
                reMeasure = true;
            }
            if ((marginEnd = size + imageEndMargin + this.mNotificationContentMarginEnd) != (params = (ViewGroup.MarginLayoutParams)this.mMainColumn.getLayoutParams()).getMarginEnd()) {
                params.setMarginEnd(marginEnd);
                this.mMainColumn.setLayoutParams(params);
                reMeasure = true;
            }
            int headerMarginEnd = size + imageEndMargin;
            params = (ViewGroup.MarginLayoutParams)this.mHeader.getLayoutParams();
            if (params.getMarginEnd() != headerMarginEnd) {
                params.setMarginEnd(headerMarginEnd);
                this.mHeader.setLayoutParams(params);
                reMeasure = true;
            }
            if (this.mHeader.getPaddingEnd() != this.mNotificationContentImageMarginEnd) {
                this.mHeader.setPaddingRelative(this.mHeader.getPaddingStart(), this.mHeader.getPaddingTop(), this.mNotificationContentImageMarginEnd, this.mHeader.getPaddingBottom());
                reMeasure = true;
            }
        }
        if (reMeasure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void resetHeaderIndention() {
        if (this.mHeader.getPaddingEnd() != this.mNotificationContentMarginEnd) {
            this.mHeader.setPaddingRelative(this.mHeader.getPaddingStart(), this.mHeader.getPaddingTop(), this.mNotificationContentMarginEnd, this.mHeader.getPaddingBottom());
        }
        ViewGroup.MarginLayoutParams headerParams = (ViewGroup.MarginLayoutParams)this.mHeader.getLayoutParams();
        headerParams.setMarginEnd(0);
        if (headerParams.getMarginEnd() != 0) {
            headerParams.setMarginEnd(0);
            this.mHeader.setLayoutParams(headerParams);
        }
    }

    public MediaNotificationView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mSmallImageSize = context.getResources().getDimensionPixelSize(17105133);
        this.mNotificationContentMarginEnd = context.getResources().getDimensionPixelSize(17105146);
        this.mNotificationContentImageMarginEnd = context.getResources().getDimensionPixelSize(17105144);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mRightIcon = (ImageView)this.findViewById(16909204);
        this.mActions = this.findViewById(16909034);
        this.mHeader = this.findViewById(16909092);
        this.mMainColumn = this.findViewById(16909093);
    }
}

