/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Comparator;

@RemoteViews.RemoteView
public class NotificationActionListLayout
extends LinearLayout {
    private int mTotalWidth = 0;
    private ArrayList<Pair<Integer, TextView>> mMeasureOrderTextViews = new ArrayList();
    private ArrayList<View> mMeasureOrderOther = new ArrayList();
    private boolean mMeasureLinearly;
    private int mDefaultPaddingEnd;
    private Drawable mDefaultBackground;
    public static final Comparator<Pair<Integer, TextView>> MEASURE_ORDER_COMPARATOR = (a, b) -> ((Integer)a.first).compareTo((Integer)b.first);

    public NotificationActionListLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mMeasureLinearly) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int N = this.getChildCount();
        int textViews = 0;
        int otherViews = 0;
        int notGoneChildren = 0;
        View lastNotGoneChild = null;
        for (int i = 0; i < N; ++i) {
            View c = this.getChildAt(i);
            if (c instanceof TextView) {
                ++textViews;
            } else {
                ++otherViews;
            }
            if (c.getVisibility() == 8) continue;
            ++notGoneChildren;
            lastNotGoneChild = c;
        }
        boolean needRebuild = false;
        if (textViews != this.mMeasureOrderTextViews.size() || otherViews != this.mMeasureOrderOther.size()) {
            needRebuild = true;
        }
        if (!needRebuild) {
            int size = this.mMeasureOrderTextViews.size();
            for (int i = 0; i < size; ++i) {
                Pair<Integer, TextView> pair = this.mMeasureOrderTextViews.get(i);
                if (((Integer)pair.first).intValue() == ((TextView)pair.second).getText().length()) continue;
                needRebuild = true;
            }
        }
        if (notGoneChildren > 1 && needRebuild) {
            this.rebuildMeasureOrder(textViews, otherViews);
        }
        boolean constrained = View.MeasureSpec.getMode(widthMeasureSpec) != 0;
        int innerWidth = View.MeasureSpec.getSize(widthMeasureSpec) - this.mPaddingLeft - this.mPaddingRight;
        int otherSize = this.mMeasureOrderOther.size();
        int usedWidth = 0;
        int measuredChildren = 0;
        for (int i = 0; i < N && notGoneChildren > 1; ++i) {
            View c = i < otherSize ? this.mMeasureOrderOther.get(i) : (View)this.mMeasureOrderTextViews.get((int)(i - otherSize)).second;
            if (c.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)c.getLayoutParams();
            int usedWidthForChild = usedWidth;
            if (constrained) {
                int availableWidth = innerWidth - usedWidth;
                int maxWidthForChild = availableWidth / (notGoneChildren - measuredChildren);
                usedWidthForChild = innerWidth - maxWidthForChild;
            }
            this.measureChildWithMargins(c, widthMeasureSpec, usedWidthForChild, heightMeasureSpec, 0);
            usedWidth += c.getMeasuredWidth() + lp.rightMargin + lp.leftMargin;
            ++measuredChildren;
        }
        if (lastNotGoneChild != null && (constrained && usedWidth < innerWidth || notGoneChildren == 1)) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)lastNotGoneChild.getLayoutParams();
            if (notGoneChildren > 1) {
                usedWidth -= lastNotGoneChild.getMeasuredWidth() + lp.rightMargin + lp.leftMargin;
            }
            int originalWidth = lp.width;
            lp.width = -1;
            this.measureChildWithMargins(lastNotGoneChild, widthMeasureSpec, usedWidth, heightMeasureSpec, 0);
            lp.width = originalWidth;
            usedWidth += lastNotGoneChild.getMeasuredWidth() + lp.rightMargin + lp.leftMargin;
        }
        this.mTotalWidth = usedWidth + this.mPaddingRight + this.mPaddingLeft;
        this.setMeasuredDimension(NotificationActionListLayout.resolveSize(this.getSuggestedMinimumWidth(), widthMeasureSpec), NotificationActionListLayout.resolveSize(this.getSuggestedMinimumHeight(), heightMeasureSpec));
    }

    private void rebuildMeasureOrder(int capacityText, int capacityOther) {
        this.clearMeasureOrder();
        this.mMeasureOrderTextViews.ensureCapacity(capacityText);
        this.mMeasureOrderOther.ensureCapacity(capacityOther);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View c = this.getChildAt(i);
            if (c instanceof TextView && ((TextView)c).getText().length() > 0) {
                this.mMeasureOrderTextViews.add(Pair.create(((TextView)c).getText().length(), (TextView)c));
                continue;
            }
            this.mMeasureOrderOther.add(c);
        }
        this.mMeasureOrderTextViews.sort(MEASURE_ORDER_COMPARATOR);
    }

    private void clearMeasureOrder() {
        this.mMeasureOrderOther.clear();
        this.mMeasureOrderTextViews.clear();
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.clearMeasureOrder();
    }

    @Override
    public void onViewRemoved(View child) {
        super.onViewRemoved(child);
        this.clearMeasureOrder();
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int childLeft;
        if (this.mMeasureLinearly) {
            super.onLayout(changed, left, top, right, bottom);
            return;
        }
        boolean isLayoutRtl = this.isLayoutRtl();
        int paddingTop = this.mPaddingTop;
        int height = bottom - top;
        int innerHeight = height - paddingTop - this.mPaddingBottom;
        int count = this.getChildCount();
        int layoutDirection = this.getLayoutDirection();
        switch (Gravity.getAbsoluteGravity(0x800003, layoutDirection)) {
            case 5: {
                childLeft = this.mPaddingLeft + right - left - this.mTotalWidth;
                break;
            }
            default: {
                childLeft = this.mPaddingLeft;
            }
        }
        int start = 0;
        int dir = 1;
        if (isLayoutRtl) {
            start = count - 1;
            dir = -1;
        }
        for (int i = 0; i < count; ++i) {
            int childIndex = start + dir * i;
            View child = this.getChildAt(childIndex);
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childTop = paddingTop + (innerHeight - childHeight) / 2 + lp.topMargin - lp.bottomMargin;
            child.layout(childLeft += lp.leftMargin, childTop, childLeft + childWidth, childTop + childHeight);
            childLeft += childWidth + lp.rightMargin;
        }
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mDefaultPaddingEnd = this.getPaddingEnd();
        this.mDefaultBackground = this.getBackground();
    }

    @RemotableViewMethod
    public void setEmphasizedMode(boolean emphasizedMode) {
        this.mMeasureLinearly = emphasizedMode;
        this.setPaddingRelative(this.getPaddingStart(), this.getPaddingTop(), emphasizedMode ? 0 : this.mDefaultPaddingEnd, this.getPaddingBottom());
        this.setBackground(emphasizedMode ? null : this.mDefaultBackground);
        this.requestLayout();
    }
}

