/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.hardware.ISerialManager;
import android.os.ParcelFileDescriptor;
import java.io.File;
import java.util.ArrayList;

public class SerialService
extends ISerialManager.Stub {
    private final Context mContext;
    private final String[] mSerialPorts;

    public SerialService(Context context) {
        this.mContext = context;
        this.mSerialPorts = context.getResources().getStringArray(17236026);
    }

    @Override
    public String[] getSerialPorts() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SERIAL_PORT", null);
        ArrayList<String> ports = new ArrayList<String>();
        for (int i = 0; i < this.mSerialPorts.length; ++i) {
            String path = this.mSerialPorts[i];
            if (!new File(path).exists()) continue;
            ports.add(path);
        }
        String[] result = new String[ports.size()];
        ports.toArray(result);
        return result;
    }

    @Override
    public ParcelFileDescriptor openSerialPort(String path) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SERIAL_PORT", null);
        for (int i = 0; i < this.mSerialPorts.length; ++i) {
            if (!this.mSerialPorts[i].equals(path)) continue;
            return this.native_open(path);
        }
        throw new IllegalArgumentException("Invalid serial port " + path);
    }

    private native ParcelFileDescriptor native_open(String var1);
}

