/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.os.Build;
import android.util.Slog;
import com.android.internal.util.ConcurrentUtils;
import com.android.internal.util.Preconditions;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class SystemServerInitThreadPool {
    private static final String TAG = SystemServerInitThreadPool.class.getSimpleName();
    private static final int SHUTDOWN_TIMEOUT_MILLIS = 20000;
    private static final boolean IS_DEBUGGABLE = Build.IS_DEBUGGABLE;
    private static SystemServerInitThreadPool sInstance;
    private ExecutorService mService = ConcurrentUtils.newFixedThreadPool(4, "system-server-init-thread", -2);

    public static synchronized SystemServerInitThreadPool get() {
        if (sInstance == null) {
            sInstance = new SystemServerInitThreadPool();
        }
        Preconditions.checkState(SystemServerInitThreadPool.sInstance.mService != null, "Cannot get " + TAG + " - it has been shut down");
        return sInstance;
    }

    public Future<?> submit(Runnable runnable, String description) {
        if (IS_DEBUGGABLE) {
            return this.mService.submit(() -> {
                Slog.d(TAG, "Started executing " + description);
                try {
                    runnable.run();
                }
                catch (RuntimeException e) {
                    Slog.e(TAG, "Failure in " + description + ": " + e, e);
                    throw e;
                }
                Slog.d(TAG, "Finished executing " + description);
            });
        }
        return this.mService.submit(runnable);
    }

    static synchronized void shutdown() {
        if (sInstance != null && SystemServerInitThreadPool.sInstance.mService != null) {
            boolean terminated;
            SystemServerInitThreadPool.sInstance.mService.shutdown();
            try {
                terminated = SystemServerInitThreadPool.sInstance.mService.awaitTermination(20000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(TAG + " init interrupted");
            }
            List<Runnable> unstartedRunnables = SystemServerInitThreadPool.sInstance.mService.shutdownNow();
            if (!terminated) {
                throw new IllegalStateException("Cannot shutdown. Unstarted tasks " + unstartedRunnables);
            }
            SystemServerInitThreadPool.sInstance.mService = null;
            Slog.d(TAG, "Shutdown successful");
        }
    }
}

