/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SpellCheckerSubtype;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.inputmethod.InputMethodUtils;
import com.android.internal.textservice.ISpellCheckerService;
import com.android.internal.textservice.ISpellCheckerServiceCallback;
import com.android.internal.textservice.ISpellCheckerSession;
import com.android.internal.textservice.ISpellCheckerSessionListener;
import com.android.internal.textservice.ITextServicesManager;
import com.android.internal.textservice.ITextServicesSessionListener;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemService;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class TextServicesManagerService
extends ITextServicesManager.Stub {
    private static final String TAG = TextServicesManagerService.class.getSimpleName();
    private static final boolean DBG = false;
    private final Context mContext;
    private boolean mSystemReady = false;
    private final TextServicesMonitor mMonitor;
    private final HashMap<String, SpellCheckerInfo> mSpellCheckerMap = new HashMap();
    private final ArrayList<SpellCheckerInfo> mSpellCheckerList = new ArrayList();
    private final HashMap<String, SpellCheckerBindGroup> mSpellCheckerBindGroups = new HashMap();
    private final TextServicesSettings mSettings;
    private final UserManager mUserManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemRunning() {
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            if (!this.mSystemReady) {
                this.mSystemReady = true;
                this.resetInternalState(this.mSettings.getCurrentUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSwitchUser(int userId) {
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            this.resetInternalState(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUnlockUser(int userId) {
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            int currentUserId = this.mSettings.getCurrentUserId();
            if (userId != currentUserId) {
                return;
            }
            this.resetInternalState(currentUserId);
        }
    }

    public TextServicesManagerService(Context context) {
        this.mContext = context;
        this.mUserManager = this.mContext.getSystemService(UserManager.class);
        IntentFilter broadcastFilter = new IntentFilter();
        broadcastFilter.addAction("android.intent.action.USER_ADDED");
        broadcastFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(new TextServicesBroadcastReceiver(), broadcastFilter);
        int userId = 0;
        try {
            userId = ActivityManager.getService().getCurrentUser().id;
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Couldn't get current user ID; guessing it's 0", e);
        }
        this.mMonitor = new TextServicesMonitor();
        this.mMonitor.register(context, null, true);
        boolean useCopyOnWriteSettings = !this.mSystemReady || !this.mUserManager.isUserUnlockingOrUnlocked(userId);
        this.mSettings = new TextServicesSettings(context.getContentResolver(), userId, useCopyOnWriteSettings);
        this.resetInternalState(userId);
    }

    private void resetInternalState(int userId) {
        boolean useCopyOnWriteSettings = !this.mSystemReady || !this.mUserManager.isUserUnlockingOrUnlocked(userId);
        this.mSettings.switchCurrentUser(userId, useCopyOnWriteSettings);
        this.updateCurrentProfileIds();
        this.unbindServiceLocked();
        TextServicesManagerService.buildSpellCheckerMapLocked(this.mContext, this.mSpellCheckerList, this.mSpellCheckerMap, this.mSettings);
        SpellCheckerInfo sci = this.getCurrentSpellChecker(null);
        if (sci == null && (sci = this.findAvailSpellCheckerLocked(null)) != null) {
            this.setCurrentSpellCheckerLocked(sci.getId());
        }
    }

    void updateCurrentProfileIds() {
        this.mSettings.setCurrentProfileIds(this.mUserManager.getProfileIdsWithDisabled(this.mSettings.getCurrentUserId()));
    }

    private static void buildSpellCheckerMapLocked(Context context, ArrayList<SpellCheckerInfo> list, HashMap<String, SpellCheckerInfo> map, TextServicesSettings settings) {
        list.clear();
        map.clear();
        PackageManager pm = context.getPackageManager();
        List<ResolveInfo> services = pm.queryIntentServicesAsUser(new Intent("android.service.textservice.SpellCheckerService"), 128, settings.getCurrentUserId());
        int N = services.size();
        for (int i = 0; i < N; ++i) {
            ResolveInfo ri = services.get(i);
            ServiceInfo si = ri.serviceInfo;
            ComponentName compName = new ComponentName(si.packageName, si.name);
            if (!"android.permission.BIND_TEXT_SERVICE".equals(si.permission)) {
                Slog.w(TAG, "Skipping text service " + compName + ": it does not require the permission " + "android.permission.BIND_TEXT_SERVICE");
                continue;
            }
            try {
                SpellCheckerInfo sci = new SpellCheckerInfo(context, ri);
                if (sci.getSubtypeCount() <= 0) {
                    Slog.w(TAG, "Skipping text service " + compName + ": it does not contain subtypes.");
                    continue;
                }
                list.add(sci);
                map.put(sci.getId(), sci);
                continue;
            }
            catch (XmlPullParserException e) {
                Slog.w(TAG, "Unable to load the spell checker " + compName, e);
                continue;
            }
            catch (IOException e) {
                Slog.w(TAG, "Unable to load the spell checker " + compName, e);
            }
        }
    }

    private boolean calledFromValidUser() {
        SpellCheckerInfo spellCheckerInfo;
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getUserId(uid);
        if (uid == 1000 || userId == this.mSettings.getCurrentUserId()) {
            return true;
        }
        boolean isCurrentProfile = this.mSettings.isCurrentProfile(userId);
        if (this.mSettings.isCurrentProfile(userId) && (spellCheckerInfo = this.getCurrentSpellCheckerWithoutVerification()) != null) {
            boolean isSystemSpellChecker;
            ServiceInfo serviceInfo = spellCheckerInfo.getServiceInfo();
            boolean bl = isSystemSpellChecker = (serviceInfo.applicationInfo.flags & 1) != 0;
            if (isSystemSpellChecker) {
                return true;
            }
        }
        return false;
    }

    private boolean bindCurrentSpellCheckerService(Intent service, ServiceConnection conn, int flags) {
        if (service == null || conn == null) {
            Slog.e(TAG, "--- bind failed: service = " + service + ", conn = " + conn);
            return false;
        }
        return this.mContext.bindServiceAsUser(service, conn, flags, new UserHandle(this.mSettings.getCurrentUserId()));
    }

    private void unbindServiceLocked() {
        for (SpellCheckerBindGroup scbg : this.mSpellCheckerBindGroups.values()) {
            scbg.removeAll();
        }
        this.mSpellCheckerBindGroups.clear();
    }

    private SpellCheckerInfo findAvailSpellCheckerLocked(String prefPackage) {
        int spellCheckersCount = this.mSpellCheckerList.size();
        if (spellCheckersCount == 0) {
            Slog.w(TAG, "no available spell checker services found");
            return null;
        }
        if (prefPackage != null) {
            for (int i = 0; i < spellCheckersCount; ++i) {
                SpellCheckerInfo sci = this.mSpellCheckerList.get(i);
                if (!prefPackage.equals(sci.getPackageName())) continue;
                return sci;
            }
        }
        Locale systemLocal = this.mContext.getResources().getConfiguration().locale;
        ArrayList<Locale> suitableLocales = InputMethodUtils.getSuitableLocalesForSpellChecker(systemLocal);
        int localeCount = suitableLocales.size();
        for (int localeIndex = 0; localeIndex < localeCount; ++localeIndex) {
            Locale locale = suitableLocales.get(localeIndex);
            for (int spellCheckersIndex = 0; spellCheckersIndex < spellCheckersCount; ++spellCheckersIndex) {
                SpellCheckerInfo info = this.mSpellCheckerList.get(spellCheckersIndex);
                int subtypeCount = info.getSubtypeCount();
                for (int subtypeIndex = 0; subtypeIndex < subtypeCount; ++subtypeIndex) {
                    SpellCheckerSubtype subtype = info.getSubtypeAt(subtypeIndex);
                    Locale subtypeLocale = InputMethodUtils.constructLocaleFromString(subtype.getLocale());
                    if (!locale.equals(subtypeLocale)) continue;
                    return info;
                }
            }
        }
        if (spellCheckersCount > 1) {
            Slog.w(TAG, "more than one spell checker service found, picking first");
        }
        return this.mSpellCheckerList.get(0);
    }

    @Override
    public SpellCheckerInfo getCurrentSpellChecker(String locale) {
        if (!this.calledFromValidUser()) {
            return null;
        }
        return this.getCurrentSpellCheckerWithoutVerification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpellCheckerInfo getCurrentSpellCheckerWithoutVerification() {
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            String curSpellCheckerId = this.mSettings.getSelectedSpellChecker();
            if (TextUtils.isEmpty(curSpellCheckerId)) {
                return null;
            }
            return this.mSpellCheckerMap.get(curSpellCheckerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpellCheckerSubtype getCurrentSpellCheckerSubtype(String locale, boolean allowImplicitlySelectedSubtype) {
        Locale systemLocale;
        SpellCheckerInfo sci;
        int subtypeHashCode;
        if (!this.calledFromValidUser()) {
            return null;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            subtypeHashCode = this.mSettings.getSelectedSpellCheckerSubtype(0);
            sci = this.getCurrentSpellChecker(null);
            systemLocale = this.mContext.getResources().getConfiguration().locale;
        }
        if (sci == null || sci.getSubtypeCount() == 0) {
            return null;
        }
        if (subtypeHashCode == 0 && !allowImplicitlySelectedSubtype) {
            return null;
        }
        String candidateLocale = null;
        if (subtypeHashCode == 0) {
            String localeString;
            InputMethodSubtype currentInputMethodSubtype;
            InputMethodManager imm = this.mContext.getSystemService(InputMethodManager.class);
            if (imm != null && (currentInputMethodSubtype = imm.getCurrentInputMethodSubtype()) != null && !TextUtils.isEmpty(localeString = currentInputMethodSubtype.getLocale())) {
                candidateLocale = localeString;
            }
            if (candidateLocale == null) {
                candidateLocale = systemLocale.toString();
            }
        }
        SpellCheckerSubtype candidate = null;
        for (int i = 0; i < sci.getSubtypeCount(); ++i) {
            SpellCheckerSubtype scs = sci.getSubtypeAt(i);
            if (subtypeHashCode == 0) {
                String scsLocale = scs.getLocale();
                if (candidateLocale.equals(scsLocale)) {
                    return scs;
                }
                if (candidate != null || candidateLocale.length() < 2 || scsLocale.length() < 2 || !candidateLocale.startsWith(scsLocale)) continue;
                candidate = scs;
                continue;
            }
            if (scs.hashCode() != subtypeHashCode) continue;
            return scs;
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSpellCheckerService(String sciId, String locale, ITextServicesSessionListener tsListener, ISpellCheckerSessionListener scListener, Bundle bundle) {
        if (!this.calledFromValidUser()) {
            return;
        }
        if (!this.mSystemReady) {
            return;
        }
        if (TextUtils.isEmpty(sciId) || tsListener == null || scListener == null) {
            Slog.e(TAG, "getSpellCheckerService: Invalid input.");
            return;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            if (!this.mSpellCheckerMap.containsKey(sciId)) {
                return;
            }
            SpellCheckerInfo sci = this.mSpellCheckerMap.get(sciId);
            SpellCheckerBindGroup bindGroup = this.mSpellCheckerBindGroups.get(sciId);
            int uid = Binder.getCallingUid();
            if (bindGroup == null) {
                long ident = Binder.clearCallingIdentity();
                try {
                    bindGroup = this.startSpellCheckerServiceInnerLocked(sci);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
                if (bindGroup == null) {
                    return;
                }
            }
            bindGroup.getISpellCheckerSessionOrQueueLocked(new SessionRequest(uid, locale, tsListener, scListener, bundle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSpellCheckerEnabled() {
        if (!this.calledFromValidUser()) {
            return false;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            return this.isSpellCheckerEnabledLocked();
        }
    }

    private SpellCheckerBindGroup startSpellCheckerServiceInnerLocked(SpellCheckerInfo info) {
        String sciId = info.getId();
        InternalServiceConnection connection = new InternalServiceConnection(sciId);
        Intent serviceIntent = new Intent("android.service.textservice.SpellCheckerService");
        serviceIntent.setComponent(info.getComponent());
        if (!this.bindCurrentSpellCheckerService(serviceIntent, connection, 0x2000001)) {
            Slog.e(TAG, "Failed to get a spell checker service.");
            return null;
        }
        SpellCheckerBindGroup group = new SpellCheckerBindGroup(connection);
        this.mSpellCheckerBindGroups.put(sciId, group);
        return group;
    }

    @Override
    public SpellCheckerInfo[] getEnabledSpellCheckers() {
        if (!this.calledFromValidUser()) {
            return null;
        }
        return this.mSpellCheckerList.toArray(new SpellCheckerInfo[this.mSpellCheckerList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishSpellCheckerService(ISpellCheckerSessionListener listener) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            ArrayList<SpellCheckerBindGroup> removeList = new ArrayList<SpellCheckerBindGroup>();
            for (SpellCheckerBindGroup group : this.mSpellCheckerBindGroups.values()) {
                if (group == null) continue;
                removeList.add(group);
            }
            int removeSize = removeList.size();
            for (int i = 0; i < removeSize; ++i) {
                ((SpellCheckerBindGroup)removeList.get(i)).removeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentSpellChecker(String locale, String sciId) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                throw new SecurityException("Requires permission android.permission.WRITE_SECURE_SETTINGS");
            }
            this.setCurrentSpellCheckerLocked(sciId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentSpellCheckerSubtype(String locale, int hashCode) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                throw new SecurityException("Requires permission android.permission.WRITE_SECURE_SETTINGS");
            }
            this.setCurrentSpellCheckerSubtypeLocked(hashCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSpellCheckerEnabled(boolean enabled) {
        if (!this.calledFromValidUser()) {
            return;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                throw new SecurityException("Requires permission android.permission.WRITE_SECURE_SETTINGS");
            }
            this.setSpellCheckerEnabledLocked(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentSpellCheckerLocked(String sciId) {
        if (TextUtils.isEmpty(sciId) || !this.mSpellCheckerMap.containsKey(sciId)) {
            return;
        }
        SpellCheckerInfo currentSci = this.getCurrentSpellChecker(null);
        if (currentSci != null && currentSci.getId().equals(sciId)) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mSettings.putSelectedSpellChecker(sciId);
            this.setCurrentSpellCheckerSubtypeLocked(0);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentSpellCheckerSubtypeLocked(int hashCode) {
        SpellCheckerInfo sci = this.getCurrentSpellChecker(null);
        int tempHashCode = 0;
        for (int i = 0; sci != null && i < sci.getSubtypeCount(); ++i) {
            if (sci.getSubtypeAt(i).hashCode() != hashCode) continue;
            tempHashCode = hashCode;
            break;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mSettings.putSelectedSpellCheckerSubtype(tempHashCode);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSpellCheckerEnabledLocked(boolean enabled) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mSettings.setSpellCheckerEnabled(enabled);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSpellCheckerEnabledLocked() {
        long ident = Binder.clearCallingIdentity();
        try {
            boolean retval;
            boolean bl = retval = this.mSettings.isSpellCheckerEnabled();
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        HashMap<String, SpellCheckerInfo> hashMap = this.mSpellCheckerMap;
        synchronized (hashMap) {
            pw.println("Current Text Services Manager state:");
            pw.println("  Spell Checkers:");
            int spellCheckerIndex = 0;
            for (SpellCheckerInfo spellCheckerInfo : this.mSpellCheckerMap.values()) {
                pw.println("  Spell Checker #" + spellCheckerIndex);
                spellCheckerInfo.dump(pw, "    ");
                ++spellCheckerIndex;
            }
            pw.println("");
            pw.println("  Spell Checker Bind Groups:");
            for (Map.Entry entry : this.mSpellCheckerBindGroups.entrySet()) {
                SpellCheckerBindGroup grp = (SpellCheckerBindGroup)entry.getValue();
                pw.println("    " + (String)entry.getKey() + " " + grp + ":");
                pw.println("      mInternalConnection=" + grp.mInternalConnection);
                pw.println("      mSpellChecker=" + grp.mSpellChecker);
                pw.println("      mUnbindCalled=" + grp.mUnbindCalled);
                pw.println("      mConnected=" + grp.mConnected);
                int numPendingSessionRequests = grp.mPendingSessionRequests.size();
                for (int i = 0; i < numPendingSessionRequests; ++i) {
                    SessionRequest req = (SessionRequest)grp.mPendingSessionRequests.get(i);
                    pw.println("      Pending Request #" + i + ":");
                    pw.println("        mTsListener=" + req.mTsListener);
                    pw.println("        mScListener=" + req.mScListener);
                    pw.println("        mScLocale=" + req.mLocale + " mUid=" + req.mUserId);
                }
                int numOnGoingSessionRequests = grp.mOnGoingSessionRequests.size();
                for (int i = 0; i < numOnGoingSessionRequests; ++i) {
                    SessionRequest req = (SessionRequest)grp.mOnGoingSessionRequests.get(i);
                    pw.println("      On going Request #" + i + ":");
                    ++i;
                    pw.println("        mTsListener=" + req.mTsListener);
                    pw.println("        mScListener=" + req.mScListener);
                    pw.println("        mScLocale=" + req.mLocale + " mUid=" + req.mUserId);
                }
                int N = grp.mListeners.size();
                for (int i = 0; i < N; ++i) {
                    InternalDeathRecipient listener = (InternalDeathRecipient)grp.mListeners.get(i);
                    pw.println("      Listener #" + i + ":");
                    pw.println("        mScListener=" + listener.mScListener);
                    pw.println("        mGroup=" + listener.mGroup);
                }
            }
            pw.println("");
            pw.println("  mSettings:");
            this.mSettings.dumpLocked(pw, "    ");
        }
    }

    private static String getStackTrace() {
        StringBuilder sb = new StringBuilder();
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            StackTraceElement[] frames = e.getStackTrace();
            for (int j = 1; j < frames.length; ++j) {
                sb.append(frames[j].toString() + "\n");
            }
            return sb.toString();
        }
    }

    private static final class TextServicesSettings {
        private final ContentResolver mResolver;
        private int mCurrentUserId;
        @GuardedBy(value="mLock")
        private int[] mCurrentProfileIds = new int[0];
        private Object mLock = new Object();
        private final HashMap<String, String> mCopyOnWriteDataStore = new HashMap();
        private boolean mCopyOnWrite = false;

        public TextServicesSettings(ContentResolver resolver, int userId, boolean copyOnWrite) {
            this.mResolver = resolver;
            this.switchCurrentUser(userId, copyOnWrite);
        }

        public void switchCurrentUser(int userId, boolean copyOnWrite) {
            if (this.mCurrentUserId != userId || this.mCopyOnWrite != copyOnWrite) {
                this.mCopyOnWriteDataStore.clear();
            }
            this.mCurrentUserId = userId;
            this.mCopyOnWrite = copyOnWrite;
        }

        private void putString(String key, String str) {
            if (this.mCopyOnWrite) {
                this.mCopyOnWriteDataStore.put(key, str);
            } else {
                Settings.Secure.putStringForUser(this.mResolver, key, str, this.mCurrentUserId);
            }
        }

        private String getString(String key, String defaultValue) {
            String result = this.mCopyOnWrite && this.mCopyOnWriteDataStore.containsKey(key) ? this.mCopyOnWriteDataStore.get(key) : Settings.Secure.getStringForUser(this.mResolver, key, this.mCurrentUserId);
            return result != null ? result : defaultValue;
        }

        private void putInt(String key, int value) {
            if (this.mCopyOnWrite) {
                this.mCopyOnWriteDataStore.put(key, String.valueOf(value));
            } else {
                Settings.Secure.putIntForUser(this.mResolver, key, value, this.mCurrentUserId);
            }
        }

        private int getInt(String key, int defaultValue) {
            if (this.mCopyOnWrite && this.mCopyOnWriteDataStore.containsKey(key)) {
                String result = this.mCopyOnWriteDataStore.get(key);
                return result != null ? Integer.parseInt(result) : 0;
            }
            return Settings.Secure.getIntForUser(this.mResolver, key, defaultValue, this.mCurrentUserId);
        }

        private void putBoolean(String key, boolean value) {
            this.putInt(key, value ? 1 : 0);
        }

        private boolean getBoolean(String key, boolean defaultValue) {
            return this.getInt(key, defaultValue ? 1 : 0) == 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCurrentProfileIds(int[] currentProfileIds) {
            Object object = this.mLock;
            synchronized (object) {
                this.mCurrentProfileIds = currentProfileIds;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCurrentProfile(int userId) {
            Object object = this.mLock;
            synchronized (object) {
                if (userId == this.mCurrentUserId) {
                    return true;
                }
                for (int i = 0; i < this.mCurrentProfileIds.length; ++i) {
                    if (userId != this.mCurrentProfileIds[i]) continue;
                    return true;
                }
                return false;
            }
        }

        public int getCurrentUserId() {
            return this.mCurrentUserId;
        }

        public void putSelectedSpellChecker(String sciId) {
            if (TextUtils.isEmpty(sciId)) {
                this.putString("selected_spell_checker", null);
            } else {
                this.putString("selected_spell_checker", sciId);
            }
        }

        public void putSelectedSpellCheckerSubtype(int hashCode) {
            this.putInt("selected_spell_checker_subtype", hashCode);
        }

        public void setSpellCheckerEnabled(boolean enabled) {
            this.putBoolean("spell_checker_enabled", enabled);
        }

        public String getSelectedSpellChecker() {
            return this.getString("selected_spell_checker", "");
        }

        public int getSelectedSpellCheckerSubtype(int defaultValue) {
            return this.getInt("selected_spell_checker_subtype", defaultValue);
        }

        public boolean isSpellCheckerEnabled() {
            return this.getBoolean("spell_checker_enabled", true);
        }

        public void dumpLocked(PrintWriter pw, String prefix) {
            pw.println(prefix + "mCurrentUserId=" + this.mCurrentUserId);
            pw.println(prefix + "mCurrentProfileIds=" + Arrays.toString(this.mCurrentProfileIds));
            pw.println(prefix + "mCopyOnWrite=" + this.mCopyOnWrite);
        }
    }

    private static final class ISpellCheckerServiceCallbackBinder
    extends ISpellCheckerServiceCallback.Stub {
        private final SpellCheckerBindGroup mBindGroup;
        private final SessionRequest mRequest;

        ISpellCheckerServiceCallbackBinder(SpellCheckerBindGroup bindGroup, SessionRequest request) {
            this.mBindGroup = bindGroup;
            this.mRequest = request;
        }

        @Override
        public void onSessionCreated(ISpellCheckerSession newSession) {
            this.mBindGroup.onSessionCreated(newSession, this.mRequest);
        }
    }

    private static final class InternalDeathRecipient
    implements IBinder.DeathRecipient {
        public final ISpellCheckerSessionListener mScListener;
        private final SpellCheckerBindGroup mGroup;

        public InternalDeathRecipient(SpellCheckerBindGroup group, ISpellCheckerSessionListener scListener) {
            this.mScListener = scListener;
            this.mGroup = group;
        }

        public boolean hasSpellCheckerListener(ISpellCheckerSessionListener listener) {
            return listener.asBinder().equals(this.mScListener.asBinder());
        }

        @Override
        public void binderDied() {
            this.mGroup.removeListener(this.mScListener);
        }
    }

    private final class InternalServiceConnection
    implements ServiceConnection {
        private final String mSciId;

        public InternalServiceConnection(String id2) {
            this.mSciId = id2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                this.onServiceConnectedInnerLocked(name, service);
            }
        }

        private void onServiceConnectedInnerLocked(ComponentName name, IBinder service) {
            ISpellCheckerService spellChecker = ISpellCheckerService.Stub.asInterface(service);
            SpellCheckerBindGroup group = (SpellCheckerBindGroup)TextServicesManagerService.this.mSpellCheckerBindGroups.get(this.mSciId);
            if (group != null && this == group.mInternalConnection) {
                group.onServiceConnected(spellChecker);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                SpellCheckerBindGroup group = (SpellCheckerBindGroup)TextServicesManagerService.this.mSpellCheckerBindGroups.get(this.mSciId);
                if (group != null && this == group.mInternalConnection) {
                    TextServicesManagerService.this.mSpellCheckerBindGroups.remove(this.mSciId);
                }
            }
        }
    }

    private final class SpellCheckerBindGroup {
        private final String TAG = SpellCheckerBindGroup.class.getSimpleName();
        private final InternalServiceConnection mInternalConnection;
        private final ArrayList<InternalDeathRecipient> mListeners = new ArrayList();
        private boolean mUnbindCalled;
        private ISpellCheckerService mSpellChecker;
        private boolean mConnected;
        private final ArrayList<SessionRequest> mPendingSessionRequests = new ArrayList();
        private final ArrayList<SessionRequest> mOnGoingSessionRequests = new ArrayList();

        public SpellCheckerBindGroup(InternalServiceConnection connection) {
            this.mInternalConnection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ISpellCheckerService spellChecker) {
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                this.mSpellChecker = spellChecker;
                this.mConnected = true;
                this.mPendingSessionRequests.forEach(this::getISpellCheckerSessionLocked);
                this.mPendingSessionRequests.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(ISpellCheckerSessionListener listener) {
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                int size = this.mListeners.size();
                ArrayList<InternalDeathRecipient> removeList = new ArrayList<InternalDeathRecipient>();
                for (int i = 0; i < size; ++i) {
                    InternalDeathRecipient tempRecipient = this.mListeners.get(i);
                    if (!tempRecipient.hasSpellCheckerListener(listener)) continue;
                    removeList.add(tempRecipient);
                }
                int removeSize = removeList.size();
                for (int i = 0; i < removeSize; ++i) {
                    InternalDeathRecipient idr = (InternalDeathRecipient)removeList.get(i);
                    idr.mScListener.asBinder().unlinkToDeath(idr, 0);
                    this.mListeners.remove(idr);
                }
                this.cleanLocked();
            }
        }

        private void cleanLocked() {
            if (this.mUnbindCalled) {
                return;
            }
            if (!this.mListeners.isEmpty()) {
                return;
            }
            if (!this.mPendingSessionRequests.isEmpty()) {
                return;
            }
            if (!this.mOnGoingSessionRequests.isEmpty()) {
                return;
            }
            String sciId = this.mInternalConnection.mSciId;
            SpellCheckerBindGroup cur = (SpellCheckerBindGroup)TextServicesManagerService.this.mSpellCheckerBindGroups.get(sciId);
            if (cur == this) {
                TextServicesManagerService.this.mSpellCheckerBindGroups.remove(sciId);
            }
            TextServicesManagerService.this.mContext.unbindService(this.mInternalConnection);
            this.mUnbindCalled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll() {
            Slog.e(this.TAG, "Remove the spell checker bind unexpectedly.");
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                int size = this.mListeners.size();
                for (int i = 0; i < size; ++i) {
                    InternalDeathRecipient idr = this.mListeners.get(i);
                    idr.mScListener.asBinder().unlinkToDeath(idr, 0);
                }
                this.mListeners.clear();
                this.mPendingSessionRequests.clear();
                this.mOnGoingSessionRequests.clear();
                this.cleanLocked();
            }
        }

        public void getISpellCheckerSessionOrQueueLocked(SessionRequest request) {
            if (this.mUnbindCalled) {
                return;
            }
            if (!this.mConnected) {
                this.mPendingSessionRequests.add(request);
                return;
            }
            this.getISpellCheckerSessionLocked(request);
        }

        private void getISpellCheckerSessionLocked(SessionRequest request) {
            if (this.mUnbindCalled) {
                return;
            }
            try {
                this.mSpellChecker.getISpellCheckerSession(request.mLocale, request.mScListener, request.mBundle, new ISpellCheckerServiceCallbackBinder(this, request));
                this.mOnGoingSessionRequests.add(request);
            }
            catch (RemoteException e) {
                this.removeAll();
            }
            this.cleanLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onSessionCreated(ISpellCheckerSession newSession, SessionRequest request) {
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                if (this.mUnbindCalled) {
                    return;
                }
                if (this.mOnGoingSessionRequests.remove(request)) {
                    InternalDeathRecipient recipient = new InternalDeathRecipient(this, request.mScListener);
                    try {
                        request.mTsListener.onServiceConnected(newSession);
                        request.mScListener.asBinder().linkToDeath(recipient, 0);
                        this.mListeners.add(recipient);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                this.cleanLocked();
            }
        }
    }

    private static final class SessionRequest {
        public final int mUserId;
        public final String mLocale;
        public final ITextServicesSessionListener mTsListener;
        public final ISpellCheckerSessionListener mScListener;
        public final Bundle mBundle;

        SessionRequest(int userId, String locale, ITextServicesSessionListener tsListener, ISpellCheckerSessionListener scListener, Bundle bundle) {
            this.mUserId = userId;
            this.mLocale = locale;
            this.mTsListener = tsListener;
            this.mScListener = scListener;
            this.mBundle = bundle;
        }
    }

    private final class TextServicesBroadcastReceiver
    extends BroadcastReceiver {
        private TextServicesBroadcastReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.USER_ADDED".equals(action) || "android.intent.action.USER_REMOVED".equals(action)) {
                TextServicesManagerService.this.updateCurrentProfileIds();
                return;
            }
            Slog.w(TAG, "Unexpected intent " + intent);
        }
    }

    private final class TextServicesMonitor
    extends PackageMonitor {
        private TextServicesMonitor() {
        }

        private boolean isChangingPackagesOfCurrentUser() {
            int userId = this.getChangingUserId();
            boolean retval = userId == TextServicesManagerService.this.mSettings.getCurrentUserId();
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSomePackagesChanged() {
            if (!this.isChangingPackagesOfCurrentUser()) {
                return;
            }
            HashMap hashMap = TextServicesManagerService.this.mSpellCheckerMap;
            synchronized (hashMap) {
                TextServicesManagerService.buildSpellCheckerMapLocked(TextServicesManagerService.this.mContext, TextServicesManagerService.this.mSpellCheckerList, TextServicesManagerService.this.mSpellCheckerMap, TextServicesManagerService.this.mSettings);
                SpellCheckerInfo sci = TextServicesManagerService.this.getCurrentSpellChecker(null);
                if (sci == null) {
                    return;
                }
                String packageName = sci.getPackageName();
                int change = this.isPackageDisappearing(packageName);
                if ((change == 3 || change == 2 || this.isPackageModified(packageName)) && (sci = TextServicesManagerService.this.findAvailSpellCheckerLocked(packageName)) != null) {
                    TextServicesManagerService.this.setCurrentSpellCheckerLocked(sci.getId());
                }
            }
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private TextServicesManagerService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new TextServicesManagerService(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService("textservices", this.mService);
        }

        @Override
        public void onSwitchUser(int userHandle) {
            this.mService.onSwitchUser(userHandle);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                this.mService.systemRunning();
            }
        }

        @Override
        public void onUnlockUser(int userHandle) {
            this.mService.onUnlockUser(userHandle);
        }
    }
}

