/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.app.StatusBarManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.display.DisplayManager;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.input.InputManager;
import android.media.AudioManagerInternal;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.provider.Settings;
import android.provider.SettingsStringUtil;
import android.text.TextUtils;
import android.util.IntArray;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.IWindow;
import android.view.KeyEvent;
import android.view.MagnificationSpec;
import android.view.View;
import android.view.WindowInfo;
import android.view.WindowManagerInternal;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IntPair;
import com.android.server.LocalServices;
import com.android.server.accessibility.AccessibilityInputFilter;
import com.android.server.accessibility.ActionReplacingCallback;
import com.android.server.accessibility.DisplayAdjustmentUtils;
import com.android.server.accessibility.FingerprintGestureDispatcher;
import com.android.server.accessibility.KeyEventDispatcher;
import com.android.server.accessibility.MagnificationController;
import com.android.server.accessibility.MotionEventInjector;
import com.android.server.policy.AccessibilityShortcutController;
import com.android.server.statusbar.StatusBarManagerInternal;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.xmlpull.v1.XmlPullParserException;

public class AccessibilityManagerService
extends IAccessibilityManager.Stub {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityManagerService";
    private static final int WAIT_FOR_USER_STATE_FULLY_INITIALIZED_MILLIS = 3000;
    private static final int WAIT_WINDOWS_TIMEOUT_MILLIS = 5000;
    private static final int WAIT_MOTION_INJECTOR_TIMEOUT_MILLIS = 1000;
    private static final String FUNCTION_REGISTER_UI_TEST_AUTOMATION_SERVICE = "registerUiTestAutomationService";
    private static final String TEMPORARY_ENABLE_ACCESSIBILITY_UNTIL_KEYGUARD_REMOVED = "temporaryEnableAccessibilityStateUntilKeyguardRemoved";
    private static final String GET_WINDOW_TOKEN = "getWindowToken";
    private static final String SET_PIP_ACTION_REPLACEMENT = "setPictureInPictureActionReplacingConnection";
    private static final ComponentName sFakeAccessibilityServiceComponentName = new ComponentName("foo.bar", "FakeService");
    private static final String FUNCTION_DUMP = "dump";
    private static final char COMPONENT_NAME_SEPARATOR = ':';
    private static final int OWN_PROCESS_ID = Process.myPid();
    public static final int MAGNIFICATION_GESTURE_HANDLER_ID = 0;
    private static int sIdCounter = 1;
    private static int sNextWindowId;
    private final Context mContext;
    private final Object mLock = new Object();
    private final TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
    private final Rect mTempRect = new Rect();
    private final Rect mTempRect1 = new Rect();
    private final Point mTempPoint = new Point();
    private final PackageManager mPackageManager;
    private final PowerManager mPowerManager;
    private final WindowManagerInternal mWindowManagerService;
    private final SecurityPolicy mSecurityPolicy;
    private final MainHandler mMainHandler;
    private MagnificationController mMagnificationController;
    private InteractionBridge mInteractionBridge;
    private AlertDialog mEnableTouchExplorationDialog;
    private AccessibilityInputFilter mInputFilter;
    private boolean mHasInputFilter;
    private KeyEventDispatcher mKeyEventDispatcher;
    private MotionEventInjector mMotionEventInjector;
    private FingerprintGestureDispatcher mFingerprintGestureDispatcher;
    private final Set<ComponentName> mTempComponentNameSet = new HashSet<ComponentName>();
    private final List<AccessibilityServiceInfo> mTempAccessibilityServiceInfoList = new ArrayList<AccessibilityServiceInfo>();
    private final IntArray mTempIntArray = new IntArray(0);
    private final RemoteCallbackList<IAccessibilityManagerClient> mGlobalClients = new RemoteCallbackList();
    private final SparseArray<AccessibilityConnectionWrapper> mGlobalInteractionConnections = new SparseArray();
    private AccessibilityConnectionWrapper mPictureInPictureActionReplacingConnection;
    private final SparseArray<IBinder> mGlobalWindowTokens = new SparseArray();
    private final SparseArray<UserState> mUserStates = new SparseArray();
    private final UserManager mUserManager;
    private int mCurrentUserId = 0;
    private boolean mInitialized;
    private WindowsForAccessibilityCallback mWindowsForAccessibilityCallback;
    private boolean mIsAccessibilityButtonShown;

    private UserState getCurrentUserStateLocked() {
        return this.getUserStateLocked(this.mCurrentUserId);
    }

    public AccessibilityManagerService(Context context) {
        this.mContext = context;
        this.mPackageManager = this.mContext.getPackageManager();
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWindowManagerService = LocalServices.getService(WindowManagerInternal.class);
        this.mUserManager = (UserManager)context.getSystemService("user");
        this.mSecurityPolicy = new SecurityPolicy();
        this.mMainHandler = new MainHandler(this.mContext.getMainLooper());
        this.registerBroadcastReceivers();
        new AccessibilityContentObserver(this.mMainHandler).register(context.getContentResolver());
    }

    private UserState getUserStateLocked(int userId) {
        UserState state = this.mUserStates.get(userId);
        if (state == null) {
            state = new UserState(userId);
            this.mUserStates.put(userId, state);
        }
        return state;
    }

    private void registerBroadcastReceivers() {
        PackageMonitor monitor = new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSomePackagesChanged() {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    if (this.getChangingUserId() != AccessibilityManagerService.this.mCurrentUserId) {
                        return;
                    }
                    UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                    userState.mInstalledServices.clear();
                    if (!userState.isUiAutomationSuppressingOtherServices() && AccessibilityManagerService.this.readConfigurationForUserStateLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageUpdateFinished(String packageName, int uid) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    int userId = this.getChangingUserId();
                    if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                        return;
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(userId);
                    boolean unboundAService = false;
                    for (int i = userState.mBoundServices.size() - 1; i >= 0; --i) {
                        Service boundService = userState.mBoundServices.get(i);
                        String servicePkg = boundService.mComponentName.getPackageName();
                        if (!servicePkg.equals(packageName)) continue;
                        boundService.unbindLocked();
                        unboundAService = true;
                    }
                    if (unboundAService) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageRemoved(String packageName, int uid) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    int userId = this.getChangingUserId();
                    if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                        return;
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(userId);
                    Iterator<ComponentName> it = userState.mEnabledServices.iterator();
                    while (it.hasNext()) {
                        ComponentName comp = it.next();
                        String compPkg = comp.getPackageName();
                        if (!compPkg.equals(packageName)) continue;
                        it.remove();
                        AccessibilityManagerService.this.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, userId);
                        userState.mTouchExplorationGrantedServices.remove(comp);
                        AccessibilityManagerService.this.persistComponentNamesToSettingLocked("touch_exploration_granted_accessibility_services", userState.mTouchExplorationGrantedServices, userId);
                        if (!userState.isUiAutomationSuppressingOtherServices()) {
                            AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                        }
                        return;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    int userId = this.getChangingUserId();
                    if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                        return false;
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(userId);
                    Iterator<ComponentName> it = userState.mEnabledServices.iterator();
                    while (it.hasNext()) {
                        ComponentName comp = it.next();
                        String compPkg = comp.getPackageName();
                        for (String pkg : packages) {
                            if (!compPkg.equals(pkg)) continue;
                            if (!doit) {
                                return true;
                            }
                            it.remove();
                            AccessibilityManagerService.this.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, userId);
                            if (userState.isUiAutomationSuppressingOtherServices()) continue;
                            AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                        }
                    }
                    return false;
                }
            }
        };
        monitor.register(this.mContext, null, UserHandle.ALL, true);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.USER_UNLOCKED");
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.os.action.SETTING_RESTORED");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.USER_SWITCHED".equals(action)) {
                    AccessibilityManagerService.this.switchUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else if ("android.intent.action.USER_UNLOCKED".equals(action)) {
                    AccessibilityManagerService.this.unlockUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                    AccessibilityManagerService.this.removeUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else {
                    String which;
                    if ("android.intent.action.USER_PRESENT".equals(action)) {
                        Object object = AccessibilityManagerService.this.mLock;
                        synchronized (object) {
                            UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                            if (!userState.isUiAutomationSuppressingOtherServices() && AccessibilityManagerService.this.readConfigurationForUserStateLocked(userState)) {
                                AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                            }
                        }
                    }
                    if ("android.os.action.SETTING_RESTORED".equals(action) && "enabled_accessibility_services".equals(which = intent.getStringExtra("setting_name"))) {
                        Object object = AccessibilityManagerService.this.mLock;
                        synchronized (object) {
                            AccessibilityManagerService.this.restoreEnabledAccessibilityServicesLocked(intent.getStringExtra("previous_value"), intent.getStringExtra("new_value"));
                        }
                    }
                }
            }
        }, UserHandle.ALL, intentFilter, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addClient(IAccessibilityManagerClient client, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            UserState userState = this.getUserStateLocked(resolvedUserId);
            if (this.mSecurityPolicy.isCallerInteractingAcrossUsers(userId)) {
                this.mGlobalClients.register(client);
                return IntPair.of(userState.getClientState(), userState.mLastSentRelevantEventTypes);
            }
            userState.mUserClients.register(client);
            return IntPair.of(resolvedUserId == this.mCurrentUserId ? userState.getClientState() : 0, userState.mLastSentRelevantEventTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAccessibilityEvent(AccessibilityEvent event, int userId) {
        boolean dispatchEvent = false;
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId;
            AccessibilityWindowInfo pip;
            if (event.getWindowId() == -3 && (pip = this.mSecurityPolicy.getPictureInPictureWindow()) != null) {
                int pipId = pip.getId();
                event.setWindowId(pipId);
                event.setSealed(true);
                AccessibilityNodeInfo info = event.getSource();
                info.setSealed(false);
                event.setSealed(false);
                if (info != null) {
                    info.setSourceNodeId(info.getSourceNodeId(), pipId);
                    event.setSource(info);
                    info.recycle();
                }
            }
            if ((resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId)) == this.mCurrentUserId) {
                if (this.mSecurityPolicy.canDispatchAccessibilityEventLocked(event)) {
                    this.mSecurityPolicy.updateActiveAndAccessibilityFocusedWindowLocked(event.getWindowId(), event.getSourceNodeId(), event.getEventType(), event.getAction());
                    this.mSecurityPolicy.updateEventSourceLocked(event);
                    dispatchEvent = true;
                }
                if (this.mHasInputFilter && this.mInputFilter != null) {
                    this.mMainHandler.obtainMessage(1, AccessibilityEvent.obtain(event)).sendToTarget();
                }
            }
        }
        if (dispatchEvent) {
            if (event.getEventType() == 32 && this.mWindowsForAccessibilityCallback != null) {
                WindowManagerInternal wm = LocalServices.getService(WindowManagerInternal.class);
                wm.computeWindowsForAccessibility();
            }
            object = this.mLock;
            synchronized (object) {
                this.notifyAccessibilityServicesDelayedLocked(event, false);
                this.notifyAccessibilityServicesDelayedLocked(event, true);
            }
        }
        if (OWN_PROCESS_ID != Binder.getCallingPid()) {
            event.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            UserState userState = this.getUserStateLocked(resolvedUserId);
            if (userState.mUiAutomationService != null) {
                ArrayList<AccessibilityServiceInfo> installedServices = new ArrayList<AccessibilityServiceInfo>();
                installedServices.addAll(userState.mInstalledServices);
                installedServices.remove(((UserState)userState).mUiAutomationService.mAccessibilityServiceInfo);
                return installedServices;
            }
            return userState.mInstalledServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackType, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            UserState userState = this.getUserStateLocked(resolvedUserId);
            if (userState.isUiAutomationSuppressingOtherServices()) {
                return Collections.emptyList();
            }
            CopyOnWriteArrayList<Service> services = userState.mBoundServices;
            int serviceCount = services.size();
            ArrayList<AccessibilityServiceInfo> result = new ArrayList<AccessibilityServiceInfo>(serviceCount);
            for (int i = 0; i < serviceCount; ++i) {
                Service service = (Service)services.get(i);
                if (sFakeAccessibilityServiceComponentName.equals(service.mComponentName) || (service.mFeedbackType & feedbackType) == 0) continue;
                result.add(service.mAccessibilityServiceInfo);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt(int userId) {
        ArrayList<IAccessibilityServiceClient> interfacesToInterrupt;
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            if (resolvedUserId != this.mCurrentUserId) {
                return;
            }
            CopyOnWriteArrayList<Service> services = this.getUserStateLocked((int)resolvedUserId).mBoundServices;
            int numServices = services.size();
            interfacesToInterrupt = new ArrayList<IAccessibilityServiceClient>(numServices);
            for (int i = 0; i < numServices; ++i) {
                Service service = (Service)services.get(i);
                IBinder a11yServiceBinder = service.mService;
                IAccessibilityServiceClient a11yServiceInterface = service.mServiceInterface;
                if (a11yServiceBinder == null || a11yServiceInterface == null) continue;
                interfacesToInterrupt.add(a11yServiceInterface);
            }
        }
        int count = interfacesToInterrupt.size();
        for (int i = 0; i < count; ++i) {
            try {
                ((IAccessibilityServiceClient)interfacesToInterrupt.get(i)).onInterrupt();
                continue;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error sending interrupt request to " + interfacesToInterrupt.get(i), re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addAccessibilityInteractionConnection(IWindow windowToken, IAccessibilityInteractionConnection connection, int userId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            int windowId = sNextWindowId++;
            if (this.mSecurityPolicy.isCallerInteractingAcrossUsers(userId)) {
                AccessibilityConnectionWrapper wrapper = new AccessibilityConnectionWrapper(windowId, connection, -1);
                wrapper.linkToDeath();
                this.mGlobalInteractionConnections.put(windowId, wrapper);
                this.mGlobalWindowTokens.put(windowId, windowToken.asBinder());
            } else {
                AccessibilityConnectionWrapper wrapper = new AccessibilityConnectionWrapper(windowId, connection, resolvedUserId);
                wrapper.linkToDeath();
                UserState userState = this.getUserStateLocked(resolvedUserId);
                userState.mInteractionConnections.put(windowId, wrapper);
                userState.mWindowTokens.put(windowId, windowToken.asBinder());
            }
            return windowId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAccessibilityInteractionConnection(IWindow window) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(UserHandle.getCallingUserId());
            IBinder token = window.asBinder();
            int removedWindowId = this.removeAccessibilityInteractionConnectionInternalLocked(token, this.mGlobalWindowTokens, this.mGlobalInteractionConnections);
            if (removedWindowId >= 0) {
                return;
            }
            int userCount = this.mUserStates.size();
            for (int i = 0; i < userCount; ++i) {
                UserState userState = this.mUserStates.valueAt(i);
                int removedWindowIdForUser = this.removeAccessibilityInteractionConnectionInternalLocked(token, userState.mWindowTokens, userState.mInteractionConnections);
                if (removedWindowIdForUser < 0) continue;
                return;
            }
        }
    }

    private int removeAccessibilityInteractionConnectionInternalLocked(IBinder windowToken, SparseArray<IBinder> windowTokens, SparseArray<AccessibilityConnectionWrapper> interactionConnections) {
        int count = windowTokens.size();
        for (int i = 0; i < count; ++i) {
            if (windowTokens.valueAt(i) != windowToken) continue;
            int windowId = windowTokens.keyAt(i);
            windowTokens.removeAt(i);
            AccessibilityConnectionWrapper wrapper = interactionConnections.get(windowId);
            wrapper.unlinkToDeath();
            interactionConnections.remove(windowId);
            return windowId;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPictureInPictureActionReplacingConnection(IAccessibilityInteractionConnection connection) throws RemoteException {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.MODIFY_ACCESSIBILITY_DATA", SET_PIP_ACTION_REPLACEMENT);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPictureInPictureActionReplacingConnection != null) {
                this.mPictureInPictureActionReplacingConnection.unlinkToDeath();
                this.mPictureInPictureActionReplacingConnection = null;
            }
            if (connection != null) {
                AccessibilityConnectionWrapper wrapper;
                this.mPictureInPictureActionReplacingConnection = wrapper = new AccessibilityConnectionWrapper(-3, connection, -1);
                wrapper.linkToDeath();
            }
            this.mSecurityPolicy.notifyWindowsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUiTestAutomationService(IBinder owner, IAccessibilityServiceClient serviceClient, AccessibilityServiceInfo accessibilityServiceInfo, int flags) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.RETRIEVE_WINDOW_CONTENT", FUNCTION_REGISTER_UI_TEST_AUTOMATION_SERVICE);
        accessibilityServiceInfo.setComponentName(sFakeAccessibilityServiceComponentName);
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCurrentUserStateLocked();
            if (userState.mUiAutomationService != null) {
                throw new IllegalStateException("UiAutomationService " + serviceClient + "already registered!");
            }
            try {
                owner.linkToDeath(userState.mUiAutomationSerivceOnwerDeathRecipient, 0);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Couldn't register for the death of a UiTestAutomationService!", re);
                return;
            }
            userState.mUiAutomationServiceOwner = owner;
            userState.mUiAutomationServiceClient = serviceClient;
            userState.mUiAutomationFlags = flags;
            userState.mInstalledServices.add(accessibilityServiceInfo);
            if ((flags & 1) == 0) {
                userState.mIsTouchExplorationEnabled = false;
                userState.mIsDisplayMagnificationEnabled = false;
                userState.mIsNavBarMagnificationEnabled = false;
                userState.mIsAutoclickEnabled = false;
                userState.mEnabledServices.clear();
            }
            userState.mEnabledServices.add(sFakeAccessibilityServiceComponentName);
            userState.mTouchExplorationGrantedServices.add(sFakeAccessibilityServiceComponentName);
            this.onUserStateChangedLocked(userState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterUiTestAutomationService(IAccessibilityServiceClient serviceClient) {
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCurrentUserStateLocked();
            if (userState.mUiAutomationService == null || serviceClient == null || ((UserState)userState).mUiAutomationService.mServiceInterface == null || ((UserState)userState).mUiAutomationService.mServiceInterface.asBinder() != serviceClient.asBinder()) {
                throw new IllegalStateException("UiAutomationService " + serviceClient + " not registered!");
            }
            userState.mUiAutomationService.binderDied();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void temporaryEnableAccessibilityStateUntilKeyguardRemoved(ComponentName service, boolean touchExplorationEnabled) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.TEMPORARY_ENABLE_ACCESSIBILITY", TEMPORARY_ENABLE_ACCESSIBILITY_UNTIL_KEYGUARD_REMOVED);
        if (!this.mWindowManagerService.isKeyguardLocked()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCurrentUserStateLocked();
            if (userState.isUiAutomationSuppressingOtherServices()) {
                return;
            }
            userState.mIsTouchExplorationEnabled = touchExplorationEnabled;
            userState.mIsDisplayMagnificationEnabled = false;
            userState.mIsNavBarMagnificationEnabled = false;
            userState.mIsAutoclickEnabled = false;
            userState.mEnabledServices.clear();
            userState.mEnabledServices.add(service);
            userState.mBindingServices.clear();
            userState.mTouchExplorationGrantedServices.clear();
            userState.mTouchExplorationGrantedServices.add(service);
            this.onUserStateChangedLocked(userState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder getWindowToken(int windowId, int userId) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.RETRIEVE_WINDOW_TOKEN", GET_WINDOW_TOKEN);
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            if (resolvedUserId != this.mCurrentUserId) {
                return null;
            }
            if (this.mSecurityPolicy.findWindowById(windowId) == null) {
                return null;
            }
            IBinder token = this.mGlobalWindowTokens.get(windowId);
            if (token != null) {
                return token;
            }
            return this.getCurrentUserStateLocked().mWindowTokens.get(windowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAccessibilityButtonClicked() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR_SERVICE");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.notifyAccessibilityButtonClickedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAccessibilityButtonVisibilityChanged(boolean shown) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR_SERVICE");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.notifyAccessibilityButtonVisibilityChangedLocked(shown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onGesture(int gestureId) {
        Object object = this.mLock;
        synchronized (object) {
            boolean handled = this.notifyGestureLocked(gestureId, false);
            if (!handled) {
                handled = this.notifyGestureLocked(gestureId, true);
            }
            return handled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean notifyKeyEvent(KeyEvent event, int policyFlags) {
        Object object = this.mLock;
        synchronized (object) {
            CopyOnWriteArrayList<Service> boundServices = this.getCurrentUserStateLocked().mBoundServices;
            if (boundServices.isEmpty()) {
                return false;
            }
            return this.getKeyEventDispatcher().notifyKeyEventLocked(event, policyFlags, boundServices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyMagnificationChanged(Region region, float scale, float centerX, float centerY) {
        Object object = this.mLock;
        synchronized (object) {
            this.notifyClearAccessibilityCacheLocked();
            this.notifyMagnificationChangedLocked(region, scale, centerX, centerY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMotionEventInjector(MotionEventInjector motionEventInjector) {
        Object object = this.mLock;
        synchronized (object) {
            this.mMotionEventInjector = motionEventInjector;
            this.mLock.notifyAll();
        }
    }

    boolean getAccessibilityFocusClickPointInScreen(Point outPoint) {
        return this.getInteractionBridge().getAccessibilityFocusClickPointInScreenNotLocked(outPoint);
    }

    public boolean performActionOnAccessibilityFocusedItem(AccessibilityNodeInfo.AccessibilityAction action) {
        return this.getInteractionBridge().performActionOnAccessibilityFocusedItemNotLocked(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getWindowBounds(int windowId, Rect outBounds) {
        IBinder token;
        Object object = this.mLock;
        synchronized (object) {
            token = this.mGlobalWindowTokens.get(windowId);
            if (token == null) {
                token = this.getCurrentUserStateLocked().mWindowTokens.get(windowId);
            }
        }
        this.mWindowManagerService.getWindowFrame(token, outBounds);
        return !outBounds.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean accessibilityFocusOnlyInActiveWindow() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mWindowsForAccessibilityCallback == null;
        }
    }

    int getActiveWindowId() {
        return this.mSecurityPolicy.getActiveWindowId();
    }

    void onTouchInteractionStart() {
        this.mSecurityPolicy.onTouchInteractionStart();
    }

    void onTouchInteractionEnd() {
        this.mSecurityPolicy.onTouchInteractionEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            UserManager userManager;
            if (this.mCurrentUserId == userId && this.mInitialized) {
                return;
            }
            UserState oldUserState = this.getCurrentUserStateLocked();
            oldUserState.onSwitchToAnotherUser();
            if (oldUserState.mUserClients.getRegisteredCallbackCount() > 0) {
                this.mMainHandler.obtainMessage(3, oldUserState.mUserId, 0).sendToTarget();
            }
            boolean announceNewUser = (userManager = (UserManager)this.mContext.getSystemService("user")).getUsers().size() > 1;
            this.mCurrentUserId = userId;
            UserState userState = this.getCurrentUserStateLocked();
            if (userState.mUiAutomationService != null) {
                userState.mUiAutomationService.binderDied();
            }
            this.readConfigurationForUserStateLocked(userState);
            this.onUserStateChangedLocked(userState);
            if (announceNewUser) {
                this.mMainHandler.sendEmptyMessageDelayed(5, 3000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int parentUserId = this.mSecurityPolicy.resolveProfileParentLocked(userId);
            if (parentUserId == this.mCurrentUserId) {
                UserState userState = this.getUserStateLocked(this.mCurrentUserId);
                this.onUserStateChangedLocked(userState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUserStates.remove(userId);
        }
    }

    void restoreEnabledAccessibilityServicesLocked(String oldSetting, String newSetting) {
        this.readComponentNamesFromStringLocked(oldSetting, this.mTempComponentNameSet, false);
        this.readComponentNamesFromStringLocked(newSetting, this.mTempComponentNameSet, true);
        UserState userState = this.getUserStateLocked(0);
        userState.mEnabledServices.clear();
        userState.mEnabledServices.addAll(this.mTempComponentNameSet);
        this.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, 0);
        this.onUserStateChangedLocked(userState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InteractionBridge getInteractionBridge() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInteractionBridge == null) {
                this.mInteractionBridge = new InteractionBridge();
            }
            return this.mInteractionBridge;
        }
    }

    private boolean notifyGestureLocked(int gestureId, boolean isDefault) {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            Service service = state.mBoundServices.get(i);
            if (!service.mRequestTouchExplorationMode || service.mIsDefault != isDefault) continue;
            service.notifyGesture(gestureId);
            return true;
        }
        return false;
    }

    private void notifyClearAccessibilityCacheLocked() {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            Service service = state.mBoundServices.get(i);
            service.notifyClearAccessibilityNodeInfoCache();
        }
    }

    private void notifyMagnificationChangedLocked(Region region, float scale, float centerX, float centerY) {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            Service service = state.mBoundServices.get(i);
            service.notifyMagnificationChangedLocked(region, scale, centerX, centerY);
        }
    }

    private void notifySoftKeyboardShowModeChangedLocked(int showMode) {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            Service service = state.mBoundServices.get(i);
            service.notifySoftKeyboardShowModeChangedLocked(showMode);
        }
    }

    private void notifyAccessibilityButtonClickedLocked() {
        Service service;
        int i;
        UserState state = this.getCurrentUserStateLocked();
        int potentialTargets = state.mIsNavBarMagnificationEnabled ? 1 : 0;
        for (i = state.mBoundServices.size() - 1; i >= 0; --i) {
            service = state.mBoundServices.get(i);
            if (!service.mRequestAccessibilityButton) continue;
            ++potentialTargets;
        }
        if (potentialTargets == 0) {
            return;
        }
        if (potentialTargets == 1) {
            if (state.mIsNavBarMagnificationEnabled) {
                this.mMainHandler.obtainMessage(13).sendToTarget();
                return;
            }
            for (i = state.mBoundServices.size() - 1; i >= 0; --i) {
                service = state.mBoundServices.get(i);
                if (!service.mRequestAccessibilityButton) continue;
                service.notifyAccessibilityButtonClickedLocked();
                return;
            }
        } else {
            if (state.mServiceAssignedToAccessibilityButton == null && !state.mIsNavBarMagnificationAssignedToAccessibilityButton) {
                this.mMainHandler.obtainMessage(14).sendToTarget();
            } else {
                if (state.mIsNavBarMagnificationEnabled && state.mIsNavBarMagnificationAssignedToAccessibilityButton) {
                    this.mMainHandler.obtainMessage(13).sendToTarget();
                    return;
                }
                for (i = state.mBoundServices.size() - 1; i >= 0; --i) {
                    service = state.mBoundServices.get(i);
                    if (!service.mRequestAccessibilityButton || !service.mComponentName.equals(state.mServiceAssignedToAccessibilityButton)) continue;
                    service.notifyAccessibilityButtonClickedLocked();
                    return;
                }
            }
            this.mMainHandler.obtainMessage(14).sendToTarget();
        }
    }

    private void notifyAccessibilityButtonVisibilityChangedLocked(boolean available) {
        UserState state = this.getCurrentUserStateLocked();
        this.mIsAccessibilityButtonShown = available;
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            Service service = state.mBoundServices.get(i);
            if (!service.mRequestAccessibilityButton) continue;
            service.notifyAccessibilityButtonAvailabilityChangedLocked(service.isAccessibilityButtonAvailableLocked(state));
        }
    }

    private void removeAccessibilityInteractionConnectionLocked(int windowId, int userId) {
        if (userId == -1) {
            this.mGlobalWindowTokens.remove(windowId);
            this.mGlobalInteractionConnections.remove(windowId);
        } else {
            UserState userState = this.getCurrentUserStateLocked();
            userState.mWindowTokens.remove(windowId);
            userState.mInteractionConnections.remove(windowId);
        }
    }

    private boolean readInstalledAccessibilityServiceLocked(UserState userState) {
        this.mTempAccessibilityServiceInfoList.clear();
        List<ResolveInfo> installedServices = this.mPackageManager.queryIntentServicesAsUser(new Intent("android.accessibilityservice.AccessibilityService"), 819332, this.mCurrentUserId);
        int count = installedServices.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo resolveInfo = installedServices.get(i);
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (!"android.permission.BIND_ACCESSIBILITY_SERVICE".equals(serviceInfo.permission)) {
                Slog.w(LOG_TAG, "Skipping accessibilty service " + new ComponentName(serviceInfo.packageName, serviceInfo.name).flattenToShortString() + ": it does not require the permission " + "android.permission.BIND_ACCESSIBILITY_SERVICE");
                continue;
            }
            try {
                AccessibilityServiceInfo accessibilityServiceInfo = new AccessibilityServiceInfo(resolveInfo, this.mContext);
                this.mTempAccessibilityServiceInfoList.add(accessibilityServiceInfo);
                continue;
            }
            catch (IOException | XmlPullParserException xppe) {
                Slog.e(LOG_TAG, "Error while initializing AccessibilityServiceInfo", xppe);
            }
        }
        if (!this.mTempAccessibilityServiceInfoList.equals(userState.mInstalledServices)) {
            userState.mInstalledServices.clear();
            userState.mInstalledServices.addAll(this.mTempAccessibilityServiceInfoList);
            this.mTempAccessibilityServiceInfoList.clear();
            return true;
        }
        this.mTempAccessibilityServiceInfoList.clear();
        return false;
    }

    private boolean readEnabledAccessibilityServicesLocked(UserState userState) {
        this.mTempComponentNameSet.clear();
        this.readComponentNamesFromSettingLocked("enabled_accessibility_services", userState.mUserId, this.mTempComponentNameSet);
        if (!this.mTempComponentNameSet.equals(userState.mEnabledServices)) {
            userState.mEnabledServices.clear();
            userState.mEnabledServices.addAll(this.mTempComponentNameSet);
            if (userState.mUiAutomationService != null) {
                userState.mEnabledServices.add(sFakeAccessibilityServiceComponentName);
            }
            this.mTempComponentNameSet.clear();
            return true;
        }
        this.mTempComponentNameSet.clear();
        return false;
    }

    private boolean readTouchExplorationGrantedAccessibilityServicesLocked(UserState userState) {
        this.mTempComponentNameSet.clear();
        this.readComponentNamesFromSettingLocked("touch_exploration_granted_accessibility_services", userState.mUserId, this.mTempComponentNameSet);
        if (!this.mTempComponentNameSet.equals(userState.mTouchExplorationGrantedServices)) {
            userState.mTouchExplorationGrantedServices.clear();
            userState.mTouchExplorationGrantedServices.addAll(this.mTempComponentNameSet);
            this.mTempComponentNameSet.clear();
            return true;
        }
        this.mTempComponentNameSet.clear();
        return false;
    }

    private void notifyAccessibilityServicesDelayedLocked(AccessibilityEvent event, boolean isDefault) {
        try {
            UserState state = this.getCurrentUserStateLocked();
            int count = state.mBoundServices.size();
            for (int i = 0; i < count; ++i) {
                Service service = state.mBoundServices.get(i);
                if (service.mIsDefault != isDefault) continue;
                if (this.doesServiceWantEventLocked(service, event)) {
                    service.notifyAccessibilityEvent(event, true);
                    continue;
                }
                if (!service.mUsesAccessibilityCache || (0x41B83D & event.getEventType()) == 0) continue;
                service.notifyAccessibilityEvent(event, false);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void addServiceLocked(Service service, UserState userState) {
        try {
            if (!userState.mBoundServices.contains(service)) {
                service.onAdded();
                userState.mBoundServices.add(service);
                userState.mComponentNameToServiceMap.put(service.mComponentName, service);
                this.scheduleNotifyClientsOfServicesStateChange(userState);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void removeServiceLocked(Service service, UserState userState) {
        userState.mBoundServices.remove(service);
        service.onRemoved();
        userState.mComponentNameToServiceMap.clear();
        for (int i = 0; i < userState.mBoundServices.size(); ++i) {
            Service boundService = userState.mBoundServices.get(i);
            userState.mComponentNameToServiceMap.put(boundService.mComponentName, boundService);
        }
        this.scheduleNotifyClientsOfServicesStateChange(userState);
    }

    private void updateRelevantEventsLocked(UserState userState) {
        int relevantEventTypes = 4307005;
        for (Service service : userState.mBoundServices) {
            relevantEventTypes |= service.mEventTypes;
        }
        int finalRelevantEventTypes = relevantEventTypes;
        if (userState.mLastSentRelevantEventTypes != finalRelevantEventTypes) {
            userState.mLastSentRelevantEventTypes = finalRelevantEventTypes;
            this.mMainHandler.obtainMessage(12, userState.mUserId, finalRelevantEventTypes);
            this.mMainHandler.post(() -> this.broadcastToClients(userState, client -> {
                try {
                    client.setRelevantEventTypes(finalRelevantEventTypes);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }));
        }
    }

    private void broadcastToClients(UserState userState, Consumer<IAccessibilityManagerClient> clientAction) {
        this.mGlobalClients.broadcast(clientAction);
        userState.mUserClients.broadcast(clientAction);
    }

    private boolean doesServiceWantEventLocked(Service service, AccessibilityEvent event) {
        if (!service.canReceiveEventsLocked()) {
            return false;
        }
        if (event.getWindowId() != -1 && !event.isImportantForAccessibility() && (service.mFetchFlags & 8) == 0) {
            return false;
        }
        int eventType = event.getEventType();
        if ((service.mEventTypes & eventType) != eventType) {
            return false;
        }
        Set<String> packageNames = service.mPackageNames;
        String packageName = event.getPackageName() != null ? event.getPackageName().toString() : null;
        return packageNames.isEmpty() || packageNames.contains(packageName);
    }

    private void unbindAllServicesLocked(UserState userState) {
        CopyOnWriteArrayList<Service> services = userState.mBoundServices;
        int count = services.size();
        for (int i = 0; i < count; ++i) {
            Service service = (Service)services.get(i);
            if (!service.unbindLocked()) continue;
            --i;
            --count;
        }
    }

    private void readComponentNamesFromSettingLocked(String settingName, int userId, Set<ComponentName> outComponentNames) {
        String settingValue = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), settingName, userId);
        this.readComponentNamesFromStringLocked(settingValue, outComponentNames, false);
    }

    private void readComponentNamesFromStringLocked(String names, Set<ComponentName> outComponentNames, boolean doMerge) {
        if (!doMerge) {
            outComponentNames.clear();
        }
        if (names != null) {
            TextUtils.SimpleStringSplitter splitter = this.mStringColonSplitter;
            splitter.setString(names);
            while (splitter.hasNext()) {
                ComponentName enabledService;
                String str = splitter.next();
                if (str == null || str.length() <= 0 || (enabledService = ComponentName.unflattenFromString(str)) == null) continue;
                outComponentNames.add(enabledService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistComponentNamesToSettingLocked(String settingName, Set<ComponentName> componentNames, int userId) {
        StringBuilder builder = new StringBuilder();
        for (ComponentName componentName : componentNames) {
            if (builder.length() > 0) {
                builder.append(':');
            }
            builder.append(componentName.flattenToShortString());
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), settingName, builder.toString(), userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void updateServicesLocked(UserState userState) {
        Map<ComponentName, Service> componentNameToServiceMap = userState.mComponentNameToServiceMap;
        boolean isUnlockingOrUnlocked = LocalServices.getService(UserManagerInternal.class).isUserUnlockingOrUnlocked(userState.mUserId);
        int count = userState.mInstalledServices.size();
        for (int i = 0; i < count; ++i) {
            AccessibilityServiceInfo installedService = userState.mInstalledServices.get(i);
            ComponentName componentName = ComponentName.unflattenFromString(installedService.getId());
            Service service = componentNameToServiceMap.get(componentName);
            if (!isUnlockingOrUnlocked && !installedService.isDirectBootAware()) {
                Slog.d(LOG_TAG, "Ignoring non-encryption-aware service " + componentName);
                continue;
            }
            if (userState.mBindingServices.contains(componentName)) continue;
            if (userState.mEnabledServices.contains(componentName)) {
                if (service == null) {
                    service = new Service(userState.mUserId, componentName, installedService);
                } else if (userState.mBoundServices.contains(service)) continue;
                service.bindLocked();
                continue;
            }
            if (service == null) continue;
            service.unbindLocked();
        }
        int count2 = userState.mBoundServices.size();
        this.mTempIntArray.clear();
        for (int i = 0; i < count2; ++i) {
            ResolveInfo resolveInfo = userState.mBoundServices.get((int)i).mAccessibilityServiceInfo.getResolveInfo();
            if (resolveInfo == null) continue;
            this.mTempIntArray.add(resolveInfo.serviceInfo.applicationInfo.uid);
        }
        AudioManagerInternal audioManager = LocalServices.getService(AudioManagerInternal.class);
        if (audioManager != null) {
            audioManager.setAccessibilityServiceUids(this.mTempIntArray);
        }
        this.updateAccessibilityEnabledSetting(userState);
    }

    private void scheduleUpdateClientsIfNeededLocked(UserState userState) {
        int clientState = userState.getClientState();
        if (userState.mLastSentClientState != clientState && (this.mGlobalClients.getRegisteredCallbackCount() > 0 || userState.mUserClients.getRegisteredCallbackCount() > 0)) {
            userState.mLastSentClientState = clientState;
            this.mMainHandler.obtainMessage(2, clientState, userState.mUserId).sendToTarget();
        }
    }

    private void showAccessibilityButtonTargetSelection() {
        Intent intent = new Intent("com.android.internal.intent.action.CHOOSE_ACCESSIBILITY_BUTTON");
        intent.addFlags(0x10008000);
        this.mContext.startActivityAsUser(intent, UserHandle.of(this.mCurrentUserId));
    }

    private void scheduleNotifyClientsOfServicesStateChange(UserState userState) {
        this.mMainHandler.obtainMessage(10, userState.mUserId).sendToTarget();
    }

    private void scheduleUpdateInputFilter(UserState userState) {
        this.mMainHandler.obtainMessage(6, userState).sendToTarget();
    }

    private void scheduleUpdateFingerprintGestureHandling(UserState userState) {
        this.mMainHandler.obtainMessage(11, userState).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInputFilter(UserState userState) {
        boolean setInputFilter = false;
        AccessibilityInputFilter inputFilter = null;
        Object object = this.mLock;
        synchronized (object) {
            int flags = 0;
            if (userState.mIsDisplayMagnificationEnabled) {
                flags |= 1;
            }
            if (userState.mIsNavBarMagnificationEnabled) {
                flags |= 0x40;
            }
            if (this.userHasMagnificationServicesLocked(userState)) {
                flags |= 0x20;
            }
            if (userState.isHandlingAccessibilityEvents() && userState.mIsTouchExplorationEnabled) {
                flags |= 2;
            }
            if (userState.mIsFilterKeyEventsEnabled) {
                flags |= 4;
            }
            if (userState.mIsAutoclickEnabled) {
                flags |= 8;
            }
            if (userState.mIsPerformGesturesEnabled) {
                flags |= 0x10;
            }
            if (flags != 0) {
                if (!this.mHasInputFilter) {
                    this.mHasInputFilter = true;
                    if (this.mInputFilter == null) {
                        this.mInputFilter = new AccessibilityInputFilter(this.mContext, this);
                    }
                    inputFilter = this.mInputFilter;
                    setInputFilter = true;
                }
                this.mInputFilter.setUserAndEnabledFeatures(userState.mUserId, flags);
            } else if (this.mHasInputFilter) {
                this.mHasInputFilter = false;
                this.mInputFilter.setUserAndEnabledFeatures(userState.mUserId, 0);
                inputFilter = null;
                setInputFilter = true;
            }
        }
        if (setInputFilter) {
            this.mWindowManagerService.setInputFilter(inputFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showEnableTouchExplorationDialog(final Service service) {
        Object object = this.mLock;
        synchronized (object) {
            String label = service.mResolveInfo.loadLabel(this.mContext.getPackageManager()).toString();
            final UserState state = this.getCurrentUserStateLocked();
            if (state.mIsTouchExplorationEnabled) {
                return;
            }
            if (this.mEnableTouchExplorationDialog != null && this.mEnableTouchExplorationDialog.isShowing()) {
                return;
            }
            this.mEnableTouchExplorationDialog = new AlertDialog.Builder(this.mContext).setIconAttribute(16843605).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    state.mTouchExplorationGrantedServices.add(service.mComponentName);
                    AccessibilityManagerService.this.persistComponentNamesToSettingLocked("touch_exploration_granted_accessibility_services", state.mTouchExplorationGrantedServices, state.mUserId);
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(service.mUserId);
                    userState.mIsTouchExplorationEnabled = true;
                    long identity = Binder.clearCallingIdentity();
                    try {
                        Settings.Secure.putIntForUser(AccessibilityManagerService.this.mContext.getContentResolver(), "touch_exploration_enabled", 1, service.mUserId);
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                    AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).setTitle(17039802).setMessage(this.mContext.getString(17039801, label)).create();
            this.mEnableTouchExplorationDialog.getWindow().setType(2003);
            this.mEnableTouchExplorationDialog.getWindow().getAttributes().privateFlags |= 0x10;
            this.mEnableTouchExplorationDialog.setCanceledOnTouchOutside(true);
            this.mEnableTouchExplorationDialog.show();
        }
    }

    private void onUserStateChangedLocked(UserState userState) {
        this.mInitialized = true;
        this.updateLegacyCapabilitiesLocked(userState);
        this.updateServicesLocked(userState);
        this.updateAccessibilityShortcutLocked(userState);
        this.updateWindowsForAccessibilityCallbackLocked(userState);
        this.updateAccessibilityFocusBehaviorLocked(userState);
        this.updateFilterKeyEventsLocked(userState);
        this.updateTouchExplorationLocked(userState);
        this.updatePerformGesturesLocked(userState);
        this.updateDisplayDaltonizerLocked(userState);
        this.updateDisplayInversionLocked(userState);
        this.updateMagnificationLocked(userState);
        this.updateSoftKeyboardShowModeLocked(userState);
        this.scheduleUpdateFingerprintGestureHandling(userState);
        this.scheduleUpdateInputFilter(userState);
        this.scheduleUpdateClientsIfNeededLocked(userState);
        this.updateRelevantEventsLocked(userState);
        this.updateAccessibilityButtonTargetsLocked(userState);
    }

    private void updateAccessibilityFocusBehaviorLocked(UserState userState) {
        CopyOnWriteArrayList<Service> boundServices = userState.mBoundServices;
        int boundServiceCount = boundServices.size();
        for (int i = 0; i < boundServiceCount; ++i) {
            Service boundService = (Service)boundServices.get(i);
            if (!boundService.canRetrieveInteractiveWindowsLocked()) continue;
            userState.mAccessibilityFocusOnlyInActiveWindow = false;
            return;
        }
        userState.mAccessibilityFocusOnlyInActiveWindow = true;
    }

    private void updateWindowsForAccessibilityCallbackLocked(UserState userState) {
        CopyOnWriteArrayList<Service> boundServices = userState.mBoundServices;
        int boundServiceCount = boundServices.size();
        for (int i = 0; i < boundServiceCount; ++i) {
            Service boundService = (Service)boundServices.get(i);
            if (!boundService.canRetrieveInteractiveWindowsLocked()) continue;
            if (this.mWindowsForAccessibilityCallback == null) {
                this.mWindowsForAccessibilityCallback = new WindowsForAccessibilityCallback();
                this.mWindowManagerService.setWindowsForAccessibilityCallback(this.mWindowsForAccessibilityCallback);
            }
            return;
        }
        if (this.mWindowsForAccessibilityCallback != null) {
            this.mWindowsForAccessibilityCallback = null;
            this.mWindowManagerService.setWindowsForAccessibilityCallback(null);
            this.mSecurityPolicy.clearWindowsLocked();
        }
    }

    private void updateLegacyCapabilitiesLocked(UserState userState) {
        int installedServiceCount = userState.mInstalledServices.size();
        for (int i = 0; i < installedServiceCount; ++i) {
            ComponentName componentName;
            AccessibilityServiceInfo serviceInfo = userState.mInstalledServices.get(i);
            ResolveInfo resolveInfo = serviceInfo.getResolveInfo();
            if ((serviceInfo.getCapabilities() & 2) != 0 || resolveInfo.serviceInfo.applicationInfo.targetSdkVersion > 17 || !userState.mTouchExplorationGrantedServices.contains(componentName = new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name))) continue;
            serviceInfo.setCapabilities(serviceInfo.getCapabilities() | 2);
        }
    }

    private void updatePerformGesturesLocked(UserState userState) {
        int serviceCount = userState.mBoundServices.size();
        for (int i = 0; i < serviceCount; ++i) {
            Service service = userState.mBoundServices.get(i);
            if ((service.mAccessibilityServiceInfo.getCapabilities() & 0x20) == 0) continue;
            userState.mIsPerformGesturesEnabled = true;
            return;
        }
        userState.mIsPerformGesturesEnabled = false;
    }

    private void updateFilterKeyEventsLocked(UserState userState) {
        int serviceCount = userState.mBoundServices.size();
        for (int i = 0; i < serviceCount; ++i) {
            Service service = userState.mBoundServices.get(i);
            if (!service.mRequestFilterKeyEvents || (service.mAccessibilityServiceInfo.getCapabilities() & 8) == 0) continue;
            userState.mIsFilterKeyEventsEnabled = true;
            return;
        }
        userState.mIsFilterKeyEventsEnabled = false;
    }

    private boolean readConfigurationForUserStateLocked(UserState userState) {
        boolean somethingChanged = this.readInstalledAccessibilityServiceLocked(userState);
        somethingChanged |= this.readEnabledAccessibilityServicesLocked(userState);
        somethingChanged |= this.readTouchExplorationGrantedAccessibilityServicesLocked(userState);
        somethingChanged |= this.readTouchExplorationEnabledSettingLocked(userState);
        somethingChanged |= this.readHighTextContrastEnabledSettingLocked(userState);
        somethingChanged |= this.readMagnificationEnabledSettingsLocked(userState);
        somethingChanged |= this.readAutoclickEnabledSettingLocked(userState);
        somethingChanged |= this.readAccessibilityShortcutSettingLocked(userState);
        return somethingChanged |= this.readAccessibilityButtonSettingsLocked(userState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccessibilityEnabledSetting(UserState userState) {
        long identity = Binder.clearCallingIdentity();
        try {
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_enabled", userState.isHandlingAccessibilityEvents() ? 1 : 0, userState.mUserId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private boolean readTouchExplorationEnabledSettingLocked(UserState userState) {
        boolean touchExplorationEnabled;
        boolean bl = touchExplorationEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "touch_exploration_enabled", 0, userState.mUserId) == 1;
        if (touchExplorationEnabled != userState.mIsTouchExplorationEnabled) {
            userState.mIsTouchExplorationEnabled = touchExplorationEnabled;
            return true;
        }
        return false;
    }

    private boolean readMagnificationEnabledSettingsLocked(UserState userState) {
        boolean navBarMagnificationEnabled;
        boolean displayMagnificationEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_display_magnification_enabled", 0, userState.mUserId) == 1;
        boolean bl = navBarMagnificationEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_display_magnification_navbar_enabled", 0, userState.mUserId) == 1;
        if (displayMagnificationEnabled != userState.mIsDisplayMagnificationEnabled || navBarMagnificationEnabled != userState.mIsNavBarMagnificationEnabled) {
            userState.mIsDisplayMagnificationEnabled = displayMagnificationEnabled;
            userState.mIsNavBarMagnificationEnabled = navBarMagnificationEnabled;
            return true;
        }
        return false;
    }

    private boolean readAutoclickEnabledSettingLocked(UserState userState) {
        boolean autoclickEnabled;
        boolean bl = autoclickEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_autoclick_enabled", 0, userState.mUserId) == 1;
        if (autoclickEnabled != userState.mIsAutoclickEnabled) {
            userState.mIsAutoclickEnabled = autoclickEnabled;
            return true;
        }
        return false;
    }

    private boolean readHighTextContrastEnabledSettingLocked(UserState userState) {
        boolean highTextContrastEnabled;
        boolean bl = highTextContrastEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "high_text_contrast_enabled", 0, userState.mUserId) == 1;
        if (highTextContrastEnabled != userState.mIsTextHighContrastEnabled) {
            userState.mIsTextHighContrastEnabled = highTextContrastEnabled;
            return true;
        }
        return false;
    }

    private boolean readSoftKeyboardShowModeChangedLocked(UserState userState) {
        int softKeyboardShowMode = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_soft_keyboard_mode", 0, userState.mUserId);
        if (softKeyboardShowMode != userState.mSoftKeyboardShowMode) {
            userState.mSoftKeyboardShowMode = softKeyboardShowMode;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTouchExplorationLocked(UserState userState) {
        boolean enabled = false;
        int serviceCount = userState.mBoundServices.size();
        for (int i = 0; i < serviceCount; ++i) {
            Service service = userState.mBoundServices.get(i);
            if (!this.canRequestAndRequestsTouchExplorationLocked(service)) continue;
            enabled = true;
            break;
        }
        if (enabled != userState.mIsTouchExplorationEnabled) {
            userState.mIsTouchExplorationEnabled = enabled;
            long identity = Binder.clearCallingIdentity();
            try {
                Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "touch_exploration_enabled", enabled ? 1 : 0, userState.mUserId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private boolean readAccessibilityShortcutSettingLocked(UserState userState) {
        String componentNameToEnableString = AccessibilityShortcutController.getTargetServiceComponentNameString(this.mContext, userState.mUserId);
        if (componentNameToEnableString == null || componentNameToEnableString.isEmpty()) {
            if (userState.mServiceToEnableWithShortcut == null) {
                return false;
            }
            userState.mServiceToEnableWithShortcut = null;
            return true;
        }
        ComponentName componentNameToEnable = ComponentName.unflattenFromString(componentNameToEnableString);
        if (componentNameToEnable != null && componentNameToEnable.equals(userState.mServiceToEnableWithShortcut)) {
            return false;
        }
        userState.mServiceToEnableWithShortcut = componentNameToEnable;
        return true;
    }

    private boolean readAccessibilityButtonSettingsLocked(UserState userState) {
        String componentId = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "accessibility_button_target_component", userState.mUserId);
        if (TextUtils.isEmpty(componentId)) {
            if (userState.mServiceAssignedToAccessibilityButton == null && !userState.mIsNavBarMagnificationAssignedToAccessibilityButton) {
                return false;
            }
            userState.mServiceAssignedToAccessibilityButton = null;
            userState.mIsNavBarMagnificationAssignedToAccessibilityButton = false;
            return true;
        }
        if (componentId.equals(MagnificationController.class.getName())) {
            if (userState.mIsNavBarMagnificationAssignedToAccessibilityButton) {
                return false;
            }
            userState.mServiceAssignedToAccessibilityButton = null;
            userState.mIsNavBarMagnificationAssignedToAccessibilityButton = true;
            return true;
        }
        ComponentName componentName = ComponentName.unflattenFromString(componentId);
        if (componentName.equals(userState.mServiceAssignedToAccessibilityButton)) {
            return false;
        }
        userState.mServiceAssignedToAccessibilityButton = componentName;
        userState.mIsNavBarMagnificationAssignedToAccessibilityButton = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccessibilityShortcutLocked(UserState userState) {
        if (userState.mServiceToEnableWithShortcut == null) {
            return;
        }
        boolean shortcutServiceIsInstalled = false;
        for (int i = 0; i < userState.mInstalledServices.size(); ++i) {
            if (!userState.mInstalledServices.get(i).getComponentName().equals(userState.mServiceToEnableWithShortcut)) continue;
            shortcutServiceIsInstalled = true;
        }
        if (!shortcutServiceIsInstalled) {
            userState.mServiceToEnableWithShortcut = null;
            long identity = Binder.clearCallingIdentity();
            try {
                Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "accessibility_shortcut_target_service", null, userState.mUserId);
                Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_shortcut_enabled", 0, userState.mUserId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private boolean canRequestAndRequestsTouchExplorationLocked(Service service) {
        if (!service.canReceiveEventsLocked() || !service.mRequestTouchExplorationMode) {
            return false;
        }
        if (service.mIsAutomation) {
            return true;
        }
        if (service.mResolveInfo.serviceInfo.applicationInfo.targetSdkVersion <= 17) {
            UserState userState = this.getUserStateLocked(service.mUserId);
            if (userState.mTouchExplorationGrantedServices.contains(service.mComponentName)) {
                return true;
            }
            if (this.mEnableTouchExplorationDialog == null || !this.mEnableTouchExplorationDialog.isShowing()) {
                this.mMainHandler.obtainMessage(7, service).sendToTarget();
            }
        } else if ((service.mAccessibilityServiceInfo.getCapabilities() & 2) != 0) {
            return true;
        }
        return false;
    }

    private void updateDisplayDaltonizerLocked(UserState userState) {
        DisplayAdjustmentUtils.applyDaltonizerSetting(this.mContext, userState.mUserId);
    }

    private void updateDisplayInversionLocked(UserState userState) {
        DisplayAdjustmentUtils.applyInversionSetting(this.mContext, userState.mUserId);
    }

    private void updateMagnificationLocked(UserState userState) {
        if (userState.mUserId != this.mCurrentUserId) {
            return;
        }
        if (userState.mIsDisplayMagnificationEnabled || userState.mIsNavBarMagnificationEnabled || this.userHasListeningMagnificationServicesLocked(userState)) {
            this.getMagnificationController();
            this.mMagnificationController.register();
        } else if (this.mMagnificationController != null) {
            this.mMagnificationController.unregister();
        }
    }

    private boolean userHasMagnificationServicesLocked(UserState userState) {
        CopyOnWriteArrayList<Service> services = userState.mBoundServices;
        int count = services.size();
        for (int i = 0; i < count; ++i) {
            Service service = (Service)services.get(i);
            if (!this.mSecurityPolicy.canControlMagnification(service)) continue;
            return true;
        }
        return false;
    }

    private boolean userHasListeningMagnificationServicesLocked(UserState userState) {
        CopyOnWriteArrayList<Service> services = userState.mBoundServices;
        int count = services.size();
        for (int i = 0; i < count; ++i) {
            Service service = (Service)services.get(i);
            if (!this.mSecurityPolicy.canControlMagnification(service) || !service.mInvocationHandler.mIsMagnificationCallbackEnabled) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSoftKeyboardShowModeLocked(UserState userState) {
        boolean serviceChangingSoftKeyboardModeIsEnabled;
        int userId = userState.mUserId;
        if (userId == this.mCurrentUserId && userState.mSoftKeyboardShowMode != 0 && !(serviceChangingSoftKeyboardModeIsEnabled = userState.mEnabledServices.contains(userState.mServiceChangingSoftKeyboardMode))) {
            long identity = Binder.clearCallingIdentity();
            try {
                Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_soft_keyboard_mode", 0, userState.mUserId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            userState.mSoftKeyboardShowMode = 0;
            userState.mServiceChangingSoftKeyboardMode = null;
            this.notifySoftKeyboardShowModeChangedLocked(userState.mSoftKeyboardShowMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFingerprintGestureHandling(UserState userState) {
        CopyOnWriteArrayList<Service> services;
        Object object = this.mLock;
        synchronized (object) {
            services = userState.mBoundServices;
            if (this.mFingerprintGestureDispatcher == null && this.mPackageManager.hasSystemFeature("android.hardware.fingerprint")) {
                int numServices = services.size();
                for (int i = 0; i < numServices; ++i) {
                    if (!((Service)services.get(i)).isCapturingFingerprintGestures()) continue;
                    long identity = Binder.clearCallingIdentity();
                    IFingerprintService service = null;
                    try {
                        service = IFingerprintService.Stub.asInterface(ServiceManager.getService("fingerprint"));
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                    if (service == null) continue;
                    this.mFingerprintGestureDispatcher = new FingerprintGestureDispatcher(service, this.mLock);
                    break;
                }
            }
        }
        if (this.mFingerprintGestureDispatcher != null) {
            this.mFingerprintGestureDispatcher.updateClientList(services);
        }
    }

    private void updateAccessibilityButtonTargetsLocked(UserState userState) {
        for (int i = userState.mBoundServices.size() - 1; i >= 0; --i) {
            Service service = userState.mBoundServices.get(i);
            if (!service.mRequestAccessibilityButton) continue;
            service.notifyAccessibilityButtonAvailabilityChangedLocked(service.isAccessibilityButtonAvailableLocked(userState));
        }
    }

    @GuardedBy(value="mLock")
    private MagnificationSpec getCompatibleMagnificationSpecLocked(int windowId) {
        IBinder windowToken = this.mGlobalWindowTokens.get(windowId);
        if (windowToken == null) {
            windowToken = this.getCurrentUserStateLocked().mWindowTokens.get(windowId);
        }
        if (windowToken != null) {
            return this.mWindowManagerService.getCompatibleMagnificationSpecForWindow(windowToken);
        }
        return null;
    }

    private KeyEventDispatcher getKeyEventDispatcher() {
        if (this.mKeyEventDispatcher == null) {
            this.mKeyEventDispatcher = new KeyEventDispatcher(this.mMainHandler, 8, this.mLock, this.mPowerManager);
        }
        return this.mKeyEventDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAccessibilityShortcut() {
        if (UserHandle.getAppId(Binder.getCallingUid()) != 1000 && this.mContext.checkCallingPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("performAccessibilityShortcut requires the WRITE_SECURE_SETTINGS permission");
        }
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getUserStateLocked(this.mCurrentUserId);
            ComponentName serviceName = userState.mServiceToEnableWithShortcut;
            if (serviceName == null) {
                return;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                if (userState.mComponentNameToServiceMap.get(serviceName) == null) {
                    this.enableAccessibilityServiceLocked(serviceName, this.mCurrentUserId);
                } else {
                    this.disableAccessibilityServiceLocked(serviceName, this.mCurrentUserId);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private void enableAccessibilityServiceLocked(ComponentName componentName, int userId) {
        SettingsStringUtil.SettingStringHelper setting = new SettingsStringUtil.SettingStringHelper(this.mContext.getContentResolver(), "enabled_accessibility_services", userId);
        setting.write(SettingsStringUtil.ComponentNameSet.add(setting.read(), componentName));
        UserState userState = this.getUserStateLocked(userId);
        if (userState.mEnabledServices.add(componentName)) {
            this.onUserStateChangedLocked(userState);
        }
    }

    private void disableAccessibilityServiceLocked(ComponentName componentName, int userId) {
        SettingsStringUtil.SettingStringHelper setting = new SettingsStringUtil.SettingStringHelper(this.mContext.getContentResolver(), "enabled_accessibility_services", userId);
        setting.write(SettingsStringUtil.ComponentNameSet.remove(setting.read(), componentName));
        UserState userState = this.getUserStateLocked(userId);
        if (userState.mEnabledServices.remove(componentName)) {
            this.onUserStateChangedLocked(userState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendFingerprintGesture(int gestureKeyCode) {
        Object object = this.mLock;
        synchronized (object) {
            if (UserHandle.getAppId(Binder.getCallingUid()) != 1000) {
                throw new SecurityException("Only SYSTEM can call sendFingerprintGesture");
            }
        }
        if (this.mFingerprintGestureDispatcher == null) {
            return false;
        }
        return this.mFingerprintGestureDispatcher.onFingerprintGesture(gestureKeyCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, LOG_TAG, pw)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.println("ACCESSIBILITY MANAGER (dumpsys accessibility)");
            pw.println();
            int userCount = this.mUserStates.size();
            for (int i = 0; i < userCount; ++i) {
                UserState userState = this.mUserStates.valueAt(i);
                pw.append("User state[attributes:{id=" + userState.mUserId);
                pw.append(", currentUser=" + (userState.mUserId == this.mCurrentUserId));
                pw.append(", touchExplorationEnabled=" + userState.mIsTouchExplorationEnabled);
                pw.append(", displayMagnificationEnabled=" + userState.mIsDisplayMagnificationEnabled);
                pw.append(", navBarMagnificationEnabled=" + userState.mIsNavBarMagnificationEnabled);
                pw.append(", autoclickEnabled=" + userState.mIsAutoclickEnabled);
                if (userState.mUiAutomationService != null) {
                    pw.append(", ");
                    userState.mUiAutomationService.dump(fd, pw, args);
                    pw.println();
                }
                pw.append("}");
                pw.println();
                pw.append("           services:{");
                int serviceCount = userState.mBoundServices.size();
                for (int j = 0; j < serviceCount; ++j) {
                    if (j > 0) {
                        pw.append(", ");
                        pw.println();
                        pw.append("                     ");
                    }
                    Service service = userState.mBoundServices.get(j);
                    service.dump(fd, pw, args);
                }
                pw.println("}]");
                pw.println();
            }
            if (this.mSecurityPolicy.mWindows != null) {
                int windowCount = this.mSecurityPolicy.mWindows.size();
                for (int j = 0; j < windowCount; ++j) {
                    if (j > 0) {
                        pw.append(',');
                        pw.println();
                    }
                    pw.append("Window[");
                    AccessibilityWindowInfo window = this.mSecurityPolicy.mWindows.get(j);
                    pw.append(window.toString());
                    pw.append(']');
                }
            }
        }
    }

    private int findWindowIdLocked(IBinder token) {
        int globalIndex = this.mGlobalWindowTokens.indexOfValue(token);
        if (globalIndex >= 0) {
            return this.mGlobalWindowTokens.keyAt(globalIndex);
        }
        UserState userState = this.getCurrentUserStateLocked();
        int userIndex = userState.mWindowTokens.indexOfValue(token);
        if (userIndex >= 0) {
            return userState.mWindowTokens.keyAt(userIndex);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWindowsAvailableTimed() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSecurityPolicy.mWindows != null) {
                return;
            }
            if (this.mWindowsForAccessibilityCallback == null) {
                UserState userState = this.getCurrentUserStateLocked();
                this.onUserStateChangedLocked(userState);
            }
            if (this.mWindowsForAccessibilityCallback == null) {
                return;
            }
            long startMillis = SystemClock.uptimeMillis();
            while (this.mSecurityPolicy.mWindows == null) {
                long elapsedMillis = SystemClock.uptimeMillis() - startMillis;
                long remainMillis = 5000L - elapsedMillis;
                if (remainMillis <= 0L) {
                    return;
                }
                try {
                    this.mLock.wait(remainMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MagnificationController getMagnificationController() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMagnificationController == null) {
                this.mMagnificationController = new MagnificationController(this.mContext, this, this.mLock);
                this.mMagnificationController.setUserId(this.mCurrentUserId);
            }
            return this.mMagnificationController;
        }
    }

    private final class AccessibilityContentObserver
    extends ContentObserver {
        private final Uri mTouchExplorationEnabledUri;
        private final Uri mDisplayMagnificationEnabledUri;
        private final Uri mNavBarMagnificationEnabledUri;
        private final Uri mAutoclickEnabledUri;
        private final Uri mEnabledAccessibilityServicesUri;
        private final Uri mTouchExplorationGrantedAccessibilityServicesUri;
        private final Uri mDisplayInversionEnabledUri;
        private final Uri mDisplayDaltonizerEnabledUri;
        private final Uri mDisplayDaltonizerUri;
        private final Uri mHighTextContrastUri;
        private final Uri mAccessibilitySoftKeyboardModeUri;
        private final Uri mAccessibilityShortcutServiceIdUri;
        private final Uri mAccessibilityButtonComponentIdUri;

        public AccessibilityContentObserver(Handler handler) {
            super(handler);
            this.mTouchExplorationEnabledUri = Settings.Secure.getUriFor("touch_exploration_enabled");
            this.mDisplayMagnificationEnabledUri = Settings.Secure.getUriFor("accessibility_display_magnification_enabled");
            this.mNavBarMagnificationEnabledUri = Settings.Secure.getUriFor("accessibility_display_magnification_navbar_enabled");
            this.mAutoclickEnabledUri = Settings.Secure.getUriFor("accessibility_autoclick_enabled");
            this.mEnabledAccessibilityServicesUri = Settings.Secure.getUriFor("enabled_accessibility_services");
            this.mTouchExplorationGrantedAccessibilityServicesUri = Settings.Secure.getUriFor("touch_exploration_granted_accessibility_services");
            this.mDisplayInversionEnabledUri = Settings.Secure.getUriFor("accessibility_display_inversion_enabled");
            this.mDisplayDaltonizerEnabledUri = Settings.Secure.getUriFor("accessibility_display_daltonizer_enabled");
            this.mDisplayDaltonizerUri = Settings.Secure.getUriFor("accessibility_display_daltonizer");
            this.mHighTextContrastUri = Settings.Secure.getUriFor("high_text_contrast_enabled");
            this.mAccessibilitySoftKeyboardModeUri = Settings.Secure.getUriFor("accessibility_soft_keyboard_mode");
            this.mAccessibilityShortcutServiceIdUri = Settings.Secure.getUriFor("accessibility_shortcut_target_service");
            this.mAccessibilityButtonComponentIdUri = Settings.Secure.getUriFor("accessibility_button_target_component");
        }

        public void register(ContentResolver contentResolver) {
            contentResolver.registerContentObserver(this.mTouchExplorationEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayMagnificationEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mNavBarMagnificationEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mAutoclickEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mEnabledAccessibilityServicesUri, false, this, -1);
            contentResolver.registerContentObserver(this.mTouchExplorationGrantedAccessibilityServicesUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayInversionEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayDaltonizerEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayDaltonizerUri, false, this, -1);
            contentResolver.registerContentObserver(this.mHighTextContrastUri, false, this, -1);
            contentResolver.registerContentObserver(this.mAccessibilitySoftKeyboardModeUri, false, this, -1);
            contentResolver.registerContentObserver(this.mAccessibilityShortcutServiceIdUri, false, this, -1);
            contentResolver.registerContentObserver(this.mAccessibilityButtonComponentIdUri, false, this, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                if (userState.isUiAutomationSuppressingOtherServices()) {
                    return;
                }
                if (this.mTouchExplorationEnabledUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readTouchExplorationEnabledSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mDisplayMagnificationEnabledUri.equals(uri) || this.mNavBarMagnificationEnabledUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readMagnificationEnabledSettingsLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mAutoclickEnabledUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readAutoclickEnabledSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mEnabledAccessibilityServicesUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readEnabledAccessibilityServicesLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mTouchExplorationGrantedAccessibilityServicesUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readTouchExplorationGrantedAccessibilityServicesLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mDisplayDaltonizerEnabledUri.equals(uri) || this.mDisplayDaltonizerUri.equals(uri)) {
                    AccessibilityManagerService.this.updateDisplayDaltonizerLocked(userState);
                } else if (this.mDisplayInversionEnabledUri.equals(uri)) {
                    AccessibilityManagerService.this.updateDisplayInversionLocked(userState);
                } else if (this.mHighTextContrastUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readHighTextContrastEnabledSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mAccessibilitySoftKeyboardModeUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readSoftKeyboardShowModeChangedLocked(userState)) {
                        AccessibilityManagerService.this.notifySoftKeyboardShowModeChangedLocked(userState.mSoftKeyboardShowMode);
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mAccessibilityShortcutServiceIdUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readAccessibilityShortcutSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mAccessibilityButtonComponentIdUri.equals(uri) && AccessibilityManagerService.this.readAccessibilityButtonSettingsLocked(userState)) {
                    AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                }
            }
        }
    }

    private class UserState {
        public final int mUserId;
        public final RemoteCallbackList<IAccessibilityManagerClient> mUserClients = new RemoteCallbackList();
        public final SparseArray<AccessibilityConnectionWrapper> mInteractionConnections = new SparseArray();
        public final SparseArray<IBinder> mWindowTokens = new SparseArray();
        public final CopyOnWriteArrayList<Service> mBoundServices = new CopyOnWriteArrayList();
        public int mLastSentRelevantEventTypes = -1;
        public final Map<ComponentName, Service> mComponentNameToServiceMap = new HashMap<ComponentName, Service>();
        public final List<AccessibilityServiceInfo> mInstalledServices = new ArrayList<AccessibilityServiceInfo>();
        public final Set<ComponentName> mBindingServices = new HashSet<ComponentName>();
        public final Set<ComponentName> mEnabledServices = new HashSet<ComponentName>();
        public final Set<ComponentName> mTouchExplorationGrantedServices = new HashSet<ComponentName>();
        public ComponentName mServiceChangingSoftKeyboardMode;
        public ComponentName mServiceToEnableWithShortcut;
        public int mLastSentClientState = -1;
        public int mSoftKeyboardShowMode = 0;
        public boolean mIsNavBarMagnificationAssignedToAccessibilityButton;
        public ComponentName mServiceAssignedToAccessibilityButton;
        public boolean mIsTouchExplorationEnabled;
        public boolean mIsTextHighContrastEnabled;
        public boolean mIsDisplayMagnificationEnabled;
        public boolean mIsNavBarMagnificationEnabled;
        public boolean mIsAutoclickEnabled;
        public boolean mIsPerformGesturesEnabled;
        public boolean mIsFilterKeyEventsEnabled;
        public boolean mAccessibilityFocusOnlyInActiveWindow;
        private Service mUiAutomationService;
        private int mUiAutomationFlags;
        private IAccessibilityServiceClient mUiAutomationServiceClient;
        private IBinder mUiAutomationServiceOwner;
        private final IBinder.DeathRecipient mUiAutomationSerivceOnwerDeathRecipient = new IBinder.DeathRecipient(){

            @Override
            public void binderDied() {
                UserState.this.mUiAutomationServiceOwner.unlinkToDeath(UserState.this.mUiAutomationSerivceOnwerDeathRecipient, 0);
                UserState.this.mUiAutomationServiceOwner = null;
                if (UserState.this.mUiAutomationService != null) {
                    UserState.this.mUiAutomationService.binderDied();
                }
            }
        };

        public UserState(int userId) {
            this.mUserId = userId;
        }

        public int getClientState() {
            int clientState = 0;
            if (this.isHandlingAccessibilityEvents()) {
                clientState |= 1;
            }
            if (this.isHandlingAccessibilityEvents() && this.mIsTouchExplorationEnabled) {
                clientState |= 2;
            }
            if (this.mIsTextHighContrastEnabled) {
                clientState |= 4;
            }
            return clientState;
        }

        public boolean isHandlingAccessibilityEvents() {
            return !this.mBoundServices.isEmpty() || !this.mBindingServices.isEmpty();
        }

        public void onSwitchToAnotherUser() {
            if (this.mUiAutomationService != null) {
                this.mUiAutomationService.binderDied();
            }
            AccessibilityManagerService.this.unbindAllServicesLocked(this);
            this.mBoundServices.clear();
            this.mBindingServices.clear();
            this.mLastSentClientState = -1;
            this.mEnabledServices.clear();
            this.mTouchExplorationGrantedServices.clear();
            this.mIsTouchExplorationEnabled = false;
            this.mIsDisplayMagnificationEnabled = false;
            this.mIsNavBarMagnificationEnabled = false;
            this.mServiceAssignedToAccessibilityButton = null;
            this.mIsNavBarMagnificationAssignedToAccessibilityButton = false;
            this.mIsAutoclickEnabled = false;
            this.mSoftKeyboardShowMode = 0;
        }

        public void destroyUiAutomationService() {
            this.mUiAutomationService = null;
            this.mUiAutomationFlags = 0;
            this.mUiAutomationServiceClient = null;
            if (this.mUiAutomationServiceOwner != null) {
                this.mUiAutomationServiceOwner.unlinkToDeath(this.mUiAutomationSerivceOnwerDeathRecipient, 0);
                this.mUiAutomationServiceOwner = null;
            }
        }

        boolean isUiAutomationSuppressingOtherServices() {
            return this.mUiAutomationService != null && (this.mUiAutomationFlags & 1) == 0;
        }
    }

    final class SecurityPolicy {
        public static final int INVALID_WINDOW_ID = -1;
        private static final int RETRIEVAL_ALLOWING_EVENT_TYPES = 244159;
        public List<AccessibilityWindowInfo> mWindows;
        public SparseArray<AccessibilityWindowInfo> mWindowsById = new SparseArray();
        public int mActiveWindowId = -1;
        public int mFocusedWindowId = -1;
        public int mAccessibilityFocusedWindowId = -1;
        public long mAccessibilityFocusNodeId = Integer.MAX_VALUE;
        private boolean mTouchInteractionInProgress;

        SecurityPolicy() {
        }

        private boolean canDispatchAccessibilityEventLocked(AccessibilityEvent event) {
            int eventType = event.getEventType();
            switch (eventType) {
                case 32: 
                case 64: 
                case 128: 
                case 256: 
                case 512: 
                case 1024: 
                case 16384: 
                case 262144: 
                case 524288: 
                case 0x100000: 
                case 0x200000: 
                case 0x400000: 
                case 0x1000000: {
                    return true;
                }
            }
            return this.isRetrievalAllowingWindow(event.getWindowId());
        }

        public void clearWindowsLocked() {
            List<AccessibilityWindowInfo> windows = Collections.emptyList();
            int activeWindowId = this.mActiveWindowId;
            this.updateWindowsLocked(windows);
            this.mActiveWindowId = activeWindowId;
            this.mWindows = null;
        }

        public void updateWindowsLocked(List<AccessibilityWindowInfo> windows) {
            if (this.mWindows == null) {
                this.mWindows = new ArrayList<AccessibilityWindowInfo>();
            }
            int oldWindowCount = this.mWindows.size();
            for (int i = oldWindowCount - 1; i >= 0; --i) {
                this.mWindows.remove(i).recycle();
            }
            this.mWindowsById.clear();
            this.mFocusedWindowId = -1;
            if (!this.mTouchInteractionInProgress) {
                this.mActiveWindowId = -1;
            }
            boolean activeWindowGone = true;
            int windowCount = windows.size();
            if (windowCount > 0) {
                AccessibilityWindowInfo window;
                int i;
                for (i = 0; i < windowCount; ++i) {
                    window = windows.get(i);
                    int windowId = window.getId();
                    if (window.isFocused()) {
                        this.mFocusedWindowId = windowId;
                        if (!this.mTouchInteractionInProgress) {
                            this.mActiveWindowId = windowId;
                            window.setActive(true);
                        } else if (windowId == this.mActiveWindowId) {
                            activeWindowGone = false;
                        }
                    }
                    this.mWindows.add(window);
                    this.mWindowsById.put(windowId, window);
                }
                if (this.mTouchInteractionInProgress && activeWindowGone) {
                    this.mActiveWindowId = this.mFocusedWindowId;
                }
                for (i = 0; i < windowCount; ++i) {
                    window = this.mWindows.get(i);
                    if (window.getId() == this.mActiveWindowId) {
                        window.setActive(true);
                    }
                    if (window.getId() != this.mAccessibilityFocusedWindowId) continue;
                    window.setAccessibilityFocused(true);
                }
            }
            this.notifyWindowsChanged();
        }

        public boolean computePartialInteractiveRegionForWindowLocked(int windowId, Region outRegion) {
            if (this.mWindows == null) {
                return false;
            }
            Region windowInteractiveRegion = null;
            boolean windowInteractiveRegionChanged = false;
            int windowCount = this.mWindows.size();
            for (int i = windowCount - 1; i >= 0; --i) {
                Rect currentWindowBounds;
                AccessibilityWindowInfo currentWindow = this.mWindows.get(i);
                if (windowInteractiveRegion == null) {
                    if (currentWindow.getId() != windowId) continue;
                    currentWindowBounds = AccessibilityManagerService.this.mTempRect;
                    currentWindow.getBoundsInScreen(currentWindowBounds);
                    outRegion.set(currentWindowBounds);
                    windowInteractiveRegion = outRegion;
                    continue;
                }
                if (currentWindow.getType() == 4) continue;
                currentWindowBounds = AccessibilityManagerService.this.mTempRect;
                currentWindow.getBoundsInScreen(currentWindowBounds);
                if (!windowInteractiveRegion.op(currentWindowBounds, Region.Op.DIFFERENCE)) continue;
                windowInteractiveRegionChanged = true;
            }
            return windowInteractiveRegionChanged;
        }

        public void updateEventSourceLocked(AccessibilityEvent event) {
            if ((event.getEventType() & 0x3B9BF) == 0) {
                event.setSource((View)null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateActiveAndAccessibilityFocusedWindowLocked(int windowId, long nodeId, int eventType, int eventAction) {
            switch (eventType) {
                case 32: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (AccessibilityManagerService.this.mWindowsForAccessibilityCallback == null) {
                            this.mFocusedWindowId = this.getFocusedWindowId();
                            if (windowId == this.mFocusedWindowId) {
                                this.mActiveWindowId = windowId;
                            }
                        }
                        break;
                    }
                }
                case 128: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (this.mTouchInteractionInProgress && this.mActiveWindowId != windowId) {
                            this.setActiveWindowLocked(windowId);
                        }
                        break;
                    }
                }
                case 32768: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (this.mAccessibilityFocusedWindowId != windowId) {
                            AccessibilityManagerService.this.mMainHandler.obtainMessage(9, this.mAccessibilityFocusedWindowId, 0).sendToTarget();
                            AccessibilityManagerService.this.mSecurityPolicy.setAccessibilityFocusedWindowLocked(windowId);
                            this.mAccessibilityFocusNodeId = nodeId;
                        }
                        break;
                    }
                }
                case 65536: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (this.mAccessibilityFocusNodeId == nodeId) {
                            this.mAccessibilityFocusNodeId = Integer.MAX_VALUE;
                        }
                        if (this.mAccessibilityFocusNodeId == Integer.MAX_VALUE && this.mAccessibilityFocusedWindowId == windowId && eventAction != 64) {
                            this.mAccessibilityFocusedWindowId = -1;
                        }
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTouchInteractionStart() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                this.mTouchInteractionInProgress = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTouchInteractionEnd() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                this.mTouchInteractionInProgress = false;
                int oldActiveWindow = ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mActiveWindowId;
                this.setActiveWindowLocked(this.mFocusedWindowId);
                if (oldActiveWindow != ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mActiveWindowId && this.mAccessibilityFocusedWindowId == oldActiveWindow && ((AccessibilityManagerService)AccessibilityManagerService.this).getCurrentUserStateLocked().mAccessibilityFocusOnlyInActiveWindow) {
                    AccessibilityManagerService.this.mMainHandler.obtainMessage(9, oldActiveWindow, 0).sendToTarget();
                }
            }
        }

        public int getActiveWindowId() {
            if (this.mActiveWindowId == -1 && !this.mTouchInteractionInProgress) {
                this.mActiveWindowId = this.getFocusedWindowId();
            }
            return this.mActiveWindowId;
        }

        private void setActiveWindowLocked(int windowId) {
            if (this.mActiveWindowId != windowId) {
                this.mActiveWindowId = windowId;
                if (this.mWindows != null) {
                    int windowCount = this.mWindows.size();
                    for (int i = 0; i < windowCount; ++i) {
                        AccessibilityWindowInfo window;
                        window.setActive((window = this.mWindows.get(i)).getId() == windowId);
                    }
                }
                this.notifyWindowsChanged();
            }
        }

        private void setAccessibilityFocusedWindowLocked(int windowId) {
            if (this.mAccessibilityFocusedWindowId != windowId) {
                this.mAccessibilityFocusedWindowId = windowId;
                if (this.mWindows != null) {
                    int windowCount = this.mWindows.size();
                    for (int i = 0; i < windowCount; ++i) {
                        AccessibilityWindowInfo window;
                        window.setAccessibilityFocused((window = this.mWindows.get(i)).getId() == windowId);
                    }
                }
                this.notifyWindowsChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyWindowsChanged() {
            if (AccessibilityManagerService.this.mWindowsForAccessibilityCallback == null) {
                return;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                AccessibilityEvent event = AccessibilityEvent.obtain(0x400000);
                event.setEventTime(SystemClock.uptimeMillis());
                AccessibilityManagerService.this.sendAccessibilityEvent(event, AccessibilityManagerService.this.mCurrentUserId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        public boolean canGetAccessibilityNodeInfoLocked(Service service, int windowId) {
            return this.canRetrieveWindowContentLocked(service) && this.isRetrievalAllowingWindow(windowId);
        }

        public boolean canRetrieveWindowsLocked(Service service) {
            return this.canRetrieveWindowContentLocked(service) && service.mRetrieveInteractiveWindows;
        }

        public boolean canRetrieveWindowContentLocked(Service service) {
            return (service.mAccessibilityServiceInfo.getCapabilities() & 1) != 0;
        }

        public boolean canControlMagnification(Service service) {
            return (service.mAccessibilityServiceInfo.getCapabilities() & 0x10) != 0;
        }

        public boolean canPerformGestures(Service service) {
            return (service.mAccessibilityServiceInfo.getCapabilities() & 0x20) != 0;
        }

        public boolean canCaptureFingerprintGestures(Service service) {
            return (service.mAccessibilityServiceInfo.getCapabilities() & 0x40) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int resolveProfileParentLocked(int userId) {
            if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                long identity = Binder.clearCallingIdentity();
                try {
                    UserInfo parent = AccessibilityManagerService.this.mUserManager.getProfileParent(userId);
                    if (parent != null) {
                        int n = parent.getUserHandle().getIdentifier();
                        return n;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return userId;
        }

        public int resolveCallingUserIdEnforcingPermissionsLocked(int userId) {
            int callingUid = Binder.getCallingUid();
            if (callingUid == 0 || callingUid == 1000 || callingUid == 2000) {
                if (userId == -2 || userId == -3) {
                    return AccessibilityManagerService.this.mCurrentUserId;
                }
                return this.resolveProfileParentLocked(userId);
            }
            int callingUserId = UserHandle.getUserId(callingUid);
            if (callingUserId == userId) {
                return this.resolveProfileParentLocked(userId);
            }
            int callingUserParentId = this.resolveProfileParentLocked(callingUserId);
            if (callingUserParentId == AccessibilityManagerService.this.mCurrentUserId && (userId == -2 || userId == -3)) {
                return AccessibilityManagerService.this.mCurrentUserId;
            }
            if (!this.hasPermission("android.permission.INTERACT_ACROSS_USERS") && !this.hasPermission("android.permission.INTERACT_ACROSS_USERS_FULL")) {
                throw new SecurityException("Call from user " + callingUserId + " as user " + userId + " without permission INTERACT_ACROSS_USERS or " + "INTERACT_ACROSS_USERS_FULL not allowed.");
            }
            if (userId == -2 || userId == -3) {
                return AccessibilityManagerService.this.mCurrentUserId;
            }
            throw new IllegalArgumentException("Calling user can be changed to only UserHandle.USER_CURRENT or UserHandle.USER_CURRENT_OR_SELF.");
        }

        public boolean isCallerInteractingAcrossUsers(int userId) {
            int callingUid = Binder.getCallingUid();
            return Binder.getCallingPid() == Process.myPid() || callingUid == 2000 || userId == -2 || userId == -3;
        }

        private boolean isRetrievalAllowingWindow(int windowId) {
            if (Binder.getCallingUid() == 1000) {
                return true;
            }
            if (windowId == this.mActiveWindowId) {
                return true;
            }
            return this.findWindowById(windowId) != null;
        }

        private AccessibilityWindowInfo findWindowById(int windowId) {
            return this.mWindowsById.get(windowId);
        }

        private AccessibilityWindowInfo getPictureInPictureWindow() {
            if (this.mWindows != null) {
                int windowCount = this.mWindows.size();
                for (int i = 0; i < windowCount; ++i) {
                    AccessibilityWindowInfo window = this.mWindows.get(i);
                    if (!window.inPictureInPicture()) continue;
                    return window;
                }
            }
            return null;
        }

        private void enforceCallingPermission(String permission2, String function) {
            if (OWN_PROCESS_ID == Binder.getCallingPid()) {
                return;
            }
            if (!this.hasPermission(permission2)) {
                throw new SecurityException("You do not have " + permission2 + " required to call " + function + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            }
        }

        private boolean hasPermission(String permission2) {
            return AccessibilityManagerService.this.mContext.checkCallingPermission(permission2) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getFocusedWindowId() {
            IBinder token = AccessibilityManagerService.this.mWindowManagerService.getFocusedWindowToken();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                return AccessibilityManagerService.this.findWindowIdLocked(token);
            }
        }
    }

    private final class InteractionBridge {
        private final Display mDefaultDisplay;
        private final int mConnectionId;
        private final AccessibilityInteractionClient mClient;

        public InteractionBridge() {
            AccessibilityServiceInfo info = new AccessibilityServiceInfo();
            info.setCapabilities(1);
            info.flags |= 0x40;
            info.flags |= 2;
            Service service = new Service(-10000, sFakeAccessibilityServiceComponentName, info);
            this.mConnectionId = service.mId;
            this.mClient = AccessibilityInteractionClient.getInstance();
            this.mClient.addConnection(this.mConnectionId, service);
            DisplayManager displayManager = (DisplayManager)AccessibilityManagerService.this.mContext.getSystemService("display");
            this.mDefaultDisplay = displayManager.getDisplay(0);
        }

        public void clearAccessibilityFocusNotLocked(int windowId) {
            AccessibilityNodeInfo focus = this.getAccessibilityFocusNotLocked(windowId);
            if (focus != null) {
                focus.performAction(128);
            }
        }

        public boolean performActionOnAccessibilityFocusedItemNotLocked(AccessibilityNodeInfo.AccessibilityAction action) {
            AccessibilityNodeInfo focus = this.getAccessibilityFocusNotLocked();
            if (focus == null || !focus.getActionList().contains(action)) {
                return false;
            }
            return focus.performAction(action.getId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getAccessibilityFocusClickPointInScreenNotLocked(Point outPoint) {
            AccessibilityNodeInfo focus = this.getAccessibilityFocusNotLocked();
            if (focus == null) {
                return false;
            }
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                Rect boundsInScreen = AccessibilityManagerService.this.mTempRect;
                focus.getBoundsInScreen(boundsInScreen);
                MagnificationSpec spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(focus.getWindowId());
                if (spec != null && !spec.isNop()) {
                    boundsInScreen.offset((int)(-spec.offsetX), (int)(-spec.offsetY));
                    boundsInScreen.scale(1.0f / spec.scale);
                }
                Rect windowBounds = AccessibilityManagerService.this.mTempRect1;
                AccessibilityManagerService.this.getWindowBounds(focus.getWindowId(), windowBounds);
                if (!boundsInScreen.intersect(windowBounds)) {
                    return false;
                }
                Point screenSize = AccessibilityManagerService.this.mTempPoint;
                this.mDefaultDisplay.getRealSize(screenSize);
                if (!boundsInScreen.intersect(0, 0, screenSize.x, screenSize.y)) {
                    return false;
                }
                outPoint.set(boundsInScreen.centerX(), boundsInScreen.centerY());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AccessibilityNodeInfo getAccessibilityFocusNotLocked() {
            int focusedWindowId;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                focusedWindowId = ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mAccessibilityFocusedWindowId;
                if (focusedWindowId == -1) {
                    return null;
                }
            }
            return this.getAccessibilityFocusNotLocked(focusedWindowId);
        }

        private AccessibilityNodeInfo getAccessibilityFocusNotLocked(int windowId) {
            return this.mClient.findFocus(this.mConnectionId, windowId, AccessibilityNodeInfo.ROOT_NODE_ID, 2);
        }
    }

    final class WindowsForAccessibilityCallback
    implements WindowManagerInternal.WindowsForAccessibilityCallback {
        WindowsForAccessibilityCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWindowsForAccessibilityChanged(List<WindowInfo> windows) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                ArrayList<AccessibilityWindowInfo> reportedWindows = new ArrayList<AccessibilityWindowInfo>();
                int receivedWindowCount = windows.size();
                for (int i = 0; i < receivedWindowCount; ++i) {
                    WindowInfo receivedWindow = windows.get(i);
                    AccessibilityWindowInfo reportedWindow = this.populateReportedWindow(receivedWindow);
                    if (reportedWindow == null) continue;
                    reportedWindows.add(reportedWindow);
                }
                AccessibilityManagerService.this.mSecurityPolicy.updateWindowsLocked(reportedWindows);
                AccessibilityManagerService.this.mLock.notifyAll();
            }
        }

        private AccessibilityWindowInfo populateReportedWindow(WindowInfo window) {
            int windowId = AccessibilityManagerService.this.findWindowIdLocked(window.token);
            if (windowId < 0) {
                return null;
            }
            AccessibilityWindowInfo reportedWindow = AccessibilityWindowInfo.obtain();
            reportedWindow.setId(windowId);
            reportedWindow.setType(this.getTypeForWindowManagerWindowType(window.type));
            reportedWindow.setLayer(window.layer);
            reportedWindow.setFocused(window.focused);
            reportedWindow.setBoundsInScreen(window.boundsInScreen);
            reportedWindow.setTitle(window.title);
            reportedWindow.setAnchorId(window.accessibilityIdOfAnchor);
            reportedWindow.setPictureInPicture(window.inPictureInPicture);
            int parentId = AccessibilityManagerService.this.findWindowIdLocked(window.parentToken);
            if (parentId >= 0) {
                reportedWindow.setParentId(parentId);
            }
            if (window.childTokens != null) {
                int childCount = window.childTokens.size();
                for (int i = 0; i < childCount; ++i) {
                    IBinder childToken = window.childTokens.get(i);
                    int childId = AccessibilityManagerService.this.findWindowIdLocked(childToken);
                    if (childId < 0) continue;
                    reportedWindow.addChild(childId);
                }
            }
            return reportedWindow;
        }

        private int getTypeForWindowManagerWindowType(int windowType) {
            switch (windowType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 1000: 
                case 1001: 
                case 1002: 
                case 1003: 
                case 1005: 
                case 2002: 
                case 2005: 
                case 2007: {
                    return 1;
                }
                case 2011: 
                case 2012: {
                    return 2;
                }
                case 2000: 
                case 2001: 
                case 2003: 
                case 2006: 
                case 2008: 
                case 2009: 
                case 2010: 
                case 2014: 
                case 2017: 
                case 2019: 
                case 2020: 
                case 2024: 
                case 2036: 
                case 2038: {
                    return 3;
                }
                case 2034: {
                    return 5;
                }
                case 2032: {
                    return 4;
                }
            }
            return -1;
        }
    }

    class Service
    extends IAccessibilityServiceConnection.Stub
    implements ServiceConnection,
    IBinder.DeathRecipient,
    KeyEventDispatcher.KeyEventFilter,
    FingerprintGestureDispatcher.FingerprintGestureClient {
        final int mUserId;
        int mId = 0;
        AccessibilityServiceInfo mAccessibilityServiceInfo;
        IBinder mService;
        IAccessibilityServiceClient mServiceInterface;
        int mEventTypes;
        int mFeedbackType;
        Set<String> mPackageNames = new HashSet<String>();
        boolean mIsDefault;
        boolean mRequestTouchExplorationMode;
        boolean mRequestFilterKeyEvents;
        boolean mRetrieveInteractiveWindows;
        boolean mCaptureFingerprintGestures;
        boolean mRequestAccessibilityButton;
        boolean mReceivedAccessibilityButtonCallbackSinceBind;
        boolean mLastAccessibilityButtonCallbackState;
        int mFetchFlags;
        long mNotificationTimeout;
        ComponentName mComponentName;
        Intent mIntent;
        boolean mIsAutomation;
        final ResolveInfo mResolveInfo;
        final IBinder mOverlayWindowToken = new Binder();
        final SparseArray<AccessibilityEvent> mPendingEvents = new SparseArray();
        boolean mWasConnectedAndDied;
        boolean mUsesAccessibilityCache = false;
        public Handler mEventDispatchHandler = new Handler(AccessibilityManagerService.access$3300(AccessibilityManagerService.this).getLooper()){

            @Override
            public void handleMessage(Message message) {
                int eventType = message.what;
                AccessibilityEvent event = (AccessibilityEvent)message.obj;
                boolean serviceWantsEvent = message.arg1 != 0;
                Service.this.notifyAccessibilityEventInternal(eventType, event, serviceWantsEvent);
            }
        };
        public final InvocationHandler mInvocationHandler = new InvocationHandler(AccessibilityManagerService.access$3300(AccessibilityManagerService.this).getLooper());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Service(int userId, ComponentName componentName, AccessibilityServiceInfo accessibilityServiceInfo) {
            this.mUserId = userId;
            this.mResolveInfo = accessibilityServiceInfo.getResolveInfo();
            this.mId = sIdCounter++;
            this.mComponentName = componentName;
            this.mAccessibilityServiceInfo = accessibilityServiceInfo;
            this.mIsAutomation = sFakeAccessibilityServiceComponentName.equals(componentName);
            if (!this.mIsAutomation) {
                this.mIntent = new Intent().setComponent(this.mComponentName);
                this.mIntent.putExtra("android.intent.extra.client_label", 17039417);
                long idendtity = Binder.clearCallingIdentity();
                try {
                    this.mIntent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivity(AccessibilityManagerService.this.mContext, 0, new Intent("android.settings.ACCESSIBILITY_SETTINGS"), 0));
                }
                finally {
                    Binder.restoreCallingIdentity(idendtity);
                }
            }
            this.setDynamicallyConfigurableProperties(accessibilityServiceInfo);
        }

        @Override
        public boolean onKeyEvent(KeyEvent keyEvent, int sequenceNumber) {
            if (!this.mRequestFilterKeyEvents || this.mServiceInterface == null) {
                return false;
            }
            if ((this.mAccessibilityServiceInfo.getCapabilities() & 8) == 0) {
                return false;
            }
            try {
                this.mServiceInterface.onKeyEvent(keyEvent, sequenceNumber);
            }
            catch (RemoteException e) {
                return false;
            }
            return true;
        }

        @Override
        public boolean isCapturingFingerprintGestures() {
            return this.mServiceInterface != null && AccessibilityManagerService.this.mSecurityPolicy.canCaptureFingerprintGestures(this) && this.mCaptureFingerprintGestures;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFingerprintGestureDetectionActiveChanged(boolean active) {
            IAccessibilityServiceClient serviceInterface;
            if (!this.isCapturingFingerprintGestures()) {
                return;
            }
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                serviceInterface = this.mServiceInterface;
            }
            if (serviceInterface != null) {
                try {
                    this.mServiceInterface.onFingerprintCapturingGesturesChanged(active);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFingerprintGesture(int gesture) {
            IAccessibilityServiceClient serviceInterface;
            if (!this.isCapturingFingerprintGestures()) {
                return;
            }
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                serviceInterface = this.mServiceInterface;
            }
            if (serviceInterface != null) {
                try {
                    this.mServiceInterface.onFingerprintGesture(gesture);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        public void setDynamicallyConfigurableProperties(AccessibilityServiceInfo info) {
            this.mEventTypes = info.eventTypes;
            this.mFeedbackType = info.feedbackType;
            String[] packageNames = info.packageNames;
            if (packageNames != null) {
                this.mPackageNames.addAll(Arrays.asList(packageNames));
            }
            this.mNotificationTimeout = info.notificationTimeout;
            boolean bl = this.mIsDefault = (info.flags & 1) != 0;
            if (this.mIsAutomation || info.getResolveInfo().serviceInfo.applicationInfo.targetSdkVersion >= 16) {
                this.mFetchFlags = (info.flags & 2) != 0 ? (this.mFetchFlags |= 8) : (this.mFetchFlags &= 0xFFFFFFF7);
            }
            this.mFetchFlags = (info.flags & 0x10) != 0 ? (this.mFetchFlags |= 0x10) : (this.mFetchFlags &= 0xFFFFFFEF);
            this.mRequestTouchExplorationMode = (info.flags & 4) != 0;
            this.mRequestFilterKeyEvents = (info.flags & 0x20) != 0;
            this.mRetrieveInteractiveWindows = (info.flags & 0x40) != 0;
            this.mCaptureFingerprintGestures = (info.flags & 0x200) != 0;
            this.mRequestAccessibilityButton = (info.flags & 0x100) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean bindLocked() {
            final UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
            if (!this.mIsAutomation) {
                long identity = Binder.clearCallingIdentity();
                try {
                    if (this.mService != null || !AccessibilityManagerService.this.mContext.bindServiceAsUser(this.mIntent, this, 0x2000001, new UserHandle(this.mUserId))) return false;
                    userState.mBindingServices.add(this.mComponentName);
                    return false;
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            } else {
                userState.mBindingServices.add(this.mComponentName);
                AccessibilityManagerService.this.mMainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Service.this.onServiceConnected(Service.this.mComponentName, userState.mUiAutomationServiceClient.asBinder());
                    }
                });
                userState.mUiAutomationService = this;
            }
            return false;
        }

        public boolean unbindLocked() {
            UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
            AccessibilityManagerService.this.getKeyEventDispatcher().flush(this);
            if (!this.mIsAutomation) {
                AccessibilityManagerService.this.mContext.unbindService(this);
            } else {
                userState.destroyUiAutomationService();
            }
            AccessibilityManagerService.this.removeServiceLocked(this, userState);
            this.resetLocked();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disableSelf() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
                if (userState.mEnabledServices.remove(this.mComponentName)) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        AccessibilityManagerService.this.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, this.mUserId);
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                    AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                }
            }
        }

        public boolean canReceiveEventsLocked() {
            return this.mEventTypes != 0 && this.mFeedbackType != 0 && this.mService != null;
        }

        @Override
        public void setOnKeyEventResult(boolean handled, int sequence) {
            AccessibilityManagerService.this.getKeyEventDispatcher().setOnKeyEventResult(this, handled, sequence);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AccessibilityServiceInfo getServiceInfo() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                return this.mAccessibilityServiceInfo;
            }
        }

        public boolean canRetrieveInteractiveWindowsLocked() {
            return AccessibilityManagerService.this.mSecurityPolicy.canRetrieveWindowContentLocked(this) && this.mRetrieveInteractiveWindows;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setServiceInfo(AccessibilityServiceInfo info) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    AccessibilityServiceInfo oldInfo = this.mAccessibilityServiceInfo;
                    if (oldInfo != null) {
                        oldInfo.updateDynamicallyConfigurableProperties(info);
                        this.setDynamicallyConfigurableProperties(oldInfo);
                    } else {
                        this.setDynamicallyConfigurableProperties(info);
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
                    AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    AccessibilityManagerService.this.scheduleNotifyClientsOfServicesStateChange(userState);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName componentName, IBinder service) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (this.mService != service) {
                    if (this.mService != null) {
                        this.mService.unlinkToDeath(this, 0);
                    }
                    this.mService = service;
                    try {
                        this.mService.linkToDeath(this, 0);
                    }
                    catch (RemoteException re) {
                        Slog.e(AccessibilityManagerService.LOG_TAG, "Failed registering death link");
                        this.binderDied();
                        return;
                    }
                }
                this.mServiceInterface = IAccessibilityServiceClient.Stub.asInterface(service);
                UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
                AccessibilityManagerService.this.addServiceLocked(this, userState);
                if (userState.mBindingServices.contains(this.mComponentName) || this.mWasConnectedAndDied) {
                    userState.mBindingServices.remove(this.mComponentName);
                    this.mWasConnectedAndDied = false;
                    try {
                        this.mServiceInterface.init(this, this.mId, this.mOverlayWindowToken);
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                    catch (RemoteException re) {
                        Slog.w(AccessibilityManagerService.LOG_TAG, "Error while setting connection for service: " + service, re);
                        this.binderDied();
                    }
                } else {
                    this.binderDied();
                }
            }
        }

        private boolean isCalledForCurrentUserLocked() {
            int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(-2);
            return resolvedUserId == AccessibilityManagerService.this.mCurrentUserId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<AccessibilityWindowInfo> getWindows() {
            AccessibilityManagerService.this.ensureWindowsAvailableTimed();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isCalledForCurrentUserLocked()) {
                    return null;
                }
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canRetrieveWindowsLocked(this);
                if (!permissionGranted) {
                    return null;
                }
                if (((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mWindows == null) {
                    return null;
                }
                ArrayList<AccessibilityWindowInfo> windows = new ArrayList<AccessibilityWindowInfo>();
                int windowCount = ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mWindows.size();
                for (int i = 0; i < windowCount; ++i) {
                    AccessibilityWindowInfo window = ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mWindows.get(i);
                    AccessibilityWindowInfo windowClone = AccessibilityWindowInfo.obtain(window);
                    windowClone.setConnectionId(this.mId);
                    windows.add(windowClone);
                }
                return windows;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AccessibilityWindowInfo getWindow(int windowId) {
            AccessibilityManagerService.this.ensureWindowsAvailableTimed();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isCalledForCurrentUserLocked()) {
                    return null;
                }
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canRetrieveWindowsLocked(this);
                if (!permissionGranted) {
                    return null;
                }
                AccessibilityWindowInfo window = AccessibilityManagerService.this.mSecurityPolicy.findWindowById(windowId);
                if (window != null) {
                    AccessibilityWindowInfo windowClone = AccessibilityWindowInfo.obtain(window);
                    windowClone.setConnectionId(this.mId);
                    return windowClone;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean findAccessibilityNodeInfosByViewId(int accessibilityWindowId, long accessibilityNodeId, String viewIdResName, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            MagnificationSpec spec;
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Region partialInteractiveRegion = Region.obtain();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                this.mUsesAccessibilityCache = true;
                if (!this.isCalledForCurrentUserLocked()) {
                    return false;
                }
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
                if (!AccessibilityManagerService.this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                    partialInteractiveRegion.recycle();
                    partialInteractiveRegion = null;
                }
                spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(resolvedWindowId);
            }
            int interrogatingPid = Binder.getCallingPid();
            callback = this.replaceCallbackIfNeeded(callback, resolvedWindowId, interactionId, interrogatingPid, interrogatingTid);
            long identityToken = Binder.clearCallingIdentity();
            try {
                connection.findAccessibilityNodeInfosByViewId(accessibilityNodeId, viewIdResName, partialInteractiveRegion, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
                boolean bl = true;
                return bl;
            }
            catch (RemoteException remoteException) {
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
                if (partialInteractiveRegion != null && Binder.isProxy(connection)) {
                    partialInteractiveRegion.recycle();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean findAccessibilityNodeInfosByText(int accessibilityWindowId, long accessibilityNodeId, String text, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            MagnificationSpec spec;
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Region partialInteractiveRegion = Region.obtain();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                this.mUsesAccessibilityCache = true;
                if (!this.isCalledForCurrentUserLocked()) {
                    return false;
                }
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
                if (!AccessibilityManagerService.this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                    partialInteractiveRegion.recycle();
                    partialInteractiveRegion = null;
                }
                spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(resolvedWindowId);
            }
            int interrogatingPid = Binder.getCallingPid();
            callback = this.replaceCallbackIfNeeded(callback, resolvedWindowId, interactionId, interrogatingPid, interrogatingTid);
            long identityToken = Binder.clearCallingIdentity();
            try {
                connection.findAccessibilityNodeInfosByText(accessibilityNodeId, text, partialInteractiveRegion, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
                boolean bl = true;
                return bl;
            }
            catch (RemoteException remoteException) {
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
                if (partialInteractiveRegion != null && Binder.isProxy(connection)) {
                    partialInteractiveRegion.recycle();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean findAccessibilityNodeInfoByAccessibilityId(int accessibilityWindowId, long accessibilityNodeId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, long interrogatingTid, Bundle arguments) throws RemoteException {
            MagnificationSpec spec;
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Region partialInteractiveRegion = Region.obtain();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                this.mUsesAccessibilityCache = true;
                if (!this.isCalledForCurrentUserLocked()) {
                    return false;
                }
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
                if (!AccessibilityManagerService.this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                    partialInteractiveRegion.recycle();
                    partialInteractiveRegion = null;
                }
                spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(resolvedWindowId);
            }
            int interrogatingPid = Binder.getCallingPid();
            callback = this.replaceCallbackIfNeeded(callback, resolvedWindowId, interactionId, interrogatingPid, interrogatingTid);
            long identityToken = Binder.clearCallingIdentity();
            try {
                connection.findAccessibilityNodeInfoByAccessibilityId(accessibilityNodeId, partialInteractiveRegion, interactionId, callback, this.mFetchFlags | flags, interrogatingPid, interrogatingTid, spec, arguments);
                boolean bl = true;
                return bl;
            }
            catch (RemoteException remoteException) {
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
                if (partialInteractiveRegion != null && Binder.isProxy(connection)) {
                    partialInteractiveRegion.recycle();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean findFocus(int accessibilityWindowId, long accessibilityNodeId, int focusType, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            MagnificationSpec spec;
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Region partialInteractiveRegion = Region.obtain();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isCalledForCurrentUserLocked()) {
                    return false;
                }
                resolvedWindowId = this.resolveAccessibilityWindowIdForFindFocusLocked(accessibilityWindowId, focusType);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
                if (!AccessibilityManagerService.this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                    partialInteractiveRegion.recycle();
                    partialInteractiveRegion = null;
                }
                spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(resolvedWindowId);
            }
            int interrogatingPid = Binder.getCallingPid();
            callback = this.replaceCallbackIfNeeded(callback, resolvedWindowId, interactionId, interrogatingPid, interrogatingTid);
            long identityToken = Binder.clearCallingIdentity();
            try {
                connection.findFocus(accessibilityNodeId, focusType, partialInteractiveRegion, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
                boolean bl = true;
                return bl;
            }
            catch (RemoteException remoteException) {
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
                if (partialInteractiveRegion != null && Binder.isProxy(connection)) {
                    partialInteractiveRegion.recycle();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean focusSearch(int accessibilityWindowId, long accessibilityNodeId, int direction, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            MagnificationSpec spec;
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Region partialInteractiveRegion = Region.obtain();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isCalledForCurrentUserLocked()) {
                    return false;
                }
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
                if (!AccessibilityManagerService.this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                    partialInteractiveRegion.recycle();
                    partialInteractiveRegion = null;
                }
                spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(resolvedWindowId);
            }
            int interrogatingPid = Binder.getCallingPid();
            callback = this.replaceCallbackIfNeeded(callback, resolvedWindowId, interactionId, interrogatingPid, interrogatingTid);
            long identityToken = Binder.clearCallingIdentity();
            try {
                connection.focusSearch(accessibilityNodeId, direction, partialInteractiveRegion, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
                boolean bl = true;
                return bl;
            }
            catch (RemoteException remoteException) {
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
                if (partialInteractiveRegion != null && Binder.isProxy(connection)) {
                    partialInteractiveRegion.recycle();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendGesture(int sequence, ParceledListSlice gestureSteps) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (AccessibilityManagerService.this.mSecurityPolicy.canPerformGestures(this)) {
                    long endMillis = SystemClock.uptimeMillis() + 1000L;
                    while (AccessibilityManagerService.this.mMotionEventInjector == null && SystemClock.uptimeMillis() < endMillis) {
                        try {
                            AccessibilityManagerService.this.mLock.wait(endMillis - SystemClock.uptimeMillis());
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (AccessibilityManagerService.this.mMotionEventInjector != null) {
                        List steps = gestureSteps.getList();
                        AccessibilityManagerService.this.mMotionEventInjector.injectEvents(steps, this.mServiceInterface, sequence);
                        return;
                    }
                    Slog.e(AccessibilityManagerService.LOG_TAG, "MotionEventInjector installation timed out");
                }
            }
            try {
                this.mServiceInterface.onPerformGestureResult(sequence, false);
            }
            catch (RemoteException re) {
                Slog.e(AccessibilityManagerService.LOG_TAG, "Error sending motion event injection failure to " + this.mServiceInterface, re);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean performAccessibilityAction(int accessibilityWindowId, long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            IAccessibilityInteractionConnection connection = null;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isCalledForCurrentUserLocked()) {
                    return false;
                }
                int resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
                AccessibilityWindowInfo windowInfo = AccessibilityManagerService.this.mSecurityPolicy.findWindowById(resolvedWindowId);
                if (windowInfo != null && windowInfo.inPictureInPicture()) {
                    boolean isA11yFocusAction;
                    boolean bl = isA11yFocusAction = action == 64 || action == 128;
                    if (AccessibilityManagerService.this.mPictureInPictureActionReplacingConnection != null && !isA11yFocusAction) {
                        connection = AccessibilityManagerService.this.mPictureInPictureActionReplacingConnection.mConnection;
                    }
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            try {
                AccessibilityManagerService.this.mPowerManager.userActivity(SystemClock.uptimeMillis(), 3, 0);
                connection.performAccessibilityAction(accessibilityNodeId, action, arguments, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid);
            }
            catch (RemoteException remoteException) {
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean performGlobalAction(int action) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isCalledForCurrentUserLocked()) {
                    return false;
                }
            }
            long identity = Binder.clearCallingIdentity();
            try {
                AccessibilityManagerService.this.mPowerManager.userActivity(SystemClock.uptimeMillis(), 3, 0);
                switch (action) {
                    case 1: {
                        this.sendDownAndUpKeyEvents(4);
                        boolean bl = true;
                        return bl;
                    }
                    case 2: {
                        this.sendDownAndUpKeyEvents(3);
                        boolean bl = true;
                        return bl;
                    }
                    case 3: {
                        boolean bl = this.openRecents();
                        return bl;
                    }
                    case 4: {
                        this.expandNotifications();
                        boolean bl = true;
                        return bl;
                    }
                    case 5: {
                        this.expandQuickSettings();
                        boolean bl = true;
                        return bl;
                    }
                    case 6: {
                        this.showGlobalActions();
                        boolean bl = true;
                        return bl;
                    }
                    case 7: {
                        this.toggleSplitScreen();
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public boolean isFingerprintGestureDetectionAvailable() {
            return this.isCapturingFingerprintGestures() && AccessibilityManagerService.this.mFingerprintGestureDispatcher != null && AccessibilityManagerService.this.mFingerprintGestureDispatcher.isFingerprintGestureDetectionAvailable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float getMagnificationScale() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isCalledForCurrentUserLocked()) {
                    return 1.0f;
                }
            }
            long identity = Binder.clearCallingIdentity();
            try {
                float f = AccessibilityManagerService.this.getMagnificationController().getScale();
                return f;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Region getMagnificationRegion() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                Region region;
                Region region2 = Region.obtain();
                if (!this.isCalledForCurrentUserLocked()) {
                    return region2;
                }
                MagnificationController magnificationController = AccessibilityManagerService.this.getMagnificationController();
                boolean forceRegistration = AccessibilityManagerService.this.mSecurityPolicy.canControlMagnification(this);
                boolean initiallyRegistered = magnificationController.isRegisteredLocked();
                if (!initiallyRegistered && forceRegistration) {
                    magnificationController.register();
                }
                long identity = Binder.clearCallingIdentity();
                try {
                    magnificationController.getMagnificationRegion(region2);
                    region = region2;
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(identity);
                    if (!initiallyRegistered && forceRegistration) {
                        magnificationController.unregister();
                    }
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identity);
                if (!initiallyRegistered && forceRegistration) {
                    magnificationController.unregister();
                }
                return region;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float getMagnificationCenterX() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isCalledForCurrentUserLocked()) {
                    return 0.0f;
                }
            }
            long identity = Binder.clearCallingIdentity();
            try {
                float f = AccessibilityManagerService.this.getMagnificationController().getCenterX();
                return f;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public float getMagnificationCenterY() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isCalledForCurrentUserLocked()) {
                    return 0.0f;
                }
            }
            long identity = Binder.clearCallingIdentity();
            try {
                float f = AccessibilityManagerService.this.getMagnificationController().getCenterY();
                return f;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean resetMagnification(boolean animate) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isCalledForCurrentUserLocked()) {
                    return false;
                }
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canControlMagnification(this);
                if (!permissionGranted) {
                    return false;
                }
            }
            long identity = Binder.clearCallingIdentity();
            try {
                boolean bl = AccessibilityManagerService.this.getMagnificationController().reset(animate);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setMagnificationScaleAndCenter(float scale, float centerX, float centerY, boolean animate) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                boolean bl;
                if (!this.isCalledForCurrentUserLocked()) {
                    return false;
                }
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canControlMagnification(this);
                if (!permissionGranted) {
                    return false;
                }
                long identity = Binder.clearCallingIdentity();
                try {
                    MagnificationController magnificationController = AccessibilityManagerService.this.getMagnificationController();
                    if (!magnificationController.isRegisteredLocked()) {
                        magnificationController.register();
                    }
                    bl = magnificationController.setScaleAndCenter(scale, centerX, centerY, animate, this.mId);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(identity);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identity);
                return bl;
            }
        }

        @Override
        public void setMagnificationCallbackEnabled(boolean enabled) {
            this.mInvocationHandler.setMagnificationCallbackEnabled(enabled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setSoftKeyboardShowMode(int showMode) {
            UserState userState;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isCalledForCurrentUserLocked()) {
                    return false;
                }
                userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
            }
            long identity = Binder.clearCallingIdentity();
            try {
                userState.mServiceChangingSoftKeyboardMode = showMode == 0 ? null : this.mComponentName;
                Settings.Secure.putIntForUser(AccessibilityManagerService.this.mContext.getContentResolver(), "accessibility_soft_keyboard_mode", showMode, userState.mUserId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            return true;
        }

        @Override
        public void setSoftKeyboardCallbackEnabled(boolean enabled) {
            this.mInvocationHandler.setSoftKeyboardCallbackEnabled(enabled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAccessibilityButtonAvailable() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isCalledForCurrentUserLocked()) {
                    return false;
                }
                UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                return this.isAccessibilityButtonAvailableLocked(userState);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(AccessibilityManagerService.this.mContext, AccessibilityManagerService.LOG_TAG, pw)) {
                return;
            }
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                pw.append("Service[label=" + this.mAccessibilityServiceInfo.getResolveInfo().loadLabel(AccessibilityManagerService.this.mContext.getPackageManager()));
                pw.append(", feedbackType" + AccessibilityServiceInfo.feedbackTypeToString(this.mFeedbackType));
                pw.append(", capabilities=" + this.mAccessibilityServiceInfo.getCapabilities());
                pw.append(", eventTypes=" + AccessibilityEvent.eventTypeToString(this.mEventTypes));
                pw.append(", notificationTimeout=" + this.mNotificationTimeout);
                pw.append("]");
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            this.binderDied();
        }

        public void onAdded() throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                AccessibilityManagerService.this.mWindowManagerService.addWindowToken(this.mOverlayWindowToken, 2032, 0);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        public void onRemoved() {
            long identity = Binder.clearCallingIdentity();
            try {
                AccessibilityManagerService.this.mWindowManagerService.removeWindowToken(this.mOverlayWindowToken, true, 0);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        public void resetLocked() {
            try {
                if (this.mServiceInterface != null) {
                    this.mServiceInterface.init(null, this.mId, null);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (this.mService != null) {
                this.mService.unlinkToDeath(this, 0);
                this.mService = null;
            }
            this.mServiceInterface = null;
            this.mReceivedAccessibilityButtonCallbackSinceBind = false;
        }

        public boolean isConnectedLocked() {
            return this.mService != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isConnectedLocked()) {
                    return;
                }
                this.mWasConnectedAndDied = true;
                AccessibilityManagerService.this.getKeyEventDispatcher().flush(this);
                UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
                this.resetLocked();
                if (this.mIsAutomation) {
                    AccessibilityManagerService.this.removeServiceLocked(this, userState);
                    userState.mInstalledServices.remove(this.mAccessibilityServiceInfo);
                    userState.mEnabledServices.remove(this.mComponentName);
                    userState.destroyUiAutomationService();
                    AccessibilityManagerService.this.readConfigurationForUserStateLocked(userState);
                }
                if (this.mId == AccessibilityManagerService.this.getMagnificationController().getIdOfLastServiceToMagnify()) {
                    AccessibilityManagerService.this.getMagnificationController().resetIfNeeded(true);
                }
                AccessibilityManagerService.this.onUserStateChangedLocked(userState);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyAccessibilityEvent(AccessibilityEvent event, boolean serviceWantsEvent) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                Message message;
                int eventType = event.getEventType();
                AccessibilityEvent newEvent = AccessibilityEvent.obtain(event);
                if (this.mNotificationTimeout > 0L && eventType != 2048) {
                    AccessibilityEvent oldEvent = this.mPendingEvents.get(eventType);
                    this.mPendingEvents.put(eventType, newEvent);
                    if (oldEvent != null) {
                        this.mEventDispatchHandler.removeMessages(eventType);
                        oldEvent.recycle();
                    }
                    message = this.mEventDispatchHandler.obtainMessage(eventType);
                } else {
                    message = this.mEventDispatchHandler.obtainMessage(eventType, newEvent);
                }
                message.arg1 = serviceWantsEvent ? 1 : 0;
                this.mEventDispatchHandler.sendMessageDelayed(message, this.mNotificationTimeout);
            }
        }

        private boolean isAccessibilityButtonAvailableLocked(UserState userState) {
            if (!this.mRequestAccessibilityButton) {
                return false;
            }
            if (!AccessibilityManagerService.this.mIsAccessibilityButtonShown) {
                return false;
            }
            if (userState.mIsNavBarMagnificationEnabled && userState.mIsNavBarMagnificationAssignedToAccessibilityButton) {
                return false;
            }
            int requestingServices = 0;
            for (int i = userState.mBoundServices.size() - 1; i >= 0; --i) {
                Service service = userState.mBoundServices.get(i);
                if (!service.mRequestAccessibilityButton) continue;
                ++requestingServices;
            }
            if (requestingServices == 1) {
                return true;
            }
            if (userState.mServiceAssignedToAccessibilityButton == null) {
                return true;
            }
            return this.mComponentName.equals(userState.mServiceAssignedToAccessibilityButton);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAccessibilityEventInternal(int eventType, AccessibilityEvent event, boolean serviceWantsEvent) {
            IAccessibilityServiceClient listener;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                listener = this.mServiceInterface;
                if (listener == null) {
                    return;
                }
                if (event == null) {
                    event = this.mPendingEvents.get(eventType);
                    if (event == null) {
                        return;
                    }
                    this.mPendingEvents.remove(eventType);
                }
                if (AccessibilityManagerService.this.mSecurityPolicy.canRetrieveWindowContentLocked(this)) {
                    event.setConnectionId(this.mId);
                } else {
                    event.setSource((View)null);
                }
                event.setSealed(true);
            }
            try {
                listener.onAccessibilityEvent(event, serviceWantsEvent);
            }
            catch (RemoteException re) {
                Slog.e(AccessibilityManagerService.LOG_TAG, "Error during sending " + event + " to " + listener, re);
            }
            finally {
                event.recycle();
            }
        }

        public void notifyGesture(int gestureId) {
            this.mInvocationHandler.obtainMessage(1, gestureId, 0).sendToTarget();
        }

        public void notifyClearAccessibilityNodeInfoCache() {
            this.mInvocationHandler.sendEmptyMessage(2);
        }

        public void notifyMagnificationChangedLocked(Region region, float scale, float centerX, float centerY) {
            this.mInvocationHandler.notifyMagnificationChangedLocked(region, scale, centerX, centerY);
        }

        public void notifySoftKeyboardShowModeChangedLocked(int showState) {
            this.mInvocationHandler.notifySoftKeyboardShowModeChangedLocked(showState);
        }

        public void notifyAccessibilityButtonClickedLocked() {
            this.mInvocationHandler.notifyAccessibilityButtonClickedLocked();
        }

        public void notifyAccessibilityButtonAvailabilityChangedLocked(boolean available) {
            this.mInvocationHandler.notifyAccessibilityButtonAvailabilityChangedLocked(available);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyMagnificationChangedInternal(Region region, float scale, float centerX, float centerY) {
            IAccessibilityServiceClient listener;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                listener = this.mServiceInterface;
            }
            if (listener != null) {
                try {
                    listener.onMagnificationChanged(region, scale, centerX, centerY);
                }
                catch (RemoteException re) {
                    Slog.e(AccessibilityManagerService.LOG_TAG, "Error sending magnification changes to " + this.mService, re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifySoftKeyboardShowModeChangedInternal(int showState) {
            IAccessibilityServiceClient listener;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                listener = this.mServiceInterface;
            }
            if (listener != null) {
                try {
                    listener.onSoftKeyboardShowModeChanged(showState);
                }
                catch (RemoteException re) {
                    Slog.e(AccessibilityManagerService.LOG_TAG, "Error sending soft keyboard show mode changes to " + this.mService, re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAccessibilityButtonClickedInternal() {
            IAccessibilityServiceClient listener;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                listener = this.mServiceInterface;
            }
            if (listener != null) {
                try {
                    listener.onAccessibilityButtonClicked();
                }
                catch (RemoteException re) {
                    Slog.e(AccessibilityManagerService.LOG_TAG, "Error sending accessibility button click to " + this.mService, re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAccessibilityButtonAvailabilityChangedInternal(boolean available) {
            IAccessibilityServiceClient listener;
            if (this.mReceivedAccessibilityButtonCallbackSinceBind && this.mLastAccessibilityButtonCallbackState == available) {
                return;
            }
            this.mReceivedAccessibilityButtonCallbackSinceBind = true;
            this.mLastAccessibilityButtonCallbackState = available;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                listener = this.mServiceInterface;
            }
            if (listener != null) {
                try {
                    listener.onAccessibilityButtonAvailabilityChanged(available);
                }
                catch (RemoteException re) {
                    Slog.e(AccessibilityManagerService.LOG_TAG, "Error sending accessibility button availability change to " + this.mService, re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyGestureInternal(int gestureId) {
            IAccessibilityServiceClient listener;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                listener = this.mServiceInterface;
            }
            if (listener != null) {
                try {
                    listener.onGesture(gestureId);
                }
                catch (RemoteException re) {
                    Slog.e(AccessibilityManagerService.LOG_TAG, "Error during sending gesture " + gestureId + " to " + this.mService, re);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyClearAccessibilityCacheInternal() {
            IAccessibilityServiceClient listener;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                listener = this.mServiceInterface;
            }
            if (listener != null) {
                try {
                    listener.clearAccessibilityCache();
                }
                catch (RemoteException re) {
                    Slog.e(AccessibilityManagerService.LOG_TAG, "Error during requesting accessibility info cache to be cleared.", re);
                }
            }
        }

        private void sendDownAndUpKeyEvents(int keyCode) {
            long token = Binder.clearCallingIdentity();
            long downTime = SystemClock.uptimeMillis();
            KeyEvent down = KeyEvent.obtain(downTime, downTime, 0, keyCode, 0, 0, -1, 0, 8, 257, null);
            InputManager.getInstance().injectInputEvent(down, 0);
            down.recycle();
            long upTime = SystemClock.uptimeMillis();
            KeyEvent up = KeyEvent.obtain(downTime, upTime, 1, keyCode, 0, 0, -1, 0, 8, 257, null);
            InputManager.getInstance().injectInputEvent(up, 0);
            up.recycle();
            Binder.restoreCallingIdentity(token);
        }

        private void expandNotifications() {
            long token = Binder.clearCallingIdentity();
            StatusBarManager statusBarManager = (StatusBarManager)AccessibilityManagerService.this.mContext.getSystemService("statusbar");
            statusBarManager.expandNotificationsPanel();
            Binder.restoreCallingIdentity(token);
        }

        private void expandQuickSettings() {
            long token = Binder.clearCallingIdentity();
            StatusBarManager statusBarManager = (StatusBarManager)AccessibilityManagerService.this.mContext.getSystemService("statusbar");
            statusBarManager.expandSettingsPanel();
            Binder.restoreCallingIdentity(token);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean openRecents() {
            long token = Binder.clearCallingIdentity();
            try {
                StatusBarManagerInternal statusBarService = LocalServices.getService(StatusBarManagerInternal.class);
                if (statusBarService == null) {
                    boolean bl = false;
                    return bl;
                }
                statusBarService.toggleRecentApps();
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            return true;
        }

        private void showGlobalActions() {
            AccessibilityManagerService.this.mWindowManagerService.showGlobalActions();
        }

        private void toggleSplitScreen() {
            LocalServices.getService(StatusBarManagerInternal.class).toggleSplitScreen();
        }

        private IAccessibilityInteractionConnection getConnectionLocked(int windowId) {
            AccessibilityConnectionWrapper wrapper = (AccessibilityConnectionWrapper)AccessibilityManagerService.this.mGlobalInteractionConnections.get(windowId);
            if (wrapper == null) {
                wrapper = ((AccessibilityManagerService)AccessibilityManagerService.this).getCurrentUserStateLocked().mInteractionConnections.get(windowId);
            }
            if (wrapper != null && wrapper.mConnection != null) {
                return wrapper.mConnection;
            }
            return null;
        }

        private int resolveAccessibilityWindowIdLocked(int accessibilityWindowId) {
            if (accessibilityWindowId == Integer.MAX_VALUE) {
                return AccessibilityManagerService.this.mSecurityPolicy.getActiveWindowId();
            }
            return accessibilityWindowId;
        }

        private int resolveAccessibilityWindowIdForFindFocusLocked(int windowId, int focusType) {
            if (windowId == Integer.MAX_VALUE) {
                return ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mActiveWindowId;
            }
            if (windowId == -2) {
                if (focusType == 1) {
                    return ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mFocusedWindowId;
                }
                if (focusType == 2) {
                    return ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mAccessibilityFocusedWindowId;
                }
            }
            return windowId;
        }

        private IAccessibilityInteractionConnectionCallback replaceCallbackIfNeeded(IAccessibilityInteractionConnectionCallback originalCallback, int resolvedWindowId, int interactionId, int interrogatingPid, long interrogatingTid) {
            AccessibilityWindowInfo windowInfo = AccessibilityManagerService.this.mSecurityPolicy.findWindowById(resolvedWindowId);
            if (windowInfo == null || !windowInfo.inPictureInPicture() || AccessibilityManagerService.this.mPictureInPictureActionReplacingConnection == null) {
                return originalCallback;
            }
            return new ActionReplacingCallback(originalCallback, AccessibilityManagerService.this.mPictureInPictureActionReplacingConnection.mConnection, interactionId, interrogatingPid, interrogatingTid);
        }

        private final class InvocationHandler
        extends Handler {
            public static final int MSG_ON_GESTURE = 1;
            public static final int MSG_CLEAR_ACCESSIBILITY_CACHE = 2;
            private static final int MSG_ON_MAGNIFICATION_CHANGED = 5;
            private static final int MSG_ON_SOFT_KEYBOARD_STATE_CHANGED = 6;
            private static final int MSG_ON_ACCESSIBILITY_BUTTON_CLICKED = 7;
            private static final int MSG_ON_ACCESSIBILITY_BUTTON_AVAILABILITY_CHANGED = 8;
            private boolean mIsMagnificationCallbackEnabled;
            private boolean mIsSoftKeyboardCallbackEnabled;

            public InvocationHandler(Looper looper) {
                super(looper, null, true);
                this.mIsMagnificationCallbackEnabled = false;
                this.mIsSoftKeyboardCallbackEnabled = false;
            }

            @Override
            public void handleMessage(Message message) {
                int type = message.what;
                switch (type) {
                    case 1: {
                        int gestureId = message.arg1;
                        Service.this.notifyGestureInternal(gestureId);
                        break;
                    }
                    case 2: {
                        Service.this.notifyClearAccessibilityCacheInternal();
                        break;
                    }
                    case 5: {
                        SomeArgs args = (SomeArgs)message.obj;
                        Region region = (Region)args.arg1;
                        float scale = ((Float)args.arg2).floatValue();
                        float centerX = ((Float)args.arg3).floatValue();
                        float centerY = ((Float)args.arg4).floatValue();
                        Service.this.notifyMagnificationChangedInternal(region, scale, centerX, centerY);
                        break;
                    }
                    case 6: {
                        int showState = message.arg1;
                        Service.this.notifySoftKeyboardShowModeChangedInternal(showState);
                        break;
                    }
                    case 7: {
                        Service.this.notifyAccessibilityButtonClickedInternal();
                        break;
                    }
                    case 8: {
                        boolean available = message.arg1 != 0;
                        Service.this.notifyAccessibilityButtonAvailabilityChangedInternal(available);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown message: " + type);
                    }
                }
            }

            public void notifyMagnificationChangedLocked(Region region, float scale, float centerX, float centerY) {
                if (!this.mIsMagnificationCallbackEnabled) {
                    return;
                }
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = region;
                args.arg2 = Float.valueOf(scale);
                args.arg3 = Float.valueOf(centerX);
                args.arg4 = Float.valueOf(centerY);
                Message msg = this.obtainMessage(5, args);
                msg.sendToTarget();
            }

            public void setMagnificationCallbackEnabled(boolean enabled) {
                this.mIsMagnificationCallbackEnabled = enabled;
            }

            public void notifySoftKeyboardShowModeChangedLocked(int showState) {
                if (!this.mIsSoftKeyboardCallbackEnabled) {
                    return;
                }
                Message msg = this.obtainMessage(6, showState, 0);
                msg.sendToTarget();
            }

            public void setSoftKeyboardCallbackEnabled(boolean enabled) {
                this.mIsSoftKeyboardCallbackEnabled = enabled;
            }

            public void notifyAccessibilityButtonClickedLocked() {
                Message msg = this.obtainMessage(7);
                msg.sendToTarget();
            }

            public void notifyAccessibilityButtonAvailabilityChangedLocked(boolean available) {
                Message msg = this.obtainMessage(8, available ? 1 : 0, 0);
                msg.sendToTarget();
            }
        }
    }

    private final class MainHandler
    extends Handler {
        public static final int MSG_SEND_ACCESSIBILITY_EVENT_TO_INPUT_FILTER = 1;
        public static final int MSG_SEND_STATE_TO_CLIENTS = 2;
        public static final int MSG_SEND_CLEARED_STATE_TO_CLIENTS_FOR_USER = 3;
        public static final int MSG_ANNOUNCE_NEW_USER_IF_NEEDED = 5;
        public static final int MSG_UPDATE_INPUT_FILTER = 6;
        public static final int MSG_SHOW_ENABLED_TOUCH_EXPLORATION_DIALOG = 7;
        public static final int MSG_SEND_KEY_EVENT_TO_INPUT_FILTER = 8;
        public static final int MSG_CLEAR_ACCESSIBILITY_FOCUS = 9;
        public static final int MSG_SEND_SERVICES_STATE_CHANGED_TO_CLIENTS = 10;
        public static final int MSG_UPDATE_FINGERPRINT = 11;
        public static final int MSG_SEND_RELEVANT_EVENTS_CHANGED_TO_CLIENTS = 12;
        public static final int MSG_SEND_ACCESSIBILITY_BUTTON_TO_INPUT_FILTER = 13;
        public static final int MSG_SHOW_ACCESSIBILITY_BUTTON_CHOOSER = 14;

        public MainHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            int type = msg.what;
            switch (type) {
                case 1: {
                    AccessibilityEvent event = (AccessibilityEvent)msg.obj;
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (AccessibilityManagerService.this.mHasInputFilter && AccessibilityManagerService.this.mInputFilter != null) {
                            AccessibilityManagerService.this.mInputFilter.notifyAccessibilityEvent(event);
                        }
                    }
                    event.recycle();
                    break;
                }
                case 8: {
                    KeyEvent event = (KeyEvent)msg.obj;
                    int policyFlags = msg.arg1;
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (AccessibilityManagerService.this.mHasInputFilter && AccessibilityManagerService.this.mInputFilter != null) {
                            AccessibilityManagerService.this.mInputFilter.sendInputEvent(event, policyFlags);
                        }
                    }
                    event.recycle();
                    break;
                }
                case 2: {
                    int clientState = msg.arg1;
                    int userId = msg.arg2;
                    this.sendStateToClients(clientState, AccessibilityManagerService.this.mGlobalClients);
                    this.sendStateToClients(clientState, this.getUserClientsForId(userId));
                    break;
                }
                case 3: {
                    int userId = msg.arg1;
                    this.sendStateToClients(0, this.getUserClientsForId(userId));
                    break;
                }
                case 5: {
                    this.announceNewUserIfNeeded();
                    break;
                }
                case 6: {
                    UserState userState = (UserState)msg.obj;
                    AccessibilityManagerService.this.updateInputFilter(userState);
                    break;
                }
                case 7: {
                    Service service = (Service)msg.obj;
                    AccessibilityManagerService.this.showEnableTouchExplorationDialog(service);
                    break;
                }
                case 9: {
                    int windowId = msg.arg1;
                    AccessibilityManagerService.this.getInteractionBridge().clearAccessibilityFocusNotLocked(windowId);
                    break;
                }
                case 10: {
                    int userId = msg.arg1;
                    this.notifyClientsOfServicesStateChange(AccessibilityManagerService.this.mGlobalClients);
                    this.notifyClientsOfServicesStateChange(this.getUserClientsForId(userId));
                    break;
                }
                case 11: {
                    AccessibilityManagerService.this.updateFingerprintGestureHandling((UserState)msg.obj);
                    break;
                }
                case 12: {
                    UserState userState;
                    int userId = msg.arg1;
                    int relevantEventTypes = msg.arg2;
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        userState = AccessibilityManagerService.this.getUserStateLocked(userId);
                    }
                    AccessibilityManagerService.this.broadcastToClients(userState, client -> {
                        try {
                            client.setRelevantEventTypes(relevantEventTypes);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    });
                    break;
                }
                case 13: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (AccessibilityManagerService.this.mHasInputFilter && AccessibilityManagerService.this.mInputFilter != null) {
                            AccessibilityManagerService.this.mInputFilter.notifyAccessibilityButtonClicked();
                        }
                        break;
                    }
                }
                case 14: {
                    AccessibilityManagerService.this.showAccessibilityButtonTargetSelection();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void announceNewUserIfNeeded() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                if (userState.isHandlingAccessibilityEvents()) {
                    UserManager userManager = (UserManager)AccessibilityManagerService.this.mContext.getSystemService("user");
                    String message = AccessibilityManagerService.this.mContext.getString(17040921, userManager.getUserInfo((int)((AccessibilityManagerService)AccessibilityManagerService.this).mCurrentUserId).name);
                    AccessibilityEvent event = AccessibilityEvent.obtain(16384);
                    event.getText().add(message);
                    AccessibilityManagerService.this.sendAccessibilityEvent(event, AccessibilityManagerService.this.mCurrentUserId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RemoteCallbackList<IAccessibilityManagerClient> getUserClientsForId(int userId) {
            UserState userState;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                userState = AccessibilityManagerService.this.getUserStateLocked(userId);
            }
            return userState.mUserClients;
        }

        private void sendStateToClients(int clientState, RemoteCallbackList<IAccessibilityManagerClient> clients) {
            clients.broadcast(client -> {
                try {
                    client.setState(clientState);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyClientsOfServicesStateChange(RemoteCallbackList<IAccessibilityManagerClient> clients) {
            try {
                int userClientCount = clients.beginBroadcast();
                for (int i = 0; i < userClientCount; ++i) {
                    IAccessibilityManagerClient client = clients.getBroadcastItem(i);
                    try {
                        client.notifyServicesStateChanged();
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            finally {
                clients.finishBroadcast();
            }
        }
    }

    private class AccessibilityConnectionWrapper
    implements IBinder.DeathRecipient {
        private final int mWindowId;
        private final int mUserId;
        private final IAccessibilityInteractionConnection mConnection;

        public AccessibilityConnectionWrapper(int windowId, IAccessibilityInteractionConnection connection, int userId) {
            this.mWindowId = windowId;
            this.mUserId = userId;
            this.mConnection = connection;
        }

        public void linkToDeath() throws RemoteException {
            this.mConnection.asBinder().linkToDeath(this, 0);
        }

        public void unlinkToDeath() {
            this.mConnection.asBinder().unlinkToDeath(this, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            this.unlinkToDeath();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                AccessibilityManagerService.this.removeAccessibilityInteractionConnectionLocked(this.mWindowId, this.mUserId);
            }
        }
    }
}

