/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.ApplicationErrorReport;
import android.app.BroadcastOptions;
import android.app.ContentProviderHolder;
import android.app.Dialog;
import android.app.IActivityContainer;
import android.app.IActivityContainerCallback;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IAppTask;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.INotificationManager;
import android.app.IProcessObserver;
import android.app.IServiceConnection;
import android.app.IStopUserCallback;
import android.app.ITaskStackListener;
import android.app.IUiAutomationConnection;
import android.app.IUidObserver;
import android.app.IUserSwitchObserver;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.PictureInPictureParams;
import android.app.ProfilerInfo;
import android.app.RemoteAction;
import android.app.WaitResult;
import android.app.admin.DevicePolicyManager;
import android.app.assist.AssistContent;
import android.app.assist.AssistStructure;
import android.app.backup.IBackupManager;
import android.app.usage.UsageStatsManagerInternal;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageManager;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ParceledListSlice;
import android.content.pm.PathPermission;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.metrics.LogMaker;
import android.net.NetworkPolicyManager;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.FactoryTest;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.IDeviceIdentifiersPolicyService;
import android.os.IPermissionController;
import android.os.IProcessInfoService;
import android.os.IProgressListener;
import android.os.LocaleList;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.TransactionTooLargeException;
import android.os.UpdateLock;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.WorkSource;
import android.os.storage.IStorageManager;
import android.os.storage.StorageManager;
import android.os.storage.StorageManagerInternal;
import android.provider.Settings;
import android.service.voice.IVoiceInteractionSession;
import android.service.voice.VoiceInteractionManagerInternal;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.BootTimingsTraceLog;
import android.util.DebugUtils;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.Xml;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.AssistUtils;
import com.android.internal.app.DumpHeapActivity;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.app.ProcessMap;
import com.android.internal.app.SystemUserHomeActivity;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.IResultReceiver;
import com.android.internal.os.ProcessCpuTracker;
import com.android.internal.os.TransferPipe;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.MemInfoReader;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.AppOpsService;
import com.android.server.AttributeCache;
import com.android.server.DeviceIdleController;
import com.android.server.IntentResolver;
import com.android.server.LocalServices;
import com.android.server.LockGuard;
import com.android.server.NetworkManagementInternal;
import com.android.server.RescueParty;
import com.android.server.ServiceThread;
import com.android.server.SystemConfig;
import com.android.server.SystemService;
import com.android.server.SystemServiceManager;
import com.android.server.ThreadPriorityBooster;
import com.android.server.UiThread;
import com.android.server.Watchdog;
import com.android.server.am.ActiveInstrumentation;
import com.android.server.am.ActiveServices;
import com.android.server.am.ActivityManagerConstants;
import com.android.server.am.ActivityManagerShellCommand;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.ActivityStarter;
import com.android.server.am.AppErrorResult;
import com.android.server.am.AppErrors;
import com.android.server.am.AppTimeTracker;
import com.android.server.am.AppWaitingForDebuggerDialog;
import com.android.server.am.BackupRecord;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.BatteryStatsService;
import com.android.server.am.BroadcastFilter;
import com.android.server.am.BroadcastQueue;
import com.android.server.am.BroadcastRecord;
import com.android.server.am.BroadcastStats;
import com.android.server.am.CompatModeDialog;
import com.android.server.am.CompatModePackages;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.ContentProviderConnection;
import com.android.server.am.ContentProviderRecord;
import com.android.server.am.CoreSettingsObserver;
import com.android.server.am.DumpHeapProvider;
import com.android.server.am.EventLogTags;
import com.android.server.am.FactoryErrorDialog;
import com.android.server.am.InstrumentationReporter;
import com.android.server.am.KeyguardController;
import com.android.server.am.LaunchWarningWindow;
import com.android.server.am.NativeCrashListener;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.PinnedActivityStack;
import com.android.server.am.ProcessList;
import com.android.server.am.ProcessMemInfo;
import com.android.server.am.ProcessRecord;
import com.android.server.am.ProcessStatsService;
import com.android.server.am.ProviderMap;
import com.android.server.am.ReceiverList;
import com.android.server.am.RecentTasks;
import com.android.server.am.ServiceRecord;
import com.android.server.am.StrictModeViolationDialog;
import com.android.server.am.TaskChangeNotificationController;
import com.android.server.am.TaskPersister;
import com.android.server.am.TaskRecord;
import com.android.server.am.UidRecord;
import com.android.server.am.UnsupportedDisplaySizeDialog;
import com.android.server.am.UriPermission;
import com.android.server.am.UriPermissionOwner;
import com.android.server.am.UserController;
import com.android.server.am.UserState;
import com.android.server.am.VrController;
import com.android.server.firewall.IntentFirewall;
import com.android.server.job.JobSchedulerInternal;
import com.android.server.pm.Installer;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.vr.VrManagerInternal;
import com.android.server.wm.PinnedStackWindowController;
import com.android.server.wm.WindowManagerService;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ActivityManagerService
extends IActivityManager.Stub
implements Watchdog.Monitor,
BatteryStatsImpl.BatteryCallback {
    public static final int TOP_APP_PRIORITY_BOOST = -10;
    private static final String TAG = "ActivityManager";
    private static final String TAG_BACKUP = "ActivityManager";
    private static final String TAG_BROADCAST = "ActivityManager";
    private static final String TAG_CLEANUP = "ActivityManager";
    private static final String TAG_CONFIGURATION = "ActivityManager";
    private static final String TAG_FOCUS = "ActivityManager";
    private static final String TAG_IMMERSIVE = "ActivityManager";
    private static final String TAG_LOCKSCREEN = "ActivityManager";
    private static final String TAG_LOCKTASK = "ActivityManager";
    private static final String TAG_LRU = "ActivityManager";
    private static final String TAG_MU = "ActivityManager_MU";
    private static final String TAG_NETWORK = "ActivityManager_Network";
    private static final String TAG_OOM_ADJ = "ActivityManager";
    private static final String TAG_POWER = "ActivityManager";
    private static final String TAG_PROCESS_OBSERVERS = "ActivityManager";
    private static final String TAG_PROCESSES = "ActivityManager";
    private static final String TAG_PROVIDER = "ActivityManager";
    private static final String TAG_PSS = "ActivityManager";
    private static final String TAG_RECENTS = "ActivityManager";
    private static final String TAG_SERVICE = "ActivityManager";
    private static final String TAG_STACK = "ActivityManager";
    private static final String TAG_SWITCH = "ActivityManager";
    private static final String TAG_UID_OBSERVERS = "ActivityManager";
    private static final String TAG_URI_PERMISSION = "ActivityManager";
    private static final String TAG_VISIBILITY = "ActivityManager";
    private static final String TAG_VISIBLE_BEHIND = "ActivityManager";
    public static final String ACTION_TRIGGER_IDLE = "com.android.server.ACTION_TRIGGER_IDLE";
    static final long BATTERY_STATS_TIME = 1800000L;
    static final boolean MONITOR_CPU_USAGE = true;
    static final long MONITOR_CPU_MIN_TIME = 5000L;
    static final long MONITOR_CPU_MAX_TIME = 0xFFFFFFFL;
    static final boolean MONITOR_THREAD_CPU_USAGE = false;
    static final int STOCK_PM_FLAGS = 1024;
    static final String SYSTEM_DEBUGGABLE = "ro.debuggable";
    static final boolean IS_USER_BUILD = "user".equals(Build.TYPE);
    static final long APP_SWITCH_DELAY_TIME = 5000L;
    static final int PROC_START_TIMEOUT = 10000;
    static final int CONTENT_PROVIDER_PUBLISH_TIMEOUT = 10000;
    static final int PROC_START_TIMEOUT_WITH_WRAPPER = 1200000;
    static final int BROADCAST_FG_TIMEOUT = 10000;
    static final int BROADCAST_BG_TIMEOUT = 60000;
    static final int KEY_DISPATCHING_TIMEOUT = 5000;
    static final int INSTRUMENTATION_KEY_DISPATCHING_TIMEOUT = 60000;
    static final int PENDING_ASSIST_EXTRAS_TIMEOUT = 500;
    static final int PENDING_ASSIST_EXTRAS_LONG_TIMEOUT = 2000;
    static final int PENDING_AUTOFILL_ASSIST_STRUCTURE_TIMEOUT = 2000;
    static final int MAX_PERSISTED_URI_GRANTS = 128;
    static final int MY_PID = android.os.Process.myPid();
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final int DROPBOX_MAX_SIZE = 196608;
    static final int RESERVED_BYTES_PER_LOGCAT_LINE = 100;
    static final int ALLOW_NON_FULL = 0;
    static final int ALLOW_NON_FULL_IN_PROFILE = 1;
    static final int ALLOW_FULL_ONLY = 2;
    private static final int PERSISTENT_MASK = 9;
    private static final String INTENT_REMOTE_BUGREPORT_FINISHED = "com.android.internal.intent.action.REMOTE_BUGREPORT_FINISHED";
    static final boolean ANIMATE = true;
    static final boolean TAKE_FULLSCREEN_SCREENSHOTS = true;
    private static final long NETWORK_ACCESS_TIMEOUT_DEFAULT_MS = 200L;
    static final int NETWORK_STATE_NO_CHANGE = 0;
    static final int NETWORK_STATE_BLOCK = 1;
    static final int NETWORK_STATE_UNBLOCK = 2;
    private static final int MAX_BUGREPORT_TITLE_SIZE = 50;
    SystemServiceManager mSystemServiceManager;
    AssistUtils mAssistUtils;
    private Installer mInstaller;
    final ActivityStackSupervisor mStackSupervisor;
    private final KeyguardController mKeyguardController;
    final ActivityStarter mActivityStarter;
    final TaskChangeNotificationController mTaskChangeNotificationController;
    final InstrumentationReporter mInstrumentationReporter = new InstrumentationReporter();
    final ArrayList<ActiveInstrumentation> mActiveInstrumentation = new ArrayList();
    public final IntentFirewall mIntentFirewall;
    private boolean mShowDialogs = true;
    private final VrController mVrController;
    int mVr2dDisplayId = -1;
    private boolean mUseFifoUiScheduling = false;
    BroadcastQueue mFgBroadcastQueue;
    BroadcastQueue mBgBroadcastQueue;
    final BroadcastQueue[] mBroadcastQueues = new BroadcastQueue[2];
    BroadcastStats mLastBroadcastStats;
    BroadcastStats mCurBroadcastStats;
    private ActivityRecord mLastResumedActivity;
    private AppTimeTracker mCurAppTimeTracker;
    final RecentTasks mRecentTasks;
    ComponentName mLastAddedTaskComponent;
    int mLastAddedTaskUid;
    ActivityInfo mLastAddedTaskActivity;
    SparseArray<String[]> mLockTaskPackages = new SparseArray();
    String mDeviceOwnerName;
    final UserController mUserController;
    final AppErrors mAppErrors;
    String mLastANRState;
    long mWaitForNetworkTimeoutMs;
    private static ThreadPriorityBooster sThreadPriorityBooster = new ThreadPriorityBooster(-2, 6);
    final ArrayList<PendingAssistExtras> mPendingAssistExtras = new ArrayList();
    final ProcessList mProcessList = new ProcessList();
    final ProcessMap<ProcessRecord> mProcessNames = new ProcessMap();
    final ProcessStatsService mProcessStats;
    final SparseArray<ProcessRecord> mIsolatedProcesses = new SparseArray();
    int mNextIsolatedProcessUid = 0;
    ProcessRecord mHeavyWeightProcess = null;
    int[] mBackgroundAppIdWhitelist = new int[]{1002};
    ArraySet<String> mBackgroundLaunchBroadcasts;
    final SparseArray<ProcessRecord> mPidsSelfLocked = new SparseArray();
    final SparseArray<ImportanceToken> mImportantProcesses = new SparseArray();
    final ArrayList<ProcessRecord> mProcessesOnHold = new ArrayList();
    final ArrayList<ProcessRecord> mPersistentStartingProcesses = new ArrayList();
    final ArrayList<ProcessRecord> mRemovedProcesses = new ArrayList();
    final ArrayList<ProcessRecord> mLruProcesses = new ArrayList();
    int mLruProcessActivityStart = 0;
    int mLruProcessServiceStart = 0;
    final ArrayList<ProcessRecord> mProcessesToGc = new ArrayList();
    final ArrayList<ProcessRecord> mPendingPssProcesses = new ArrayList();
    private boolean mBinderTransactionTrackingEnabled = false;
    long mLastFullPssTime = SystemClock.uptimeMillis();
    boolean mFullPssPending = false;
    ProcessRecord mHomeProcess;
    ProcessRecord mPreviousProcess;
    long mPreviousProcessVisibleTime;
    final SparseArray<UidRecord> mActiveUids = new SparseArray();
    static final boolean VALIDATE_UID_STATES = true;
    final SparseArray<UidRecord> mValidateUids = new SparseArray();
    final CompatModePackages mCompatModePackages;
    final HashMap<PendingIntentRecord.Key, WeakReference<PendingIntentRecord>> mIntentSenderRecords = new HashMap();
    private final HashSet<Integer> mAlreadyLoggedViolatedStacks = new HashSet();
    private static final int MAX_DUP_SUPPRESSED_STACKS = 5000;
    private final StringBuilder mStrictModeBuffer = new StringBuilder();
    final HashMap<IBinder, ReceiverList> mRegisteredReceivers = new HashMap();
    final IntentResolver<BroadcastFilter, BroadcastFilter> mReceiverResolver = new IntentResolver<BroadcastFilter, BroadcastFilter>(){

        @Override
        protected boolean allowFilterResult(BroadcastFilter filter, List<BroadcastFilter> dest) {
            IBinder target = filter.receiverList.receiver.asBinder();
            for (int i = dest.size() - 1; i >= 0; --i) {
                if (dest.get((int)i).receiverList.receiver.asBinder() != target) continue;
                return false;
            }
            return true;
        }

        @Override
        protected BroadcastFilter newResult(BroadcastFilter filter, int match, int userId) {
            if (userId == -1 || filter.owningUserId == -1 || userId == filter.owningUserId) {
                return (BroadcastFilter)super.newResult(filter, match, userId);
            }
            return null;
        }

        protected BroadcastFilter[] newArray(int size) {
            return new BroadcastFilter[size];
        }

        @Override
        protected boolean isPackageForFilter(String packageName, BroadcastFilter filter) {
            return packageName.equals(filter.packageName);
        }
    };
    final SparseArray<ArrayMap<String, ArrayList<Intent>>> mStickyBroadcasts = new SparseArray();
    final ActiveServices mServices;
    final SparseArray<ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>>> mAssociations = new SparseArray();
    boolean mTrackingAssociations;
    String mBackupAppName = null;
    BackupRecord mBackupTarget = null;
    final ProviderMap mProviderMap;
    final ArrayList<ContentProviderRecord> mLaunchingProviders = new ArrayList();
    private final AtomicFile mGrantFile;
    private static final String TAG_URI_GRANTS = "uri-grants";
    private static final String TAG_URI_GRANT = "uri-grant";
    private static final String ATTR_USER_HANDLE = "userHandle";
    private static final String ATTR_SOURCE_USER_ID = "sourceUserId";
    private static final String ATTR_TARGET_USER_ID = "targetUserId";
    private static final String ATTR_SOURCE_PKG = "sourcePkg";
    private static final String ATTR_TARGET_PKG = "targetPkg";
    private static final String ATTR_URI = "uri";
    private static final String ATTR_MODE_FLAGS = "modeFlags";
    private static final String ATTR_CREATED_TIME = "createdTime";
    private static final String ATTR_PREFIX = "prefix";
    @GuardedBy(value="this")
    private final SparseArray<ArrayMap<GrantUri, UriPermission>> mGrantedUriPermissions = new SparseArray();
    CoreSettingsObserver mCoreSettingsObserver;
    FontScaleSettingObserver mFontScaleSettingObserver;
    private static final ThreadLocal<Identity> sCallerIdentity = new ThreadLocal();
    final BatteryStatsService mBatteryStatsService;
    UsageStatsManagerInternal mUsageStatsService;
    DeviceIdleController.LocalService mLocalDeviceIdleController;
    int[] mDeviceIdleWhitelist = new int[0];
    int[] mDeviceIdleTempWhitelist = new int[0];
    final SparseArray<PendingTempWhitelist> mPendingTempWhitelist = new SparseArray();
    final AppOpsService mAppOpsService;
    private int mConfigurationSeq;
    private Configuration mTempConfig = new Configuration();
    private final UpdateConfigurationResult mTmpUpdateConfigurationResult = new UpdateConfigurationResult();
    boolean mSuppressResizeConfigChanges;
    final int GL_ES_VERSION;
    HashMap<String, IBinder> mAppBindArgs;
    HashMap<String, IBinder> mIsolatedAppBindArgs;
    final StringBuilder mStringBuilder = new StringBuilder(256);
    ComponentName mTopComponent;
    String mTopAction = "android.intent.action.MAIN";
    String mTopData;
    volatile boolean mProcessesReady = false;
    volatile boolean mSystemReady = false;
    volatile boolean mOnBattery = false;
    volatile int mFactoryTest;
    @GuardedBy(value="this")
    boolean mBooting = false;
    @GuardedBy(value="this")
    boolean mCallFinishBooting = false;
    @GuardedBy(value="this")
    boolean mBootAnimationComplete = false;
    @GuardedBy(value="this")
    boolean mLaunchWarningShown = false;
    @GuardedBy(value="this")
    boolean mCheckedForSetup = false;
    final Context mContext;
    final Context mUiContext;
    long mAppSwitchesAllowedTime;
    boolean mDidAppSwitch;
    long mLastPowerCheckRealtime;
    long mLastPowerCheckUptime;
    private boolean mSleeping = false;
    int mTopProcessState = 2;
    private IVoiceInteractionSession mRunningVoice;
    PowerManagerInternal mLocalPowerManager;
    PowerManager.WakeLock mVoiceWakeLock;
    private int mWakefulness = 1;
    final ArrayList<ActivityManagerInternal.SleepToken> mSleepTokens = new ArrayList();
    boolean mShuttingDown = false;
    int mAdjSeq = 0;
    int mLruSeq = 0;
    int mNumNonCachedProcs = 0;
    int mNumCachedHiddenProcs = 0;
    int mNumServiceProcs = 0;
    int mNewNumAServiceProcs = 0;
    int mNewNumServiceProcs = 0;
    boolean mAllowLowerMemLevel = false;
    int mLastMemoryLevel = 0;
    int mLastNumProcesses;
    long mLastIdleTime = SystemClock.uptimeMillis();
    long mLowRamTimeSinceLastIdle = 0L;
    long mLowRamStartTime = 0L;
    private String mCurResumedPackage = null;
    private int mCurResumedUid = -1;
    final ProcessMap<ArrayList<ProcessRecord>> mForegroundPackages = new ProcessMap();
    boolean mDidDexOpt;
    boolean mSafeMode;
    boolean mTestPssMode = false;
    String mDebugApp = null;
    boolean mWaitForDebugger = false;
    boolean mDebugTransient = false;
    String mOrigDebugApp = null;
    boolean mOrigWaitForDebugger = false;
    boolean mAlwaysFinishActivities = false;
    boolean mForceResizableActivities;
    boolean mSupportsMultiWindow;
    boolean mSupportsSplitScreenMultiWindow;
    boolean mSupportsFreeformWindowManagement;
    boolean mSupportsPictureInPicture;
    boolean mSupportsMultiDisplay;
    boolean mSupportsLeanbackOnly;
    IActivityController mController = null;
    boolean mControllerIsAMonkey = false;
    String mProfileApp = null;
    ProcessRecord mProfileProc = null;
    String mProfileFile;
    ParcelFileDescriptor mProfileFd;
    int mSamplingInterval = 0;
    boolean mAutoStopProfiler = false;
    boolean mStreamingOutput = false;
    int mProfileType = 0;
    final ProcessMap<Pair<Long, String>> mMemWatchProcesses = new ProcessMap();
    String mMemWatchDumpProcName;
    String mMemWatchDumpFile;
    int mMemWatchDumpPid;
    int mMemWatchDumpUid;
    String mTrackAllocationApp = null;
    String mNativeDebuggingApp = null;
    final long[] mTmpLong = new long[2];
    private final ArraySet<BroadcastQueue> mTmpBroadcastQueue = new ArraySet();
    @GuardedBy(value="this")
    long mProcStateSeqCounter = 0L;
    private final Injector mInjector;
    final RemoteCallbackList<IProcessObserver> mProcessObservers = new RemoteCallbackList();
    ProcessChangeItem[] mActiveProcessChanges = new ProcessChangeItem[5];
    final ArrayList<ProcessChangeItem> mPendingProcessChanges = new ArrayList();
    final ArrayList<ProcessChangeItem> mAvailProcessChanges = new ArrayList();
    final RemoteCallbackList<IUidObserver> mUidObservers = new RemoteCallbackList();
    UidRecord.ChangeItem[] mActiveUidChanges = new UidRecord.ChangeItem[5];
    final ArrayList<UidRecord.ChangeItem> mPendingUidChanges = new ArrayList();
    final ArrayList<UidRecord.ChangeItem> mAvailUidChanges = new ArrayList();
    final Thread mProcessCpuThread;
    final ProcessCpuTracker mProcessCpuTracker = new ProcessCpuTracker(false);
    final AtomicLong mLastCpuTime = new AtomicLong(0L);
    final AtomicBoolean mProcessCpuMutexFree = new AtomicBoolean(true);
    final CountDownLatch mProcessCpuInitLatch = new CountDownLatch(1);
    long mLastWriteTime = 0L;
    final UpdateLock mUpdateLock = new UpdateLock("immersive");
    boolean mBooted = false;
    WindowManagerService mWindowManager;
    final ActivityThread mSystemThread;
    static final int SHOW_ERROR_UI_MSG = 1;
    static final int SHOW_NOT_RESPONDING_UI_MSG = 2;
    static final int SHOW_FACTORY_ERROR_UI_MSG = 3;
    static final int UPDATE_CONFIGURATION_MSG = 4;
    static final int GC_BACKGROUND_PROCESSES_MSG = 5;
    static final int WAIT_FOR_DEBUGGER_UI_MSG = 6;
    static final int SERVICE_TIMEOUT_MSG = 12;
    static final int UPDATE_TIME_ZONE = 13;
    static final int SHOW_UID_ERROR_UI_MSG = 14;
    static final int SHOW_FINGERPRINT_ERROR_UI_MSG = 15;
    static final int PROC_START_TIMEOUT_MSG = 20;
    static final int DO_PENDING_ACTIVITY_LAUNCHES_MSG = 21;
    static final int KILL_APPLICATION_MSG = 22;
    static final int FINALIZE_PENDING_INTENT_MSG = 23;
    static final int POST_HEAVY_NOTIFICATION_MSG = 24;
    static final int CANCEL_HEAVY_NOTIFICATION_MSG = 25;
    static final int SHOW_STRICT_MODE_VIOLATION_UI_MSG = 26;
    static final int CHECK_EXCESSIVE_WAKE_LOCKS_MSG = 27;
    static final int CLEAR_DNS_CACHE_MSG = 28;
    static final int UPDATE_HTTP_PROXY_MSG = 29;
    static final int SHOW_COMPAT_MODE_DIALOG_UI_MSG = 30;
    static final int DISPATCH_PROCESSES_CHANGED_UI_MSG = 31;
    static final int DISPATCH_PROCESS_DIED_UI_MSG = 32;
    static final int REPORT_MEM_USAGE_MSG = 33;
    static final int REPORT_USER_SWITCH_MSG = 34;
    static final int CONTINUE_USER_SWITCH_MSG = 35;
    static final int USER_SWITCH_TIMEOUT_MSG = 36;
    static final int IMMERSIVE_MODE_LOCK_MSG = 37;
    static final int PERSIST_URI_GRANTS_MSG = 38;
    static final int REQUEST_ALL_PSS_MSG = 39;
    static final int START_PROFILES_MSG = 40;
    static final int UPDATE_TIME_PREFERENCE_MSG = 41;
    static final int SYSTEM_USER_START_MSG = 42;
    static final int SYSTEM_USER_CURRENT_MSG = 43;
    static final int ENTER_ANIMATION_COMPLETE_MSG = 44;
    static final int FINISH_BOOTING_MSG = 45;
    static final int START_USER_SWITCH_UI_MSG = 46;
    static final int SEND_LOCALE_TO_MOUNT_DAEMON_MSG = 47;
    static final int DISMISS_DIALOG_UI_MSG = 48;
    static final int NOTIFY_CLEARTEXT_NETWORK_MSG = 49;
    static final int POST_DUMP_HEAP_NOTIFICATION_MSG = 50;
    static final int DELETE_DUMPHEAP_MSG = 51;
    static final int FOREGROUND_PROFILE_CHANGED_MSG = 52;
    static final int DISPATCH_UIDS_CHANGED_UI_MSG = 53;
    static final int REPORT_TIME_TRACKER_MSG = 54;
    static final int REPORT_USER_SWITCH_COMPLETE_MSG = 55;
    static final int SHUTDOWN_UI_AUTOMATION_CONNECTION_MSG = 56;
    static final int CONTENT_PROVIDER_PUBLISH_TIMEOUT_MSG = 57;
    static final int IDLE_UIDS_MSG = 58;
    static final int SYSTEM_USER_UNLOCK_MSG = 59;
    static final int LOG_STACK_STATE = 60;
    static final int VR_MODE_CHANGE_MSG = 61;
    static final int SHOW_UNSUPPORTED_DISPLAY_SIZE_DIALOG_MSG = 62;
    static final int HANDLE_TRUST_STORAGE_UPDATE_MSG = 63;
    static final int REPORT_LOCKED_BOOT_COMPLETE_MSG = 64;
    static final int NOTIFY_VR_SLEEPING_MSG = 65;
    static final int SERVICE_FOREGROUND_TIMEOUT_MSG = 66;
    static final int DISPATCH_PENDING_INTENT_CANCEL_MSG = 67;
    static final int PUSH_TEMP_WHITELIST_UI_MSG = 68;
    static final int SERVICE_FOREGROUND_CRASH_MSG = 69;
    static final int START_USER_SWITCH_FG_MSG = 712;
    static final int FIRST_ACTIVITY_STACK_MSG = 100;
    static final int FIRST_BROADCAST_QUEUE_MSG = 200;
    static final int FIRST_COMPAT_MODE_MSG = 300;
    static final int FIRST_SUPERVISOR_STACK_MSG = 100;
    static ServiceThread sKillThread = null;
    static KillHandler sKillHandler = null;
    CompatModeDialog mCompatModeDialog;
    UnsupportedDisplaySizeDialog mUnsupportedDisplaySizeDialog;
    long mLastMemUsageReportTime = 0L;
    private boolean mUserIsMonkey;
    boolean mHasRecents;
    int mThumbnailWidth;
    int mThumbnailHeight;
    float mFullscreenThumbnailScale;
    final ServiceThread mHandlerThread;
    final MainHandler mHandler;
    final Handler mUiHandler;
    final ActivityManagerConstants mConstants;
    PackageManagerInternal mPackageManagerInt;
    private int mViSessionId = 1000;
    final boolean mPermissionReviewRequired;
    static final int COLLECT_PSS_BG_MSG = 1;
    final Handler mBgHandler = new Handler(BackgroundThread.getHandler().getLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    long start = SystemClock.uptimeMillis();
                    MemInfoReader memInfo = null;
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    // MONITORENTER : activityManagerService
                    if (ActivityManagerService.this.mFullPssPending) {
                        ActivityManagerService.this.mFullPssPending = false;
                        memInfo = new MemInfoReader();
                    }
                    // MONITOREXIT : activityManagerService
                    if (memInfo != null) {
                        ActivityManagerService.this.updateCpuStatsNow();
                        long nativeTotalPss = 0L;
                        ProcessCpuTracker processCpuTracker = ActivityManagerService.this.mProcessCpuTracker;
                        // MONITORENTER : processCpuTracker
                        List<ProcessCpuTracker.Stats> stats = ActivityManagerService.this.mProcessCpuTracker.getStats(st -> st.vsize > 0L && st.uid < 10000);
                        // MONITOREXIT : processCpuTracker
                        int N = stats.size();
                        for (int j = 0; j < N; ++j) {
                            SparseArray<ProcessRecord> sparseArray = ActivityManagerService.this.mPidsSelfLocked;
                            // MONITORENTER : sparseArray
                            if (ActivityManagerService.this.mPidsSelfLocked.indexOfKey(stats.get((int)j).pid) >= 0) {
                                // MONITOREXIT : sparseArray
                                continue;
                            }
                            // MONITOREXIT : sparseArray
                            nativeTotalPss += Debug.getPss(stats.get((int)j).pid, null, null);
                        }
                        memInfo.readMemInfo();
                        ActivityManagerService j = ActivityManagerService.this;
                        // MONITORENTER : j
                        long cachedKb = memInfo.getCachedSizeKb();
                        long freeKb = memInfo.getFreeSizeKb();
                        long zramKb = memInfo.getZramTotalSizeKb();
                        long kernelKb = memInfo.getKernelUsedSizeKb();
                        EventLogTags.writeAmMeminfo(cachedKb * 1024L, freeKb * 1024L, zramKb * 1024L, kernelKb * 1024L, nativeTotalPss * 1024L);
                        ActivityManagerService.this.mProcessStats.addSysMemUsageLocked(cachedKb, freeKb, zramKb, kernelKb, nativeTotalPss);
                        // MONITOREXIT : j
                    }
                    int num = 0;
                    long[] tmp = new long[2];
                    while (true) {
                        int pid;
                        ActivityManagerService activityManagerService2 = ActivityManagerService.this;
                        // MONITORENTER : activityManagerService2
                        if (ActivityManagerService.this.mPendingPssProcesses.size() <= 0) {
                            if (ActivityManagerService.this.mTestPssMode) {
                                Slog.d("ActivityManager", "Collected PSS of " + num + " processes in " + (SystemClock.uptimeMillis() - start) + "ms");
                            }
                            ActivityManagerService.this.mPendingPssProcesses.clear();
                            // MONITOREXIT : activityManagerService2
                            return;
                        }
                        ProcessRecord proc = ActivityManagerService.this.mPendingPssProcesses.remove(0);
                        int procState = proc.pssProcState;
                        long lastPssTime = proc.lastPssTime;
                        if (proc.thread != null && procState == proc.setProcState && lastPssTime + 1000L < SystemClock.uptimeMillis()) {
                            pid = proc.pid;
                        } else {
                            proc = null;
                            pid = 0;
                        }
                        // MONITOREXIT : activityManagerService2
                        if (proc == null) continue;
                        long pss = Debug.getPss(pid, tmp, null);
                        ActivityManagerService activityManagerService3 = ActivityManagerService.this;
                        // MONITORENTER : activityManagerService3
                        if (pss != 0L && proc.thread != null && proc.setProcState == procState && proc.pid == pid && proc.lastPssTime == lastPssTime) {
                            ++num;
                            ActivityManagerService.this.recordPssSampleLocked(proc, procState, pss, tmp[0], tmp[1], SystemClock.uptimeMillis());
                        }
                        // MONITOREXIT : activityManagerService3
                    }
                }
            }
        }
    };
    private static final int[] PROCESS_STATE_STATS_FORMAT = new int[]{32, 544, 10272};
    private final long[] mProcessStateStatsLongs = new long[1];
    private volatile long mWtfClusterStart;
    private volatile int mWtfClusterCount;
    static final long[] DUMP_MEM_BUCKETS = new long[]{5120L, 7168L, 10240L, 15360L, 20480L, 30720L, 40960L, 81920L, 122880L, 163840L, 204800L, 256000L, 307200L, 358400L, 409600L, 512000L, 614400L, 819200L, 0x100000L, 0x200000L, 0x500000L, 0xA00000L, 0x1400000L};
    static final int[] DUMP_MEM_OOM_ADJ = new int[]{-1000, -900, -800, -700, 0, 100, 200, 300, 400, 500, 600, 700, 800, 900};
    static final String[] DUMP_MEM_OOM_LABEL = new String[]{"Native", "System", "Persistent", "Persistent Service", "Foreground", "Visible", "Perceptible", "Heavy Weight", "Backup", "A Services", "Home", "Previous", "B Services", "Cached"};
    static final String[] DUMP_MEM_OOM_COMPACT_LABEL = new String[]{"native", "sys", "pers", "persvc", "fore", "vis", "percept", "heavy", "backup", "servicea", "home", "prev", "serviceb", "cached"};
    private static final int KSM_SHARED = 0;
    private static final int KSM_SHARING = 1;
    private static final int KSM_UNSHARED = 2;
    private static final int KSM_VOLATILE = 3;
    private static final int MEMINFO_COMPACT_VERSION = 1;
    private String[] mSupportedSystemLocales = null;

    BroadcastQueue broadcastQueueForIntent(Intent intent) {
        boolean isFg = (intent.getFlags() & 0x10000000) != 0;
        return isFg ? this.mFgBroadcastQueue : this.mBgBroadcastQueue;
    }

    public boolean canShowErrorDialogs() {
        return this.mShowDialogs && !this.mSleeping && !this.mShuttingDown && !this.mKeyguardController.isKeyguardShowing();
    }

    static void boostPriorityForLockedSection() {
        sThreadPriorityBooster.boost();
    }

    static void resetPriorityAfterLockedSection() {
        sThreadPriorityBooster.reset();
    }

    Configuration getGlobalConfiguration() {
        return this.mStackSupervisor.getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemProcess() {
        try {
            ServiceManager.addService("activity", this, true);
            ServiceManager.addService("procstats", this.mProcessStats);
            ServiceManager.addService("meminfo", new MemBinder(this));
            ServiceManager.addService("gfxinfo", new GraphicsBinder(this));
            ServiceManager.addService("dbinfo", new DbBinder(this));
            ServiceManager.addService("cpuinfo", new CpuBinder(this));
            ServiceManager.addService("permission", new PermissionController(this));
            ServiceManager.addService("processinfo", new ProcessInfoService(this));
            ApplicationInfo info = this.mContext.getPackageManager().getApplicationInfo("android", 0x100400);
            this.mSystemThread.installSystemApplicationInfo(info, this.getClass().getClassLoader());
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ProcessRecord app = this.newProcessRecordLocked(info, info.processName, false, 0);
                app.persistent = true;
                app.pid = MY_PID;
                app.maxAdj = -900;
                app.makeActive(this.mSystemThread.getApplicationThread(), this.mProcessStats);
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    this.mPidsSelfLocked.put(app.pid, app);
                }
                this.updateLruProcessLocked(app, false, null);
                this.updateOomAdjLocked();
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unable to find android system package", e);
        }
    }

    public void setWindowManager(WindowManagerService wm) {
        this.mWindowManager = wm;
        this.mStackSupervisor.setWindowManager(wm);
        this.mActivityStarter.setWindowManager(wm);
    }

    public void setUsageStatsManager(UsageStatsManagerInternal usageStatsManager) {
        this.mUsageStatsService = usageStatsManager;
    }

    public void startObservingNativeCrashes() {
        NativeCrashListener ncl = new NativeCrashListener(this);
        ncl.start();
    }

    public IAppOpsService getAppOpsService() {
        return this.mAppOpsService;
    }

    public ActivityManagerService(Injector injector) {
        this.mInjector = injector;
        this.mContext = this.mInjector.getContext();
        this.mUiContext = null;
        this.GL_ES_VERSION = 0;
        this.mActivityStarter = null;
        this.mAppErrors = null;
        this.mAppOpsService = this.mInjector.getAppOpsService(null, null);
        this.mBatteryStatsService = null;
        this.mCompatModePackages = null;
        this.mConstants = null;
        this.mGrantFile = null;
        this.mHandler = null;
        this.mHandlerThread = null;
        this.mIntentFirewall = null;
        this.mKeyguardController = null;
        this.mPermissionReviewRequired = false;
        this.mProcessCpuThread = null;
        this.mProcessStats = null;
        this.mProviderMap = null;
        this.mRecentTasks = null;
        this.mServices = null;
        this.mStackSupervisor = null;
        this.mSystemThread = null;
        this.mTaskChangeNotificationController = null;
        this.mUiHandler = injector.getUiHandler(null);
        this.mUserController = null;
        this.mVrController = null;
    }

    public ActivityManagerService(Context systemContext) {
        LockGuard.installLock((Object)this, 6);
        this.mInjector = new Injector();
        this.mContext = systemContext;
        this.mFactoryTest = FactoryTest.getMode();
        this.mSystemThread = ActivityThread.currentActivityThread();
        this.mUiContext = this.mSystemThread.getSystemUiContext();
        Slog.i("ActivityManager", "Memory class: " + ActivityManager.staticGetMemoryClass());
        this.mPermissionReviewRequired = this.mContext.getResources().getBoolean(17956980);
        this.mHandlerThread = new ServiceThread("ActivityManager", -2, false);
        this.mHandlerThread.start();
        this.mHandler = new MainHandler(this.mHandlerThread.getLooper());
        this.mUiHandler = this.mInjector.getUiHandler(this);
        this.mConstants = new ActivityManagerConstants(this, this.mHandler);
        if (sKillHandler == null) {
            sKillThread = new ServiceThread("ActivityManager:kill", 10, true);
            sKillThread.start();
            sKillHandler = new KillHandler(sKillThread.getLooper());
        }
        this.mFgBroadcastQueue = new BroadcastQueue(this, this.mHandler, "foreground", 10000L, false);
        this.mBgBroadcastQueue = new BroadcastQueue(this, this.mHandler, "background", 60000L, true);
        this.mBroadcastQueues[0] = this.mFgBroadcastQueue;
        this.mBroadcastQueues[1] = this.mBgBroadcastQueue;
        this.mServices = new ActiveServices(this);
        this.mProviderMap = new ProviderMap(this);
        this.mAppErrors = new AppErrors(this.mUiContext, this);
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        systemDir.mkdirs();
        this.mBatteryStatsService = new BatteryStatsService(systemDir, this.mHandler);
        this.mBatteryStatsService.getActiveStatistics().readLocked();
        this.mBatteryStatsService.scheduleWriteToDisk();
        this.mOnBattery = this.mBatteryStatsService.getActiveStatistics().getIsOnBattery();
        this.mBatteryStatsService.getActiveStatistics().setCallback(this);
        this.mProcessStats = new ProcessStatsService(this, new File(systemDir, "procstats"));
        this.mAppOpsService = this.mInjector.getAppOpsService(new File(systemDir, "appops.xml"), this.mHandler);
        this.mAppOpsService.startWatchingMode(63, null, new IAppOpsCallback.Stub(){

            @Override
            public void opChanged(int op, int uid, String packageName) {
                if (op == 63 && packageName != null && ActivityManagerService.this.mAppOpsService.checkOperation(op, uid, packageName) != 0) {
                    ActivityManagerService.this.runInBackgroundDisabled(uid);
                }
            }
        });
        this.mGrantFile = new AtomicFile(new File(systemDir, "urigrants.xml"));
        this.mUserController = new UserController(this);
        this.mVrController = new VrController(this);
        this.GL_ES_VERSION = SystemProperties.getInt("ro.opengles.version", 0);
        if (SystemProperties.getInt("sys.use_fifo_ui", 0) != 0) {
            this.mUseFifoUiScheduling = true;
        }
        this.mTrackingAssociations = "1".equals(SystemProperties.get("debug.track-associations"));
        this.mTempConfig.setToDefaults();
        this.mTempConfig.setLocales(LocaleList.getDefault());
        this.mTempConfig.seq = 1;
        this.mConfigurationSeq = 1;
        this.mStackSupervisor = this.createStackSupervisor();
        this.mStackSupervisor.onConfigurationChanged(this.mTempConfig);
        this.mKeyguardController = this.mStackSupervisor.mKeyguardController;
        this.mCompatModePackages = new CompatModePackages(this, systemDir, this.mHandler);
        this.mIntentFirewall = new IntentFirewall(new IntentFirewallInterface(), this.mHandler);
        this.mTaskChangeNotificationController = new TaskChangeNotificationController(this, this.mStackSupervisor, this.mHandler);
        this.mActivityStarter = new ActivityStarter(this, this.mStackSupervisor);
        this.mRecentTasks = new RecentTasks(this, this.mStackSupervisor);
        this.mProcessCpuThread = new Thread("CpuTracker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ActivityManagerService.this.mProcessCpuTracker;
                synchronized (object) {
                    ActivityManagerService.this.mProcessCpuInitLatch.countDown();
                    ActivityManagerService.this.mProcessCpuTracker.init();
                }
                while (true) {
                    try {
                        while (true) {
                            try {
                                object = this;
                                synchronized (object) {
                                    long now = SystemClock.uptimeMillis();
                                    long nextCpuDelay = ActivityManagerService.this.mLastCpuTime.get() + 0xFFFFFFFL - now;
                                    long nextWriteDelay = ActivityManagerService.this.mLastWriteTime + 1800000L - now;
                                    if (nextWriteDelay < nextCpuDelay) {
                                        nextCpuDelay = nextWriteDelay;
                                    }
                                    if (nextCpuDelay > 0L) {
                                        ActivityManagerService.this.mProcessCpuMutexFree.set(true);
                                        this.wait(nextCpuDelay);
                                    }
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ActivityManagerService.this.updateCpuStatsNow();
                        }
                    }
                    catch (Exception e) {
                        Slog.e("ActivityManager", "Unexpected exception collecting process stats", e);
                        continue;
                    }
                    break;
                }
            }
        };
        Watchdog.getInstance().addMonitor(this);
        Watchdog.getInstance().addThread(this.mHandler);
    }

    protected ActivityStackSupervisor createStackSupervisor() {
        return new ActivityStackSupervisor(this, this.mHandler.getLooper());
    }

    public void setSystemServiceManager(SystemServiceManager mgr) {
        this.mSystemServiceManager = mgr;
    }

    public void setInstaller(Installer installer) {
        this.mInstaller = installer;
    }

    private void start() {
        android.os.Process.removeAllProcessGroups();
        this.mProcessCpuThread.start();
        this.mBatteryStatsService.publish(this.mContext);
        this.mAppOpsService.publish(this.mContext);
        Slog.d("AppOps", "AppOpsService published");
        LocalServices.addService(ActivityManagerInternal.class, new LocalService());
        try {
            this.mProcessCpuInitLatch.await();
        }
        catch (InterruptedException e) {
            Slog.wtf("ActivityManager", "Interrupted wait during start", e);
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted wait during start");
        }
    }

    void onUserStoppedLocked(int userId) {
        this.mRecentTasks.unloadUserDataFromMemoryLocked(userId);
    }

    public void initPowerManagement() {
        this.mStackSupervisor.initPowerManagement();
        this.mBatteryStatsService.initPowerManagement();
        this.mLocalPowerManager = LocalServices.getService(PowerManagerInternal.class);
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mVoiceWakeLock = pm.newWakeLock(1, "*voice*");
        this.mVoiceWakeLock.setReferenceCounted(false);
    }

    private ArraySet<String> getBackgroundLaunchBroadcasts() {
        if (this.mBackgroundLaunchBroadcasts == null) {
            this.mBackgroundLaunchBroadcasts = SystemConfig.getInstance().getAllowImplicitBroadcasts();
        }
        return this.mBackgroundLaunchBroadcasts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (code == 1599295570) {
            ArrayList<IBinder> procs = new ArrayList<IBinder>();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                int NP = this.mProcessNames.getMap().size();
                for (int ip = 0; ip < NP; ++ip) {
                    SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
                    int NA = apps.size();
                    for (int ia = 0; ia < NA; ++ia) {
                        ProcessRecord app = apps.valueAt(ia);
                        if (app.thread == null) continue;
                        procs.add(app.thread.asBinder());
                    }
                }
            }
            int N = procs.size();
            for (int i = 0; i < N; ++i) {
                Parcel data2 = Parcel.obtain();
                try {
                    ((IBinder)procs.get(i)).transact(1599295570, data2, null, 1);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                data2.recycle();
            }
        }
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf("ActivityManager", "Activity Manager Crash. UID:" + Binder.getCallingUid() + " PID:" + Binder.getCallingPid() + " TRANS:" + code, e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCpuStats() {
        long now = SystemClock.uptimeMillis();
        if (this.mLastCpuTime.get() >= now - 5000L) {
            return;
        }
        if (this.mProcessCpuMutexFree.compareAndSet(true, false)) {
            Thread thread = this.mProcessCpuThread;
            synchronized (thread) {
                this.mProcessCpuThread.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCpuStatsNow() {
        ProcessCpuTracker processCpuTracker = this.mProcessCpuTracker;
        synchronized (processCpuTracker) {
            BatteryStatsImpl bstats;
            this.mProcessCpuMutexFree.set(false);
            long now = SystemClock.uptimeMillis();
            boolean haveNewCpuStats = false;
            if (this.mLastCpuTime.get() < now - 5000L) {
                this.mLastCpuTime.set(now);
                this.mProcessCpuTracker.update();
                if (this.mProcessCpuTracker.hasGoodLastStats()) {
                    haveNewCpuStats = true;
                    if ("true".equals(SystemProperties.get("events.cpu"))) {
                        int idle;
                        int softIrq;
                        int irq;
                        int iowait;
                        int system;
                        int user = this.mProcessCpuTracker.getLastUserTime();
                        int total = user + (system = this.mProcessCpuTracker.getLastSystemTime()) + (iowait = this.mProcessCpuTracker.getLastIoWaitTime()) + (irq = this.mProcessCpuTracker.getLastIrqTime()) + (softIrq = this.mProcessCpuTracker.getLastSoftIrqTime()) + (idle = this.mProcessCpuTracker.getLastIdleTime());
                        if (total == 0) {
                            total = 1;
                        }
                        EventLog.writeEvent(2721, (user + system + iowait + irq + softIrq) * 100 / total, user * 100 / total, system * 100 / total, iowait * 100 / total, irq * 100 / total, softIrq * 100 / total);
                    }
                }
            }
            BatteryStatsImpl batteryStatsImpl = bstats = this.mBatteryStatsService.getActiveStatistics();
            synchronized (batteryStatsImpl) {
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    if (haveNewCpuStats && bstats.startAddingCpuLocked()) {
                        int totalUTime = 0;
                        int totalSTime = 0;
                        int N = this.mProcessCpuTracker.countStats();
                        for (int i = 0; i < N; ++i) {
                            BatteryStatsImpl.Uid.Proc ps;
                            ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                            if (!st.working) continue;
                            ProcessRecord pr = this.mPidsSelfLocked.get(st.pid);
                            totalUTime += st.rel_utime;
                            totalSTime += st.rel_stime;
                            if (pr != null) {
                                ps = pr.curProcBatteryStats;
                                if (ps == null || !ps.isActive()) {
                                    pr.curProcBatteryStats = ps = bstats.getProcessStatsLocked(pr.info.uid, pr.processName);
                                }
                                ps.addCpuTimeLocked(st.rel_utime, st.rel_stime);
                                pr.curCpuTime += (long)(st.rel_utime + st.rel_stime);
                                continue;
                            }
                            ps = st.batteryStats;
                            if (ps == null || !ps.isActive()) {
                                st.batteryStats = ps = bstats.getProcessStatsLocked(bstats.mapUid(st.uid), st.name);
                            }
                            ps.addCpuTimeLocked(st.rel_utime, st.rel_stime);
                        }
                        int userTime = this.mProcessCpuTracker.getLastUserTime();
                        int systemTime = this.mProcessCpuTracker.getLastSystemTime();
                        int iowaitTime = this.mProcessCpuTracker.getLastIoWaitTime();
                        int irqTime = this.mProcessCpuTracker.getLastIrqTime();
                        int softIrqTime = this.mProcessCpuTracker.getLastSoftIrqTime();
                        int idleTime = this.mProcessCpuTracker.getLastIdleTime();
                        bstats.finishAddingCpuLocked(totalUTime, totalSTime, userTime, systemTime, iowaitTime, irqTime, softIrqTime, idleTime);
                    }
                }
                if (this.mLastWriteTime < now - 1800000L) {
                    this.mLastWriteTime = now;
                    this.mBatteryStatsService.scheduleWriteToDisk();
                }
            }
        }
    }

    @Override
    public void batteryNeedsCpuUpdate() {
        this.updateCpuStatsNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batteryPowerChanged(boolean onBattery) {
        this.updateCpuStatsNow();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mOnBattery = onBattery;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batterySendBroadcast(Intent intent) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, -1, 1000, -1);
        }
    }

    private HashMap<String, IBinder> getCommonServicesLocked(boolean isolated) {
        if (isolated) {
            if (this.mIsolatedAppBindArgs == null) {
                this.mIsolatedAppBindArgs = new HashMap();
                this.mIsolatedAppBindArgs.put("package", ServiceManager.getService("package"));
            }
            return this.mIsolatedAppBindArgs;
        }
        if (this.mAppBindArgs == null) {
            this.mAppBindArgs = new HashMap();
            this.mAppBindArgs.put("package", ServiceManager.getService("package"));
            this.mAppBindArgs.put("window", ServiceManager.getService("window"));
            this.mAppBindArgs.put("alarm", ServiceManager.getService("alarm"));
        }
        return this.mAppBindArgs;
    }

    void setResumedActivityUncheckLocked(ActivityRecord r, String reason) {
        TaskRecord task = r.getTask();
        if (task.isApplicationTask()) {
            if (this.mCurAppTimeTracker != r.appTimeTracker) {
                if (this.mCurAppTimeTracker != null) {
                    this.mCurAppTimeTracker.stop();
                    this.mHandler.obtainMessage(54, this.mCurAppTimeTracker).sendToTarget();
                    this.mStackSupervisor.clearOtherAppTimeTrackers(r.appTimeTracker);
                    this.mCurAppTimeTracker = null;
                }
                if (r.appTimeTracker != null) {
                    this.mCurAppTimeTracker = r.appTimeTracker;
                    this.startTimeTrackingFocusedActivityLocked();
                }
            } else {
                this.startTimeTrackingFocusedActivityLocked();
            }
        } else {
            r.appTimeTracker = null;
        }
        if (task.voiceInteractor != null) {
            this.startRunningVoiceLocked(task.voiceSession, r.info.applicationInfo.uid);
        } else {
            TaskRecord lastResumedActivityTask;
            IVoiceInteractionSession session;
            this.finishRunningVoiceLocked();
            if (this.mLastResumedActivity != null && (session = (lastResumedActivityTask = this.mLastResumedActivity.getTask()) != null && lastResumedActivityTask.voiceSession != null ? lastResumedActivityTask.voiceSession : this.mLastResumedActivity.voiceSession) != null) {
                this.finishVoiceTask(session);
            }
        }
        if (this.mLastResumedActivity != null && r.userId != this.mLastResumedActivity.userId) {
            this.mHandler.removeMessages(52);
            this.mHandler.obtainMessage(52, r.userId, 0).sendToTarget();
        }
        this.mLastResumedActivity = r;
        this.mWindowManager.setFocusedApp(r.appToken, true);
        this.applyUpdateLockStateLocked(r);
        this.applyUpdateVrModeLocked(r);
        EventLogTags.writeAmSetResumedActivity(r == null ? -1 : r.userId, r == null ? "NULL" : r.shortComponentName, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusedStack(int stackId) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "setFocusedStack()");
        long callingId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                Object stack;
                block9: {
                    stack = this.mStackSupervisor.getStack(stackId);
                    if (stack != null) break block9;
                    return;
                }
                ActivityRecord r = ((ActivityStack)stack).topRunningActivityLocked();
                if (this.mStackSupervisor.moveFocusableActivityStackToFrontLocked(r, "setFocusedStack")) {
                    this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusedTask(int taskId) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "setFocusedTask()");
        long callingId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                TaskRecord task;
                block9: {
                    task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
                    if (task != null) break block9;
                    return;
                }
                ActivityRecord r = task.topRunningActivityLocked();
                if (this.mStackSupervisor.moveFocusableActivityStackToFrontLocked(r, "setFocusedTask")) {
                    this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    @Override
    public void registerTaskStackListener(ITaskStackListener listener) throws RemoteException {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "registerTaskStackListener()");
        this.mTaskChangeNotificationController.registerTaskStackListener(listener);
    }

    @Override
    public void unregisterTaskStackListener(ITaskStackListener listener) throws RemoteException {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "unregisterTaskStackListener()");
        this.mTaskChangeNotificationController.unregisterTaskStackListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyActivityDrawn(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.mStackSupervisor.isInAnyStackLocked(token);
            if (r != null) {
                ((ActivityStack)r.getStack()).notifyActivityDrawnLocked(r);
            }
        }
    }

    final void applyUpdateLockStateLocked(ActivityRecord r) {
        boolean nextState = r != null && r.immersive;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(37, nextState ? 1 : 0, 0, r));
    }

    final void applyUpdateVrModeLocked(ActivityRecord r) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(61, 0, 0, r));
    }

    private void sendNotifyVrManagerOfSleepState(boolean isSleeping) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(65, isSleeping ? 1 : 0, 0));
    }

    private void notifyVrManagerOfSleepState(boolean isSleeping) {
        VrManagerInternal vrService = LocalServices.getService(VrManagerInternal.class);
        if (vrService == null) {
            return;
        }
        vrService.onSleepStateChanged(isSleeping);
    }

    final void showAskCompatModeDialogLocked(ActivityRecord r) {
        Message msg = Message.obtain();
        msg.what = 30;
        msg.obj = r.getTask().askedCompatMode ? null : r;
        this.mUiHandler.sendMessage(msg);
    }

    final void showUnsupportedZoomDialogIfNeededLocked(ActivityRecord r) {
        Configuration globalConfig = this.getGlobalConfiguration();
        if (globalConfig.densityDpi != DisplayMetrics.DENSITY_DEVICE_STABLE && r.appInfo.requiresSmallestWidthDp > globalConfig.smallestScreenWidthDp) {
            Message msg = Message.obtain();
            msg.what = 62;
            msg.obj = r;
            this.mUiHandler.sendMessage(msg);
        }
    }

    private int updateLruProcessInternalLocked(ProcessRecord app, long now, int index, String what, Object obj, ProcessRecord srcApp) {
        app.lastActivityTime = now;
        if (app.activities.size() > 0) {
            return index;
        }
        int lrui = this.mLruProcesses.lastIndexOf(app);
        if (lrui < 0) {
            Slog.wtf("ActivityManager", "Adding dependent process " + app + " not on LRU list: " + what + " " + obj + " from " + srcApp);
            return index;
        }
        if (lrui >= index) {
            return index;
        }
        if (lrui >= this.mLruProcessActivityStart) {
            return index;
        }
        this.mLruProcesses.remove(lrui);
        if (index > 0) {
            --index;
        }
        this.mLruProcesses.add(index, app);
        return index;
    }

    static void killProcessGroup(int uid, int pid) {
        if (sKillHandler != null) {
            sKillHandler.sendMessage(sKillHandler.obtainMessage(4000, uid, pid));
        } else {
            Slog.w("ActivityManager", "Asked to kill process group before system bringup!");
            android.os.Process.killProcessGroup(uid, pid);
        }
    }

    final void removeLruProcessLocked(ProcessRecord app) {
        int lrui = this.mLruProcesses.lastIndexOf(app);
        if (lrui >= 0) {
            if (!app.killed) {
                Slog.wtfStack("ActivityManager", "Removing process that hasn't been killed: " + app);
                android.os.Process.killProcessQuiet(app.pid);
                ActivityManagerService.killProcessGroup(app.uid, app.pid);
            }
            if (lrui <= this.mLruProcessActivityStart) {
                --this.mLruProcessActivityStart;
            }
            if (lrui <= this.mLruProcessServiceStart) {
                --this.mLruProcessServiceStart;
            }
            this.mLruProcesses.remove(lrui);
        }
    }

    final void updateLruProcessLocked(ProcessRecord app, boolean activityChange, ProcessRecord client) {
        int j;
        int nextIndex;
        int N;
        long now;
        boolean hasActivity = app.activities.size() > 0 || app.hasClientActivities || app.treatLikeActivity;
        boolean hasService = false;
        if (!activityChange && hasActivity) {
            return;
        }
        ++this.mLruSeq;
        app.lastActivityTime = now = SystemClock.uptimeMillis();
        if (hasActivity ? (N = this.mLruProcesses.size()) > 0 && this.mLruProcesses.get(N - 1) == app : this.mLruProcessServiceStart > 0 && this.mLruProcesses.get(this.mLruProcessServiceStart - 1) == app) {
            return;
        }
        int lrui = this.mLruProcesses.lastIndexOf(app);
        if (app.persistent && lrui >= 0) {
            return;
        }
        if (lrui >= 0) {
            if (lrui < this.mLruProcessActivityStart) {
                --this.mLruProcessActivityStart;
            }
            if (lrui < this.mLruProcessServiceStart) {
                --this.mLruProcessServiceStart;
            }
            this.mLruProcesses.remove(lrui);
        }
        if (hasActivity) {
            int N2 = this.mLruProcesses.size();
            if (app.activities.size() == 0 && this.mLruProcessActivityStart < N2 - 1) {
                this.mLruProcesses.add(N2 - 1, app);
                int uid = app.info.uid;
                for (int i = N2 - 2; i > this.mLruProcessActivityStart; --i) {
                    ProcessRecord subProc = this.mLruProcesses.get(i);
                    if (subProc.info.uid == uid) {
                        if (this.mLruProcesses.get((int)(i - 1)).info.uid == uid) continue;
                        ProcessRecord tmp = this.mLruProcesses.get(i);
                        this.mLruProcesses.set(i, this.mLruProcesses.get(i - 1));
                        this.mLruProcesses.set(i - 1, tmp);
                        --i;
                        continue;
                    }
                    break;
                }
            } else {
                this.mLruProcesses.add(app);
            }
            nextIndex = this.mLruProcessServiceStart;
        } else {
            int index = this.mLruProcessServiceStart;
            if (client != null) {
                int clientIndex = this.mLruProcesses.lastIndexOf(client);
                if (clientIndex <= lrui) {
                    clientIndex = lrui;
                }
                if (clientIndex >= 0 && index > clientIndex) {
                    index = clientIndex;
                }
            }
            this.mLruProcesses.add(index, app);
            nextIndex = index - 1;
            ++this.mLruProcessActivityStart;
            ++this.mLruProcessServiceStart;
        }
        for (j = app.connections.size() - 1; j >= 0; --j) {
            ConnectionRecord cr = app.connections.valueAt(j);
            if (cr.binding == null || cr.serviceDead || cr.binding.service == null || cr.binding.service.app == null || cr.binding.service.app.lruSeq == this.mLruSeq || cr.binding.service.app.persistent) continue;
            nextIndex = this.updateLruProcessInternalLocked(cr.binding.service.app, now, nextIndex, "service connection", cr, app);
        }
        for (j = app.conProviders.size() - 1; j >= 0; --j) {
            ContentProviderRecord cpr = app.conProviders.get((int)j).provider;
            if (cpr.proc == null || cpr.proc.lruSeq == this.mLruSeq || cpr.proc.persistent) continue;
            nextIndex = this.updateLruProcessInternalLocked(cpr.proc, now, nextIndex, "provider reference", cpr, app);
        }
    }

    final ProcessRecord getProcessRecordLocked(String processName, int uid, boolean keepIfLarge) {
        ProcessRecord proc;
        if (uid == 1000) {
            SparseArray<ProcessRecord> procs = this.mProcessNames.getMap().get(processName);
            if (procs == null) {
                return null;
            }
            int procCount = procs.size();
            for (int i = 0; i < procCount; ++i) {
                int procUid = procs.keyAt(i);
                if (UserHandle.isApp(procUid) || !UserHandle.isSameUser(procUid, uid)) continue;
                return procs.valueAt(i);
            }
        }
        if ((proc = this.mProcessNames.get(processName, uid)) != null && !keepIfLarge && this.mLastMemoryLevel > 0 && proc.setProcState >= 17 && proc.lastCachedPss >= this.mProcessList.getCachedRestoreThresholdKb()) {
            if (proc.baseProcessTracker != null) {
                proc.baseProcessTracker.reportCachedKill(proc.pkgList, proc.lastCachedPss);
            }
            proc.kill(Long.toString(proc.lastCachedPss) + "k from cached", true);
        }
        return proc;
    }

    void notifyPackageUse(String packageName, int reason) {
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            pm.notifyPackageUse(packageName, reason);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    boolean isNextTransitionForward() {
        int transit = this.mWindowManager.getPendingAppTransition();
        return transit == 6 || transit == 8 || transit == 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int startIsolatedProcess(String entryPoint, String[] entryPointArgs, String processName, String abiOverride, int uid, Runnable crashHandler) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ApplicationInfo info = new ApplicationInfo();
            info.uid = 1000;
            info.processName = processName;
            info.className = entryPoint;
            info.packageName = "android";
            info.seInfoUser = ":complete";
            ProcessRecord proc = this.startProcessLocked(processName, info, false, 0, "", null, true, true, uid, true, abiOverride, entryPoint, entryPointArgs, crashHandler);
            return proc != null ? proc.pid : 0;
        }
    }

    final ProcessRecord startProcessLocked(String processName, ApplicationInfo info, boolean knownToBeDead, int intentFlags, String hostingType, ComponentName hostingName, boolean allowWhileBooting, boolean isolated, boolean keepIfLarge) {
        return this.startProcessLocked(processName, info, knownToBeDead, intentFlags, hostingType, hostingName, allowWhileBooting, isolated, 0, keepIfLarge, null, null, null, null);
    }

    final ProcessRecord startProcessLocked(String processName, ApplicationInfo info, boolean knownToBeDead, int intentFlags, String hostingType, ComponentName hostingName, boolean allowWhileBooting, boolean isolated, int isolatedUid, boolean keepIfLarge, String abiOverride, String entryPoint, String[] entryPointArgs, Runnable crashHandler) {
        String hostingNameStr;
        ProcessRecord app;
        long startTime = SystemClock.elapsedRealtime();
        if (!isolated) {
            app = this.getProcessRecordLocked(processName, info.uid, keepIfLarge);
            this.checkTime(startTime, "startProcess: after getProcessRecord");
            if ((intentFlags & 4) != 0) {
                if (this.mAppErrors.isBadProcessLocked(info)) {
                    return null;
                }
            } else {
                this.mAppErrors.resetProcessCrashTimeLocked(info);
                if (this.mAppErrors.isBadProcessLocked(info)) {
                    EventLog.writeEvent(30016, UserHandle.getUserId(info.uid), info.uid, info.processName);
                    this.mAppErrors.clearBadProcessLocked(info);
                    if (app != null) {
                        app.bad = false;
                    }
                }
            }
        } else {
            app = null;
        }
        if (app != null && app.pid > 0) {
            if (!knownToBeDead && !app.killed || app.thread == null) {
                app.addPackage(info.packageName, info.versionCode, this.mProcessStats);
                this.checkTime(startTime, "startProcess: done, added package to proc");
                return app;
            }
            this.checkTime(startTime, "startProcess: bad proc running, killing");
            ActivityManagerService.killProcessGroup(app.uid, app.pid);
            this.handleAppDiedLocked(app, true, true);
            this.checkTime(startTime, "startProcess: done killing old proc");
        }
        String string2 = hostingNameStr = hostingName != null ? hostingName.flattenToShortString() : null;
        if (app == null) {
            this.checkTime(startTime, "startProcess: creating new process record");
            app = this.newProcessRecordLocked(info, processName, isolated, isolatedUid);
            if (app == null) {
                Slog.w("ActivityManager", "Failed making new process record for " + processName + "/" + info.uid + " isolated=" + isolated);
                return null;
            }
            app.crashHandler = crashHandler;
            this.checkTime(startTime, "startProcess: done creating new process record");
        } else {
            app.addPackage(info.packageName, info.versionCode, this.mProcessStats);
            this.checkTime(startTime, "startProcess: added package to existing proc");
        }
        if (!(this.mProcessesReady || this.isAllowedWhileBooting(info) || allowWhileBooting)) {
            if (!this.mProcessesOnHold.contains(app)) {
                this.mProcessesOnHold.add(app);
            }
            this.checkTime(startTime, "startProcess: returning with proc on hold");
            return app;
        }
        this.checkTime(startTime, "startProcess: stepping in to startProcess");
        this.startProcessLocked(app, hostingType, hostingNameStr, abiOverride, entryPoint, entryPointArgs);
        this.checkTime(startTime, "startProcess: done starting proc!");
        return app.pid != 0 ? app : null;
    }

    boolean isAllowedWhileBooting(ApplicationInfo ai) {
        return (ai.flags & 8) != 0;
    }

    private final void startProcessLocked(ProcessRecord app, String hostingType, String hostingNameStr) {
        this.startProcessLocked(app, hostingType, hostingNameStr, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startProcessLocked(ProcessRecord app, String hostingType, String hostingNameStr, String abiOverride, String entryPoint, String[] entryPointArgs) {
        long startTime = SystemClock.elapsedRealtime();
        if (app.pid > 0 && app.pid != MY_PID) {
            this.checkTime(startTime, "startProcess: removing from pids map");
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.remove(app.pid);
                this.mHandler.removeMessages(20, app);
            }
            this.checkTime(startTime, "startProcess: done removing from pids map");
            app.setPid(0);
        }
        this.mProcessesOnHold.remove(app);
        this.checkTime(startTime, "startProcess: starting to update cpu stats");
        this.updateCpuStats();
        this.checkTime(startTime, "startProcess: done updating cpu stats");
        try {
            ProcessRecord oldApp;
            boolean isActivityProcess;
            String requiredAbi;
            String genDebugInfoProperty;
            try {
                int userId = UserHandle.getUserId(app.uid);
                AppGlobals.getPackageManager().checkPackageStartable(app.info.packageName, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            int uid = app.uid;
            int[] gids = null;
            int mountExternal = 0;
            if (!app.isolated) {
                int[] permGids = null;
                try {
                    this.checkTime(startTime, "startProcess: getting gids from package manager");
                    IPackageManager pm = AppGlobals.getPackageManager();
                    permGids = pm.getPackageGids(app.info.packageName, 0x10000000, app.userId);
                    StorageManagerInternal storageManagerInternal = LocalServices.getService(StorageManagerInternal.class);
                    mountExternal = storageManagerInternal.getExternalStorageMountMode(uid, app.info.packageName);
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
                if (ArrayUtils.isEmpty(permGids)) {
                    gids = new int[3];
                } else {
                    gids = new int[permGids.length + 3];
                    System.arraycopy((int[])permGids, (int)0, (int[])gids, (int)3, (int)permGids.length);
                }
                gids[0] = UserHandle.getSharedAppGid(UserHandle.getAppId(uid));
                gids[1] = UserHandle.getCacheAppGid(UserHandle.getAppId(uid));
                gids[2] = UserHandle.getUserGid(UserHandle.getUserId(uid));
            }
            this.checkTime(startTime, "startProcess: building args");
            if (this.mFactoryTest != 0) {
                if (this.mFactoryTest == 1 && this.mTopComponent != null && app.processName.equals(this.mTopComponent.getPackageName())) {
                    uid = 0;
                }
                if (this.mFactoryTest == 2 && (app.info.flags & 0x10) != 0) {
                    uid = 0;
                }
            }
            int debugFlags = 0;
            if ((app.info.flags & 2) != 0) {
                debugFlags |= 1;
                debugFlags |= 0x100;
                debugFlags |= 2;
            }
            if ((app.info.flags & 0x4000) != 0 || this.mSafeMode) {
                debugFlags |= 8;
            }
            if ("1".equals(SystemProperties.get("debug.checkjni"))) {
                debugFlags |= 2;
            }
            if ("true".equals(genDebugInfoProperty = SystemProperties.get("debug.generate-debug-info"))) {
                debugFlags |= 0x20;
            }
            if ("1".equals(SystemProperties.get("debug.jni.logging"))) {
                debugFlags |= 0x10;
            }
            if ("1".equals(SystemProperties.get("debug.assert"))) {
                debugFlags |= 4;
            }
            if (this.mNativeDebuggingApp != null && this.mNativeDebuggingApp.equals(app.processName)) {
                debugFlags |= 0x40;
                debugFlags |= 0x20;
                debugFlags |= 0x80;
                this.mNativeDebuggingApp = null;
            }
            String invokeWith = null;
            if ((app.info.flags & 2) != 0) {
                String wrapperFileName = app.info.nativeLibraryDir + "/wrap.sh";
                StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
                try {
                    if (new File(wrapperFileName).exists()) {
                        invokeWith = "/system/bin/logwrapper " + wrapperFileName;
                    }
                }
                finally {
                    StrictMode.setThreadPolicy(oldPolicy);
                }
            }
            String string2 = requiredAbi = abiOverride != null ? abiOverride : app.info.primaryCpuAbi;
            if (requiredAbi == null) {
                requiredAbi = Build.SUPPORTED_ABIS[0];
            }
            String instructionSet = null;
            if (app.info.primaryCpuAbi != null) {
                instructionSet = VMRuntime.getInstructionSet(app.info.primaryCpuAbi);
            }
            app.gids = gids;
            app.requiredAbi = requiredAbi;
            app.instructionSet = instructionSet;
            if (TextUtils.isEmpty(app.info.seInfoUser)) {
                Slog.wtf("ActivityManager", "SELinux tag not defined", new IllegalStateException("SELinux tag not defined for " + app.info.packageName + " (uid " + app.uid + ")"));
            }
            String seInfo = app.info.seInfo + (TextUtils.isEmpty(app.info.seInfoUser) ? "" : app.info.seInfoUser);
            boolean bl = isActivityProcess = entryPoint == null;
            if (entryPoint == null) {
                entryPoint = "android.app.ActivityThread";
            }
            Trace.traceBegin(64L, "Start proc: " + app.processName);
            this.checkTime(startTime, "startProcess: asking zygote to start proc");
            Process.ProcessStartResult startResult = hostingType.equals("webview_service") ? android.os.Process.startWebView(entryPoint, app.processName, uid, uid, gids, debugFlags, mountExternal, app.info.targetSdkVersion, seInfo, requiredAbi, instructionSet, app.info.dataDir, null, entryPointArgs) : android.os.Process.start(entryPoint, app.processName, uid, uid, gids, debugFlags, mountExternal, app.info.targetSdkVersion, seInfo, requiredAbi, instructionSet, app.info.dataDir, invokeWith, entryPointArgs);
            this.checkTime(startTime, "startProcess: returned from zygote!");
            Trace.traceEnd(64L);
            this.mBatteryStatsService.noteProcessStart(app.processName, app.info.uid);
            this.checkTime(startTime, "startProcess: done updating battery stats");
            EventLog.writeEvent(30014, UserHandle.getUserId(uid), startResult.pid, uid, app.processName, hostingType, hostingNameStr != null ? hostingNameStr : "");
            try {
                AppGlobals.getPackageManager().logAppProcessStartIfNeeded(app.processName, app.uid, seInfo, app.info.sourceDir, startResult.pid);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (app.persistent) {
                Watchdog.getInstance().processStarted(app.processName, startResult.pid);
            }
            this.checkTime(startTime, "startProcess: building log message");
            StringBuilder buf = this.mStringBuilder;
            buf.setLength(0);
            buf.append("Start proc ");
            buf.append(startResult.pid);
            buf.append(':');
            buf.append(app.processName);
            buf.append('/');
            UserHandle.formatUid(buf, uid);
            if (!isActivityProcess) {
                buf.append(" [");
                buf.append(entryPoint);
                buf.append("]");
            }
            buf.append(" for ");
            buf.append(hostingType);
            if (hostingNameStr != null) {
                buf.append(" ");
                buf.append(hostingNameStr);
            }
            Slog.i("ActivityManager", buf.toString());
            app.setPid(startResult.pid);
            app.usingWrapper = startResult.usingWrapper;
            app.removed = false;
            app.killed = false;
            app.killedByAm = false;
            this.checkTime(startTime, "startProcess: starting to update pids map");
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                oldApp = this.mPidsSelfLocked.get(startResult.pid);
            }
            if (oldApp != null && !app.isolated) {
                Slog.w("ActivityManager", "Reusing pid " + startResult.pid + " while app is still mapped to it");
                this.cleanUpApplicationRecordLocked(oldApp, false, false, -1, true);
            }
            sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.put(startResult.pid, app);
                if (isActivityProcess) {
                    Message msg = this.mHandler.obtainMessage(20);
                    msg.obj = app;
                    this.mHandler.sendMessageDelayed(msg, startResult.usingWrapper ? 1200000L : 10000L);
                }
            }
            this.checkTime(startTime, "startProcess: done updating pids map");
        }
        catch (RuntimeException e) {
            Slog.e("ActivityManager", "Failure starting process " + app.processName, e);
            this.forceStopPackageLocked(app.info.packageName, UserHandle.getAppId(app.uid), false, false, true, false, false, UserHandle.getUserId(app.userId), "start failure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUsageStats(ActivityRecord component, boolean resumed) {
        BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
        if (resumed) {
            if (this.mUsageStatsService != null) {
                this.mUsageStatsService.reportEvent(component.realActivity, component.userId, 1);
            }
            BatteryStatsImpl batteryStatsImpl = stats;
            synchronized (batteryStatsImpl) {
                stats.noteActivityResumedLocked(component.app.uid);
            }
        }
        if (this.mUsageStatsService != null) {
            this.mUsageStatsService.reportEvent(component.realActivity, component.userId, 2);
        }
        BatteryStatsImpl batteryStatsImpl = stats;
        synchronized (batteryStatsImpl) {
            stats.noteActivityPausedLocked(component.app.uid);
        }
    }

    Intent getHomeIntent() {
        Intent intent = new Intent(this.mTopAction, this.mTopData != null ? Uri.parse(this.mTopData) : null);
        intent.setComponent(this.mTopComponent);
        intent.addFlags(256);
        if (this.mFactoryTest != 1) {
            intent.addCategory("android.intent.category.HOME");
        }
        return intent;
    }

    boolean startHomeActivityLocked(int userId, String reason) {
        if (this.mFactoryTest == 1 && this.mTopAction == null) {
            return false;
        }
        Intent intent = this.getHomeIntent();
        ActivityInfo aInfo = this.resolveActivityInfo(intent, 1024, userId);
        if (aInfo != null) {
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            aInfo = new ActivityInfo(aInfo);
            aInfo.applicationInfo = this.getAppInfoForUser(aInfo.applicationInfo, userId);
            ProcessRecord app = this.getProcessRecordLocked(aInfo.processName, aInfo.applicationInfo.uid, true);
            if (app == null || app.instr == null) {
                intent.setFlags(intent.getFlags() | 0x10000000);
                int resolvedUserId = UserHandle.getUserId(aInfo.applicationInfo.uid);
                String myReason = reason + ":" + userId + ":" + resolvedUserId;
                this.mActivityStarter.startHomeActivityLocked(intent, aInfo, myReason);
            }
        } else {
            Slog.wtf("ActivityManager", "No home screen found for " + intent, new Throwable());
        }
        return true;
    }

    private ActivityInfo resolveActivityInfo(Intent intent, int flags, int userId) {
        ActivityInfo ai = null;
        ComponentName comp = intent.getComponent();
        try {
            if (comp != null) {
                ai = AppGlobals.getPackageManager().getActivityInfo(comp, flags, userId);
            } else {
                ResolveInfo info = AppGlobals.getPackageManager().resolveIntent(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags, userId);
                if (info != null) {
                    ai = info.activityInfo;
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return ai;
    }

    void startSetupActivityLocked() {
        if (this.mCheckedForSetup) {
            return;
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        if (this.mFactoryTest != 1 && Settings.Global.getInt(resolver, "device_provisioned", 0) != 0) {
            this.mCheckedForSetup = true;
            Intent intent = new Intent("android.intent.action.UPGRADE_SETUP");
            List<ResolveInfo> ris = this.mContext.getPackageManager().queryIntentActivities(intent, 0x100080);
            if (!ris.isEmpty()) {
                String vers;
                ResolveInfo ri = ris.get(0);
                String string2 = vers = ri.activityInfo.metaData != null ? ri.activityInfo.metaData.getString("android.SETUP_VERSION") : null;
                if (vers == null && ri.activityInfo.applicationInfo.metaData != null) {
                    vers = ri.activityInfo.applicationInfo.metaData.getString("android.SETUP_VERSION");
                }
                String lastVers = Settings.Secure.getString(resolver, "last_setup_shown");
                if (vers != null && !vers.equals(lastVers)) {
                    intent.setFlags(0x10000000);
                    intent.setComponent(new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name));
                    this.mActivityStarter.startActivityLocked(null, intent, null, null, ri.activityInfo, null, null, null, null, null, 0, 0, 0, null, 0, 0, 0, null, false, false, null, null, null, "startSetupActivity");
                }
            }
        }
    }

    CompatibilityInfo compatibilityInfoForPackageLocked(ApplicationInfo ai) {
        return this.mCompatModePackages.compatibilityInfoForPackageLocked(ai);
    }

    void enforceNotIsolatedCaller(String caller) {
        if (UserHandle.isIsolated(Binder.getCallingUid())) {
            throw new SecurityException("Isolated process not allowed to call " + caller);
        }
    }

    void enforceShellRestriction(String restriction, int userHandle) {
        if (Binder.getCallingUid() == 2000 && (userHandle < 0 || this.mUserController.hasUserRestriction(restriction, userHandle))) {
            throw new SecurityException("Shell does not have permission to access user " + userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFrontActivityScreenCompatMode() {
        this.enforceNotIsolatedCaller("getFrontActivityScreenCompatMode");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mCompatModePackages.getFrontActivityScreenCompatModeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFrontActivityScreenCompatMode(int mode) {
        this.enforceCallingPermission("android.permission.SET_SCREEN_COMPATIBILITY", "setFrontActivityScreenCompatMode");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mCompatModePackages.setFrontActivityScreenCompatModeLocked(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPackageScreenCompatMode(String packageName) {
        this.enforceNotIsolatedCaller("getPackageScreenCompatMode");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mCompatModePackages.getPackageScreenCompatModeLocked(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPackageScreenCompatMode(String packageName, int mode) {
        this.enforceCallingPermission("android.permission.SET_SCREEN_COMPATIBILITY", "setPackageScreenCompatMode");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mCompatModePackages.setPackageScreenCompatModeLocked(packageName, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getPackageAskScreenCompat(String packageName) {
        this.enforceNotIsolatedCaller("getPackageAskScreenCompat");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mCompatModePackages.getPackageAskCompatModeLocked(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPackageAskScreenCompat(String packageName, boolean ask) {
        this.enforceCallingPermission("android.permission.SET_SCREEN_COMPATIBILITY", "setPackageAskScreenCompat");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mCompatModePackages.setPackageAskCompatModeLocked(packageName, ask);
        }
    }

    private boolean hasUsageStatsPermission(String callingPackage) {
        int mode = this.mAppOpsService.checkOperation(43, Binder.getCallingUid(), callingPackage);
        if (mode == 3) {
            return this.checkCallingPermission("android.permission.PACKAGE_USAGE_STATS") == 0;
        }
        return mode == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPackageProcessState(String packageName, String callingPackage) {
        if (!this.hasUsageStatsPermission(callingPackage)) {
            this.enforceCallingPermission("android.permission.PACKAGE_USAGE_STATS", "getPackageProcessState");
        }
        int procState = 18;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord proc = this.mLruProcesses.get(i);
                if (procState <= proc.setProcState || !proc.pkgList.containsKey(packageName) && (proc.pkgDeps == null || !proc.pkgDeps.contains(packageName))) continue;
                procState = proc.setProcState;
            }
        }
        return procState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setProcessMemoryTrimLevel(String process, int userId, int level) throws RemoteException {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app = this.findProcessLocked(process, userId, "setProcessMemoryTrimLevel");
            if (app == null) {
                throw new IllegalArgumentException("Unknown process: " + process);
            }
            if (app.thread == null) {
                throw new IllegalArgumentException("Process has no app thread");
            }
            if (app.trimMemoryLevel >= level) {
                throw new IllegalArgumentException("Unable to set a higher trim level than current level");
            }
            if (level >= 20 && app.curProcState <= 6) {
                throw new IllegalArgumentException("Unable to set a background trim level on a foreground process");
            }
            app.thread.scheduleTrimMemory(level);
            app.trimMemoryLevel = level;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchProcessesChanged() {
        int j;
        int N;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            N = this.mPendingProcessChanges.size();
            if (this.mActiveProcessChanges.length < N) {
                this.mActiveProcessChanges = new ProcessChangeItem[N];
            }
            this.mPendingProcessChanges.toArray(this.mActiveProcessChanges);
            this.mPendingProcessChanges.clear();
        }
        int i = this.mProcessObservers.beginBroadcast();
        while (i > 0) {
            IProcessObserver observer;
            if ((observer = this.mProcessObservers.getBroadcastItem(--i)) == null) continue;
            try {
                for (j = 0; j < N; ++j) {
                    ProcessChangeItem item = this.mActiveProcessChanges[j];
                    if ((item.changes & 1) == 0) continue;
                    observer.onForegroundActivitiesChanged(item.pid, item.uid, item.foregroundActivities);
                }
            }
            catch (RemoteException j2) {
            }
        }
        this.mProcessObservers.finishBroadcast();
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            for (j = 0; j < N; ++j) {
                this.mAvailProcessChanges.add(this.mActiveProcessChanges[j]);
            }
        }
    }

    private void dispatchProcessDied(int pid, int uid) {
        int i = this.mProcessObservers.beginBroadcast();
        while (i > 0) {
            IProcessObserver observer;
            if ((observer = this.mProcessObservers.getBroadcastItem(--i)) == null) continue;
            try {
                observer.onProcessDied(pid, uid);
            }
            catch (RemoteException remoteException) {}
        }
        this.mProcessObservers.finishBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchUidsChanged() {
        int N;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            N = this.mPendingUidChanges.size();
            if (this.mActiveUidChanges.length < N) {
                this.mActiveUidChanges = new UidRecord.ChangeItem[N];
            }
            for (int i = 0; i < N; ++i) {
                UidRecord.ChangeItem change;
                this.mActiveUidChanges[i] = change = this.mPendingUidChanges.get(i);
                if (change.uidRecord == null) continue;
                change.uidRecord.pendingChange = null;
                change.uidRecord = null;
            }
            this.mPendingUidChanges.clear();
        }
        int i = this.mUidObservers.beginBroadcast();
        while (i > 0) {
            this.dispatchUidsChangedForObserver(this.mUidObservers.getBroadcastItem(--i), (UidObserverRegistration)this.mUidObservers.getBroadcastCookie(i), N);
        }
        this.mUidObservers.finishBroadcast();
        if (this.mUidObservers.getRegisteredCallbackCount() > 0) {
            for (int j = 0; j < N; ++j) {
                UidRecord.ChangeItem item = this.mActiveUidChanges[j];
                if (item.change == 1 || item.change == 2) {
                    this.mValidateUids.remove(item.uid);
                    continue;
                }
                UidRecord validateUid = this.mValidateUids.get(item.uid);
                if (validateUid == null) {
                    validateUid = new UidRecord(item.uid);
                    this.mValidateUids.put(item.uid, validateUid);
                }
                if (item.change == 3) {
                    validateUid.idle = true;
                } else if (item.change == 4) {
                    validateUid.idle = false;
                }
                validateUid.curProcState = validateUid.setProcState = item.processState;
                validateUid.lastDispatchedProcStateSeq = item.procStateSeq;
            }
        }
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            for (int j = 0; j < N; ++j) {
                this.mAvailUidChanges.add(this.mActiveUidChanges[j]);
            }
        }
    }

    private void dispatchUidsChangedForObserver(IUidObserver observer, UidObserverRegistration reg, int changesSize) {
        if (observer == null) {
            return;
        }
        try {
            for (int j = 0; j < changesSize; ++j) {
                UidRecord.ChangeItem item = this.mActiveUidChanges[j];
                int change = item.change;
                if (change == 3 || change == 2) {
                    if ((reg.which & 4) != 0) {
                        observer.onUidIdle(item.uid, item.ephemeral);
                    }
                } else if (change == 4 && (reg.which & 8) != 0) {
                    observer.onUidActive(item.uid);
                }
                if (change == 1 || change == 2) {
                    if ((reg.which & 2) != 0) {
                        observer.onUidGone(item.uid, item.ephemeral);
                    }
                    if (reg.lastProcStates == null) continue;
                    reg.lastProcStates.delete(item.uid);
                    continue;
                }
                if ((reg.which & 1) == 0) continue;
                boolean doReport = true;
                if (reg.cutpoint >= 0) {
                    int lastState = reg.lastProcStates.get(item.uid, -1);
                    if (lastState != -1) {
                        boolean lastAboveCut = lastState <= reg.cutpoint;
                        boolean newAboveCut = item.processState <= reg.cutpoint;
                        doReport = lastAboveCut != newAboveCut;
                    } else {
                        boolean bl = doReport = item.processState != 18;
                    }
                }
                if (!doReport) continue;
                if (reg.lastProcStates != null) {
                    reg.lastProcStates.put(item.uid, item.processState);
                }
                observer.onUidStateChanged(item.uid, item.processState, item.procStateSeq);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public final int startActivity(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, Bundle bOptions) {
        return this.startActivityAsUser(caller, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, profilerInfo, bOptions, UserHandle.getCallingUserId());
    }

    final int startActivity(Intent intent, ActivityStackSupervisor.ActivityContainer container) {
        this.enforceNotIsolatedCaller("ActivityContainer.startActivity");
        int userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), this.mStackSupervisor.mCurrentUser, false, 2, "ActivityContainer", null);
        String mimeType = intent.getType();
        Uri data = intent.getData();
        if (mimeType == null && data != null && "content".equals(data.getScheme())) {
            mimeType = this.getProviderMimeType(data, userId);
        }
        container.checkEmbeddedAllowedInner(userId, intent, mimeType);
        intent.addFlags(0x18010000);
        return this.mActivityStarter.startActivityMayWait(null, -1, null, intent, mimeType, null, null, null, null, 0, 0, null, null, null, null, false, userId, container, null, "startActivity");
    }

    @Override
    public final int startActivityAsUser(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, Bundle bOptions, int userId) {
        this.enforceNotIsolatedCaller("startActivity");
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startActivity", null);
        return this.mActivityStarter.startActivityMayWait(caller, -1, callingPackage, intent, resolvedType, null, null, resultTo, resultWho, requestCode, startFlags, profilerInfo, null, null, bOptions, false, userId, null, null, "startActivityAsUser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int startActivityAsCaller(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, Bundle bOptions, boolean ignoreTargetSecurity, int userId) {
        String targetPackage;
        int targetUid;
        ActivityRecord sourceRecord;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (resultTo == null) {
                throw new SecurityException("Must be called from an activity");
            }
            sourceRecord = this.mStackSupervisor.isInAnyStackLocked(resultTo);
            if (sourceRecord == null) {
                throw new SecurityException("Called with bad activity token: " + resultTo);
            }
            if (!sourceRecord.info.packageName.equals("android")) {
                throw new SecurityException("Must be called from an activity that is declared in the android package");
            }
            if (sourceRecord.app == null) {
                throw new SecurityException("Called without a process attached to activity");
            }
            if (UserHandle.getAppId(sourceRecord.app.uid) != 1000 && sourceRecord.app.uid != sourceRecord.launchedFromUid) {
                throw new SecurityException("Calling activity in uid " + sourceRecord.app.uid + " must be system uid or original calling uid " + sourceRecord.launchedFromUid);
            }
            if (ignoreTargetSecurity) {
                if (intent.getComponent() == null) {
                    throw new SecurityException("Component must be specified with ignoreTargetSecurity");
                }
                if (intent.getSelector() != null) {
                    throw new SecurityException("Selector not allowed with ignoreTargetSecurity");
                }
            }
            targetUid = sourceRecord.launchedFromUid;
            targetPackage = sourceRecord.launchedFromPackage;
        }
        if (userId == -10000) {
            userId = UserHandle.getUserId(sourceRecord.app.uid);
        }
        int ret = this.mActivityStarter.startActivityMayWait(null, targetUid, targetPackage, intent, resolvedType, null, null, resultTo, resultWho, requestCode, startFlags, null, null, null, bOptions, ignoreTargetSecurity, userId, null, null, "startActivityAsCaller");
        return ret;
    }

    @Override
    public final WaitResult startActivityAndWait(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, Bundle bOptions, int userId) {
        this.enforceNotIsolatedCaller("startActivityAndWait");
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startActivityAndWait", null);
        WaitResult res = new WaitResult();
        this.mActivityStarter.startActivityMayWait(caller, -1, callingPackage, intent, resolvedType, null, null, resultTo, resultWho, requestCode, startFlags, profilerInfo, res, null, bOptions, false, userId, null, null, "startActivityAndWait");
        return res;
    }

    @Override
    public final int startActivityWithConfig(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, Configuration config, Bundle bOptions, int userId) {
        this.enforceNotIsolatedCaller("startActivityWithConfig");
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startActivityWithConfig", null);
        int ret = this.mActivityStarter.startActivityMayWait(caller, -1, callingPackage, intent, resolvedType, null, null, resultTo, resultWho, requestCode, startFlags, null, null, config, bOptions, false, userId, null, null, "startActivityWithConfig");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startActivityIntentSender(IApplicationThread caller, IIntentSender target, IBinder whitelistToken, Intent fillInIntent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int flagsMask, int flagsValues, Bundle bOptions) throws TransactionTooLargeException {
        this.enforceNotIsolatedCaller("startActivityIntentSender");
        if (fillInIntent != null && fillInIntent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        if (!(target instanceof PendingIntentRecord)) {
            throw new IllegalArgumentException("Bad PendingIntent object");
        }
        PendingIntentRecord pir = (PendingIntentRecord)target;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = this.getFocusedStack();
            if (stack.mResumedActivity != null && stack.mResumedActivity.info.applicationInfo.uid == Binder.getCallingUid()) {
                this.mAppSwitchesAllowedTime = 0L;
            }
        }
        int ret = pir.sendInner(0, fillInIntent, resolvedType, whitelistToken, null, null, resultTo, resultWho, requestCode, flagsMask, flagsValues, bOptions, null);
        return ret;
    }

    @Override
    public int startVoiceActivity(String callingPackage, int callingPid, int callingUid, Intent intent, String resolvedType, IVoiceInteractionSession session, IVoiceInteractor interactor, int startFlags, ProfilerInfo profilerInfo, Bundle bOptions, int userId) {
        if (this.checkCallingPermission("android.permission.BIND_VOICE_INTERACTION") != 0) {
            String msg = "Permission Denial: startVoiceActivity() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.BIND_VOICE_INTERACTION";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        if (session == null || interactor == null) {
            throw new NullPointerException("null session or interactor");
        }
        userId = this.mUserController.handleIncomingUser(callingPid, callingUid, userId, false, 2, "startVoiceActivity", null);
        return this.mActivityStarter.startActivityMayWait(null, callingUid, callingPackage, intent, resolvedType, session, interactor, null, null, 0, startFlags, profilerInfo, null, null, bOptions, false, userId, null, null, "startVoiceActivity");
    }

    @Override
    public int startAssistantActivity(String callingPackage, int callingPid, int callingUid, Intent intent, String resolvedType, Bundle bOptions, int userId) {
        if (this.checkCallingPermission("android.permission.BIND_VOICE_INTERACTION") != 0) {
            String msg = "Permission Denial: startAssistantActivity() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.BIND_VOICE_INTERACTION";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        userId = this.mUserController.handleIncomingUser(callingPid, callingUid, userId, false, 2, "startAssistantActivity", null);
        return this.mActivityStarter.startActivityMayWait(null, callingUid, callingPackage, intent, resolvedType, null, null, null, null, 0, 0, null, null, null, bOptions, false, userId, null, null, "startAssistantActivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLocalVoiceInteraction(IBinder callingActivity, Bundle options) throws RemoteException {
        Slog.i("ActivityManager", "Activity tried to startVoiceInteraction");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord activity = this.getFocusedStack().topActivity();
            if (ActivityRecord.forTokenLocked(callingActivity) != activity) {
                throw new SecurityException("Only focused activity can call startVoiceInteraction");
            }
            if (this.mRunningVoice != null || activity.getTask().voiceSession != null || activity.voiceSession != null) {
                Slog.w("ActivityManager", "Already in a voice interaction, cannot start new voice interaction");
                return;
            }
            if (activity.pendingVoiceInteractionStart) {
                Slog.w("ActivityManager", "Pending start of voice interaction already.");
                return;
            }
            activity.pendingVoiceInteractionStart = true;
        }
        LocalServices.getService(VoiceInteractionManagerInternal.class).startLocalVoiceInteraction(callingActivity, options);
    }

    @Override
    public void stopLocalVoiceInteraction(IBinder callingActivity) throws RemoteException {
        LocalServices.getService(VoiceInteractionManagerInternal.class).stopLocalVoiceInteraction(callingActivity);
    }

    @Override
    public boolean supportsLocalVoiceInteraction() throws RemoteException {
        return LocalServices.getService(VoiceInteractionManagerInternal.class).supportsLocalVoiceInteraction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onLocalVoiceInteractionStartedLocked(IBinder activity, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor) {
        ActivityRecord activityToCallback = ActivityRecord.forTokenLocked(activity);
        if (activityToCallback == null) {
            return;
        }
        activityToCallback.setVoiceSessionLocked(voiceSession);
        try {
            activityToCallback.app.thread.scheduleLocalVoiceInteractionStarted(activity, voiceInteractor);
            long token = Binder.clearCallingIdentity();
            try {
                this.startRunningVoiceLocked(voiceSession, activityToCallback.appInfo.uid);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
        catch (RemoteException re) {
            activityToCallback.clearVoiceSessionLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVoiceKeepAwake(IVoiceInteractionSession session, boolean keepAwake) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mRunningVoice != null && this.mRunningVoice.asBinder() == session.asBinder()) {
                if (keepAwake) {
                    this.mVoiceWakeLock.acquire();
                } else {
                    this.mVoiceWakeLock.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startNextMatchingActivity(IBinder callingActivity, Intent intent, Bundle bOptions) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityOptions options = ActivityOptions.fromBundle(bOptions);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(callingActivity);
            if (r == null) {
                ActivityOptions.abort(options);
                return false;
            }
            if (r.app == null || r.app.thread == null) {
                ActivityOptions.abort(options);
                return false;
            }
            intent = new Intent(intent);
            intent.setDataAndType(r.intent.getData(), r.intent.getType());
            intent.setComponent(null);
            boolean debug = (intent.getFlags() & 8) != 0;
            ActivityInfo aInfo = null;
            try {
                List resolves = AppGlobals.getPackageManager().queryIntentActivities(intent, r.resolvedType, 66560, UserHandle.getCallingUserId()).getList();
                int N = resolves != null ? resolves.size() : 0;
                for (int i = 0; i < N; ++i) {
                    ResolveInfo rInfo = (ResolveInfo)resolves.get(i);
                    if (!rInfo.activityInfo.packageName.equals(r.packageName) || !rInfo.activityInfo.name.equals(r.info.name)) continue;
                    if (++i < N) {
                        aInfo = ((ResolveInfo)resolves.get((int)i)).activityInfo;
                    }
                    if (debug) {
                        Slog.v("ActivityManager", "Next matching activity: found current " + r.packageName + "/" + r.info.name);
                        Slog.v("ActivityManager", "Next matching activity: next is " + (aInfo == null ? "null" : aInfo.packageName + "/" + aInfo.name));
                    }
                    break;
                }
            }
            catch (RemoteException resolves) {
                // empty catch block
            }
            if (aInfo == null) {
                ActivityOptions.abort(options);
                if (debug) {
                    Slog.d("ActivityManager", "Next matching activity: nothing found");
                }
                return false;
            }
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            intent.setFlags(intent.getFlags() & 0xE1FFFFFF);
            boolean wasFinishing = r.finishing;
            r.finishing = true;
            ActivityRecord resultTo = r.resultTo;
            String resultWho = r.resultWho;
            int requestCode = r.requestCode;
            r.resultTo = null;
            if (resultTo != null) {
                resultTo.removeResultsLocked(r, resultWho, requestCode);
            }
            long origId = Binder.clearCallingIdentity();
            int res = this.mActivityStarter.startActivityLocked(r.app.thread, intent, null, r.resolvedType, aInfo, null, null, null, resultTo != null ? resultTo.appToken : null, resultWho, requestCode, -1, r.launchedFromUid, r.launchedFromPackage, -1, r.launchedFromUid, 0, options, false, false, null, null, null, "startNextMatchingActivity");
            Binder.restoreCallingIdentity(origId);
            r.finishing = wasFinishing;
            return res == 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int startActivityFromRecents(int taskId, Bundle bOptions) {
        if (this.checkCallingPermission("android.permission.START_TASKS_FROM_RECENTS") != 0) {
            String msg = "Permission Denial: startActivityFromRecents called without android.permission.START_TASKS_FROM_RECENTS";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                int n = this.mStackSupervisor.startActivityFromRecentsInner(taskId, bOptions);
                return n;
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    final int startActivityInPackage(int uid, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, Bundle bOptions, int userId, IActivityContainer container, TaskRecord inTask, String reason) {
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startActivityInPackage", null);
        int ret = this.mActivityStarter.startActivityMayWait(null, uid, callingPackage, intent, resolvedType, null, null, resultTo, resultWho, requestCode, startFlags, null, null, null, bOptions, false, userId, container, inTask, reason);
        return ret;
    }

    @Override
    public final int startActivities(IApplicationThread caller, String callingPackage, Intent[] intents, String[] resolvedTypes, IBinder resultTo, Bundle bOptions, int userId) {
        String reason = "startActivities";
        this.enforceNotIsolatedCaller("startActivities");
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startActivities", null);
        int ret = this.mActivityStarter.startActivities(caller, -1, callingPackage, intents, resolvedTypes, resultTo, bOptions, userId, "startActivities");
        return ret;
    }

    final int startActivitiesInPackage(int uid, String callingPackage, Intent[] intents, String[] resolvedTypes, IBinder resultTo, Bundle bOptions, int userId) {
        String reason = "startActivityInPackage";
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startActivityInPackage", null);
        int ret = this.mActivityStarter.startActivities(null, uid, callingPackage, intents, resolvedTypes, resultTo, bOptions, userId, "startActivityInPackage");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportActivityFullyDrawn(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return;
            }
            r.reportFullyDrawnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(IBinder token, int requestedOrientation) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            try {
                r.setRequestedOrientation(requestedOrientation);
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return -1;
            }
            return r.getRequestedOrientation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void requestActivityRelaunch(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            try {
                r.forceNewConfig = true;
                r.ensureActivityConfigurationLocked(0, true);
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean finishActivity(IBinder token, int resultCode, Intent resultData, int finishTask) {
        if (resultData != null && resultData.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean bl;
            ActivityRecord next;
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return true;
            }
            TaskRecord tr = r.getTask();
            ActivityRecord rootR = tr.getRootActivity();
            if (rootR == null) {
                Slog.w("ActivityManager", "Finishing task with all activities already finished");
            }
            if (tr.mLockTaskAuth != 4 && rootR == r && this.mStackSupervisor.isLastLockedTask(tr)) {
                Slog.i("ActivityManager", "Not finishing task in lock task mode");
                this.mStackSupervisor.showLockTaskToast();
                return false;
            }
            if (this.mController != null && (next = ((ActivityStack)r.getStack()).topRunningActivityLocked(token, 0)) != null) {
                boolean resumeOK = true;
                try {
                    resumeOK = this.mController.activityResuming(next.packageName);
                }
                catch (RemoteException e) {
                    this.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
                if (!resumeOK) {
                    Slog.i("ActivityManager", "Not finishing activity because controller resumed");
                    return false;
                }
            }
            long origId = Binder.clearCallingIdentity();
            try {
                boolean res;
                boolean finishWithRootActivity;
                boolean bl2 = finishWithRootActivity = finishTask == 1;
                if (finishTask == 2 || finishWithRootActivity && r == rootR) {
                    res = this.mStackSupervisor.removeTaskByIdLocked(tr.taskId, false, finishWithRootActivity);
                    if (!res) {
                        Slog.i("ActivityManager", "Removing task failed to finish activity");
                    }
                } else {
                    res = tr.getStack().requestFinishActivityLocked(token, resultCode, resultData, "app-request", true);
                    if (!res) {
                        Slog.i("ActivityManager", "Failed to finish by app-request");
                    }
                }
                bl = res;
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void finishHeavyWeightApp() {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: finishHeavyWeightApp() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mHeavyWeightProcess == null) {
                return;
            }
            ArrayList<ActivityRecord> activities = new ArrayList<ActivityRecord>(this.mHeavyWeightProcess.activities);
            for (int i = 0; i < activities.size(); ++i) {
                ActivityRecord r = activities.get(i);
                if (r.finishing || !r.isInStackLocked()) continue;
                ((ActivityStack)r.getStack()).finishActivityLocked(r, 0, null, "finish-heavy", true);
            }
            this.mHandler.sendMessage(this.mHandler.obtainMessage(25, this.mHeavyWeightProcess.userId, 0));
            this.mHeavyWeightProcess = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crashApplication(int uid, int initialPid, String packageName, int userId, String message) {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: crashApplication() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAppErrors.scheduleAppCrashLocked(uid, initialPid, packageName, userId, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void finishSubActivity(IBinder token, String resultWho, int requestCode) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r != null) {
                ((ActivityStack)r.getStack()).finishSubActivityLocked(r, resultWho, requestCode);
            }
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean finishActivityAffinity(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                ActivityRecord r = ActivityRecord.isInStackLocked(token);
                if (r == null) {
                    boolean bl = false;
                    return bl;
                }
                TaskRecord task = r.getTask();
                if (task.mLockTaskAuth != 4 && this.mStackSupervisor.isLastLockedTask(task) && task.getRootActivity() == r) {
                    this.mStackSupervisor.showLockTaskToast();
                    boolean bl = false;
                    return bl;
                }
                boolean bl = task.getStack().finishActivityAffinityLocked(r);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishVoiceTask(IVoiceInteractionSession session) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                this.mStackSupervisor.finishVoiceTask(session);
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean releaseActivityInstance(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                ActivityRecord r = ActivityRecord.isInStackLocked(token);
                if (r == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = ((ActivityStack)r.getStack()).safelyDestroyActivityLocked(r, "app-req");
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSomeActivities(IApplicationThread appInt) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                ProcessRecord app = this.getRecordForAppLocked(appInt);
                this.mStackSupervisor.releaseSomeActivitiesLocked(app, "low-mem");
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean willActivityBeVisible(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                return stack.willActivityBeVisibleLocked(token);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingTransition(IBinder token, String packageName, int enterAnim, int exitAnim) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord self = ActivityRecord.isInStackLocked(token);
            if (self == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            if (self.state == ActivityStack.ActivityState.RESUMED || self.state == ActivityStack.ActivityState.PAUSING) {
                this.mWindowManager.overridePendingAppTransition(packageName, enterAnim, exitAnim, null);
            }
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleAppDiedLocked(ProcessRecord app, boolean restarting, boolean allowRestart) {
        int pid = app.pid;
        boolean kept = this.cleanUpApplicationRecordLocked(app, restarting, allowRestart, -1, false);
        if (!kept && !restarting) {
            this.removeLruProcessLocked(app);
            if (pid > 0) {
                ProcessList.remove(pid);
            }
        }
        if (this.mProfileProc == app) {
            this.clearProfilerLocked();
        }
        boolean hasVisibleActivities = this.mStackSupervisor.handleAppDiedLocked(app);
        app.activities.clear();
        if (app.instr != null) {
            Slog.w("ActivityManager", "Crash of app " + app.processName + " running instrumentation " + app.instr.mClass);
            Bundle info = new Bundle();
            info.putString("shortMsg", "Process crashed.");
            this.finishInstrumentationLocked(app, 0, info);
        }
        this.mWindowManager.deferSurfaceLayout();
        try {
            if (!restarting && hasVisibleActivities && !this.mStackSupervisor.resumeFocusedStackTopActivityLocked()) {
                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
            }
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
        }
    }

    private final int getLRURecordIndexForAppLocked(IApplicationThread thread) {
        IBinder threadBinder = thread.asBinder();
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord rec = this.mLruProcesses.get(i);
            if (rec.thread == null || rec.thread.asBinder() != threadBinder) continue;
            return i;
        }
        return -1;
    }

    final ProcessRecord getRecordForAppLocked(IApplicationThread thread) {
        if (thread == null) {
            return null;
        }
        int appIndex = this.getLRURecordIndexForAppLocked(thread);
        if (appIndex >= 0) {
            return this.mLruProcesses.get(appIndex);
        }
        IBinder threadBinder = thread.asBinder();
        ArrayMap<String, SparseArray<ProcessRecord>> pmap = this.mProcessNames.getMap();
        for (int i = pmap.size() - 1; i >= 0; --i) {
            SparseArray<ProcessRecord> procs = pmap.valueAt(i);
            for (int j = procs.size() - 1; j >= 0; --j) {
                ProcessRecord proc = procs.valueAt(j);
                if (proc.thread == null || proc.thread.asBinder() != threadBinder) continue;
                Slog.wtf("ActivityManager", "getRecordForApp: exists in name list but not in LRU list: " + proc);
                return proc;
            }
        }
        return null;
    }

    final void doLowMemReportIfNeededLocked(ProcessRecord dyingProc) {
        boolean haveBg = false;
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord rec = this.mLruProcesses.get(i);
            if (rec.thread == null || rec.setProcState < 15) continue;
            haveBg = true;
            break;
        }
        if (!haveBg) {
            boolean doReport = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (doReport) {
                long now = SystemClock.uptimeMillis();
                if (now < this.mLastMemUsageReportTime + 300000L) {
                    doReport = false;
                } else {
                    this.mLastMemUsageReportTime = now;
                }
            }
            ArrayList<ProcessMemInfo> memInfos = doReport ? new ArrayList<ProcessMemInfo>(this.mLruProcesses.size()) : null;
            EventLog.writeEvent(30017, this.mLruProcesses.size());
            long now = SystemClock.uptimeMillis();
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord rec = this.mLruProcesses.get(i);
                if (rec == dyingProc || rec.thread == null) continue;
                if (doReport) {
                    memInfos.add(new ProcessMemInfo(rec.processName, rec.pid, rec.setAdj, rec.setProcState, rec.adjType, rec.makeAdjReason()));
                }
                if (rec.lastLowMemory + this.mConstants.GC_MIN_INTERVAL > now) continue;
                rec.lastRequestedGc = rec.setAdj <= 400 ? 0L : rec.lastLowMemory;
                rec.reportLowMemory = true;
                rec.lastLowMemory = now;
                this.mProcessesToGc.remove(rec);
                this.addProcessToGcListLocked(rec);
            }
            if (doReport) {
                Message msg = this.mHandler.obtainMessage(33, memInfos);
                this.mHandler.sendMessage(msg);
            }
            this.scheduleAppGcsLocked();
        }
    }

    final void appDiedLocked(ProcessRecord app) {
        this.appDiedLocked(app, app.pid, app.thread, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void appDiedLocked(ProcessRecord app, int pid, IApplicationThread thread, boolean fromBinderDied) {
        Object curProc;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            curProc = this.mPidsSelfLocked.get(pid);
            if (curProc != app) {
                Slog.w("ActivityManager", "Spurious death for " + app + ", curProc for " + pid + ": " + curProc);
                return;
            }
        }
        BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
        curProc = stats;
        synchronized (curProc) {
            stats.noteProcessDiedLocked(app.info.uid, pid);
        }
        if (!app.killed) {
            if (!fromBinderDied) {
                android.os.Process.killProcessQuiet(pid);
            }
            ActivityManagerService.killProcessGroup(app.uid, pid);
            app.killed = true;
        }
        if (app.pid == pid && app.thread != null && app.thread.asBinder() == thread.asBinder()) {
            boolean doLowMem;
            boolean doOomAdj = doLowMem = app.instr == null;
            if (!app.killedByAm) {
                Slog.i("ActivityManager", "Process " + app.processName + " (pid " + pid + ") has died: " + ProcessList.makeOomAdjString(app.setAdj) + ProcessList.makeProcStateString(app.setProcState));
                this.mAllowLowerMemLevel = true;
            } else {
                this.mAllowLowerMemLevel = false;
                doLowMem = false;
            }
            EventLog.writeEvent(30011, app.userId, app.pid, app.processName, app.setAdj, app.setProcState);
            this.handleAppDiedLocked(app, false, true);
            if (doOomAdj) {
                this.updateOomAdjLocked();
            }
            if (doLowMem) {
                this.doLowMemReportIfNeededLocked(app);
            }
        } else if (app.pid != pid) {
            Slog.i("ActivityManager", "Process " + app.processName + " (pid " + pid + ") has died and restarted (pid " + app.pid + ").");
            EventLog.writeEvent(30011, app.userId, app.pid, app.processName);
        }
    }

    public static File dumpStackTraces(boolean clearTraces, ArrayList<Integer> firstPids, ProcessCpuTracker processCpuTracker, SparseArray<Boolean> lastPids, ArrayList<Integer> nativePids) {
        String tracesPath = SystemProperties.get("dalvik.vm.stack-trace-file", null);
        if (tracesPath == null || tracesPath.length() == 0) {
            return null;
        }
        File tracesFile = new File(tracesPath);
        try {
            if (clearTraces && tracesFile.exists()) {
                tracesFile.delete();
            }
            tracesFile.createNewFile();
            FileUtils.setPermissions(tracesFile.getPath(), 438, -1, -1);
        }
        catch (IOException e) {
            Slog.w("ActivityManager", "Unable to prepare ANR traces file: " + tracesPath, e);
            return null;
        }
        ActivityManagerService.dumpStackTraces(tracesPath, firstPids, processCpuTracker, lastPids, nativePids);
        return tracesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpStackTraces(String tracesPath, ArrayList<Integer> firstPids, ProcessCpuTracker processCpuTracker, SparseArray<Boolean> lastPids, ArrayList<Integer> nativePids) {
        block16: {
            DumpStackFileObserver observer = new DumpStackFileObserver(tracesPath);
            long remainingTime = 20000L;
            try {
                observer.startWatching();
                if (firstPids != null) {
                    int num = firstPids.size();
                    for (int i = 0; i < num; ++i) {
                        long timeTaken;
                        if ((remainingTime -= (timeTaken = observer.dumpWithTimeout(firstPids.get(i), remainingTime))) > 0L) continue;
                        Slog.e("ActivityManager", "Aborting stack trace dump (current firstPid=" + firstPids.get(i) + "); deadline exceeded.");
                        return;
                    }
                }
                if (nativePids != null) {
                    for (int pid : nativePids) {
                        long nativeDumpTimeoutMs = Math.min(2000L, remainingTime);
                        long start = SystemClock.elapsedRealtime();
                        Debug.dumpNativeBacktraceToFileTimeout(pid, tracesPath, (int)(nativeDumpTimeoutMs / 1000L));
                        long timeTaken = SystemClock.elapsedRealtime() - start;
                        if ((remainingTime -= timeTaken) > 0L) continue;
                        Slog.e("ActivityManager", "Aborting stack trace dump (current native pid=" + pid + "); deadline exceeded.");
                        return;
                    }
                }
                if (processCpuTracker == null) break block16;
                processCpuTracker.init();
                System.gc();
                processCpuTracker.update();
                try {
                    ProcessCpuTracker num = processCpuTracker;
                    synchronized (num) {
                        processCpuTracker.wait(500L);
                    }
                }
                catch (InterruptedException num) {
                    // empty catch block
                }
                processCpuTracker.update();
                int N = processCpuTracker.countWorkingStats();
                int numProcs = 0;
                for (int i = 0; i < N && numProcs < 5; ++i) {
                    long timeTaken;
                    ProcessCpuTracker.Stats stats = processCpuTracker.getWorkingStats(i);
                    if (lastPids.indexOfKey(stats.pid) < 0) continue;
                    ++numProcs;
                    if ((remainingTime -= (timeTaken = observer.dumpWithTimeout(stats.pid, remainingTime))) > 0L) continue;
                    Slog.e("ActivityManager", "Aborting stack trace dump (current extra pid=" + stats.pid + "); deadline exceeded.");
                    return;
                }
            }
            finally {
                observer.stopWatching();
            }
        }
    }

    final void logAppTooSlow(ProcessRecord app, long startTime, String msg) {
    }

    final void showLaunchWarningLocked(final ActivityRecord cur, final ActivityRecord next) {
        if (!this.mLaunchWarningShown) {
            this.mLaunchWarningShown = true;
            this.mUiHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        final LaunchWarningWindow d = new LaunchWarningWindow(ActivityManagerService.this.mContext, cur, next);
                        d.show();
                        ActivityManagerService.this.mUiHandler.postDelayed(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                ActivityManagerService activityManagerService = ActivityManagerService.this;
                                synchronized (activityManagerService) {
                                    d.dismiss();
                                    ActivityManagerService.this.mLaunchWarningShown = false;
                                }
                            }
                        }, 4000L);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearApplicationUserData(String packageName, final IPackageDataObserver observer, int userId) {
        this.enforceNotIsolatedCaller("clearApplicationUserData");
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        userId = this.mUserController.handleIncomingUser(pid, uid, userId, false, 2, "clearApplicationUserData", null);
        long callingId = Binder.clearCallingIdentity();
        try {
            Object taskPackageName;
            IPackageManager pm = AppGlobals.getPackageManager();
            int pkgUid = -1;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                block21: {
                    if (this.getPackageManagerInternalLocked().isPackageDataProtected(userId, packageName)) {
                        throw new SecurityException("Cannot clear data for a protected package: " + packageName);
                    }
                    try {
                        pkgUid = pm.getPackageUid(packageName, 8192, userId);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (pkgUid != -1) break block21;
                    Slog.w("ActivityManager", "Invalid packageName: " + packageName);
                    if (observer != null) {
                        try {
                            observer.onRemoveCompleted(packageName, false);
                        }
                        catch (RemoteException e) {
                            Slog.i("ActivityManager", "Observer no longer exists.");
                        }
                    }
                    boolean e = false;
                    return e;
                }
                if (uid != pkgUid && this.checkComponentPermission("android.permission.CLEAR_APP_USER_DATA", pid, uid, -1, true) != 0) {
                    throw new SecurityException("PID " + pid + " does not have permission " + "android.permission.CLEAR_APP_USER_DATA" + " to clear data" + " of package " + packageName);
                }
                this.forceStopPackageLocked(packageName, pkgUid, "clear data");
                for (int i = this.mRecentTasks.size() - 1; i >= 0; --i) {
                    TaskRecord tr = (TaskRecord)this.mRecentTasks.get(i);
                    taskPackageName = tr.getBaseIntent().getComponent().getPackageName();
                    if (tr.userId != userId || !((String)taskPackageName).equals(packageName)) continue;
                    this.mStackSupervisor.removeTaskByIdLocked(tr.taskId, false, true);
                }
            }
            final int pkgUidF = pkgUid;
            final int userIdF = userId;
            IPackageDataObserver.Stub localObserver = new IPackageDataObserver.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onRemoveCompleted(String packageName, boolean succeeded) throws RemoteException {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        ActivityManagerService.this.finishForceStopPackageLocked(packageName, pkgUidF);
                    }
                    Intent intent = new Intent("android.intent.action.PACKAGE_DATA_CLEARED", Uri.fromParts("package", packageName, null));
                    intent.addFlags(0x1000000);
                    intent.putExtra("android.intent.extra.UID", pkgUidF);
                    intent.putExtra("android.intent.extra.user_handle", UserHandle.getUserId(pkgUidF));
                    ActivityManagerService.this.broadcastIntentInPackage("android", 1000, intent, null, null, 0, null, null, null, null, false, false, userIdF);
                    if (observer != null) {
                        observer.onRemoveCompleted(packageName, succeeded);
                    }
                }
            };
            try {
                pm.clearApplicationUserData(packageName, localObserver, userId);
                taskPackageName = this;
                synchronized (taskPackageName) {
                    this.removeUriPermissionsForPackageLocked(packageName, userId, true);
                }
                INotificationManager inm = NotificationManager.getService();
                inm.clearData(packageName, pkgUidF, uid == pkgUidF);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killBackgroundProcesses(String packageName, int userId) {
        if (this.checkCallingPermission("android.permission.KILL_BACKGROUND_PROCESSES") != 0 && this.checkCallingPermission("android.permission.RESTART_PACKAGES") != 0) {
            String msg = "Permission Denial: killBackgroundProcesses() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.KILL_BACKGROUND_PROCESSES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, 2, "killBackgroundProcesses", null);
        long callingId = Binder.clearCallingIdentity();
        try {
            IPackageManager pm = AppGlobals.getPackageManager();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                int appId;
                block11: {
                    appId = -1;
                    try {
                        appId = UserHandle.getAppId(pm.getPackageUid(packageName, 0x10000000, userId));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (appId != -1) break block11;
                    Slog.w("ActivityManager", "Invalid packageName: " + packageName);
                    return;
                }
                this.killPackageProcessesLocked(packageName, appId, userId, 500, false, true, true, false, "kill background");
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killAllBackgroundProcesses() {
        if (this.checkCallingPermission("android.permission.KILL_BACKGROUND_PROCESSES") != 0) {
            String msg = "Permission Denial: killAllBackgroundProcesses() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.KILL_BACKGROUND_PROCESSES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
                int NP = this.mProcessNames.getMap().size();
                for (int ip = 0; ip < NP; ++ip) {
                    SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
                    int NA = apps.size();
                    for (int ia = 0; ia < NA; ++ia) {
                        ProcessRecord app = apps.valueAt(ia);
                        if (app.persistent) continue;
                        if (app.removed) {
                            procs.add(app);
                            continue;
                        }
                        if (app.setAdj < 900) continue;
                        app.removed = true;
                        procs.add(app);
                    }
                }
                int N = procs.size();
                for (int i = 0; i < N; ++i) {
                    this.removeProcessLocked((ProcessRecord)procs.get(i), false, true, "kill all background");
                }
                this.mAllowLowerMemLevel = true;
                this.updateOomAdjLocked();
                this.doLowMemReportIfNeededLocked(null);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killAllBackgroundProcessesExcept(int minTargetSdk, int maxProcState) {
        if (this.checkCallingPermission("android.permission.KILL_BACKGROUND_PROCESSES") != 0) {
            String msg = "Permission Denial: killAllBackgroundProcessesExcept() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.KILL_BACKGROUND_PROCESSES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
                int NP = this.mProcessNames.getMap().size();
                for (int ip = 0; ip < NP; ++ip) {
                    SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
                    int NA = apps.size();
                    for (int ia = 0; ia < NA; ++ia) {
                        ProcessRecord app = apps.valueAt(ia);
                        if (app.removed) {
                            procs.add(app);
                            continue;
                        }
                        if (minTargetSdk >= 0 && app.info.targetSdkVersion >= minTargetSdk || maxProcState >= 0 && app.setProcState <= maxProcState) continue;
                        app.removed = true;
                        procs.add(app);
                    }
                }
                int N = procs.size();
                for (int i = 0; i < N; ++i) {
                    this.removeProcessLocked((ProcessRecord)procs.get(i), false, true, "kill all background except");
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceStopPackage(String packageName, int userId) {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: forceStopPackage() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        int callingPid = Binder.getCallingPid();
        userId = this.mUserController.handleIncomingUser(callingPid, Binder.getCallingUid(), userId, true, 2, "forceStopPackage", null);
        long callingId = Binder.clearCallingIdentity();
        try {
            IPackageManager pm = AppGlobals.getPackageManager();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                int[] users;
                int[] nArray;
                if (userId == -1) {
                    nArray = this.mUserController.getUsers();
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = userId;
                }
                for (int user : users = nArray) {
                    int pkgUid = -1;
                    try {
                        pkgUid = pm.getPackageUid(packageName, 0x10000000, user);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (pkgUid == -1) {
                        Slog.w("ActivityManager", "Invalid packageName: " + packageName);
                        continue;
                    }
                    try {
                        pm.setPackageStoppedState(packageName, true, user);
                    }
                    catch (RemoteException remoteException) {
                    }
                    catch (IllegalArgumentException e) {
                        Slog.w("ActivityManager", "Failed trying to unstop package " + packageName + ": " + e);
                    }
                    if (!this.mUserController.isUserRunningLocked(user, 0)) continue;
                    this.forceStopPackageLocked(packageName, pkgUid, "from pid " + callingPid);
                    this.finishForceStopPackageLocked(packageName, pkgUid);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPackageDependency(String packageName) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord proc;
            int callingPid = Binder.getCallingPid();
            if (callingPid == android.os.Process.myPid()) {
                return;
            }
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                proc = this.mPidsSelfLocked.get(Binder.getCallingPid());
            }
            if (proc != null) {
                if (proc.pkgDeps == null) {
                    proc.pkgDeps = new ArraySet(1);
                }
                proc.pkgDeps.add(packageName);
            }
        }
    }

    @Override
    public void killApplication(String pkg, int appId, int userId, String reason) {
        if (pkg == null) {
            return;
        }
        if (appId < 0) {
            Slog.w("ActivityManager", "Invalid appid specified for pkg : " + pkg);
            return;
        }
        int callerUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callerUid) != 1000) {
            throw new SecurityException(callerUid + " cannot kill pkg: " + pkg);
        }
        Message msg = this.mHandler.obtainMessage(22);
        msg.arg1 = appId;
        msg.arg2 = userId;
        Bundle bundle = new Bundle();
        bundle.putString("pkg", pkg);
        bundle.putString("reason", reason);
        msg.obj = bundle;
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSystemDialogs(String reason) {
        this.enforceNotIsolatedCaller("closeSystemDialogs");
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                block11: {
                    ProcessRecord proc;
                    if (uid < 10000) break block11;
                    SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                    synchronized (sparseArray) {
                        proc = this.mPidsSelfLocked.get(pid);
                    }
                    if (proc.curRawAdj <= 200) break block11;
                    Slog.w("ActivityManager", "Ignoring closeSystemDialogs " + reason + " from background process " + proc);
                    return;
                }
                this.closeSystemDialogsLocked(reason);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    void closeSystemDialogsLocked(String reason) {
        Intent intent = new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        intent.addFlags(0x50000000);
        if (reason != null) {
            intent.putExtra("reason", reason);
        }
        this.mWindowManager.closeSystemDialogs(reason);
        this.mStackSupervisor.closeSystemDialogsLocked();
        this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, -1, 1000, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Debug.MemoryInfo[] getProcessMemoryInfo(int[] pids) {
        this.enforceNotIsolatedCaller("getProcessMemoryInfo");
        Debug.MemoryInfo[] infos = new Debug.MemoryInfo[pids.length];
        for (int i = pids.length - 1; i >= 0; --i) {
            int oomAdj;
            ProcessRecord proc;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    proc = this.mPidsSelfLocked.get(pids[i]);
                    oomAdj = proc != null ? proc.setAdj : 0;
                }
            }
            infos[i] = new Debug.MemoryInfo();
            Debug.getMemoryInfo(pids[i], infos[i]);
            if (proc == null) continue;
            activityManagerService = this;
            synchronized (activityManagerService) {
                if (proc.thread != null && proc.setAdj == oomAdj) {
                    proc.baseProcessTracker.addPss(infos[i].getTotalPss(), infos[i].getTotalUss(), false, proc.pkgList);
                }
                continue;
            }
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getProcessPss(int[] pids) {
        this.enforceNotIsolatedCaller("getProcessPss");
        long[] pss = new long[pids.length];
        for (int i = pids.length - 1; i >= 0; --i) {
            int oomAdj;
            ProcessRecord proc;
            Object object;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                object = this.mPidsSelfLocked;
                synchronized (object) {
                    proc = this.mPidsSelfLocked.get(pids[i]);
                    oomAdj = proc != null ? proc.setAdj : 0;
                }
            }
            long[] tmpUss = new long[1];
            pss[i] = Debug.getPss(pids[i], tmpUss, null);
            if (proc == null) continue;
            object = this;
            synchronized (object) {
                if (proc.thread != null && proc.setAdj == oomAdj) {
                    proc.baseProcessTracker.addPss(pss[i], tmpUss[0], false, proc.pkgList);
                }
                continue;
            }
        }
        return pss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killApplicationProcess(String processName, int uid) {
        if (processName == null) {
            return;
        }
        int callerUid = Binder.getCallingUid();
        if (callerUid == 1000) {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ProcessRecord app = this.getProcessRecordLocked(processName, uid, true);
                if (app != null && app.thread != null) {
                    try {
                        app.thread.scheduleSuicide();
                    }
                    catch (RemoteException remoteException) {}
                } else {
                    Slog.w("ActivityManager", "Process/uid not found attempting kill of " + processName + " / " + uid);
                }
            }
        } else {
            throw new SecurityException(callerUid + " cannot kill app process: " + processName);
        }
    }

    private void forceStopPackageLocked(String packageName, int uid, String reason) {
        this.forceStopPackageLocked(packageName, UserHandle.getAppId(uid), false, false, true, false, false, UserHandle.getUserId(uid), reason);
    }

    private void finishForceStopPackageLocked(String packageName, int uid) {
        Intent intent = new Intent("android.intent.action.PACKAGE_RESTARTED", Uri.fromParts("package", packageName, null));
        if (!this.mProcessesReady) {
            intent.addFlags(0x50000000);
        }
        intent.putExtra("android.intent.extra.UID", uid);
        intent.putExtra("android.intent.extra.user_handle", UserHandle.getUserId(uid));
        this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, UserHandle.getUserId(uid));
    }

    private final boolean killPackageProcessesLocked(String packageName, int appId, int userId, int minOomAdj, boolean callerWillRestart, boolean allowRestart, boolean doit, boolean evenPersistent, String reason) {
        ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
        int NP = this.mProcessNames.getMap().size();
        for (int ip = 0; ip < NP; ++ip) {
            SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
            int NA = apps.size();
            for (int ia = 0; ia < NA; ++ia) {
                ProcessRecord app = apps.valueAt(ia);
                if (app.persistent && !evenPersistent) continue;
                if (app.removed) {
                    if (!doit) continue;
                    procs.add(app);
                    continue;
                }
                if (app.setAdj < minOomAdj) continue;
                if (packageName == null) {
                    if (userId != -1 && app.userId != userId || appId >= 0 && UserHandle.getAppId(app.uid) != appId) {
                        continue;
                    }
                } else {
                    boolean isDep;
                    boolean bl = isDep = app.pkgDeps != null && app.pkgDeps.contains(packageName);
                    if (!isDep && UserHandle.getAppId(app.uid) != appId || userId != -1 && app.userId != userId || !app.pkgList.containsKey(packageName) && !isDep) continue;
                }
                if (!doit) {
                    return true;
                }
                app.removed = true;
                procs.add(app);
            }
        }
        int N = procs.size();
        for (int i = 0; i < N; ++i) {
            this.removeProcessLocked((ProcessRecord)procs.get(i), callerWillRestart, allowRestart, reason);
        }
        this.updateOomAdjLocked();
        return N > 0;
    }

    private void cleanupDisabledPackageComponentsLocked(String packageName, int userId, boolean killProcess, String[] changedClasses) {
        int i;
        ArraySet<String> disabledClasses = null;
        boolean packageDisabled = false;
        IPackageManager pm = AppGlobals.getPackageManager();
        if (changedClasses == null) {
            return;
        }
        int enabled = 0;
        for (int i2 = changedClasses.length - 1; i2 >= 0; --i2) {
            String changedClass = changedClasses[i2];
            if (changedClass.equals(packageName)) {
                try {
                    enabled = pm.getApplicationEnabledSetting(packageName, userId != -1 ? userId : 0);
                }
                catch (Exception e) {
                    return;
                }
                boolean bl = packageDisabled = enabled != 1 && enabled != 0;
                if (!packageDisabled) continue;
                disabledClasses = null;
                break;
            }
            try {
                enabled = pm.getComponentEnabledSetting(new ComponentName(packageName, changedClass), userId != -1 ? userId : 0);
            }
            catch (Exception e) {
                return;
            }
            if (enabled == 1 || enabled == 0) continue;
            if (disabledClasses == null) {
                disabledClasses = new ArraySet<String>(changedClasses.length);
            }
            disabledClasses.add(changedClass);
        }
        if (!packageDisabled && disabledClasses == null) {
            return;
        }
        if (this.mStackSupervisor.finishDisabledPackageActivitiesLocked(packageName, disabledClasses, true, false, userId) && this.mBooted) {
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            this.mStackSupervisor.scheduleIdleLocked();
        }
        this.cleanupDisabledPackageTasksLocked(packageName, disabledClasses, userId);
        this.mServices.bringDownDisabledPackageServicesLocked(packageName, disabledClasses, userId, false, killProcess, true);
        ArrayList<ContentProviderRecord> providers = new ArrayList<ContentProviderRecord>();
        this.mProviderMap.collectPackageProvidersLocked(packageName, disabledClasses, true, false, userId, providers);
        for (i = providers.size() - 1; i >= 0; --i) {
            this.removeDyingProviderLocked(null, providers.get(i), true);
        }
        for (i = this.mBroadcastQueues.length - 1; i >= 0; --i) {
            this.mBroadcastQueues[i].cleanupDisabledPackageReceiversLocked(packageName, disabledClasses, userId, true);
        }
    }

    final boolean clearBroadcastQueueForUserLocked(int userId) {
        boolean didSomething = false;
        for (int i = this.mBroadcastQueues.length - 1; i >= 0; --i) {
            didSomething |= this.mBroadcastQueues[i].cleanupDisabledPackageReceiversLocked(null, null, userId, true);
        }
        return didSomething;
    }

    final boolean forceStopPackageLocked(String packageName, int appId, boolean callerWillRestart, boolean purgeCache, boolean doit, boolean evenPersistent, boolean uninstalling, int userId, String reason) {
        int i;
        ArrayList<ContentProviderRecord> providers;
        if (userId == -1 && packageName == null) {
            Slog.w("ActivityManager", "Can't force stop all processes of all users, that is insane!");
        }
        if (appId < 0 && packageName != null) {
            try {
                appId = UserHandle.getAppId(AppGlobals.getPackageManager().getPackageUid(packageName, 0x10000000, 0));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (doit) {
            if (packageName != null) {
                Slog.i("ActivityManager", "Force stopping " + packageName + " appid=" + appId + " user=" + userId + ": " + reason);
            } else {
                Slog.i("ActivityManager", "Force stopping u" + userId + ": " + reason);
            }
            this.mAppErrors.resetProcessCrashTimeLocked(packageName == null, appId, userId);
        }
        boolean didSomething = this.killPackageProcessesLocked(packageName, appId, userId, -10000, callerWillRestart, true, doit, evenPersistent, packageName == null ? "stop user " + userId : "stop " + packageName);
        didSomething |= this.mActivityStarter.clearPendingActivityLaunchesLocked(packageName);
        if (this.mStackSupervisor.finishDisabledPackageActivitiesLocked(packageName, null, doit, evenPersistent, userId)) {
            if (!doit) {
                return true;
            }
            didSomething = true;
        }
        if (this.mServices.bringDownDisabledPackageServicesLocked(packageName, null, userId, evenPersistent, true, doit)) {
            if (!doit) {
                return true;
            }
            didSomething = true;
        }
        if (packageName == null) {
            this.mStickyBroadcasts.remove(userId);
        }
        if (this.mProviderMap.collectPackageProvidersLocked(packageName, null, doit, evenPersistent, userId, providers = new ArrayList<ContentProviderRecord>())) {
            if (!doit) {
                return true;
            }
            didSomething = true;
        }
        for (i = providers.size() - 1; i >= 0; --i) {
            this.removeDyingProviderLocked(null, providers.get(i), true);
        }
        this.removeUriPermissionsForPackageLocked(packageName, userId, false);
        if (doit) {
            for (i = this.mBroadcastQueues.length - 1; i >= 0; --i) {
                didSomething |= this.mBroadcastQueues[i].cleanupDisabledPackageReceiversLocked(packageName, null, userId, doit);
            }
        }
        if ((packageName == null || uninstalling) && this.mIntentSenderRecords.size() > 0) {
            Iterator<WeakReference<PendingIntentRecord>> it = this.mIntentSenderRecords.values().iterator();
            while (it.hasNext()) {
                WeakReference<PendingIntentRecord> wpir = it.next();
                if (wpir == null) {
                    it.remove();
                    continue;
                }
                PendingIntentRecord pir = (PendingIntentRecord)wpir.get();
                if (pir == null) {
                    it.remove();
                    continue;
                }
                if (packageName != null ? UserHandle.getAppId(pir.uid) != appId || userId != -1 && pir.key.userId != userId || !pir.key.packageName.equals(packageName) : pir.key.userId != userId) continue;
                if (!doit) {
                    return true;
                }
                didSomething = true;
                it.remove();
                this.makeIntentSenderCanceledLocked(pir);
                if (pir.key.activity == null || pir.key.activity.pendingResults == null) continue;
                pir.key.activity.pendingResults.remove(pir.ref);
            }
        }
        if (doit) {
            AttributeCache ac;
            if (purgeCache && packageName != null && (ac = AttributeCache.instance()) != null) {
                ac.removePackage(packageName);
            }
            if (this.mBooted) {
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                this.mStackSupervisor.scheduleIdleLocked();
            }
        }
        return didSomething;
    }

    private final ProcessRecord removeProcessNameLocked(String name, int uid) {
        return this.removeProcessNameLocked(name, uid, null);
    }

    private final ProcessRecord removeProcessNameLocked(String name, int uid, ProcessRecord expecting) {
        ProcessRecord old = this.mProcessNames.get(name, uid);
        if (expecting == null || old == expecting) {
            this.mProcessNames.remove(name, uid);
        }
        if (old != null && old.uidRecord != null) {
            --old.uidRecord.numProcs;
            if (old.uidRecord.numProcs == 0) {
                this.enqueueUidChangeLocked(old.uidRecord, -1, 1);
                EventLogTags.writeAmUidStopped(uid);
                this.mActiveUids.remove(uid);
                this.noteUidProcessState(uid, 18);
            }
            old.uidRecord = null;
        }
        this.mIsolatedProcesses.remove(uid);
        return old;
    }

    private final void addProcessNameLocked(ProcessRecord proc) {
        ProcessRecord old = this.removeProcessNameLocked(proc.processName, proc.uid);
        if (old == proc && proc.persistent) {
            Slog.w("ActivityManager", "Re-adding persistent process " + proc);
        } else if (old != null) {
            Slog.wtf("ActivityManager", "Already have existing proc " + old + " when adding " + proc);
        }
        UidRecord uidRec = this.mActiveUids.get(proc.uid);
        if (uidRec == null) {
            uidRec = new UidRecord(proc.uid);
            if (Arrays.binarySearch(this.mDeviceIdleTempWhitelist, UserHandle.getAppId(proc.uid)) >= 0 || this.mPendingTempWhitelist.indexOfKey(proc.uid) >= 0) {
                uidRec.curWhitelist = true;
                uidRec.setWhitelist = true;
            }
            uidRec.updateHasInternetPermission();
            this.mActiveUids.put(proc.uid, uidRec);
            EventLogTags.writeAmUidRunning(uidRec.uid);
            this.noteUidProcessState(uidRec.uid, uidRec.curProcState);
            this.enqueueUidChangeLocked(uidRec, -1, 4);
        }
        proc.uidRecord = uidRec;
        proc.renderThreadTid = 0;
        ++uidRec.numProcs;
        this.mProcessNames.put(proc.processName, proc.uid, proc);
        if (proc.isolated) {
            this.mIsolatedProcesses.put(proc.uid, proc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeProcessLocked(ProcessRecord app, boolean callerWillRestart, boolean allowRestart, String reason) {
        String name = app.processName;
        int uid = app.uid;
        ProcessRecord old = this.mProcessNames.get(name, uid);
        if (old != app) {
            Slog.w("ActivityManager", "Ignoring remove of inactive process: " + app);
            return false;
        }
        this.removeProcessNameLocked(name, uid);
        if (this.mHeavyWeightProcess == app) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(25, this.mHeavyWeightProcess.userId, 0));
            this.mHeavyWeightProcess = null;
        }
        boolean needRestart = false;
        if (app.pid > 0 && app.pid != MY_PID) {
            int pid = app.pid;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.remove(pid);
                this.mHandler.removeMessages(20, app);
            }
            this.mBatteryStatsService.noteProcessFinish(app.processName, app.info.uid);
            if (app.isolated) {
                this.mBatteryStatsService.removeIsolatedUid(app.uid, app.info.uid);
                this.getPackageManagerInternalLocked().removeIsolatedUid(app.uid);
            }
            boolean willRestart = false;
            if (app.persistent && !app.isolated) {
                if (!callerWillRestart) {
                    willRestart = true;
                } else {
                    needRestart = true;
                }
            }
            app.kill(reason, true);
            this.handleAppDiedLocked(app, willRestart, allowRestart);
            if (willRestart) {
                this.removeLruProcessLocked(app);
                this.addAppLocked(app.info, null, false, null);
            }
        } else {
            this.mRemovedProcesses.add(app);
        }
        return needRestart;
    }

    private final void processContentProviderPublishTimedOutLocked(ProcessRecord app) {
        this.cleanupAppInLaunchingProvidersLocked(app, true);
        this.removeProcessLocked(app, false, true, "timeout publishing content providers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processStartTimedOutLocked(final ProcessRecord app) {
        int pid = app.pid;
        boolean gone = false;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            ProcessRecord knownApp = this.mPidsSelfLocked.get(pid);
            if (knownApp != null && knownApp.thread == null) {
                this.mPidsSelfLocked.remove(pid);
                gone = true;
            }
        }
        if (gone) {
            Slog.w("ActivityManager", "Process " + app + " failed to attach");
            EventLog.writeEvent(30037, app.userId, pid, app.uid, app.processName);
            this.removeProcessNameLocked(app.processName, app.uid);
            if (this.mHeavyWeightProcess == app) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(25, this.mHeavyWeightProcess.userId, 0));
                this.mHeavyWeightProcess = null;
            }
            this.mBatteryStatsService.noteProcessFinish(app.processName, app.info.uid);
            if (app.isolated) {
                this.mBatteryStatsService.removeIsolatedUid(app.uid, app.info.uid);
            }
            this.cleanupAppInLaunchingProvidersLocked(app, true);
            this.mServices.processStartTimedOutLocked(app);
            app.kill("start timeout", true);
            this.removeLruProcessLocked(app);
            if (this.mBackupTarget != null && this.mBackupTarget.app.pid == pid) {
                Slog.w("ActivityManager", "Unattached app died before backup, skipping");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                            bm.agentDisconnected(app.info.packageName);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                });
            }
            if (this.isPendingBroadcastProcessLocked(pid)) {
                Slog.w("ActivityManager", "Unattached app died before broadcast acknowledged, skipping");
                this.skipPendingBroadcastLocked(pid);
            }
        } else {
            Slog.w("ActivityManager", "Spurious process start timeout - pid not known for " + app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean attachApplicationLocked(IApplicationThread thread, int pid) {
        List<ProviderInfo> providers;
        ProcessRecord app;
        long startTime = SystemClock.uptimeMillis();
        if (pid != MY_PID && pid >= 0) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                app = this.mPidsSelfLocked.get(pid);
            }
        } else {
            app = null;
        }
        if (app == null) {
            Slog.w("ActivityManager", "No pending application record for pid " + pid + " (IApplicationThread " + thread + "); dropping process");
            EventLog.writeEvent(30033, pid);
            if (pid > 0 && pid != MY_PID) {
                android.os.Process.killProcessQuiet(pid);
            } else {
                try {
                    thread.scheduleExit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        if (app.thread != null) {
            this.handleAppDiedLocked(app, true, true);
        }
        String processName = app.processName;
        try {
            AppDeathRecipient adr = new AppDeathRecipient(app, pid, thread);
            thread.asBinder().linkToDeath(adr, 0);
            app.deathRecipient = adr;
        }
        catch (RemoteException e) {
            app.resetPackageList(this.mProcessStats);
            this.startProcessLocked(app, "link fail", processName);
            return false;
        }
        EventLog.writeEvent(30010, app.userId, app.pid, app.processName);
        app.makeActive(thread, this.mProcessStats);
        app.verifiedAdj = -10000;
        app.setAdj = -10000;
        app.curAdj = -10000;
        app.setSchedGroup = 1;
        app.curSchedGroup = 1;
        app.forcingToImportant = null;
        this.updateProcessForegroundLocked(app, false, false);
        app.hasShownUi = false;
        app.debugging = false;
        app.cached = false;
        app.killedByAm = false;
        app.killed = false;
        app.unlocked = StorageManager.isUserKeyUnlocked(app.userId);
        this.mHandler.removeMessages(20, app);
        boolean normalMode = this.mProcessesReady || this.isAllowedWhileBooting(app.info);
        List<ProviderInfo> list = providers = normalMode ? this.generateApplicationProvidersLocked(app) : null;
        if (providers != null && this.checkAppInLaunchingProvidersLocked(app)) {
            Message msg = this.mHandler.obtainMessage(57);
            msg.obj = app;
            this.mHandler.sendMessageDelayed(msg, 10000L);
        }
        this.checkTime(startTime, "attachApplicationLocked: before bindApplication");
        if (!normalMode) {
            Slog.i("ActivityManager", "Launching preboot mode app: " + app);
        }
        try {
            int testMode = 0;
            if (this.mDebugApp != null && this.mDebugApp.equals(processName)) {
                testMode = this.mWaitForDebugger ? 2 : 1;
                app.debugging = true;
                if (this.mDebugTransient) {
                    this.mDebugApp = this.mOrigDebugApp;
                    this.mWaitForDebugger = this.mOrigWaitForDebugger;
                }
            }
            String profileFile = app.instr != null ? app.instr.mProfileFile : null;
            ParcelFileDescriptor profileFd = null;
            int samplingInterval = 0;
            boolean profileAutoStop = false;
            boolean profileStreamingOutput = false;
            if (this.mProfileApp != null && this.mProfileApp.equals(processName)) {
                this.mProfileProc = app;
                profileFile = this.mProfileFile;
                profileFd = this.mProfileFd;
                samplingInterval = this.mSamplingInterval;
                profileAutoStop = this.mAutoStopProfiler;
                profileStreamingOutput = this.mStreamingOutput;
            }
            boolean enableTrackAllocation = false;
            if (this.mTrackAllocationApp != null && this.mTrackAllocationApp.equals(processName)) {
                enableTrackAllocation = true;
                this.mTrackAllocationApp = null;
            }
            boolean isRestrictedBackupMode = false;
            if (this.mBackupTarget != null && this.mBackupAppName.equals(processName)) {
                boolean bl = isRestrictedBackupMode = this.mBackupTarget.appInfo.uid >= 10000 && (this.mBackupTarget.backupMode == 2 || this.mBackupTarget.backupMode == 3 || this.mBackupTarget.backupMode == 1);
            }
            if (app.instr != null) {
                this.notifyPackageUse(app.instr.mClass.getPackageName(), 7);
            }
            ApplicationInfo appInfo = app.instr != null ? app.instr.mTargetInfo : app.info;
            app.compat = this.compatibilityInfoForPackageLocked(appInfo);
            if (profileFd != null) {
                profileFd = profileFd.dup();
            }
            ProfilerInfo profilerInfo = profileFile == null ? null : new ProfilerInfo(profileFile, profileFd, samplingInterval, profileAutoStop, profileStreamingOutput);
            String buildSerial = "unknown";
            if (appInfo.targetSandboxVersion != 2) {
                buildSerial = IDeviceIdentifiersPolicyService.Stub.asInterface(ServiceManager.getService("device_identifiers")).getSerial();
            }
            if (this.mActiveInstrumentation.size() > 0 && app.instr == null) {
                block17: for (int i = this.mActiveInstrumentation.size() - 1; i >= 0 && app.instr == null; --i) {
                    ActiveInstrumentation aInstr = this.mActiveInstrumentation.get(i);
                    if (aInstr.mFinished || aInstr.mTargetInfo.uid != app.uid) continue;
                    if (aInstr.mTargetProcesses.length == 0) {
                        if (!aInstr.mTargetInfo.packageName.equals(app.info.packageName)) continue;
                        app.instr = aInstr;
                        aInstr.mRunningProcesses.add(app);
                        continue;
                    }
                    for (String proc : aInstr.mTargetProcesses) {
                        if (!proc.equals(app.processName)) continue;
                        app.instr = aInstr;
                        aInstr.mRunningProcesses.add(app);
                        continue block17;
                    }
                }
            }
            this.checkTime(startTime, "attachApplicationLocked: immediately before bindApplication");
            this.mStackSupervisor.mActivityMetricsLogger.notifyBindApplication(app);
            if (app.instr != null) {
                thread.bindApplication(processName, appInfo, providers, app.instr.mClass, profilerInfo, app.instr.mArguments, app.instr.mWatcher, app.instr.mUiAutomationConnection, testMode, this.mBinderTransactionTrackingEnabled, enableTrackAllocation, isRestrictedBackupMode || !normalMode, app.persistent, new Configuration(this.getGlobalConfiguration()), app.compat, this.getCommonServicesLocked(app.isolated), this.mCoreSettingsObserver.getCoreSettingsLocked(), buildSerial);
            } else {
                thread.bindApplication(processName, appInfo, providers, null, profilerInfo, null, null, null, testMode, this.mBinderTransactionTrackingEnabled, enableTrackAllocation, isRestrictedBackupMode || !normalMode, app.persistent, new Configuration(this.getGlobalConfiguration()), app.compat, this.getCommonServicesLocked(app.isolated), this.mCoreSettingsObserver.getCoreSettingsLocked(), buildSerial);
            }
            this.checkTime(startTime, "attachApplicationLocked: immediately after bindApplication");
            this.updateLruProcessLocked(app, false, null);
            this.checkTime(startTime, "attachApplicationLocked: after updateLruProcessLocked");
            app.lastRequestedGc = app.lastLowMemory = SystemClock.uptimeMillis();
        }
        catch (Exception e) {
            Slog.wtf("ActivityManager", "Exception thrown during bind of " + app, e);
            app.resetPackageList(this.mProcessStats);
            app.unlinkDeathRecipient();
            this.startProcessLocked(app, "bind fail", processName);
            return false;
        }
        this.mPersistentStartingProcesses.remove(app);
        this.mProcessesOnHold.remove(app);
        boolean badApp = false;
        boolean didSomething = false;
        if (normalMode) {
            try {
                if (this.mStackSupervisor.attachApplicationLocked(app)) {
                    didSomething = true;
                }
            }
            catch (Exception e) {
                Slog.wtf("ActivityManager", "Exception thrown launching activities in " + app, e);
                badApp = true;
            }
        }
        if (!badApp) {
            try {
                didSomething |= this.mServices.attachApplicationLocked(app, processName);
                this.checkTime(startTime, "attachApplicationLocked: after mServices.attachApplicationLocked");
            }
            catch (Exception e) {
                Slog.wtf("ActivityManager", "Exception thrown starting services in " + app, e);
                badApp = true;
            }
        }
        if (!badApp && this.isPendingBroadcastProcessLocked(pid)) {
            try {
                didSomething |= this.sendPendingBroadcastsLocked(app);
                this.checkTime(startTime, "attachApplicationLocked: after sendPendingBroadcastsLocked");
            }
            catch (Exception e) {
                Slog.wtf("ActivityManager", "Exception thrown dispatching broadcasts in " + app, e);
                badApp = true;
            }
        }
        if (!badApp && this.mBackupTarget != null && this.mBackupTarget.app == app) {
            this.notifyPackageUse(this.mBackupTarget.appInfo.packageName, 5);
            try {
                thread.scheduleCreateBackupAgent(this.mBackupTarget.appInfo, this.compatibilityInfoForPackageLocked(this.mBackupTarget.appInfo), this.mBackupTarget.backupMode);
            }
            catch (Exception e) {
                Slog.wtf("ActivityManager", "Exception thrown creating backup agent in " + app, e);
                badApp = true;
            }
        }
        if (badApp) {
            app.kill("error during init", true);
            this.handleAppDiedLocked(app, false, true);
            return false;
        }
        if (!didSomething) {
            this.updateOomAdjLocked();
            this.checkTime(startTime, "attachApplicationLocked: after updateOomAdjLocked");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void attachApplication(IApplicationThread thread) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingPid = Binder.getCallingPid();
            long origId = Binder.clearCallingIdentity();
            this.attachApplicationLocked(thread, callingPid);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityIdle(IBinder token, Configuration config, boolean stopProfiling) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                ActivityRecord r = this.mStackSupervisor.activityIdleInternalLocked(token, false, false, config);
                if (stopProfiling && this.mProfileProc == r.app && this.mProfileFd != null) {
                    try {
                        this.mProfileFd.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.clearProfilerLocked();
                }
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    void postFinishBooting(boolean finishBooting, boolean enableScreen) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(45, finishBooting ? 1 : 0, enableScreen ? 1 : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableScreenAfterBoot() {
        EventLog.writeEvent(3050, SystemClock.uptimeMillis());
        this.mWindowManager.enableScreenAfterBoot();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.updateEventDispatchingLocked();
        }
    }

    @Override
    public void showBootMessage(CharSequence msg, boolean always) {
        if (Binder.getCallingUid() != android.os.Process.myUid()) {
            throw new SecurityException();
        }
        this.mWindowManager.showBootMessage(msg, always);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyguardGoingAway(int flags) {
        this.enforceNotIsolatedCaller("keyguardGoingAway");
        long token = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.mKeyguardController.keyguardGoingAway(flags);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    boolean isKeyguardLocked() {
        return this.mKeyguardController.isKeyguardLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void finishBooting() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!this.mBootAnimationComplete) {
                this.mCallFinishBooting = true;
                return;
            }
            this.mCallFinishBooting = false;
        }
        ArraySet<String> completedIsas = new ArraySet<String>();
        for (String abi : Build.SUPPORTED_ABIS) {
            android.os.Process.zygoteProcess.establishZygoteConnectionForAbi(abi);
            String instructionSet = VMRuntime.getInstructionSet(abi);
            if (completedIsas.contains(instructionSet)) continue;
            try {
                this.mInstaller.markBootComplete(VMRuntime.getInstructionSet(abi));
            }
            catch (Installer.InstallerException e) {
                Slog.w("ActivityManager", "Unable to mark boot complete for abi: " + abi + " (" + e.getMessage() + ")");
            }
            completedIsas.add(instructionSet);
        }
        IntentFilter pkgFilter = new IntentFilter();
        pkgFilter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        pkgFilter.addDataScheme("package");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                String[] pkgs = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                if (pkgs != null) {
                    for (String pkg : pkgs) {
                        ActivityManagerService activityManagerService = ActivityManagerService.this;
                        synchronized (activityManagerService) {
                            if (ActivityManagerService.this.forceStopPackageLocked(pkg, -1, false, false, false, false, false, 0, "query restart")) {
                                this.setResultCode(-1);
                                return;
                            }
                        }
                    }
                }
            }
        }, pkgFilter);
        IntentFilter dumpheapFilter = new IntentFilter();
        dumpheapFilter.addAction("com.android.server.am.DELETE_DUMPHEAP");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getBooleanExtra("delay_delete", false)) {
                    ActivityManagerService.this.mHandler.sendEmptyMessageDelayed(50, 300000L);
                } else {
                    ActivityManagerService.this.mHandler.sendEmptyMessage(50);
                }
            }
        }, dumpheapFilter);
        this.mSystemServiceManager.startBootPhase(1000);
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            int NP = this.mProcessesOnHold.size();
            if (NP > 0) {
                ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>(this.mProcessesOnHold);
                for (int ip = 0; ip < NP; ++ip) {
                    this.startProcessLocked(procs.get(ip), "on-hold", null);
                }
            }
            if (this.mFactoryTest != 1) {
                Message nmsg = this.mHandler.obtainMessage(27);
                this.mHandler.sendMessageDelayed(nmsg, this.mConstants.POWER_CHECK_DELAY);
                SystemProperties.set("sys.boot_completed", "1");
                if (!"trigger_restart_min_framework".equals(SystemProperties.get("vold.decrypt")) || "".equals(SystemProperties.get("vold.encrypt_progress"))) {
                    SystemProperties.set("dev.bootcomplete", "1");
                }
                this.mUserController.sendBootCompletedLocked(new IIntentReceiver.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                        ActivityManagerService activityManagerService = ActivityManagerService.this;
                        synchronized (activityManagerService) {
                            ActivityManagerService.this.requestPssAllProcsLocked(SystemClock.uptimeMillis(), true, false);
                        }
                    }
                });
                this.scheduleStartProfilesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bootAnimationComplete() {
        boolean callFinishBooting;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            callFinishBooting = this.mCallFinishBooting;
            this.mBootAnimationComplete = true;
        }
        if (callFinishBooting) {
            Trace.traceBegin(64L, "FinishBooting");
            this.finishBooting();
            Trace.traceEnd(64L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureBootCompleted() {
        boolean enableScreen;
        boolean booting;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            booting = this.mBooting;
            this.mBooting = false;
            enableScreen = !this.mBooted;
            this.mBooted = true;
        }
        if (booting) {
            Trace.traceBegin(64L, "FinishBooting");
            this.finishBooting();
            Trace.traceEnd(64L);
        }
        if (enableScreen) {
            this.enableScreenAfterBoot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityResumed(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord.activityResumedLocked(token);
            this.mWindowManager.notifyAppResumedFinished(token);
        }
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityPaused(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                stack.activityPausedLocked(token, false);
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityStopped(IBinder token, Bundle icicle, PersistableBundle persistentState, CharSequence description) {
        if (icicle != null && icicle.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r != null) {
                r.activityStoppedLocked(icicle, persistentState, description);
            }
        }
        this.trimApplications();
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityDestroyed(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                stack.activityDestroyedLocked(token, "activityDestroyed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityRelaunched(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mStackSupervisor.activityRelaunchedLocked(token);
        }
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportSizeConfigurations(IBinder token, int[] horizontalSizeConfiguration, int[] verticalSizeConfigurations, int[] smallestSizeConfigurations) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord record = ActivityRecord.isInStackLocked(token);
            if (record == null) {
                throw new IllegalArgumentException("reportSizeConfigurations: ActivityRecord not found for: " + token);
            }
            record.setSizeConfigurations(horizontalSizeConfiguration, verticalSizeConfigurations, smallestSizeConfigurations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void backgroundResourcesReleased(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ActivityStack stack = ActivityRecord.getStackLocked(token);
                if (stack != null) {
                    stack.backgroundResourcesReleased();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    @Override
    public final void notifyLaunchTaskBehindComplete(IBinder token) {
        this.mStackSupervisor.scheduleLaunchTaskBehindComplete(token);
    }

    @Override
    public final void notifyEnterAnimationComplete(IBinder token) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(44, token));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCallingPackage(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.getCallingRecordLocked(token);
            return r != null ? r.info.packageName : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getCallingActivity(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.getCallingRecordLocked(token);
            return r != null ? r.intent.getComponent() : null;
        }
    }

    private ActivityRecord getCallingRecordLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.isInStackLocked(token);
        if (r == null) {
            return null;
        }
        return r.resultTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getActivityClassForToken(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return null;
            }
            return r.intent.getComponent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPackageForToken(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return null;
            }
            return r.packageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRootVoiceInteraction(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return false;
            }
            return r.rootVoiceInteraction;
        }
    }

    @Override
    public IIntentSender getIntentSender(int type, String packageName, IBinder token, String resultWho, int requestCode, Intent[] intents, String[] resolvedTypes, int flags, Bundle bOptions, int userId) {
        this.enforceNotIsolatedCaller("getIntentSender");
        if (intents != null) {
            if (intents.length < 1) {
                throw new IllegalArgumentException("Intents array length must be >= 1");
            }
            for (int i = 0; i < intents.length; ++i) {
                Intent intent = intents[i];
                if (intent == null) continue;
                if (intent.hasFileDescriptors()) {
                    throw new IllegalArgumentException("File descriptors passed in Intent");
                }
                if (type == 1 && (intent.getFlags() & 0x2000000) != 0) {
                    throw new IllegalArgumentException("Can't use FLAG_RECEIVER_BOOT_UPGRADE here");
                }
                intents[i] = new Intent(intent);
            }
            if (resolvedTypes != null && resolvedTypes.length != intents.length) {
                throw new IllegalArgumentException("Intent array length does not match resolvedTypes length");
            }
        }
        if (bOptions != null && bOptions.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in options");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingUid = Binder.getCallingUid();
            int origUserId = userId;
            userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), callingUid, userId, type == 1, 0, "getIntentSender", null);
            if (origUserId == -2) {
                userId = -2;
            }
            try {
                int uid;
                if (callingUid != 0 && callingUid != 1000 && !UserHandle.isSameApp(callingUid, uid = AppGlobals.getPackageManager().getPackageUid(packageName, 0x10000000, UserHandle.getUserId(callingUid)))) {
                    String msg = "Permission Denial: getIntentSender() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + ", (need uid=" + uid + ")" + " is not allowed to send as package " + packageName;
                    Slog.w("ActivityManager", msg);
                    throw new SecurityException(msg);
                }
                return this.getIntentSenderLocked(type, packageName, callingUid, userId, token, resultWho, requestCode, intents, resolvedTypes, flags, bOptions);
            }
            catch (RemoteException e) {
                throw new SecurityException(e);
            }
        }
    }

    IIntentSender getIntentSenderLocked(int type, String packageName, int callingUid, int userId, IBinder token, String resultWho, int requestCode, Intent[] intents, String[] resolvedTypes, int flags, Bundle bOptions) {
        PendingIntentRecord rec;
        ActivityRecord activity = null;
        if (type == 3) {
            activity = ActivityRecord.isInStackLocked(token);
            if (activity == null) {
                Slog.w("ActivityManager", "Failed createPendingResult: activity " + token + " not in any stack");
                return null;
            }
            if (activity.finishing) {
                Slog.w("ActivityManager", "Failed createPendingResult: activity " + activity + " is finishing");
                return null;
            }
        }
        if (intents != null) {
            for (int i = 0; i < intents.length; ++i) {
                intents[i].setDefusable(true);
            }
        }
        Bundle.setDefusable(bOptions, true);
        boolean noCreate = (flags & 0x20000000) != 0;
        boolean cancelCurrent = (flags & 0x10000000) != 0;
        boolean updateCurrent = (flags & 0x8000000) != 0;
        PendingIntentRecord.Key key = new PendingIntentRecord.Key(type, packageName, activity, resultWho, requestCode, intents, resolvedTypes, flags &= 0xC7FFFFFF, bOptions, userId);
        WeakReference<PendingIntentRecord> ref = this.mIntentSenderRecords.get(key);
        PendingIntentRecord pendingIntentRecord = rec = ref != null ? (PendingIntentRecord)ref.get() : null;
        if (rec != null) {
            if (!cancelCurrent) {
                if (updateCurrent) {
                    if (rec.key.requestIntent != null) {
                        rec.key.requestIntent.replaceExtras(intents != null ? intents[intents.length - 1] : null);
                    }
                    if (intents != null) {
                        intents[intents.length - 1] = rec.key.requestIntent;
                        rec.key.allIntents = intents;
                        rec.key.allResolvedTypes = resolvedTypes;
                    } else {
                        rec.key.allIntents = null;
                        rec.key.allResolvedTypes = null;
                    }
                }
                return rec;
            }
            this.makeIntentSenderCanceledLocked(rec);
            this.mIntentSenderRecords.remove(key);
        }
        if (noCreate) {
            return rec;
        }
        rec = new PendingIntentRecord(this, key, callingUid);
        this.mIntentSenderRecords.put(key, rec.ref);
        if (type == 3) {
            if (activity.pendingResults == null) {
                activity.pendingResults = new HashSet();
            }
            activity.pendingResults.add(rec.ref);
        }
        return rec;
    }

    @Override
    public int sendIntentSender(IIntentSender target, IBinder whitelistToken, int code, Intent intent, String resolvedType, IIntentReceiver finishedReceiver, String requiredPermission, Bundle options) {
        if (target instanceof PendingIntentRecord) {
            return ((PendingIntentRecord)target).sendWithResult(code, intent, resolvedType, whitelistToken, finishedReceiver, requiredPermission, options);
        }
        if (intent == null) {
            Slog.wtf("ActivityManager", "Can't use null intent with direct IIntentSender call");
            intent = new Intent("android.intent.action.MAIN");
        }
        try {
            target.send(code, intent, resolvedType, whitelistToken, null, requiredPermission, options);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (finishedReceiver != null) {
            try {
                finishedReceiver.performReceive(intent, 0, null, null, false, false, UserHandle.getCallingUserId());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelIntentSender(IIntentSender sender) {
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            PendingIntentRecord rec = (PendingIntentRecord)sender;
            try {
                int uid = AppGlobals.getPackageManager().getPackageUid(rec.key.packageName, 0x10000000, UserHandle.getCallingUserId());
                if (!UserHandle.isSameApp(uid, Binder.getCallingUid())) {
                    String msg = "Permission Denial: cancelIntentSender() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " is not allowed to cancel package " + rec.key.packageName;
                    Slog.w("ActivityManager", msg);
                    throw new SecurityException(msg);
                }
            }
            catch (RemoteException e) {
                throw new SecurityException(e);
            }
            this.cancelIntentSenderLocked(rec, true);
        }
    }

    void cancelIntentSenderLocked(PendingIntentRecord rec, boolean cleanActivity) {
        this.makeIntentSenderCanceledLocked(rec);
        this.mIntentSenderRecords.remove(rec.key);
        if (cleanActivity && rec.key.activity != null) {
            rec.key.activity.pendingResults.remove(rec.ref);
        }
    }

    void makeIntentSenderCanceledLocked(PendingIntentRecord rec) {
        rec.canceled = true;
        RemoteCallbackList<IResultReceiver> callbacks = rec.detachCancelListenersLocked();
        if (callbacks != null) {
            this.mHandler.obtainMessage(67, callbacks).sendToTarget();
        }
    }

    @Override
    public String getPackageForIntentSender(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return null;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.packageName;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerIntentSenderCancelListener(IIntentSender sender, IResultReceiver receiver) {
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ((PendingIntentRecord)sender).registerCancelListenerLocked(receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterIntentSenderCancelListener(IIntentSender sender, IResultReceiver receiver) {
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ((PendingIntentRecord)sender).unregisterCancelListenerLocked(receiver);
        }
    }

    @Override
    public int getUidForIntentSender(IIntentSender sender) {
        if (sender instanceof PendingIntentRecord) {
            try {
                PendingIntentRecord res = (PendingIntentRecord)sender;
                return res.uid;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public boolean isIntentSenderTargetedToPackage(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return false;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            if (res.key.allIntents == null) {
                return false;
            }
            for (int i = 0; i < res.key.allIntents.length; ++i) {
                Intent intent = res.key.allIntents[i];
                if (intent.getPackage() == null || intent.getComponent() == null) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean isIntentSenderAnActivity(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return false;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.type == 2;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public Intent getIntentForIntentSender(IIntentSender pendingResult) {
        this.enforceCallingPermission("android.permission.GET_INTENT_SENDER_INTENT", "getIntentForIntentSender()");
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return null;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.requestIntent != null ? new Intent(res.key.requestIntent) : null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTagForIntentSender(IIntentSender pendingResult, String prefix) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return null;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                return this.getTagForIntentSenderLocked(res, prefix);
            }
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    String getTagForIntentSenderLocked(PendingIntentRecord res, String prefix) {
        Intent intent = res.key.requestIntent;
        if (intent != null) {
            if (res.lastTag != null && res.lastTagPrefix == prefix && (res.lastTagPrefix == null || res.lastTagPrefix.equals(prefix))) {
                return res.lastTag;
            }
            res.lastTagPrefix = prefix;
            StringBuilder sb = new StringBuilder(128);
            if (prefix != null) {
                sb.append(prefix);
            }
            if (intent.getAction() != null) {
                sb.append(intent.getAction());
            } else if (intent.getComponent() != null) {
                intent.getComponent().appendShortString(sb);
            } else {
                sb.append("?");
            }
            res.lastTag = sb.toString();
            return res.lastTag;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProcessLimit(int max) {
        this.enforceCallingPermission("android.permission.SET_PROCESS_LIMIT", "setProcessLimit()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mConstants.setOverrideMaxCachedProcesses(max);
        }
        this.trimApplications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProcessLimit() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mConstants.getOverrideMaxCachedProcesses();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importanceTokenDied(ImportanceToken token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                ImportanceToken cur = this.mImportantProcesses.get(token.pid);
                if (cur != token) {
                    return;
                }
                this.mImportantProcesses.remove(token.pid);
                ProcessRecord pr = this.mPidsSelfLocked.get(token.pid);
                if (pr == null) {
                    return;
                }
                pr.forcingToImportant = null;
                this.updateProcessForegroundLocked(pr, false, false);
            }
            this.updateOomAdjLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProcessImportant(IBinder token, int pid, boolean isForeground, String reason) {
        this.enforceCallingPermission("android.permission.SET_PROCESS_LIMIT", "setProcessImportant()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean changed = false;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                ProcessRecord pr = this.mPidsSelfLocked.get(pid);
                if (pr == null && isForeground) {
                    Slog.w("ActivityManager", "setProcessForeground called on unknown pid: " + pid);
                    return;
                }
                ImportanceToken oldToken = this.mImportantProcesses.get(pid);
                if (oldToken != null) {
                    oldToken.token.unlinkToDeath(oldToken, 0);
                    this.mImportantProcesses.remove(pid);
                    if (pr != null) {
                        pr.forcingToImportant = null;
                    }
                    changed = true;
                }
                if (isForeground && token != null) {
                    ImportanceToken newToken = new ImportanceToken(pid, token, reason){

                        @Override
                        public void binderDied() {
                            ActivityManagerService.this.importanceTokenDied(this);
                        }
                    };
                    try {
                        token.linkToDeath(newToken, 0);
                        this.mImportantProcesses.put(pid, newToken);
                        pr.forcingToImportant = newToken;
                        changed = true;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            if (changed) {
                this.updateOomAdjLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAppForeground(int uid) throws RemoteException {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UidRecord uidRec = this.mActiveUids.get(uid);
            if (uidRec == null || uidRec.idle) {
                return false;
            }
            return uidRec.curProcState <= 6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getUidState(int uid) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.getUidStateLocked(uid);
        }
    }

    int getUidStateLocked(int uid) {
        UidRecord uidRec = this.mActiveUids.get(uid);
        return uidRec == null ? 18 : uidRec.curProcState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInMultiWindowMode(IBinder token) {
        ActivityRecord r;
        long origId;
        block6: {
            boolean bl;
            origId = Binder.clearCallingIdentity();
            try {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                r = ActivityRecord.isInStackLocked(token);
                if (r != null) break block6;
                bl = false;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
        boolean bl = !r.getTask().mFullscreen;
        // MONITOREXIT : activityManagerService
        Binder.restoreCallingIdentity(origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInPictureInPictureMode(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                boolean bl = this.isInPictureInPictureMode(ActivityRecord.forTokenLocked(token));
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    private boolean isInPictureInPictureMode(ActivityRecord r) {
        if (r == null || r.getStack() == null || !((ActivityStack)r.getStack()).isPinnedStack() || ((ActivityStack)r.getStack()).isInStackLocked(r) == null) {
            return false;
        }
        PinnedActivityStack stack = (PinnedActivityStack)r.getStack();
        PinnedStackWindowController windowController = (PinnedStackWindowController)stack.getWindowContainerController();
        return !windowController.isAnimatingBoundsToFullscreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean enterPictureInPictureMode(IBinder token, PictureInPictureParams params) {
        ActivityRecord r;
        long origId;
        block12: {
            boolean bl;
            origId = Binder.clearCallingIdentity();
            try {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                r = this.ensureValidPictureInPictureActivityParamsLocked("enterPictureInPictureMode", token, params);
                if (!this.isInPictureInPictureMode(r)) break block12;
                bl = true;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
        if (!r.checkEnterPictureInPictureState("enterPictureInPictureMode", false, false)) {
            boolean bl = false;
            // MONITOREXIT : activityManagerService
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
        final Runnable enterPipRunnable = () -> {
            activityRecord.pictureInPictureArgs.copyOnlySet(params);
            float aspectRatio = activityRecord.pictureInPictureArgs.getAspectRatio();
            List<RemoteAction> actions = activityRecord.pictureInPictureArgs.getActions();
            Rect sourceBounds = new Rect(activityRecord.pictureInPictureArgs.getSourceRectHint());
            this.mStackSupervisor.moveActivityToPinnedStackLocked(r, sourceBounds, aspectRatio, true, "enterPictureInPictureMode");
            PinnedActivityStack stack = (PinnedActivityStack)this.mStackSupervisor.getStack(4);
            stack.setPictureInPictureAspectRatio(aspectRatio);
            stack.setPictureInPictureActions(actions);
            MetricsLogger.action(this.mContext, 819, activityRecord.supportsPictureInPictureWhilePausing);
            this.logPictureInPictureArgs(params);
        };
        if (this.isKeyguardLocked()) {
            try {
                this.dismissKeyguard(token, new IKeyguardDismissCallback.Stub(){

                    @Override
                    public void onDismissError() throws RemoteException {
                    }

                    @Override
                    public void onDismissSucceeded() throws RemoteException {
                        ActivityManagerService.this.mHandler.post(enterPipRunnable);
                    }

                    @Override
                    public void onDismissCancelled() throws RemoteException {
                    }
                });
            }
            catch (RemoteException remoteException) {}
        } else {
            enterPipRunnable.run();
        }
        boolean bl = true;
        // MONITOREXIT : activityManagerService
        Binder.restoreCallingIdentity(origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPictureInPictureParams(IBinder token, PictureInPictureParams params) {
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                PinnedActivityStack stack;
                ActivityRecord r = this.ensureValidPictureInPictureActivityParamsLocked("setPictureInPictureParams", token, params);
                r.pictureInPictureArgs.copyOnlySet(params);
                if (((ActivityStack)r.getStack()).getStackId() == 4 && !(stack = (PinnedActivityStack)r.getStack()).isAnimatingBoundsToFullscreen()) {
                    stack.setPictureInPictureAspectRatio(r.pictureInPictureArgs.getAspectRatio());
                    stack.setPictureInPictureActions(r.pictureInPictureArgs.getActions());
                }
                this.logPictureInPictureArgs(params);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    @Override
    public int getMaxNumPictureInPictureActions(IBinder token) {
        return 3;
    }

    private void logPictureInPictureArgs(PictureInPictureParams params) {
        if (params.hasSetActions()) {
            MetricsLogger.histogram(this.mContext, "tron_varz_picture_in_picture_actions_count", params.getActions().size());
        }
        if (params.hasSetAspectRatio()) {
            LogMaker lm = new LogMaker(824);
            lm.addTaggedData(825, Float.valueOf(params.getAspectRatio()));
            MetricsLogger.action(lm);
        }
    }

    private ActivityRecord ensureValidPictureInPictureActivityParamsLocked(String caller, IBinder token, PictureInPictureParams params) {
        if (!this.mSupportsPictureInPicture) {
            throw new IllegalStateException(caller + ": Device doesn't support picture-in-picture mode.");
        }
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r == null) {
            throw new IllegalStateException(caller + ": Can't find activity for token=" + token);
        }
        if (!r.supportsPictureInPicture()) {
            throw new IllegalStateException(caller + ": Current activity does not support picture-in-picture.");
        }
        if (!ActivityManager.StackId.isAllowedToEnterPictureInPicture(((ActivityStack)r.getStack()).getStackId())) {
            throw new IllegalStateException(caller + ": Activities on the home, assistant, or recents stack not supported");
        }
        if (params.hasSetAspectRatio() && !this.mWindowManager.isValidPictureInPictureAspectRatio(((ActivityStack)r.getStack()).mDisplayId, params.getAspectRatio())) {
            float minAspectRatio = this.mContext.getResources().getFloat(17104956);
            float maxAspectRatio = this.mContext.getResources().getFloat(17104955);
            throw new IllegalArgumentException(String.format(caller + ": Aspect ratio is too extreme (must be between %f and %f).", Float.valueOf(minAspectRatio), Float.valueOf(maxAspectRatio)));
        }
        params.truncateActions(this.getMaxNumPictureInPictureActions(token));
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getProcessStatesAndOomScoresForPIDs(int[] pids, int[] states, int[] scores) {
        if (scores != null) {
            this.enforceCallingPermission("android.permission.GET_PROCESS_STATE_AND_OOM_SCORE", "getProcessStatesAndOomScoresForPIDs()");
        }
        if (pids == null) {
            throw new NullPointerException("pids");
        }
        if (states == null) {
            throw new NullPointerException("states");
        }
        if (pids.length != states.length) {
            throw new IllegalArgumentException("pids and states arrays have different lengths!");
        }
        if (scores != null && pids.length != scores.length) {
            throw new IllegalArgumentException("pids and scores arrays have different lengths!");
        }
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            for (int i = 0; i < pids.length; ++i) {
                ProcessRecord pr = this.mPidsSelfLocked.get(pids[i]);
                int n = states[i] = pr == null ? 18 : pr.curProcState;
                if (scores == null) continue;
                scores[i] = pr == null ? -10000 : pr.curAdj;
            }
        }
    }

    int checkComponentPermission(String permission2, int pid, int uid, int owningUid, boolean exported) {
        if (pid == MY_PID) {
            return 0;
        }
        return ActivityManager.checkComponentPermission(permission2, uid, owningUid, exported);
    }

    @Override
    public int checkPermission(String permission2, int pid, int uid) {
        if (permission2 == null) {
            return -1;
        }
        return this.checkComponentPermission(permission2, pid, uid, -1, true);
    }

    @Override
    public int checkPermissionWithToken(String permission2, int pid, int uid, IBinder callerToken) {
        if (permission2 == null) {
            return -1;
        }
        Identity tlsIdentity = sCallerIdentity.get();
        if (tlsIdentity != null && tlsIdentity.token == callerToken) {
            Slog.d("ActivityManager", "checkComponentPermission() adjusting {pid,uid} to {" + tlsIdentity.pid + "," + tlsIdentity.uid + "}");
            uid = tlsIdentity.uid;
            pid = tlsIdentity.pid;
        }
        return this.checkComponentPermission(permission2, pid, uid, -1, true);
    }

    int checkCallingPermission(String permission2) {
        return this.checkPermission(permission2, Binder.getCallingPid(), UserHandle.getAppId(Binder.getCallingUid()));
    }

    void enforceCallingPermission(String permission2, String func) {
        if (this.checkCallingPermission(permission2) == 0) {
            return;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission2;
        Slog.w("ActivityManager", msg);
        throw new SecurityException(msg);
    }

    private final boolean checkHoldingPermissionsLocked(IPackageManager pm, ProviderInfo pi, GrantUri grantUri, int uid, int modeFlags) {
        if (UserHandle.getUserId(uid) != grantUri.sourceUserId && ActivityManager.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS", uid, -1, true) != 0) {
            return false;
        }
        return this.checkHoldingPermissionsInternalLocked(pm, pi, grantUri, uid, modeFlags, true);
    }

    private final boolean checkHoldingPermissionsInternalLocked(IPackageManager pm, ProviderInfo pi, GrantUri grantUri, int uid, int modeFlags, boolean considerUidPermissions) {
        if (pi.applicationInfo.uid == uid) {
            return true;
        }
        if (!pi.exported) {
            return false;
        }
        boolean readMet = (modeFlags & 1) == 0;
        boolean writeMet = (modeFlags & 2) == 0;
        try {
            if (!readMet && pi.readPermission != null && considerUidPermissions && pm.checkUidPermission(pi.readPermission, uid) == 0) {
                readMet = true;
            }
            if (!writeMet && pi.writePermission != null && considerUidPermissions && pm.checkUidPermission(pi.writePermission, uid) == 0) {
                writeMet = true;
            }
            boolean allowDefaultRead = pi.readPermission == null;
            boolean allowDefaultWrite = pi.writePermission == null;
            PathPermission[] pps = pi.pathPermissions;
            if (pps != null) {
                String path = grantUri.uri.getPath();
                int i = pps.length;
                while (!(i <= 0 || readMet && writeMet)) {
                    String ppwperm;
                    String pprperm;
                    PathPermission pp;
                    if (!(pp = pps[--i]).match(path)) continue;
                    if (!readMet && (pprperm = pp.getReadPermission()) != null) {
                        if (considerUidPermissions && pm.checkUidPermission(pprperm, uid) == 0) {
                            readMet = true;
                        } else {
                            allowDefaultRead = false;
                        }
                    }
                    if (writeMet || (ppwperm = pp.getWritePermission()) == null) continue;
                    if (considerUidPermissions && pm.checkUidPermission(ppwperm, uid) == 0) {
                        writeMet = true;
                        continue;
                    }
                    allowDefaultWrite = false;
                }
            }
            if (allowDefaultRead) {
                readMet = true;
            }
            if (allowDefaultWrite) {
                writeMet = true;
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return readMet && writeMet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAppStartModeDisabled(int uid, String packageName) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.getAppStartModeLocked(uid, packageName, 0, -1, false, true) == 3;
        }
    }

    int appRestrictedInBackgroundLocked(int uid, String packageName, int packageTargetSdk) {
        if (packageTargetSdk >= 26) {
            return 2;
        }
        int appop = this.mAppOpsService.noteOperation(63, uid, packageName);
        switch (appop) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    int appServicesRestrictedInBackgroundLocked(int uid, String packageName, int packageTargetSdk) {
        if (this.mPackageManagerInt.isPackagePersistent(packageName)) {
            return 0;
        }
        if (this.uidOnBackgroundWhitelist(uid)) {
            return 0;
        }
        if (this.isOnDeviceIdleWhitelistLocked(uid)) {
            return 0;
        }
        return this.appRestrictedInBackgroundLocked(uid, packageName, packageTargetSdk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAppStartModeLocked(int uid, String packageName, int packageTargetSdk, int callingPid, boolean alwaysRestrict, boolean disabledOnly) {
        UidRecord uidRec = this.mActiveUids.get(uid);
        if (uidRec == null || alwaysRestrict || uidRec.idle) {
            int startMode;
            boolean ephemeral = uidRec == null ? this.getPackageManagerInternalLocked().isPackageEphemeral(UserHandle.getUserId(uid), packageName) : uidRec.ephemeral;
            if (ephemeral) {
                return 3;
            }
            if (disabledOnly) {
                return 0;
            }
            int n = startMode = alwaysRestrict ? this.appRestrictedInBackgroundLocked(uid, packageName, packageTargetSdk) : this.appServicesRestrictedInBackgroundLocked(uid, packageName, packageTargetSdk);
            if (startMode == 1 && callingPid >= 0) {
                ProcessRecord proc;
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    proc = this.mPidsSelfLocked.get(callingPid);
                }
                if (proc != null && !ActivityManager.isProcStateBackground(proc.curProcState)) {
                    return 0;
                }
            }
            return startMode;
        }
        return 0;
    }

    boolean isOnDeviceIdleWhitelistLocked(int uid) {
        int appId = UserHandle.getAppId(uid);
        return Arrays.binarySearch(this.mDeviceIdleWhitelist, appId) >= 0 || Arrays.binarySearch(this.mDeviceIdleTempWhitelist, appId) >= 0 || this.mPendingTempWhitelist.indexOfKey(uid) >= 0;
    }

    private ProviderInfo getProviderInfoLocked(String authority, int userHandle, int pmFlags) {
        ProviderInfo pi = null;
        ContentProviderRecord cpr = this.mProviderMap.getProviderByName(authority, userHandle);
        if (cpr != null) {
            pi = cpr.info;
        } else {
            try {
                pi = AppGlobals.getPackageManager().resolveContentProvider(authority, 0x800 | pmFlags, userHandle);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return pi;
    }

    void grantEphemeralAccessLocked(int userId, Intent intent, int targetAppId, int ephemeralAppId) {
        this.getPackageManagerInternalLocked().grantEphemeralAccess(userId, intent, targetAppId, ephemeralAppId);
    }

    private UriPermission findUriPermissionLocked(int targetUid, GrantUri grantUri) {
        ArrayMap<GrantUri, UriPermission> targetUris = this.mGrantedUriPermissions.get(targetUid);
        if (targetUris != null) {
            return targetUris.get(grantUri);
        }
        return null;
    }

    private UriPermission findOrCreateUriPermissionLocked(String sourcePkg, String targetPkg, int targetUid, GrantUri grantUri) {
        UriPermission perm;
        ArrayMap<GrantUri, UriPermission> targetUris = this.mGrantedUriPermissions.get(targetUid);
        if (targetUris == null) {
            targetUris = Maps.newArrayMap();
            this.mGrantedUriPermissions.put(targetUid, targetUris);
        }
        if ((perm = targetUris.get(grantUri)) == null) {
            perm = new UriPermission(sourcePkg, targetPkg, targetUid, grantUri);
            targetUris.put(grantUri, perm);
        }
        return perm;
    }

    private final boolean checkUriPermissionLocked(GrantUri grantUri, int uid, int modeFlags) {
        int minStrength;
        boolean persistable = (modeFlags & 0x40) != 0;
        int n = minStrength = persistable ? 3 : 1;
        if (uid == 0) {
            return true;
        }
        ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(uid);
        if (perms == null) {
            return false;
        }
        UriPermission exactPerm = perms.get(grantUri);
        if (exactPerm != null && exactPerm.getStrength(modeFlags) >= minStrength) {
            return true;
        }
        int N = perms.size();
        for (int i = 0; i < N; ++i) {
            UriPermission perm = perms.valueAt(i);
            if (!perm.uri.prefix || !grantUri.uri.isPathPrefixMatch(perm.uri.uri) || perm.getStrength(modeFlags) < minStrength) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkUriPermission(Uri uri, int pid, int uid, int modeFlags, int userId, IBinder callerToken) {
        this.enforceNotIsolatedCaller("checkUriPermission");
        Identity tlsIdentity = sCallerIdentity.get();
        if (tlsIdentity != null && tlsIdentity.token == callerToken) {
            uid = tlsIdentity.uid;
            pid = tlsIdentity.pid;
        }
        if (pid == MY_PID) {
            return 0;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.checkUriPermissionLocked(new GrantUri(userId, uri, false), uid, modeFlags) ? 0 : -1;
        }
    }

    int checkGrantUriPermissionLocked(int callingUid, String targetPkg, GrantUri grantUri, int modeFlags, int lastTargetUid) {
        int callingAppId;
        boolean specialCrossUserGrant;
        if (!Intent.isAccessUriMode(modeFlags)) {
            return -1;
        }
        if (targetPkg != null) {
            // empty if block
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        if (!"content".equals(grantUri.uri.getScheme())) {
            return -1;
        }
        String authority = grantUri.uri.getAuthority();
        ProviderInfo pi = this.getProviderInfoLocked(authority, grantUri.sourceUserId, 0x10000000);
        if (pi == null) {
            Slog.w("ActivityManager", "No content provider found for permission check: " + grantUri.uri.toSafeString());
            return -1;
        }
        int targetUid = lastTargetUid;
        if (targetUid < 0 && targetPkg != null) {
            try {
                targetUid = pm.getPackageUid(targetPkg, 0x10000000, UserHandle.getUserId(callingUid));
                if (targetUid < 0) {
                    return -1;
                }
            }
            catch (RemoteException ex) {
                return -1;
            }
        }
        if ((modeFlags & 0x40) != 0) {
            return targetUid;
        }
        if (targetUid >= 0) {
            if (this.checkHoldingPermissionsLocked(pm, pi, grantUri, targetUid, modeFlags)) {
                return -1;
            }
        } else {
            boolean allowed = pi.exported;
            if ((modeFlags & 1) != 0 && pi.readPermission != null) {
                allowed = false;
            }
            if ((modeFlags & 2) != 0 && pi.writePermission != null) {
                allowed = false;
            }
            if (allowed) {
                return -1;
            }
        }
        boolean bl = specialCrossUserGrant = UserHandle.getUserId(targetUid) != grantUri.sourceUserId && this.checkHoldingPermissionsInternalLocked(pm, pi, grantUri, callingUid, modeFlags, false);
        if (!specialCrossUserGrant) {
            if (!pi.grantUriPermissions) {
                throw new SecurityException("Provider " + pi.packageName + "/" + pi.name + " does not allow granting of Uri permissions (uri " + grantUri + ")");
            }
            if (pi.uriPermissionPatterns != null) {
                int N = pi.uriPermissionPatterns.length;
                boolean allowed = false;
                for (int i = 0; i < N; ++i) {
                    if (pi.uriPermissionPatterns[i] == null || !pi.uriPermissionPatterns[i].match(grantUri.uri.getPath())) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    throw new SecurityException("Provider " + pi.packageName + "/" + pi.name + " does not allow granting of permission to path of Uri " + grantUri);
                }
            }
        }
        if (!((callingAppId = UserHandle.getAppId(callingUid)) != 1000 && callingAppId != 0 || "com.android.settings.files".equals(grantUri.uri.getAuthority()))) {
            Slog.w("ActivityManager", "For security reasons, the system cannot issue a Uri permission grant to " + grantUri + "; use startActivityAsCaller() instead");
            return -1;
        }
        if (!this.checkHoldingPermissionsLocked(pm, pi, grantUri, callingUid, modeFlags) && !this.checkUriPermissionLocked(grantUri, callingUid, modeFlags)) {
            if ("android.permission.MANAGE_DOCUMENTS".equals(pi.readPermission)) {
                throw new SecurityException("UID " + callingUid + " does not have permission to " + grantUri + "; you could obtain access using ACTION_OPEN_DOCUMENT " + "or related APIs");
            }
            throw new SecurityException("UID " + callingUid + " does not have permission to " + grantUri);
        }
        return targetUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkGrantUriPermission(int callingUid, String targetPkg, Uri uri, int modeFlags, int userId) {
        this.enforceNotIsolatedCaller("checkGrantUriPermission");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.checkGrantUriPermissionLocked(callingUid, targetPkg, new GrantUri(userId, uri, false), modeFlags, -1);
        }
    }

    void grantUriPermissionUncheckedLocked(int targetUid, String targetPkg, GrantUri grantUri, int modeFlags, UriPermissionOwner owner) {
        if (!Intent.isAccessUriMode(modeFlags)) {
            return;
        }
        String authority = grantUri.uri.getAuthority();
        ProviderInfo pi = this.getProviderInfoLocked(authority, grantUri.sourceUserId, 0x10000000);
        if (pi == null) {
            Slog.w("ActivityManager", "No content provider found for grant: " + grantUri.toSafeString());
            return;
        }
        if ((modeFlags & 0x80) != 0) {
            grantUri.prefix = true;
        }
        UriPermission perm = this.findOrCreateUriPermissionLocked(pi.packageName, targetPkg, targetUid, grantUri);
        perm.grantModes(modeFlags, owner);
    }

    void grantUriPermissionLocked(int callingUid, String targetPkg, GrantUri grantUri, int modeFlags, UriPermissionOwner owner, int targetUserId) {
        int targetUid;
        if (targetPkg == null) {
            throw new NullPointerException(ATTR_TARGET_PKG);
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            targetUid = pm.getPackageUid(targetPkg, 0x10000000, targetUserId);
        }
        catch (RemoteException ex) {
            return;
        }
        targetUid = this.checkGrantUriPermissionLocked(callingUid, targetPkg, grantUri, modeFlags, targetUid);
        if (targetUid < 0) {
            return;
        }
        this.grantUriPermissionUncheckedLocked(targetUid, targetPkg, grantUri, modeFlags, owner);
    }

    NeededUriGrants checkGrantUriPermissionFromIntentLocked(int callingUid, String targetPkg, Intent intent, int mode, NeededUriGrants needed, int targetUserId) {
        GrantUri grantUri;
        int targetUid;
        if (targetPkg == null) {
            throw new NullPointerException(ATTR_TARGET_PKG);
        }
        if (intent == null) {
            return null;
        }
        Uri data = intent.getData();
        ClipData clip = intent.getClipData();
        if (data == null && clip == null) {
            return null;
        }
        int contentUserHint = intent.getContentUserHint();
        if (contentUserHint == -2) {
            contentUserHint = UserHandle.getUserId(callingUid);
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        if (needed != null) {
            targetUid = needed.targetUid;
        } else {
            try {
                targetUid = pm.getPackageUid(targetPkg, 0x10000000, targetUserId);
            }
            catch (RemoteException ex) {
                return null;
            }
            if (targetUid < 0) {
                return null;
            }
        }
        if (data != null && (targetUid = this.checkGrantUriPermissionLocked(callingUid, targetPkg, grantUri = GrantUri.resolve(contentUserHint, data), mode, targetUid)) > 0) {
            if (needed == null) {
                needed = new NeededUriGrants(targetPkg, targetUid, mode);
            }
            needed.add(grantUri);
        }
        if (clip != null) {
            for (int i = 0; i < clip.getItemCount(); ++i) {
                NeededUriGrants newNeeded;
                Uri uri = clip.getItemAt(i).getUri();
                if (uri != null) {
                    GrantUri grantUri2 = GrantUri.resolve(contentUserHint, uri);
                    targetUid = this.checkGrantUriPermissionLocked(callingUid, targetPkg, grantUri2, mode, targetUid);
                    if (targetUid <= 0) continue;
                    if (needed == null) {
                        needed = new NeededUriGrants(targetPkg, targetUid, mode);
                    }
                    needed.add(grantUri2);
                    continue;
                }
                Intent clipIntent = clip.getItemAt(i).getIntent();
                if (clipIntent == null || (newNeeded = this.checkGrantUriPermissionFromIntentLocked(callingUid, targetPkg, clipIntent, mode, needed, targetUserId)) == null) continue;
                needed = newNeeded;
            }
        }
        return needed;
    }

    void grantUriPermissionUncheckedFromIntentLocked(NeededUriGrants needed, UriPermissionOwner owner) {
        if (needed != null) {
            for (int i = 0; i < needed.size(); ++i) {
                GrantUri grantUri = (GrantUri)needed.get(i);
                this.grantUriPermissionUncheckedLocked(needed.targetUid, needed.targetPkg, grantUri, needed.flags, owner);
            }
        }
    }

    void grantUriPermissionFromIntentLocked(int callingUid, String targetPkg, Intent intent, UriPermissionOwner owner, int targetUserId) {
        NeededUriGrants needed = this.checkGrantUriPermissionFromIntentLocked(callingUid, targetPkg, intent, intent != null ? intent.getFlags() : 0, null, targetUserId);
        if (needed == null) {
            return;
        }
        this.grantUriPermissionUncheckedFromIntentLocked(needed, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantUriPermission(IApplicationThread caller, String targetPkg, Uri uri, int modeFlags, int userId) {
        this.enforceNotIsolatedCaller("grantUriPermission");
        GrantUri grantUri = new GrantUri(userId, uri, false);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " when granting permission to uri " + grantUri);
            }
            if (targetPkg == null) {
                throw new IllegalArgumentException("null target");
            }
            if (grantUri == null) {
                throw new IllegalArgumentException("null uri");
            }
            Preconditions.checkFlagsArgument(modeFlags, 195);
            this.grantUriPermissionLocked(r.uid, targetPkg, grantUri, modeFlags, null, UserHandle.getUserId(r.uid));
        }
    }

    void removeUriPermissionIfNeededLocked(UriPermission perm) {
        ArrayMap<GrantUri, UriPermission> perms;
        if (perm.modeFlags == 0 && (perms = this.mGrantedUriPermissions.get(perm.targetUid)) != null) {
            perms.remove(perm.uri);
            if (perms.isEmpty()) {
                this.mGrantedUriPermissions.remove(perm.targetUid);
            }
        }
    }

    private void revokeUriPermissionLocked(String targetPackage, int callingUid, GrantUri grantUri, int modeFlags) {
        IPackageManager pm = AppGlobals.getPackageManager();
        String authority = grantUri.uri.getAuthority();
        ProviderInfo pi = this.getProviderInfoLocked(authority, grantUri.sourceUserId, 786432);
        if (pi == null) {
            Slog.w("ActivityManager", "No content provider found for permission revoke: " + grantUri.toSafeString());
            return;
        }
        if (!this.checkHoldingPermissionsLocked(pm, pi, grantUri, callingUid, modeFlags)) {
            ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(callingUid);
            if (perms != null) {
                boolean persistChanged = false;
                for (int i = perms.size() - 1; i >= 0; --i) {
                    UriPermission perm = perms.valueAt(i);
                    if (targetPackage != null && !targetPackage.equals(perm.targetPkg) || perm.uri.sourceUserId != grantUri.sourceUserId || !perm.uri.uri.isPathPrefixMatch(grantUri.uri)) continue;
                    persistChanged |= perm.revokeModes(modeFlags | 0x40, false);
                    if (perm.modeFlags != 0) continue;
                    perms.removeAt(i);
                }
                if (perms.isEmpty()) {
                    this.mGrantedUriPermissions.remove(callingUid);
                }
                if (persistChanged) {
                    this.schedulePersistUriGrants();
                }
            }
            return;
        }
        boolean persistChanged = false;
        for (int i = this.mGrantedUriPermissions.size() - 1; i >= 0; --i) {
            int targetUid = this.mGrantedUriPermissions.keyAt(i);
            ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
            for (int j = perms.size() - 1; j >= 0; --j) {
                UriPermission perm = perms.valueAt(j);
                if (targetPackage != null && !targetPackage.equals(perm.targetPkg) || perm.uri.sourceUserId != grantUri.sourceUserId || !perm.uri.uri.isPathPrefixMatch(grantUri.uri)) continue;
                persistChanged |= perm.revokeModes(modeFlags | 0x40, targetPackage == null);
                if (perm.modeFlags != 0) continue;
                perms.removeAt(j);
            }
            if (!perms.isEmpty()) continue;
            this.mGrantedUriPermissions.removeAt(i);
        }
        if (persistChanged) {
            this.schedulePersistUriGrants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeUriPermission(IApplicationThread caller, String targetPackage, Uri uri, int modeFlags, int userId) {
        this.enforceNotIsolatedCaller("revokeUriPermission");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " when revoking permission to uri " + uri);
            }
            if (uri == null) {
                Slog.w("ActivityManager", "revokeUriPermission: null uri");
                return;
            }
            if (!Intent.isAccessUriMode(modeFlags)) {
                return;
            }
            String authority = uri.getAuthority();
            ProviderInfo pi = this.getProviderInfoLocked(authority, userId, 786432);
            if (pi == null) {
                Slog.w("ActivityManager", "No content provider found for permission revoke: " + uri.toSafeString());
                return;
            }
            this.revokeUriPermissionLocked(targetPackage, r.uid, new GrantUri(userId, uri, false), modeFlags);
        }
    }

    private void removeUriPermissionsForPackageLocked(String packageName, int userHandle, boolean persistable) {
        if (userHandle == -1 && packageName == null) {
            throw new IllegalArgumentException("Must narrow by either package or user");
        }
        boolean persistChanged = false;
        int N = this.mGrantedUriPermissions.size();
        for (int i = 0; i < N; ++i) {
            int targetUid = this.mGrantedUriPermissions.keyAt(i);
            ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
            if (userHandle != -1 && userHandle != UserHandle.getUserId(targetUid)) continue;
            Iterator<UriPermission> it = perms.values().iterator();
            while (it.hasNext()) {
                UriPermission perm = it.next();
                if (packageName != null && !perm.sourcePkg.equals(packageName) && !perm.targetPkg.equals(packageName) || "downloads".equals(perm.uri.uri.getAuthority()) && !persistable) continue;
                persistChanged |= perm.revokeModes(persistable ? -1 : -65, true);
                if (perm.modeFlags != 0) continue;
                it.remove();
            }
            if (!perms.isEmpty()) continue;
            this.mGrantedUriPermissions.remove(targetUid);
            --N;
            --i;
        }
        if (persistChanged) {
            this.schedulePersistUriGrants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder newUriPermissionOwner(String name) {
        this.enforceNotIsolatedCaller("newUriPermissionOwner");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UriPermissionOwner owner = new UriPermissionOwner(this, name);
            return owner.getExternalTokenLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder getUriPermissionOwnerForActivity(IBinder activityToken) {
        this.enforceNotIsolatedCaller("getUriPermissionOwnerForActivity");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(activityToken);
            if (r == null) {
                throw new IllegalArgumentException("Activity does not exist; token=" + activityToken);
            }
            return r.getUriPermissionsLocked().getExternalTokenLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantUriPermissionFromOwner(IBinder token, int fromUid, String targetPkg, Uri uri, int modeFlags, int sourceUserId, int targetUserId) {
        targetUserId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), targetUserId, false, 2, "grantUriPermissionFromOwner", null);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UriPermissionOwner owner = UriPermissionOwner.fromExternalToken(token);
            if (owner == null) {
                throw new IllegalArgumentException("Unknown owner: " + token);
            }
            if (fromUid != Binder.getCallingUid() && Binder.getCallingUid() != android.os.Process.myUid()) {
                throw new SecurityException("nice try");
            }
            if (targetPkg == null) {
                throw new IllegalArgumentException("null target");
            }
            if (uri == null) {
                throw new IllegalArgumentException("null uri");
            }
            this.grantUriPermissionLocked(fromUid, targetPkg, new GrantUri(sourceUserId, uri, false), modeFlags, owner, targetUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeUriPermissionFromOwner(IBinder token, Uri uri, int mode, int userId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UriPermissionOwner owner = UriPermissionOwner.fromExternalToken(token);
            if (owner == null) {
                throw new IllegalArgumentException("Unknown owner: " + token);
            }
            if (uri == null) {
                owner.removeUriPermissionsLocked(mode);
            } else {
                boolean prefix = (mode & 0x80) != 0;
                owner.removeUriPermissionLocked(new GrantUri(userId, uri, prefix), mode);
            }
        }
    }

    private void schedulePersistUriGrants() {
        if (!this.mHandler.hasMessages(38)) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(38), 10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGrantedUriPermissions() {
        block8: {
            ArrayList<UriPermission.Snapshot> persist = Lists.newArrayList();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                int size = this.mGrantedUriPermissions.size();
                for (int i = 0; i < size; ++i) {
                    ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                    for (UriPermission perm : perms.values()) {
                        if (perm.persistedModeFlags == 0) continue;
                        persist.add(perm.snapshot());
                    }
                }
            }
            FileOutputStream fos = null;
            try {
                fos = this.mGrantFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, TAG_URI_GRANTS);
                for (UriPermission.Snapshot perm : persist) {
                    out.startTag(null, TAG_URI_GRANT);
                    XmlUtils.writeIntAttribute(out, ATTR_SOURCE_USER_ID, perm.uri.sourceUserId);
                    XmlUtils.writeIntAttribute(out, ATTR_TARGET_USER_ID, perm.targetUserId);
                    out.attribute(null, ATTR_SOURCE_PKG, perm.sourcePkg);
                    out.attribute(null, ATTR_TARGET_PKG, perm.targetPkg);
                    out.attribute(null, ATTR_URI, String.valueOf(perm.uri.uri));
                    XmlUtils.writeBooleanAttribute(out, ATTR_PREFIX, perm.uri.prefix);
                    XmlUtils.writeIntAttribute(out, ATTR_MODE_FLAGS, perm.persistedModeFlags);
                    XmlUtils.writeLongAttribute(out, ATTR_CREATED_TIME, perm.persistedCreateTime);
                    out.endTag(null, TAG_URI_GRANT);
                }
                out.endTag(null, TAG_URI_GRANTS);
                out.endDocument();
                this.mGrantFile.finishWrite(fos);
            }
            catch (IOException e) {
                if (fos == null) break block8;
                this.mGrantFile.failWrite(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readGrantedUriPermissionsLocked() {
        long now = System.currentTimeMillis();
        FileInputStream fis = null;
        try {
            int type;
            fis = this.mGrantFile.openRead();
            XmlPullParser in = Xml.newPullParser();
            in.setInput(fis, StandardCharsets.UTF_8.name());
            while ((type = in.next()) != 1) {
                int targetUserId;
                int sourceUserId;
                String tag = in.getName();
                if (type != 2 || !TAG_URI_GRANT.equals(tag)) continue;
                int userHandle = XmlUtils.readIntAttribute(in, ATTR_USER_HANDLE, -10000);
                if (userHandle != -10000) {
                    sourceUserId = userHandle;
                    targetUserId = userHandle;
                } else {
                    sourceUserId = XmlUtils.readIntAttribute(in, ATTR_SOURCE_USER_ID);
                    targetUserId = XmlUtils.readIntAttribute(in, ATTR_TARGET_USER_ID);
                }
                String sourcePkg = in.getAttributeValue(null, ATTR_SOURCE_PKG);
                String targetPkg = in.getAttributeValue(null, ATTR_TARGET_PKG);
                Uri uri = Uri.parse(in.getAttributeValue(null, ATTR_URI));
                boolean prefix = XmlUtils.readBooleanAttribute(in, ATTR_PREFIX);
                int modeFlags = XmlUtils.readIntAttribute(in, ATTR_MODE_FLAGS);
                long createdTime = XmlUtils.readLongAttribute(in, ATTR_CREATED_TIME, now);
                ProviderInfo pi = this.getProviderInfoLocked(uri.getAuthority(), sourceUserId, 786432);
                if (pi != null && sourcePkg.equals(pi.packageName)) {
                    int targetUid = -1;
                    try {
                        targetUid = AppGlobals.getPackageManager().getPackageUid(targetPkg, 8192, targetUserId);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (targetUid == -1) continue;
                    UriPermission perm = this.findOrCreateUriPermissionLocked(sourcePkg, targetPkg, targetUid, new GrantUri(sourceUserId, uri, prefix));
                    perm.initPersistedModes(modeFlags, createdTime);
                    continue;
                }
                Slog.w("ActivityManager", "Persisted grant for " + uri + " had source " + sourcePkg + " but instead found " + pi);
            }
        }
        catch (FileNotFoundException in) {
        }
        catch (IOException e) {
            Slog.wtf("ActivityManager", "Failed reading Uri grants", e);
        }
        catch (XmlPullParserException e) {
            Slog.wtf("ActivityManager", "Failed reading Uri grants", e);
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takePersistableUriPermission(Uri uri, int modeFlags, int userId) {
        this.enforceNotIsolatedCaller("takePersistableUriPermission");
        Preconditions.checkFlagsArgument(modeFlags, 3);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean prefixValid;
            int callingUid = Binder.getCallingUid();
            boolean persistChanged = false;
            GrantUri grantUri = new GrantUri(userId, uri, false);
            UriPermission exactPerm = this.findUriPermissionLocked(callingUid, new GrantUri(userId, uri, false));
            UriPermission prefixPerm = this.findUriPermissionLocked(callingUid, new GrantUri(userId, uri, true));
            boolean exactValid = exactPerm != null && (modeFlags & exactPerm.persistableModeFlags) == modeFlags;
            boolean bl = prefixValid = prefixPerm != null && (modeFlags & prefixPerm.persistableModeFlags) == modeFlags;
            if (!exactValid && !prefixValid) {
                throw new SecurityException("No persistable permission grants found for UID " + callingUid + " and Uri " + grantUri.toSafeString());
            }
            if (exactValid) {
                persistChanged |= exactPerm.takePersistableModes(modeFlags);
            }
            if (prefixValid) {
                persistChanged |= prefixPerm.takePersistableModes(modeFlags);
            }
            if (persistChanged |= this.maybePrunePersistedUriGrantsLocked(callingUid)) {
                this.schedulePersistUriGrants();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePersistableUriPermission(Uri uri, int modeFlags, int userId) {
        this.enforceNotIsolatedCaller("releasePersistableUriPermission");
        Preconditions.checkFlagsArgument(modeFlags, 3);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingUid = Binder.getCallingUid();
            boolean persistChanged = false;
            UriPermission exactPerm = this.findUriPermissionLocked(callingUid, new GrantUri(userId, uri, false));
            UriPermission prefixPerm = this.findUriPermissionLocked(callingUid, new GrantUri(userId, uri, true));
            if (exactPerm == null && prefixPerm == null) {
                throw new SecurityException("No permission grants found for UID " + callingUid + " and Uri " + uri.toSafeString());
            }
            if (exactPerm != null) {
                persistChanged |= exactPerm.releasePersistableModes(modeFlags);
                this.removeUriPermissionIfNeededLocked(exactPerm);
            }
            if (prefixPerm != null) {
                persistChanged |= prefixPerm.releasePersistableModes(modeFlags);
                this.removeUriPermissionIfNeededLocked(prefixPerm);
            }
            if (persistChanged) {
                this.schedulePersistUriGrants();
            }
        }
    }

    private boolean maybePrunePersistedUriGrantsLocked(int uid) {
        ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(uid);
        if (perms == null) {
            return false;
        }
        if (perms.size() < 128) {
            return false;
        }
        ArrayList<UriPermission> persisted = Lists.newArrayList();
        for (UriPermission perm : perms.values()) {
            if (perm.persistedModeFlags == 0) continue;
            persisted.add(perm);
        }
        int trimCount = persisted.size() - 128;
        if (trimCount <= 0) {
            return false;
        }
        Collections.sort(persisted, new UriPermission.PersistedTimeComparator());
        for (int i = 0; i < trimCount; ++i) {
            UriPermission perm = (UriPermission)persisted.get(i);
            perm.releasePersistableModes(-1);
            this.removeUriPermissionIfNeededLocked(perm);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<android.content.UriPermission> getPersistedUriPermissions(String packageName, boolean incoming) {
        this.enforceNotIsolatedCaller("getPersistedUriPermissions");
        Preconditions.checkNotNull(packageName, "packageName");
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            int packageUid = pm.getPackageUid(packageName, 786432, callingUserId);
            if (packageUid != callingUid) {
                throw new SecurityException("Package " + packageName + " does not belong to calling UID " + callingUid);
            }
        }
        catch (RemoteException e) {
            throw new SecurityException("Failed to verify package name ownership");
        }
        ArrayList<android.content.UriPermission> result = Lists.newArrayList();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (incoming) {
                ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(callingUid);
                if (perms == null) {
                    Slog.w("ActivityManager", "No permission grants found for " + packageName);
                } else {
                    for (UriPermission perm : perms.values()) {
                        if (!packageName.equals(perm.targetPkg) || perm.persistedModeFlags == 0) continue;
                        result.add(perm.buildPersistedPublicApiObject());
                    }
                }
            } else {
                int size = this.mGrantedUriPermissions.size();
                for (int i = 0; i < size; ++i) {
                    ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                    for (UriPermission perm : perms.values()) {
                        if (!packageName.equals(perm.sourcePkg) || perm.persistedModeFlags == 0) continue;
                        result.add(perm.buildPersistedPublicApiObject());
                    }
                }
            }
        }
        return new ParceledListSlice<android.content.UriPermission>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<android.content.UriPermission> getGrantedUriPermissions(String packageName, int userId) {
        this.enforceCallingPermission("android.permission.GET_APP_GRANTED_URI_PERMISSIONS", "getGrantedUriPermissions");
        ArrayList<android.content.UriPermission> result = Lists.newArrayList();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int size = this.mGrantedUriPermissions.size();
            for (int i = 0; i < size; ++i) {
                ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                for (UriPermission perm : perms.values()) {
                    if (!packageName.equals(perm.targetPkg) || perm.targetUserId != userId || perm.persistedModeFlags == 0) continue;
                    result.add(perm.buildPersistedPublicApiObject());
                }
            }
        }
        return new ParceledListSlice<android.content.UriPermission>(result);
    }

    @Override
    public void clearGrantedUriPermissions(String packageName, int userId) {
        this.enforceCallingPermission("android.permission.CLEAR_APP_GRANTED_URI_PERMISSIONS", "clearGrantedUriPermissions");
        this.removeUriPermissionsForPackageLocked(packageName, userId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showWaitingForDebugger(IApplicationThread who, boolean waiting) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app;
            ProcessRecord processRecord = app = who != null ? this.getRecordForAppLocked(who) : null;
            if (app == null) {
                return;
            }
            Message msg = Message.obtain();
            msg.what = 6;
            msg.obj = app;
            msg.arg1 = waiting ? 1 : 0;
            this.mUiHandler.sendMessage(msg);
        }
    }

    @Override
    public void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        long homeAppMem = this.mProcessList.getMemLevel(600);
        long cachedAppMem = this.mProcessList.getMemLevel(900);
        outInfo.availMem = android.os.Process.getFreeMemory();
        outInfo.totalMem = android.os.Process.getTotalMemory();
        outInfo.threshold = homeAppMem;
        outInfo.lowMemory = outInfo.availMem < homeAppMem + (cachedAppMem - homeAppMem) / 2L;
        outInfo.hiddenAppThreshold = cachedAppMem;
        outInfo.secondaryServerThreshold = this.mProcessList.getMemLevel(500);
        outInfo.visibleAppThreshold = this.mProcessList.getMemLevel(100);
        outInfo.foregroundAppThreshold = this.mProcessList.getMemLevel(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IBinder> getAppTasks(String callingPackage) {
        int callingUid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ArrayList<IBinder> list = new ArrayList<IBinder>();
            try {
                int N = this.mRecentTasks.size();
                for (int i = 0; i < N; ++i) {
                    Intent intent;
                    TaskRecord tr = (TaskRecord)this.mRecentTasks.get(i);
                    if (tr.effectiveUid != callingUid || (intent = tr.getBaseIntent()) == null || !callingPackage.equals(intent.getComponent().getPackageName())) continue;
                    ActivityManager.RecentTaskInfo taskInfo = this.createRecentTaskInfoFromTaskRecord(tr);
                    AppTaskImpl taskImpl = new AppTaskImpl(taskInfo.persistentId, callingUid);
                    list.add(taskImpl.asBinder());
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.RunningTaskInfo> getTasks(int maxNum, int flags) {
        int callingUid = Binder.getCallingUid();
        ArrayList<ActivityManager.RunningTaskInfo> list = new ArrayList<ActivityManager.RunningTaskInfo>();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean allowed = this.isGetTasksAllowed("getTasks", Binder.getCallingPid(), callingUid);
            this.mStackSupervisor.getTasksLocked(maxNum, list, callingUid, allowed);
        }
        return list;
    }

    private ActivityManager.RecentTaskInfo createRecentTaskInfoFromTaskRecord(TaskRecord tr) {
        tr.updateTaskDescription();
        ActivityManager.RecentTaskInfo rti = new ActivityManager.RecentTaskInfo();
        rti.id = tr.getTopActivity() == null ? -1 : tr.taskId;
        rti.persistentId = tr.taskId;
        rti.baseIntent = new Intent(tr.getBaseIntent());
        rti.origActivity = tr.origActivity;
        rti.realActivity = tr.realActivity;
        rti.description = tr.lastDescription;
        rti.stackId = tr.getStackId();
        rti.userId = tr.userId;
        rti.taskDescription = new ActivityManager.TaskDescription(tr.lastTaskDescription);
        rti.firstActiveTime = tr.firstActiveTime;
        rti.lastActiveTime = tr.lastActiveTime;
        rti.affiliatedTaskId = tr.mAffiliatedTaskId;
        rti.affiliatedTaskColor = tr.mAffiliatedTaskColor;
        rti.numActivities = 0;
        if (tr.mBounds != null) {
            rti.bounds = new Rect(tr.mBounds);
        }
        rti.supportsSplitScreenMultiWindow = tr.supportsSplitScreen();
        rti.resizeMode = tr.mResizeMode;
        ActivityRecord base = null;
        ActivityRecord top = null;
        for (int i = tr.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord tmp = tr.mActivities.get(i);
            if (tmp.finishing) continue;
            base = tmp;
            if (top == null || top.state == ActivityStack.ActivityState.INITIALIZING) {
                top = base;
            }
            ++rti.numActivities;
        }
        rti.baseActivity = base != null ? base.intent.getComponent() : null;
        rti.topActivity = top != null ? top.intent.getComponent() : null;
        return rti;
    }

    private boolean isGetTasksAllowed(String caller, int callingPid, int callingUid) {
        boolean allowed;
        boolean bl = allowed = this.checkPermission("android.permission.REAL_GET_TASKS", callingPid, callingUid) == 0;
        if (!allowed && this.checkPermission("android.permission.GET_TASKS", callingPid, callingUid) == 0) {
            try {
                if (AppGlobals.getPackageManager().isUidPrivileged(callingUid)) {
                    allowed = true;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (!allowed) {
            // empty if block
        }
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ActivityManager.RecentTaskInfo> getRecentTasks(int maxNum, int flags, int userId) {
        int callingUid = Binder.getCallingUid();
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), callingUid, userId, false, 2, "getRecentTasks", null);
        boolean includeProfiles = (flags & 4) != 0;
        boolean withExcluded = (flags & 1) != 0;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean detailed;
            boolean allowed = this.isGetTasksAllowed("getRecentTasks", Binder.getCallingPid(), callingUid);
            boolean bl = detailed = this.checkCallingPermission("android.permission.GET_DETAILED_TASKS") == 0;
            if (!this.isUserRunning(userId, 4)) {
                Slog.i("ActivityManager", "user " + userId + " is still locked. Cannot load recents");
                return ParceledListSlice.emptyList();
            }
            this.mRecentTasks.loadUserRecentsLocked(userId);
            int recentsCount = this.mRecentTasks.size();
            ArrayList<ActivityManager.RecentTaskInfo> res = new ArrayList<ActivityManager.RecentTaskInfo>(maxNum < recentsCount ? maxNum : recentsCount);
            Set<Object> includedUsers = includeProfiles ? this.mUserController.getProfileIds(userId) : new HashSet();
            includedUsers.add(userId);
            for (int i = 0; i < recentsCount && maxNum > 0; ++i) {
                TaskRecord tr = (TaskRecord)this.mRecentTasks.get(i);
                if (!includedUsers.contains(tr.userId) || tr.realActivitySuspended || i != 0 && !withExcluded && tr.intent != null && (tr.intent.getFlags() & 0x800000) != 0 || !allowed && !tr.isHomeTask() && tr.effectiveUid != callingUid) continue;
                ActivityStack stack = tr.getStack();
                if ((flags & 8) != 0 && stack != null && stack.isHomeOrRecentsStack() || (flags & 0x10) != 0 && stack != null && stack.isDockedStack() && stack.topTask() == tr || (flags & 0x20) != 0 && stack != null && stack.isPinnedStack() || tr.autoRemoveRecents && tr.getTopActivity() == null || (flags & 2) != 0 && !tr.isAvailable || !tr.mUserSetupComplete) continue;
                ActivityManager.RecentTaskInfo rti = this.createRecentTaskInfoFromTaskRecord(tr);
                if (!detailed) {
                    rti.baseIntent.replaceExtras((Bundle)null);
                }
                res.add(rti);
                --maxNum;
            }
            return new ParceledListSlice<ActivityManager.RecentTaskInfo>(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityManager.TaskThumbnail getTaskThumbnail(int id2) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.enforceCallingPermission("android.permission.READ_FRAME_BUFFER", "getTaskThumbnail()");
            TaskRecord tr = this.mStackSupervisor.anyTaskForIdLocked(id2, 1, -1);
            if (tr != null) {
                return tr.getTaskThumbnailLocked();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityManager.TaskDescription getTaskDescription(int id2) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "getTaskDescription()");
            TaskRecord tr = this.mStackSupervisor.anyTaskForIdLocked(id2, 1, -1);
            if (tr != null) {
                return tr.lastTaskDescription;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int addAppTask(IBinder activityToken, Intent intent, ActivityManager.TaskDescription description, Bitmap thumbnail) throws RemoteException {
        TaskRecord task;
        ActivityRecord r;
        long callingIdent;
        block16: {
            int n;
            int callingUid = Binder.getCallingUid();
            callingIdent = Binder.clearCallingIdentity();
            try {
                int trimIdx;
                ActivityInfo ainfo;
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                r = ActivityRecord.isInStackLocked(activityToken);
                if (r == null) {
                    throw new IllegalArgumentException("Activity does not exist; token=" + activityToken);
                }
                ComponentName comp = intent.getComponent();
                if (comp == null) {
                    throw new IllegalArgumentException("Intent " + intent + " must specify explicit component");
                }
                if (thumbnail.getWidth() != this.mThumbnailWidth) throw new IllegalArgumentException("Bad thumbnail size: got " + thumbnail.getWidth() + "x" + thumbnail.getHeight() + ", require " + this.mThumbnailWidth + "x" + this.mThumbnailHeight);
                if (thumbnail.getHeight() != this.mThumbnailHeight) {
                    throw new IllegalArgumentException("Bad thumbnail size: got " + thumbnail.getWidth() + "x" + thumbnail.getHeight() + ", require " + this.mThumbnailWidth + "x" + this.mThumbnailHeight);
                }
                if (intent.getSelector() != null) {
                    intent.setSelector(null);
                }
                if (intent.getSourceBounds() != null) {
                    intent.setSourceBounds(null);
                }
                if ((intent.getFlags() & 0x80000) != 0 && (intent.getFlags() & 0x2000) == 0) {
                    intent.addFlags(8192);
                }
                if (!comp.equals(this.mLastAddedTaskComponent) || callingUid != this.mLastAddedTaskUid) {
                    this.mLastAddedTaskActivity = null;
                }
                if ((ainfo = this.mLastAddedTaskActivity) == null) {
                    ainfo = this.mLastAddedTaskActivity = AppGlobals.getPackageManager().getActivityInfo(comp, 0, UserHandle.getUserId(callingUid));
                    if (ainfo.applicationInfo.uid != callingUid) {
                        throw new SecurityException("Can't add task for another application: target uid=" + ainfo.applicationInfo.uid + ", calling uid=" + callingUid);
                    }
                }
                if ((trimIdx = this.mRecentTasks.trimForTaskLocked(task = new TaskRecord(this, this.mStackSupervisor.getNextTaskIdForUserLocked(r.userId), ainfo, intent, description, new ActivityManager.TaskThumbnailInfo()), false)) < 0) break block16;
                n = -1;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(callingIdent);
                throw throwable;
            }
            Binder.restoreCallingIdentity(callingIdent);
            return n;
        }
        int N = this.mRecentTasks.size();
        if (N >= ActivityManager.getMaxRecentTasksStatic() - 1) {
            TaskRecord tr = (TaskRecord)this.mRecentTasks.remove(N - 1);
            tr.removedFromRecents();
        }
        task.inRecents = true;
        this.mRecentTasks.add(task);
        ((ActivityStack)r.getStack()).addTask(task, false, "addAppTask");
        task.setLastThumbnailLocked(thumbnail);
        task.freeLastThumbnail();
        int n = task.taskId;
        // MONITOREXIT : activityManagerService
        Binder.restoreCallingIdentity(callingIdent);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getAppTaskThumbnailSize() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return new Point(this.mThumbnailWidth, this.mThumbnailHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTaskDescription(IBinder token, ActivityManager.TaskDescription td) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r != null) {
                r.setTaskDescription(td);
                TaskRecord task = r.getTask();
                task.updateTaskDescription();
                this.mTaskChangeNotificationController.notifyTaskDescriptionChanged(task.taskId, td);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTaskResizeable(int taskId, int resizeableMode) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            TaskRecord task = this.mStackSupervisor.anyTaskForIdLocked(taskId, 1, -1);
            if (task == null) {
                Slog.w("ActivityManager", "setTaskResizeable: taskId=" + taskId + " not found");
                return;
            }
            task.setResizeMode(resizeableMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeTask(int taskId, Rect bounds, int resizeMode) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "resizeTask()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                boolean preserveWindow;
                TaskRecord task;
                block13: {
                    task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
                    if (task != null) break block13;
                    Slog.w("ActivityManager", "resizeTask: taskId=" + taskId + " not found");
                    return;
                }
                int stackId = task.getStackId();
                if (!ActivityManager.StackId.isTaskResizeAllowed(stackId)) {
                    throw new IllegalArgumentException("resizeTask not allowed on task=" + task);
                }
                if (bounds == null && stackId == 2) {
                    stackId = 1;
                } else if (bounds != null && stackId != 2) {
                    stackId = 2;
                }
                boolean bl = preserveWindow = (resizeMode & 1) != 0;
                if (stackId != task.getStackId()) {
                    task.reparent(stackId, true, 1, true, true, "resizeTask");
                    preserveWindow = false;
                }
                task.resize(bounds, resizeMode, preserveWindow, false);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rect getTaskBounds(int taskId) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "getTaskBounds()");
        long ident = Binder.clearCallingIdentity();
        Rect rect = new Rect();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                TaskRecord task;
                block13: {
                    task = this.mStackSupervisor.anyTaskForIdLocked(taskId, 1, -1);
                    if (task != null) break block13;
                    Slog.w("ActivityManager", "getTaskBounds: taskId=" + taskId + " not found");
                    Rect rect2 = rect;
                    return rect2;
                }
                if (task.getStack() != null) {
                    task.getWindowContainerBounds(rect);
                } else if (task.mBounds != null) {
                    rect.set(task.mBounds);
                } else if (task.mLastNonFullscreenBounds != null) {
                    rect.set(task.mLastNonFullscreenBounds);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTaskWindowTransition(int taskId) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "cancelTaskWindowTransition()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                TaskRecord task;
                block8: {
                    task = this.mStackSupervisor.anyTaskForIdLocked(taskId, 0, -1);
                    if (task != null) break block8;
                    Slog.w("ActivityManager", "cancelTaskWindowTransition: taskId=" + taskId + " not found");
                    return;
                }
                task.cancelWindowTransition();
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTaskThumbnailTransition(int taskId) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "cancelTaskThumbnailTransition()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                TaskRecord task;
                block8: {
                    task = this.mStackSupervisor.anyTaskForIdLocked(taskId, 0, -1);
                    if (task != null) break block8;
                    Slog.w("ActivityManager", "cancelTaskThumbnailTransition: taskId=" + taskId + " not found");
                    return;
                }
                task.cancelThumbnailTransition();
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ActivityManager.TaskSnapshot getTaskSnapshot(int taskId, boolean reducedResolution) {
        this.enforceCallingPermission("android.permission.READ_FRAME_BUFFER", "getTaskSnapshot()");
        long ident = Binder.clearCallingIdentity();
        try {
            TaskRecord task;
            Object object = this;
            synchronized (object) {
                task = this.mStackSupervisor.anyTaskForIdLocked(taskId, 1, -1);
                if (task == null) {
                    Slog.w("ActivityManager", "getTaskSnapshot: taskId=" + taskId + " not found");
                    ActivityManager.TaskSnapshot taskSnapshot = null;
                    return taskSnapshot;
                }
            }
            object = task.getSnapshot(reducedResolution);
            return object;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public Bitmap getTaskDescriptionIcon(String filePath, int userId) {
        if (userId != UserHandle.getCallingUserId()) {
            this.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "getTaskDescriptionIcon");
        }
        File passedIconFile = new File(filePath);
        File legitIconFile = new File(TaskPersister.getUserImagesDir(userId), passedIconFile.getName());
        if (!legitIconFile.getPath().equals(filePath) || !filePath.contains("_activity_icon_")) {
            throw new IllegalArgumentException("Bad file path: " + filePath + " passed for userId " + userId);
        }
        return this.mRecentTasks.getTaskDescriptionIcon(filePath);
    }

    @Override
    public void startInPlaceAnimationOnFrontMostApplication(Bundle opts) throws RemoteException {
        ActivityOptions activityOptions = ActivityOptions.fromBundle(opts);
        if (activityOptions.getAnimationType() != 10 || activityOptions.getCustomInPlaceResId() == 0) {
            throw new IllegalArgumentException("Expected in-place ActivityOption with valid animation");
        }
        this.mWindowManager.prepareAppTransition(17, false);
        this.mWindowManager.overridePendingAppTransitionInPlace(activityOptions.getPackageName(), activityOptions.getCustomInPlaceResId());
        this.mWindowManager.executeAppTransition();
    }

    private void removeTasksByPackageNameLocked(String packageName, int userId) {
        for (int i = this.mRecentTasks.size() - 1; i >= 0; --i) {
            ComponentName cn;
            TaskRecord tr = (TaskRecord)this.mRecentTasks.get(i);
            if (tr.userId != userId || (cn = tr.intent.getComponent()) == null || !cn.getPackageName().equals(packageName)) continue;
            this.mStackSupervisor.removeTaskByIdLocked(tr.taskId, true, true);
        }
    }

    private void cleanupDisabledPackageTasksLocked(String packageName, Set<String> filterByClasses, int userId) {
        for (int i = this.mRecentTasks.size() - 1; i >= 0; --i) {
            boolean sameComponent;
            TaskRecord tr = (TaskRecord)this.mRecentTasks.get(i);
            if (userId != -1 && tr.userId != userId) continue;
            ComponentName cn = tr.intent.getComponent();
            boolean bl = sameComponent = cn != null && cn.getPackageName().equals(packageName) && (filterByClasses == null || filterByClasses.contains(cn.getClassName()));
            if (!sameComponent) continue;
            this.mStackSupervisor.removeTaskByIdLocked(tr.taskId, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStack(int stackId) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "removeStack()");
        if (ActivityManager.StackId.isHomeOrRecentsStack(stackId)) {
            throw new IllegalArgumentException("Removing home or recents stack is not allowed.");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mStackSupervisor.removeStackLocked(stackId);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveStackToDisplay(int stackId, int displayId) {
        this.enforceCallingPermission("android.permission.INTERNAL_SYSTEM_WINDOW", "moveStackToDisplay()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mStackSupervisor.moveStackToDisplayLocked(stackId, displayId, true);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTask(int taskId) {
        this.enforceCallingPermission("android.permission.REMOVE_TASKS", "removeTask()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean bl;
            long ident = Binder.clearCallingIdentity();
            try {
                bl = this.mStackSupervisor.removeTaskByIdLocked(taskId, true, true);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTaskToFront(int taskId, int flags, Bundle bOptions) {
        this.enforceCallingPermission("android.permission.REORDER_TASKS", "moveTaskToFront()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.moveTaskToFrontLocked(taskId, flags, bOptions, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTaskToFrontLocked(int taskId, int flags, Bundle bOptions, boolean fromRecents) {
        ActivityOptions options = ActivityOptions.fromBundle(bOptions);
        if (!this.checkAppSwitchAllowedLocked(Binder.getCallingPid(), Binder.getCallingUid(), -1, -1, "Task to front")) {
            ActivityOptions.abort(options);
            return;
        }
        long origId = Binder.clearCallingIdentity();
        try {
            TaskRecord task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
            if (task == null) {
                Slog.d("ActivityManager", "Could not find task for id: " + taskId);
                return;
            }
            if (this.mStackSupervisor.isLockTaskModeViolation(task)) {
                this.mStackSupervisor.showLockTaskToast();
                Slog.e("ActivityManager", "moveTaskToFront: Attempt to violate Lock Task Mode");
                return;
            }
            ActivityRecord prev = this.mStackSupervisor.topRunningActivityLocked();
            if (prev != null) {
                task.setTaskToReturnTo(prev);
            }
            this.mStackSupervisor.findTaskToMoveToFrontLocked(task, flags, options, "moveTaskToFront", false);
            ActivityRecord topActivity = task.getTopActivity();
            if (topActivity != null) {
                topActivity.showStartingWindow(null, false, true, fromRecents);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        ActivityOptions.abort(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean moveActivityTaskToBack(IBinder token, boolean nonRoot) {
        this.enforceNotIsolatedCaller("moveActivityTaskToBack");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                int taskId = ActivityRecord.getTaskForActivityLocked(token, !nonRoot);
                TaskRecord task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
                if (task == null) return false;
                boolean bl = ActivityRecord.getStackLocked(token).moveTaskToBackLocked(taskId);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTaskBackwards(int task) {
        this.enforceCallingPermission("android.permission.REORDER_TASKS", "moveTaskBackwards()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!this.checkAppSwitchAllowedLocked(Binder.getCallingPid(), Binder.getCallingUid(), -1, -1, "Task backwards")) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.moveTaskBackwardsLocked(task);
            Binder.restoreCallingIdentity(origId);
        }
    }

    private final void moveTaskBackwardsLocked(int task) {
        Slog.e("ActivityManager", "moveTaskBackwards not yet implemented!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IActivityContainer createVirtualActivityContainer(IBinder parentActivityToken, IActivityContainerCallback callback) throws RemoteException {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "createActivityContainer()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (parentActivityToken == null) {
                throw new IllegalArgumentException("parent token must not be null");
            }
            ActivityRecord r = ActivityRecord.forTokenLocked(parentActivityToken);
            if (r == null) {
                return null;
            }
            if (callback == null) {
                throw new IllegalArgumentException("callback must not be null");
            }
            return this.mStackSupervisor.createVirtualActivityContainer(r, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IActivityContainer createStackOnDisplay(int displayId) throws RemoteException {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "createStackOnDisplay()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int stackId = this.mStackSupervisor.getNextStackId();
            ActivityStack stack = this.mStackSupervisor.createStackOnDisplay(stackId, displayId, true);
            if (stack == null) {
                return null;
            }
            return stack.mActivityContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActivityDisplayId(IBinder activityToken) throws RemoteException {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(activityToken);
            if (stack != null && stack.mActivityContainer.isAttachedLocked()) {
                return stack.mActivityContainer.getDisplayId();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActivityStackId(IBinder token) throws RemoteException {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack == null) {
                return -1;
            }
            return stack.mStackId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitFreeformMode(IBinder token) throws RemoteException {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                ActivityRecord r = ActivityRecord.forTokenLocked(token);
                if (r == null) {
                    throw new IllegalArgumentException("exitFreeformMode: No activity record matching token=" + token);
                }
                Object stack = r.getStack();
                if (stack == null || ((ActivityStack)stack).mStackId != 2) {
                    throw new IllegalStateException("exitFreeformMode: You can only go fullscreen from freeform.");
                }
                r.getTask().reparent(1, true, 1, true, false, "exitFreeformMode");
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTaskToStack(int taskId, int stackId, boolean toTop) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "moveTaskToStack()");
        if (ActivityManager.StackId.isHomeOrRecentsStack(stackId)) {
            throw new IllegalArgumentException("moveTaskToStack: Attempt to move task " + taskId + " to stack " + stackId);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                TaskRecord task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
                if (task == null) {
                    Slog.w("ActivityManager", "moveTaskToStack: No task for id=" + taskId);
                    return;
                }
                if (stackId == 3) {
                    this.mWindowManager.setDockedStackCreateState(0, null);
                }
                task.reparent(stackId, toTop, 1, true, false, "moveTaskToStack");
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapDockedAndFullscreenStack() throws RemoteException {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "swapDockedAndFullscreenStack()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                ArrayList<TaskRecord> tasks;
                Object fullscreenStack = this.mStackSupervisor.getStack(1);
                TaskRecord topTask = fullscreenStack != null ? ((ActivityStack)fullscreenStack).topTask() : null;
                Object dockedStack = this.mStackSupervisor.getStack(3);
                ArrayList<TaskRecord> arrayList = tasks = dockedStack != null ? ((ActivityStack)dockedStack).getAllTasks() : null;
                if (topTask == null || tasks == null || tasks.size() == 0) {
                    Slog.w("ActivityManager", "Unable to swap tasks, either docked or fullscreen stack is empty.");
                    return;
                }
                this.mWindowManager.prepareAppTransition(18, false);
                topTask.reparent(3, true, 1, true, true, "swapDockedAndFullscreenStack - DOCKED_STACK");
                int size = tasks.size();
                for (int i = 0; i < size; ++i) {
                    int id2 = tasks.get((int)i).taskId;
                    if (id2 == topTask.taskId) continue;
                    tasks.get(i).reparent(1, true, 1, true, true, "swapDockedAndFullscreenStack - FULLSCREEN_STACK");
                }
                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                this.mWindowManager.executeAppTransition();
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean moveTaskToDockedStack(int taskId, int createMode, boolean toTop, boolean animate, Rect initialBounds) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "moveTaskToDockedStack()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                TaskRecord task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
                if (task == null) {
                    Slog.w("ActivityManager", "moveTaskToDockedStack: No task for id=" + taskId);
                    boolean bl = false;
                    return bl;
                }
                this.mWindowManager.setDockedStackCreateState(createMode, initialBounds);
                boolean moved = task.reparent(3, toTop, 1, animate, false, "moveTaskToDockedStack");
                if (moved) {
                    this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
                }
                boolean bl = moved;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveTopActivityToPinnedStack(int stackId, Rect bounds) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "moveTopActivityToPinnedStack()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean bl;
            if (!this.mSupportsPictureInPicture) {
                throw new IllegalStateException("moveTopActivityToPinnedStack:Device doesn't support picture-in-picture mode");
            }
            long ident = Binder.clearCallingIdentity();
            try {
                bl = this.mStackSupervisor.moveTopStackActivityToPinnedStackLocked(stackId, bounds);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resizeStack(int stackId, Rect destBounds, boolean allowResizeInDockedMode, boolean preserveWindows, boolean animate, int animationDuration) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "resizeStack()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (animate) {
                    if (stackId != 4) throw new IllegalArgumentException("Stack: " + stackId + " doesn't support animated resize.");
                    PinnedActivityStack pinnedStack = (PinnedActivityStack)this.mStackSupervisor.getStack(4);
                    if (pinnedStack == null) return;
                    pinnedStack.animateResizePinnedStack(null, destBounds, animationDuration, false);
                } else {
                    this.mStackSupervisor.resizeStackLocked(stackId, destBounds, null, null, preserveWindows, allowResizeInDockedMode, false);
                }
                return;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeDockedStack(Rect dockedBounds, Rect tempDockedTaskBounds, Rect tempDockedTaskInsetBounds, Rect tempOtherTaskBounds, Rect tempOtherTaskInsetBounds) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "resizeDockedStack()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.mStackSupervisor.resizeDockedStackLocked(dockedBounds, tempDockedTaskBounds, tempDockedTaskInsetBounds, tempOtherTaskBounds, tempOtherTaskInsetBounds, true);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizePinnedStack(Rect pinnedBounds, Rect tempPinnedTaskBounds) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "resizePinnedStack()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.mStackSupervisor.resizePinnedStackLocked(pinnedBounds, tempPinnedTaskBounds);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void positionTaskInStack(int taskId, int stackId, int position) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "positionTaskInStack()");
        if (ActivityManager.StackId.isHomeOrRecentsStack(stackId)) {
            throw new IllegalArgumentException("positionTaskInStack: Attempt to change the position of task " + taskId + " in/to home/recents stack");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                TaskRecord task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
                if (task == null) {
                    throw new IllegalArgumentException("positionTaskInStack: no task for id=" + taskId);
                }
                Object stack = this.mStackSupervisor.getStack(stackId, true, false);
                if (task.getStack() == stack) {
                    ((ActivityStack)stack).positionChildAt(task, position);
                } else {
                    task.reparent(stackId, position, 2, false, false, "positionTaskInStack");
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.StackInfo> getAllStackInfos() {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "getAllStackInfos()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ArrayList<ActivityManager.StackInfo> arrayList = this.mStackSupervisor.getAllStackInfosLocked();
                return arrayList;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityManager.StackInfo getStackInfo(int stackId) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "getStackInfo()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ActivityManager.StackInfo stackInfo = this.mStackSupervisor.getStackInfoLocked(stackId);
                return stackInfo;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTaskForActivity(IBinder token, boolean onlyRoot) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return ActivityRecord.getTaskForActivityLocked(token, onlyRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeviceOwner(String packageName) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != 1000) {
            throw new SecurityException("updateDeviceOwner called from non-system process");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mDeviceOwnerName = packageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLockTaskPackages(int userId, String[] packages) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != 1000) {
            this.enforceCallingPermission("android.permission.UPDATE_LOCK_TASK_PACKAGES", "updateLockTaskPackages()");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mLockTaskPackages.put(userId, packages);
            this.mStackSupervisor.onLockTaskPackagesUpdatedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startLockTaskModeLocked(TaskRecord task) {
        int callingUid;
        if (task.mLockTaskAuth == 0) {
            return;
        }
        PinnedActivityStack pinnedStack = (PinnedActivityStack)this.mStackSupervisor.getStack(4);
        if (pinnedStack != null) {
            this.mStackSupervisor.removeStackLocked(4);
        }
        boolean isSystemInitiated = (callingUid = Binder.getCallingUid()) == 1000;
        long ident = Binder.clearCallingIdentity();
        try {
            if (!isSystemInitiated) {
                task.mLockTaskUid = callingUid;
                if (task.mLockTaskAuth == 1) {
                    StatusBarManagerInternal statusBarManager = LocalServices.getService(StatusBarManagerInternal.class);
                    if (statusBarManager != null) {
                        statusBarManager.showScreenPinningRequest(task.taskId);
                    }
                    return;
                }
                ActivityStack stack = this.mStackSupervisor.getFocusedStack();
                if (stack == null || task != stack.topTask()) {
                    throw new IllegalArgumentException("Invalid task, not in foreground");
                }
            }
            this.mStackSupervisor.setLockTaskModeLocked(task, isSystemInitiated ? 2 : 1, "startLockTask", true);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLockTaskModeById(int taskId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            TaskRecord task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
            if (task != null) {
                this.startLockTaskModeLocked(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLockTaskModeByToken(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.forTokenLocked(token);
            if (r == null) {
                return;
            }
            TaskRecord task = r.getTask();
            if (task != null) {
                this.startLockTaskModeLocked(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startSystemLockTaskMode(int taskId) throws RemoteException {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "startSystemLockTaskMode");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.startLockTaskModeById(taskId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopLockTaskMode() {
        TaskRecord lockTask = this.mStackSupervisor.getLockedTaskLocked();
        if (lockTask == null) {
            return;
        }
        int callingUid = Binder.getCallingUid();
        int lockTaskUid = lockTask.mLockTaskUid;
        int lockTaskModeState = this.mStackSupervisor.getLockTaskModeState();
        if (lockTaskModeState == 0) {
            return;
        }
        if (this.checkCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS") != 0 && callingUid != lockTaskUid && (lockTaskUid != 0 || callingUid != lockTask.effectiveUid)) {
            throw new SecurityException("Invalid uid, expected " + lockTaskUid + " callingUid=" + callingUid + " effectiveUid=" + lockTask.effectiveUid);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Log.d("ActivityManager", "stopLockTaskMode");
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.mStackSupervisor.setLockTaskModeLocked(null, 0, "stopLockTask", true);
            }
            TelecomManager tm = (TelecomManager)this.mContext.getSystemService("telecom");
            if (tm != null) {
                tm.showInCallScreen(false);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public void stopSystemLockTaskMode() throws RemoteException {
        if (this.mStackSupervisor.getLockTaskModeState() == 2) {
            this.stopLockTaskMode();
        } else {
            this.mStackSupervisor.showLockTaskToast();
        }
    }

    @Override
    public boolean isInLockTaskMode() {
        return this.getLockTaskModeState() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLockTaskModeState() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mStackSupervisor.getLockTaskModeState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showLockTaskEscapeMessage(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.forTokenLocked(token);
            if (r == null) {
                return;
            }
            this.mStackSupervisor.showLockTaskEscapeMessageLocked(r.getTask());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisablePreviewScreenshots(IBinder token, boolean disable) throws RemoteException {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                Slog.w("ActivityManager", "setDisablePreviewScreenshots: Unable to find activity for token=" + token);
                return;
            }
            long origId = Binder.clearCallingIdentity();
            try {
                r.setDisablePreviewScreenshots(disable);
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    private final List<ProviderInfo> generateApplicationProvidersLocked(ProcessRecord app) {
        List providers = null;
        try {
            providers = AppGlobals.getPackageManager().queryContentProviders(app.processName, app.uid, 0x10000C00, null).getList();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        int userId = app.userId;
        if (providers != null) {
            int N = providers.size();
            app.pubProviders.ensureCapacity(N + app.pubProviders.size());
            for (int i = 0; i < N; ++i) {
                ProviderInfo cpi = (ProviderInfo)providers.get(i);
                boolean singleton = this.isSingleton(cpi.processName, cpi.applicationInfo, cpi.name, cpi.flags);
                if (singleton && UserHandle.getUserId(app.uid) != 0) {
                    providers.remove(i);
                    --N;
                    --i;
                    continue;
                }
                ComponentName comp = new ComponentName(cpi.packageName, cpi.name);
                ContentProviderRecord cpr = this.mProviderMap.getProviderByClass(comp, userId);
                if (cpr == null) {
                    cpr = new ContentProviderRecord(this, cpi, app.info, comp, singleton);
                    this.mProviderMap.putProviderByClass(comp, cpr);
                }
                app.pubProviders.put(cpi.name, cpr);
                if (!cpi.multiprocess || !"android".equals(cpi.packageName)) {
                    app.addPackage(cpi.applicationInfo.packageName, cpi.applicationInfo.versionCode, this.mProcessStats);
                }
                this.notifyPackageUse(cpi.applicationInfo.packageName, 4);
            }
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkContentProviderAccess(String authority, int userId) {
        if (userId == -1) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "ActivityManager");
            userId = UserHandle.getCallingUserId();
        }
        ProviderInfo cpi = null;
        try {
            cpi = AppGlobals.getPackageManager().resolveContentProvider(authority, 790016, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (cpi == null) {
            return "Failed to find provider " + authority + " for user " + userId + "; expected to find a valid ContentProvider for this authority";
        }
        ProcessRecord r = null;
        Object object = this.mPidsSelfLocked;
        synchronized (object) {
            r = this.mPidsSelfLocked.get(Binder.getCallingPid());
        }
        if (r == null) {
            return "Failed to find PID " + Binder.getCallingPid();
        }
        object = this;
        synchronized (object) {
            return this.checkContentProviderPermissionLocked(cpi, r, userId, true);
        }
    }

    private final String checkContentProviderPermissionLocked(ProviderInfo cpi, ProcessRecord r, int userId, boolean checkUser) {
        int callingPid = r != null ? r.pid : Binder.getCallingPid();
        int callingUid = r != null ? r.uid : Binder.getCallingUid();
        boolean checkedGrants = false;
        if (checkUser) {
            int tmpTargetUserId = this.mUserController.unsafeConvertIncomingUserLocked(userId);
            if (tmpTargetUserId != UserHandle.getUserId(callingUid)) {
                if (this.checkAuthorityGrants(callingUid, cpi, tmpTargetUserId, checkUser)) {
                    return null;
                }
                checkedGrants = true;
            }
            if ((userId = this.mUserController.handleIncomingUser(callingPid, callingUid, userId, false, 0, "checkContentProviderPermissionLocked " + cpi.authority, null)) != tmpTargetUserId) {
                checkedGrants = false;
            }
        }
        if (this.checkComponentPermission(cpi.readPermission, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
            return null;
        }
        if (this.checkComponentPermission(cpi.writePermission, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
            return null;
        }
        PathPermission[] pps = cpi.pathPermissions;
        if (pps != null) {
            int i = pps.length;
            while (i > 0) {
                PathPermission pp;
                String pprperm;
                if ((pprperm = (pp = pps[--i]).getReadPermission()) != null && this.checkComponentPermission(pprperm, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
                    return null;
                }
                String ppwperm = pp.getWritePermission();
                if (ppwperm == null || this.checkComponentPermission(ppwperm, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) != 0) continue;
                return null;
            }
        }
        if (!checkedGrants && this.checkAuthorityGrants(callingUid, cpi, userId, checkUser)) {
            return null;
        }
        String suffix = !cpi.exported ? " that is not exported from UID " + cpi.applicationInfo.uid : ("android.permission.MANAGE_DOCUMENTS".equals(cpi.readPermission) ? " requires that you obtain access using ACTION_OPEN_DOCUMENT or related APIs" : " requires " + cpi.readPermission + " or " + cpi.writePermission);
        String msg = "Permission Denial: opening provider " + cpi.name + " from " + (r != null ? r : "(null)") + " (pid=" + callingPid + ", uid=" + callingUid + ")" + suffix;
        Slog.w("ActivityManager", msg);
        return msg;
    }

    boolean checkAuthorityGrants(int callingUid, ProviderInfo cpi, int userId, boolean checkUser) {
        ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(callingUid);
        if (perms != null) {
            for (int i = perms.size() - 1; i >= 0; --i) {
                GrantUri grantUri = perms.keyAt(i);
                if (grantUri.sourceUserId != userId && checkUser || !this.matchesProvider(grantUri.uri, cpi)) continue;
                return true;
            }
        }
        return false;
    }

    boolean matchesProvider(Uri uri, ProviderInfo cpi) {
        String uriAuth = uri.getAuthority();
        String cpiAuth = cpi.authority;
        if (cpiAuth.indexOf(59) == -1) {
            return cpiAuth.equals(uriAuth);
        }
        String[] cpiAuths = cpiAuth.split(";");
        int length = cpiAuths.length;
        for (int i = 0; i < length; ++i) {
            if (!cpiAuths[i].equals(uriAuth)) continue;
            return true;
        }
        return false;
    }

    ContentProviderConnection incProviderCountLocked(ProcessRecord r, ContentProviderRecord cpr, IBinder externalProcessToken, boolean stable) {
        if (r != null) {
            for (int i = 0; i < r.conProviders.size(); ++i) {
                ContentProviderConnection conn = r.conProviders.get(i);
                if (conn.provider != cpr) continue;
                if (stable) {
                    ++conn.stableCount;
                    ++conn.numStableIncs;
                } else {
                    ++conn.unstableCount;
                    ++conn.numUnstableIncs;
                }
                return conn;
            }
            ContentProviderConnection conn = new ContentProviderConnection(cpr, r);
            if (stable) {
                conn.stableCount = 1;
                conn.numStableIncs = 1;
            } else {
                conn.unstableCount = 1;
                conn.numUnstableIncs = 1;
            }
            cpr.connections.add(conn);
            r.conProviders.add(conn);
            this.startAssociationLocked(r.uid, r.processName, r.curProcState, cpr.uid, cpr.name, cpr.info.processName);
            return conn;
        }
        cpr.addExternalProcessHandleLocked(externalProcessToken);
        return null;
    }

    boolean decProviderCountLocked(ContentProviderConnection conn, ContentProviderRecord cpr, IBinder externalProcessToken, boolean stable) {
        if (conn != null) {
            cpr = conn.provider;
            if (stable) {
                --conn.stableCount;
            } else {
                --conn.unstableCount;
            }
            if (conn.stableCount == 0 && conn.unstableCount == 0) {
                cpr.connections.remove(conn);
                conn.client.conProviders.remove(conn);
                if (conn.client.setProcState < 14 && cpr.proc != null) {
                    cpr.proc.lastProviderTime = SystemClock.uptimeMillis();
                }
                this.stopAssociationLocked(conn.client.uid, conn.client.processName, cpr.uid, cpr.name);
                return true;
            }
            return false;
        }
        cpr.removeExternalProcessHandleLocked(externalProcessToken);
        return false;
    }

    private void checkTime(long startTime, String where) {
        long now = SystemClock.uptimeMillis();
        if (now - startTime > 50L) {
            Slog.w("ActivityManager", "Slow operation: " + (now - startTime) + "ms so far, now at " + where);
        }
    }

    boolean isProcessAliveLocked(ProcessRecord proc) {
        if (proc.procStatFile == null) {
            proc.procStatFile = "/proc/" + proc.pid + "/stat";
        }
        this.mProcessStateStatsLongs[0] = 0L;
        if (!android.os.Process.readProcFile(proc.procStatFile, PROCESS_STATE_STATS_FORMAT, null, this.mProcessStateStatsLongs, null)) {
            return false;
        }
        long state = this.mProcessStateStatsLongs[0];
        return state != 90L && state != 88L && state != 120L && state != 75L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ContentProviderHolder getContentProviderImpl(IApplicationThread caller, String name, IBinder token, boolean stable, int userId) {
        ContentProviderRecord cpr;
        ContentProviderConnection conn = null;
        ProviderInfo cpi = null;
        Object object = this;
        synchronized (object) {
            boolean providerRunning;
            long startTime = SystemClock.uptimeMillis();
            ProcessRecord r = null;
            if (caller != null && (r = this.getRecordForAppLocked(caller)) == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when getting content provider " + name);
            }
            boolean checkCrossUser = true;
            this.checkTime(startTime, "getContentProviderImpl: getProviderByName");
            cpr = this.mProviderMap.getProviderByName(name, userId);
            if (cpr == null && userId != 0 && (cpr = this.mProviderMap.getProviderByName(name, 0)) != null) {
                cpi = cpr.info;
                if (this.isSingleton(cpi.processName, cpi.applicationInfo, cpi.name, cpi.flags) && this.isValidSingletonCall(r.uid, cpi.applicationInfo.uid)) {
                    userId = 0;
                    checkCrossUser = false;
                } else {
                    cpr = null;
                    cpi = null;
                }
            }
            boolean bl = providerRunning = cpr != null && cpr.proc != null && !cpr.proc.killed;
            if (providerRunning) {
                cpi = cpr.info;
                this.checkTime(startTime, "getContentProviderImpl: before checkContentProviderPermission");
                String msg = this.checkContentProviderPermissionLocked(cpi, r, userId, checkCrossUser);
                if (msg != null) {
                    throw new SecurityException(msg);
                }
                this.checkTime(startTime, "getContentProviderImpl: after checkContentProviderPermission");
                if (r != null && cpr.canRunHere(r)) {
                    ContentProviderHolder holder = cpr.newHolder(null);
                    holder.provider = null;
                    return holder;
                }
                try {
                    if (AppGlobals.getPackageManager().resolveContentProvider(name, 0, userId) == null) {
                        return null;
                    }
                }
                catch (RemoteException holder) {
                    // empty catch block
                }
                long origId = Binder.clearCallingIdentity();
                this.checkTime(startTime, "getContentProviderImpl: incProviderCountLocked");
                conn = this.incProviderCountLocked(r, cpr, token, stable);
                if (conn != null && conn.stableCount + conn.unstableCount == 1 && cpr.proc != null && r.setAdj <= 200) {
                    this.checkTime(startTime, "getContentProviderImpl: before updateLruProcess");
                    this.updateLruProcessLocked(cpr.proc, false, null);
                    this.checkTime(startTime, "getContentProviderImpl: after updateLruProcess");
                }
                this.checkTime(startTime, "getContentProviderImpl: before updateOomAdj");
                int verifiedAdj = cpr.proc.verifiedAdj;
                boolean success = this.updateOomAdjLocked(cpr.proc, true);
                if (success && verifiedAdj != cpr.proc.setAdj && !this.isProcessAliveLocked(cpr.proc)) {
                    success = false;
                }
                this.maybeUpdateProviderUsageStatsLocked(r, cpr.info.packageName, name);
                this.checkTime(startTime, "getContentProviderImpl: after updateOomAdj");
                if (!success) {
                    Slog.i("ActivityManager", "Existing provider " + cpr.name.flattenToShortString() + " is crashing; detaching " + r);
                    boolean lastRef = this.decProviderCountLocked(conn, cpr, token, stable);
                    this.checkTime(startTime, "getContentProviderImpl: before appDied");
                    this.appDiedLocked(cpr.proc);
                    this.checkTime(startTime, "getContentProviderImpl: after appDied");
                    if (!lastRef) {
                        return null;
                    }
                    providerRunning = false;
                    conn = null;
                } else {
                    cpr.proc.verifiedAdj = cpr.proc.setAdj;
                }
                Binder.restoreCallingIdentity(origId);
            }
            if (!providerRunning) {
                int i;
                boolean firstClass;
                boolean singleton;
                try {
                    this.checkTime(startTime, "getContentProviderImpl: before resolveContentProvider");
                    cpi = AppGlobals.getPackageManager().resolveContentProvider(name, 3072, userId);
                    this.checkTime(startTime, "getContentProviderImpl: after resolveContentProvider");
                }
                catch (RemoteException msg) {
                    // empty catch block
                }
                if (cpi == null) {
                    return null;
                }
                boolean bl2 = singleton = this.isSingleton(cpi.processName, cpi.applicationInfo, cpi.name, cpi.flags) && this.isValidSingletonCall(r.uid, cpi.applicationInfo.uid);
                if (singleton) {
                    userId = 0;
                }
                cpi.applicationInfo = this.getAppInfoForUser(cpi.applicationInfo, userId);
                this.checkTime(startTime, "getContentProviderImpl: got app info for user");
                this.checkTime(startTime, "getContentProviderImpl: before checkContentProviderPermission");
                String msg = this.checkContentProviderPermissionLocked(cpi, r, userId, !singleton);
                if (msg != null) {
                    throw new SecurityException(msg);
                }
                this.checkTime(startTime, "getContentProviderImpl: after checkContentProviderPermission");
                if (!this.mProcessesReady && !cpi.processName.equals("system")) {
                    throw new IllegalArgumentException("Attempt to launch content provider before system ready");
                }
                if (!this.mUserController.isUserRunningLocked(userId, 0)) {
                    Slog.w("ActivityManager", "Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": user " + userId + " is stopped");
                    return null;
                }
                ComponentName comp = new ComponentName(cpi.packageName, cpi.name);
                this.checkTime(startTime, "getContentProviderImpl: before getProviderByClass");
                cpr = this.mProviderMap.getProviderByClass(comp, userId);
                this.checkTime(startTime, "getContentProviderImpl: after getProviderByClass");
                boolean bl3 = firstClass = cpr == null;
                if (firstClass) {
                    long ident = Binder.clearCallingIdentity();
                    if (this.mPermissionReviewRequired && !this.requestTargetProviderPermissionsReviewIfNeededLocked(cpi, r, userId)) {
                        return null;
                    }
                    try {
                        this.checkTime(startTime, "getContentProviderImpl: before getApplicationInfo");
                        ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(cpi.applicationInfo.packageName, 1024, userId);
                        this.checkTime(startTime, "getContentProviderImpl: after getApplicationInfo");
                        if (ai == null) {
                            Slog.w("ActivityManager", "No package info for content provider " + cpi.name);
                            ContentProviderHolder contentProviderHolder = null;
                            return contentProviderHolder;
                        }
                        ai = this.getAppInfoForUser(ai, userId);
                        cpr = new ContentProviderRecord(this, cpi, ai, comp, singleton);
                    }
                    catch (RemoteException remoteException) {
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                this.checkTime(startTime, "getContentProviderImpl: now have ContentProviderRecord");
                if (r != null && cpr.canRunHere(r)) {
                    return cpr.newHolder(null);
                }
                int N = this.mLaunchingProviders.size();
                for (i = 0; i < N && this.mLaunchingProviders.get(i) != cpr; ++i) {
                }
                if (i >= N) {
                    long origId = Binder.clearCallingIdentity();
                    try {
                        try {
                            this.checkTime(startTime, "getContentProviderImpl: before set stopped state");
                            AppGlobals.getPackageManager().setPackageStoppedState(cpr.appInfo.packageName, false, userId);
                            this.checkTime(startTime, "getContentProviderImpl: after set stopped state");
                        }
                        catch (RemoteException remoteException) {
                        }
                        catch (IllegalArgumentException e) {
                            Slog.w("ActivityManager", "Failed trying to unstop package " + cpr.appInfo.packageName + ": " + e);
                        }
                        this.checkTime(startTime, "getContentProviderImpl: looking for process record");
                        ProcessRecord proc = this.getProcessRecordLocked(cpi.processName, cpr.appInfo.uid, false);
                        if (proc != null && proc.thread != null && !proc.killed) {
                            if (!proc.pubProviders.containsKey(cpi.name)) {
                                this.checkTime(startTime, "getContentProviderImpl: scheduling install");
                                proc.pubProviders.put(cpi.name, cpr);
                                try {
                                    proc.thread.scheduleInstallProvider(cpi);
                                }
                                catch (RemoteException remoteException) {}
                            }
                        } else {
                            this.checkTime(startTime, "getContentProviderImpl: before start process");
                            proc = this.startProcessLocked(cpi.processName, cpr.appInfo, false, 0, "content provider", new ComponentName(cpi.applicationInfo.packageName, cpi.name), false, false, false);
                            this.checkTime(startTime, "getContentProviderImpl: after start process");
                            if (proc == null) {
                                Slog.w("ActivityManager", "Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": process is bad");
                                ContentProviderHolder contentProviderHolder = null;
                                return contentProviderHolder;
                            }
                        }
                        cpr.launchingApp = proc;
                        this.mLaunchingProviders.add(cpr);
                    }
                    finally {
                        Binder.restoreCallingIdentity(origId);
                    }
                }
                this.checkTime(startTime, "getContentProviderImpl: updating data structures");
                if (firstClass) {
                    this.mProviderMap.putProviderByClass(comp, cpr);
                }
                this.mProviderMap.putProviderByName(name, cpr);
                conn = this.incProviderCountLocked(r, cpr, token, stable);
                if (conn != null) {
                    conn.waiting = true;
                }
            }
            this.checkTime(startTime, "getContentProviderImpl: done!");
            this.grantEphemeralAccessLocked(userId, null, cpi.applicationInfo.uid, UserHandle.getAppId(Binder.getCallingUid()));
        }
        object = cpr;
        synchronized (object) {
            while (cpr.provider == null) {
                if (cpr.launchingApp == null) {
                    Slog.w("ActivityManager", "Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": launching app became null");
                    EventLog.writeEvent(30036, UserHandle.getUserId(cpi.applicationInfo.uid), cpi.applicationInfo.packageName, cpi.applicationInfo.uid, name);
                    return null;
                }
                try {
                    if (conn != null) {
                        conn.waiting = true;
                    }
                    cpr.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
                finally {
                    if (conn == null) continue;
                    conn.waiting = false;
                }
            }
        }
        if (cpr == null) return null;
        ContentProviderHolder contentProviderHolder = cpr.newHolder(conn);
        return contentProviderHolder;
    }

    private boolean requestTargetProviderPermissionsReviewIfNeededLocked(ProviderInfo cpi, ProcessRecord r, int userId) {
        if (this.getPackageManagerInternalLocked().isPermissionsReviewRequired(cpi.packageName, userId)) {
            boolean callerForeground;
            boolean bl = callerForeground = r == null || r.setSchedGroup != 0;
            if (!callerForeground) {
                Slog.w("ActivityManager", "u" + userId + " Instantiating a provider in package" + cpi.packageName + " requires a permissions review");
                return false;
            }
            final Intent intent = new Intent("android.intent.action.REVIEW_PERMISSIONS");
            intent.addFlags(0x10800000);
            intent.putExtra("android.intent.extra.PACKAGE_NAME", cpi.packageName);
            final UserHandle userHandle = new UserHandle(userId);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ActivityManagerService.this.mContext.startActivityAsUser(intent, userHandle);
                }
            });
            return false;
        }
        return true;
    }

    PackageManagerInternal getPackageManagerInternalLocked() {
        if (this.mPackageManagerInt == null) {
            this.mPackageManagerInt = LocalServices.getService(PackageManagerInternal.class);
        }
        return this.mPackageManagerInt;
    }

    @Override
    public final ContentProviderHolder getContentProvider(IApplicationThread caller, String name, int userId, boolean stable) {
        this.enforceNotIsolatedCaller("getContentProvider");
        if (caller == null) {
            String msg = "null IApplicationThread when getting content provider " + name;
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        return this.getContentProviderImpl(caller, name, null, stable, userId);
    }

    @Override
    public ContentProviderHolder getContentProviderExternal(String name, int userId, IBinder token) {
        this.enforceCallingPermission("android.permission.ACCESS_CONTENT_PROVIDERS_EXTERNALLY", "Do not have permission in call getContentProviderExternal()");
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "getContentProvider", null);
        return this.getContentProviderExternalUnchecked(name, token, userId);
    }

    private ContentProviderHolder getContentProviderExternalUnchecked(String name, IBinder token, int userId) {
        return this.getContentProviderImpl(null, name, token, true, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContentProvider(IBinder connection, boolean stable) {
        this.enforceNotIsolatedCaller("removeContentProvider");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ContentProviderConnection conn;
                try {
                    conn = (ContentProviderConnection)connection;
                }
                catch (ClassCastException e) {
                    String msg = "removeContentProvider: " + connection + " not a ContentProviderConnection";
                    Slog.w("ActivityManager", msg);
                    throw new IllegalArgumentException(msg);
                }
                if (conn == null) {
                    throw new NullPointerException("connection is null");
                }
                if (this.decProviderCountLocked(conn, null, null, stable)) {
                    this.updateOomAdjLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContentProviderExternal(String name, IBinder token) {
        this.enforceCallingPermission("android.permission.ACCESS_CONTENT_PROVIDERS_EXTERNALLY", "Do not have permission in call removeContentProviderExternal()");
        int userId = UserHandle.getCallingUserId();
        long ident = Binder.clearCallingIdentity();
        try {
            this.removeContentProviderExternalUnchecked(name, token, userId);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContentProviderExternalUnchecked(String name, IBinder token, int userId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ContentProviderRecord cpr = this.mProviderMap.getProviderByName(name, userId);
            if (cpr == null) {
                return;
            }
            ComponentName comp = new ComponentName(cpr.info.packageName, cpr.info.name);
            ContentProviderRecord localCpr = this.mProviderMap.getProviderByClass(comp, userId);
            if (localCpr.hasExternalProcessHandles()) {
                if (localCpr.removeExternalProcessHandleLocked(token)) {
                    this.updateOomAdjLocked();
                } else {
                    Slog.e("ActivityManager", "Attmpt to remove content provider " + localCpr + " with no external reference for token: " + token + ".");
                }
            } else {
                Slog.e("ActivityManager", "Attmpt to remove content provider: " + localCpr + " with no external references.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void publishContentProviders(IApplicationThread caller, List<ContentProviderHolder> providers) {
        if (providers == null) {
            return;
        }
        this.enforceNotIsolatedCaller("publishContentProviders");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when publishing content providers");
            }
            long origId = Binder.clearCallingIdentity();
            int N = providers.size();
            for (int i = 0; i < N; ++i) {
                ContentProviderRecord dst;
                ContentProviderHolder src = providers.get(i);
                if (src == null || src.info == null || src.provider == null || (dst = r.pubProviders.get(src.info.name)) == null) continue;
                ComponentName comp = new ComponentName(dst.info.packageName, dst.info.name);
                this.mProviderMap.putProviderByClass(comp, dst);
                String[] names = dst.info.authority.split(";");
                for (int j = 0; j < names.length; ++j) {
                    this.mProviderMap.putProviderByName(names[j], dst);
                }
                int launchingCount = this.mLaunchingProviders.size();
                boolean wasInLaunchingProviders = false;
                for (int j = 0; j < launchingCount; ++j) {
                    if (this.mLaunchingProviders.get(j) != dst) continue;
                    this.mLaunchingProviders.remove(j);
                    wasInLaunchingProviders = true;
                    --j;
                    --launchingCount;
                }
                if (wasInLaunchingProviders) {
                    this.mHandler.removeMessages(57, r);
                }
                ContentProviderRecord contentProviderRecord = dst;
                synchronized (contentProviderRecord) {
                    dst.provider = src.provider;
                    dst.proc = r;
                    dst.notifyAll();
                }
                this.updateOomAdjLocked(r, true);
                this.maybeUpdateProviderUsageStatsLocked(r, src.info.packageName, src.info.authority);
            }
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refContentProvider(IBinder connection, int stable, int unstable) {
        ContentProviderConnection conn;
        try {
            conn = (ContentProviderConnection)connection;
        }
        catch (ClassCastException e) {
            String msg = "refContentProvider: " + connection + " not a ContentProviderConnection";
            Slog.w("ActivityManager", msg);
            throw new IllegalArgumentException(msg);
        }
        if (conn == null) {
            throw new NullPointerException("connection is null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (stable > 0) {
                conn.numStableIncs += stable;
            }
            if ((stable = conn.stableCount + stable) < 0) {
                throw new IllegalStateException("stableCount < 0: " + stable);
            }
            if (unstable > 0) {
                conn.numUnstableIncs += unstable;
            }
            if ((unstable = conn.unstableCount + unstable) < 0) {
                throw new IllegalStateException("unstableCount < 0: " + unstable);
            }
            if (stable + unstable <= 0) {
                throw new IllegalStateException("ref counts can't go to zero here: stable=" + stable + " unstable=" + unstable);
            }
            conn.stableCount = stable;
            conn.unstableCount = unstable;
            return !conn.dead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unstableProviderDied(IBinder connection) {
        IContentProvider provider;
        ContentProviderConnection conn;
        try {
            conn = (ContentProviderConnection)connection;
        }
        catch (ClassCastException e) {
            String msg = "refContentProvider: " + connection + " not a ContentProviderConnection";
            Slog.w("ActivityManager", msg);
            throw new IllegalArgumentException(msg);
        }
        if (conn == null) {
            throw new NullPointerException("connection is null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            provider = conn.provider.provider;
        }
        if (provider == null) {
            return;
        }
        if (provider.asBinder().pingBinder()) {
            activityManagerService = this;
            synchronized (activityManagerService) {
                Slog.w("ActivityManager", "unstableProviderDied: caller " + Binder.getCallingUid() + " says " + conn + " died, but we don't agree");
                return;
            }
        }
        activityManagerService = this;
        synchronized (activityManagerService) {
            if (conn.provider.provider != provider) {
                return;
            }
            ProcessRecord proc = conn.provider.proc;
            if (proc == null || proc.thread == null) {
                return;
            }
            Slog.i("ActivityManager", "Process " + proc.processName + " (pid " + proc.pid + ") early provider death");
            long ident = Binder.clearCallingIdentity();
            try {
                this.appDiedLocked(proc);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    @Override
    public void appNotRespondingViaProvider(IBinder connection) {
        this.enforceCallingPermission("android.permission.REMOVE_TASKS", "appNotRespondingViaProvider()");
        ContentProviderConnection conn = (ContentProviderConnection)connection;
        if (conn == null) {
            Slog.w("ActivityManager", "ContentProviderConnection is null");
            return;
        }
        final ProcessRecord host = conn.provider.proc;
        if (host == null) {
            Slog.w("ActivityManager", "Failed to find hosting ProcessRecord");
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityManagerService.this.mAppErrors.appNotResponding(host, null, null, false, "ContentProvider not responding");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void installSystemProviders() {
        List<ProviderInfo> providers;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app = this.mProcessNames.get("system", 1000);
            providers = this.generateApplicationProvidersLocked(app);
            if (providers != null) {
                for (int i = providers.size() - 1; i >= 0; --i) {
                    ProviderInfo pi = providers.get(i);
                    if ((pi.applicationInfo.flags & 1) != 0) continue;
                    Slog.w("ActivityManager", "Not installing system proc provider " + pi.name + ": not system .apk");
                    providers.remove(i);
                }
            }
        }
        if (providers != null) {
            this.mSystemThread.installSystemProviders(providers);
        }
        this.mConstants.start(this.mContext.getContentResolver());
        this.mCoreSettingsObserver = new CoreSettingsObserver(this);
        this.mFontScaleSettingObserver = new FontScaleSettingObserver();
        RescueParty.onSettingsProviderPublished(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPersistentApps(int matchFlags) {
        if (this.mFactoryTest == 1) {
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                List apps = AppGlobals.getPackageManager().getPersistentApplications(0x400 | matchFlags).getList();
                for (ApplicationInfo app : apps) {
                    if ("android".equals(app.packageName)) continue;
                    this.addAppLocked(app, null, false, null);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installEncryptionUnawareProviders(int userId) {
        int matchFlags = 262152;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int NP = this.mProcessNames.getMap().size();
            for (int ip = 0; ip < NP; ++ip) {
                SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
                int NA = apps.size();
                for (int ia = 0; ia < NA; ++ia) {
                    ProcessRecord app = apps.valueAt(ia);
                    if (app.userId != userId || app.thread == null || app.unlocked) continue;
                    int NG = app.pkgList.size();
                    for (int ig = 0; ig < NG; ++ig) {
                        try {
                            String pkgName = app.pkgList.keyAt(ig);
                            PackageInfo pkgInfo = AppGlobals.getPackageManager().getPackageInfo(pkgName, 262152, userId);
                            if (pkgInfo == null || ArrayUtils.isEmpty(pkgInfo.providers)) continue;
                            for (ProviderInfo pi : pkgInfo.providers) {
                                boolean userMatch;
                                boolean processMatch;
                                boolean bl = processMatch = Objects.equals(pi.processName, app.processName) || pi.multiprocess;
                                boolean bl2 = this.isSingleton(pi.processName, pi.applicationInfo, pi.name, pi.flags) ? app.userId == 0 : (userMatch = true);
                                if (processMatch && userMatch) {
                                    Log.v("ActivityManager", "Installing " + pi);
                                    app.thread.scheduleInstallProvider(pi);
                                    continue;
                                }
                                Log.v("ActivityManager", "Skipping " + pi);
                            }
                            continue;
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProviderMimeType(Uri uri, int userId) {
        this.enforceNotIsolatedCaller("getProviderMimeType");
        String name = uri.getAuthority();
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        long ident = 0L;
        boolean clearedIdentity = false;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            userId = this.mUserController.unsafeConvertIncomingUserLocked(userId);
        }
        if (this.canClearIdentity(callingPid, callingUid, userId)) {
            clearedIdentity = true;
            ident = Binder.clearCallingIdentity();
        }
        ContentProviderHolder holder = null;
        try {
            holder = this.getContentProviderExternalUnchecked(name, null, userId);
            if (holder != null) {
                String string2 = holder.provider.getType(uri);
                return string2;
            }
        }
        catch (RemoteException e) {
            Log.w("ActivityManager", "Content provider dead retrieving " + uri, e);
            String string3 = null;
            return string3;
        }
        catch (Exception e) {
            Log.w("ActivityManager", "Exception while determining type of " + uri, e);
            String string4 = null;
            return string4;
        }
        finally {
            if (!clearedIdentity) {
                ident = Binder.clearCallingIdentity();
            }
            try {
                if (holder != null) {
                    this.removeContentProviderExternalUnchecked(name, null, userId);
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        return null;
    }

    private boolean canClearIdentity(int callingPid, int callingUid, int userId) {
        if (UserHandle.getUserId(callingUid) == userId) {
            return true;
        }
        return this.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS", callingPid, callingUid, -1, true) == 0 || this.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingPid, callingUid, -1, true) == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    final ProcessRecord newProcessRecordLocked(ApplicationInfo info, String customProcess, boolean isolated, int isolatedUid) {
        String proc = customProcess != null ? customProcess : info.processName;
        BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
        int userId = UserHandle.getUserId(info.uid);
        int uid = info.uid;
        if (isolated) {
            block6: {
                if (isolatedUid != 0) {
                    uid = isolatedUid;
                } else {
                    int stepsLeft = 1000;
                    do {
                        if (this.mNextIsolatedProcessUid < 99000 || this.mNextIsolatedProcessUid > 99999) {
                            this.mNextIsolatedProcessUid = 99000;
                        }
                        uid = UserHandle.getUid(userId, this.mNextIsolatedProcessUid);
                        ++this.mNextIsolatedProcessUid;
                        if (this.mIsolatedProcesses.indexOfKey(uid) < 0) break block6;
                    } while (--stepsLeft > 0);
                    return null;
                }
            }
            this.getPackageManagerInternalLocked().addIsolatedUid(uid, info.uid);
            this.mBatteryStatsService.addIsolatedUid(uid, info.uid);
        }
        ProcessRecord r = new ProcessRecord(stats, info, proc, uid);
        if (!this.mBooted && !this.mBooting && userId == 0 && (info.flags & 9) == 9) {
            r.persistent = true;
            r.maxAdj = -800;
        }
        this.addProcessNameLocked(r);
        return r;
    }

    private boolean uidOnBackgroundWhitelist(int uid) {
        int appId = UserHandle.getAppId(uid);
        int[] whitelist = this.mBackgroundAppIdWhitelist;
        int N = whitelist.length;
        for (int i = 0; i < N; ++i) {
            if (appId != whitelist[i]) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backgroundWhitelistUid(int uid) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the OS may call backgroundWhitelistUid()");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int N = this.mBackgroundAppIdWhitelist.length;
            int[] newList = new int[N + 1];
            System.arraycopy((int[])this.mBackgroundAppIdWhitelist, (int)0, (int[])newList, (int)0, (int)N);
            newList[N] = UserHandle.getAppId(uid);
            this.mBackgroundAppIdWhitelist = newList;
        }
    }

    final ProcessRecord addAppLocked(ApplicationInfo info, String customProcess, boolean isolated, String abiOverride) {
        ProcessRecord app = !isolated ? this.getProcessRecordLocked(customProcess != null ? customProcess : info.processName, info.uid, true) : null;
        if (app == null) {
            app = this.newProcessRecordLocked(info, customProcess, isolated, 0);
            this.updateLruProcessLocked(app, false, null);
            this.updateOomAdjLocked();
        }
        try {
            AppGlobals.getPackageManager().setPackageStoppedState(info.packageName, false, UserHandle.getUserId(app.uid));
        }
        catch (RemoteException remoteException) {
        }
        catch (IllegalArgumentException e) {
            Slog.w("ActivityManager", "Failed trying to unstop package " + info.packageName + ": " + e);
        }
        if ((info.flags & 9) == 9) {
            app.persistent = true;
            app.maxAdj = -800;
        }
        if (app.thread == null && this.mPersistentStartingProcesses.indexOf(app) < 0) {
            this.mPersistentStartingProcesses.add(app);
            this.startProcessLocked(app, "added application", customProcess != null ? customProcess : app.processName, abiOverride, null, null);
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unhandledBack() {
        this.enforceCallingPermission("android.permission.FORCE_BACK", "unhandledBack()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                this.getFocusedStack().unhandledBackLocked();
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor openContentUri(String uriString) throws RemoteException {
        this.enforceNotIsolatedCaller("openContentUri");
        int userId = UserHandle.getCallingUserId();
        Uri uri = Uri.parse(uriString);
        String name = uri.getAuthority();
        ContentProviderHolder cph = this.getContentProviderExternalUnchecked(name, null, userId);
        ParcelFileDescriptor pfd = null;
        if (cph != null) {
            Binder token = new Binder();
            sCallerIdentity.set(new Identity(token, Binder.getCallingPid(), Binder.getCallingUid()));
            try {
                pfd = cph.provider.openFile(null, uri, "r", null, token);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                sCallerIdentity.remove();
                this.removeContentProviderExternalUnchecked(name, null, userId);
            }
        } else {
            Slog.d("ActivityManager", "Failed to get provider for authority '" + name + "'");
        }
        return pfd;
    }

    boolean isSleepingOrShuttingDownLocked() {
        return this.isSleepingLocked() || this.mShuttingDown;
    }

    boolean isShuttingDownLocked() {
        return this.mShuttingDown;
    }

    boolean isSleepingLocked() {
        return this.mSleeping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWakefulnessChanged(int wakefulness) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mWakefulness = wakefulness;
            this.updateSleepIfNeededLocked();
        }
    }

    void finishRunningVoiceLocked() {
        if (this.mRunningVoice != null) {
            this.mRunningVoice = null;
            this.mVoiceWakeLock.release();
            this.updateSleepIfNeededLocked();
        }
    }

    void startTimeTrackingFocusedActivityLocked() {
        ActivityRecord resumedActivity = this.mStackSupervisor.getResumedActivityLocked();
        if (!this.mSleeping && this.mCurAppTimeTracker != null && resumedActivity != null) {
            this.mCurAppTimeTracker.start(resumedActivity.packageName);
        }
    }

    void updateSleepIfNeededLocked() {
        boolean shouldSleep = this.shouldSleepLocked();
        if (this.mSleeping && !shouldSleep) {
            this.mSleeping = false;
            this.startTimeTrackingFocusedActivityLocked();
            this.mTopProcessState = 2;
            this.mStackSupervisor.comeOutOfSleepIfNeededLocked();
            this.sendNotifyVrManagerOfSleepState(false);
            this.updateOomAdjLocked();
        } else if (!this.mSleeping && shouldSleep) {
            this.mSleeping = true;
            if (this.mCurAppTimeTracker != null) {
                this.mCurAppTimeTracker.stop();
            }
            this.mTopProcessState = 5;
            this.mStackSupervisor.goingToSleepLocked();
            this.sendNotifyVrManagerOfSleepState(true);
            this.updateOomAdjLocked();
            this.checkExcessivePowerUsageLocked(false);
            this.mHandler.removeMessages(27);
            Message nmsg = this.mHandler.obtainMessage(27);
            this.mHandler.sendMessageDelayed(nmsg, this.mConstants.POWER_CHECK_DELAY);
        }
        switch (this.mWakefulness) {
            case 0: 
            case 2: 
            case 3: {
                this.mServices.updateScreenStateLocked(false);
                break;
            }
            default: {
                this.mServices.updateScreenStateLocked(true);
            }
        }
    }

    private boolean shouldSleepLocked() {
        if (this.mRunningVoice != null) {
            return false;
        }
        switch (this.mWakefulness) {
            case 1: 
            case 2: 
            case 3: {
                return this.mKeyguardController.isKeyguardShowing() || !this.mSleepTokens.isEmpty();
            }
        }
        return true;
    }

    void notifyTaskPersisterLocked(TaskRecord task, boolean flush) {
        this.mRecentTasks.notifyTaskPersisterLocked(task, flush);
    }

    @Override
    public void notifyPinnedStackAnimationStarted() {
        this.mTaskChangeNotificationController.notifyPinnedStackAnimationStarted();
    }

    @Override
    public void notifyPinnedStackAnimationEnded() {
        this.mTaskChangeNotificationController.notifyPinnedStackAnimationEnded();
    }

    @Override
    public void notifyCleartextNetwork(int uid, byte[] firstPacket) {
        this.mHandler.obtainMessage(49, uid, 0, firstPacket).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdown(int timeout) {
        if (this.checkCallingPermission("android.permission.SHUTDOWN") != 0) {
            throw new SecurityException("Requires permission android.permission.SHUTDOWN");
        }
        boolean timedout = false;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mShuttingDown = true;
            this.updateEventDispatchingLocked();
            timedout = this.mStackSupervisor.shutdownLocked(timeout);
        }
        this.mAppOpsService.shutdown();
        if (this.mUsageStatsService != null) {
            this.mUsageStatsService.prepareShutdown();
        }
        this.mBatteryStatsService.shutdown();
        activityManagerService = this;
        synchronized (activityManagerService) {
            this.mProcessStats.shutdownLocked();
            this.notifyTaskPersisterLocked(null, true);
        }
        return timedout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activitySlept(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r != null) {
                this.mStackSupervisor.activitySleptLocked(r);
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    void startRunningVoiceLocked(IVoiceInteractionSession session, int targetUid) {
        Slog.d("ActivityManager", "<<<  startRunningVoiceLocked()");
        this.mVoiceWakeLock.setWorkSource(new WorkSource(targetUid));
        if (this.mRunningVoice == null || this.mRunningVoice.asBinder() != session.asBinder()) {
            boolean wasRunningVoice = this.mRunningVoice != null;
            this.mRunningVoice = session;
            if (!wasRunningVoice) {
                this.mVoiceWakeLock.acquire();
                this.updateSleepIfNeededLocked();
            }
        }
    }

    private void updateEventDispatchingLocked() {
        this.mWindowManager.setEventDispatching(this.mBooted && !this.mShuttingDown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockScreenShown(boolean showing) {
        if (this.checkCallingPermission("android.permission.DEVICE_POWER") != 0) {
            throw new SecurityException("Requires permission android.permission.DEVICE_POWER");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mKeyguardController.setKeyguardShown(showing);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLockedProfile(int userId) {
        try {
            if (!AppGlobals.getPackageManager().isUidPrivileged(Binder.getCallingUid())) {
                throw new SecurityException("Only privileged app can call notifyLockedProfile");
            }
        }
        catch (RemoteException ex) {
            throw new SecurityException("Fail to check is caller a privileged app", ex);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                if (this.mUserController.shouldConfirmCredentials(userId)) {
                    if (this.mKeyguardController.isKeyguardLocked()) {
                        int currentUserId = this.mUserController.getCurrentUserIdLocked();
                        this.startHomeActivityLocked(currentUserId, "notifyLockedProfile");
                    }
                    this.mStackSupervisor.lockAllProfileTasks(userId);
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startConfirmDeviceCredentialIntent(Intent intent, Bundle options) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "startConfirmDeviceCredentialIntent");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mActivityStarter.startConfirmCredentialIntent(intent, options);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAppSwitches() {
        if (this.checkCallingPermission("android.permission.STOP_APP_SWITCHES") != 0) {
            throw new SecurityException("viewquires permission android.permission.STOP_APP_SWITCHES");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAppSwitchesAllowedTime = SystemClock.uptimeMillis() + 5000L;
            this.mDidAppSwitch = false;
            this.mHandler.removeMessages(21);
            Message msg = this.mHandler.obtainMessage(21);
            this.mHandler.sendMessageDelayed(msg, 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeAppSwitches() {
        if (this.checkCallingPermission("android.permission.STOP_APP_SWITCHES") != 0) {
            throw new SecurityException("Requires permission android.permission.STOP_APP_SWITCHES");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAppSwitchesAllowedTime = 0L;
        }
    }

    boolean checkAppSwitchAllowedLocked(int sourcePid, int sourceUid, int callingPid, int callingUid, String name) {
        if (this.mAppSwitchesAllowedTime < SystemClock.uptimeMillis()) {
            return true;
        }
        int perm = this.checkComponentPermission("android.permission.STOP_APP_SWITCHES", sourcePid, sourceUid, -1, true);
        if (perm == 0) {
            return true;
        }
        if (callingUid != -1 && callingUid != sourceUid && (perm = this.checkComponentPermission("android.permission.STOP_APP_SWITCHES", callingPid, callingUid, -1, true)) == 0) {
            return true;
        }
        Slog.w("ActivityManager", name + " request from " + sourceUid + " stopped");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDebugApp(String packageName, boolean waitForDebugger, boolean persistent) {
        this.enforceCallingPermission("android.permission.SET_DEBUG_APP", "setDebugApp()");
        long ident = Binder.clearCallingIdentity();
        try {
            if (persistent) {
                ContentResolver resolver = this.mContext.getContentResolver();
                Settings.Global.putString(resolver, "debug_app", packageName);
                Settings.Global.putInt(resolver, "wait_for_debugger", waitForDebugger ? 1 : 0);
            }
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (!persistent) {
                    this.mOrigDebugApp = this.mDebugApp;
                    this.mOrigWaitForDebugger = this.mWaitForDebugger;
                }
                this.mDebugApp = packageName;
                this.mWaitForDebugger = waitForDebugger;
                boolean bl = this.mDebugTransient = !persistent;
                if (packageName != null) {
                    this.forceStopPackageLocked(packageName, -1, false, false, true, true, false, -1, "set debug app");
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTrackAllocationApp(ApplicationInfo app, String processName) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (!isDebuggable && (app.flags & 2) == 0) {
                throw new SecurityException("Process not debuggable: " + app.packageName);
            }
            this.mTrackAllocationApp = processName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProfileApp(ApplicationInfo app, String processName, ProfilerInfo profilerInfo) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (!isDebuggable && (app.flags & 2) == 0) {
                throw new SecurityException("Process not debuggable: " + app.packageName);
            }
            this.mProfileApp = processName;
            this.mProfileFile = profilerInfo.profileFile;
            if (this.mProfileFd != null) {
                try {
                    this.mProfileFd.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mProfileFd = null;
            }
            this.mProfileFd = profilerInfo.profileFd;
            this.mSamplingInterval = profilerInfo.samplingInterval;
            this.mAutoStopProfiler = profilerInfo.autoStopProfiler;
            this.mStreamingOutput = profilerInfo.streamingOutput;
            this.mProfileType = 0;
        }
    }

    void setNativeDebuggingAppLocked(ApplicationInfo app, String processName) {
        boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
        if (!isDebuggable && (app.flags & 2) == 0) {
            throw new SecurityException("Process not debuggable: " + app.packageName);
        }
        this.mNativeDebuggingApp = processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAlwaysFinish(boolean enabled) {
        this.enforceCallingPermission("android.permission.SET_ALWAYS_FINISH", "setAlwaysFinish()");
        long ident = Binder.clearCallingIdentity();
        try {
            Settings.Global.putInt(this.mContext.getContentResolver(), "always_finish_activities", enabled ? 1 : 0);
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.mAlwaysFinishActivities = enabled;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActivityController(IActivityController controller, boolean imAMonkey) {
        this.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "setActivityController()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mController = controller;
            this.mControllerIsAMonkey = imAMonkey;
            Watchdog.getInstance().setActivityController(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserIsMonkey(boolean userIsMonkey) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                int callingPid = Binder.getCallingPid();
                ProcessRecord proc = this.mPidsSelfLocked.get(callingPid);
                if (proc == null) {
                    throw new SecurityException("Unknown process: " + callingPid);
                }
                if (proc.instr == null || proc.instr.mUiAutomationConnection == null) {
                    throw new SecurityException("Only an instrumentation process with a UiAutomation can call setUserIsMonkey");
                }
            }
            this.mUserIsMonkey = userIsMonkey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserAMonkey() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mUserIsMonkey || this.mController != null && this.mControllerIsAMonkey;
        }
    }

    @Override
    @Deprecated
    public void requestBugReport(int bugreportType) {
        String extraOptions = null;
        switch (bugreportType) {
            case 0: {
                break;
            }
            case 1: {
                extraOptions = "bugreportplus";
                break;
            }
            case 2: {
                extraOptions = "bugreportremote";
                break;
            }
            case 3: {
                extraOptions = "bugreportwear";
                break;
            }
            case 4: {
                extraOptions = "bugreporttelephony";
                break;
            }
            default: {
                throw new IllegalArgumentException("Provided bugreport type is not correct, value: " + bugreportType);
            }
        }
        this.enforceCallingPermission("android.permission.DUMP", "requestBugReport");
        if (extraOptions != null) {
            SystemProperties.set("dumpstate.options", extraOptions);
        }
        SystemProperties.set("ctl.start", "bugreport");
    }

    @Override
    @Deprecated
    public void requestTelephonyBugReport(String shareTitle, String shareDescription) {
        if (!TextUtils.isEmpty(shareTitle)) {
            if (shareTitle.length() > 50) {
                String errorStr = "shareTitle should be less than 50 characters";
                throw new IllegalArgumentException(errorStr);
            }
            if (!TextUtils.isEmpty(shareDescription)) {
                int length;
                try {
                    length = shareDescription.getBytes("UTF-8").length;
                }
                catch (UnsupportedEncodingException e) {
                    String errorStr = "shareDescription: UnsupportedEncodingException";
                    throw new IllegalArgumentException(errorStr);
                }
                if (length > 91) {
                    String errorStr = "shareTitle should be less than 91 bytes";
                    throw new IllegalArgumentException(errorStr);
                }
                SystemProperties.set("dumpstate.options.description", shareDescription);
            }
            SystemProperties.set("dumpstate.options.title", shareTitle);
        }
        Slog.d("ActivityManager", "Bugreport notification title " + shareTitle + " description " + shareDescription);
        this.requestBugReport(4);
    }

    public static long getInputDispatchingTimeoutLocked(ActivityRecord r) {
        return r != null ? ActivityManagerService.getInputDispatchingTimeoutLocked(r.app) : 5000L;
    }

    public static long getInputDispatchingTimeoutLocked(ProcessRecord r) {
        if (r != null && (r.instr != null || r.usingWrapper)) {
            return 60000L;
        }
        return 5000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long inputDispatchingTimedOut(int pid, boolean aboveSystem, String reason) {
        long timeout;
        ProcessRecord proc;
        if (this.checkCallingPermission("android.permission.FILTER_EVENTS") != 0) {
            throw new SecurityException("Requires permission android.permission.FILTER_EVENTS");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                proc = this.mPidsSelfLocked.get(pid);
            }
            timeout = ActivityManagerService.getInputDispatchingTimeoutLocked(proc);
        }
        if (!this.inputDispatchingTimedOut(proc, null, null, aboveSystem, reason)) {
            return -1L;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inputDispatchingTimedOut(final ProcessRecord proc, final ActivityRecord activity, final ActivityRecord parent, final boolean aboveSystem, String reason) {
        if (this.checkCallingPermission("android.permission.FILTER_EVENTS") != 0) {
            throw new SecurityException("Requires permission android.permission.FILTER_EVENTS");
        }
        final String annotation = reason == null ? "Input dispatching timed out" : "Input dispatching timed out (" + reason + ")";
        if (proc != null) {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (proc.debugging) {
                    return false;
                }
                if (this.mDidDexOpt) {
                    this.mDidDexOpt = false;
                    return false;
                }
                if (proc.instr != null) {
                    Bundle info = new Bundle();
                    info.putString("shortMsg", "keyDispatchingTimedOut");
                    info.putString("longMsg", annotation);
                    this.finishInstrumentationLocked(proc, 0, info);
                    return true;
                }
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ActivityManagerService.this.mAppErrors.appNotResponding(proc, activity, parent, aboveSystem, annotation);
                }
            });
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getAssistContextExtras(int requestType) {
        PendingAssistExtras pae = this.enqueueAssistContext(requestType, null, null, null, null, null, true, true, UserHandle.getCallingUserId(), null, 500L, 0);
        if (pae == null) {
            return null;
        }
        Binder binder = pae;
        synchronized (binder) {
            while (!pae.haveResult) {
                try {
                    pae.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        binder = this;
        synchronized (binder) {
            this.buildAssistBundleLocked(pae, pae.result);
            this.mPendingAssistExtras.remove(pae);
            this.mUiHandler.removeCallbacks(pae);
        }
        return pae.extras;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAssistDataAllowedOnCurrentActivity() {
        int userId;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack focusedStack = this.getFocusedStack();
            if (focusedStack == null || focusedStack.isAssistantStack()) {
                return false;
            }
            ActivityRecord activity = focusedStack.topActivity();
            if (activity == null) {
                return false;
            }
            userId = activity.userId;
        }
        DevicePolicyManager dpm = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        return dpm == null || !dpm.getScreenCaptureDisabled(null, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean showAssistFromActivity(IBinder token, Bundle args) {
        ActivityRecord top;
        ActivityRecord caller;
        long ident;
        block9: {
            ident = Binder.clearCallingIdentity();
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            caller = ActivityRecord.forTokenLocked(token);
            top = this.getFocusedStack().topActivity();
            if (top == caller) break block9;
            Slog.w("ActivityManager", "showAssistFromActivity failed: caller " + caller + " is not current top " + top);
            boolean bl = false;
            // MONITOREXIT : activityManagerService
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        if (!top.nowVisible) {
            Slog.w("ActivityManager", "showAssistFromActivity failed: caller " + caller + " is not visible");
            boolean bl = false;
            // MONITOREXIT : activityManagerService
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        try {
            // MONITOREXIT : activityManagerService
            boolean bl = this.mAssistUtils.showSessionForActiveService(args, 8, null, token);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public boolean requestAssistContextExtras(int requestType, IResultReceiver receiver, Bundle receiverExtras, IBinder activityToken, boolean focused, boolean newSessionId) {
        return this.enqueueAssistContext(requestType, null, null, receiver, receiverExtras, activityToken, focused, newSessionId, UserHandle.getCallingUserId(), null, 2000L, 0) != null;
    }

    @Override
    public boolean requestAutofillData(IResultReceiver receiver, Bundle receiverExtras, IBinder activityToken, int flags) {
        return this.enqueueAssistContext(2, null, null, receiver, receiverExtras, activityToken, true, true, UserHandle.getCallingUserId(), null, 2000L, flags) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PendingAssistExtras enqueueAssistContext(int requestType, Intent intent, String hint, IResultReceiver receiver, Bundle receiverExtras, IBinder activityToken, boolean focused, boolean newSessionId, int userHandle, Bundle args, long timeout, int flags) {
        this.enforceCallingPermission("android.permission.GET_TOP_ACTIVITY_INFO", "enqueueAssistContext()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord activity = this.getFocusedStack().topActivity();
            if (activity == null) {
                Slog.w("ActivityManager", "getAssistContextExtras failed: no top activity");
                return null;
            }
            if (activity.app == null || activity.app.thread == null) {
                Slog.w("ActivityManager", "getAssistContextExtras failed: no process for " + activity);
                return null;
            }
            if (focused) {
                ActivityRecord caller;
                if (activityToken != null && activity != (caller = ActivityRecord.forTokenLocked(activityToken))) {
                    Slog.w("ActivityManager", "enqueueAssistContext failed: caller " + caller + " is not current top " + activity);
                    return null;
                }
            } else {
                activity = ActivityRecord.forTokenLocked(activityToken);
                if (activity == null) {
                    Slog.w("ActivityManager", "enqueueAssistContext failed: activity for token=" + activityToken + " couldn't be found");
                    return null;
                }
            }
            Bundle extras = new Bundle();
            if (args != null) {
                extras.putAll(args);
            }
            extras.putString("android.intent.extra.ASSIST_PACKAGE", activity.packageName);
            extras.putInt("android.intent.extra.ASSIST_UID", activity.app.uid);
            PendingAssistExtras pae = new PendingAssistExtras(activity, extras, intent, hint, receiver, receiverExtras, userHandle);
            pae.isHome = activity.isHomeActivity();
            if (newSessionId) {
                ++this.mViSessionId;
            }
            try {
                activity.app.thread.requestAssistContextExtras(activity.appToken, pae, requestType, this.mViSessionId, flags);
                this.mPendingAssistExtras.add(pae);
                this.mUiHandler.postDelayed(pae, timeout);
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "getAssistContextExtras failed: crash calling " + activity);
                return null;
            }
            return pae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pendingAssistExtrasTimedOut(PendingAssistExtras pae) {
        IResultReceiver receiver;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mPendingAssistExtras.remove(pae);
            receiver = pae.receiver;
        }
        if (receiver != null) {
            Bundle sendBundle = new Bundle();
            sendBundle.putBundle("receiverExtras", pae.receiverExtras);
            try {
                pae.receiver.send(0, sendBundle);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void buildAssistBundleLocked(PendingAssistExtras pae, Bundle result) {
        if (result != null) {
            pae.extras.putBundle("android.intent.extra.ASSIST_CONTEXT", result);
        }
        if (pae.hint != null) {
            pae.extras.putBoolean(pae.hint, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportAssistContextExtras(IBinder token, Bundle extras, AssistStructure structure, AssistContent content, Uri referrer) {
        PendingAssistExtras pae;
        PendingAssistExtras pendingAssistExtras = pae = (PendingAssistExtras)token;
        synchronized (pendingAssistExtras) {
            pae.result = extras;
            pae.structure = structure;
            pae.content = content;
            if (referrer != null) {
                pae.extras.putParcelable("android.intent.extra.REFERRER", referrer);
            }
            if (structure != null) {
                structure.setHomeActivity(pae.isHome);
            }
            pae.haveResult = true;
            pae.notifyAll();
            if (pae.intent == null && pae.receiver == null) {
                return;
            }
        }
        IResultReceiver sendReceiver = null;
        Bundle sendBundle = null;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.buildAssistBundleLocked(pae, extras);
            boolean exists = this.mPendingAssistExtras.remove(pae);
            this.mUiHandler.removeCallbacks(pae);
            if (!exists) {
                return;
            }
            sendReceiver = pae.receiver;
            if (sendReceiver != null) {
                sendBundle = new Bundle();
                sendBundle.putBundle("data", pae.extras);
                sendBundle.putParcelable("structure", pae.structure);
                sendBundle.putParcelable("content", pae.content);
                sendBundle.putBundle("receiverExtras", pae.receiverExtras);
            }
        }
        if (sendReceiver != null) {
            try {
                sendReceiver.send(0, sendBundle);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            pae.intent.replaceExtras(pae.extras);
            pae.intent.setFlags(0x34000000);
            this.closeSystemDialogs("assist");
            try {
                this.mContext.startActivityAsUser(pae.intent, new UserHandle(pae.userHandle));
            }
            catch (ActivityNotFoundException e) {
                Slog.w("ActivityManager", "No activity to handle assist action.", e);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public boolean launchAssistIntent(Intent intent, int requestType, String hint, int userHandle, Bundle args) {
        return this.enqueueAssistContext(requestType, intent, hint, null, null, null, true, true, userHandle, args, 500L, 0) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProcessObserver(IProcessObserver observer) {
        this.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "registerProcessObserver()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mProcessObservers.register(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterProcessObserver(IProcessObserver observer) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mProcessObservers.unregister(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUidProcessState(int uid, String callingPackage) {
        if (!this.hasUsageStatsPermission(callingPackage)) {
            this.enforceCallingPermission("android.permission.PACKAGE_USAGE_STATS", "getUidProcessState");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UidRecord uidRec = this.mActiveUids.get(uid);
            return uidRec != null ? uidRec.curProcState : 18;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUidObserver(IUidObserver observer, int which, int cutpoint, String callingPackage) {
        if (!this.hasUsageStatsPermission(callingPackage)) {
            this.enforceCallingPermission("android.permission.PACKAGE_USAGE_STATS", "registerUidObserver");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mUidObservers.register(observer, new UidObserverRegistration(Binder.getCallingUid(), callingPackage, which, cutpoint));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterUidObserver(IUidObserver observer) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mUidObservers.unregister(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean convertFromTranslucent(IBinder token) {
        ActivityRecord r;
        long origId;
        block7: {
            boolean bl;
            origId = Binder.clearCallingIdentity();
            try {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                r = ActivityRecord.isInStackLocked(token);
                if (r != null) break block7;
                bl = false;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
        boolean translucentChanged = r.changeWindowTranslucency(true);
        if (translucentChanged) {
            ((ActivityStack)r.getStack()).releaseBackgroundResources(r);
            this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
        }
        this.mWindowManager.setAppFullscreen(token, true);
        boolean bl = translucentChanged;
        // MONITOREXIT : activityManagerService
        Binder.restoreCallingIdentity(origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean convertToTranslucent(IBinder token, Bundle options) {
        boolean translucentChanged;
        ActivityRecord r;
        long origId;
        block8: {
            boolean bl;
            origId = Binder.clearCallingIdentity();
            try {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                r = ActivityRecord.isInStackLocked(token);
                if (r != null) break block8;
                bl = false;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
        TaskRecord task = r.getTask();
        int index = task.mActivities.lastIndexOf(r);
        if (index > 0) {
            ActivityRecord under = task.mActivities.get(index - 1);
            under.returningOptions = ActivityOptions.fromBundle(options);
        }
        if (translucentChanged = r.changeWindowTranslucency(false)) {
            ((ActivityStack)r.getStack()).convertActivityToTranslucent(r);
        }
        this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
        this.mWindowManager.setAppFullscreen(token, false);
        boolean bl = translucentChanged;
        // MONITOREXIT : activityManagerService
        Binder.restoreCallingIdentity(origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean requestVisibleBehind(IBinder token, boolean visible) {
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ActivityRecord r = ActivityRecord.isInStackLocked(token);
                if (r != null) {
                    boolean bl = this.mStackSupervisor.requestVisibleBehindLocked(r, visible);
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBackgroundVisibleBehind(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                boolean visible;
                ActivityStack stack = ActivityRecord.getStackLocked(token);
                boolean bl = visible = stack == null ? false : stack.hasVisibleBehindActivity();
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Bundle getActivityOptions(IBinder token) {
        long origId;
        block6: {
            Bundle bundle;
            origId = Binder.clearCallingIdentity();
            try {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                ActivityRecord r = ActivityRecord.isInStackLocked(token);
                if (r == null) break block6;
                ActivityOptions activityOptions = r.pendingOptions;
                r.pendingOptions = null;
                bundle = activityOptions == null ? null : activityOptions.toBundle();
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bundle;
        }
        Bundle bundle = null;
        // MONITOREXIT : activityManagerService
        Binder.restoreCallingIdentity(origId);
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImmersive(IBinder token, boolean immersive) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                throw new IllegalArgumentException();
            }
            r.immersive = immersive;
            if (r == this.mStackSupervisor.getResumedActivityLocked()) {
                this.applyUpdateLockStateLocked(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isImmersive(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                throw new IllegalArgumentException();
            }
            return r.immersive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVrThread(int tid) {
        this.enforceSystemHasVrFeature();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                int pid = Binder.getCallingPid();
                ProcessRecord proc = this.mPidsSelfLocked.get(pid);
                this.mVrController.setVrThreadLocked(tid, pid, proc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPersistentVrThread(int tid) {
        if (this.checkCallingPermission("android.permission.RESTRICTED_VR_ACCESS") != 0) {
            String msg = "Permission Denial: setPersistentVrThread() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.RESTRICTED_VR_ACCESS";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        this.enforceSystemHasVrFeature();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                int pid = Binder.getCallingPid();
                ProcessRecord proc = this.mPidsSelfLocked.get(pid);
                this.mVrController.setPersistentVrThreadLocked(tid, pid, proc);
            }
        }
    }

    static boolean scheduleAsRegularPriority(int tid, boolean suppressLogs) {
        try {
            android.os.Process.setThreadScheduler(tid, 0, 0);
            return true;
        }
        catch (IllegalArgumentException e) {
            if (!suppressLogs) {
                Slog.w("ActivityManager", "Failed to set scheduling policy, thread does not exist:\n" + e);
            }
            return false;
        }
    }

    static boolean scheduleAsFifoPriority(int tid, boolean suppressLogs) {
        try {
            android.os.Process.setThreadScheduler(tid, 0x40000001, 1);
            return true;
        }
        catch (IllegalArgumentException e) {
            if (!suppressLogs) {
                Slog.w("ActivityManager", "Failed to set scheduling policy, thread does not exist:\n" + e);
            }
            return false;
        }
    }

    private void enforceSystemHasVrFeature() {
        if (!this.mContext.getPackageManager().hasSystemFeature("android.software.vr.mode")) {
            throw new UnsupportedOperationException("VR mode not supported on this device!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRenderThread(int tid) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int pid = Binder.getCallingPid();
            if (pid == android.os.Process.myPid()) {
                this.demoteSystemServerRenderThread(tid);
                return;
            }
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                ProcessRecord proc = this.mPidsSelfLocked.get(pid);
                if (proc != null && proc.renderThreadTid == 0 && tid > 0) {
                    if (!android.os.Process.isThreadInProcess(pid, tid)) {
                        throw new IllegalArgumentException("Render thread does not belong to process");
                    }
                    proc.renderThreadTid = tid;
                    if (proc.curSchedGroup == 2) {
                        if (this.mUseFifoUiScheduling) {
                            android.os.Process.setThreadScheduler(proc.renderThreadTid, 0x40000001, 1);
                        } else {
                            android.os.Process.setThreadPriority(proc.renderThreadTid, -10);
                        }
                    }
                }
            }
        }
    }

    private void demoteSystemServerRenderThread(int tid) {
        android.os.Process.setThreadPriority(tid, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setVrMode(IBinder token, boolean enabled, ComponentName packageName) {
        ActivityRecord r;
        if (!this.mContext.getPackageManager().hasSystemFeature("android.software.vr.mode")) {
            throw new UnsupportedOperationException("VR mode not supported on this device!");
        }
        VrManagerInternal vrService = LocalServices.getService(VrManagerInternal.class);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            r = ActivityRecord.isInStackLocked(token);
        }
        if (r == null) {
            throw new IllegalArgumentException();
        }
        int err = vrService.hasVrPackage(packageName, r.userId);
        if (err != 0) {
            return err;
        }
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            ComponentName componentName = r.requestedVrComponent = enabled ? packageName : null;
            if (r == this.mStackSupervisor.getResumedActivityLocked()) {
                this.applyUpdateVrModeLocked(r);
            }
            return 0;
        }
    }

    @Override
    public boolean isVrModePackageEnabled(ComponentName packageName) {
        if (!this.mContext.getPackageManager().hasSystemFeature("android.software.vr.mode")) {
            throw new UnsupportedOperationException("VR mode not supported on this device!");
        }
        VrManagerInternal vrService = LocalServices.getService(VrManagerInternal.class);
        return vrService.hasVrPackage(packageName, UserHandle.getCallingUserId()) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTopActivityImmersive() {
        this.enforceNotIsolatedCaller("startActivity");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.getFocusedStack().topRunningActivityLocked();
            return r != null ? r.immersive : false;
        }
    }

    boolean shouldDisableNonVrUiLocked() {
        return this.mVrController.shouldDisableNonVrUiLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTopOfTask(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                throw new IllegalArgumentException();
            }
            return r.getTask().getTopActivity() == r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setHasTopUi(boolean hasTopUi) throws RemoteException {
        if (this.checkCallingPermission("android.permission.INTERNAL_SYSTEM_WINDOW") != 0) {
            String msg = "Permission Denial: setHasTopUi() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERNAL_SYSTEM_WINDOW";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        int pid = Binder.getCallingPid();
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ProcessRecord pr;
                boolean changed = false;
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    pr = this.mPidsSelfLocked.get(pid);
                    if (pr == null) {
                        Slog.w("ActivityManager", "setHasTopUi called on unknown pid: " + pid);
                        return;
                    }
                    if (pr.hasTopUi != hasTopUi) {
                        pr.hasTopUi = hasTopUi;
                        changed = true;
                    }
                }
                if (!changed) return;
                this.updateOomAdjLocked(pr, true);
                return;
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void enterSafeMode() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!this.mSystemReady) {
                try {
                    AppGlobals.getPackageManager().enterSafeMode();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mSafeMode = true;
        }
    }

    public final void showSafeModeOverlay() {
        View v = LayoutInflater.from(this.mContext).inflate(17367245, null);
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.type = 2015;
        lp.width = -2;
        lp.height = -2;
        lp.gravity = 8388691;
        lp.format = v.getBackground().getOpacity();
        lp.flags = 24;
        lp.privateFlags |= 0x10;
        ((WindowManager)this.mContext.getSystemService("window")).addView(v, lp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWakeupAlarm(IIntentSender sender, int sourceUid, String sourcePkg, String tag) {
        BatteryStatsImpl stats;
        if (sender != null && !(sender instanceof PendingIntentRecord)) {
            return;
        }
        PendingIntentRecord rec = (PendingIntentRecord)sender;
        BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
        synchronized (batteryStatsImpl) {
            if (this.mBatteryStatsService.isOnBattery()) {
                this.mBatteryStatsService.enforceCallingPermission();
                int MY_UID = Binder.getCallingUid();
                int uid = sender == null ? sourceUid : (rec.uid == MY_UID ? 1000 : rec.uid);
                BatteryStatsImpl.Uid.Pkg pkg = stats.getPackageStatsLocked(sourceUid >= 0 ? sourceUid : uid, sourcePkg != null ? sourcePkg : rec.key.packageName);
                pkg.noteWakeupAlarmLocked(tag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteAlarmStart(IIntentSender sender, int sourceUid, String tag) {
        BatteryStatsImpl stats;
        if (sender != null && !(sender instanceof PendingIntentRecord)) {
            return;
        }
        PendingIntentRecord rec = (PendingIntentRecord)sender;
        BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
        synchronized (batteryStatsImpl) {
            this.mBatteryStatsService.enforceCallingPermission();
            int MY_UID = Binder.getCallingUid();
            int uid = sender == null ? sourceUid : (rec.uid == MY_UID ? 1000 : rec.uid);
            this.mBatteryStatsService.noteAlarmStart(tag, sourceUid >= 0 ? sourceUid : uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteAlarmFinish(IIntentSender sender, int sourceUid, String tag) {
        BatteryStatsImpl stats;
        if (sender != null && !(sender instanceof PendingIntentRecord)) {
            return;
        }
        PendingIntentRecord rec = (PendingIntentRecord)sender;
        BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
        synchronized (batteryStatsImpl) {
            this.mBatteryStatsService.enforceCallingPermission();
            int MY_UID = Binder.getCallingUid();
            int uid = sender == null ? sourceUid : (rec.uid == MY_UID ? 1000 : rec.uid);
            this.mBatteryStatsService.noteAlarmFinish(tag, sourceUid >= 0 ? sourceUid : uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean killPids(int[] pids, String pReason, boolean secure) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killPids only available to the system");
        }
        String reason = pReason == null ? "Unknown" : pReason;
        boolean killed = false;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            ProcessRecord proc;
            int i;
            int worstType = 0;
            for (i = 0; i < pids.length; ++i) {
                int type;
                proc = this.mPidsSelfLocked.get(pids[i]);
                if (proc == null || (type = proc.setAdj) <= worstType) continue;
                worstType = type;
            }
            if (worstType < 906 && worstType > 900) {
                worstType = 900;
            }
            if (!secure && worstType < 500) {
                worstType = 500;
            }
            Slog.w("ActivityManager", "Killing processes " + reason + " at adjustment " + worstType);
            for (i = 0; i < pids.length; ++i) {
                int adj;
                proc = this.mPidsSelfLocked.get(pids[i]);
                if (proc == null || (adj = proc.setAdj) < worstType || proc.killedByAm) continue;
                proc.kill(reason, true);
                killed = true;
            }
        }
        return killed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killUid(int appId, int userId, String reason) {
        this.enforceCallingPermission("android.permission.KILL_UID", "killUid");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.killPackageProcessesLocked(null, appId, userId, -800, false, true, true, true, reason != null ? reason : "kill uid");
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    @Override
    public boolean killProcessesBelowForeground(String reason) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killProcessesBelowForeground() only available to system");
        }
        return this.killProcessesBelowAdj(0, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean killProcessesBelowAdj(int belowAdj, String reason) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killProcessesBelowAdj() only available to system");
        }
        boolean killed = false;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            int size = this.mPidsSelfLocked.size();
            for (int i = 0; i < size; ++i) {
                int adj;
                int pid = this.mPidsSelfLocked.keyAt(i);
                ProcessRecord proc = this.mPidsSelfLocked.valueAt(i);
                if (proc == null || (adj = proc.setAdj) <= belowAdj || proc.killedByAm) continue;
                proc.kill(reason, true);
                killed = true;
            }
        }
        return killed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hang(IBinder who, boolean allowRestart) {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        IBinder.DeathRecipient death = new IBinder.DeathRecipient(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void binderDied() {
                16 var1_1 = this;
                synchronized (var1_1) {
                    this.notifyAll();
                }
            }
        };
        try {
            who.linkToDeath(death, 0);
        }
        catch (RemoteException e) {
            Slog.w("ActivityManager", "hang: given caller IBinder is already dead.");
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            Watchdog.getInstance().setAllowRestart(allowRestart);
            Slog.i("ActivityManager", "Hanging system process at request of pid " + Binder.getCallingPid());
            IBinder.DeathRecipient deathRecipient = death;
            synchronized (deathRecipient) {
                while (who.isBinderAlive()) {
                    try {
                        death.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            Watchdog.getInstance().setAllowRestart(true);
        }
    }

    @Override
    public void restart() {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        Log.i("ActivityManager", "Sending shutdown broadcast...");
        BroadcastReceiver br = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                Log.i("ActivityManager", "Shutting down activity manager...");
                ActivityManagerService.this.shutdown(10000);
                Log.i("ActivityManager", "Shutdown complete, restarting!");
                android.os.Process.killProcess(android.os.Process.myPid());
                System.exit(10);
            }
        };
        Intent intent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.SHUTDOWN_USERSPACE_ONLY", true);
        br.onReceive(this.mContext, intent);
    }

    private long getLowRamTimeSinceIdle(long now) {
        return this.mLowRamTimeSinceLastIdle + (this.mLowRamStartTime > 0L ? now - this.mLowRamStartTime : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performIdleMaintenance() {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long now = SystemClock.uptimeMillis();
            long timeSinceLastIdle = now - this.mLastIdleTime;
            long lowRamSinceLastIdle = this.getLowRamTimeSinceIdle(now);
            this.mLastIdleTime = now;
            this.mLowRamTimeSinceLastIdle = 0L;
            if (this.mLowRamStartTime != 0L) {
                this.mLowRamStartTime = now;
            }
            StringBuilder sb = new StringBuilder(128);
            sb.append("Idle maintenance over ");
            TimeUtils.formatDuration(timeSinceLastIdle, sb);
            sb.append(" low RAM for ");
            TimeUtils.formatDuration(lowRamSinceLastIdle, sb);
            Slog.i("ActivityManager", sb.toString());
            boolean doKilling = lowRamSinceLastIdle > timeSinceLastIdle / 3L;
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord proc = this.mLruProcesses.get(i);
                if (proc.notCachedSinceIdle) {
                    if (proc.setProcState == 5 || proc.setProcState < 4 || proc.setProcState > 11 || !doKilling || proc.initialIdlePss == 0L || proc.lastPss <= proc.initialIdlePss * 3L / 2L) continue;
                    sb = new StringBuilder(128);
                    sb.append("Kill");
                    sb.append(proc.processName);
                    sb.append(" in idle maint: pss=");
                    sb.append(proc.lastPss);
                    sb.append(", swapPss=");
                    sb.append(proc.lastSwapPss);
                    sb.append(", initialPss=");
                    sb.append(proc.initialIdlePss);
                    sb.append(", period=");
                    TimeUtils.formatDuration(timeSinceLastIdle, sb);
                    sb.append(", lowRamPeriod=");
                    TimeUtils.formatDuration(lowRamSinceLastIdle, sb);
                    Slog.wtfQuiet("ActivityManager", sb.toString());
                    proc.kill("idle maint (pss " + proc.lastPss + " from " + proc.initialIdlePss + ")", true);
                    continue;
                }
                if (proc.setProcState >= 13 || proc.setProcState < 0) continue;
                proc.notCachedSinceIdle = true;
                proc.initialIdlePss = 0L;
                proc.nextPssTime = ProcessList.computeNextPssTime(proc.setProcState, true, this.mTestPssMode, this.isSleepingLocked(), now);
            }
            this.mHandler.removeMessages(39);
            this.mHandler.sendEmptyMessageDelayed(39, 120000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendIdleJobTrigger() {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Intent intent = new Intent(ACTION_TRIGGER_IDLE).setPackage("android").addFlags(0x40000000);
            this.broadcastIntent(null, intent, null, null, 0, null, null, null, -1, null, true, false, -1);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveSettings() {
        ContentResolver resolver = this.mContext.getContentResolver();
        boolean freeformWindowManagement = this.mContext.getPackageManager().hasSystemFeature("android.software.freeform_window_management") || Settings.Global.getInt(resolver, "enable_freeform_support", 0) != 0;
        boolean supportsPictureInPicture = this.mContext.getPackageManager().hasSystemFeature("android.software.picture_in_picture");
        boolean supportsMultiWindow = ActivityManager.supportsMultiWindow(this.mContext);
        boolean supportsSplitScreenMultiWindow = ActivityManager.supportsSplitScreenMultiWindow(this.mContext);
        boolean supportsMultiDisplay = this.mContext.getPackageManager().hasSystemFeature("android.software.activities_on_secondary_displays");
        String debugApp = Settings.Global.getString(resolver, "debug_app");
        boolean waitForDebugger = Settings.Global.getInt(resolver, "wait_for_debugger", 0) != 0;
        boolean alwaysFinishActivities = Settings.Global.getInt(resolver, "always_finish_activities", 0) != 0;
        boolean forceRtl = Settings.Global.getInt(resolver, "debug.force_rtl", 0) != 0;
        boolean forceResizable = Settings.Global.getInt(resolver, "force_resizable_activities", 0) != 0;
        long waitForNetworkTimeoutMs = Settings.Global.getLong(resolver, "network_access_timeout_ms", 200L);
        boolean supportsLeanbackOnly = this.mContext.getPackageManager().hasSystemFeature("android.software.leanback_only");
        SystemProperties.set("debug.force_rtl", forceRtl ? "1" : "0");
        Configuration configuration = new Configuration();
        Settings.System.getConfiguration(resolver, configuration);
        if (forceRtl) {
            configuration.setLayoutDirection(configuration.locale);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean multiWindowFormEnabled;
            this.mDebugApp = this.mOrigDebugApp = debugApp;
            this.mWaitForDebugger = this.mOrigWaitForDebugger = waitForDebugger;
            this.mAlwaysFinishActivities = alwaysFinishActivities;
            this.mSupportsLeanbackOnly = supportsLeanbackOnly;
            this.mForceResizableActivities = forceResizable;
            boolean bl = multiWindowFormEnabled = freeformWindowManagement || supportsSplitScreenMultiWindow || supportsPictureInPicture || supportsMultiDisplay;
            if ((supportsMultiWindow || forceResizable) && multiWindowFormEnabled) {
                this.mSupportsMultiWindow = true;
                this.mSupportsFreeformWindowManagement = freeformWindowManagement;
                this.mSupportsSplitScreenMultiWindow = supportsSplitScreenMultiWindow;
                this.mSupportsPictureInPicture = supportsPictureInPicture;
                this.mSupportsMultiDisplay = supportsMultiDisplay;
            } else {
                this.mSupportsMultiWindow = false;
                this.mSupportsFreeformWindowManagement = false;
                this.mSupportsSplitScreenMultiWindow = false;
                this.mSupportsPictureInPicture = false;
                this.mSupportsMultiDisplay = false;
            }
            this.mWindowManager.setForceResizableTasks(this.mForceResizableActivities);
            this.mWindowManager.setSupportsPictureInPicture(this.mSupportsPictureInPicture);
            this.updateConfigurationLocked(configuration, null, true);
            Configuration globalConfig = this.getGlobalConfiguration();
            Resources res = this.mContext.getResources();
            this.mHasRecents = res.getBoolean(17956965);
            this.mThumbnailWidth = res.getDimensionPixelSize(17104898);
            this.mThumbnailHeight = res.getDimensionPixelSize(0x1050001);
            this.mAppErrors.loadAppsNotReportingCrashesFromConfigLocked(res.getString(17039623));
            this.mUserController.mUserSwitchUiEnabled = !res.getBoolean(17956914);
            this.mFullscreenThumbnailScale = (globalConfig.uiMode & 4) == 4 ? (float)res.getInteger(0x10E00E0) / (float)globalConfig.screenWidthDp : res.getFraction(18022411, 1, 1);
            this.mWaitForNetworkTimeoutMs = waitForNetworkTimeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(Runnable goingCallback, BootTimingsTraceLog traceLog) {
        int currentUserId;
        ProcessRecord proc;
        int i;
        traceLog.traceBegin("PhaseActivityManagerReady");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mSystemReady) {
                if (goingCallback != null) {
                    goingCallback.run();
                }
                return;
            }
            this.mLocalDeviceIdleController = LocalServices.getService(DeviceIdleController.LocalService.class);
            this.mAssistUtils = new AssistUtils(this.mContext);
            this.mVrController.onSystemReady();
            this.mUserController.onSystemReady();
            this.mRecentTasks.onSystemReadyLocked();
            this.mAppOpsService.systemReady();
            this.mSystemReady = true;
        }
        ArrayList<ProcessRecord> procsToKill = null;
        Object object = this.mPidsSelfLocked;
        synchronized (object) {
            for (i = this.mPidsSelfLocked.size() - 1; i >= 0; --i) {
                proc = this.mPidsSelfLocked.valueAt(i);
                if (this.isAllowedWhileBooting(proc.info)) continue;
                if (procsToKill == null) {
                    procsToKill = new ArrayList<ProcessRecord>();
                }
                procsToKill.add(proc);
            }
        }
        object = this;
        synchronized (object) {
            if (procsToKill != null) {
                for (i = procsToKill.size() - 1; i >= 0; --i) {
                    proc = (ProcessRecord)procsToKill.get(i);
                    Slog.i("ActivityManager", "Removing system update proc: " + proc);
                    this.removeProcessLocked(proc, true, false, "system update done");
                }
            }
            this.mProcessesReady = true;
        }
        Slog.i("ActivityManager", "System now ready");
        EventLog.writeEvent(3040, SystemClock.uptimeMillis());
        object = this;
        synchronized (object) {
            if (this.mFactoryTest == 1) {
                ResolveInfo ri = this.mContext.getPackageManager().resolveActivity(new Intent("android.intent.action.FACTORY_TEST"), 1024);
                CharSequence errorMsg = null;
                if (ri != null) {
                    ActivityInfo ai = ri.activityInfo;
                    ApplicationInfo app = ai.applicationInfo;
                    if ((app.flags & 1) != 0) {
                        this.mTopAction = "android.intent.action.FACTORY_TEST";
                        this.mTopData = null;
                        this.mTopComponent = new ComponentName(app.packageName, ai.name);
                    } else {
                        errorMsg = this.mContext.getResources().getText(17039860);
                    }
                } else {
                    errorMsg = this.mContext.getResources().getText(17039859);
                }
                if (errorMsg != null) {
                    this.mTopAction = null;
                    this.mTopData = null;
                    this.mTopComponent = null;
                    Message msg = Message.obtain();
                    msg.what = 3;
                    msg.getData().putCharSequence("msg", errorMsg);
                    this.mUiHandler.sendMessage(msg);
                }
            }
        }
        this.retrieveSettings();
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            currentUserId = this.mUserController.getCurrentUserIdLocked();
            this.readGrantedUriPermissionsLocked();
        }
        if (goingCallback != null) {
            goingCallback.run();
        }
        traceLog.traceBegin("ActivityManagerStartApps");
        this.mBatteryStatsService.noteEvent(32775, Integer.toString(currentUserId), currentUserId);
        this.mBatteryStatsService.noteEvent(32776, Integer.toString(currentUserId), currentUserId);
        this.mSystemServiceManager.startUser(currentUserId);
        activityManagerService2 = this;
        synchronized (activityManagerService2) {
            this.startPersistentApps(524288);
            this.mBooting = true;
            if (UserManager.isSplitSystemUser() && Settings.Secure.getInt(this.mContext.getContentResolver(), "user_setup_complete", 0) != 0) {
                ComponentName cName = new ComponentName(this.mContext, SystemUserHomeActivity.class);
                try {
                    AppGlobals.getPackageManager().setComponentEnabledSetting(cName, 1, 0, 0);
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
            }
            this.startHomeActivityLocked(currentUserId, "systemReady");
            try {
                if (AppGlobals.getPackageManager().hasSystemUidErrors()) {
                    Slog.e("ActivityManager", "UIDs on the system are inconsistent, you need to wipe your data partition or your device will be unstable.");
                    this.mUiHandler.obtainMessage(14).sendToTarget();
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (!Build.isBuildConsistent()) {
                Slog.e("ActivityManager", "Build fingerprint is not consistent, warning user");
                this.mUiHandler.obtainMessage(15).sendToTarget();
            }
            long ident = Binder.clearCallingIdentity();
            try {
                Intent intent = new Intent("android.intent.action.USER_STARTED");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", currentUserId);
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, currentUserId);
                intent = new Intent("android.intent.action.USER_STARTING");
                intent.addFlags(0x40000000);
                intent.putExtra("android.intent.extra.user_handle", currentUserId);
                this.broadcastIntentLocked(null, null, intent, null, new IIntentReceiver.Stub(){

                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                    }
                }, 0, null, null, new String[]{"android.permission.INTERACT_ACROSS_USERS"}, -1, null, true, false, MY_PID, 1000, -1);
            }
            catch (Throwable t) {
                Slog.wtf("ActivityManager", "Failed sending first user broadcasts", t);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
            this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            this.mUserController.sendUserSwitchBroadcastsLocked(-1, currentUserId);
            traceLog.traceEnd();
            traceLog.traceEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void killAppAtUsersRequest(ProcessRecord app, Dialog fromDialog) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAppErrors.killAppAtUserRequestLocked(app, fromDialog);
        }
    }

    void skipCurrentReceiverLocked(ProcessRecord app) {
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.skipCurrentReceiverLocked(app);
        }
    }

    @Override
    public void handleApplicationCrash(IBinder app, ApplicationErrorReport.ParcelableCrashInfo crashInfo) {
        ProcessRecord r = this.findAppProcess(app, "Crash");
        String processName = app == null ? "system_server" : (r == null ? "unknown" : r.processName);
        this.handleApplicationCrashInner("crash", r, processName, crashInfo);
    }

    void handleApplicationCrashInner(String eventType, ProcessRecord r, String processName, ApplicationErrorReport.CrashInfo crashInfo) {
        EventLog.writeEvent(30039, Binder.getCallingPid(), UserHandle.getUserId(Binder.getCallingUid()), processName, r == null ? -1 : r.info.flags, crashInfo.exceptionClassName, crashInfo.exceptionMessage, crashInfo.throwFileName, crashInfo.throwLineNumber);
        this.addErrorToDropBox(eventType, r, processName, null, null, null, null, null, crashInfo);
        this.mAppErrors.crashApplication(r, crashInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleApplicationStrictModeViolation(IBinder app, int violationMask, StrictMode.ViolationInfo info) {
        ProcessRecord r = this.findAppProcess(app, "StrictMode");
        if (r == null) {
            return;
        }
        if ((violationMask & 0x200000) != 0) {
            Integer stackFingerprint = info.hashCode();
            boolean logIt = true;
            HashSet<Integer> hashSet = this.mAlreadyLoggedViolatedStacks;
            synchronized (hashSet) {
                if (this.mAlreadyLoggedViolatedStacks.contains(stackFingerprint)) {
                    logIt = false;
                } else {
                    if (this.mAlreadyLoggedViolatedStacks.size() >= 5000) {
                        this.mAlreadyLoggedViolatedStacks.clear();
                    }
                    this.mAlreadyLoggedViolatedStacks.add(stackFingerprint);
                }
            }
            if (logIt) {
                this.logStrictModeViolationToDropBox(r, info);
            }
        }
        if ((violationMask & 0x20000) != 0) {
            AppErrorResult result = new AppErrorResult();
            ActivityManagerService logIt = this;
            synchronized (logIt) {
                long origId = Binder.clearCallingIdentity();
                Message msg = Message.obtain();
                msg.what = 26;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("result", result);
                data.put("app", r);
                data.put("violationMask", violationMask);
                data.put("info", info);
                msg.obj = data;
                this.mUiHandler.sendMessage(msg);
                Binder.restoreCallingIdentity(origId);
            }
            int res = result.get();
            Slog.w("ActivityManager", "handleApplicationStrictModeViolation; res=" + res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStrictModeViolationToDropBox(ProcessRecord process, StrictMode.ViolationInfo info) {
        boolean needsFlush;
        boolean bufferWasEmpty;
        StringBuilder sb;
        if (info == null) {
            return;
        }
        boolean isSystemApp = process == null || (process.info.flags & 0x81) != 0;
        String processName = process == null ? "unknown" : process.processName;
        final String dropboxTag = isSystemApp ? "system_app_strictmode" : "data_app_strictmode";
        final DropBoxManager dbox = (DropBoxManager)this.mContext.getSystemService("dropbox");
        if (dbox == null || !dbox.isTagEnabled(dropboxTag)) {
            return;
        }
        StringBuilder stringBuilder = sb = isSystemApp ? this.mStrictModeBuffer : new StringBuilder(1024);
        synchronized (stringBuilder) {
            bufferWasEmpty = sb.length() == 0;
            this.appendDropBoxProcessHeaders(process, processName, sb);
            sb.append("Build: ").append(Build.FINGERPRINT).append("\n");
            sb.append("System-App: ").append(isSystemApp).append("\n");
            sb.append("Uptime-Millis: ").append(info.violationUptimeMillis).append("\n");
            if (info.violationNumThisLoop != 0) {
                sb.append("Loop-Violation-Number: ").append(info.violationNumThisLoop).append("\n");
            }
            if (info.numAnimationsRunning != 0) {
                sb.append("Animations-Running: ").append(info.numAnimationsRunning).append("\n");
            }
            if (info.broadcastIntentAction != null) {
                sb.append("Broadcast-Intent-Action: ").append(info.broadcastIntentAction).append("\n");
            }
            if (info.durationMillis != -1) {
                sb.append("Duration-Millis: ").append(info.durationMillis).append("\n");
            }
            if (info.numInstances != -1L) {
                sb.append("Instance-Count: ").append(info.numInstances).append("\n");
            }
            if (info.tags != null) {
                for (String tag : info.tags) {
                    sb.append("Span-Tag: ").append(tag).append("\n");
                }
            }
            sb.append("\n");
            if (info.crashInfo != null && info.crashInfo.stackTrace != null) {
                sb.append(info.crashInfo.stackTrace);
                sb.append("\n");
            }
            if (info.message != null) {
                sb.append(info.message);
                sb.append("\n");
            }
            needsFlush = sb.length() > 65536;
        }
        if (!isSystemApp || needsFlush) {
            new Thread("Error dump: " + dropboxTag){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String report;
                    StringBuilder stringBuilder = sb;
                    synchronized (stringBuilder) {
                        report = sb.toString();
                        sb.delete(0, sb.length());
                        sb.trimToSize();
                    }
                    if (report.length() != 0) {
                        dbox.addText(dropboxTag, report);
                    }
                }
            }.start();
            return;
        }
        if (!bufferWasEmpty) {
            return;
        }
        new Thread("Error dump: " + dropboxTag){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String errorReport;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                StringBuilder stringBuilder = ActivityManagerService.this.mStrictModeBuffer;
                synchronized (stringBuilder) {
                    errorReport = ActivityManagerService.this.mStrictModeBuffer.toString();
                    if (errorReport.length() == 0) {
                        return;
                    }
                    ActivityManagerService.this.mStrictModeBuffer.delete(0, ActivityManagerService.this.mStrictModeBuffer.length());
                    ActivityManagerService.this.mStrictModeBuffer.trimToSize();
                }
                dbox.addText(dropboxTag, errorReport);
            }
        }.start();
    }

    @Override
    public boolean handleApplicationWtf(final IBinder app, final String tag, boolean system, final ApplicationErrorReport.ParcelableCrashInfo crashInfo) {
        boolean isSystem;
        final int callingUid = Binder.getCallingUid();
        final int callingPid = Binder.getCallingPid();
        if (system) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ActivityManagerService.this.handleApplicationWtfInner(callingUid, callingPid, app, tag, crashInfo);
                }
            });
            return false;
        }
        ProcessRecord r = this.handleApplicationWtfInner(callingUid, callingPid, app, tag, crashInfo);
        boolean isFatal = "eng".equals(Build.TYPE) || Settings.Global.getInt(this.mContext.getContentResolver(), "wtf_is_fatal", 0) != 0;
        boolean bl = isSystem = r == null || r.persistent;
        if (isFatal && !isSystem) {
            this.mAppErrors.crashApplication(r, crashInfo);
            return true;
        }
        return false;
    }

    ProcessRecord handleApplicationWtfInner(int callingUid, int callingPid, IBinder app, String tag, ApplicationErrorReport.CrashInfo crashInfo) {
        ProcessRecord r = this.findAppProcess(app, "WTF");
        String processName = app == null ? "system_server" : (r == null ? "unknown" : r.processName);
        EventLog.writeEvent(30040, UserHandle.getUserId(callingUid), callingPid, processName, r == null ? -1 : r.info.flags, tag, crashInfo.exceptionMessage);
        this.addErrorToDropBox("wtf", r, processName, null, null, tag, null, null, crashInfo);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessRecord findAppProcess(IBinder app, String reason) {
        if (app == null) {
            return null;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int NP = this.mProcessNames.getMap().size();
            for (int ip = 0; ip < NP; ++ip) {
                SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
                int NA = apps.size();
                for (int ia = 0; ia < NA; ++ia) {
                    ProcessRecord p = apps.valueAt(ia);
                    if (p.thread == null || p.thread.asBinder() != app) continue;
                    return p;
                }
            }
            Slog.w("ActivityManager", "Can't find mystery application for " + reason + " from pid=" + Binder.getCallingPid() + " uid=" + Binder.getCallingUid() + ": " + app);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendDropBoxProcessHeaders(ProcessRecord process, String processName, StringBuilder sb) {
        if (process == null) {
            sb.append("Process: ").append(processName).append("\n");
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            sb.append("Process: ").append(processName).append("\n");
            sb.append("PID: ").append(process.pid).append("\n");
            int flags = process.info.flags;
            IPackageManager pm = AppGlobals.getPackageManager();
            sb.append("Flags: 0x").append(Integer.toHexString(flags)).append("\n");
            for (int ip = 0; ip < process.pkgList.size(); ++ip) {
                String pkg = process.pkgList.keyAt(ip);
                sb.append("Package: ").append(pkg);
                try {
                    PackageInfo pi = pm.getPackageInfo(pkg, 0, UserHandle.getCallingUserId());
                    if (pi != null) {
                        sb.append(" v").append(pi.versionCode);
                        if (pi.versionName != null) {
                            sb.append(" (").append(pi.versionName).append(")");
                        }
                    }
                }
                catch (RemoteException e) {
                    Slog.e("ActivityManager", "Error getting package info: " + pkg, e);
                }
                sb.append("\n");
            }
        }
    }

    private static String processClass(ProcessRecord process) {
        if (process == null || process.pid == MY_PID) {
            return "system_server";
        }
        if ((process.info.flags & 1) != 0) {
            return "system_app";
        }
        return "data_app";
    }

    public void addErrorToDropBox(String eventType, ProcessRecord process, String processName, ActivityRecord activity, ActivityRecord parent, String subject, final String report, final File dataFile, final ApplicationErrorReport.CrashInfo crashInfo) {
        if (ServiceManager.getService("dropbox") == null) {
            return;
        }
        final DropBoxManager dbox = this.mContext.getSystemService(DropBoxManager.class);
        final String dropboxTag = ActivityManagerService.processClass(process) + "_" + eventType;
        if (dbox == null || !dbox.isTagEnabled(dropboxTag)) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        if (now - this.mWtfClusterStart > 10000L) {
            this.mWtfClusterStart = now;
            this.mWtfClusterCount = 1;
        } else if (this.mWtfClusterCount++ >= 5) {
            return;
        }
        final StringBuilder sb = new StringBuilder(1024);
        this.appendDropBoxProcessHeaders(process, processName, sb);
        if (process != null) {
            sb.append("Foreground: ").append(process.isInterestingToUserLocked() ? "Yes" : "No").append("\n");
        }
        if (activity != null) {
            sb.append("Activity: ").append(activity.shortComponentName).append("\n");
        }
        if (parent != null && parent.app != null && parent.app.pid != process.pid) {
            sb.append("Parent-Process: ").append(parent.app.processName).append("\n");
        }
        if (parent != null && parent != activity) {
            sb.append("Parent-Activity: ").append(parent.shortComponentName).append("\n");
        }
        if (subject != null) {
            sb.append("Subject: ").append(subject).append("\n");
        }
        sb.append("Build: ").append(Build.FINGERPRINT).append("\n");
        if (Debug.isDebuggerConnected()) {
            sb.append("Debugger: Connected\n");
        }
        sb.append("\n");
        Thread worker = new Thread("Error dump: " + dropboxTag){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (report != null) {
                    sb.append(report);
                }
                String setting = "logcat_for_" + dropboxTag;
                int lines = Settings.Global.getInt(ActivityManagerService.this.mContext.getContentResolver(), setting, 0);
                int maxDataFileSize = 196608 - sb.length() - lines * 100;
                if (dataFile != null && maxDataFileSize > 0) {
                    try {
                        sb.append(FileUtils.readTextFile(dataFile, maxDataFileSize, "\n\n[[TRUNCATED]]"));
                    }
                    catch (IOException e) {
                        Slog.e("ActivityManager", "Error reading " + dataFile, e);
                    }
                }
                if (crashInfo != null && crashInfo.stackTrace != null) {
                    sb.append(crashInfo.stackTrace);
                }
                if (lines > 0) {
                    sb.append("\n");
                    InputStreamReader input = null;
                    try {
                        int num;
                        Process logcat = new ProcessBuilder("/system/bin/timeout", "-k", "15s", "10s", "/system/bin/logcat", "-v", "threadtime", "-b", "events", "-b", "system", "-b", "main", "-b", "crash", "-t", String.valueOf(lines)).redirectErrorStream(true).start();
                        try {
                            logcat.getOutputStream().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            logcat.getErrorStream().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        input = new InputStreamReader(logcat.getInputStream());
                        char[] buf = new char[8192];
                        while ((num = input.read(buf)) > 0) {
                            sb.append(buf, 0, num);
                        }
                    }
                    catch (IOException e) {
                        Slog.e("ActivityManager", "Error running logcat", e);
                    }
                    finally {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                dbox.addText(dropboxTag, sb.toString());
            }
        };
        if (process == null) {
            worker.run();
        } else {
            worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.ProcessErrorStateInfo> getProcessesInErrorState() {
        this.enforceNotIsolatedCaller("getProcessesInErrorState");
        ArrayList<ActivityManager.ProcessErrorStateInfo> errList = null;
        boolean allUsers = ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", Binder.getCallingUid()) == 0;
        int userId = UserHandle.getUserId(Binder.getCallingUid());
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (!allUsers && app.userId != userId || app.thread == null || !app.crashing && !app.notResponding) continue;
                ActivityManager.ProcessErrorStateInfo report = null;
                if (app.crashing) {
                    report = app.crashingReport;
                } else if (app.notResponding) {
                    report = app.notRespondingReport;
                }
                if (report != null) {
                    if (errList == null) {
                        errList = new ArrayList<ActivityManager.ProcessErrorStateInfo>(1);
                    }
                    errList.add(report);
                    continue;
                }
                Slog.w("ActivityManager", "Missing app error report, app = " + app.processName + " crashing = " + app.crashing + " notResponding = " + app.notResponding);
            }
        }
        return errList;
    }

    static int procStateToImportance(int procState, int memAdj, ActivityManager.RunningAppProcessInfo currApp, int clientTargetSdk) {
        int imp = ActivityManager.RunningAppProcessInfo.procStateToImportanceForTargetSdk(procState, clientTargetSdk);
        currApp.lru = imp == 400 ? memAdj : 0;
        return imp;
    }

    private void fillInProcMemInfo(ProcessRecord app, ActivityManager.RunningAppProcessInfo outInfo, int clientTargetSdk) {
        outInfo.pid = app.pid;
        outInfo.uid = app.info.uid;
        if (this.mHeavyWeightProcess == app) {
            outInfo.flags |= 1;
        }
        if (app.persistent) {
            outInfo.flags |= 2;
        }
        if (app.activities.size() > 0) {
            outInfo.flags |= 4;
        }
        outInfo.lastTrimLevel = app.trimMemoryLevel;
        int adj = app.curAdj;
        int procState = app.curProcState;
        outInfo.importance = ActivityManagerService.procStateToImportance(procState, adj, outInfo, clientTargetSdk);
        outInfo.importanceReasonCode = app.adjTypeCode;
        outInfo.processState = app.curProcState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() {
        this.enforceNotIsolatedCaller("getRunningAppProcesses");
        int callingUid = Binder.getCallingUid();
        int clientTargetSdk = this.mPackageManagerInt.getUidTargetSdkVersion(callingUid);
        ArrayList<ActivityManager.RunningAppProcessInfo> runList = null;
        boolean allUsers = ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingUid) == 0;
        int userId = UserHandle.getUserId(callingUid);
        boolean allUids = this.isGetTasksAllowed("getRunningAppProcesses", Binder.getCallingPid(), callingUid);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (!allUsers && app.userId != userId || !allUids && app.uid != callingUid || app.thread == null || app.crashing || app.notResponding) continue;
                ActivityManager.RunningAppProcessInfo currApp = new ActivityManager.RunningAppProcessInfo(app.processName, app.pid, app.getPackageList());
                this.fillInProcMemInfo(app, currApp, clientTargetSdk);
                if (app.adjSource instanceof ProcessRecord) {
                    currApp.importanceReasonPid = ((ProcessRecord)app.adjSource).pid;
                    currApp.importanceReasonImportance = ActivityManager.RunningAppProcessInfo.procStateToImportance(app.adjSourceProcState);
                } else if (app.adjSource instanceof ActivityRecord) {
                    ActivityRecord r = (ActivityRecord)app.adjSource;
                    if (r.app != null) {
                        currApp.importanceReasonPid = r.app.pid;
                    }
                }
                if (app.adjTarget instanceof ComponentName) {
                    currApp.importanceReasonComponent = (ComponentName)app.adjTarget;
                }
                if (runList == null) {
                    runList = new ArrayList<ActivityManager.RunningAppProcessInfo>();
                }
                runList.add(currApp);
            }
        }
        return runList;
    }

    @Override
    public List<ApplicationInfo> getRunningExternalApplications() {
        this.enforceNotIsolatedCaller("getRunningExternalApplications");
        List<ActivityManager.RunningAppProcessInfo> runningApps = this.getRunningAppProcesses();
        ArrayList<ApplicationInfo> retList = new ArrayList<ApplicationInfo>();
        if (runningApps != null && runningApps.size() > 0) {
            HashSet<String> extList = new HashSet<String>();
            for (ActivityManager.RunningAppProcessInfo app : runningApps) {
                if (app.pkgList == null) continue;
                for (String pkg : app.pkgList) {
                    extList.add(pkg);
                }
            }
            IPackageManager pm = AppGlobals.getPackageManager();
            for (String pkg : extList) {
                try {
                    ApplicationInfo info = pm.getApplicationInfo(pkg, 0, UserHandle.getCallingUserId());
                    if ((info.flags & 0x40000) == 0) continue;
                    retList.add(info);
                }
                catch (RemoteException remoteException) {}
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMyMemoryState(ActivityManager.RunningAppProcessInfo outInfo) {
        this.enforceNotIsolatedCaller("getMyMemoryState");
        int callingUid = Binder.getCallingUid();
        int clientTargetSdk = this.mPackageManagerInt.getUidTargetSdkVersion(callingUid);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord proc;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                proc = this.mPidsSelfLocked.get(Binder.getCallingPid());
            }
            this.fillInProcMemInfo(proc, outInfo, clientTargetSdk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMemoryTrimLevel() {
        this.enforceNotIsolatedCaller("getMyMemoryState");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mLastMemoryLevel;
        }
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new ActivityManagerShellCommand(this, false).exec(this, in, out, err, args, callback, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, "ActivityManager", pw)) {
            return;
        }
        boolean dumpAll = false;
        boolean dumpClient = false;
        boolean dumpCheckin = false;
        boolean dumpCheckinFormat = false;
        boolean dumpVisibleStacksOnly = false;
        boolean dumpFocusedStackOnly = false;
        String dumpPackage = null;
        int opti = 0;
        while (opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-') {
            ++opti;
            if ("-a".equals(opt)) {
                dumpAll = true;
                continue;
            }
            if ("-c".equals(opt)) {
                dumpClient = true;
                continue;
            }
            if ("-v".equals(opt)) {
                dumpVisibleStacksOnly = true;
                continue;
            }
            if ("-f".equals(opt)) {
                dumpFocusedStackOnly = true;
                continue;
            }
            if ("-p".equals(opt)) {
                if (opti >= args.length) {
                    pw.println("Error: -p option requires package argument");
                    return;
                }
                dumpPackage = args[opti];
                ++opti;
                dumpClient = true;
                continue;
            }
            if ("--checkin".equals(opt)) {
                dumpCheckinFormat = true;
                dumpCheckin = true;
                continue;
            }
            if ("-C".equals(opt)) {
                dumpCheckinFormat = true;
                continue;
            }
            if ("-h".equals(opt)) {
                ActivityManagerShellCommand.dumpHelp(pw, true);
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        long origId = Binder.clearCallingIdentity();
        boolean more = false;
        if (opti < args.length) {
            ActivityManagerShellCommand activityManagerShellCommand;
            int res;
            String cmd = args[opti];
            ++opti;
            if ("activities".equals(cmd) || "a".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                this.dumpActivitiesLocked(fd, pw, args, opti, true, dumpClient, dumpPackage);
                // MONITOREXIT : activityManagerService
            } else if ("lastanr".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                this.dumpLastANRLocked(pw);
                // MONITOREXIT : activityManagerService
            } else if ("starter".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                this.dumpActivityStarterLocked(pw);
                // MONITOREXIT : activityManagerService
            } else if ("recents".equals(cmd) || "r".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                this.dumpRecentsLocked(fd, pw, args, opti, true, dumpPackage);
                // MONITOREXIT : activityManagerService
            } else if ("broadcasts".equals(cmd) || "b".equals(cmd)) {
                if (opti >= args.length) {
                    Object name = null;
                    String[] stringArray = EMPTY_STRING_ARRAY;
                } else {
                    dumpPackage = args[opti];
                    String[] stringArray = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, stringArray, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                this.dumpBroadcastsLocked(fd, pw, args, opti, true, dumpPackage);
                // MONITOREXIT : activityManagerService
            } else if ("broadcast-stats".equals(cmd)) {
                if (opti >= args.length) {
                    Object name = null;
                    String[] stringArray = EMPTY_STRING_ARRAY;
                } else {
                    dumpPackage = args[opti];
                    String[] stringArray = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, stringArray, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                if (dumpCheckinFormat) {
                    this.dumpBroadcastStatsCheckinLocked(fd, pw, args, opti, dumpCheckin, dumpPackage);
                } else {
                    this.dumpBroadcastStatsLocked(fd, pw, args, opti, true, dumpPackage);
                }
                // MONITOREXIT : activityManagerService
            } else if ("intents".equals(cmd) || "i".equals(cmd)) {
                if (opti >= args.length) {
                    Object name = null;
                    String[] stringArray = EMPTY_STRING_ARRAY;
                } else {
                    dumpPackage = args[opti];
                    String[] stringArray = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, stringArray, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                this.dumpPendingIntentsLocked(fd, pw, args, opti, true, dumpPackage);
                // MONITOREXIT : activityManagerService
            } else if ("processes".equals(cmd) || "p".equals(cmd)) {
                if (opti >= args.length) {
                    Object name = null;
                    String[] stringArray = EMPTY_STRING_ARRAY;
                } else {
                    dumpPackage = args[opti];
                    String[] stringArray = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, stringArray, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                this.dumpProcessesLocked(fd, pw, args, opti, true, dumpPackage);
                // MONITOREXIT : activityManagerService
            } else if ("oom".equals(cmd) || "o".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                this.dumpOomLocked(fd, pw, args, opti, true);
                // MONITOREXIT : activityManagerService
            } else if ("permissions".equals(cmd) || "perm".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                this.dumpPermissionsLocked(fd, pw, args, opti, true, null);
                // MONITOREXIT : activityManagerService
            } else if ("provider".equals(cmd)) {
                void var17_36;
                String name;
                if (opti >= args.length) {
                    name = null;
                    String[] stringArray = EMPTY_STRING_ARRAY;
                } else {
                    name = args[opti];
                    String[] stringArray = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, stringArray, 0, args.length - opti);
                    }
                }
                if (!this.dumpProvider(fd, pw, name, (String[])var17_36, 0, dumpAll)) {
                    pw.println("No providers match: " + name);
                    pw.println("Use -h for help.");
                }
            } else if ("providers".equals(cmd) || "prov".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                this.dumpProvidersLocked(fd, pw, args, opti, true, null);
                // MONITOREXIT : activityManagerService
            } else if ("service".equals(cmd)) {
                void var17_40;
                String name;
                if (opti >= args.length) {
                    name = null;
                    String[] stringArray = EMPTY_STRING_ARRAY;
                } else {
                    name = args[opti];
                    String[] stringArray = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, stringArray, 0, args.length - opti);
                    }
                }
                if (!this.mServices.dumpService(fd, pw, name, (String[])var17_40, 0, dumpAll)) {
                    pw.println("No services match: " + name);
                    pw.println("Use -h for help.");
                }
            } else if ("package".equals(cmd)) {
                if (opti >= args.length) {
                    pw.println("package: no package name specified");
                    pw.println("Use -h for help.");
                } else {
                    dumpPackage = args[opti];
                    String[] stringArray = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, stringArray, 0, args.length - opti);
                    }
                    args = stringArray;
                    opti = 0;
                    more = true;
                }
            } else if ("associations".equals(cmd) || "as".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                this.dumpAssociationsLocked(fd, pw, args, opti, true, dumpClient, dumpPackage);
                // MONITOREXIT : activityManagerService
            } else if ("settings".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                this.mConstants.dump(pw);
                // MONITOREXIT : activityManagerService
            } else if ("services".equals(cmd) || "s".equals(cmd)) {
                if (dumpClient) {
                    ActivityManagerService name = this;
                    // MONITORENTER : name
                    ActiveServices.ServiceDumper serviceDumper = this.mServices.newServiceDumperLocked(fd, pw, args, opti, true, dumpPackage);
                    // MONITOREXIT : name
                    serviceDumper.dumpWithClient();
                } else {
                    ActivityManagerService activityManagerService = this;
                    // MONITORENTER : activityManagerService
                    this.mServices.newServiceDumperLocked(fd, pw, args, opti, true, dumpPackage).dumpLocked();
                    // MONITOREXIT : activityManagerService
                }
            } else if ("locks".equals(cmd)) {
                LockGuard.dump(fd, pw, args);
            } else if (!this.dumpActivity(fd, pw, cmd, args, opti, dumpAll, dumpVisibleStacksOnly, dumpFocusedStackOnly) && (res = (activityManagerShellCommand = new ActivityManagerShellCommand(this, true)).exec(this, null, fd, null, args, null, new ResultReceiver(null))) < 0) {
                pw.println("Bad activity command, or no activities match: " + cmd);
                pw.println("Use -h for help.");
            }
            if (!more) {
                Binder.restoreCallingIdentity(origId);
                return;
            }
        }
        if (dumpCheckinFormat) {
            this.dumpBroadcastStatsCheckinLocked(fd, pw, args, opti, dumpCheckin, dumpPackage);
        } else if (dumpClient) {
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            this.mConstants.dump(pw);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpPendingIntentsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpBroadcastsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            if (dumpAll || dumpPackage != null) {
                this.dumpBroadcastStatsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
            }
            this.dumpProvidersLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpPermissionsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            ActiveServices.ServiceDumper sdumper = this.mServices.newServiceDumperLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            // MONITOREXIT : activityManagerService
            sdumper.dumpWithClient();
            pw.println();
            ActivityManagerService activityManagerService2 = this;
            // MONITORENTER : activityManagerService2
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpRecentsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpLastANRLocked(pw);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpActivityStarterLocked(pw);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpActivitiesLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
            if (this.mAssociations.size() > 0) {
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpAssociationsLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
            }
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpProcessesLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            // MONITOREXIT : activityManagerService2
        } else {
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            this.mConstants.dump(pw);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpPendingIntentsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpBroadcastsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            if (dumpAll || dumpPackage != null) {
                this.dumpBroadcastStatsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
            }
            this.dumpProvidersLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpPermissionsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.mServices.newServiceDumperLocked(fd, pw, args, opti, dumpAll, dumpPackage).dumpLocked();
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpRecentsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpLastANRLocked(pw);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpActivityStarterLocked(pw);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpActivitiesLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
            if (this.mAssociations.size() > 0) {
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpAssociationsLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
            }
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpProcessesLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            // MONITOREXIT : activityManagerService
        }
        Binder.restoreCallingIdentity(origId);
    }

    private void dumpLastANRLocked(PrintWriter pw) {
        pw.println("ACTIVITY MANAGER ACTIVITIES (dumpsys activity lastanr)");
        if (this.mLastANRState == null) {
            pw.println("  <no ANR has occurred since boot>");
        } else {
            pw.println(this.mLastANRState);
        }
    }

    private void dumpActivityStarterLocked(PrintWriter pw) {
        pw.println("ACTIVITY MANAGER ACTIVITIES (dumpsys activity starter)");
        this.mActivityStarter.dump(pw, "");
    }

    void dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        this.dumpActivitiesLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage, "ACTIVITY MANAGER ACTIVITIES (dumpsys activity activities)");
    }

    void dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, boolean dumpClient, String dumpPackage, String header) {
        boolean printedAnything;
        pw.println(header);
        boolean needSep = printedAnything = this.mStackSupervisor.dumpActivitiesLocked(fd, pw, dumpAll, dumpClient, dumpPackage);
        boolean printed = ActivityStackSupervisor.printThisActivity(pw, this.mStackSupervisor.getResumedActivityLocked(), dumpPackage, needSep, "  ResumedActivity: ");
        if (printed) {
            printedAnything = true;
            needSep = false;
        }
        if (dumpPackage == null) {
            if (needSep) {
                pw.println();
            }
            printedAnything = true;
            this.mStackSupervisor.dump(pw, "  ");
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpRecentsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        pw.println("ACTIVITY MANAGER RECENT TASKS (dumpsys activity recents)");
        boolean printedAnything = false;
        if (this.mRecentTasks != null && this.mRecentTasks.size() > 0) {
            boolean printedHeader = false;
            int N = this.mRecentTasks.size();
            for (int i = 0; i < N; ++i) {
                TaskRecord tr = (TaskRecord)this.mRecentTasks.get(i);
                if (dumpPackage != null && (tr.realActivity == null || !dumpPackage.equals(tr.realActivity.getPackageName()))) continue;
                if (!printedHeader) {
                    pw.println("  Recent tasks:");
                    printedHeader = true;
                    printedAnything = true;
                }
                pw.print("  * Recent #");
                pw.print(i);
                pw.print(": ");
                pw.println(tr);
                if (!dumpAll) continue;
                ((TaskRecord)this.mRecentTasks.get(i)).dump(pw, "    ");
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpAssociationsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        pw.println("ACTIVITY MANAGER ASSOCIATIONS (dumpsys activity associations)");
        int dumpUid = 0;
        if (dumpPackage != null) {
            IPackageManager pm = AppGlobals.getPackageManager();
            try {
                dumpUid = pm.getPackageUid(dumpPackage, 0x400000, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        boolean printedAnything = false;
        long now = SystemClock.uptimeMillis();
        int N1 = this.mAssociations.size();
        for (int i1 = 0; i1 < N1; ++i1) {
            ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>> targetComponents = this.mAssociations.valueAt(i1);
            int N2 = targetComponents.size();
            for (int i2 = 0; i2 < N2; ++i2) {
                SparseArray<ArrayMap<String, Association>> sourceUids = targetComponents.valueAt(i2);
                int N3 = sourceUids.size();
                for (int i3 = 0; i3 < N3; ++i3) {
                    ArrayMap<String, Association> sourceProcesses = sourceUids.valueAt(i3);
                    int N4 = sourceProcesses.size();
                    for (int i4 = 0; i4 < N4; ++i4) {
                        Association ass = sourceProcesses.valueAt(i4);
                        if (dumpPackage != null && !ass.mTargetComponent.getPackageName().equals(dumpPackage) && UserHandle.getAppId(ass.mSourceUid) != dumpUid) continue;
                        printedAnything = true;
                        pw.print("  ");
                        pw.print(ass.mTargetProcess);
                        pw.print("/");
                        UserHandle.formatUid(pw, ass.mTargetUid);
                        pw.print(" <- ");
                        pw.print(ass.mSourceProcess);
                        pw.print("/");
                        UserHandle.formatUid(pw, ass.mSourceUid);
                        pw.println();
                        pw.print("    via ");
                        pw.print(ass.mTargetComponent.flattenToShortString());
                        pw.println();
                        pw.print("    ");
                        long dur = ass.mTime;
                        if (ass.mNesting > 0) {
                            dur += now - ass.mStartTime;
                        }
                        TimeUtils.formatDuration(dur, pw);
                        pw.print(" (");
                        pw.print(ass.mCount);
                        pw.print(" times)");
                        pw.print("  ");
                        for (int i = 0; i < ass.mStateTimes.length; ++i) {
                            long amt = ass.mStateTimes[i];
                            if (ass.mLastState - 0 == i) {
                                amt += now - ass.mLastStateUptime;
                            }
                            if (amt == 0L) continue;
                            pw.print(" ");
                            pw.print(ProcessList.makeProcStateString(i + 0));
                            pw.print("=");
                            TimeUtils.formatDuration(amt, pw);
                            if (ass.mLastState - 0 != i) continue;
                            pw.print("*");
                        }
                        pw.println();
                        if (ass.mNesting <= 0) continue;
                        pw.print("    Currently active: ");
                        TimeUtils.formatDuration(now - ass.mStartTime, pw);
                        pw.println();
                    }
                }
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    boolean dumpUids(PrintWriter pw, String dumpPackage, SparseArray<UidRecord> uids, String header, boolean needSep) {
        boolean printed = false;
        int whichAppId = -1;
        if (dumpPackage != null) {
            try {
                ApplicationInfo info = this.mContext.getPackageManager().getApplicationInfo(dumpPackage, 0);
                whichAppId = UserHandle.getAppId(info.uid);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < uids.size(); ++i) {
            UidRecord uidRec = uids.valueAt(i);
            if (dumpPackage != null && UserHandle.getAppId(uidRec.uid) != whichAppId) continue;
            if (!printed) {
                printed = true;
                if (needSep) {
                    pw.println();
                }
                pw.print("  ");
                pw.println(header);
                needSep = true;
            }
            pw.print("    UID ");
            UserHandle.formatUid(pw, uidRec.uid);
            pw.print(": ");
            pw.println(uidRec);
        }
        return printed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpProcessesLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean printed;
        int i;
        boolean printed2;
        boolean needSep = false;
        boolean printedAnything = false;
        int numPers = 0;
        pw.println("ACTIVITY MANAGER RUNNING PROCESSES (dumpsys activity processes)");
        if (dumpAll) {
            int NP = this.mProcessNames.getMap().size();
            for (int ip = 0; ip < NP; ++ip) {
                SparseArray<ProcessRecord> procs = this.mProcessNames.getMap().valueAt(ip);
                int NA = procs.size();
                for (int ia = 0; ia < NA; ++ia) {
                    ProcessRecord r = procs.valueAt(ia);
                    if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                    if (!needSep) {
                        pw.println("  All known processes:");
                        needSep = true;
                        printedAnything = true;
                    }
                    pw.print(r.persistent ? "  *PERS*" : "  *APP*");
                    pw.print(" UID ");
                    pw.print(procs.keyAt(ia));
                    pw.print(" ");
                    pw.println(r);
                    r.dump(pw, "    ");
                    if (!r.persistent) continue;
                    ++numPers;
                }
            }
        }
        if (this.mIsolatedProcesses.size() > 0) {
            printed2 = false;
            for (i = 0; i < this.mIsolatedProcesses.size(); ++i) {
                ProcessRecord r = this.mIsolatedProcesses.valueAt(i);
                if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                if (!printed2) {
                    if (needSep) {
                        pw.println();
                    }
                    pw.println("  Isolated process list (sorted by uid):");
                    printedAnything = true;
                    printed2 = true;
                    needSep = true;
                }
                pw.print("    Isolated #");
                pw.print(i);
                pw.print(": ");
                pw.println(r);
            }
        }
        if (this.mActiveInstrumentation.size() > 0) {
            printed2 = false;
            for (i = 0; i < this.mActiveInstrumentation.size(); ++i) {
                ActiveInstrumentation ai = this.mActiveInstrumentation.get(i);
                if (dumpPackage != null && !ai.mClass.getPackageName().equals(dumpPackage) && !ai.mTargetInfo.packageName.equals(dumpPackage)) continue;
                if (!printed2) {
                    if (needSep) {
                        pw.println();
                    }
                    pw.println("  Active instrumentation:");
                    printedAnything = true;
                    printed2 = true;
                    needSep = true;
                }
                pw.print("    Instrumentation #");
                pw.print(i);
                pw.print(": ");
                pw.println(ai);
                ai.dump(pw, "      ");
            }
        }
        if (this.mActiveUids.size() > 0 && this.dumpUids(pw, dumpPackage, this.mActiveUids, "UID states:", needSep)) {
            needSep = true;
            printedAnything = true;
        }
        if (dumpAll && this.mValidateUids.size() > 0 && this.dumpUids(pw, dumpPackage, this.mValidateUids, "UID validation:", needSep)) {
            needSep = true;
            printedAnything = true;
        }
        if (this.mLruProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            pw.print("  Process LRU list (sorted by oom_adj, ");
            pw.print(this.mLruProcesses.size());
            pw.print(" total, non-act at ");
            pw.print(this.mLruProcesses.size() - this.mLruProcessActivityStart);
            pw.print(", non-svc at ");
            pw.print(this.mLruProcesses.size() - this.mLruProcessServiceStart);
            pw.println("):");
            ActivityManagerService.dumpProcessOomList(pw, this, this.mLruProcesses, "    ", "Proc", "PERS", false, dumpPackage);
            needSep = true;
            printedAnything = true;
        }
        if (dumpAll || dumpPackage != null) {
            SparseArray<ProcessRecord> printed3 = this.mPidsSelfLocked;
            synchronized (printed3) {
                printed = false;
                for (int i2 = 0; i2 < this.mPidsSelfLocked.size(); ++i2) {
                    ProcessRecord r = this.mPidsSelfLocked.valueAt(i2);
                    if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  PID mappings:");
                        printed = true;
                        printedAnything = true;
                    }
                    pw.print("    PID #");
                    pw.print(this.mPidsSelfLocked.keyAt(i2));
                    pw.print(": ");
                    pw.println(this.mPidsSelfLocked.valueAt(i2));
                }
            }
        }
        if (this.mImportantProcesses.size() > 0) {
            SparseArray<ProcessRecord> printed3 = this.mPidsSelfLocked;
            synchronized (printed3) {
                printed = false;
                for (int i3 = 0; i3 < this.mImportantProcesses.size(); ++i3) {
                    ProcessRecord r = this.mPidsSelfLocked.get(this.mImportantProcesses.valueAt((int)i3).pid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  Foreground Processes:");
                        printed = true;
                        printedAnything = true;
                    }
                    pw.print("    PID #");
                    pw.print(this.mImportantProcesses.keyAt(i3));
                    pw.print(": ");
                    pw.println(this.mImportantProcesses.valueAt(i3));
                }
            }
        }
        if (this.mPersistentStartingProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            printedAnything = true;
            pw.println("  Persisent processes that are starting:");
            ActivityManagerService.dumpProcessList(pw, this, this.mPersistentStartingProcesses, "    ", "Starting Norm", "Restarting PERS", dumpPackage);
        }
        if (this.mRemovedProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            printedAnything = true;
            pw.println("  Processes that are being removed:");
            ActivityManagerService.dumpProcessList(pw, this, this.mRemovedProcesses, "    ", "Removed Norm", "Removed PERS", dumpPackage);
        }
        if (this.mProcessesOnHold.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            printedAnything = true;
            pw.println("  Processes that are on old until the system is ready:");
            ActivityManagerService.dumpProcessList(pw, this, this.mProcessesOnHold, "    ", "OnHold Norm", "OnHold PERS", dumpPackage);
        }
        needSep = this.dumpProcessesToGc(fd, pw, args, opti, needSep, dumpAll, dumpPackage);
        if (needSep = this.mAppErrors.dumpLocked(fd, pw, needSep, dumpPackage)) {
            printedAnything = true;
        }
        if (dumpPackage == null) {
            pw.println();
            needSep = false;
            this.mUserController.dump(pw, dumpAll);
        }
        if (this.mHomeProcess != null && (dumpPackage == null || this.mHomeProcess.pkgList.containsKey(dumpPackage))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mHomeProcess: " + this.mHomeProcess);
        }
        if (this.mPreviousProcess != null && (dumpPackage == null || this.mPreviousProcess.pkgList.containsKey(dumpPackage))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mPreviousProcess: " + this.mPreviousProcess);
        }
        if (dumpAll) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("  mPreviousProcessVisibleTime: ");
            TimeUtils.formatDuration(this.mPreviousProcessVisibleTime, sb);
            pw.println(sb);
        }
        if (this.mHeavyWeightProcess != null && (dumpPackage == null || this.mHeavyWeightProcess.pkgList.containsKey(dumpPackage))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mHeavyWeightProcess: " + this.mHeavyWeightProcess);
        }
        if (dumpPackage == null) {
            pw.println("  mGlobalConfiguration: " + this.getGlobalConfiguration());
            this.mStackSupervisor.dumpDisplayConfigs(pw, "  ");
        }
        if (dumpAll) {
            int i4;
            pw.println("  mConfigWillChange: " + this.getFocusedStack().mConfigWillChange);
            if (this.mCompatModePackages.getPackages().size() > 0) {
                boolean printed4 = false;
                for (Map.Entry<String, Integer> entry : this.mCompatModePackages.getPackages().entrySet()) {
                    String pkg = entry.getKey();
                    int mode = entry.getValue();
                    if (dumpPackage != null && !dumpPackage.equals(pkg)) continue;
                    if (!printed4) {
                        pw.println("  mScreenCompatPackages:");
                        printed4 = true;
                    }
                    pw.print("    ");
                    pw.print(pkg);
                    pw.print(": ");
                    pw.print(mode);
                    pw.println();
                }
            }
            int NI = this.mUidObservers.getRegisteredCallbackCount();
            printed = false;
            for (i4 = 0; i4 < NI; ++i4) {
                UidObserverRegistration reg = (UidObserverRegistration)this.mUidObservers.getRegisteredCallbackCookie(i4);
                if (dumpPackage != null && !dumpPackage.equals(reg.pkg)) continue;
                if (!printed) {
                    pw.println("  mUidObservers:");
                    printed = true;
                }
                pw.print("    ");
                UserHandle.formatUid(pw, reg.uid);
                pw.print(" ");
                pw.print(reg.pkg);
                pw.print(":");
                if ((reg.which & 4) != 0) {
                    pw.print(" IDLE");
                }
                if ((reg.which & 8) != 0) {
                    pw.print(" ACT");
                }
                if ((reg.which & 2) != 0) {
                    pw.print(" GONE");
                }
                if ((reg.which & 1) != 0) {
                    pw.print(" STATE");
                    pw.print(" (cut=");
                    pw.print(reg.cutpoint);
                    pw.print(")");
                }
                pw.println();
                if (reg.lastProcStates == null) continue;
                int NJ = reg.lastProcStates.size();
                for (int j = 0; j < NJ; ++j) {
                    pw.print("      Last ");
                    UserHandle.formatUid(pw, reg.lastProcStates.keyAt(j));
                    pw.print(": ");
                    pw.println(reg.lastProcStates.valueAt(j));
                }
            }
            pw.println("  mDeviceIdleWhitelist=" + Arrays.toString(this.mDeviceIdleWhitelist));
            pw.println("  mDeviceIdleTempWhitelist=" + Arrays.toString(this.mDeviceIdleTempWhitelist));
            if (this.mPendingTempWhitelist.size() > 0) {
                pw.println("  mPendingTempWhitelist:");
                for (i4 = 0; i4 < this.mPendingTempWhitelist.size(); ++i4) {
                    PendingTempWhitelist ptw = this.mPendingTempWhitelist.valueAt(i4);
                    pw.print("    ");
                    UserHandle.formatUid(pw, ptw.targetUid);
                    pw.print(": ");
                    TimeUtils.formatDuration(ptw.duration, pw);
                    pw.print(" ");
                    pw.println(ptw.tag);
                }
            }
        }
        if (dumpPackage == null) {
            pw.println("  mWakefulness=" + PowerManagerInternal.wakefulnessToString(this.mWakefulness));
            pw.println("  mSleepTokens=" + this.mSleepTokens);
            pw.println("  mSleeping=" + this.mSleeping);
            pw.println("  mShuttingDown=" + this.mShuttingDown + " mTestPssMode=" + this.mTestPssMode);
            if (this.mRunningVoice != null) {
                pw.println("  mRunningVoice=" + this.mRunningVoice);
                pw.println("  mVoiceWakeLock" + this.mVoiceWakeLock);
            }
        }
        pw.println("  mVrController=" + this.mVrController);
        if ((this.mDebugApp != null || this.mOrigDebugApp != null || this.mDebugTransient || this.mOrigWaitForDebugger) && (dumpPackage == null || dumpPackage.equals(this.mDebugApp) || dumpPackage.equals(this.mOrigDebugApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mDebugApp=" + this.mDebugApp + "/orig=" + this.mOrigDebugApp + " mDebugTransient=" + this.mDebugTransient + " mOrigWaitForDebugger=" + this.mOrigWaitForDebugger);
        }
        if (this.mCurAppTimeTracker != null) {
            this.mCurAppTimeTracker.dumpWithHeader(pw, "  ", true);
        }
        if (this.mMemWatchProcesses.getMap().size() > 0) {
            pw.println("  Mem watch processes:");
            ArrayMap<String, SparseArray<Pair<Long, String>>> procs = this.mMemWatchProcesses.getMap();
            for (i = 0; i < procs.size(); ++i) {
                String proc = procs.keyAt(i);
                SparseArray<Pair<Long, String>> uids = procs.valueAt(i);
                for (int j = 0; j < uids.size(); ++j) {
                    if (needSep) {
                        pw.println();
                        needSep = false;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("    ").append(proc).append('/');
                    UserHandle.formatUid(sb, uids.keyAt(j));
                    Pair<Long, String> val = uids.valueAt(j);
                    sb.append(": ");
                    DebugUtils.sizeValueToString((Long)val.first, sb);
                    if (val.second != null) {
                        sb.append(", report to ").append((String)val.second);
                    }
                    pw.println(sb.toString());
                }
            }
            pw.print("  mMemWatchDumpProcName=");
            pw.println(this.mMemWatchDumpProcName);
            pw.print("  mMemWatchDumpFile=");
            pw.println(this.mMemWatchDumpFile);
            pw.print("  mMemWatchDumpPid=");
            pw.print(this.mMemWatchDumpPid);
            pw.print(" mMemWatchDumpUid=");
            pw.println(this.mMemWatchDumpUid);
        }
        if (this.mTrackAllocationApp != null && (dumpPackage == null || dumpPackage.equals(this.mTrackAllocationApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mTrackAllocationApp=" + this.mTrackAllocationApp);
        }
        if (!(this.mProfileApp == null && this.mProfileProc == null && this.mProfileFile == null && this.mProfileFd == null || dumpPackage != null && !dumpPackage.equals(this.mProfileApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mProfileApp=" + this.mProfileApp + " mProfileProc=" + this.mProfileProc);
            pw.println("  mProfileFile=" + this.mProfileFile + " mProfileFd=" + this.mProfileFd);
            pw.println("  mSamplingInterval=" + this.mSamplingInterval + " mAutoStopProfiler=" + this.mAutoStopProfiler + " mStreamingOutput=" + this.mStreamingOutput);
            pw.println("  mProfileType=" + this.mProfileType);
        }
        if (this.mNativeDebuggingApp != null && (dumpPackage == null || dumpPackage.equals(this.mNativeDebuggingApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mNativeDebuggingApp=" + this.mNativeDebuggingApp);
        }
        if (dumpPackage == null) {
            if (this.mAlwaysFinishActivities) {
                pw.println("  mAlwaysFinishActivities=" + this.mAlwaysFinishActivities);
            }
            if (this.mController != null) {
                pw.println("  mController=" + this.mController + " mControllerIsAMonkey=" + this.mControllerIsAMonkey);
            }
            if (dumpAll) {
                pw.println("  Total persistent processes: " + numPers);
                pw.println("  mProcessesReady=" + this.mProcessesReady + " mSystemReady=" + this.mSystemReady + " mBooted=" + this.mBooted + " mFactoryTest=" + this.mFactoryTest);
                pw.println("  mBooting=" + this.mBooting + " mCallFinishBooting=" + this.mCallFinishBooting + " mBootAnimationComplete=" + this.mBootAnimationComplete);
                pw.print("  mLastPowerCheckRealtime=");
                TimeUtils.formatDuration(this.mLastPowerCheckRealtime, pw);
                pw.println("");
                pw.print("  mLastPowerCheckUptime=");
                TimeUtils.formatDuration(this.mLastPowerCheckUptime, pw);
                pw.println("");
                pw.println("  mGoingToSleep=" + this.mStackSupervisor.mGoingToSleep);
                pw.println("  mLaunchingActivity=" + this.mStackSupervisor.mLaunchingActivity);
                pw.println("  mAdjSeq=" + this.mAdjSeq + " mLruSeq=" + this.mLruSeq);
                pw.println("  mNumNonCachedProcs=" + this.mNumNonCachedProcs + " (" + this.mLruProcesses.size() + " total)" + " mNumCachedHiddenProcs=" + this.mNumCachedHiddenProcs + " mNumServiceProcs=" + this.mNumServiceProcs + " mNewNumServiceProcs=" + this.mNewNumServiceProcs);
                pw.println("  mAllowLowerMemLevel=" + this.mAllowLowerMemLevel + " mLastMemoryLevel=" + this.mLastMemoryLevel + " mLastNumProcesses=" + this.mLastNumProcesses);
                long now = SystemClock.uptimeMillis();
                pw.print("  mLastIdleTime=");
                TimeUtils.formatDuration(now, this.mLastIdleTime, pw);
                pw.print(" mLowRamSinceLastIdle=");
                TimeUtils.formatDuration(this.getLowRamTimeSinceIdle(now), pw);
                pw.println();
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    boolean dumpProcessesToGc(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean needSep, boolean dumpAll, String dumpPackage) {
        if (this.mProcessesToGc.size() > 0) {
            boolean printed = false;
            long now = SystemClock.uptimeMillis();
            for (int i = 0; i < this.mProcessesToGc.size(); ++i) {
                ProcessRecord proc = this.mProcessesToGc.get(i);
                if (dumpPackage != null && !dumpPackage.equals(proc.info.packageName)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Processes that are waiting to GC:");
                    printed = true;
                }
                pw.print("    Process ");
                pw.println(proc);
                pw.print("      lowMem=");
                pw.print(proc.reportLowMemory);
                pw.print(", last gced=");
                pw.print(now - proc.lastRequestedGc);
                pw.print(" ms ago, last lowMem=");
                pw.print(now - proc.lastLowMemory);
                pw.println(" ms ago");
            }
        }
        return needSep;
    }

    void printOomLevel(PrintWriter pw, String name, int adj) {
        pw.print("    ");
        if (adj >= 0) {
            pw.print(' ');
            if (adj < 10) {
                pw.print(' ');
            }
        } else if (adj > -10) {
            pw.print(' ');
        }
        pw.print(adj);
        pw.print(": ");
        pw.print(name);
        pw.print(" (");
        pw.print(ActivityManagerService.stringifySize(this.mProcessList.getMemLevel(adj), 1024));
        pw.println(")");
    }

    boolean dumpOomLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll) {
        boolean needSep = false;
        if (this.mLruProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            pw.println("  OOM levels:");
            this.printOomLevel(pw, "SYSTEM_ADJ", -900);
            this.printOomLevel(pw, "PERSISTENT_PROC_ADJ", -800);
            this.printOomLevel(pw, "PERSISTENT_SERVICE_ADJ", -700);
            this.printOomLevel(pw, "FOREGROUND_APP_ADJ", 0);
            this.printOomLevel(pw, "VISIBLE_APP_ADJ", 100);
            this.printOomLevel(pw, "PERCEPTIBLE_APP_ADJ", 200);
            this.printOomLevel(pw, "BACKUP_APP_ADJ", 300);
            this.printOomLevel(pw, "HEAVY_WEIGHT_APP_ADJ", 400);
            this.printOomLevel(pw, "SERVICE_ADJ", 500);
            this.printOomLevel(pw, "HOME_APP_ADJ", 600);
            this.printOomLevel(pw, "PREVIOUS_APP_ADJ", 700);
            this.printOomLevel(pw, "SERVICE_B_ADJ", 800);
            this.printOomLevel(pw, "CACHED_APP_MIN_ADJ", 900);
            this.printOomLevel(pw, "CACHED_APP_MAX_ADJ", 906);
            if (needSep) {
                pw.println();
            }
            pw.print("  Process OOM control (");
            pw.print(this.mLruProcesses.size());
            pw.print(" total, non-act at ");
            pw.print(this.mLruProcesses.size() - this.mLruProcessActivityStart);
            pw.print(", non-svc at ");
            pw.print(this.mLruProcesses.size() - this.mLruProcessServiceStart);
            pw.println("):");
            ActivityManagerService.dumpProcessOomList(pw, this, this.mLruProcesses, "    ", "Proc", "PERS", true, null);
            needSep = true;
        }
        this.dumpProcessesToGc(fd, pw, args, opti, needSep, dumpAll, null);
        pw.println();
        pw.println("  mHomeProcess: " + this.mHomeProcess);
        pw.println("  mPreviousProcess: " + this.mPreviousProcess);
        if (this.mHeavyWeightProcess != null) {
            pw.println("  mHeavyWeightProcess: " + this.mHeavyWeightProcess);
        }
        return true;
    }

    protected boolean dumpProvider(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        return this.mProviderMap.dumpProvider(fd, pw, name, args, opti, dumpAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dumpActivity(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll, boolean dumpVisibleStacksOnly, boolean dumpFocusedStackOnly) {
        ArrayList<ActivityRecord> activities;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            activities = this.mStackSupervisor.getDumpActivitiesLocked(name, dumpVisibleStacksOnly, dumpFocusedStackOnly);
        }
        if (activities.size() <= 0) {
            return false;
        }
        String[] newArgs = new String[args.length - opti];
        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
        TaskRecord lastTask = null;
        boolean needSep = false;
        for (int i = activities.size() - 1; i >= 0; --i) {
            ActivityRecord r = activities.get(i);
            if (needSep) {
                pw.println();
            }
            needSep = true;
            ActivityManagerService activityManagerService2 = this;
            synchronized (activityManagerService2) {
                TaskRecord task = r.getTask();
                if (lastTask != task) {
                    lastTask = task;
                    pw.print("TASK ");
                    pw.print(lastTask.affinity);
                    pw.print(" id=");
                    pw.print(lastTask.taskId);
                    pw.print(" userId=");
                    pw.println(lastTask.userId);
                    if (dumpAll) {
                        lastTask.dump(pw, "  ");
                    }
                }
            }
            this.dumpActivity("  ", fd, pw, activities.get(i), newArgs, dumpAll);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpActivity(String prefix, FileDescriptor fd, PrintWriter pw, ActivityRecord r, String[] args, boolean dumpAll) {
        String innerPrefix = prefix + "  ";
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            pw.print(prefix);
            pw.print("ACTIVITY ");
            pw.print(r.shortComponentName);
            pw.print(" ");
            pw.print(Integer.toHexString(System.identityHashCode(r)));
            pw.print(" pid=");
            if (r.app != null) {
                pw.println(r.app.pid);
            } else {
                pw.println("(not running)");
            }
            if (dumpAll) {
                r.dump(pw, innerPrefix);
            }
        }
        if (r.app != null && r.app.thread != null) {
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.app.thread.dumpActivity(tp.getWriteFd(), r.appToken, innerPrefix, args);
                    tp.go(fd);
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println(innerPrefix + "Failure while dumping the activity: " + e);
            }
            catch (RemoteException e) {
                pw.println(innerPrefix + "Got a RemoteException while dumping the activity");
            }
        }
    }

    void dumpBroadcastsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean needSep = false;
        boolean onlyHistory = false;
        boolean printedAnything = false;
        if ("history".equals(dumpPackage)) {
            if (opti < args.length && "-s".equals(args[opti])) {
                dumpAll = false;
            }
            onlyHistory = true;
            dumpPackage = null;
        }
        pw.println("ACTIVITY MANAGER BROADCAST STATE (dumpsys activity broadcasts)");
        if (!onlyHistory && dumpAll) {
            if (this.mRegisteredReceivers.size() > 0) {
                boolean printed = false;
                for (ReceiverList r : this.mRegisteredReceivers.values()) {
                    if (dumpPackage != null && (r.app == null || !dumpPackage.equals(r.app.info.packageName))) continue;
                    if (!printed) {
                        pw.println("  Registered Receivers:");
                        needSep = true;
                        printed = true;
                        printedAnything = true;
                    }
                    pw.print("  * ");
                    pw.println(r);
                    r.dump(pw, "    ");
                }
            }
            if (this.mReceiverResolver.dump(pw, needSep ? "\n  Receiver Resolver Table:" : "  Receiver Resolver Table:", "    ", dumpPackage, false, false)) {
                needSep = true;
                printedAnything = true;
            }
        }
        for (BroadcastQueue q : this.mBroadcastQueues) {
            needSep = q.dumpLocked(fd, pw, args, opti, dumpAll, dumpPackage, needSep);
            printedAnything |= needSep;
        }
        needSep = true;
        if (!onlyHistory && this.mStickyBroadcasts != null && dumpPackage == null) {
            for (int user = 0; user < this.mStickyBroadcasts.size(); ++user) {
                if (needSep) {
                    pw.println();
                }
                needSep = true;
                printedAnything = true;
                pw.print("  Sticky broadcasts for user ");
                pw.print(this.mStickyBroadcasts.keyAt(user));
                pw.println(":");
                StringBuilder sb = new StringBuilder(128);
                for (Map.Entry<String, ArrayList<Intent>> ent : this.mStickyBroadcasts.valueAt(user).entrySet()) {
                    pw.print("  * Sticky action ");
                    pw.print(ent.getKey());
                    if (dumpAll) {
                        pw.println(":");
                        ArrayList<Intent> intents = ent.getValue();
                        int N = intents.size();
                        for (int i = 0; i < N; ++i) {
                            sb.setLength(0);
                            sb.append("    Intent: ");
                            intents.get(i).toShortString(sb, false, true, false, false);
                            pw.println(sb.toString());
                            Bundle bundle = intents.get(i).getExtras();
                            if (bundle == null) continue;
                            pw.print("      ");
                            pw.println(bundle.toString());
                        }
                        continue;
                    }
                    pw.println("");
                }
            }
        }
        if (!onlyHistory && dumpAll) {
            pw.println();
            for (BroadcastQueue queue : this.mBroadcastQueues) {
                pw.println("  mBroadcastsScheduled [" + queue.mQueueName + "]=" + queue.mBroadcastsScheduled);
            }
            pw.println("  mHandler:");
            this.mHandler.dump(new PrintWriterPrinter(pw), "    ");
            needSep = true;
            printedAnything = true;
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpBroadcastStatsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        if (this.mCurBroadcastStats == null) {
            return;
        }
        pw.println("ACTIVITY MANAGER BROADCAST STATS STATE (dumpsys activity broadcast-stats)");
        long now = SystemClock.elapsedRealtime();
        if (this.mLastBroadcastStats != null) {
            pw.print("  Last stats (from ");
            TimeUtils.formatDuration(this.mLastBroadcastStats.mStartRealtime, now, pw);
            pw.print(" to ");
            TimeUtils.formatDuration(this.mLastBroadcastStats.mEndRealtime, now, pw);
            pw.print(", ");
            TimeUtils.formatDuration(this.mLastBroadcastStats.mEndUptime - this.mLastBroadcastStats.mStartUptime, pw);
            pw.println(" uptime):");
            if (!this.mLastBroadcastStats.dumpStats(pw, "    ", dumpPackage)) {
                pw.println("    (nothing)");
            }
            pw.println();
        }
        pw.print("  Current stats (from ");
        TimeUtils.formatDuration(this.mCurBroadcastStats.mStartRealtime, now, pw);
        pw.print(" to now, ");
        TimeUtils.formatDuration(SystemClock.uptimeMillis() - this.mCurBroadcastStats.mStartUptime, pw);
        pw.println(" uptime):");
        if (!this.mCurBroadcastStats.dumpStats(pw, "    ", dumpPackage)) {
            pw.println("    (nothing)");
        }
    }

    void dumpBroadcastStatsCheckinLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean fullCheckin, String dumpPackage) {
        if (this.mCurBroadcastStats == null) {
            return;
        }
        if (this.mLastBroadcastStats != null) {
            this.mLastBroadcastStats.dumpCheckinStats(pw, dumpPackage);
            if (fullCheckin) {
                this.mLastBroadcastStats = null;
                return;
            }
        }
        this.mCurBroadcastStats.dumpCheckinStats(pw, dumpPackage);
        if (fullCheckin) {
            this.mCurBroadcastStats = null;
        }
    }

    void dumpProvidersLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean printedAnything = false;
        ItemMatcher matcher = new ItemMatcher();
        matcher.build(args, opti);
        pw.println("ACTIVITY MANAGER CONTENT PROVIDERS (dumpsys activity providers)");
        boolean needSep = this.mProviderMap.dumpProvidersLocked(pw, dumpAll, dumpPackage);
        printedAnything |= needSep;
        if (this.mLaunchingProviders.size() > 0) {
            boolean printed = false;
            for (int i = this.mLaunchingProviders.size() - 1; i >= 0; --i) {
                ContentProviderRecord r = this.mLaunchingProviders.get(i);
                if (dumpPackage != null && !dumpPackage.equals(r.name.getPackageName())) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Launching content providers:");
                    printed = true;
                    printedAnything = true;
                }
                pw.print("  Launching #");
                pw.print(i);
                pw.print(": ");
                pw.println(r);
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpPermissionsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean needSep = false;
        boolean printedAnything = false;
        pw.println("ACTIVITY MANAGER URI PERMISSIONS (dumpsys activity permissions)");
        if (this.mGrantedUriPermissions.size() > 0) {
            boolean printed = false;
            int dumpUid = -2;
            if (dumpPackage != null) {
                try {
                    dumpUid = this.mContext.getPackageManager().getPackageUidAsUser(dumpPackage, 0x400000, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    dumpUid = -1;
                }
            }
            for (int i = 0; i < this.mGrantedUriPermissions.size(); ++i) {
                int uid = this.mGrantedUriPermissions.keyAt(i);
                if (dumpUid >= -1 && UserHandle.getAppId(uid) != dumpUid) continue;
                ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Granted Uri Permissions:");
                    printed = true;
                    printedAnything = true;
                }
                pw.print("  * UID ");
                pw.print(uid);
                pw.println(" holds:");
                for (UriPermission perm : perms.values()) {
                    pw.print("    ");
                    pw.println(perm);
                    if (!dumpAll) continue;
                    perm.dump(pw, "      ");
                }
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpPendingIntentsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean printed = false;
        pw.println("ACTIVITY MANAGER PENDING INTENTS (dumpsys activity intents)");
        if (this.mIntentSenderRecords.size() > 0) {
            int i;
            ArrayMap<String, ArrayList<PendingIntentRecord>> byPackage = new ArrayMap<String, ArrayList<PendingIntentRecord>>();
            ArrayList<WeakReference<PendingIntentRecord>> weakRefs = new ArrayList<WeakReference<PendingIntentRecord>>();
            for (WeakReference<PendingIntentRecord> ref : this.mIntentSenderRecords.values()) {
                PendingIntentRecord rec;
                PendingIntentRecord pendingIntentRecord = rec = ref != null ? (PendingIntentRecord)ref.get() : null;
                if (rec == null) {
                    weakRefs.add(ref);
                    continue;
                }
                if (dumpPackage != null && !dumpPackage.equals(rec.key.packageName)) continue;
                ArrayList<PendingIntentRecord> list = (ArrayList<PendingIntentRecord>)byPackage.get(rec.key.packageName);
                if (list == null) {
                    list = new ArrayList<PendingIntentRecord>();
                    byPackage.put(rec.key.packageName, list);
                }
                list.add(rec);
            }
            for (i = 0; i < byPackage.size(); ++i) {
                ArrayList intents = (ArrayList)byPackage.valueAt(i);
                printed = true;
                pw.print("  * ");
                pw.print((String)byPackage.keyAt(i));
                pw.print(": ");
                pw.print(intents.size());
                pw.println(" items");
                for (int j = 0; j < intents.size(); ++j) {
                    pw.print("    #");
                    pw.print(j);
                    pw.print(": ");
                    pw.println(intents.get(j));
                    if (!dumpAll) continue;
                    ((PendingIntentRecord)intents.get(j)).dump(pw, "      ");
                }
            }
            if (weakRefs.size() > 0) {
                printed = true;
                pw.println("  * WEAK REFS:");
                for (i = 0; i < weakRefs.size(); ++i) {
                    pw.print("    #");
                    pw.print(i);
                    pw.print(": ");
                    pw.println(weakRefs.get(i));
                }
            }
        }
        if (!printed) {
            pw.println("  (nothing)");
        }
    }

    private static final int dumpProcessList(PrintWriter pw, ActivityManagerService service, List list, String prefix, String normalLabel, String persistentLabel, String dumpPackage) {
        int N;
        int numPers = 0;
        for (int i = N = list.size() - 1; i >= 0; --i) {
            ProcessRecord r = (ProcessRecord)list.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r.info.packageName)) continue;
            pw.println(String.format("%s%s #%2d: %s", prefix, r.persistent ? persistentLabel : normalLabel, i, r.toString()));
            if (!r.persistent) continue;
            ++numPers;
        }
        return numPers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean dumpProcessOomList(PrintWriter pw, ActivityManagerService service, List<ProcessRecord> origList, String prefix, String normalLabel, String persistentLabel, boolean inclDetails, String dumpPackage) {
        ArrayList<Pair<ProcessRecord, Integer>> list = new ArrayList<Pair<ProcessRecord, Integer>>(origList.size());
        for (int i = 0; i < origList.size(); ++i) {
            ProcessRecord r = origList.get(i);
            if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
            list.add(new Pair<ProcessRecord, Integer>(origList.get(i), i));
        }
        if (list.size() <= 0) {
            return false;
        }
        Comparator<Pair<ProcessRecord, Integer>> comparator = new Comparator<Pair<ProcessRecord, Integer>>(){

            @Override
            public int compare(Pair<ProcessRecord, Integer> object1, Pair<ProcessRecord, Integer> object2) {
                if (((ProcessRecord)object1.first).setAdj != ((ProcessRecord)object2.first).setAdj) {
                    return ((ProcessRecord)object1.first).setAdj > ((ProcessRecord)object2.first).setAdj ? -1 : 1;
                }
                if (((ProcessRecord)object1.first).setProcState != ((ProcessRecord)object2.first).setProcState) {
                    return ((ProcessRecord)object1.first).setProcState > ((ProcessRecord)object2.first).setProcState ? -1 : 1;
                }
                if (((Integer)object1.second).intValue() != ((Integer)object2.second).intValue()) {
                    return (Integer)object1.second > (Integer)object2.second ? -1 : 1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
        long curRealtime = SystemClock.elapsedRealtime();
        long realtimeSince = curRealtime - service.mLastPowerCheckRealtime;
        long curUptime = SystemClock.uptimeMillis();
        long uptimeSince = curUptime - service.mLastPowerCheckUptime;
        for (int i = list.size() - 1; i >= 0; --i) {
            char schedGroup;
            ProcessRecord r = (ProcessRecord)((Pair)list.get((int)i)).first;
            String oomAdj = ProcessList.makeOomAdjString(r.setAdj);
            switch (r.setSchedGroup) {
                case 0: {
                    schedGroup = 'B';
                    break;
                }
                case 1: {
                    schedGroup = 'F';
                    break;
                }
                case 2: {
                    schedGroup = 'T';
                    break;
                }
                default: {
                    schedGroup = '?';
                }
            }
            char foreground = r.foregroundActivities ? (char)'A' : (r.foregroundServices ? (char)'S' : ' ');
            String procState = ProcessList.makeProcStateString(r.curProcState);
            pw.print(prefix);
            pw.print(r.persistent ? persistentLabel : normalLabel);
            pw.print(" #");
            int num = origList.size() - 1 - (Integer)((Pair)list.get((int)i)).second;
            if (num < 10) {
                pw.print(' ');
            }
            pw.print(num);
            pw.print(": ");
            pw.print(oomAdj);
            pw.print(' ');
            pw.print(schedGroup);
            pw.print('/');
            pw.print(foreground);
            pw.print('/');
            pw.print(procState);
            pw.print(" trm:");
            if (r.trimMemoryLevel < 10) {
                pw.print(' ');
            }
            pw.print(r.trimMemoryLevel);
            pw.print(' ');
            pw.print(r.toShortString());
            pw.print(" (");
            pw.print(r.adjType);
            pw.println(')');
            if (r.adjSource != null || r.adjTarget != null) {
                pw.print(prefix);
                pw.print("    ");
                if (r.adjTarget instanceof ComponentName) {
                    pw.print(((ComponentName)r.adjTarget).flattenToShortString());
                } else if (r.adjTarget != null) {
                    pw.print(r.adjTarget.toString());
                } else {
                    pw.print("{null}");
                }
                pw.print("<=");
                if (r.adjSource instanceof ProcessRecord) {
                    pw.print("Proc{");
                    pw.print(((ProcessRecord)r.adjSource).toShortString());
                    pw.println("}");
                } else if (r.adjSource != null) {
                    pw.println(r.adjSource.toString());
                } else {
                    pw.println("{null}");
                }
            }
            if (!inclDetails) continue;
            pw.print(prefix);
            pw.print("    ");
            pw.print("oom: max=");
            pw.print(r.maxAdj);
            pw.print(" curRaw=");
            pw.print(r.curRawAdj);
            pw.print(" setRaw=");
            pw.print(r.setRawAdj);
            pw.print(" cur=");
            pw.print(r.curAdj);
            pw.print(" set=");
            pw.println(r.setAdj);
            pw.print(prefix);
            pw.print("    ");
            pw.print("state: cur=");
            pw.print(ProcessList.makeProcStateString(r.curProcState));
            pw.print(" set=");
            pw.print(ProcessList.makeProcStateString(r.setProcState));
            pw.print(" lastPss=");
            DebugUtils.printSizeValue(pw, r.lastPss * 1024L);
            pw.print(" lastSwapPss=");
            DebugUtils.printSizeValue(pw, r.lastSwapPss * 1024L);
            pw.print(" lastCachedPss=");
            DebugUtils.printSizeValue(pw, r.lastCachedPss * 1024L);
            pw.println();
            pw.print(prefix);
            pw.print("    ");
            pw.print("cached=");
            pw.print(r.cached);
            pw.print(" empty=");
            pw.print(r.empty);
            pw.print(" hasAboveClient=");
            pw.println(r.hasAboveClient);
            if (r.setProcState < 11) continue;
            if (r.lastWakeTime != 0L) {
                long wtime;
                BatteryStatsImpl stats;
                BatteryStatsImpl batteryStatsImpl = stats = service.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    wtime = stats.getProcessWakeTime(r.info.uid, r.pid, curRealtime);
                }
                long timeUsed = wtime - r.lastWakeTime;
                pw.print(prefix);
                pw.print("    ");
                pw.print("keep awake over ");
                TimeUtils.formatDuration(realtimeSince, pw);
                pw.print(" used ");
                TimeUtils.formatDuration(timeUsed, pw);
                pw.print(" (");
                pw.print(timeUsed * 100L / realtimeSince);
                pw.println("%)");
            }
            if (r.lastCpuTime == 0L) continue;
            long timeUsed = r.curCpuTime - r.lastCpuTime;
            pw.print(prefix);
            pw.print("    ");
            pw.print("run cpu over ");
            TimeUtils.formatDuration(uptimeSince, pw);
            pw.print(" used ");
            TimeUtils.formatDuration(timeUsed, pw);
            pw.print(" (");
            pw.print(timeUsed * 100L / uptimeSince);
            pw.println("%)");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<ProcessRecord> collectProcesses(PrintWriter pw, int start, boolean allPkgs, String[] args) {
        ArrayList<ProcessRecord> procs;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (args != null && args.length > start && args[start].charAt(0) != '-') {
                procs = new ArrayList();
                int pid = -1;
                try {
                    pid = Integer.parseInt(args[start]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                    ProcessRecord proc = this.mLruProcesses.get(i);
                    if (proc.pid == pid) {
                        procs.add(proc);
                        continue;
                    }
                    if (allPkgs && proc.pkgList != null && proc.pkgList.containsKey(args[start])) {
                        procs.add(proc);
                        continue;
                    }
                    if (!proc.processName.equals(args[start])) continue;
                    procs.add(proc);
                }
                if (procs.size() <= 0) {
                    return null;
                }
            } else {
                procs = new ArrayList<ProcessRecord>(this.mLruProcesses);
            }
        }
        return procs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpGraphicsHardwareUsage(FileDescriptor fd, PrintWriter pw, String[] args) {
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, 0, false, args);
        if (procs == null) {
            pw.println("No process found for: " + args[0]);
            return;
        }
        long uptime = SystemClock.uptimeMillis();
        long realtime = SystemClock.elapsedRealtime();
        pw.println("Applications Graphics Acceleration Info:");
        pw.println("Uptime: " + uptime + " Realtime: " + realtime);
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessRecord r = procs.get(i);
            if (r.thread == null) continue;
            pw.println("\n** Graphics info for pid " + r.pid + " [" + r.processName + "] **");
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.thread.dumpGfxInfo(tp.getWriteFd(), args);
                    tp.go(fd);
                    continue;
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println("Failure while dumping the app: " + r);
                pw.flush();
                continue;
            }
            catch (RemoteException e) {
                pw.println("Got a RemoteException while dumping the app " + r);
                pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpDbInfo(FileDescriptor fd, PrintWriter pw, String[] args) {
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, 0, false, args);
        if (procs == null) {
            pw.println("No process found for: " + args[0]);
            return;
        }
        pw.println("Applications Database Info:");
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessRecord r = procs.get(i);
            if (r.thread == null) continue;
            pw.println("\n** Database info for pid " + r.pid + " [" + r.processName + "] **");
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.thread.dumpDbInfo(tp.getWriteFd(), args);
                    tp.go(fd);
                    continue;
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println("Failure while dumping the app: " + r);
                pw.flush();
                continue;
            }
            catch (RemoteException e) {
                pw.println("Got a RemoteException while dumping the app " + r);
                pw.flush();
            }
        }
    }

    static final void dumpMemItems(PrintWriter pw, String prefix, String tag, ArrayList<MemItem> items, boolean sort, boolean isCompact, boolean dumpSwapPss) {
        if (sort && !isCompact) {
            Collections.sort(items, new Comparator<MemItem>(){

                @Override
                public int compare(MemItem lhs, MemItem rhs) {
                    if (lhs.pss < rhs.pss) {
                        return 1;
                    }
                    if (lhs.pss > rhs.pss) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        for (int i = 0; i < items.size(); ++i) {
            MemItem mi = items.get(i);
            if (!isCompact) {
                if (dumpSwapPss) {
                    pw.printf("%s%s: %-60s (%s in swap)\n", prefix, ActivityManagerService.stringifyKBSize(mi.pss), mi.label, ActivityManagerService.stringifyKBSize(mi.swapPss));
                } else {
                    pw.printf("%s%s: %s\n", prefix, ActivityManagerService.stringifyKBSize(mi.pss), mi.label);
                }
            } else if (mi.isProc) {
                pw.print("proc,");
                pw.print(tag);
                pw.print(",");
                pw.print(mi.shortLabel);
                pw.print(",");
                pw.print(mi.id);
                pw.print(",");
                pw.print(mi.pss);
                pw.print(",");
                pw.print(dumpSwapPss ? Long.valueOf(mi.swapPss) : "N/A");
                pw.println(mi.hasActivities ? ",a" : ",e");
            } else {
                pw.print(tag);
                pw.print(",");
                pw.print(mi.shortLabel);
                pw.print(",");
                pw.print(mi.pss);
                pw.print(",");
                pw.println(dumpSwapPss ? Long.valueOf(mi.swapPss) : "N/A");
            }
            if (mi.subitems == null) continue;
            ActivityManagerService.dumpMemItems(pw, prefix + "    ", mi.shortLabel, mi.subitems, true, isCompact, dumpSwapPss);
        }
    }

    static final void appendMemBucket(StringBuilder out, long memKB, String label, boolean stackLike) {
        int start = label.lastIndexOf(46);
        start = start >= 0 ? ++start : 0;
        int end = label.length();
        for (int i = 0; i < DUMP_MEM_BUCKETS.length; ++i) {
            if (DUMP_MEM_BUCKETS[i] < memKB) continue;
            long bucket = DUMP_MEM_BUCKETS[i] / 1024L;
            out.append(bucket);
            out.append(stackLike ? "MB." : "MB ");
            out.append(label, start, end);
            return;
        }
        out.append(memKB / 1024L);
        out.append(stackLike ? "MB." : "MB ");
        out.append(label, start, end);
    }

    private final void dumpApplicationMemoryUsageHeader(PrintWriter pw, long uptime, long realtime, boolean isCheckinRequest, boolean isCompact) {
        if (isCompact) {
            pw.print("version,");
            pw.println(1);
        }
        if (isCheckinRequest || isCompact) {
            pw.print("time,");
            pw.print(uptime);
            pw.print(",");
            pw.println(realtime);
        } else {
            pw.println("Applications Memory Usage (in Kilobytes):");
            pw.println("Uptime: " + uptime + " Realtime: " + realtime);
        }
    }

    private final long[] getKsmInfo() {
        long[] longOut = new long[4];
        int[] SINGLE_LONG_FORMAT = new int[]{8224};
        long[] longTmp = new long[1];
        android.os.Process.readProcFile("/sys/kernel/mm/ksm/pages_shared", SINGLE_LONG_FORMAT, null, longTmp, null);
        longOut[0] = longTmp[0] * 4096L / 1024L;
        longTmp[0] = 0L;
        android.os.Process.readProcFile("/sys/kernel/mm/ksm/pages_sharing", SINGLE_LONG_FORMAT, null, longTmp, null);
        longOut[1] = longTmp[0] * 4096L / 1024L;
        longTmp[0] = 0L;
        android.os.Process.readProcFile("/sys/kernel/mm/ksm/pages_unshared", SINGLE_LONG_FORMAT, null, longTmp, null);
        longOut[2] = longTmp[0] * 4096L / 1024L;
        longTmp[0] = 0L;
        android.os.Process.readProcFile("/sys/kernel/mm/ksm/pages_volatile", SINGLE_LONG_FORMAT, null, longTmp, null);
        longOut[3] = longTmp[0] * 4096L / 1024L;
        return longOut;
    }

    private static String stringifySize(long size, int order) {
        Locale locale = Locale.US;
        switch (order) {
            case 1: {
                return String.format(locale, "%,13d", size);
            }
            case 1024: {
                return String.format(locale, "%,9dK", size / 1024L);
            }
            case 0x100000: {
                return String.format(locale, "%,5dM", size / 1024L / 1024L);
            }
            case 0x40000000: {
                return String.format(locale, "%,1dG", size / 1024L / 1024L / 1024L);
            }
        }
        throw new IllegalArgumentException("Invalid size order");
    }

    private static String stringifyKBSize(long size) {
        return ActivityManagerService.stringifySize(size * 1024L, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpApplicationMemoryUsage(FileDescriptor fd, PrintWriter pw, String prefix, String[] args, boolean brief, PrintWriter categoryPw) {
        long myTotalPss;
        Object thread;
        ActivityManagerService activityManagerService;
        String opt;
        int opti;
        boolean dumpDetails = false;
        boolean dumpFullDetails = false;
        boolean dumpDalvik = false;
        boolean dumpSummaryOnly = false;
        boolean dumpUnreachable = false;
        boolean oomOnly = false;
        boolean isCompact = false;
        boolean localOnly = false;
        boolean packages = false;
        boolean isCheckinRequest = false;
        boolean dumpSwapPss = false;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) {
                dumpDetails = true;
                dumpFullDetails = true;
                dumpDalvik = true;
                dumpSwapPss = true;
                continue;
            }
            if ("-d".equals(opt)) {
                dumpDalvik = true;
                continue;
            }
            if ("-c".equals(opt)) {
                isCompact = true;
                continue;
            }
            if ("-s".equals(opt)) {
                dumpDetails = true;
                dumpSummaryOnly = true;
                continue;
            }
            if ("-S".equals(opt)) {
                dumpSwapPss = true;
                continue;
            }
            if ("--unreachable".equals(opt)) {
                dumpUnreachable = true;
                continue;
            }
            if ("--oom".equals(opt)) {
                oomOnly = true;
                continue;
            }
            if ("--local".equals(opt)) {
                localOnly = true;
                continue;
            }
            if ("--package".equals(opt)) {
                packages = true;
                continue;
            }
            if ("--checkin".equals(opt)) {
                isCheckinRequest = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("meminfo dump options: [-a] [-d] [-c] [-s] [--oom] [process]");
                pw.println("  -a: include all available information for each process.");
                pw.println("  -d: include dalvik details.");
                pw.println("  -c: dump in a compact machine-parseable representation.");
                pw.println("  -s: dump only summary of application memory usage.");
                pw.println("  -S: dump also SwapPss.");
                pw.println("  --oom: only show processes organized by oom adj.");
                pw.println("  --local: only collect details locally, don't call process.");
                pw.println("  --package: interpret process arg as package, dumping all");
                pw.println("             processes that have loaded that package.");
                pw.println("  --checkin: dump data for a checkin");
                pw.println("If [process] is specified it can be the name or ");
                pw.println("pid of a specific process to dump.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        long uptime = SystemClock.uptimeMillis();
        long realtime = SystemClock.elapsedRealtime();
        long[] tmpLong = new long[1];
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, opti, packages, args);
        if (procs == null) {
            if (args != null && args.length > opti && args[opti].charAt(0) != '-') {
                ArrayList<ProcessCpuTracker.Stats> nativeProcs = new ArrayList<ProcessCpuTracker.Stats>();
                this.updateCpuStatsNow();
                int findPid = -1;
                try {
                    findPid = Integer.parseInt(args[opti]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ProcessCpuTracker processCpuTracker = this.mProcessCpuTracker;
                synchronized (processCpuTracker) {
                    int N = this.mProcessCpuTracker.countStats();
                    for (int i = 0; i < N; ++i) {
                        ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                        if (st.pid != findPid && (st.baseName == null || !st.baseName.equals(args[opti]))) continue;
                        nativeProcs.add(st);
                    }
                }
                if (nativeProcs.size() > 0) {
                    this.dumpApplicationMemoryUsageHeader(pw, uptime, realtime, isCheckinRequest, isCompact);
                    Debug.MemoryInfo mi = null;
                    for (int i = nativeProcs.size() - 1; i >= 0; --i) {
                        ProcessCpuTracker.Stats r = (ProcessCpuTracker.Stats)nativeProcs.get(i);
                        int pid = r.pid;
                        if (!isCheckinRequest && dumpDetails) {
                            pw.println("\n** MEMINFO in pid " + pid + " [" + r.baseName + "] **");
                        }
                        if (mi == null) {
                            mi = new Debug.MemoryInfo();
                        }
                        if (dumpDetails || !brief && !oomOnly) {
                            Debug.getMemoryInfo(pid, mi);
                        } else {
                            mi.dalvikPss = (int)Debug.getPss(pid, tmpLong, null);
                            mi.dalvikPrivateDirty = (int)tmpLong[0];
                        }
                        ActivityThread.dumpMemInfoTable(pw, mi, isCheckinRequest, dumpFullDetails, dumpDalvik, dumpSummaryOnly, pid, r.baseName, 0L, 0L, 0L, 0L, 0L, 0L);
                        if (!isCheckinRequest) continue;
                        pw.println();
                    }
                    return;
                }
            }
            pw.println("No process found for: " + args[opti]);
            return;
        }
        if (!brief && !oomOnly && (procs.size() == 1 || isCheckinRequest || packages)) {
            dumpDetails = true;
        }
        this.dumpApplicationMemoryUsageHeader(pw, uptime, realtime, isCheckinRequest, isCompact);
        String[] innerArgs = new String[args.length - opti];
        System.arraycopy(args, opti, innerArgs, 0, args.length - opti);
        ArrayList<MemItem> procMems = new ArrayList<MemItem>();
        SparseArray<MemItem> procMemsMap = new SparseArray<MemItem>();
        long nativePss = 0L;
        long nativeSwapPss = 0L;
        long dalvikPss = 0L;
        long dalvikSwapPss = 0L;
        long[] dalvikSubitemPss = dumpDalvik ? new long[8] : EmptyArray.LONG;
        long[] dalvikSubitemSwapPss = dumpDalvik ? new long[8] : EmptyArray.LONG;
        long otherPss = 0L;
        long otherSwapPss = 0L;
        long[] miscPss = new long[17];
        long[] miscSwapPss = new long[17];
        long[] oomPss = new long[DUMP_MEM_OOM_LABEL.length];
        long[] oomSwapPss = new long[DUMP_MEM_OOM_LABEL.length];
        ArrayList[] oomProcs = new ArrayList[DUMP_MEM_OOM_LABEL.length];
        long totalPss = 0L;
        long totalSwapPss = 0L;
        long cachedPss = 0L;
        long cachedSwapPss = 0L;
        boolean hasSwapPss = false;
        Debug.MemoryInfo mi = null;
        block32: for (int i = procs.size() - 1; i >= 0; --i) {
            int j;
            boolean hasActivities;
            int oomAdj;
            int pid;
            ProcessRecord r;
            block101: {
                r = procs.get(i);
                activityManagerService = this;
                synchronized (activityManagerService) {
                    thread = r.thread;
                    pid = r.pid;
                    oomAdj = r.getSetAdjWithServices();
                    hasActivities = r.activities.size() > 0;
                }
                if (thread == null) continue;
                if (!isCheckinRequest && dumpDetails) {
                    pw.println("\n** MEMINFO in pid " + pid + " [" + r.processName + "] **");
                }
                if (mi == null) {
                    mi = new Debug.MemoryInfo();
                }
                if (dumpDetails || !brief && !oomOnly) {
                    Debug.getMemoryInfo(pid, mi);
                    hasSwapPss = mi.hasSwappedOutPss;
                } else {
                    mi.dalvikPss = (int)Debug.getPss(pid, tmpLong, null);
                    mi.dalvikPrivateDirty = (int)tmpLong[0];
                }
                if (dumpDetails) {
                    if (localOnly) {
                        ActivityThread.dumpMemInfoTable(pw, mi, isCheckinRequest, dumpFullDetails, dumpDalvik, dumpSummaryOnly, pid, r.processName, 0L, 0L, 0L, 0L, 0L, 0L);
                        if (isCheckinRequest) {
                            pw.println();
                        }
                    } else {
                        pw.flush();
                        try {
                            TransferPipe tp = new TransferPipe();
                            try {
                                thread.dumpMemInfo(tp.getWriteFd(), mi, isCheckinRequest, dumpFullDetails, dumpDalvik, dumpSummaryOnly, dumpUnreachable, innerArgs);
                                tp.go(fd);
                            }
                            finally {
                                tp.kill();
                            }
                        }
                        catch (IOException e) {
                            if (!isCheckinRequest) {
                                pw.println("Got IoException!");
                                pw.flush();
                            }
                        }
                        catch (RemoteException e) {
                            if (isCheckinRequest) break block101;
                            pw.println("Got RemoteException!");
                            pw.flush();
                        }
                    }
                }
            }
            myTotalPss = mi.getTotalPss();
            long myTotalUss = mi.getTotalUss();
            long myTotalSwapPss = mi.getTotalSwappedOutPss();
            ActivityManagerService activityManagerService2 = this;
            synchronized (activityManagerService2) {
                if (r.thread != null && oomAdj == r.getSetAdjWithServices()) {
                    r.baseProcessTracker.addPss(myTotalPss, myTotalUss, true, r.pkgList);
                }
            }
            if (isCheckinRequest || mi == null) continue;
            totalPss += myTotalPss;
            totalSwapPss += myTotalSwapPss;
            MemItem pssItem = new MemItem(r.processName + " (pid " + pid + (hasActivities ? " / activities)" : ")"), r.processName, myTotalPss, myTotalSwapPss, pid, hasActivities);
            procMems.add(pssItem);
            procMemsMap.put(pid, pssItem);
            nativePss += (long)mi.nativePss;
            nativeSwapPss += (long)mi.nativeSwappedOutPss;
            dalvikPss += (long)mi.dalvikPss;
            dalvikSwapPss += (long)mi.dalvikSwappedOutPss;
            for (j = 0; j < dalvikSubitemPss.length; ++j) {
                int n = j;
                dalvikSubitemPss[n] = dalvikSubitemPss[n] + (long)mi.getOtherPss(17 + j);
                int n2 = j;
                dalvikSubitemSwapPss[n2] = dalvikSubitemSwapPss[n2] + (long)mi.getOtherSwappedOutPss(17 + j);
            }
            otherPss += (long)mi.otherPss;
            otherSwapPss += (long)mi.otherSwappedOutPss;
            j = 0;
            while (j < 17) {
                long mem = mi.getOtherPss(j);
                int n = j;
                miscPss[n] = miscPss[n] + mem;
                otherPss -= mem;
                mem = mi.getOtherSwappedOutPss(j);
                int n3 = j++;
                miscSwapPss[n3] = miscSwapPss[n3] + mem;
                otherSwapPss -= mem;
            }
            if (oomAdj >= 900) {
                cachedPss += myTotalPss;
                cachedSwapPss += myTotalSwapPss;
            }
            for (int oomIndex = 0; oomIndex < oomPss.length; ++oomIndex) {
                if (oomIndex != oomPss.length - 1 && (oomAdj < DUMP_MEM_OOM_ADJ[oomIndex] || oomAdj >= DUMP_MEM_OOM_ADJ[oomIndex + 1])) continue;
                int n = oomIndex;
                oomPss[n] = oomPss[n] + myTotalPss;
                int n4 = oomIndex;
                oomSwapPss[n4] = oomSwapPss[n4] + myTotalSwapPss;
                if (oomProcs[oomIndex] == null) {
                    oomProcs[oomIndex] = new ArrayList();
                }
                oomProcs[oomIndex].add(pssItem);
                continue block32;
            }
        }
        long nativeProcTotalPss = 0L;
        if (!isCheckinRequest && procs.size() > 1 && !packages) {
            int j;
            this.updateCpuStatsNow();
            mi = null;
            thread = this.mProcessCpuTracker;
            synchronized (thread) {
                int N = this.mProcessCpuTracker.countStats();
                for (int i = 0; i < N; ++i) {
                    int j2;
                    ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                    if (st.vsize <= 0L || procMemsMap.indexOfKey(st.pid) >= 0) continue;
                    if (mi == null) {
                        mi = new Debug.MemoryInfo();
                    }
                    if (!brief && !oomOnly) {
                        Debug.getMemoryInfo(st.pid, mi);
                    } else {
                        mi.nativePss = (int)Debug.getPss(st.pid, tmpLong, null);
                        mi.nativePrivateDirty = (int)tmpLong[0];
                    }
                    myTotalPss = mi.getTotalPss();
                    long myTotalSwapPss = mi.getTotalSwappedOutPss();
                    totalPss += myTotalPss;
                    nativeProcTotalPss += myTotalPss;
                    MemItem pssItem = new MemItem(st.name + " (pid " + st.pid + ")", st.name, myTotalPss, mi.getSummaryTotalSwapPss(), st.pid, false);
                    procMems.add(pssItem);
                    nativePss += (long)mi.nativePss;
                    nativeSwapPss += (long)mi.nativeSwappedOutPss;
                    dalvikPss += (long)mi.dalvikPss;
                    dalvikSwapPss += (long)mi.dalvikSwappedOutPss;
                    for (j2 = 0; j2 < dalvikSubitemPss.length; ++j2) {
                        int n = j2;
                        dalvikSubitemPss[n] = dalvikSubitemPss[n] + (long)mi.getOtherPss(17 + j2);
                        int n5 = j2;
                        dalvikSubitemSwapPss[n5] = dalvikSubitemSwapPss[n5] + (long)mi.getOtherSwappedOutPss(17 + j2);
                    }
                    otherPss += (long)mi.otherPss;
                    otherSwapPss += (long)mi.otherSwappedOutPss;
                    j2 = 0;
                    while (j2 < 17) {
                        long mem = mi.getOtherPss(j2);
                        int n = j2;
                        miscPss[n] = miscPss[n] + mem;
                        otherPss -= mem;
                        mem = mi.getOtherSwappedOutPss(j2);
                        int n6 = j2++;
                        miscSwapPss[n6] = miscSwapPss[n6] + mem;
                        otherSwapPss -= mem;
                    }
                    oomPss[0] = oomPss[0] + myTotalPss;
                    oomSwapPss[0] = oomSwapPss[0] + myTotalSwapPss;
                    if (oomProcs[0] == null) {
                        oomProcs[0] = new ArrayList();
                    }
                    oomProcs[0].add(pssItem);
                }
            }
            ArrayList<MemItem> catMems = new ArrayList<MemItem>();
            catMems.add(new MemItem("Native", "Native", nativePss, nativeSwapPss, -1));
            MemItem dalvikItem = new MemItem("Dalvik", "Dalvik", dalvikPss, dalvikSwapPss, -2);
            if (dalvikSubitemPss.length > 0) {
                dalvikItem.subitems = new ArrayList();
                for (j = 0; j < dalvikSubitemPss.length; ++j) {
                    String name = Debug.MemoryInfo.getOtherLabel(17 + j);
                    dalvikItem.subitems.add(new MemItem(name, name, dalvikSubitemPss[j], dalvikSubitemSwapPss[j], j));
                }
            }
            catMems.add(dalvikItem);
            catMems.add(new MemItem("Unknown", "Unknown", otherPss, otherSwapPss, -3));
            for (j = 0; j < 17; ++j) {
                String label = Debug.MemoryInfo.getOtherLabel(j);
                catMems.add(new MemItem(label, label, miscPss[j], miscSwapPss[j], j));
            }
            ArrayList<MemItem> oomMems = new ArrayList<MemItem>();
            for (int j3 = 0; j3 < oomPss.length; ++j3) {
                if (oomPss[j3] == 0L) continue;
                String label = isCompact ? DUMP_MEM_OOM_COMPACT_LABEL[j3] : DUMP_MEM_OOM_LABEL[j3];
                MemItem item = new MemItem(label, label, oomPss[j3], oomSwapPss[j3], DUMP_MEM_OOM_ADJ[j3]);
                item.subitems = oomProcs[j3];
                oomMems.add(item);
            }
            boolean bl = dumpSwapPss = dumpSwapPss && hasSwapPss && totalSwapPss != 0L;
            if (!(brief || oomOnly || isCompact)) {
                pw.println();
                pw.println("Total PSS by process:");
                ActivityManagerService.dumpMemItems(pw, "  ", "proc", procMems, true, isCompact, dumpSwapPss);
                pw.println();
            }
            if (!isCompact) {
                pw.println("Total PSS by OOM adjustment:");
            }
            ActivityManagerService.dumpMemItems(pw, "  ", "oom", oomMems, false, isCompact, dumpSwapPss);
            if (!brief && !oomOnly) {
                PrintWriter out;
                PrintWriter printWriter = out = categoryPw != null ? categoryPw : pw;
                if (!isCompact) {
                    out.println();
                    out.println("Total PSS by category:");
                }
                ActivityManagerService.dumpMemItems(out, "  ", "cat", catMems, true, isCompact, dumpSwapPss);
            }
            if (!isCompact) {
                pw.println();
            }
            MemInfoReader memInfo = new MemInfoReader();
            memInfo.readMemInfo();
            if (nativeProcTotalPss > 0L) {
                activityManagerService = this;
                synchronized (activityManagerService) {
                    long cachedKb = memInfo.getCachedSizeKb();
                    long freeKb = memInfo.getFreeSizeKb();
                    long zramKb = memInfo.getZramTotalSizeKb();
                    long kernelKb = memInfo.getKernelUsedSizeKb();
                    EventLogTags.writeAmMeminfo(cachedKb * 1024L, freeKb * 1024L, zramKb * 1024L, kernelKb * 1024L, nativeProcTotalPss * 1024L);
                    this.mProcessStats.addSysMemUsageLocked(cachedKb, freeKb, zramKb, kernelKb, nativeProcTotalPss);
                }
            }
            if (!brief) {
                if (!isCompact) {
                    pw.print("Total RAM: ");
                    pw.print(ActivityManagerService.stringifyKBSize(memInfo.getTotalSizeKb()));
                    pw.print(" (status ");
                    switch (this.mLastMemoryLevel) {
                        case 0: {
                            pw.println("normal)");
                            break;
                        }
                        case 1: {
                            pw.println("moderate)");
                            break;
                        }
                        case 2: {
                            pw.println("low)");
                            break;
                        }
                        case 3: {
                            pw.println("critical)");
                            break;
                        }
                        default: {
                            pw.print(this.mLastMemoryLevel);
                            pw.println(")");
                        }
                    }
                    pw.print(" Free RAM: ");
                    pw.print(ActivityManagerService.stringifyKBSize(cachedPss + memInfo.getCachedSizeKb() + memInfo.getFreeSizeKb()));
                    pw.print(" (");
                    pw.print(ActivityManagerService.stringifyKBSize(cachedPss));
                    pw.print(" cached pss + ");
                    pw.print(ActivityManagerService.stringifyKBSize(memInfo.getCachedSizeKb()));
                    pw.print(" cached kernel + ");
                    pw.print(ActivityManagerService.stringifyKBSize(memInfo.getFreeSizeKb()));
                    pw.println(" free)");
                } else {
                    pw.print("ram,");
                    pw.print(memInfo.getTotalSizeKb());
                    pw.print(",");
                    pw.print(cachedPss + memInfo.getCachedSizeKb() + memInfo.getFreeSizeKb());
                    pw.print(",");
                    pw.println(totalPss - cachedPss);
                }
            }
            long lostRAM = memInfo.getTotalSizeKb() - (totalPss - totalSwapPss) - memInfo.getFreeSizeKb() - memInfo.getCachedSizeKb() - memInfo.getKernelUsedSizeKb() - memInfo.getZramTotalSizeKb();
            if (!isCompact) {
                pw.print(" Used RAM: ");
                pw.print(ActivityManagerService.stringifyKBSize(totalPss - cachedPss + memInfo.getKernelUsedSizeKb()));
                pw.print(" (");
                pw.print(ActivityManagerService.stringifyKBSize(totalPss - cachedPss));
                pw.print(" used pss + ");
                pw.print(ActivityManagerService.stringifyKBSize(memInfo.getKernelUsedSizeKb()));
                pw.print(" kernel)\n");
                pw.print(" Lost RAM: ");
                pw.println(ActivityManagerService.stringifyKBSize(lostRAM));
            } else {
                pw.print("lostram,");
                pw.println(lostRAM);
            }
            if (!brief) {
                if (memInfo.getZramTotalSizeKb() != 0L) {
                    if (!isCompact) {
                        pw.print("     ZRAM: ");
                        pw.print(ActivityManagerService.stringifyKBSize(memInfo.getZramTotalSizeKb()));
                        pw.print(" physical used for ");
                        pw.print(ActivityManagerService.stringifyKBSize(memInfo.getSwapTotalSizeKb() - memInfo.getSwapFreeSizeKb()));
                        pw.print(" in swap (");
                        pw.print(ActivityManagerService.stringifyKBSize(memInfo.getSwapTotalSizeKb()));
                        pw.println(" total swap)");
                    } else {
                        pw.print("zram,");
                        pw.print(memInfo.getZramTotalSizeKb());
                        pw.print(",");
                        pw.print(memInfo.getSwapTotalSizeKb());
                        pw.print(",");
                        pw.println(memInfo.getSwapFreeSizeKb());
                    }
                }
                long[] ksm = this.getKsmInfo();
                if (!isCompact) {
                    if (ksm[1] != 0L || ksm[0] != 0L || ksm[2] != 0L || ksm[3] != 0L) {
                        pw.print("      KSM: ");
                        pw.print(ActivityManagerService.stringifyKBSize(ksm[1]));
                        pw.print(" saved from shared ");
                        pw.print(ActivityManagerService.stringifyKBSize(ksm[0]));
                        pw.print("           ");
                        pw.print(ActivityManagerService.stringifyKBSize(ksm[2]));
                        pw.print(" unshared; ");
                        pw.print(ActivityManagerService.stringifyKBSize(ksm[3]));
                        pw.println(" volatile");
                    }
                    pw.print("   Tuning: ");
                    pw.print(ActivityManager.staticGetMemoryClass());
                    pw.print(" (large ");
                    pw.print(ActivityManager.staticGetLargeMemoryClass());
                    pw.print("), oom ");
                    pw.print(ActivityManagerService.stringifySize(this.mProcessList.getMemLevel(906), 1024));
                    pw.print(", restore limit ");
                    pw.print(ActivityManagerService.stringifyKBSize(this.mProcessList.getCachedRestoreThresholdKb()));
                    if (ActivityManager.isLowRamDeviceStatic()) {
                        pw.print(" (low-ram)");
                    }
                    if (ActivityManager.isHighEndGfx()) {
                        pw.print(" (high-end-gfx)");
                    }
                    pw.println();
                } else {
                    pw.print("ksm,");
                    pw.print(ksm[1]);
                    pw.print(",");
                    pw.print(ksm[0]);
                    pw.print(",");
                    pw.print(ksm[2]);
                    pw.print(",");
                    pw.println(ksm[3]);
                    pw.print("tuning,");
                    pw.print(ActivityManager.staticGetMemoryClass());
                    pw.print(',');
                    pw.print(ActivityManager.staticGetLargeMemoryClass());
                    pw.print(',');
                    pw.print(this.mProcessList.getMemLevel(906) / 1024L);
                    if (ActivityManager.isLowRamDeviceStatic()) {
                        pw.print(",low-ram");
                    }
                    if (ActivityManager.isHighEndGfx()) {
                        pw.print(",high-end-gfx");
                    }
                    pw.println();
                }
            }
        }
    }

    private void appendBasicMemEntry(StringBuilder sb, int oomAdj, int procState, long pss, long memtrack, String name) {
        sb.append("  ");
        sb.append(ProcessList.makeOomAdjString(oomAdj));
        sb.append(' ');
        sb.append(ProcessList.makeProcStateString(procState));
        sb.append(' ');
        ProcessList.appendRamKb(sb, pss);
        sb.append(": ");
        sb.append(name);
        if (memtrack > 0L) {
            sb.append(" (");
            sb.append(ActivityManagerService.stringifyKBSize(memtrack));
            sb.append(" memtrack)");
        }
    }

    private void appendMemInfo(StringBuilder sb, ProcessMemInfo mi) {
        this.appendBasicMemEntry(sb, mi.oomAdj, mi.procState, mi.pss, mi.memtrack, mi.name);
        sb.append(" (pid ");
        sb.append(mi.pid);
        sb.append(") ");
        sb.append(mi.adjType);
        sb.append('\n');
        if (mi.adjReason != null) {
            sb.append("                      ");
            sb.append(mi.adjReason);
            sb.append('\n');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportMemUsage(ArrayList<ProcessMemInfo> memInfos) {
        long[] ksm;
        List<ProcessCpuTracker.Stats> stats;
        Object mi;
        SparseArray<ProcessMemInfo> infoMap = new SparseArray<ProcessMemInfo>(memInfos.size());
        int N = memInfos.size();
        for (int i = 0; i < N; ++i) {
            mi = memInfos.get(i);
            infoMap.put(((ProcessMemInfo)mi).pid, (ProcessMemInfo)mi);
        }
        this.updateCpuStatsNow();
        long[] memtrackTmp = new long[1];
        mi = this.mProcessCpuTracker;
        synchronized (mi) {
            stats = this.mProcessCpuTracker.getStats(st -> st.vsize > 0L);
        }
        int statsCount = stats.size();
        for (int i = 0; i < statsCount; ++i) {
            ProcessCpuTracker.Stats st2 = stats.get(i);
            long pss = Debug.getPss(st2.pid, null, memtrackTmp);
            if (pss <= 0L || infoMap.indexOfKey(st2.pid) >= 0) continue;
            ProcessMemInfo mi2 = new ProcessMemInfo(st2.name, st2.pid, -1000, -1, "native", null);
            mi2.pss = pss;
            mi2.memtrack = memtrackTmp[0];
            memInfos.add(mi2);
        }
        long totalPss = 0L;
        long totalMemtrack = 0L;
        int N2 = memInfos.size();
        for (int i = 0; i < N2; ++i) {
            ProcessMemInfo mi3 = memInfos.get(i);
            if (mi3.pss == 0L) {
                mi3.pss = Debug.getPss(mi3.pid, null, memtrackTmp);
                mi3.memtrack = memtrackTmp[0];
            }
            totalPss += mi3.pss;
            totalMemtrack += mi3.memtrack;
        }
        Collections.sort(memInfos, new Comparator<ProcessMemInfo>(){

            @Override
            public int compare(ProcessMemInfo lhs, ProcessMemInfo rhs) {
                if (lhs.oomAdj != rhs.oomAdj) {
                    return lhs.oomAdj < rhs.oomAdj ? -1 : 1;
                }
                if (lhs.pss != rhs.pss) {
                    return lhs.pss < rhs.pss ? 1 : -1;
                }
                return 0;
            }
        });
        StringBuilder tag = new StringBuilder(128);
        StringBuilder stack = new StringBuilder(128);
        tag.append("Low on memory -- ");
        ActivityManagerService.appendMemBucket(tag, totalPss, "total", false);
        ActivityManagerService.appendMemBucket(stack, totalPss, "total", true);
        StringBuilder fullNativeBuilder = new StringBuilder(1024);
        StringBuilder shortNativeBuilder = new StringBuilder(1024);
        StringBuilder fullJavaBuilder = new StringBuilder(1024);
        boolean firstLine = true;
        int lastOomAdj = Integer.MIN_VALUE;
        long extraNativeRam = 0L;
        long extraNativeMemtrack = 0L;
        long cachedPss = 0L;
        int N3 = memInfos.size();
        for (int i = 0; i < N3; ++i) {
            ProcessMemInfo mi4 = memInfos.get(i);
            if (mi4.oomAdj >= 900) {
                cachedPss += mi4.pss;
            }
            if (mi4.oomAdj != -1000 && (mi4.oomAdj < 500 || mi4.oomAdj == 600 || mi4.oomAdj == 700)) {
                if (lastOomAdj != mi4.oomAdj) {
                    lastOomAdj = mi4.oomAdj;
                    if (mi4.oomAdj <= 0) {
                        tag.append(" / ");
                    }
                    if (mi4.oomAdj >= 0) {
                        if (firstLine) {
                            stack.append(":");
                            firstLine = false;
                        }
                        stack.append("\n\t at ");
                    } else {
                        stack.append("$");
                    }
                } else {
                    tag.append(" ");
                    stack.append("$");
                }
                if (mi4.oomAdj <= 0) {
                    ActivityManagerService.appendMemBucket(tag, mi4.pss, mi4.name, false);
                }
                ActivityManagerService.appendMemBucket(stack, mi4.pss, mi4.name, true);
                if (mi4.oomAdj >= 0 && (i + 1 >= N3 || memInfos.get((int)(i + 1)).oomAdj != lastOomAdj)) {
                    stack.append("(");
                    for (int k = 0; k < DUMP_MEM_OOM_ADJ.length; ++k) {
                        if (DUMP_MEM_OOM_ADJ[k] != mi4.oomAdj) continue;
                        stack.append(DUMP_MEM_OOM_LABEL[k]);
                        stack.append(":");
                        stack.append(DUMP_MEM_OOM_ADJ[k]);
                    }
                    stack.append(")");
                }
            }
            this.appendMemInfo(fullNativeBuilder, mi4);
            if (mi4.oomAdj == -1000) {
                if (mi4.pss >= 512L) {
                    this.appendMemInfo(shortNativeBuilder, mi4);
                    continue;
                }
                extraNativeRam += mi4.pss;
                extraNativeMemtrack += mi4.memtrack;
                continue;
            }
            if (extraNativeRam > 0L) {
                this.appendBasicMemEntry(shortNativeBuilder, -1000, -1, extraNativeRam, extraNativeMemtrack, "(Other native)");
                shortNativeBuilder.append('\n');
                extraNativeRam = 0L;
            }
            this.appendMemInfo(fullJavaBuilder, mi4);
        }
        fullJavaBuilder.append("           ");
        ProcessList.appendRamKb(fullJavaBuilder, totalPss);
        fullJavaBuilder.append(": TOTAL");
        if (totalMemtrack > 0L) {
            fullJavaBuilder.append(" (");
            fullJavaBuilder.append(ActivityManagerService.stringifyKBSize(totalMemtrack));
            fullJavaBuilder.append(" memtrack)");
        }
        fullJavaBuilder.append("\n");
        MemInfoReader memInfo = new MemInfoReader();
        memInfo.readMemInfo();
        long[] infos = memInfo.getRawInfo();
        StringBuilder memInfoBuilder = new StringBuilder(1024);
        Debug.getMemInfo(infos);
        memInfoBuilder.append("  MemInfo: ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[5])).append(" slab, ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[4])).append(" shmem, ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[10])).append(" vm alloc, ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[11])).append(" page tables ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[12])).append(" kernel stack\n");
        memInfoBuilder.append("           ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[2])).append(" buffers, ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[3])).append(" cached, ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[9])).append(" mapped, ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[1])).append(" free\n");
        if (infos[8] != 0L) {
            memInfoBuilder.append("  ZRAM: ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[8]));
            memInfoBuilder.append(" RAM, ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[6]));
            memInfoBuilder.append(" swap total, ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(infos[7]));
            memInfoBuilder.append(" swap free\n");
        }
        if ((ksm = this.getKsmInfo())[1] != 0L || ksm[0] != 0L || ksm[2] != 0L || ksm[3] != 0L) {
            memInfoBuilder.append("  KSM: ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(ksm[1]));
            memInfoBuilder.append(" saved from shared ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(ksm[0]));
            memInfoBuilder.append("\n       ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(ksm[2]));
            memInfoBuilder.append(" unshared; ");
            memInfoBuilder.append(ActivityManagerService.stringifyKBSize(ksm[3]));
            memInfoBuilder.append(" volatile\n");
        }
        memInfoBuilder.append("  Free RAM: ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(cachedPss + memInfo.getCachedSizeKb() + memInfo.getFreeSizeKb()));
        memInfoBuilder.append("\n");
        memInfoBuilder.append("  Used RAM: ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(totalPss - cachedPss + memInfo.getKernelUsedSizeKb()));
        memInfoBuilder.append("\n");
        memInfoBuilder.append("  Lost RAM: ");
        memInfoBuilder.append(ActivityManagerService.stringifyKBSize(memInfo.getTotalSizeKb() - totalPss - memInfo.getFreeSizeKb() - memInfo.getCachedSizeKb() - memInfo.getKernelUsedSizeKb() - memInfo.getZramTotalSizeKb()));
        memInfoBuilder.append("\n");
        Slog.i("ActivityManager", "Low on memory:");
        Slog.i("ActivityManager", shortNativeBuilder.toString());
        Slog.i("ActivityManager", fullJavaBuilder.toString());
        Slog.i("ActivityManager", memInfoBuilder.toString());
        StringBuilder dropBuilder = new StringBuilder(1024);
        dropBuilder.append("Low on memory:");
        dropBuilder.append((CharSequence)stack);
        dropBuilder.append('\n');
        dropBuilder.append((CharSequence)fullNativeBuilder);
        dropBuilder.append((CharSequence)fullJavaBuilder);
        dropBuilder.append('\n');
        dropBuilder.append((CharSequence)memInfoBuilder);
        dropBuilder.append('\n');
        StringWriter catSw = new StringWriter();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            FastPrintWriter catPw = new FastPrintWriter(catSw, false, 256);
            String[] emptyArgs = new String[]{};
            ((PrintWriter)catPw).println();
            this.dumpProcessesLocked(null, catPw, emptyArgs, 0, false, null);
            ((PrintWriter)catPw).println();
            this.mServices.newServiceDumperLocked(null, catPw, emptyArgs, 0, false, null).dumpLocked();
            ((PrintWriter)catPw).println();
            this.dumpActivitiesLocked(null, catPw, emptyArgs, 0, false, false, null);
            ((PrintWriter)catPw).flush();
        }
        dropBuilder.append(catSw.toString());
        this.addErrorToDropBox("lowmem", null, "system_server", null, null, tag.toString(), dropBuilder.toString(), null, null);
        activityManagerService = this;
        synchronized (activityManagerService) {
            long now = SystemClock.uptimeMillis();
            if (this.mLastMemUsageReportTime < now) {
                this.mLastMemUsageReportTime = now;
            }
        }
    }

    private static boolean scanArgs(String[] args, String value) {
        if (args != null) {
            for (String arg : args) {
                if (!value.equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean removeDyingProviderLocked(ProcessRecord proc, ContentProviderRecord cpr, boolean always) {
        boolean inLaunching = this.mLaunchingProviders.contains(cpr);
        if (!inLaunching || always) {
            ContentProviderRecord contentProviderRecord = cpr;
            synchronized (contentProviderRecord) {
                cpr.launchingApp = null;
                cpr.notifyAll();
            }
            this.mProviderMap.removeProviderByClass(cpr.name, UserHandle.getUserId(cpr.uid));
            String[] names = cpr.info.authority.split(";");
            for (int j = 0; j < names.length; ++j) {
                this.mProviderMap.removeProviderByName(names[j], UserHandle.getUserId(cpr.uid));
            }
        }
        for (int i = cpr.connections.size() - 1; i >= 0; --i) {
            ContentProviderConnection conn = cpr.connections.get(i);
            if (conn.waiting && inLaunching && !always) continue;
            ProcessRecord capp = conn.client;
            conn.dead = true;
            if (conn.stableCount > 0) {
                if (capp.persistent || capp.thread == null || capp.pid == 0 || capp.pid == MY_PID) continue;
                capp.kill("depends on provider " + cpr.name.flattenToShortString() + " in dying proc " + (proc != null ? proc.processName : "??") + " (adj " + (proc != null ? Integer.valueOf(proc.setAdj) : "??") + ")", true);
                continue;
            }
            if (capp.thread == null || conn.provider.provider == null) continue;
            try {
                capp.thread.unstableProviderDied(conn.provider.provider.asBinder());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            cpr.connections.remove(i);
            if (!conn.client.conProviders.remove(conn)) continue;
            this.stopAssociationLocked(capp.uid, capp.processName, cpr.uid, cpr.name);
        }
        if (inLaunching && always) {
            this.mLaunchingProviders.remove(cpr);
        }
        return inLaunching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean cleanUpApplicationRecordLocked(final ProcessRecord app, boolean restarting, boolean allowRestart, int index, boolean replacingPid) {
        int i;
        if (index >= 0) {
            this.removeLruProcessLocked(app);
            ProcessList.remove(app.pid);
        }
        this.mProcessesToGc.remove(app);
        this.mPendingPssProcesses.remove(app);
        if (app.crashDialog != null && !app.forceCrashReport) {
            app.crashDialog.dismiss();
            app.crashDialog = null;
        }
        if (app.anrDialog != null) {
            app.anrDialog.dismiss();
            app.anrDialog = null;
        }
        if (app.waitDialog != null) {
            app.waitDialog.dismiss();
            app.waitDialog = null;
        }
        app.crashing = false;
        app.notResponding = false;
        app.resetPackageList(this.mProcessStats);
        app.unlinkDeathRecipient();
        app.makeInactive(this.mProcessStats);
        app.waitingToKill = null;
        app.forcingToImportant = null;
        this.updateProcessForegroundLocked(app, false, false);
        app.foregroundActivities = false;
        app.hasShownUi = false;
        app.treatLikeActivity = false;
        app.hasAboveClient = false;
        app.hasClientActivities = false;
        this.mServices.killServicesLocked(app, allowRestart);
        boolean restart = false;
        for (i = app.pubProviders.size() - 1; i >= 0; --i) {
            boolean always;
            ContentProviderRecord cpr = app.pubProviders.valueAt(i);
            boolean inLaunching = this.removeDyingProviderLocked(app, cpr, always = app.bad || !allowRestart);
            if ((inLaunching || always) && cpr.hasConnectionOrHandle()) {
                restart = true;
            }
            cpr.provider = null;
            cpr.proc = null;
        }
        app.pubProviders.clear();
        if (this.cleanupAppInLaunchingProvidersLocked(app, false)) {
            restart = true;
        }
        if (!app.conProviders.isEmpty()) {
            for (i = app.conProviders.size() - 1; i >= 0; --i) {
                ContentProviderConnection conn = app.conProviders.get(i);
                conn.provider.connections.remove(conn);
                this.stopAssociationLocked(app.uid, app.processName, conn.provider.uid, conn.provider.name);
            }
            app.conProviders.clear();
        }
        this.skipCurrentReceiverLocked(app);
        for (i = app.receivers.size() - 1; i >= 0; --i) {
            this.removeReceiverLocked(app.receivers.valueAt(i));
        }
        app.receivers.clear();
        if (this.mBackupTarget != null && app.pid == this.mBackupTarget.app.pid) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                        bm.agentDisconnected(app.info.packageName);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }
        for (i = this.mPendingProcessChanges.size() - 1; i >= 0; --i) {
            ProcessChangeItem item = this.mPendingProcessChanges.get(i);
            if (item.pid != app.pid) continue;
            this.mPendingProcessChanges.remove(i);
            this.mAvailProcessChanges.add(item);
        }
        this.mUiHandler.obtainMessage(32, app.pid, app.info.uid, null).sendToTarget();
        if (restarting) {
            return false;
        }
        if (!app.persistent || app.isolated) {
            if (!replacingPid) {
                this.removeProcessNameLocked(app.processName, app.uid, app);
            }
            if (this.mHeavyWeightProcess == app) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(25, this.mHeavyWeightProcess.userId, 0));
                this.mHeavyWeightProcess = null;
            }
        } else if (!app.removed && this.mPersistentStartingProcesses.indexOf(app) < 0) {
            this.mPersistentStartingProcesses.add(app);
            restart = true;
        }
        this.mProcessesOnHold.remove(app);
        if (app == this.mHomeProcess) {
            this.mHomeProcess = null;
        }
        if (app == this.mPreviousProcess) {
            this.mPreviousProcess = null;
        }
        if (restart && !app.isolated) {
            if (index < 0) {
                ProcessList.remove(app.pid);
            }
            this.addProcessNameLocked(app);
            this.startProcessLocked(app, "restart", app.processName);
            return true;
        }
        if (app.pid > 0 && app.pid != MY_PID) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.remove(app.pid);
                this.mHandler.removeMessages(20, app);
            }
            this.mBatteryStatsService.noteProcessFinish(app.processName, app.info.uid);
            if (app.isolated) {
                this.mBatteryStatsService.removeIsolatedUid(app.uid, app.info.uid);
            }
            app.setPid(0);
        }
        return false;
    }

    boolean checkAppInLaunchingProvidersLocked(ProcessRecord app) {
        for (int i = this.mLaunchingProviders.size() - 1; i >= 0; --i) {
            ContentProviderRecord cpr = this.mLaunchingProviders.get(i);
            if (cpr.launchingApp != app) continue;
            return true;
        }
        return false;
    }

    boolean cleanupAppInLaunchingProvidersLocked(ProcessRecord app, boolean alwaysBad) {
        boolean restart = false;
        for (int i = this.mLaunchingProviders.size() - 1; i >= 0; --i) {
            ContentProviderRecord cpr = this.mLaunchingProviders.get(i);
            if (cpr.launchingApp != app) continue;
            if (!alwaysBad && !app.bad && cpr.hasConnectionOrHandle()) {
                restart = true;
                continue;
            }
            this.removeDyingProviderLocked(app, cpr, true);
        }
        return restart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.RunningServiceInfo> getServices(int maxNum, int flags) {
        this.enforceNotIsolatedCaller("getServices");
        int callingUid = Binder.getCallingUid();
        boolean canInteractAcrossUsers = ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingUid) == 0;
        boolean allowed = this.isGetTasksAllowed("getServices", Binder.getCallingPid(), callingUid);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.getRunningServiceInfoLocked(maxNum, flags, callingUid, allowed, canInteractAcrossUsers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingIntent getRunningServiceControlPanel(ComponentName name) {
        this.enforceNotIsolatedCaller("getRunningServiceControlPanel");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.getRunningServiceControlPanelLocked(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName startService(IApplicationThread caller, Intent service, String resolvedType, boolean requireForeground, String callingPackage, int userId) throws TransactionTooLargeException {
        this.enforceNotIsolatedCaller("startService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        if (callingPackage == null) {
            throw new IllegalArgumentException("callingPackage cannot be null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ComponentName res;
            int callingPid = Binder.getCallingPid();
            int callingUid = Binder.getCallingUid();
            long origId = Binder.clearCallingIdentity();
            try {
                res = this.mServices.startServiceLocked(caller, service, resolvedType, callingPid, callingUid, requireForeground, callingPackage, userId);
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName startServiceInPackage(int uid, Intent service, String resolvedType, boolean fgRequired, String callingPackage, int userId) throws TransactionTooLargeException {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ComponentName res;
            long origId = Binder.clearCallingIdentity();
            try {
                res = this.mServices.startServiceLocked(null, service, resolvedType, -1, uid, fgRequired, callingPackage, userId);
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopService(IApplicationThread caller, Intent service, String resolvedType, int userId) {
        this.enforceNotIsolatedCaller("stopService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.stopServiceLocked(caller, service, resolvedType, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder peekService(Intent service, String resolvedType, String callingPackage) {
        this.enforceNotIsolatedCaller("peekService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        if (callingPackage == null) {
            throw new IllegalArgumentException("callingPackage cannot be null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.peekServiceLocked(service, resolvedType, callingPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopServiceToken(ComponentName className, IBinder token, int startId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.stopServiceTokenLocked(className, token, startId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServiceForeground(ComponentName className, IBinder token, int id2, Notification notification, int flags) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mServices.setServiceForegroundLocked(className, token, id2, notification, flags);
        }
    }

    @Override
    public int handleIncomingUser(int callingPid, int callingUid, int userId, boolean allowAll, boolean requireFull, String name, String callerPackage) {
        return this.mUserController.handleIncomingUser(callingPid, callingUid, userId, allowAll, requireFull ? 2 : 0, name, callerPackage);
    }

    boolean isSingleton(String componentProcessName, ApplicationInfo aInfo, String className, int flags) {
        boolean result = false;
        if (UserHandle.getAppId(aInfo.uid) >= 10000) {
            if ((flags & 0x40000000) != 0) {
                if (ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS", aInfo.uid) != 0) {
                    ComponentName comp = new ComponentName(aInfo.packageName, className);
                    String msg = "Permission Denial: Component " + comp.flattenToShortString() + " requests FLAG_SINGLE_USER, but app does not hold " + "android.permission.INTERACT_ACROSS_USERS";
                    Slog.w("ActivityManager", msg);
                    throw new SecurityException(msg);
                }
                result = true;
            }
        } else if ("system".equals(componentProcessName)) {
            result = true;
        } else if ((flags & 0x40000000) != 0) {
            result = UserHandle.isSameApp(aInfo.uid, 1001) || (aInfo.flags & 8) != 0;
        }
        return result;
    }

    boolean isValidSingletonCall(int callingUid, int componentUid) {
        int componentAppId = UserHandle.getAppId(componentUid);
        return UserHandle.isSameApp(callingUid, componentUid) || componentAppId == 1000 || componentAppId == 1001 || ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", componentUid) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bindService(IApplicationThread caller, IBinder token, Intent service, String resolvedType, IServiceConnection connection, int flags, String callingPackage, int userId) throws TransactionTooLargeException {
        this.enforceNotIsolatedCaller("bindService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        if (callingPackage == null) {
            throw new IllegalArgumentException("callingPackage cannot be null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.bindServiceLocked(caller, token, service, resolvedType, connection, flags, callingPackage, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unbindService(IServiceConnection connection) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.unbindServiceLocked(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishService(IBinder token, Intent intent, IBinder service) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!(token instanceof ServiceRecord)) {
                throw new IllegalArgumentException("Invalid service token");
            }
            this.mServices.publishServiceLocked((ServiceRecord)token, intent, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindFinished(IBinder token, Intent intent, boolean doRebind) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mServices.unbindFinishedLocked((ServiceRecord)token, intent, doRebind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceDoneExecuting(IBinder token, int type, int startId, int res) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!(token instanceof ServiceRecord)) {
                Slog.e("ActivityManager", "serviceDoneExecuting: Invalid service token=" + token);
                throw new IllegalArgumentException("Invalid service token");
            }
            this.mServices.serviceDoneExecutingLocked((ServiceRecord)token, type, startId, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bindBackupAgent(String packageName, int backupMode, int userId) {
        int newBackupUid;
        int oldBackupUid;
        this.enforceCallingPermission("android.permission.CONFIRM_FULL_BACKUP", "bindBackupAgent");
        IPackageManager pm = AppGlobals.getPackageManager();
        ApplicationInfo app = null;
        try {
            app = pm.getApplicationInfo(packageName, 0, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (app == null) {
            Slog.w("ActivityManager", "Unable to bind backup agent for " + packageName);
            return false;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            BatteryStatsImpl stats;
            BatteryStatsImpl.Uid.Pkg.Serv ss = null;
            BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
            synchronized (batteryStatsImpl) {
                ss = stats.getServiceStatsLocked(app.uid, app.packageName, app.name);
            }
            try {
                AppGlobals.getPackageManager().setPackageStoppedState(app.packageName, false, UserHandle.getUserId(app.uid));
            }
            catch (RemoteException remoteException) {
            }
            catch (IllegalArgumentException e) {
                Slog.w("ActivityManager", "Failed trying to unstop package " + app.packageName + ": " + e);
            }
            BackupRecord r = new BackupRecord(ss, app, backupMode);
            ComponentName hostingName = backupMode == 0 ? new ComponentName(app.packageName, app.backupAgentName) : new ComponentName("android", "FullBackupAgent");
            ProcessRecord proc = this.startProcessLocked(app.processName, app, false, 0, "backup", hostingName, false, false, false);
            if (proc == null) {
                Slog.e("ActivityManager", "Unable to start backup agent process " + r);
                return false;
            }
            if (UserHandle.isApp(app.uid) && backupMode == 1) {
                proc.inFullBackup = true;
            }
            r.app = proc;
            oldBackupUid = this.mBackupTarget != null ? this.mBackupTarget.appInfo.uid : -1;
            newBackupUid = proc.inFullBackup ? r.appInfo.uid : -1;
            this.mBackupTarget = r;
            this.mBackupAppName = app.packageName;
            this.updateOomAdjLocked(proc, true);
            if (proc.thread != null) {
                try {
                    proc.thread.scheduleCreateBackupAgent(app, this.compatibilityInfoForPackageLocked(app), backupMode);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        JobSchedulerInternal js = LocalServices.getService(JobSchedulerInternal.class);
        if (oldBackupUid != -1) {
            js.removeBackingUpUid(oldBackupUid);
        }
        if (newBackupUid != -1) {
            js.addBackingUpUid(newBackupUid);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPendingBackup() {
        this.enforceCallingPermission("android.permission.BACKUP", "clearPendingBackup");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mBackupTarget = null;
            this.mBackupAppName = null;
        }
        JobSchedulerInternal js = LocalServices.getService(JobSchedulerInternal.class);
        js.clearAllBackingUpUids();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backupAgentCreated(String agentPackageName, IBinder agent) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!agentPackageName.equals(this.mBackupAppName)) {
                Slog.e("ActivityManager", "Backup agent created for " + agentPackageName + " but not requested!");
                return;
            }
        }
        long oldIdent = Binder.clearCallingIdentity();
        try {
            IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
            bm.agentConnected(agentPackageName, agent);
        }
        catch (RemoteException bm) {
        }
        catch (Exception e) {
            Slog.w("ActivityManager", "Exception trying to deliver BackupAgent binding: ");
            e.printStackTrace();
        }
        finally {
            Binder.restoreCallingIdentity(oldIdent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void unbindBackupAgent(ApplicationInfo appInfo) {
        int oldBackupUid;
        if (appInfo == null) {
            Slog.w("ActivityManager", "unbind backup agent for null app");
            return;
        }
        ActivityManagerService activityManagerService = this;
        // MONITORENTER : activityManagerService
        try {
            if (this.mBackupAppName == null) {
                Slog.w("ActivityManager", "Unbinding backup agent with no active backup");
                return;
            }
            if (!this.mBackupAppName.equals(appInfo.packageName)) {
                Slog.e("ActivityManager", "Unbind of " + appInfo + " but is not the current backup target");
                return;
            }
            ProcessRecord proc = this.mBackupTarget.app;
            this.updateOomAdjLocked(proc, true);
            proc.inFullBackup = false;
            int n = oldBackupUid = this.mBackupTarget != null ? this.mBackupTarget.appInfo.uid : -1;
            if (proc.thread != null) {
                try {
                    proc.thread.scheduleDestroyBackupAgent(appInfo, this.compatibilityInfoForPackageLocked(appInfo));
                }
                catch (Exception e) {
                    Slog.e("ActivityManager", "Exception when unbinding backup agent:");
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.mBackupTarget = null;
            this.mBackupAppName = null;
        }
        // MONITOREXIT : activityManagerService
        if (oldBackupUid == -1) return;
        JobSchedulerInternal js = LocalServices.getService(JobSchedulerInternal.class);
        js.removeBackingUpUid(oldBackupUid);
    }

    private boolean isInstantApp(ProcessRecord record, String callerPackage, int uid) {
        if (UserHandle.getAppId(uid) < 10000) {
            return false;
        }
        if (record != null) {
            return record.info.isInstantApp();
        }
        if (callerPackage == null) {
            Slog.e("ActivityManager", "isInstantApp with an application's uid, no record, and no package name");
            throw new IllegalArgumentException("Calling application did not provide package name");
        }
        this.mAppOpsService.checkPackage(uid, callerPackage);
        try {
            IPackageManager pm = AppGlobals.getPackageManager();
            return pm.isInstantApp(callerPackage, UserHandle.getUserId(uid));
        }
        catch (RemoteException e) {
            Slog.e("ActivityManager", "Error looking up if " + callerPackage + " is an instant app.", e);
            return true;
        }
    }

    boolean isPendingBroadcastProcessLocked(int pid) {
        return this.mFgBroadcastQueue.isPendingBroadcastProcessLocked(pid) || this.mBgBroadcastQueue.isPendingBroadcastProcessLocked(pid);
    }

    void skipPendingBroadcastLocked(int pid) {
        Slog.w("ActivityManager", "Unattached app died before broadcast acknowledged, skipping");
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.skipPendingBroadcastLocked(pid);
        }
    }

    boolean sendPendingBroadcastsLocked(ProcessRecord app) {
        boolean didSomething = false;
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            didSomething |= queue.sendPendingBroadcastsLocked(app);
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Intent registerReceiver(IApplicationThread caller, String callerPackage, IIntentReceiver receiver, IntentFilter filter, String permission2, int userId, int flags) {
        Intent sticky;
        boolean instantApp;
        int callingPid;
        int callingUid;
        this.enforceNotIsolatedCaller("registerReceiver");
        ArrayList<Intent> stickyIntents = null;
        ProcessRecord callerApp = null;
        boolean visibleToInstantApps = (flags & 1) != 0;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (caller != null) {
                callerApp = this.getRecordForAppLocked(caller);
                if (callerApp == null) {
                    throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when registering receiver " + receiver);
                }
                if (callerApp.info.uid != 1000 && !callerApp.pkgList.containsKey(callerPackage) && !"android".equals(callerPackage)) {
                    throw new SecurityException("Given caller package " + callerPackage + " is not running in process " + callerApp);
                }
                callingUid = callerApp.info.uid;
                callingPid = callerApp.pid;
            } else {
                callerPackage = null;
                callingUid = Binder.getCallingUid();
                callingPid = Binder.getCallingPid();
            }
            instantApp = this.isInstantApp(callerApp, callerPackage, callingUid);
            userId = this.mUserController.handleIncomingUser(callingPid, callingUid, userId, true, 2, "registerReceiver", callerPackage);
            Iterator<String> actions = filter.actionsIterator();
            if (actions == null) {
                ArrayList noAction = new ArrayList(1);
                noAction.add(null);
                actions = noAction.iterator();
            }
            int[] userIds = new int[]{-1, UserHandle.getUserId(callingUid)};
            while (actions.hasNext()) {
                String action = actions.next();
                for (int id2 : userIds) {
                    ArrayList<Intent> intents;
                    ArrayMap<String, ArrayList<Intent>> stickies = this.mStickyBroadcasts.get(id2);
                    if (stickies == null || (intents = stickies.get(action)) == null) continue;
                    if (stickyIntents == null) {
                        stickyIntents = new ArrayList<Intent>();
                    }
                    stickyIntents.addAll(intents);
                }
            }
        }
        ArrayList<Intent> allSticky = null;
        if (stickyIntents != null) {
            ContentResolver resolver = this.mContext.getContentResolver();
            int N = stickyIntents.size();
            for (int i = 0; i < N; ++i) {
                Intent intent = (Intent)stickyIntents.get(i);
                if (instantApp && (intent.getFlags() & 0x200000) == 0 || filter.match(resolver, intent, true, "ActivityManager") < 0) continue;
                if (allSticky == null) {
                    allSticky = new ArrayList<Intent>();
                }
                allSticky.add(intent);
            }
        }
        Intent intent = sticky = allSticky != null ? (Intent)allSticky.get(0) : null;
        if (receiver == null) {
            return sticky;
        }
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            if (callerApp != null && (callerApp.thread == null || callerApp.thread.asBinder() != caller.asBinder())) {
                return null;
            }
            ReceiverList rl = this.mRegisteredReceivers.get(receiver.asBinder());
            if (rl == null) {
                rl = new ReceiverList(this, callerApp, callingPid, callingUid, userId, receiver);
                if (rl.app != null) {
                    rl.app.receivers.add(rl);
                } else {
                    try {
                        receiver.asBinder().linkToDeath(rl, 0);
                    }
                    catch (RemoteException e) {
                        return sticky;
                    }
                    rl.linkedToDeath = true;
                }
                this.mRegisteredReceivers.put(receiver.asBinder(), rl);
            } else {
                if (rl.uid != callingUid) {
                    throw new IllegalArgumentException("Receiver requested to register for uid " + callingUid + " was previously registered for uid " + rl.uid + " callerPackage is " + callerPackage);
                }
                if (rl.pid != callingPid) {
                    throw new IllegalArgumentException("Receiver requested to register for pid " + callingPid + " was previously registered for pid " + rl.pid + " callerPackage is " + callerPackage);
                }
                if (rl.userId != userId) {
                    throw new IllegalArgumentException("Receiver requested to register for user " + userId + " was previously registered for user " + rl.userId + " callerPackage is " + callerPackage);
                }
            }
            BroadcastFilter bf = new BroadcastFilter(filter, rl, callerPackage, permission2, callingUid, userId, instantApp, visibleToInstantApps);
            rl.add(bf);
            if (!bf.debugCheck()) {
                Slog.w("ActivityManager", "==> For Dynamic broadcast");
            }
            this.mReceiverResolver.addFilter(bf);
            if (allSticky != null) {
                ArrayList<BroadcastFilter> receivers = new ArrayList<BroadcastFilter>();
                receivers.add(bf);
                int stickyCount = allSticky.size();
                for (int i = 0; i < stickyCount; ++i) {
                    Intent intent2 = (Intent)allSticky.get(i);
                    BroadcastQueue queue = this.broadcastQueueForIntent(intent2);
                    BroadcastRecord r = new BroadcastRecord(queue, intent2, null, null, -1, -1, false, null, null, -1, null, receivers, null, 0, null, null, false, true, true, -1);
                    queue.enqueueParallelBroadcastLocked(r);
                    queue.scheduleBroadcastsLocked();
                }
            }
            return sticky;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterReceiver(IIntentReceiver receiver) {
        long origId = Binder.clearCallingIdentity();
        try {
            boolean doTrim = false;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ReceiverList rl = this.mRegisteredReceivers.get(receiver.asBinder());
                if (rl != null) {
                    boolean doNext;
                    BroadcastRecord r = rl.curBroadcast;
                    if (r != null && r == r.queue.getMatchingOrderedReceiver(r) && (doNext = r.queue.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false))) {
                        doTrim = true;
                        r.queue.processNextBroadcast(false);
                    }
                    if (rl.app != null) {
                        rl.app.receivers.remove(rl);
                    }
                    this.removeReceiverLocked(rl);
                    if (rl.linkedToDeath) {
                        rl.linkedToDeath = false;
                        rl.receiver.asBinder().unlinkToDeath(rl, 0);
                    }
                }
            }
            if (doTrim) {
                this.trimApplications();
                return;
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    void removeReceiverLocked(ReceiverList rl) {
        this.mRegisteredReceivers.remove(rl.receiver.asBinder());
        for (int i = rl.size() - 1; i >= 0; --i) {
            this.mReceiverResolver.removeFilter((BroadcastFilter)((IntentFilter)rl.get(i)));
        }
    }

    private final void sendPackageBroadcastLocked(int cmd, String[] packages, int userId) {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord r = this.mLruProcesses.get(i);
            if (r.thread == null || userId != -1 && r.userId != userId) continue;
            try {
                r.thread.dispatchPackageBroadcast(cmd, packages);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private List<ResolveInfo> collectReceiverComponents(Intent intent, String resolvedType, int callingUid, int[] users) {
        int pmFlags = 0x10000400;
        List receivers = null;
        try {
            HashSet<ComponentName> singleUserReceivers = null;
            boolean scannedFirstReceivers = false;
            for (int user : users) {
                ComponentName cn;
                ResolveInfo ri;
                int i;
                if (callingUid == 2000 && this.mUserController.hasUserRestriction("no_debugging_features", user) && !this.isPermittedShellBroadcast(intent)) continue;
                List newReceivers = AppGlobals.getPackageManager().queryIntentReceivers(intent, resolvedType, pmFlags, user).getList();
                if (user != 0 && newReceivers != null) {
                    for (i = 0; i < newReceivers.size(); ++i) {
                        ri = (ResolveInfo)newReceivers.get(i);
                        if ((ri.activityInfo.flags & 0x20000000) == 0) continue;
                        newReceivers.remove(i);
                        --i;
                    }
                }
                if (newReceivers != null && newReceivers.size() == 0) {
                    newReceivers = null;
                }
                if (receivers == null) {
                    receivers = newReceivers;
                    continue;
                }
                if (newReceivers == null) continue;
                if (!scannedFirstReceivers) {
                    scannedFirstReceivers = true;
                    for (i = 0; i < receivers.size(); ++i) {
                        ri = (ResolveInfo)receivers.get(i);
                        if ((ri.activityInfo.flags & 0x40000000) == 0) continue;
                        cn = new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name);
                        if (singleUserReceivers == null) {
                            singleUserReceivers = new HashSet();
                        }
                        singleUserReceivers.add(cn);
                    }
                }
                for (i = 0; i < newReceivers.size(); ++i) {
                    ri = (ResolveInfo)newReceivers.get(i);
                    if ((ri.activityInfo.flags & 0x40000000) != 0) {
                        cn = new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name);
                        if (singleUserReceivers == null) {
                            singleUserReceivers = new HashSet<ComponentName>();
                        }
                        if (singleUserReceivers.contains(cn)) continue;
                        singleUserReceivers.add(cn);
                        receivers.add(ri);
                        continue;
                    }
                    receivers.add(ri);
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return receivers;
    }

    private boolean isPermittedShellBroadcast(Intent intent) {
        return INTENT_REMOTE_BUGREPORT_FINISHED.equals(intent.getAction());
    }

    private void checkBroadcastFromSystem(Intent intent, ProcessRecord callerApp, String callerPackage, int callingUid, boolean isProtectedBroadcast, List receivers) {
        if ((intent.getFlags() & 0x400000) != 0) {
            return;
        }
        String action = intent.getAction();
        if (isProtectedBroadcast || "android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action) || "com.android.intent.action.DISMISS_KEYBOARD_SHORTCUTS".equals(action) || "android.intent.action.MEDIA_BUTTON".equals(action) || "android.intent.action.MEDIA_SCANNER_SCAN_FILE".equals(action) || "com.android.intent.action.SHOW_KEYBOARD_SHORTCUTS".equals(action) || "android.intent.action.MASTER_CLEAR".equals(action) || "android.intent.action.FACTORY_RESET".equals(action) || "android.appwidget.action.APPWIDGET_CONFIGURE".equals(action) || "android.appwidget.action.APPWIDGET_UPDATE".equals(action) || "android.location.HIGH_POWER_REQUEST_CHANGE".equals(action) || "com.android.omadm.service.CONFIGURATION_UPDATE".equals(action) || "android.text.style.SUGGESTION_PICKED".equals(action) || "android.media.action.OPEN_AUDIO_EFFECT_CONTROL_SESSION".equals(action) || "android.media.action.CLOSE_AUDIO_EFFECT_CONTROL_SESSION".equals(action)) {
            return;
        }
        if (receivers != null && receivers.size() > 0 && (intent.getPackage() != null || intent.getComponent() != null)) {
            boolean allProtected = true;
            for (int i = receivers.size() - 1; i >= 0; --i) {
                Object target = receivers.get(i);
                if (target instanceof ResolveInfo) {
                    ResolveInfo ri = (ResolveInfo)target;
                    if (!ri.activityInfo.exported || ri.activityInfo.permission != null) continue;
                    allProtected = false;
                    break;
                }
                BroadcastFilter bf = (BroadcastFilter)target;
                if (bf.requiredPermission != null) continue;
                allProtected = false;
                break;
            }
            if (allProtected) {
                return;
            }
        }
        if (callerApp != null) {
            Log.wtf("ActivityManager", "Sending non-protected broadcast " + action + " from system " + callerApp.toShortString() + " pkg " + callerPackage, new Throwable());
        } else {
            Log.wtf("ActivityManager", "Sending non-protected broadcast " + action + " from system uid " + UserHandle.formatUid(callingUid) + " pkg " + callerPackage, new Throwable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    final int broadcastIntentLocked(ProcessRecord callerApp, String callerPackage, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String[] requiredPermissions, int appOp, Bundle bOptions, boolean ordered, boolean sticky, int callingPid, int callingUid, int userId) {
        int NR;
        boolean isCallerSystem;
        boolean isProtectedBroadcast;
        BroadcastOptions brOptions;
        boolean callerInstantApp;
        block132: {
            UidRecord uidRec;
            int uid;
            String action;
            block133: {
                intent = new Intent(intent);
                callerInstantApp = this.isInstantApp(callerApp, callerPackage, callingUid);
                if (callerInstantApp) {
                    intent.setFlags(intent.getFlags() & 0xFFDFFFFF);
                }
                intent.addFlags(16);
                if (!this.mProcessesReady && (intent.getFlags() & 0x2000000) == 0) {
                    intent.addFlags(0x40000000);
                }
                if (resultTo != null && !ordered) {
                    Slog.w("ActivityManager", "Broadcast " + intent + " not ordered but result callback requested!");
                }
                if (!((userId = this.mUserController.handleIncomingUser(callingPid, callingUid, userId, true, 0, "broadcast", callerPackage)) == -1 || this.mUserController.isUserRunningLocked(userId, 0) || callingUid == 1000 && (intent.getFlags() & 0x2000000) != 0 || "android.intent.action.ACTION_SHUTDOWN".equals(intent.getAction()))) {
                    Slog.w("ActivityManager", "Skipping broadcast of " + intent + ": user " + userId + " is stopped");
                    return -2;
                }
                brOptions = null;
                if (bOptions != null && (brOptions = new BroadcastOptions(bOptions)).getTemporaryAppWhitelistDuration() > 0L && this.checkComponentPermission("android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", Binder.getCallingPid(), Binder.getCallingUid(), -1, true) != 0) {
                    String msg = "Permission Denial: " + intent.getAction() + " broadcast from " + callerPackage + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires " + "android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST";
                    Slog.w("ActivityManager", msg);
                    throw new SecurityException(msg);
                }
                action = intent.getAction();
                try {
                    isProtectedBroadcast = AppGlobals.getPackageManager().isProtectedBroadcast(action);
                }
                catch (RemoteException e) {
                    Slog.w("ActivityManager", "Remote exception", e);
                    return 0;
                }
                switch (UserHandle.getAppId(callingUid)) {
                    case 0: 
                    case 1000: 
                    case 1001: 
                    case 1002: 
                    case 1027: {
                        isCallerSystem = true;
                        break;
                    }
                    default: {
                        boolean bl = isCallerSystem = callerApp != null && callerApp.persistent;
                    }
                }
                if (!isCallerSystem) {
                    if (isProtectedBroadcast) {
                        String msg = "Permission Denial: not allowed to send broadcast " + action + " from pid=" + callingPid + ", uid=" + callingUid;
                        Slog.w("ActivityManager", msg);
                        throw new SecurityException(msg);
                    }
                    if ("android.appwidget.action.APPWIDGET_CONFIGURE".equals(action) || "android.appwidget.action.APPWIDGET_UPDATE".equals(action)) {
                        if (callerPackage == null) {
                            String msg = "Permission Denial: not allowed to send broadcast " + action + " from unknown caller.";
                            Slog.w("ActivityManager", msg);
                            throw new SecurityException(msg);
                        }
                        if (intent.getComponent() != null) {
                            if (!intent.getComponent().getPackageName().equals(callerPackage)) {
                                String msg = "Permission Denial: not allowed to send broadcast " + action + " to " + intent.getComponent().getPackageName() + " from " + callerPackage;
                                Slog.w("ActivityManager", msg);
                                throw new SecurityException(msg);
                            }
                        } else {
                            intent.setPackage(callerPackage);
                        }
                    }
                }
                if (action == null) break block132;
                if (this.getBackgroundLaunchBroadcasts().contains(action)) {
                    intent.addFlags(0x1000000);
                }
                block31 : switch (action) {
                    case "android.intent.action.UID_REMOVED": 
                    case "android.intent.action.PACKAGE_REMOVED": 
                    case "android.intent.action.PACKAGE_CHANGED": 
                    case "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE": 
                    case "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE": 
                    case "android.intent.action.PACKAGES_SUSPENDED": 
                    case "android.intent.action.PACKAGES_UNSUSPENDED": {
                        if (this.checkComponentPermission("android.permission.BROADCAST_PACKAGE_REMOVED", callingPid, callingUid, -1, true) != 0) {
                            String msg = "Permission Denial: " + intent.getAction() + " broadcast from " + callerPackage + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires " + "android.permission.BROADCAST_PACKAGE_REMOVED";
                            Slog.w("ActivityManager", msg);
                            throw new SecurityException(msg);
                        }
                        switch (action) {
                            case "android.intent.action.UID_REMOVED": {
                                int uid2 = this.getUidFromIntent(intent);
                                if (uid2 >= 0) {
                                    this.mBatteryStatsService.removeUid(uid2);
                                    this.mAppOpsService.uidRemoved(uid2);
                                    break;
                                }
                                break block133;
                            }
                            case "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE": {
                                String[] list = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                                if (list != null && list.length > 0) {
                                    for (int i = 0; i < list.length; ++i) {
                                        this.forceStopPackageLocked(list[i], -1, false, true, true, false, false, userId, "storage unmount");
                                    }
                                    this.mRecentTasks.cleanupLocked(-1);
                                    this.sendPackageBroadcastLocked(1, list, userId);
                                    break;
                                }
                                break block133;
                            }
                            case "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE": {
                                this.mRecentTasks.cleanupLocked(-1);
                                break;
                            }
                            case "android.intent.action.PACKAGE_REMOVED": 
                            case "android.intent.action.PACKAGE_CHANGED": {
                                String ssp;
                                Uri data = intent.getData();
                                if (data != null && (ssp = data.getSchemeSpecificPart()) != null) {
                                    boolean fullUninstall;
                                    boolean removed = "android.intent.action.PACKAGE_REMOVED".equals(action);
                                    boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                                    boolean bl = !intent.getBooleanExtra("android.intent.extra.DONT_KILL_APP", false);
                                    boolean bl2 = fullUninstall = removed && !replacing;
                                    if (removed) {
                                        if (bl) {
                                            this.forceStopPackageLocked(ssp, UserHandle.getAppId(intent.getIntExtra("android.intent.extra.UID", -1)), false, true, true, false, fullUninstall, userId, removed ? "pkg removed" : "pkg changed");
                                        }
                                        int cmd = bl ? 0 : 2;
                                        this.sendPackageBroadcastLocked(cmd, new String[]{ssp}, userId);
                                        if (!fullUninstall) break block31;
                                        this.mAppOpsService.packageRemoved(intent.getIntExtra("android.intent.extra.UID", -1), ssp);
                                        this.removeUriPermissionsForPackageLocked(ssp, userId, true);
                                        this.removeTasksByPackageNameLocked(ssp, userId);
                                        this.mServices.forceStopPackageLocked(ssp, userId);
                                        if (this.mUnsupportedDisplaySizeDialog != null && ssp.equals(this.mUnsupportedDisplaySizeDialog.getPackageName())) {
                                            this.mUnsupportedDisplaySizeDialog.dismiss();
                                            this.mUnsupportedDisplaySizeDialog = null;
                                        }
                                        this.mCompatModePackages.handlePackageUninstalledLocked(ssp);
                                        this.mBatteryStatsService.notePackageUninstalled(ssp);
                                        break;
                                    }
                                    if (bl) {
                                        this.killPackageProcessesLocked(ssp, UserHandle.getAppId(intent.getIntExtra("android.intent.extra.UID", -1)), userId, -10000, false, true, true, false, "change " + ssp);
                                    }
                                    this.cleanupDisabledPackageComponentsLocked(ssp, userId, bl, intent.getStringArrayExtra("android.intent.extra.changed_component_name_list"));
                                    break;
                                }
                                break block133;
                            }
                            case "android.intent.action.PACKAGES_SUSPENDED": 
                            case "android.intent.action.PACKAGES_UNSUSPENDED": {
                                boolean suspended = "android.intent.action.PACKAGES_SUSPENDED".equals(intent.getAction());
                                String[] packageNames = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                                int n = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                                ActivityManagerService fullUninstall = this;
                                synchronized (fullUninstall) {
                                    this.mRecentTasks.onPackagesSuspendedChanged(packageNames, suspended, n);
                                    break;
                                }
                            }
                        }
                        break;
                    }
                    case "android.intent.action.PACKAGE_REPLACED": {
                        String ssp;
                        Uri data = intent.getData();
                        if (data == null || (ssp = data.getSchemeSpecificPart()) == null) break;
                        ApplicationInfo aInfo = null;
                        try {
                            aInfo = AppGlobals.getPackageManager().getApplicationInfo(ssp, 0, userId);
                        }
                        catch (RemoteException list) {
                            // empty catch block
                        }
                        if (aInfo == null) {
                            Slog.w("ActivityManager", "Dropping ACTION_PACKAGE_REPLACED for non-existent pkg: ssp=" + ssp + " data=" + data);
                            return 0;
                        }
                        this.mStackSupervisor.updateActivityApplicationInfoLocked(aInfo);
                        this.sendPackageBroadcastLocked(3, new String[]{ssp}, userId);
                        break;
                    }
                    case "android.intent.action.PACKAGE_ADDED": {
                        Parcelable ai22;
                        String ssp;
                        Uri data = intent.getData();
                        if (data == null || (ssp = data.getSchemeSpecificPart()) == null) break;
                        boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                        this.mCompatModePackages.handlePackageAddedLocked(ssp, replacing);
                        try {
                            ai22 = AppGlobals.getPackageManager().getApplicationInfo(ssp, 0, 0);
                            this.mBatteryStatsService.notePackageInstalled(ssp, ai22 != null ? ((ApplicationInfo)ai22).versionCode : 0);
                        }
                        catch (RemoteException ai22) {}
                        break;
                    }
                    case "android.intent.action.PACKAGE_DATA_CLEARED": {
                        String ssp;
                        Uri data = intent.getData();
                        if (data == null || (ssp = data.getSchemeSpecificPart()) == null) break;
                        if (this.mUnsupportedDisplaySizeDialog != null && ssp.equals(this.mUnsupportedDisplaySizeDialog.getPackageName())) {
                            this.mUnsupportedDisplaySizeDialog.dismiss();
                            this.mUnsupportedDisplaySizeDialog = null;
                        }
                        this.mCompatModePackages.handlePackageDataClearedLocked(ssp);
                        break;
                    }
                    case "android.intent.action.TIMEZONE_CHANGED": {
                        this.mHandler.sendEmptyMessage(13);
                        break;
                    }
                    case "android.intent.action.TIME_SET": {
                        BatteryStatsImpl stats;
                        int NO_EXTRA_VALUE_FOUND = -1;
                        int timeFormatPreferenceMsgValue = intent.getIntExtra("android.intent.extra.TIME_PREF_24_HOUR_FORMAT", -1);
                        if (timeFormatPreferenceMsgValue != -1) {
                            Message updateTimePreferenceMsg = this.mHandler.obtainMessage(41, timeFormatPreferenceMsgValue, 0);
                            this.mHandler.sendMessage(updateTimePreferenceMsg);
                        }
                        Parcelable ai22 = stats = this.mBatteryStatsService.getActiveStatistics();
                        synchronized (ai22) {
                            stats.noteCurrentTimeChangedLocked();
                            break;
                        }
                    }
                    case "android.intent.action.CLEAR_DNS_CACHE": {
                        this.mHandler.sendEmptyMessage(28);
                        break;
                    }
                    case "android.intent.action.PROXY_CHANGE": {
                        ProxyInfo proxy = (ProxyInfo)intent.getParcelableExtra("android.intent.extra.PROXY_INFO");
                        this.mHandler.sendMessage(this.mHandler.obtainMessage(29, proxy));
                        break;
                    }
                    case "android.hardware.action.NEW_PICTURE": 
                    case "android.hardware.action.NEW_VIDEO": {
                        intent.addFlags(0x40000000);
                        break;
                    }
                    case "android.security.action.TRUST_STORE_CHANGED": {
                        this.mHandler.sendEmptyMessage(63);
                        break;
                    }
                    case "com.android.launcher.action.INSTALL_SHORTCUT": {
                        Log.w("ActivityManager", "Broadcast " + action + " no longer supported. It will not be delivered.");
                        return 0;
                    }
                }
            }
            if (("android.intent.action.PACKAGE_ADDED".equals(action) || "android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.PACKAGE_REPLACED".equals(action)) && (uid = this.getUidFromIntent(intent)) != -1 && (uidRec = this.mActiveUids.get(uid)) != null) {
                uidRec.updateHasInternetPermission();
            }
        }
        if (sticky) {
            int i;
            ArrayList<Intent> list;
            ArrayMap<String, ArrayList<Intent>> stickies;
            if (this.checkPermission("android.permission.BROADCAST_STICKY", callingPid, callingUid) != 0) {
                String msg = "Permission Denial: broadcastIntent() requesting a sticky broadcast from pid=" + callingPid + ", uid=" + callingUid + " requires " + "android.permission.BROADCAST_STICKY";
                Slog.w("ActivityManager", msg);
                throw new SecurityException(msg);
            }
            if (requiredPermissions != null && requiredPermissions.length > 0) {
                Slog.w("ActivityManager", "Can't broadcast sticky intent " + intent + " and enforce permissions " + Arrays.toString(requiredPermissions));
                return -1;
            }
            if (intent.getComponent() != null) {
                throw new SecurityException("Sticky broadcasts can't target a specific component");
            }
            if (userId != -1 && (stickies = this.mStickyBroadcasts.get(-1)) != null && (list = stickies.get(intent.getAction())) != null) {
                int N = list.size();
                for (int i2 = 0; i2 < N; ++i2) {
                    if (!intent.filterEquals(list.get(i2))) continue;
                    throw new IllegalArgumentException("Sticky broadcast " + intent + " for user " + userId + " conflicts with existing global broadcast");
                }
            }
            if ((stickies = this.mStickyBroadcasts.get(userId)) == null) {
                stickies = new ArrayMap();
                this.mStickyBroadcasts.put(userId, stickies);
            }
            if ((list = stickies.get(intent.getAction())) == null) {
                list = new ArrayList();
                stickies.put(intent.getAction(), list);
            }
            int stickiesCount = list.size();
            for (i = 0; i < stickiesCount; ++i) {
                if (!intent.filterEquals(list.get(i))) continue;
                list.set(i, new Intent(intent));
                break;
            }
            if (i >= stickiesCount) {
                list.add(new Intent(intent));
            }
        }
        int[] users = userId == -1 ? this.mUserController.getStartedUserArrayLocked() : new int[]{userId};
        List<ResolveInfo> receivers = null;
        List<BroadcastFilter> registeredReceivers = null;
        if ((intent.getFlags() & 0x40000000) == 0) {
            receivers = this.collectReceiverComponents(intent, resolvedType, callingUid, users);
        }
        if (intent.getComponent() == null) {
            if (userId == -1 && callingUid == 2000) {
                for (int i = 0; i < users.length; ++i) {
                    if (this.mUserController.hasUserRestriction("no_debugging_features", users[i])) continue;
                    List<BroadcastFilter> registeredReceiversForUser = this.mReceiverResolver.queryIntent(intent, resolvedType, false, users[i]);
                    if (registeredReceivers == null) {
                        registeredReceivers = registeredReceiversForUser;
                        continue;
                    }
                    if (registeredReceiversForUser == null) continue;
                    registeredReceivers.addAll(registeredReceiversForUser);
                }
            } else {
                registeredReceivers = this.mReceiverResolver.queryIntent(intent, resolvedType, false, userId);
            }
        }
        boolean replacePending = (intent.getFlags() & 0x20000000) != 0;
        int n = NR = registeredReceivers != null ? registeredReceivers.size() : 0;
        if (!ordered && NR > 0) {
            boolean replaced;
            if (isCallerSystem) {
                this.checkBroadcastFromSystem(intent, callerApp, callerPackage, callingUid, isProtectedBroadcast, registeredReceivers);
            }
            BroadcastQueue queue = this.broadcastQueueForIntent(intent);
            BroadcastRecord r = new BroadcastRecord(queue, intent, callerApp, callerPackage, callingPid, callingUid, callerInstantApp, resolvedType, requiredPermissions, appOp, brOptions, registeredReceivers, resultTo, resultCode, resultData, resultExtras, ordered, sticky, false, userId);
            boolean bl = replaced = replacePending && queue.replaceParallelBroadcastLocked(r) != null;
            if (!replaced) {
                queue.enqueueParallelBroadcastLocked(r);
                queue.scheduleBroadcastsLocked();
            }
            registeredReceivers = null;
            NR = 0;
        }
        int ir = 0;
        if (receivers != null) {
            String[] skipPackages = null;
            if ("android.intent.action.PACKAGE_ADDED".equals(intent.getAction()) || "android.intent.action.PACKAGE_RESTARTED".equals(intent.getAction()) || "android.intent.action.PACKAGE_DATA_CLEARED".equals(intent.getAction())) {
                String pkgName;
                Uri data = intent.getData();
                if (data != null && (pkgName = data.getSchemeSpecificPart()) != null) {
                    skipPackages = new String[]{pkgName};
                }
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(intent.getAction())) {
                skipPackages = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            }
            if (skipPackages != null && skipPackages.length > 0) {
                for (Uri uri : skipPackages) {
                    if (uri == null) continue;
                    int NT = receivers.size();
                    for (int it = 0; it < NT; ++it) {
                        ResolveInfo curt = receivers.get(it);
                        if (!curt.activityInfo.packageName.equals(uri)) continue;
                        receivers.remove(it);
                        --it;
                        --NT;
                    }
                }
            }
            int NT = receivers != null ? receivers.size() : 0;
            int it = 0;
            ResolveInfo curt = null;
            Object var32_84 = null;
            while (it < NT && ir < NR) {
                void var32_85;
                if (curt == null) {
                    curt = receivers.get(it);
                }
                if (var32_85 == null) {
                    BroadcastFilter broadcastFilter = registeredReceivers.get(ir);
                }
                if (var32_85.getPriority() >= curt.priority) {
                    receivers.add(it, (ResolveInfo)var32_85);
                    ++ir;
                    Object var32_87 = null;
                    ++it;
                    ++NT;
                    continue;
                }
                ++it;
                curt = null;
            }
        }
        while (ir < NR) {
            if (receivers == null) {
                receivers = new ArrayList<ResolveInfo>();
            }
            receivers.add((ResolveInfo)((Object)registeredReceivers.get(ir)));
            ++ir;
        }
        if (isCallerSystem) {
            this.checkBroadcastFromSystem(intent, callerApp, callerPackage, callingUid, isProtectedBroadcast, receivers);
        }
        if (receivers != null && receivers.size() > 0 || resultTo != null) {
            BroadcastRecord oldRecord;
            BroadcastQueue queue = this.broadcastQueueForIntent(intent);
            BroadcastRecord r = new BroadcastRecord(queue, intent, callerApp, callerPackage, callingPid, callingUid, callerInstantApp, resolvedType, requiredPermissions, appOp, brOptions, receivers, resultTo, resultCode, resultData, resultExtras, ordered, sticky, false, userId);
            BroadcastRecord broadcastRecord = oldRecord = replacePending ? queue.replaceOrderedBroadcastLocked(r) : null;
            if (oldRecord != null) {
                if (oldRecord.resultTo != null) {
                    BroadcastQueue oldQueue = this.broadcastQueueForIntent(oldRecord.intent);
                    try {
                        oldQueue.performReceiveLocked(oldRecord.callerApp, oldRecord.resultTo, oldRecord.intent, 0, null, null, false, false, oldRecord.userId);
                    }
                    catch (RemoteException remoteException) {
                        Slog.w("ActivityManager", "Failure [" + queue.mQueueName + "] sending broadcast result of " + intent, remoteException);
                    }
                }
            } else {
                queue.enqueueOrderedBroadcastLocked(r);
                queue.scheduleBroadcastsLocked();
            }
        } else if (intent.getComponent() == null && intent.getPackage() == null && (intent.getFlags() & 0x40000000) == 0) {
            this.addBroadcastStatLocked(intent.getAction(), callerPackage, 0, 0, 0L);
        }
        return 0;
    }

    private int getUidFromIntent(Intent intent) {
        if (intent == null) {
            return -1;
        }
        Bundle intentExtras = intent.getExtras();
        return intent.hasExtra("android.intent.extra.UID") ? intentExtras.getInt("android.intent.extra.UID") : -1;
    }

    final void rotateBroadcastStatsIfNeededLocked() {
        long now = SystemClock.elapsedRealtime();
        if (this.mCurBroadcastStats == null || this.mCurBroadcastStats.mStartRealtime + 86400000L < now) {
            this.mLastBroadcastStats = this.mCurBroadcastStats;
            if (this.mLastBroadcastStats != null) {
                this.mLastBroadcastStats.mEndRealtime = SystemClock.elapsedRealtime();
                this.mLastBroadcastStats.mEndUptime = SystemClock.uptimeMillis();
            }
            this.mCurBroadcastStats = new BroadcastStats();
        }
    }

    final void addBroadcastStatLocked(String action, String srcPackage, int receiveCount, int skipCount, long dispatchTime) {
        this.rotateBroadcastStatsIfNeededLocked();
        this.mCurBroadcastStats.addBroadcast(action, srcPackage, receiveCount, skipCount, dispatchTime);
    }

    final void addBackgroundCheckViolationLocked(String action, String targetPackage) {
        this.rotateBroadcastStatsIfNeededLocked();
        this.mCurBroadcastStats.addBackgroundCheckViolation(action, targetPackage);
    }

    final Intent verifyBroadcastLocked(Intent intent) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        int flags = intent.getFlags();
        if (!this.mProcessesReady && (flags & 0x4000000) == 0 && (flags & 0x40000000) == 0) {
            Slog.e("ActivityManager", "Attempt to launch receivers of broadcast intent " + intent + " before boot completion");
            throw new IllegalStateException("Cannot broadcast before boot completed");
        }
        if ((flags & 0x2000000) != 0) {
            throw new IllegalArgumentException("Can't use FLAG_RECEIVER_BOOT_UPGRADE here");
        }
        if ((flags & 0x400000) != 0) {
            switch (Binder.getCallingUid()) {
                case 0: 
                case 2000: {
                    break;
                }
                default: {
                    Slog.w("ActivityManager", "Removing FLAG_RECEIVER_FROM_SHELL because caller is UID " + Binder.getCallingUid());
                    intent.removeFlags(0x400000);
                }
            }
        }
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int broadcastIntent(IApplicationThread caller, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String[] requiredPermissions, int appOp, Bundle bOptions, boolean serialized, boolean sticky, int userId) {
        this.enforceNotIsolatedCaller("broadcastIntent");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            intent = this.verifyBroadcastLocked(intent);
            ProcessRecord callerApp = this.getRecordForAppLocked(caller);
            int callingPid = Binder.getCallingPid();
            int callingUid = Binder.getCallingUid();
            long origId = Binder.clearCallingIdentity();
            int res = this.broadcastIntentLocked(callerApp, callerApp != null ? callerApp.info.packageName : null, intent, resolvedType, resultTo, resultCode, resultData, resultExtras, requiredPermissions, appOp, bOptions, serialized, sticky, callingPid, callingUid, userId);
            Binder.restoreCallingIdentity(origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int broadcastIntentInPackage(String packageName, int uid, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String requiredPermission, Bundle bOptions, boolean serialized, boolean sticky, int userId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            String[] stringArray;
            intent = this.verifyBroadcastLocked(intent);
            long origId = Binder.clearCallingIdentity();
            if (requiredPermission == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = requiredPermission;
            }
            String[] requiredPermissions = stringArray;
            int res = this.broadcastIntentLocked(null, packageName, intent, resolvedType, resultTo, resultCode, resultData, resultExtras, requiredPermissions, -1, bOptions, serialized, sticky, -1, uid, userId);
            Binder.restoreCallingIdentity(origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unbroadcastIntent(IApplicationThread caller, Intent intent, int userId) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, 0, "removeStickyBroadcast", null);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.checkCallingPermission("android.permission.BROADCAST_STICKY") != 0) {
                String msg = "Permission Denial: unbroadcastIntent() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.BROADCAST_STICKY";
                Slog.w("ActivityManager", msg);
                throw new SecurityException(msg);
            }
            ArrayMap<String, ArrayList<Intent>> stickies = this.mStickyBroadcasts.get(userId);
            if (stickies != null) {
                ArrayList<Intent> list = stickies.get(intent.getAction());
                if (list != null) {
                    int N = list.size();
                    for (int i = 0; i < N; ++i) {
                        if (!intent.filterEquals(list.get(i))) continue;
                        list.remove(i);
                        break;
                    }
                    if (list.size() <= 0) {
                        stickies.remove(intent.getAction());
                    }
                }
                if (stickies.size() <= 0) {
                    this.mStickyBroadcasts.remove(userId);
                }
            }
        }
    }

    void backgroundServicesFinishedLocked(int userId) {
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.backgroundServicesFinishedLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishReceiver(IBinder who, int resultCode, String resultData, Bundle resultExtras, boolean resultAbort, int flags) {
        if (resultExtras != null && resultExtras.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            BroadcastRecord r;
            boolean doNext = false;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                BroadcastQueue queue = (flags & 0x10000000) != 0 ? this.mFgBroadcastQueue : this.mBgBroadcastQueue;
                r = queue.getMatchingOrderedReceiver(who);
                if (r != null) {
                    doNext = r.queue.finishReceiverLocked(r, resultCode, resultData, resultExtras, resultAbort, true);
                }
            }
            if (doNext) {
                r.queue.processNextBroadcast(false);
            }
            this.trimApplications();
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startInstrumentation(ComponentName className, String profileFile, int flags, Bundle arguments, IInstrumentationWatcher watcher, IUiAutomationConnection uiAutomationConnection, int userId, String abiOverride) {
        this.enforceNotIsolatedCaller("startInstrumentation");
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startInstrumentation", null);
        if (arguments != null && arguments.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            InstrumentationInfo ii = null;
            ApplicationInfo ai = null;
            try {
                ii = this.mContext.getPackageManager().getInstrumentationInfo(className, 1024);
                ai = AppGlobals.getPackageManager().getApplicationInfo(ii.targetPackage, 1024, userId);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (ii == null) {
                this.reportStartInstrumentationFailureLocked(watcher, className, "Unable to find instrumentation info for: " + className);
                return false;
            }
            if (ai == null) {
                this.reportStartInstrumentationFailureLocked(watcher, className, "Unable to find instrumentation target package: " + ii.targetPackage);
                return false;
            }
            if (!ai.hasCode()) {
                this.reportStartInstrumentationFailureLocked(watcher, className, "Instrumentation target has no code: " + ii.targetPackage);
                return false;
            }
            int match = this.mContext.getPackageManager().checkSignatures(ii.targetPackage, ii.packageName);
            if (match < 0 && match != -1) {
                String msg = "Permission Denial: starting instrumentation " + className + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingPid() + " not allowed because package " + ii.packageName + " does not have a signature matching the target " + ii.targetPackage;
                this.reportStartInstrumentationFailureLocked(watcher, className, msg);
                throw new SecurityException(msg);
            }
            ActiveInstrumentation activeInstr = new ActiveInstrumentation(this);
            activeInstr.mClass = className;
            String defProcess = ai.processName;
            if (ii.targetProcesses == null) {
                activeInstr.mTargetProcesses = new String[]{ai.processName};
            } else if (ii.targetProcesses.equals("*")) {
                activeInstr.mTargetProcesses = new String[0];
            } else {
                activeInstr.mTargetProcesses = ii.targetProcesses.split(",");
                defProcess = activeInstr.mTargetProcesses[0];
            }
            activeInstr.mTargetInfo = ai;
            activeInstr.mProfileFile = profileFile;
            activeInstr.mArguments = arguments;
            activeInstr.mWatcher = watcher;
            activeInstr.mUiAutomationConnection = uiAutomationConnection;
            activeInstr.mResultClass = className;
            long origId = Binder.clearCallingIdentity();
            this.forceStopPackageLocked(ii.targetPackage, -1, true, false, true, true, false, userId, "start instr");
            ProcessRecord app = this.addAppLocked(ai, defProcess, false, abiOverride);
            app.instr = activeInstr;
            activeInstr.mFinished = false;
            activeInstr.mRunningProcesses.add(app);
            if (!this.mActiveInstrumentation.contains(activeInstr)) {
                this.mActiveInstrumentation.add(activeInstr);
            }
            Binder.restoreCallingIdentity(origId);
        }
        return true;
    }

    private void reportStartInstrumentationFailureLocked(IInstrumentationWatcher watcher, ComponentName cn, String report) {
        Slog.w("ActivityManager", report);
        if (watcher != null) {
            Bundle results = new Bundle();
            results.putString("id", "ActivityManagerService");
            results.putString("Error", report);
            this.mInstrumentationReporter.reportStatus(watcher, cn, -1, results);
        }
    }

    void addInstrumentationResultsLocked(ProcessRecord app, Bundle results) {
        if (app.instr == null) {
            Slog.w("ActivityManager", "finishInstrumentation called on non-instrumented: " + app);
            return;
        }
        if (!app.instr.mFinished && results != null) {
            if (app.instr.mCurResults == null) {
                app.instr.mCurResults = new Bundle(results);
            } else {
                app.instr.mCurResults.putAll(results);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInstrumentationResults(IApplicationThread target, Bundle results) {
        int userId = UserHandle.getCallingUserId();
        if (results != null && results.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app = this.getRecordForAppLocked(target);
            if (app == null) {
                Slog.w("ActivityManager", "addInstrumentationResults: no app for " + target);
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.addInstrumentationResultsLocked(app, results);
            Binder.restoreCallingIdentity(origId);
        }
    }

    void finishInstrumentationLocked(ProcessRecord app, int resultCode, Bundle results) {
        if (app.instr == null) {
            Slog.w("ActivityManager", "finishInstrumentation called on non-instrumented: " + app);
            return;
        }
        if (!app.instr.mFinished) {
            if (app.instr.mWatcher != null) {
                Bundle finalResults = app.instr.mCurResults;
                if (finalResults != null) {
                    if (app.instr.mCurResults != null && results != null) {
                        finalResults.putAll(results);
                    }
                } else {
                    finalResults = results;
                }
                this.mInstrumentationReporter.reportFinished(app.instr.mWatcher, app.instr.mClass, resultCode, finalResults);
            }
            if (app.instr.mUiAutomationConnection != null) {
                this.mHandler.obtainMessage(56, app.instr.mUiAutomationConnection).sendToTarget();
            }
            app.instr.mFinished = true;
        }
        app.instr.removeProcess(app);
        app.instr = null;
        this.forceStopPackageLocked(app.info.packageName, -1, false, false, true, true, false, app.userId, "finished inst");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishInstrumentation(IApplicationThread target, int resultCode, Bundle results) {
        int userId = UserHandle.getCallingUserId();
        if (results != null && results.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app = this.getRecordForAppLocked(target);
            if (app == null) {
                Slog.w("ActivityManager", "finishInstrumentation: no app for " + target);
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.finishInstrumentationLocked(app, resultCode, results);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationInfo getDeviceConfigurationInfo() {
        ConfigurationInfo config = new ConfigurationInfo();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            Configuration globalConfig = this.getGlobalConfiguration();
            config.reqTouchScreen = globalConfig.touchscreen;
            config.reqKeyboardType = globalConfig.keyboard;
            config.reqNavigation = globalConfig.navigation;
            if (globalConfig.navigation == 2 || globalConfig.navigation == 3) {
                config.reqInputFeatures |= 2;
            }
            if (globalConfig.keyboard != 0 && globalConfig.keyboard != 1) {
                config.reqInputFeatures |= 1;
            }
            config.reqGlEsVersion = this.GL_ES_VERSION;
        }
        return config;
    }

    ActivityStack getFocusedStack() {
        return this.mStackSupervisor.getFocusedStack();
    }

    @Override
    public int getFocusedStackId() throws RemoteException {
        ActivityStack focusedStack = this.getFocusedStack();
        if (focusedStack != null) {
            return focusedStack.getStackId();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration getConfiguration() {
        Configuration ci;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ci = new Configuration(this.getGlobalConfiguration());
            ci.userSetLocale = false;
        }
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suppressResizeConfigChanges(boolean suppress) throws RemoteException {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "suppressResizeConfigChanges()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mSuppressResizeConfigChanges = suppress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTasksToFullscreenStack(int fromStackId, boolean onTop) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "moveTasksToFullscreenStack()");
        if (ActivityManager.StackId.isHomeOrRecentsStack(fromStackId)) {
            throw new IllegalArgumentException("You can't move tasks from the home/recents stack.");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                this.mStackSupervisor.moveTasksToFullscreenStackLocked(fromStackId, onTop);
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePersistentConfiguration(Configuration values) {
        this.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updatePersistentConfiguration()");
        this.enforceWriteSettingsPermission("updatePersistentConfiguration()");
        if (values == null) {
            throw new NullPointerException("Configuration must not be null");
        }
        int userId = UserHandle.getCallingUserId();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.updatePersistentConfigurationLocked(values, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePersistentConfigurationLocked(Configuration values, int userId) {
        long origId = Binder.clearCallingIdentity();
        try {
            this.updateConfigurationLocked(values, null, false, true, userId, false);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFontScaleIfNeeded(int userId) {
        float scaleFactor = Settings.System.getFloatForUser(this.mContext.getContentResolver(), "font_scale", 1.0f, userId);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.getGlobalConfiguration().fontScale == scaleFactor) {
                return;
            }
            Configuration configuration = this.mWindowManager.computeNewConfiguration(0);
            configuration.fontScale = scaleFactor;
            this.updatePersistentConfigurationLocked(configuration, userId);
        }
    }

    private void enforceWriteSettingsPermission(String func) {
        int uid = Binder.getCallingUid();
        if (uid == 0) {
            return;
        }
        if (Settings.checkAndNoteWriteSettingsOperation(this.mContext, uid, Settings.getPackageNameForUid(this.mContext, uid), false)) {
            return;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + uid + " requires " + "android.permission.WRITE_SETTINGS";
        Slog.w("ActivityManager", msg);
        throw new SecurityException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateConfiguration(Configuration values) {
        this.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean bl;
            if (values == null && this.mWindowManager != null) {
                values = this.mWindowManager.computeNewConfiguration(0);
            }
            if (this.mWindowManager != null) {
                this.mProcessList.applyDisplaySize(this.mWindowManager);
            }
            long origId = Binder.clearCallingIdentity();
            try {
                if (values != null) {
                    Settings.System.clearConfiguration(values);
                }
                this.updateConfigurationLocked(values, null, false, false, -10000, false, this.mTmpUpdateConfigurationResult);
                bl = this.mTmpUpdateConfigurationResult.changes != 0;
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
    }

    void updateUserConfigurationLocked() {
        Configuration configuration = new Configuration(this.getGlobalConfiguration());
        int currentUserId = this.mUserController.getCurrentUserIdLocked();
        Settings.System.adjustConfigurationForUser(this.mContext.getContentResolver(), configuration, currentUserId, Settings.System.canWrite(this.mContext));
        this.updateConfigurationLocked(configuration, null, false, false, currentUserId, false);
    }

    boolean updateConfigurationLocked(Configuration values, ActivityRecord starting, boolean initLocale) {
        return this.updateConfigurationLocked(values, starting, initLocale, false);
    }

    boolean updateConfigurationLocked(Configuration values, ActivityRecord starting, boolean initLocale, boolean deferResume) {
        return this.updateConfigurationLocked(values, starting, initLocale, false, -10000, deferResume);
    }

    private boolean updateConfigurationLocked(Configuration values, ActivityRecord starting, boolean initLocale, boolean persistent, int userId, boolean deferResume) {
        return this.updateConfigurationLocked(values, starting, initLocale, persistent, userId, deferResume, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateConfigurationLocked(Configuration values, ActivityRecord starting, boolean initLocale, boolean persistent, int userId, boolean deferResume, UpdateConfigurationResult result) {
        int changes = 0;
        boolean kept = true;
        if (this.mWindowManager != null) {
            this.mWindowManager.deferSurfaceLayout();
        }
        try {
            if (values != null) {
                changes = this.updateGlobalConfiguration(values, initLocale, persistent, userId, deferResume);
            }
            kept = this.ensureConfigAndVisibilityAfterUpdate(starting, changes);
        }
        finally {
            if (this.mWindowManager != null) {
                this.mWindowManager.continueSurfaceLayout();
            }
        }
        if (result != null) {
            result.changes = changes;
            result.activityRelaunched = !kept;
        }
        return kept;
    }

    private int updateGlobalConfiguration(Configuration values, boolean initLocale, boolean persistent, int userId, boolean deferResume) {
        this.mTempConfig.setTo(this.getGlobalConfiguration());
        int changes = this.mTempConfig.updateFrom(values);
        if (changes == 0) {
            this.performDisplayOverrideConfigUpdate(values, deferResume, 0);
            return 0;
        }
        EventLog.writeEvent(2719, changes);
        if (!initLocale && !values.getLocales().isEmpty() && values.userSetLocale) {
            LocaleList locales = values.getLocales();
            int bestLocaleIndex = 0;
            if (locales.size() > 1) {
                if (this.mSupportedSystemLocales == null) {
                    this.mSupportedSystemLocales = Resources.getSystem().getAssets().getLocales();
                }
                bestLocaleIndex = Math.max(0, locales.getFirstMatchIndex(this.mSupportedSystemLocales));
            }
            SystemProperties.set("persist.sys.locale", locales.get(bestLocaleIndex).toLanguageTag());
            LocaleList.setDefault(locales, bestLocaleIndex);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(47, locales.get(bestLocaleIndex)));
        }
        this.mTempConfig.seq = this.mConfigurationSeq = Math.max(++this.mConfigurationSeq, 1);
        this.mStackSupervisor.onConfigurationChanged(this.mTempConfig);
        Slog.i("ActivityManager", "Config changes=" + Integer.toHexString(changes) + " " + this.mTempConfig);
        this.mUsageStatsService.reportConfigurationChange(this.mTempConfig, this.mUserController.getCurrentUserIdLocked());
        this.mShowDialogs = ActivityManagerService.shouldShowDialogs(this.mTempConfig);
        AttributeCache ac = AttributeCache.instance();
        if (ac != null) {
            ac.updateConfiguration(this.mTempConfig);
        }
        this.mSystemThread.applyConfigurationToResources(this.mTempConfig);
        Configuration configCopy = new Configuration(this.mTempConfig);
        if (persistent && Settings.System.hasInterestingConfigurationChanges(changes)) {
            Message msg = this.mHandler.obtainMessage(4);
            msg.obj = configCopy;
            msg.arg1 = userId;
            this.mHandler.sendMessage(msg);
        }
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord app = this.mLruProcesses.get(i);
            try {
                if (app.thread == null) continue;
                app.thread.scheduleConfigurationChanged(configCopy);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Intent intent = new Intent("android.intent.action.CONFIGURATION_CHANGED");
        intent.addFlags(0x70200000);
        this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, -1);
        if ((changes & 4) != 0) {
            intent = new Intent("android.intent.action.LOCALE_CHANGED");
            intent.addFlags(0x11200000);
            if (initLocale || !this.mProcessesReady) {
                intent.addFlags(0x40000000);
            }
            this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, -1);
        }
        this.performDisplayOverrideConfigUpdate(this.mStackSupervisor.getConfiguration(), deferResume, 0);
        return changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateDisplayOverrideConfiguration(Configuration values, int displayId) {
        this.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateDisplayOverrideConfiguration()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean bl;
            if (!this.mStackSupervisor.isDisplayAdded(displayId)) {
                return false;
            }
            if (values == null && this.mWindowManager != null) {
                values = this.mWindowManager.computeNewConfiguration(displayId);
            }
            if (this.mWindowManager != null) {
                this.mProcessList.applyDisplaySize(this.mWindowManager);
            }
            long origId = Binder.clearCallingIdentity();
            try {
                if (values != null) {
                    Settings.System.clearConfiguration(values);
                }
                this.updateDisplayOverrideConfigurationLocked(values, null, false, displayId, this.mTmpUpdateConfigurationResult);
                bl = this.mTmpUpdateConfigurationResult.changes != 0;
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
    }

    boolean updateDisplayOverrideConfigurationLocked(Configuration values, ActivityRecord starting, boolean deferResume, int displayId) {
        return this.updateDisplayOverrideConfigurationLocked(values, starting, deferResume, displayId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDisplayOverrideConfigurationLocked(Configuration values, ActivityRecord starting, boolean deferResume, int displayId, UpdateConfigurationResult result) {
        int changes = 0;
        boolean kept = true;
        if (this.mWindowManager != null) {
            this.mWindowManager.deferSurfaceLayout();
        }
        try {
            if (values != null) {
                changes = displayId == 0 ? this.updateGlobalConfiguration(values, false, false, -10000, deferResume) : this.performDisplayOverrideConfigUpdate(values, deferResume, displayId);
            }
            kept = this.ensureConfigAndVisibilityAfterUpdate(starting, changes);
        }
        finally {
            if (this.mWindowManager != null) {
                this.mWindowManager.continueSurfaceLayout();
            }
        }
        if (result != null) {
            result.changes = changes;
            result.activityRelaunched = !kept;
        }
        return kept;
    }

    private int performDisplayOverrideConfigUpdate(Configuration values, boolean deferResume, int displayId) {
        int[] resizedStacks;
        this.mTempConfig.setTo(this.mStackSupervisor.getDisplayOverrideConfiguration(displayId));
        int changes = this.mTempConfig.updateFrom(values);
        if (changes != 0) {
            boolean isDensityChange;
            Slog.i("ActivityManager", "Override config changes=" + Integer.toHexString(changes) + " " + this.mTempConfig + " for displayId=" + displayId);
            this.mStackSupervisor.setDisplayOverrideConfiguration(this.mTempConfig, displayId);
            boolean bl = isDensityChange = (changes & 0x1000) != 0;
            if (isDensityChange && displayId == 0) {
                this.mUiHandler.sendEmptyMessage(62);
                this.killAllBackgroundProcessesExcept(24, 4);
            }
        }
        if (this.mWindowManager != null && (resizedStacks = this.mWindowManager.setNewDisplayOverrideConfiguration(this.mTempConfig, displayId)) != null) {
            for (int stackId : resizedStacks) {
                this.resizeStackWithBoundsFromWindowManager(stackId, deferResume);
            }
        }
        return changes;
    }

    private boolean ensureConfigAndVisibilityAfterUpdate(ActivityRecord starting, int changes) {
        boolean kept = true;
        ActivityStack mainStack = this.mStackSupervisor.getFocusedStack();
        if (mainStack != null) {
            if (changes != 0 && starting == null) {
                starting = mainStack.topRunningActivityLocked();
            }
            if (starting != null) {
                kept = starting.ensureActivityConfigurationLocked(changes, false);
                this.mStackSupervisor.ensureActivitiesVisibleLocked(starting, changes, false);
            }
        }
        return kept;
    }

    private void resizeStackWithBoundsFromWindowManager(int stackId, boolean deferResume) {
        Rect newStackBounds = new Rect();
        ((ActivityStack)this.mStackSupervisor.getStack(stackId)).getBoundsForNewConfiguration(newStackBounds);
        this.mStackSupervisor.resizeStackLocked(stackId, !newStackBounds.isEmpty() ? newStackBounds : null, null, null, false, false, deferResume);
    }

    private static boolean shouldShowDialogs(Configuration config) {
        boolean inputMethodExists = config.keyboard != 1 || config.touchscreen != 1 || config.navigation != 1;
        int modeType = config.uiMode & 0xF;
        boolean uiModeSupportsDialogs = modeType != 3 && (modeType != 6 || !"user".equals(Build.TYPE)) && modeType != 4 && modeType != 7;
        return inputMethodExists && uiModeSupportsDialogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldUpRecreateTask(IBinder token, String destAffinity) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord srec = ActivityRecord.forTokenLocked(token);
            if (srec != null) {
                return ((ActivityStack)srec.getStack()).shouldUpRecreateTaskLocked(srec, destAffinity);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean navigateUpTo(IBinder token, Intent destIntent, int resultCode, Intent resultData) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.forTokenLocked(token);
            if (r != null) {
                return ((ActivityStack)r.getStack()).navigateUpToLocked(r, destIntent, resultCode, resultData);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLaunchedFromUid(IBinder activityToken) {
        ActivityRecord srec;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            srec = ActivityRecord.forTokenLocked(activityToken);
        }
        if (srec == null) {
            return -1;
        }
        return srec.launchedFromUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLaunchedFromPackage(IBinder activityToken) {
        ActivityRecord srec;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            srec = ActivityRecord.forTokenLocked(activityToken);
        }
        if (srec == null) {
            return null;
        }
        return srec.launchedFromPackage;
    }

    private boolean isReceivingBroadcastLocked(ProcessRecord app, ArraySet<BroadcastQueue> receivingQueues) {
        if (!app.curReceivers.isEmpty()) {
            for (BroadcastRecord r : app.curReceivers) {
                receivingQueues.add(r.queue);
            }
            return true;
        }
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            BroadcastRecord r = queue.mPendingBroadcast;
            if (r == null || r.curApp != app) continue;
            receivingQueues.add(queue);
        }
        return !receivingQueues.isEmpty();
    }

    Association startAssociationLocked(int sourceUid, String sourceProcess, int sourceState, int targetUid, ComponentName targetComponent, String targetProcess) {
        Association ass;
        ArrayMap<String, Association> sourceProcesses;
        SparseArray<ArrayMap<String, Association>> sourceUids;
        if (!this.mTrackingAssociations) {
            return null;
        }
        ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>> components = this.mAssociations.get(targetUid);
        if (components == null) {
            components = new ArrayMap();
            this.mAssociations.put(targetUid, components);
        }
        if ((sourceUids = components.get(targetComponent)) == null) {
            sourceUids = new SparseArray();
            components.put(targetComponent, sourceUids);
        }
        if ((sourceProcesses = sourceUids.get(sourceUid)) == null) {
            sourceProcesses = new ArrayMap();
            sourceUids.put(sourceUid, sourceProcesses);
        }
        if ((ass = sourceProcesses.get(sourceProcess)) == null) {
            ass = new Association(sourceUid, sourceProcess, targetUid, targetComponent, targetProcess);
            sourceProcesses.put(sourceProcess, ass);
        }
        ++ass.mCount;
        ++ass.mNesting;
        if (ass.mNesting == 1) {
            ass.mStartTime = ass.mLastStateUptime = SystemClock.uptimeMillis();
            ass.mLastState = sourceState;
        }
        return ass;
    }

    void stopAssociationLocked(int sourceUid, String sourceProcess, int targetUid, ComponentName targetComponent) {
        if (!this.mTrackingAssociations) {
            return;
        }
        ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>> components = this.mAssociations.get(targetUid);
        if (components == null) {
            return;
        }
        SparseArray<ArrayMap<String, Association>> sourceUids = components.get(targetComponent);
        if (sourceUids == null) {
            return;
        }
        ArrayMap<String, Association> sourceProcesses = sourceUids.get(sourceUid);
        if (sourceProcesses == null) {
            return;
        }
        Association ass = sourceProcesses.get(sourceProcess);
        if (ass == null || ass.mNesting <= 0) {
            return;
        }
        --ass.mNesting;
        if (ass.mNesting == 0) {
            long uptime = SystemClock.uptimeMillis();
            ass.mTime += uptime - ass.mStartTime;
            int n = ass.mLastState - 0;
            ass.mStateTimes[n] = ass.mStateTimes[n] + (uptime - ass.mLastStateUptime);
            ass.mLastState = 20;
        }
    }

    private void noteUidProcessState(int uid, int state) {
        this.mBatteryStatsService.noteUidProcessState(uid, state);
        if (this.mTrackingAssociations) {
            int N1 = this.mAssociations.size();
            for (int i1 = 0; i1 < N1; ++i1) {
                ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>> targetComponents = this.mAssociations.valueAt(i1);
                int N2 = targetComponents.size();
                for (int i2 = 0; i2 < N2; ++i2) {
                    SparseArray<ArrayMap<String, Association>> sourceUids = targetComponents.valueAt(i2);
                    ArrayMap<String, Association> sourceProcesses = sourceUids.get(uid);
                    if (sourceProcesses == null) continue;
                    int N4 = sourceProcesses.size();
                    for (int i4 = 0; i4 < N4; ++i4) {
                        Association ass = sourceProcesses.valueAt(i4);
                        if (ass.mNesting < 1) continue;
                        long uptime = SystemClock.uptimeMillis();
                        int n = ass.mLastState - 0;
                        ass.mStateTimes[n] = ass.mStateTimes[n] + (uptime - ass.mLastStateUptime);
                        ass.mLastState = state;
                        ass.mLastStateUptime = uptime;
                    }
                }
            }
        }
    }

    private final int computeOomAdjLocked(ProcessRecord app, int cachedAdj, ProcessRecord TOP_APP, boolean doingAll, long now) {
        int procState;
        int schedGroup;
        int adj;
        if (this.mAdjSeq == app.adjSeq) {
            return app.curRawAdj;
        }
        if (app.thread == null) {
            app.adjSeq = this.mAdjSeq;
            app.curSchedGroup = 0;
            app.curProcState = 17;
            app.curRawAdj = 906;
            app.curAdj = 906;
            return 906;
        }
        app.adjTypeCode = 0;
        app.adjSource = null;
        app.adjTarget = null;
        app.empty = false;
        app.cached = false;
        int activitiesSize = app.activities.size();
        if (app.maxAdj <= 0) {
            app.adjType = "fixed";
            app.adjSeq = this.mAdjSeq;
            app.curRawAdj = app.maxAdj;
            app.foregroundActivities = false;
            app.curSchedGroup = 1;
            app.curProcState = 0;
            app.systemNoUi = true;
            if (app == TOP_APP) {
                app.systemNoUi = false;
                app.curSchedGroup = 2;
                app.adjType = "pers-top-activity";
            } else if (app.hasTopUi) {
                app.systemNoUi = false;
                app.curSchedGroup = 2;
                app.adjType = "pers-top-ui";
            } else if (activitiesSize > 0) {
                for (int j = 0; j < activitiesSize; ++j) {
                    ActivityRecord r = app.activities.get(j);
                    if (!r.visible) continue;
                    app.systemNoUi = false;
                }
            }
            if (!app.systemNoUi) {
                app.curProcState = 1;
            }
            app.curAdj = app.maxAdj;
            return app.curAdj;
        }
        app.systemNoUi = false;
        int PROCESS_STATE_CUR_TOP = this.mTopProcessState;
        boolean foregroundActivities = false;
        this.mTmpBroadcastQueue.clear();
        if (app == TOP_APP) {
            adj = 0;
            schedGroup = 2;
            app.adjType = "top-activity";
            foregroundActivities = true;
            procState = PROCESS_STATE_CUR_TOP;
        } else if (app.instr != null) {
            adj = 0;
            schedGroup = 1;
            app.adjType = "instrumentation";
            procState = 4;
        } else if (this.isReceivingBroadcastLocked(app, this.mTmpBroadcastQueue)) {
            adj = 0;
            schedGroup = this.mTmpBroadcastQueue.contains(this.mFgBroadcastQueue) ? 1 : 0;
            app.adjType = "broadcast";
            procState = 12;
        } else if (app.executingServices.size() > 0) {
            adj = 0;
            schedGroup = app.execServicesFg ? 1 : 0;
            app.adjType = "exec-service";
            procState = 11;
        } else {
            schedGroup = 0;
            adj = cachedAdj;
            procState = 17;
            app.cached = true;
            app.empty = true;
            app.adjType = "cch-empty";
        }
        if (!foregroundActivities && activitiesSize > 0) {
            int minLayer = 99;
            for (int j = 0; j < activitiesSize; ++j) {
                ActivityRecord r = app.activities.get(j);
                if (r.app != app) {
                    Log.e("ActivityManager", "Found activity " + r + " in proc activity list using " + r.app + " instead of expected " + app);
                    if (r.app != null && r.app.uid != app.uid) continue;
                    r.app = app;
                }
                if (r.visible) {
                    int layer;
                    if (adj > 100) {
                        adj = 100;
                        app.adjType = "vis-activity";
                    }
                    if (procState > PROCESS_STATE_CUR_TOP) {
                        procState = PROCESS_STATE_CUR_TOP;
                        app.adjType = "vis-activity";
                    }
                    schedGroup = 1;
                    app.cached = false;
                    app.empty = false;
                    foregroundActivities = true;
                    TaskRecord task = r.getTask();
                    if (task == null || minLayer <= 0 || (layer = task.mLayerRank) < 0 || minLayer <= layer) break;
                    minLayer = layer;
                    break;
                }
                if (r.state == ActivityStack.ActivityState.PAUSING || r.state == ActivityStack.ActivityState.PAUSED) {
                    if (adj > 200) {
                        adj = 200;
                        app.adjType = "pause-activity";
                    }
                    if (procState > PROCESS_STATE_CUR_TOP) {
                        procState = PROCESS_STATE_CUR_TOP;
                        app.adjType = "pause-activity";
                    }
                    schedGroup = 1;
                    app.cached = false;
                    app.empty = false;
                    foregroundActivities = true;
                    continue;
                }
                if (r.state == ActivityStack.ActivityState.STOPPING) {
                    if (adj > 200) {
                        adj = 200;
                        app.adjType = "stop-activity";
                    }
                    if (!r.finishing && procState > 14) {
                        procState = 14;
                        app.adjType = "stop-activity";
                    }
                    app.cached = false;
                    app.empty = false;
                    foregroundActivities = true;
                    continue;
                }
                if (procState <= 15) continue;
                procState = 15;
                app.adjType = "cch-act";
            }
            if (adj == 100) {
                adj += minLayer;
            }
        }
        if (adj > 200 || procState > 4) {
            if (app.foregroundServices) {
                adj = 200;
                procState = 4;
                app.cached = false;
                app.adjType = "fg-service";
                schedGroup = 1;
            } else if (app.hasOverlayUi) {
                adj = 200;
                procState = 6;
                app.cached = false;
                app.adjType = "has-overlay-ui";
                schedGroup = 1;
            }
        }
        if ((adj > 200 || procState > 8) && app.forcingToImportant != null) {
            adj = 200;
            procState = 8;
            app.cached = false;
            app.adjType = "force-imp";
            app.adjSource = app.forcingToImportant;
            schedGroup = 1;
        }
        if (app == this.mHeavyWeightProcess) {
            if (adj > 400) {
                adj = 400;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "heavy";
            }
            if (procState > 10) {
                procState = 10;
                app.adjType = "heavy";
            }
        }
        if (app == this.mHomeProcess) {
            if (adj > 600) {
                adj = 600;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "home";
            }
            if (procState > 13) {
                procState = 13;
                app.adjType = "home";
            }
        }
        if (app == this.mPreviousProcess && app.activities.size() > 0) {
            if (adj > 700) {
                adj = 700;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "previous";
            }
            if (procState > 14) {
                procState = 14;
                app.adjType = "previous";
            }
        }
        app.adjSeq = this.mAdjSeq;
        app.curRawAdj = adj;
        app.hasStartedServices = false;
        if (this.mBackupTarget != null && app == this.mBackupTarget.app) {
            if (adj > 300) {
                adj = 300;
                if (procState > 8) {
                    procState = 8;
                }
                app.adjType = "backup";
                app.cached = false;
            }
            if (procState > 9) {
                procState = 9;
                app.adjType = "backup";
            }
        }
        boolean mayBeTop = false;
        String mayBeTopType = null;
        ProcessRecord mayBeTopSource = null;
        ComponentName mayBeTopTarget = null;
        for (int is = app.services.size() - 1; is >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --is) {
            ServiceRecord s = app.services.valueAt(is);
            if (s.startRequested) {
                app.hasStartedServices = true;
                if (procState > 11) {
                    procState = 11;
                    app.adjType = "started-services";
                }
                if (app.hasShownUi && app != this.mHomeProcess) {
                    if (adj > 500) {
                        app.adjType = "cch-started-ui-services";
                    }
                } else {
                    if (now < s.lastActivity + this.mConstants.MAX_SERVICE_INACTIVITY && adj > 500) {
                        adj = 500;
                        app.adjType = "started-services";
                        app.cached = false;
                    }
                    if (adj > 500) {
                        app.adjType = "cch-started-services";
                    }
                }
            }
            for (int conni = s.connections.size() - 1; conni >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --conni) {
                ArrayList<ConnectionRecord> clist = s.connections.valueAt(conni);
                for (int i = 0; i < clist.size() && (adj > 0 || schedGroup == 0 || procState > 2); ++i) {
                    ConnectionRecord cr = clist.get(i);
                    if (cr.binding.client == app) continue;
                    if ((cr.flags & 0x20) == 0) {
                        ProcessRecord client = cr.binding.client;
                        int clientAdj = this.computeOomAdjLocked(client, cachedAdj, TOP_APP, doingAll, now);
                        int clientProcState = client.curProcState;
                        if (clientProcState >= 15) {
                            clientProcState = 17;
                        }
                        String adjType = null;
                        if ((cr.flags & 0x10) != 0) {
                            if (app.hasShownUi && app != this.mHomeProcess) {
                                if (adj > clientAdj) {
                                    adjType = "cch-bound-ui-services";
                                }
                                app.cached = false;
                                clientAdj = adj;
                                clientProcState = procState;
                            } else if (now >= s.lastActivity + this.mConstants.MAX_SERVICE_INACTIVITY) {
                                if (adj > clientAdj) {
                                    adjType = "cch-bound-services";
                                }
                                clientAdj = adj;
                            }
                        }
                        if (adj > clientAdj) {
                            if (app.hasShownUi && app != this.mHomeProcess && clientAdj > 200) {
                                if (adj >= 900) {
                                    adjType = "cch-bound-ui-services";
                                }
                            } else {
                                int newAdj = (cr.flags & 0x48) != 0 ? (clientAdj >= -700 ? clientAdj : -700) : ((cr.flags & 0x40000000) != 0 && clientAdj < 200 && adj > 200 ? 200 : (clientAdj >= 200 ? clientAdj : (adj > 100 ? Math.max(clientAdj, 100) : adj)));
                                if (!client.cached) {
                                    app.cached = false;
                                }
                                if (adj > newAdj) {
                                    adj = newAdj;
                                    adjType = "service";
                                }
                            }
                        }
                        if ((cr.flags & 0x800004) == 0) {
                            if (client.curSchedGroup > schedGroup) {
                                schedGroup = (cr.flags & 0x40) != 0 ? client.curSchedGroup : 1;
                            }
                            if (clientProcState <= 2) {
                                if (clientProcState == 2) {
                                    mayBeTop = true;
                                    mayBeTopType = "service";
                                    mayBeTopSource = cr.binding.client;
                                    mayBeTopTarget = s.name;
                                    clientProcState = 17;
                                } else {
                                    clientProcState = (cr.flags & 0x4000000) != 0 ? 3 : (this.mWakefulness == 1 && (cr.flags & 0x2000000) != 0 ? 3 : 6);
                                }
                            }
                        } else if ((cr.flags & 0x800000) == 0) {
                            if (clientProcState < 8) {
                                clientProcState = 8;
                            }
                        } else if (clientProcState < 7) {
                            clientProcState = 7;
                        }
                        if (procState > clientProcState) {
                            procState = clientProcState;
                            if (adjType == null) {
                                adjType = "service";
                            }
                        }
                        if (procState < 7 && (cr.flags & 0x20000000) != 0) {
                            app.pendingUiClean = true;
                        }
                        if (adjType != null) {
                            app.adjType = adjType;
                            app.adjTypeCode = 2;
                            app.adjSource = cr.binding.client;
                            app.adjSourceProcState = clientProcState;
                            app.adjTarget = s.name;
                        }
                    }
                    if ((cr.flags & 0x8000000) != 0) {
                        app.treatLikeActivity = true;
                    }
                    ActivityRecord a = cr.activity;
                    if ((cr.flags & 0x80) == 0 || a == null || adj <= 0 || !a.visible && a.state != ActivityStack.ActivityState.RESUMED && a.state != ActivityStack.ActivityState.PAUSING) continue;
                    adj = 0;
                    if ((cr.flags & 4) == 0) {
                        schedGroup = (cr.flags & 0x40) != 0 ? 3 : 1;
                    }
                    app.cached = false;
                    app.adjType = "service";
                    app.adjTypeCode = 2;
                    app.adjSource = a;
                    app.adjSourceProcState = procState;
                    app.adjTarget = s.name;
                }
            }
        }
        for (int provi = app.pubProviders.size() - 1; provi >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --provi) {
            ContentProviderRecord cpr = app.pubProviders.valueAt(provi);
            for (int i = cpr.connections.size() - 1; i >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --i) {
                ContentProviderConnection conn = cpr.connections.get(i);
                ProcessRecord client = conn.client;
                if (client == app) continue;
                int clientAdj = this.computeOomAdjLocked(client, cachedAdj, TOP_APP, doingAll, now);
                int clientProcState = client.curProcState;
                if (clientProcState >= 15) {
                    clientProcState = 17;
                }
                String adjType = null;
                if (adj > clientAdj) {
                    if (app.hasShownUi && app != this.mHomeProcess && clientAdj > 200) {
                        adjType = "cch-ui-provider";
                    } else {
                        adj = clientAdj > 0 ? clientAdj : 0;
                        adjType = "provider";
                    }
                    app.cached &= client.cached;
                }
                if (clientProcState <= 2) {
                    if (clientProcState == 2) {
                        mayBeTop = true;
                        clientProcState = 17;
                        adjType = "provider-top";
                        mayBeTopType = "provider-top";
                        mayBeTopSource = client;
                        mayBeTopTarget = cpr.name;
                    } else {
                        clientProcState = 3;
                        if (adjType == null) {
                            adjType = "provider";
                        }
                    }
                }
                if (procState > clientProcState) {
                    procState = clientProcState;
                }
                if (client.curSchedGroup > schedGroup) {
                    schedGroup = 1;
                }
                if (adjType == null) continue;
                app.adjType = adjType;
                app.adjTypeCode = 1;
                app.adjSource = client;
                app.adjSourceProcState = clientProcState;
                app.adjTarget = cpr.name;
            }
            if (!cpr.hasExternalProcessHandles()) continue;
            if (adj > 0) {
                adj = 0;
                schedGroup = 1;
                app.cached = false;
                app.adjType = "ext-provider";
                app.adjTarget = cpr.name;
            }
            if (procState <= 6) continue;
            procState = 6;
        }
        if (app.lastProviderTime > 0L && app.lastProviderTime + this.mConstants.CONTENT_PROVIDER_RETAIN_TIME > now) {
            if (adj > 700) {
                adj = 700;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "recent-provider";
            }
            if (procState > 14) {
                procState = 14;
                app.adjType = "recent-provider";
            }
        }
        if (mayBeTop && procState > 2) {
            switch (procState) {
                case 3: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 11: {
                    procState = 3;
                    app.adjType = mayBeTopType;
                    app.adjSource = mayBeTopSource;
                    app.adjTarget = mayBeTopTarget;
                    break;
                }
                default: {
                    procState = 2;
                    app.adjType = mayBeTopType;
                    app.adjSource = mayBeTopSource;
                    app.adjTarget = mayBeTopTarget;
                }
            }
        }
        if (procState >= 17) {
            if (app.hasClientActivities) {
                procState = 16;
                app.adjType = "cch-client-act";
            } else if (app.treatLikeActivity) {
                procState = 15;
                app.adjType = "cch-as-act";
            }
        }
        if (adj == 500) {
            if (doingAll) {
                app.serviceb = this.mNewNumAServiceProcs > this.mNumServiceProcs / 3;
                ++this.mNewNumServiceProcs;
                if (!app.serviceb) {
                    if (this.mLastMemoryLevel > 0 && app.lastPss >= this.mProcessList.getCachedRestoreThresholdKb()) {
                        app.serviceHighRam = true;
                        app.serviceb = true;
                    } else {
                        ++this.mNewNumAServiceProcs;
                    }
                } else {
                    app.serviceHighRam = false;
                }
            }
            if (app.serviceb) {
                adj = 800;
            }
        }
        app.curRawAdj = adj;
        if (adj > app.maxAdj) {
            adj = app.maxAdj;
            if (app.maxAdj <= 200) {
                schedGroup = 1;
            }
        }
        app.curAdj = app.modifyRawOomAdj(adj);
        app.curSchedGroup = schedGroup;
        app.curProcState = procState;
        app.foregroundActivities = foregroundActivities;
        return app.curRawAdj;
    }

    void recordPssSampleLocked(ProcessRecord proc, int procState, long pss, long uss, long swapPss, long now) {
        EventLogTags.writeAmPss(proc.pid, proc.uid, proc.processName, pss * 1024L, uss * 1024L, swapPss * 1024L);
        proc.lastPssTime = now;
        proc.baseProcessTracker.addPss(pss, uss, true, proc.pkgList);
        if (proc.initialIdlePss == 0L) {
            proc.initialIdlePss = pss;
        }
        proc.lastPss = pss;
        proc.lastSwapPss = swapPss;
        if (procState >= 13) {
            proc.lastCachedPss = pss;
            proc.lastCachedSwapPss = swapPss;
        }
        SparseArray<Pair<Long, String>> watchUids = this.mMemWatchProcesses.getMap().get(proc.processName);
        Long check = null;
        if (watchUids != null) {
            Pair<Long, String> val = watchUids.get(proc.uid);
            if (val == null) {
                val = watchUids.get(0);
            }
            if (val != null) {
                check = (Long)val.first;
            }
        }
        if (check != null && pss * 1024L >= check && proc.thread != null && this.mMemWatchDumpProcName == null) {
            boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (!isDebuggable && (proc.info.flags & 2) != 0) {
                isDebuggable = true;
            }
            if (isDebuggable) {
                Slog.w("ActivityManager", "Process " + proc + " exceeded pss limit " + check + "; reporting");
                final ProcessRecord myProc = proc;
                final File heapdumpFile = DumpHeapProvider.getJavaFile();
                this.mMemWatchDumpProcName = proc.processName;
                this.mMemWatchDumpFile = heapdumpFile.toString();
                this.mMemWatchDumpPid = proc.pid;
                this.mMemWatchDumpUid = proc.uid;
                BackgroundThread.getHandler().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ActivityManagerService.this.revokeUriPermission(ActivityThread.currentActivityThread().getApplicationThread(), null, DumpHeapActivity.JAVA_URI, 3, UserHandle.myUserId());
                        ParcelFileDescriptor fd = null;
                        try {
                            heapdumpFile.delete();
                            fd = ParcelFileDescriptor.open(heapdumpFile, 0x2E000000);
                            IApplicationThread thread = myProc.thread;
                            if (thread != null) {
                                try {
                                    thread.dumpHeap(true, heapdumpFile.toString(), fd);
                                }
                                catch (RemoteException remoteException) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (fd != null) {
                                try {
                                    fd.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                });
            } else {
                Slog.w("ActivityManager", "Process " + proc + " exceeded pss limit " + check + ", but debugging not enabled");
            }
        }
    }

    void requestPssLocked(ProcessRecord proc, int procState) {
        if (this.mPendingPssProcesses.contains(proc)) {
            return;
        }
        if (this.mPendingPssProcesses.size() == 0) {
            this.mBgHandler.sendEmptyMessage(1);
        }
        proc.pssProcState = procState;
        this.mPendingPssProcesses.add(proc);
    }

    void requestPssAllProcsLocked(long now, boolean always, boolean memLowered) {
        if (!always && now < this.mLastFullPssTime + (memLowered ? this.mConstants.FULL_PSS_LOWERED_INTERVAL : this.mConstants.FULL_PSS_MIN_INTERVAL)) {
            return;
        }
        this.mLastFullPssTime = now;
        this.mFullPssPending = true;
        this.mPendingPssProcesses.ensureCapacity(this.mLruProcesses.size());
        this.mPendingPssProcesses.clear();
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord app = this.mLruProcesses.get(i);
            if (app.thread == null || app.curProcState == 18 || !memLowered && now <= app.lastStateTime + 600000L) continue;
            app.pssProcState = app.setProcState;
            app.nextPssTime = ProcessList.computeNextPssTime(app.curProcState, true, this.mTestPssMode, this.isSleepingLocked(), now);
            this.mPendingPssProcesses.add(app);
        }
        this.mBgHandler.sendEmptyMessage(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTestPssMode(boolean enabled) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mTestPssMode = enabled;
            if (enabled) {
                this.requestPssAllProcsLocked(SystemClock.uptimeMillis(), true, true);
            }
        }
    }

    final void performAppGcLocked(ProcessRecord app) {
        try {
            app.lastRequestedGc = SystemClock.uptimeMillis();
            if (app.thread != null) {
                if (app.reportLowMemory) {
                    app.reportLowMemory = false;
                    app.thread.scheduleLowMemory();
                } else {
                    app.thread.processInBackground();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final boolean canGcNowLocked() {
        boolean processingBroadcasts = false;
        for (BroadcastQueue q : this.mBroadcastQueues) {
            if (q.mParallelBroadcasts.size() == 0 && q.mOrderedBroadcasts.size() == 0) continue;
            processingBroadcasts = true;
        }
        return !processingBroadcasts && (this.isSleepingLocked() || this.mStackSupervisor.allResumedActivitiesIdle());
    }

    final void performAppGcsLocked() {
        int N = this.mProcessesToGc.size();
        if (N <= 0) {
            return;
        }
        if (this.canGcNowLocked()) {
            while (this.mProcessesToGc.size() > 0) {
                ProcessRecord proc = this.mProcessesToGc.remove(0);
                if (proc.curRawAdj <= 200 && !proc.reportLowMemory) continue;
                if (proc.lastRequestedGc + this.mConstants.GC_MIN_INTERVAL <= SystemClock.uptimeMillis()) {
                    this.performAppGcLocked(proc);
                    this.scheduleAppGcsLocked();
                    return;
                }
                this.addProcessToGcListLocked(proc);
                break;
            }
            this.scheduleAppGcsLocked();
        }
    }

    final void performAppGcsIfAppropriateLocked() {
        if (this.canGcNowLocked()) {
            this.performAppGcsLocked();
            return;
        }
        this.scheduleAppGcsLocked();
    }

    final void scheduleAppGcsLocked() {
        this.mHandler.removeMessages(5);
        if (this.mProcessesToGc.size() > 0) {
            ProcessRecord proc = this.mProcessesToGc.get(0);
            Message msg = this.mHandler.obtainMessage(5);
            long when = proc.lastRequestedGc + this.mConstants.GC_MIN_INTERVAL;
            long now = SystemClock.uptimeMillis();
            if (when < now + this.mConstants.GC_TIMEOUT) {
                when = now + this.mConstants.GC_TIMEOUT;
            }
            this.mHandler.sendMessageAtTime(msg, when);
        }
    }

    final void addProcessToGcListLocked(ProcessRecord proc) {
        boolean added = false;
        for (int i = this.mProcessesToGc.size() - 1; i >= 0; --i) {
            if (this.mProcessesToGc.get((int)i).lastRequestedGc >= proc.lastRequestedGc) continue;
            added = true;
            this.mProcessesToGc.add(i + 1, proc);
            break;
        }
        if (!added) {
            this.mProcessesToGc.add(0, proc);
        }
    }

    final void scheduleAppGcLocked(ProcessRecord app) {
        long now = SystemClock.uptimeMillis();
        if (app.lastRequestedGc + this.mConstants.GC_MIN_INTERVAL > now) {
            return;
        }
        if (!this.mProcessesToGc.contains(app)) {
            this.addProcessToGcListLocked(app);
            this.scheduleAppGcsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkExcessivePowerUsageLocked(boolean doKills) {
        this.updateCpuStatsNow();
        BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
        boolean doWakeKills = doKills;
        boolean doCpuKills = doKills;
        if (this.mLastPowerCheckRealtime == 0L) {
            doWakeKills = false;
        }
        if (this.mLastPowerCheckUptime == 0L) {
            doCpuKills = false;
        }
        if (stats.isScreenOn()) {
            doWakeKills = false;
        }
        long curRealtime = SystemClock.elapsedRealtime();
        long realtimeSince = curRealtime - this.mLastPowerCheckRealtime;
        long curUptime = SystemClock.uptimeMillis();
        long uptimeSince = curUptime - this.mLastPowerCheckUptime;
        this.mLastPowerCheckRealtime = curRealtime;
        this.mLastPowerCheckUptime = curUptime;
        if (realtimeSince < this.mConstants.WAKE_LOCK_MIN_CHECK_DURATION) {
            doWakeKills = false;
        }
        if (uptimeSince < this.mConstants.CPU_MIN_CHECK_DURATION) {
            doCpuKills = false;
        }
        int i = this.mLruProcesses.size();
        while (i > 0) {
            BatteryStatsImpl batteryStatsImpl;
            long wtime;
            ProcessRecord app = this.mLruProcesses.get(--i);
            if (app.setProcState < 13) continue;
            BatteryStatsImpl batteryStatsImpl2 = stats;
            synchronized (batteryStatsImpl2) {
                wtime = stats.getProcessWakeTime(app.info.uid, app.pid, curRealtime);
            }
            long wtimeUsed = wtime - app.lastWakeTime;
            long cputimeUsed = app.curCpuTime - app.lastCpuTime;
            if (doWakeKills && realtimeSince > 0L && wtimeUsed * 100L / realtimeSince >= 50L) {
                batteryStatsImpl = stats;
                synchronized (batteryStatsImpl) {
                    stats.reportExcessiveWakeLocked(app.info.uid, app.processName, realtimeSince, wtimeUsed);
                }
                app.kill("excessive wake held " + wtimeUsed + " during " + realtimeSince, true);
                app.baseProcessTracker.reportExcessiveWake(app.pkgList);
                continue;
            }
            if (doCpuKills && uptimeSince > 0L && cputimeUsed * 100L / uptimeSince >= 25L) {
                batteryStatsImpl = stats;
                synchronized (batteryStatsImpl) {
                    stats.reportExcessiveCpuLocked(app.info.uid, app.processName, uptimeSince, cputimeUsed);
                }
                app.kill("excessive cpu " + cputimeUsed + " during " + uptimeSince, true);
                app.baseProcessTracker.reportExcessiveCpu(app.pkgList);
                continue;
            }
            app.lastWakeTime = wtime;
            app.lastCpuTime = app.curCpuTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean applyOomAdjLocked(ProcessRecord app, boolean doingAll, long now, long nowElapsed) {
        boolean success = true;
        if (app.curRawAdj != app.setRawAdj) {
            app.setRawAdj = app.curRawAdj;
        }
        int changes = 0;
        if (app.curAdj != app.setAdj) {
            ProcessList.setOomAdj(app.pid, app.info.uid, app.curAdj);
            app.setAdj = app.curAdj;
            app.verifiedAdj = -10000;
        }
        if (app.setSchedGroup != app.curSchedGroup) {
            int oldSchedGroup = app.setSchedGroup;
            app.setSchedGroup = app.curSchedGroup;
            if (app.waitingToKill != null && app.curReceivers.isEmpty() && app.setSchedGroup == 0) {
                app.kill(app.waitingToKill, true);
                success = false;
            } else {
                int processGroup;
                switch (app.curSchedGroup) {
                    case 0: {
                        processGroup = 0;
                        break;
                    }
                    case 2: 
                    case 3: {
                        processGroup = 5;
                        break;
                    }
                    default: {
                        processGroup = -1;
                    }
                }
                long oldId = Binder.clearCallingIdentity();
                try {
                    android.os.Process.setProcessGroup(app.pid, processGroup);
                    if (app.curSchedGroup == 2) {
                        if (oldSchedGroup != 2) {
                            this.mVrController.onTopProcChangedLocked(app);
                            if (this.mUseFifoUiScheduling) {
                                app.savedPriority = android.os.Process.getThreadPriority(app.pid);
                                ActivityManagerService.scheduleAsFifoPriority(app.pid, true);
                                if (app.renderThreadTid != 0) {
                                    ActivityManagerService.scheduleAsFifoPriority(app.renderThreadTid, true);
                                }
                            } else {
                                android.os.Process.setThreadPriority(app.pid, -10);
                                if (app.renderThreadTid != 0) {
                                    try {
                                        android.os.Process.setThreadPriority(app.renderThreadTid, -10);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {}
                                }
                            }
                        }
                    } else if (oldSchedGroup == 2 && app.curSchedGroup != 2) {
                        this.mVrController.onTopProcChangedLocked(app);
                        if (this.mUseFifoUiScheduling) {
                            android.os.Process.setThreadScheduler(app.pid, 0, 0);
                            android.os.Process.setThreadPriority(app.pid, app.savedPriority);
                            if (app.renderThreadTid != 0) {
                                android.os.Process.setThreadScheduler(app.renderThreadTid, 0, 0);
                                android.os.Process.setThreadPriority(app.renderThreadTid, -4);
                            }
                        } else {
                            android.os.Process.setThreadPriority(app.pid, 0);
                            if (app.renderThreadTid != 0) {
                                android.os.Process.setThreadPriority(app.renderThreadTid, 0);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    Binder.restoreCallingIdentity(oldId);
                }
            }
        }
        if (app.repForegroundActivities != app.foregroundActivities) {
            app.repForegroundActivities = app.foregroundActivities;
            changes |= 1;
        }
        if (app.repProcState != app.curProcState) {
            app.repProcState = app.curProcState;
            if (app.thread != null) {
                try {
                    app.thread.setProcessState(app.repProcState);
                }
                catch (RemoteException oldSchedGroup) {
                    // empty catch block
                }
            }
        }
        if (app.setProcState == 18 || ProcessList.procStatesDifferForMem(app.curProcState, app.setProcState)) {
            app.lastStateTime = now;
            app.nextPssTime = ProcessList.computeNextPssTime(app.curProcState, true, this.mTestPssMode, this.isSleepingLocked(), now);
        } else if (now > app.nextPssTime || now > app.lastPssTime + 1800000L && now > app.lastStateTime + ProcessList.minTimeFromStateChange(this.mTestPssMode)) {
            this.requestPssLocked(app, app.setProcState);
            app.nextPssTime = ProcessList.computeNextPssTime(app.curProcState, false, this.mTestPssMode, this.isSleepingLocked(), now);
        }
        if (app.setProcState != app.curProcState) {
            boolean curImportant;
            boolean setImportant = app.setProcState < 11;
            boolean bl = curImportant = app.curProcState < 11;
            if (setImportant && !curImportant) {
                BatteryStatsImpl stats;
                BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    app.lastWakeTime = stats.getProcessWakeTime(app.info.uid, app.pid, nowElapsed);
                }
                app.lastCpuTime = app.curCpuTime;
            }
            this.maybeUpdateUsageStatsLocked(app, nowElapsed);
            app.setProcState = app.curProcState;
            if (app.setProcState >= 13) {
                app.notCachedSinceIdle = false;
            }
            if (!doingAll) {
                this.setProcessTrackerStateLocked(app, this.mProcessStats.getMemFactorLocked(), now);
            } else {
                app.procStateChanged = true;
            }
        } else if (app.reportedInteraction && nowElapsed - app.interactionEventTime > this.mConstants.USAGE_STATS_INTERACTION_INTERVAL) {
            this.maybeUpdateUsageStatsLocked(app, nowElapsed);
        }
        if (changes != 0) {
            int i;
            ProcessChangeItem item = null;
            for (i = this.mPendingProcessChanges.size() - 1; i >= 0; --i) {
                item = this.mPendingProcessChanges.get(i);
                if (item.pid == app.pid) break;
            }
            if (i < 0) {
                int NA = this.mAvailProcessChanges.size();
                item = NA > 0 ? this.mAvailProcessChanges.remove(NA - 1) : new ProcessChangeItem();
                item.changes = 0;
                item.pid = app.pid;
                item.uid = app.info.uid;
                if (this.mPendingProcessChanges.size() == 0) {
                    this.mUiHandler.obtainMessage(31).sendToTarget();
                }
                this.mPendingProcessChanges.add(item);
            }
            item.changes |= changes;
            item.foregroundActivities = app.repForegroundActivities;
        }
        return success;
    }

    private boolean isEphemeralLocked(int uid) {
        String[] packages = this.mContext.getPackageManager().getPackagesForUid(uid);
        if (packages == null || packages.length != 1) {
            return false;
        }
        return this.getPackageManagerInternalLocked().isPackageEphemeral(UserHandle.getUserId(uid), packages[0]);
    }

    final void enqueueUidChangeLocked(UidRecord uidRec, int uid, int change) {
        UidRecord.ChangeItem pendingChange;
        if (uidRec == null || uidRec.pendingChange == null) {
            int NA;
            if (this.mPendingUidChanges.size() == 0) {
                this.mUiHandler.obtainMessage(53).sendToTarget();
            }
            pendingChange = (NA = this.mAvailUidChanges.size()) > 0 ? this.mAvailUidChanges.remove(NA - 1) : new UidRecord.ChangeItem();
            if (uidRec != null) {
                uidRec.pendingChange = pendingChange;
                if (change == 1 && !uidRec.idle) {
                    change = 2;
                }
            } else if (uid < 0) {
                throw new IllegalArgumentException("No UidRecord or uid");
            }
            pendingChange.uidRecord = uidRec;
            pendingChange.uid = uidRec != null ? uidRec.uid : uid;
            this.mPendingUidChanges.add(pendingChange);
        } else {
            pendingChange = uidRec.pendingChange;
            if (change == 1 && pendingChange.change == 3) {
                change = 2;
            }
        }
        pendingChange.change = change;
        pendingChange.processState = uidRec != null ? uidRec.setProcState : 18;
        pendingChange.ephemeral = uidRec != null ? uidRec.ephemeral : this.isEphemeralLocked(uid);
        long l = pendingChange.procStateSeq = uidRec != null ? uidRec.curProcStateSeq : 0L;
        if (uidRec != null) {
            uidRec.updateLastDispatchedProcStateSeq(change);
        }
        if (this.mLocalPowerManager != null) {
            switch (change) {
                case 1: 
                case 2: {
                    this.mLocalPowerManager.uidGone(pendingChange.uid);
                    break;
                }
                case 3: {
                    this.mLocalPowerManager.uidIdle(pendingChange.uid);
                    break;
                }
                case 4: {
                    this.mLocalPowerManager.uidActive(pendingChange.uid);
                    break;
                }
                default: {
                    this.mLocalPowerManager.updateUidProcState(pendingChange.uid, pendingChange.processState);
                }
            }
        }
    }

    private void maybeUpdateProviderUsageStatsLocked(ProcessRecord app, String providerPkgName, String authority) {
        if (app == null) {
            return;
        }
        if (app.curProcState <= 6) {
            UserState userState = this.mUserController.getStartedUserStateLocked(app.userId);
            if (userState == null) {
                return;
            }
            long now = SystemClock.elapsedRealtime();
            Long lastReported = userState.mProviderLastReportedFg.get(authority);
            if (lastReported == null || lastReported < now - 60000L) {
                if (this.mSystemReady) {
                    this.mUsageStatsService.reportContentProviderUsage(authority, providerPkgName, app.userId);
                }
                userState.mProviderLastReportedFg.put(authority, now);
            }
        }
    }

    private void maybeUpdateUsageStatsLocked(ProcessRecord app, long nowElapsed) {
        boolean isInteraction;
        if (this.mUsageStatsService == null) {
            return;
        }
        if (app.curProcState <= 3) {
            isInteraction = true;
            app.fgInteractionTime = 0L;
        } else if (app.curProcState <= 5) {
            if (app.fgInteractionTime == 0L) {
                app.fgInteractionTime = nowElapsed;
                isInteraction = false;
            } else {
                isInteraction = nowElapsed > app.fgInteractionTime + this.mConstants.SERVICE_USAGE_INTERACTION_TIME;
            }
        } else {
            isInteraction = app.curProcState <= 6;
            app.fgInteractionTime = 0L;
        }
        if (isInteraction && (!app.reportedInteraction || nowElapsed - app.interactionEventTime > this.mConstants.USAGE_STATS_INTERACTION_INTERVAL)) {
            app.interactionEventTime = nowElapsed;
            String[] packages = app.getPackageList();
            if (packages != null) {
                for (int i = 0; i < packages.length; ++i) {
                    this.mUsageStatsService.reportEvent(packages[i], app.userId, 6);
                }
            }
        }
        app.reportedInteraction = isInteraction;
        if (!isInteraction) {
            app.interactionEventTime = 0L;
        }
    }

    private final void setProcessTrackerStateLocked(ProcessRecord proc, int memFactor, long now) {
        if (proc.thread != null && proc.baseProcessTracker != null) {
            proc.baseProcessTracker.setState(proc.repProcState, memFactor, now, proc.pkgList);
        }
    }

    private final boolean updateOomAdjLocked(ProcessRecord app, int cachedAdj, ProcessRecord TOP_APP, boolean doingAll, long now) {
        if (app.thread == null) {
            return false;
        }
        this.computeOomAdjLocked(app, cachedAdj, TOP_APP, doingAll, now);
        return this.applyOomAdjLocked(app, doingAll, now, SystemClock.elapsedRealtime());
    }

    final void updateProcessForegroundLocked(ProcessRecord proc, boolean isForeground, boolean oomAdj) {
        if (isForeground != proc.foregroundServices) {
            proc.foregroundServices = isForeground;
            ArrayList<ProcessRecord> curProcs = this.mForegroundPackages.get(proc.info.packageName, proc.info.uid);
            if (isForeground) {
                if (curProcs == null) {
                    curProcs = new ArrayList();
                    this.mForegroundPackages.put(proc.info.packageName, proc.info.uid, curProcs);
                }
                if (!curProcs.contains(proc)) {
                    curProcs.add(proc);
                    this.mBatteryStatsService.noteEvent(32770, proc.info.packageName, proc.info.uid);
                }
            } else if (curProcs != null && curProcs.remove(proc)) {
                this.mBatteryStatsService.noteEvent(16386, proc.info.packageName, proc.info.uid);
                if (curProcs.size() <= 0) {
                    this.mForegroundPackages.remove(proc.info.packageName, proc.info.uid);
                }
            }
            if (oomAdj) {
                this.updateOomAdjLocked();
            }
        }
    }

    private final ActivityRecord resumedAppLocked() {
        int uid;
        String pkg;
        ActivityRecord act = this.mStackSupervisor.getResumedActivityLocked();
        if (act != null) {
            pkg = act.packageName;
            uid = act.info.applicationInfo.uid;
        } else {
            pkg = null;
            uid = -1;
        }
        if (uid != this.mCurResumedUid || pkg != this.mCurResumedPackage && (pkg == null || !pkg.equals(this.mCurResumedPackage))) {
            if (this.mCurResumedPackage != null) {
                this.mBatteryStatsService.noteEvent(16387, this.mCurResumedPackage, this.mCurResumedUid);
            }
            this.mCurResumedPackage = pkg;
            this.mCurResumedUid = uid;
            if (this.mCurResumedPackage != null) {
                this.mBatteryStatsService.noteEvent(32771, this.mCurResumedPackage, this.mCurResumedUid);
            }
        }
        return act;
    }

    final boolean updateOomAdjLocked(ProcessRecord app, boolean oomAdjAll) {
        ActivityRecord TOP_ACT = this.resumedAppLocked();
        ProcessRecord TOP_APP = TOP_ACT != null ? TOP_ACT.app : null;
        boolean wasCached = app.cached;
        ++this.mAdjSeq;
        int cachedAdj = app.curRawAdj >= 900 ? app.curRawAdj : 1001;
        boolean success = this.updateOomAdjLocked(app, cachedAdj, TOP_APP, false, SystemClock.uptimeMillis());
        if (oomAdjAll && (wasCached != app.cached || app.curRawAdj == 1001)) {
            this.updateOomAdjLocked();
        }
        return success;
    }

    final void updateOomAdjLocked() {
        int i;
        int cachedFactor;
        int emptyFactor;
        ActivityRecord TOP_ACT = this.resumedAppLocked();
        ProcessRecord TOP_APP = TOP_ACT != null ? TOP_ACT.app : null;
        long now = SystemClock.uptimeMillis();
        long nowElapsed = SystemClock.elapsedRealtime();
        long oldTime = now - 1800000L;
        int N = this.mLruProcesses.size();
        for (int i2 = this.mActiveUids.size() - 1; i2 >= 0; --i2) {
            UidRecord uidRec = this.mActiveUids.valueAt(i2);
            uidRec.reset();
        }
        this.mStackSupervisor.rankTaskLayersIfNeeded();
        ++this.mAdjSeq;
        this.mNewNumServiceProcs = 0;
        this.mNewNumAServiceProcs = 0;
        int emptyProcessLimit = this.mConstants.CUR_MAX_EMPTY_PROCESSES;
        int cachedProcessLimit = this.mConstants.CUR_MAX_CACHED_PROCESSES - emptyProcessLimit;
        int numSlots = 3;
        int numEmptyProcs = N - this.mNumNonCachedProcs - this.mNumCachedHiddenProcs;
        if (numEmptyProcs > cachedProcessLimit) {
            numEmptyProcs = cachedProcessLimit;
        }
        if ((emptyFactor = numEmptyProcs / numSlots) < 1) {
            emptyFactor = 1;
        }
        if ((cachedFactor = (this.mNumCachedHiddenProcs > 0 ? this.mNumCachedHiddenProcs : 1) / numSlots) < 1) {
            cachedFactor = 1;
        }
        int stepCached = 0;
        int stepEmpty = 0;
        int numCached = 0;
        int numEmpty = 0;
        int numTrimming = 0;
        this.mNumNonCachedProcs = 0;
        this.mNumCachedHiddenProcs = 0;
        int curCachedAdj = 900;
        int nextCachedAdj = curCachedAdj + 1;
        int curEmptyAdj = 900;
        int nextEmptyAdj = curEmptyAdj + 2;
        for (int i3 = N - 1; i3 >= 0; --i3) {
            ProcessRecord app = this.mLruProcesses.get(i3);
            if (app.killedByAm || app.thread == null) continue;
            app.procStateChanged = false;
            this.computeOomAdjLocked(app, 1001, TOP_APP, true, now);
            if (app.curAdj >= 1001) {
                switch (app.curProcState) {
                    case 15: 
                    case 16: {
                        app.curRawAdj = curCachedAdj;
                        app.curAdj = app.modifyRawOomAdj(curCachedAdj);
                        if (curCachedAdj == nextCachedAdj || ++stepCached < cachedFactor) break;
                        stepCached = 0;
                        curCachedAdj = nextCachedAdj;
                        if ((nextCachedAdj += 2) <= 906) break;
                        nextCachedAdj = 906;
                        break;
                    }
                    default: {
                        app.curRawAdj = curEmptyAdj;
                        app.curAdj = app.modifyRawOomAdj(curEmptyAdj);
                        if (curEmptyAdj == nextEmptyAdj || ++stepEmpty < emptyFactor) break;
                        stepEmpty = 0;
                        curEmptyAdj = nextEmptyAdj;
                        if ((nextEmptyAdj += 2) <= 906) break;
                        nextEmptyAdj = 906;
                    }
                }
            }
            this.applyOomAdjLocked(app, true, now, nowElapsed);
            switch (app.curProcState) {
                case 15: 
                case 16: {
                    ++this.mNumCachedHiddenProcs;
                    if (++numCached <= cachedProcessLimit) break;
                    app.kill("cached #" + numCached, true);
                    break;
                }
                case 17: {
                    if (numEmpty > this.mConstants.CUR_TRIM_EMPTY_PROCESSES && app.lastActivityTime < oldTime) {
                        app.kill("empty for " + (oldTime + 1800000L - app.lastActivityTime) / 1000L + "s", true);
                        break;
                    }
                    if (++numEmpty <= emptyProcessLimit) break;
                    app.kill("empty #" + numEmpty, true);
                    break;
                }
                default: {
                    ++this.mNumNonCachedProcs;
                }
            }
            if (app.isolated && app.services.size() <= 0) {
                app.kill("isolated not needed", true);
            } else {
                UidRecord uidRec = app.uidRecord;
                if (uidRec != null) {
                    uidRec.ephemeral = app.info.isInstantApp();
                    if (uidRec.curProcState > app.curProcState) {
                        uidRec.curProcState = app.curProcState;
                    }
                    if (app.foregroundServices) {
                        uidRec.foregroundServices = true;
                    }
                }
            }
            if (app.curProcState < 13 || app.killedByAm) continue;
            ++numTrimming;
        }
        this.incrementProcStateSeqAndNotifyAppsLocked();
        this.mNumServiceProcs = this.mNewNumServiceProcs;
        int numCachedAndEmpty = numCached + numEmpty;
        int memFactor = numCached <= this.mConstants.CUR_TRIM_CACHED_PROCESSES && numEmpty <= this.mConstants.CUR_TRIM_EMPTY_PROCESSES ? (numCachedAndEmpty <= 3 ? 3 : (numCachedAndEmpty <= 5 ? 2 : 1)) : 0;
        if (!(memFactor <= this.mLastMemoryLevel || this.mAllowLowerMemLevel && this.mLruProcesses.size() < this.mLastNumProcesses)) {
            memFactor = this.mLastMemoryLevel;
        }
        if (memFactor != this.mLastMemoryLevel) {
            EventLogTags.writeAmMemFactor(memFactor, this.mLastMemoryLevel);
        }
        this.mLastMemoryLevel = memFactor;
        this.mLastNumProcesses = this.mLruProcesses.size();
        boolean allChanged = this.mProcessStats.setMemFactorLocked(memFactor, !this.isSleepingLocked(), now);
        int trackerMemFactor = this.mProcessStats.getMemFactorLocked();
        if (memFactor != 0) {
            int fgTrimLevel;
            if (this.mLowRamStartTime == 0L) {
                this.mLowRamStartTime = now;
            }
            int step = 0;
            switch (memFactor) {
                case 3: {
                    fgTrimLevel = 15;
                    break;
                }
                case 2: {
                    fgTrimLevel = 10;
                    break;
                }
                default: {
                    fgTrimLevel = 5;
                }
            }
            int factor = numTrimming / 3;
            int minFactor = 2;
            if (this.mHomeProcess != null) {
                ++minFactor;
            }
            if (this.mPreviousProcess != null) {
                ++minFactor;
            }
            if (factor < minFactor) {
                factor = minFactor;
            }
            int curLevel = 80;
            for (int i4 = N - 1; i4 >= 0; --i4) {
                ProcessRecord app = this.mLruProcesses.get(i4);
                if (allChanged || app.procStateChanged) {
                    this.setProcessTrackerStateLocked(app, trackerMemFactor, now);
                    app.procStateChanged = false;
                }
                if (app.curProcState >= 13 && !app.killedByAm) {
                    if (app.trimMemoryLevel < curLevel && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(curLevel);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    app.trimMemoryLevel = curLevel;
                    if (++step < factor) continue;
                    step = 0;
                    switch (curLevel) {
                        case 80: {
                            curLevel = 60;
                            break;
                        }
                        case 60: {
                            curLevel = 40;
                        }
                    }
                    continue;
                }
                if (app.curProcState == 10) {
                    if (app.trimMemoryLevel < 40 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(40);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    app.trimMemoryLevel = 40;
                    continue;
                }
                if ((app.curProcState >= 7 || app.systemNoUi) && app.pendingUiClean) {
                    int level = 20;
                    if (app.trimMemoryLevel < 20 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(20);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    app.pendingUiClean = false;
                }
                if (app.trimMemoryLevel < fgTrimLevel && app.thread != null) {
                    try {
                        app.thread.scheduleTrimMemory(fgTrimLevel);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                app.trimMemoryLevel = fgTrimLevel;
            }
        } else {
            if (this.mLowRamStartTime != 0L) {
                this.mLowRamTimeSinceLastIdle += now - this.mLowRamStartTime;
                this.mLowRamStartTime = 0L;
            }
            for (i = N - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (allChanged || app.procStateChanged) {
                    this.setProcessTrackerStateLocked(app, trackerMemFactor, now);
                    app.procStateChanged = false;
                }
                if ((app.curProcState >= 7 || app.systemNoUi) && app.pendingUiClean) {
                    if (app.trimMemoryLevel < 20 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(20);
                        }
                        catch (RemoteException factor) {
                            // empty catch block
                        }
                    }
                    app.pendingUiClean = false;
                }
                app.trimMemoryLevel = 0;
            }
        }
        if (this.mAlwaysFinishActivities) {
            this.mStackSupervisor.scheduleDestroyAllActivities(null, "always-finish");
        }
        if (allChanged) {
            this.requestPssAllProcsLocked(now, false, this.mProcessStats.isMemFactorLowered());
        }
        if (this.mLocalPowerManager != null) {
            this.mLocalPowerManager.startUidChanges();
        }
        for (i = this.mActiveUids.size() - 1; i >= 0; --i) {
            UidRecord uidRec = this.mActiveUids.valueAt(i);
            int uidChange = 0;
            if (uidRec.setProcState == uidRec.curProcState && uidRec.setWhitelist == uidRec.curWhitelist) continue;
            if (ActivityManager.isProcStateBackground(uidRec.curProcState) && !uidRec.curWhitelist) {
                if (!ActivityManager.isProcStateBackground(uidRec.setProcState) || uidRec.setWhitelist) {
                    uidRec.lastBackgroundTime = nowElapsed;
                    if (!this.mHandler.hasMessages(58)) {
                        this.mHandler.sendEmptyMessageDelayed(58, this.mConstants.BACKGROUND_SETTLE_TIME);
                    }
                }
            } else {
                if (uidRec.idle) {
                    uidChange = 4;
                    EventLogTags.writeAmUidActive(uidRec.uid);
                    uidRec.idle = false;
                }
                uidRec.lastBackgroundTime = 0L;
            }
            uidRec.setProcState = uidRec.curProcState;
            uidRec.setWhitelist = uidRec.curWhitelist;
            this.enqueueUidChangeLocked(uidRec, -1, uidChange);
            this.noteUidProcessState(uidRec.uid, uidRec.curProcState);
            if (!uidRec.foregroundServices) continue;
            this.mServices.foregroundServiceProcStateChangedLocked(uidRec);
        }
        if (this.mLocalPowerManager != null) {
            this.mLocalPowerManager.finishUidChanges();
        }
        if (this.mProcessStats.shouldWriteNowLocked(now)) {
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        ActivityManagerService.this.mProcessStats.writeStateAsyncLocked();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makePackageIdle(String packageName, int userId) {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: makePackageIdle() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        int callingPid = Binder.getCallingPid();
        userId = this.mUserController.handleIncomingUser(callingPid, Binder.getCallingUid(), userId, true, 2, "makePackageIdle", null);
        long callingId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                int pkgUid = -1;
                try {
                    pkgUid = pm.getPackageUid(packageName, 0x10002000, 0);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                if (pkgUid == -1) {
                    throw new IllegalArgumentException("Unknown package name " + packageName);
                }
                if (this.mLocalPowerManager != null) {
                    this.mLocalPowerManager.startUidChanges();
                }
                int appId = UserHandle.getAppId(pkgUid);
                int N = this.mActiveUids.size();
                for (int i = N - 1; i >= 0; --i) {
                    UidRecord uidRec = this.mActiveUids.valueAt(i);
                    long bgTime = uidRec.lastBackgroundTime;
                    if (bgTime <= 0L || uidRec.idle || UserHandle.getAppId(uidRec.uid) != appId || userId != -1 && userId != UserHandle.getUserId(uidRec.uid)) continue;
                    EventLogTags.writeAmUidIdle(uidRec.uid);
                    uidRec.idle = true;
                    Slog.w("ActivityManager", "Idling uid " + UserHandle.formatUid(uidRec.uid) + " from package " + packageName + " user " + userId);
                    this.doStopUidLocked(uidRec.uid, uidRec);
                }
            }
            finally {
                if (this.mLocalPowerManager != null) {
                    this.mLocalPowerManager.finishUidChanges();
                }
                Binder.restoreCallingIdentity(callingId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void idleUids() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int N = this.mActiveUids.size();
            if (N <= 0) {
                return;
            }
            long nowElapsed = SystemClock.elapsedRealtime();
            long maxBgTime = nowElapsed - this.mConstants.BACKGROUND_SETTLE_TIME;
            long nextTime = 0L;
            if (this.mLocalPowerManager != null) {
                this.mLocalPowerManager.startUidChanges();
            }
            for (int i = N - 1; i >= 0; --i) {
                UidRecord uidRec = this.mActiveUids.valueAt(i);
                long bgTime = uidRec.lastBackgroundTime;
                if (bgTime <= 0L || uidRec.idle) continue;
                if (bgTime <= maxBgTime) {
                    EventLogTags.writeAmUidIdle(uidRec.uid);
                    uidRec.idle = true;
                    this.doStopUidLocked(uidRec.uid, uidRec);
                    continue;
                }
                if (nextTime != 0L && nextTime <= bgTime) continue;
                nextTime = bgTime;
            }
            if (this.mLocalPowerManager != null) {
                this.mLocalPowerManager.finishUidChanges();
            }
            if (nextTime > 0L) {
                this.mHandler.removeMessages(58);
                this.mHandler.sendEmptyMessageDelayed(58, nextTime + this.mConstants.BACKGROUND_SETTLE_TIME - nowElapsed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="this")
    void incrementProcStateSeqAndNotifyAppsLocked() {
        int i;
        if (this.mWaitForNetworkTimeoutMs <= 0L) {
            return;
        }
        ArrayList<Integer> blockingUids = null;
        for (i = this.mActiveUids.size() - 1; i >= 0; --i) {
            int blockState;
            UidRecord uidRec = this.mActiveUids.valueAt(i);
            if (!this.mInjector.isNetworkRestrictedForUid(uidRec.uid) || !UserHandle.isApp(uidRec.uid) || !uidRec.hasInternetPermission || uidRec.setProcState == uidRec.curProcState || (blockState = this.getBlockStateForUid(uidRec)) == 0) continue;
            Object object = uidRec.networkStateLock;
            synchronized (object) {
                uidRec.curProcStateSeq = ++this.mProcStateSeqCounter;
                if (blockState == 1) {
                    if (blockingUids == null) {
                        blockingUids = new ArrayList<Integer>();
                    }
                    blockingUids.add(uidRec.uid);
                } else if (uidRec.waitingForNetwork) {
                    uidRec.networkStateLock.notifyAll();
                }
                continue;
            }
        }
        if (blockingUids == null) {
            return;
        }
        for (i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord app = this.mLruProcesses.get(i);
            if (!blockingUids.contains(app.uid) || app.killedByAm || app.thread == null) continue;
            UidRecord uidRec = this.mActiveUids.get(app.uid);
            try {
                app.thread.setNetworkBlockSeq(uidRec.curProcStateSeq);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    int getBlockStateForUid(UidRecord uidRec) {
        boolean wasAllowed;
        boolean isAllowed = NetworkPolicyManager.isProcStateAllowedWhileIdleOrPowerSaveMode(uidRec.curProcState) || NetworkPolicyManager.isProcStateAllowedWhileOnRestrictBackground(uidRec.curProcState);
        boolean bl = wasAllowed = NetworkPolicyManager.isProcStateAllowedWhileIdleOrPowerSaveMode(uidRec.setProcState) || NetworkPolicyManager.isProcStateAllowedWhileOnRestrictBackground(uidRec.setProcState);
        if (!wasAllowed && isAllowed) {
            return 1;
        }
        if (wasAllowed && !isAllowed) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runInBackgroundDisabled(int uid) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UidRecord uidRec = this.mActiveUids.get(uid);
            if (uidRec != null) {
                if (uidRec.idle) {
                    this.doStopUidLocked(uidRec.uid, uidRec);
                }
            } else {
                this.doStopUidLocked(uid, null);
            }
        }
    }

    final void doStopUidLocked(int uid, UidRecord uidRec) {
        this.mServices.stopInBackgroundLocked(uid);
        this.enqueueUidChangeLocked(uidRec, uid, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tempWhitelistForPendingIntentLocked(int callerPid, int callerUid, int targetUid, long duration, String tag) {
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            ProcessRecord pr = this.mPidsSelfLocked.get(callerPid);
            if (pr == null) {
                Slog.w("ActivityManager", "tempWhitelistForPendingIntentLocked() no ProcessRecord for pid " + callerPid);
                return;
            }
            if (!pr.whitelistManager && this.checkPermission("android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", callerPid, callerUid) != 0) {
                return;
            }
        }
        this.tempWhitelistUidLocked(targetUid, duration, tag);
    }

    void tempWhitelistUidLocked(int targetUid, long duration, String tag) {
        this.mPendingTempWhitelist.put(targetUid, new PendingTempWhitelist(targetUid, duration, tag));
        this.setUidTempWhitelistStateLocked(targetUid, true);
        this.mUiHandler.obtainMessage(68).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushTempWhitelist() {
        int i;
        PendingTempWhitelist[] list;
        int N;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            N = this.mPendingTempWhitelist.size();
            list = new PendingTempWhitelist[N];
            for (i = 0; i < N; ++i) {
                list[i] = this.mPendingTempWhitelist.valueAt(i);
            }
        }
        for (int i2 = 0; i2 < N; ++i2) {
            PendingTempWhitelist ptw = list[i2];
            this.mLocalDeviceIdleController.addPowerSaveTempWhitelistAppDirect(ptw.targetUid, ptw.duration, true, ptw.tag);
        }
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            for (i = 0; i < N; ++i) {
                PendingTempWhitelist ptw = list[i];
                int index = this.mPendingTempWhitelist.indexOfKey(ptw.targetUid);
                if (index < 0 || this.mPendingTempWhitelist.valueAt(index) != ptw) continue;
                this.mPendingTempWhitelist.removeAt(index);
            }
        }
    }

    final void setAppIdTempWhitelistStateLocked(int appId, boolean onWhitelist) {
        boolean changed = false;
        for (int i = this.mActiveUids.size() - 1; i >= 0; --i) {
            UidRecord uidRec = this.mActiveUids.valueAt(i);
            if (UserHandle.getAppId(uidRec.uid) != appId || uidRec.curWhitelist == onWhitelist) continue;
            uidRec.curWhitelist = onWhitelist;
            changed = true;
        }
        if (changed) {
            this.updateOomAdjLocked();
        }
    }

    final void setUidTempWhitelistStateLocked(int uid, boolean onWhitelist) {
        boolean changed = false;
        UidRecord uidRec = this.mActiveUids.get(uid);
        if (uidRec != null && uidRec.curWhitelist != onWhitelist) {
            uidRec.curWhitelist = onWhitelist;
            this.updateOomAdjLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void trimApplications() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mRemovedProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mRemovedProcesses.get(i);
                if (app.activities.size() != 0 || !app.curReceivers.isEmpty() || app.services.size() != 0) continue;
                Slog.i("ActivityManager", "Exiting empty application process " + app.toShortString() + " (" + (app.thread != null ? app.thread.asBinder() : null) + ")\n");
                if (app.pid > 0 && app.pid != MY_PID) {
                    app.kill("empty", false);
                } else {
                    try {
                        app.thread.scheduleExit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.cleanUpApplicationRecordLocked(app, false, true, -1, false);
                this.mRemovedProcesses.remove(i);
                if (!app.persistent) continue;
                this.addAppLocked(app.info, null, false, null);
            }
            this.updateOomAdjLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalPersistentProcesses(int sig) throws RemoteException {
        if (sig != 10) {
            throw new SecurityException("Only SIGNAL_USR1 is allowed");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.checkCallingPermission("android.permission.SIGNAL_PERSISTENT_PROCESSES") != 0) {
                throw new SecurityException("Requires permission android.permission.SIGNAL_PERSISTENT_PROCESSES");
            }
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord r = this.mLruProcesses.get(i);
                if (r.thread == null || !r.persistent) continue;
                android.os.Process.sendSignal(r.pid, sig);
            }
        }
    }

    private void stopProfilerLocked(ProcessRecord proc, int profileType) {
        if (proc == null || proc == this.mProfileProc) {
            proc = this.mProfileProc;
            profileType = this.mProfileType;
            this.clearProfilerLocked();
        }
        if (proc == null) {
            return;
        }
        try {
            proc.thread.profilerControl(false, null, profileType);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Process disappeared");
        }
    }

    private void clearProfilerLocked() {
        if (this.mProfileFd != null) {
            try {
                this.mProfileFd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mProfileApp = null;
        this.mProfileProc = null;
        this.mProfileFile = null;
        this.mProfileType = 0;
        this.mAutoStopProfiler = false;
        this.mStreamingOutput = false;
        this.mSamplingInterval = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean profileControl(String process, int userId, boolean start, ProfilerInfo profilerInfo, int profileType) throws RemoteException {
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
                        throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
                    }
                    if (start && (profilerInfo == null || profilerInfo.profileFd == null)) {
                        throw new IllegalArgumentException("null profile info or fd");
                    }
                    ProcessRecord proc = null;
                    if (process != null) {
                        proc = this.findProcessLocked(process, userId, "profileControl");
                    }
                    if (start && (proc == null || proc.thread == null)) {
                        throw new IllegalArgumentException("Unknown process: " + process);
                    }
                    if (start) {
                        this.stopProfilerLocked(null, 0);
                        this.setProfileApp(proc.info, proc.processName, profilerInfo);
                        this.mProfileProc = proc;
                        this.mProfileType = profileType;
                        ParcelFileDescriptor fd = profilerInfo.profileFd;
                        try {
                            fd = fd.dup();
                        }
                        catch (IOException e) {
                            fd = null;
                        }
                        profilerInfo.profileFd = fd;
                        proc.thread.profilerControl(start, profilerInfo, profileType);
                        fd = null;
                        try {
                            this.mProfileFd.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.mProfileFd = null;
                    } else {
                        this.stopProfilerLocked(proc, profileType);
                        if (profilerInfo != null && profilerInfo.profileFd != null) {
                            try {
                                profilerInfo.profileFd.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (RemoteException e) {
                        throw new IllegalStateException("Process disappeared");
                    }
                }
            }
        }
        finally {
            if (profilerInfo != null && profilerInfo.profileFd != null) {
                try {
                    profilerInfo.profileFd.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessRecord findProcessLocked(String process, int userId, String callName) {
        ArrayMap<String, SparseArray<ProcessRecord>> all;
        SparseArray<ProcessRecord> procs;
        userId = this.mUserController.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, 2, callName, null);
        ProcessRecord proc = null;
        try {
            int pid = Integer.parseInt(process);
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                proc = this.mPidsSelfLocked.get(pid);
            }
        }
        catch (NumberFormatException pid) {
            // empty catch block
        }
        if (proc == null && (procs = (all = this.mProcessNames.getMap()).get(process)) != null && procs.size() > 0) {
            proc = procs.valueAt(0);
            if (userId != -1 && proc.userId != userId) {
                for (int i = 1; i < procs.size(); ++i) {
                    ProcessRecord thisProc = procs.valueAt(i);
                    if (thisProc.userId != userId) continue;
                    proc = thisProc;
                    break;
                }
            }
        }
        return proc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dumpHeap(String process, int userId, boolean managed, String path, ParcelFileDescriptor fd) throws RemoteException {
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
                        throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
                    }
                    if (fd == null) {
                        throw new IllegalArgumentException("null fd");
                    }
                    ProcessRecord proc = this.findProcessLocked(process, userId, "dumpHeap");
                    if (proc == null || proc.thread == null) {
                        throw new IllegalArgumentException("Unknown process: " + process);
                    }
                    boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
                    if (!isDebuggable && (proc.info.flags & 2) == 0) {
                        throw new SecurityException("Process not debuggable: " + proc);
                    }
                    proc.thread.dumpHeap(managed, path, fd);
                    fd = null;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (RemoteException e) {
                        throw new IllegalStateException("Process disappeared");
                    }
                }
            }
        }
        finally {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDumpHeapDebugLimit(String processName, int uid, long maxMemSize, String reportPackage) {
        Object object;
        if (processName != null) {
            this.enforceCallingPermission("android.permission.SET_DEBUG_APP", "setDumpHeapDebugLimit()");
        } else {
            object = this.mPidsSelfLocked;
            synchronized (object) {
                ProcessRecord proc = this.mPidsSelfLocked.get(Binder.getCallingPid());
                if (proc == null) {
                    throw new SecurityException("No process found for calling pid " + Binder.getCallingPid());
                }
                if (!Build.IS_DEBUGGABLE && (proc.info.flags & 2) == 0) {
                    throw new SecurityException("Not running a debuggable build");
                }
                processName = proc.processName;
                uid = proc.uid;
                if (reportPackage != null && !proc.pkgList.containsKey(reportPackage)) {
                    throw new SecurityException("Package " + reportPackage + " is not running in " + proc);
                }
            }
        }
        object = this;
        synchronized (object) {
            if (maxMemSize > 0L) {
                this.mMemWatchProcesses.put(processName, uid, new Pair<Long, String>(maxMemSize, reportPackage));
            } else if (uid != 0) {
                this.mMemWatchProcesses.remove(processName, uid);
            } else {
                this.mMemWatchProcesses.getMap().remove(processName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpHeapFinished(String path) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (Binder.getCallingPid() != this.mMemWatchDumpPid) {
                Slog.w("ActivityManager", "dumpHeapFinished: Calling pid " + Binder.getCallingPid() + " does not match last pid " + this.mMemWatchDumpPid);
                return;
            }
            if (this.mMemWatchDumpFile == null || !this.mMemWatchDumpFile.equals(path)) {
                Slog.w("ActivityManager", "dumpHeapFinished: Calling path " + path + " does not match last path " + this.mMemWatchDumpFile);
                return;
            }
            this.mHandler.sendEmptyMessage(50);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
        }
    }

    void onCoreSettingsChange(Bundle settings) {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord processRecord = this.mLruProcesses.get(i);
            try {
                if (processRecord.thread == null) continue;
                processRecord.thread.setCoreSettings(settings);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean startUserInBackground(int userId) {
        return this.mUserController.startUser(userId, false);
    }

    @Override
    public boolean unlockUser(int userId, byte[] token, byte[] secret, IProgressListener listener) {
        return this.mUserController.unlockUser(userId, token, secret, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchUser(int targetUserId) {
        UserInfo targetUserInfo;
        int currentUserId;
        this.enforceShellRestriction("no_debugging_features", targetUserId);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            currentUserId = this.mUserController.getCurrentUserIdLocked();
            targetUserInfo = this.mUserController.getUserInfo(targetUserId);
            if (targetUserId == currentUserId) {
                Slog.i("ActivityManager", "user #" + targetUserId + " is already the current user");
                return true;
            }
            if (targetUserInfo == null) {
                Slog.w("ActivityManager", "No user info for user #" + targetUserId);
                return false;
            }
            if (!targetUserInfo.isDemo() && UserManager.isDeviceInDemoMode(this.mContext)) {
                Slog.w("ActivityManager", "Cannot switch to non-demo user #" + targetUserId + " when device is in demo mode");
                return false;
            }
            if (!targetUserInfo.supportsSwitchTo()) {
                Slog.w("ActivityManager", "Cannot switch to User #" + targetUserId + ": not supported");
                return false;
            }
            if (targetUserInfo.isManagedProfile()) {
                Slog.w("ActivityManager", "Cannot switch to User #" + targetUserId + ": not a full user");
                return false;
            }
            this.mUserController.setTargetUserIdLocked(targetUserId);
        }
        if (this.mUserController.mUserSwitchUiEnabled) {
            UserInfo currentUserInfo = this.mUserController.getUserInfo(currentUserId);
            Pair<UserInfo, UserInfo> userNames = new Pair<UserInfo, UserInfo>(currentUserInfo, targetUserInfo);
            this.mUiHandler.removeMessages(46);
            this.mUiHandler.sendMessage(this.mHandler.obtainMessage(46, userNames));
        } else {
            this.mHandler.removeMessages(712);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(712, targetUserId, 0));
        }
        return true;
    }

    void scheduleStartProfilesLocked() {
        if (!this.mHandler.hasMessages(40)) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(40), 1000L);
        }
    }

    @Override
    public int stopUser(int userId, boolean force, IStopUserCallback callback) {
        return this.mUserController.stopUser(userId, force, callback);
    }

    @Override
    public UserInfo getCurrentUser() {
        return this.mUserController.getCurrentUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getStartedUserState(int userId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UserState userState = this.mUserController.getStartedUserStateLocked(userId);
            return UserState.stateToString(userState.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserRunning(int userId, int flags) {
        if (!this.mUserController.isSameProfileGroup(userId, UserHandle.getCallingUserId()) && this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0) {
            String msg = "Permission Denial: isUserRunning() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mUserController.isUserRunningLocked(userId, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getRunningUserIds() {
        if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0) {
            String msg = "Permission Denial: isUserRunning() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mUserController.getStartedUserArrayLocked();
        }
    }

    @Override
    public void registerUserSwitchObserver(IUserSwitchObserver observer, String name) {
        this.mUserController.registerUserSwitchObserver(observer, name);
    }

    @Override
    public void unregisterUserSwitchObserver(IUserSwitchObserver observer) {
        this.mUserController.unregisterUserSwitchObserver(observer);
    }

    ApplicationInfo getAppInfoForUser(ApplicationInfo info, int userId) {
        if (info == null) {
            return null;
        }
        ApplicationInfo newInfo = new ApplicationInfo(info);
        newInfo.initForUser(userId);
        return newInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserStopped(int userId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mUserController.getStartedUserStateLocked(userId) == null;
        }
    }

    ActivityInfo getActivityInfoForUser(ActivityInfo aInfo, int userId) {
        if (aInfo == null || userId < 1 && aInfo.applicationInfo.uid < 100000) {
            return aInfo;
        }
        ActivityInfo info = new ActivityInfo(aInfo);
        info.applicationInfo = this.getAppInfoForUser(info.applicationInfo, userId);
        return info;
    }

    private boolean processSanityChecksLocked(ProcessRecord process) {
        if (process == null || process.thread == null) {
            return false;
        }
        boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
        return isDebuggable || (process.info.flags & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startBinderTracking() throws RemoteException {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mBinderTransactionTrackingEnabled = true;
            if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
                throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
            }
            for (int i = 0; i < this.mLruProcesses.size(); ++i) {
                ProcessRecord process = this.mLruProcesses.get(i);
                if (!this.processSanityChecksLocked(process)) continue;
                try {
                    process.thread.startBinderTracking();
                    continue;
                }
                catch (RemoteException e) {
                    Log.v("ActivityManager", "Process disappared");
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopBinderTrackingAndDump(ParcelFileDescriptor fd) throws RemoteException {
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.mBinderTransactionTrackingEnabled = false;
                if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
                    throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
                }
                if (fd == null) {
                    throw new IllegalArgumentException("null fd");
                }
                FastPrintWriter pw = new FastPrintWriter(new FileOutputStream(fd.getFileDescriptor()));
                pw.println("Binder transaction traces for all processes.\n");
                for (ProcessRecord process : this.mLruProcesses) {
                    if (!this.processSanityChecksLocked(process)) continue;
                    pw.println("Traces for process: " + process.processName);
                    ((PrintWriter)pw).flush();
                    try {
                        TransferPipe tp = new TransferPipe();
                        try {
                            process.thread.stopBinderTrackingAndDump(tp.getWriteFd());
                            tp.go(fd.getFileDescriptor());
                        }
                        finally {
                            tp.kill();
                        }
                    }
                    catch (IOException e) {
                        pw.println("Failure while dumping IPC traces from " + process + ".  Exception: " + e);
                        ((PrintWriter)pw).flush();
                    }
                    catch (RemoteException e) {
                        pw.println("Got a RemoteException while dumping IPC traces from " + process + ".  Exception: " + e);
                        ((PrintWriter)pw).flush();
                    }
                }
                fd = null;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForNetworkStateUpdate(long procStateSeq) {
        UidRecord record;
        int callingUid = Binder.getCallingUid();
        Object object = this;
        synchronized (object) {
            record = this.mActiveUids.get(callingUid);
            if (record == null) {
                return;
            }
        }
        object = record.networkStateLock;
        synchronized (object) {
            if (record.lastDispatchedProcStateSeq < procStateSeq) {
                return;
            }
            if (record.curProcStateSeq > procStateSeq) {
                return;
            }
            if (record.lastNetworkUpdatedProcStateSeq >= procStateSeq) {
                return;
            }
            try {
                long startTime = SystemClock.uptimeMillis();
                record.waitingForNetwork = true;
                record.networkStateLock.wait(this.mWaitForNetworkTimeoutMs);
                record.waitingForNetwork = false;
                long totalTime = SystemClock.uptimeMillis() - startTime;
                if (totalTime >= this.mWaitForNetworkTimeoutMs) {
                    Slog.wtf(TAG_NETWORK, "Total time waited for network rules to get updated: " + totalTime + ". Uid: " + callingUid + " procStateSeq: " + procStateSeq + " UidRec: " + record + " validateUidRec: " + this.mValidateUids.get(callingUid));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBroadcastIdle(PrintWriter pw) {
        this.enforceCallingPermission("android.permission.DUMP", "waitForBroadcastIdle()");
        while (true) {
            boolean idle = true;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                for (BroadcastQueue queue : this.mBroadcastQueues) {
                    if (queue.isIdle()) continue;
                    String msg = "Waiting for queue " + queue + " to become idle...";
                    pw.println(msg);
                    pw.flush();
                    Slog.v("ActivityManager", msg);
                    idle = false;
                }
            }
            if (idle) {
                String msg = "All broadcast queues are idle!";
                pw.println("All broadcast queues are idle!");
                pw.flush();
                Slog.v("ActivityManager", "All broadcast queues are idle!");
                return;
            }
            SystemClock.sleep(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLastResumedActivityUserId() {
        this.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "getLastResumedActivityUserId()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mLastResumedActivity == null) {
                return this.mUserController.getCurrentUserIdLocked();
            }
            return this.mLastResumedActivity.userId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killPackageDependents(String packageName, int userId) {
        this.enforceCallingPermission("android.permission.KILL_UID", "killPackageDependents()");
        if (packageName == null) {
            throw new NullPointerException("Cannot kill the dependents of a package without its name.");
        }
        long callingId = Binder.clearCallingIdentity();
        IPackageManager pm = AppGlobals.getPackageManager();
        int pkgUid = -1;
        try {
            pkgUid = pm.getPackageUid(packageName, 0x10000000, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (userId != -1 && pkgUid == -1) {
            throw new IllegalArgumentException("Cannot kill dependents of non-existing package " + packageName);
        }
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.killPackageProcessesLocked(packageName, UserHandle.getAppId(pkgUid), userId, 0, false, true, true, false, "dep: " + packageName);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismissKeyguard(IBinder token, IKeyguardDismissCallback callback) throws RemoteException {
        long callingId = Binder.clearCallingIdentity();
        try {
            this.mKeyguardController.dismissKeyguard(token, callback);
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    @Override
    public int restartUserInBackground(int userId) {
        return this.mUserController.restartUser(userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleApplicationInfoChanged(List<String> packageNames, int userId) {
        this.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "scheduleApplicationInfoChanged()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                this.updateApplicationInfoLocked(packageNames, userId);
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    void updateApplicationInfoLocked(List<String> packagesToUpdate, int userId) {
        boolean updateFrameworkRes = packagesToUpdate.contains("android");
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord app = this.mLruProcesses.get(i);
            if (app.thread == null || userId != -1 && app.userId != userId) continue;
            int packageCount = app.pkgList.size();
            for (int j = 0; j < packageCount; ++j) {
                String packageName = app.pkgList.keyAt(j);
                if (!updateFrameworkRes && !packagesToUpdate.contains(packageName)) continue;
                try {
                    ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(packageName, 0, app.userId);
                    if (ai == null) continue;
                    app.thread.scheduleApplicationInfoChanged(ai);
                    continue;
                }
                catch (RemoteException e) {
                    Slog.w("ActivityManager", String.format("Failed to update %s ApplicationInfo for %s", packageName, app));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachAgent(String process, String path) {
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ProcessRecord proc = this.findProcessLocked(process, 0, "attachAgent");
                if (proc == null || proc.thread == null) {
                    throw new IllegalArgumentException("Unknown process: " + process);
                }
                boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
                if (!isDebuggable && (proc.info.flags & 2) == 0) {
                    throw new SecurityException("Process not debuggable: " + proc);
                }
                proc.thread.attachAgent(path);
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Process disappeared");
        }
    }

    public static class Injector {
        private NetworkManagementInternal mNmi;

        public Context getContext() {
            return null;
        }

        public AppOpsService getAppOpsService(File file, Handler handler) {
            return new AppOpsService(file, handler);
        }

        public Handler getUiHandler(ActivityManagerService service) {
            return service.new UiHandler();
        }

        public boolean isNetworkRestrictedForUid(int uid) {
            if (this.ensureHasNetworkManagementInternal()) {
                return this.mNmi.isNetworkRestrictedForUid(uid);
            }
            return false;
        }

        private boolean ensureHasNetworkManagementInternal() {
            if (this.mNmi == null) {
                this.mNmi = LocalServices.getService(NetworkManagementInternal.class);
            }
            return this.mNmi != null;
        }
    }

    class AppTaskImpl
    extends IAppTask.Stub {
        private int mTaskId;
        private int mCallingUid;

        public AppTaskImpl(int taskId, int callingUid) {
            this.mTaskId = taskId;
            this.mCallingUid = callingUid;
        }

        private void checkCaller() {
            if (this.mCallingUid != Binder.getCallingUid()) {
                throw new SecurityException("Caller " + this.mCallingUid + " does not match caller of getAppTasks(): " + Binder.getCallingUid());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishAndRemoveTask() {
            this.checkCaller();
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                long origId = Binder.clearCallingIdentity();
                try {
                    if (!ActivityManagerService.this.mStackSupervisor.removeTaskByIdLocked(this.mTaskId, false, true)) {
                        throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActivityManager.RecentTaskInfo getTaskInfo() {
            this.checkCaller();
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManager.RecentTaskInfo recentTaskInfo;
                long origId = Binder.clearCallingIdentity();
                try {
                    TaskRecord tr = ActivityManagerService.this.mStackSupervisor.anyTaskForIdLocked(this.mTaskId);
                    if (tr == null) {
                        throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                    }
                    recentTaskInfo = ActivityManagerService.this.createRecentTaskInfoFromTaskRecord(tr);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(origId);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(origId);
                return recentTaskInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void moveToFront() {
            this.checkCaller();
            long origId = Binder.clearCallingIdentity();
            try {
                AppTaskImpl appTaskImpl = this;
                synchronized (appTaskImpl) {
                    ActivityManagerService.this.mStackSupervisor.startActivityFromRecentsInner(this.mTaskId, null);
                }
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startActivity(IBinder whoThread, String callingPackage, Intent intent, String resolvedType, Bundle bOptions) {
            IApplicationThread appThread;
            TaskRecord tr;
            this.checkCaller();
            int callingUser = UserHandle.getCallingUserId();
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                tr = ActivityManagerService.this.mStackSupervisor.anyTaskForIdLocked(this.mTaskId);
                if (tr == null) {
                    throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                }
                appThread = IApplicationThread.Stub.asInterface(whoThread);
                if (appThread == null) {
                    throw new IllegalArgumentException("Bad app thread " + appThread);
                }
            }
            return ActivityManagerService.this.mActivityStarter.startActivityMayWait(appThread, -1, callingPackage, intent, resolvedType, null, null, null, null, 0, 0, null, null, null, bOptions, false, callingUser, null, tr, "AppTaskImpl");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setExcludeFromRecents(boolean exclude) {
            this.checkCaller();
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                long origId = Binder.clearCallingIdentity();
                try {
                    TaskRecord tr = ActivityManagerService.this.mStackSupervisor.anyTaskForIdLocked(this.mTaskId);
                    if (tr == null) {
                        throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                    }
                    Intent intent = tr.getBaseIntent();
                    if (exclude) {
                        intent.addFlags(0x800000);
                    } else {
                        intent.setFlags(intent.getFlags() & 0xFF7FFFFF);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    private final class SleepTokenImpl
    extends ActivityManagerInternal.SleepToken {
        private final String mTag;
        private final long mAcquireTime;

        public SleepTokenImpl(String tag) {
            this.mTag = tag;
            this.mAcquireTime = SystemClock.uptimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                if (ActivityManagerService.this.mSleepTokens.remove(this)) {
                    ActivityManagerService.this.updateSleepIfNeededLocked();
                }
            }
        }

        public String toString() {
            return "{\"" + this.mTag + "\", acquire at " + TimeUtils.formatUptime(this.mAcquireTime) + "}";
        }
    }

    final class LocalService
    extends ActivityManagerInternal {
        LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantUriPermissionFromIntent(int callingUid, String targetPkg, Intent intent, int targetUserId) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.grantUriPermissionFromIntentLocked(callingUid, targetPkg, intent, null, targetUserId);
            }
        }

        @Override
        public String checkContentProviderAccess(String authority, int userId) {
            return ActivityManagerService.this.checkContentProviderAccess(authority, userId);
        }

        @Override
        public void onWakefulnessChanged(int wakefulness) {
            ActivityManagerService.this.onWakefulnessChanged(wakefulness);
        }

        @Override
        public int startIsolatedProcess(String entryPoint, String[] entryPointArgs, String processName, String abiOverride, int uid, Runnable crashHandler) {
            return ActivityManagerService.this.startIsolatedProcess(entryPoint, entryPointArgs, processName, abiOverride, uid, crashHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActivityManagerInternal.SleepToken acquireSleepToken(String tag) {
            Preconditions.checkNotNull(tag);
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                SleepTokenImpl token = new SleepTokenImpl(tag);
                ActivityManagerService.this.mSleepTokens.add(token);
                ActivityManagerService.this.updateSleepIfNeededLocked();
                return token;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ComponentName getHomeActivityForUser(int userId) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityRecord homeActivity = ActivityManagerService.this.mStackSupervisor.getHomeActivityForUser(userId);
                return homeActivity == null ? null : homeActivity.realActivity;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUserRemoved(int userId) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.onUserStoppedLocked(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocalVoiceInteractionStarted(IBinder activity, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.onLocalVoiceInteractionStartedLocked(activity, voiceSession, voiceInteractor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyAppTransitionStarting(SparseIntArray reasons, long timestamp) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.mStackSupervisor.mActivityMetricsLogger.notifyTransitionStarting(reasons, timestamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyAppTransitionFinished() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.mStackSupervisor.notifyAppTransitionDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyAppTransitionCancelled() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.mStackSupervisor.notifyAppTransitionDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<IBinder> getTopVisibleActivities() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                return ActivityManagerService.this.mStackSupervisor.getTopVisibleActivities();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyDockedStackMinimizedChanged(boolean minimized) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.mStackSupervisor.setDockedStackMinimized(minimized);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void killForegroundAppsForUser(int userHandle) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
                int NP = ActivityManagerService.this.mProcessNames.getMap().size();
                for (int ip = 0; ip < NP; ++ip) {
                    SparseArray<ProcessRecord> apps = ActivityManagerService.this.mProcessNames.getMap().valueAt(ip);
                    int NA = apps.size();
                    for (int ia = 0; ia < NA; ++ia) {
                        ProcessRecord app = apps.valueAt(ia);
                        if (app.persistent) continue;
                        if (app.removed) {
                            procs.add(app);
                            continue;
                        }
                        if (app.userId != userHandle || !app.foregroundActivities) continue;
                        app.removed = true;
                        procs.add(app);
                    }
                }
                int N = procs.size();
                for (int i = 0; i < N; ++i) {
                    ActivityManagerService.this.removeProcessLocked((ProcessRecord)procs.get(i), false, true, "kill all fg");
                }
            }
        }

        @Override
        public void setPendingIntentWhitelistDuration(IIntentSender target, IBinder whitelistToken, long duration) {
            if (!(target instanceof PendingIntentRecord)) {
                Slog.w("ActivityManager", "markAsSentFromNotification(): not a PendingIntentRecord: " + target);
                return;
            }
            ((PendingIntentRecord)target).setWhitelistDurationLocked(whitelistToken, duration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDeviceIdleWhitelist(int[] appids) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.mDeviceIdleWhitelist = appids;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateDeviceIdleTempWhitelist(int[] appids, int changingAppId, boolean adding) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.mDeviceIdleTempWhitelist = appids;
                ActivityManagerService.this.setAppIdTempWhitelistStateLocked(changingAppId, adding);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updatePersistentConfigurationForUser(Configuration values, int userId) {
            Preconditions.checkNotNull(values, "Configuration must not be null");
            Preconditions.checkArgumentNonnegative(userId, "userId " + userId + " not supported");
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.updateConfigurationLocked(values, null, false, true, userId, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startActivitiesAsPackage(String packageName, int userId, Intent[] intents, Bundle bOptions) {
            Preconditions.checkNotNull(intents, "intents");
            String[] resolvedTypes = new String[intents.length];
            for (int i = 0; i < intents.length; ++i) {
                resolvedTypes[i] = intents[i].resolveTypeIfNeeded(ActivityManagerService.this.mContext.getContentResolver());
            }
            int packageUid = 0;
            try {
                packageUid = AppGlobals.getPackageManager().getPackageUid(packageName, 0x10000000, userId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                return ActivityManagerService.this.startActivitiesInPackage(packageUid, packageName, intents, resolvedTypes, null, bOptions, userId);
            }
        }

        @Override
        public int getUidProcessState(int uid) {
            return ActivityManagerService.this.getUidState(uid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyKeyguardFlagsChanged(Runnable callback) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.mWindowManager.prepareAppTransition(0, false);
                ActivityManagerService.this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
                ActivityManagerService.this.mWindowManager.executeAppTransition();
            }
            if (callback != null) {
                callback.run();
            }
        }

        @Override
        public boolean isSystemReady() {
            return ActivityManagerService.this.mSystemReady;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyKeyguardTrustedChanged() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                if (ActivityManagerService.this.mKeyguardController.isKeyguardShowing()) {
                    ActivityManagerService.this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setHasOverlayUi(int pid, boolean hasOverlayUi) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ProcessRecord pr;
                SparseArray<ProcessRecord> sparseArray = ActivityManagerService.this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    pr = ActivityManagerService.this.mPidsSelfLocked.get(pid);
                    if (pr == null) {
                        Slog.w("ActivityManager", "setHasOverlayUi called on unknown pid: " + pid);
                        return;
                    }
                }
                if (pr.hasOverlayUi == hasOverlayUi) {
                    return;
                }
                pr.hasOverlayUi = hasOverlayUi;
                ActivityManagerService.this.updateOomAdjLocked(pr, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyNetworkPolicyRulesUpdated(int uid, long procStateSeq) {
            UidRecord record;
            Object object = ActivityManagerService.this;
            synchronized (object) {
                record = ActivityManagerService.this.mActiveUids.get(uid);
                if (record == null) {
                    return;
                }
            }
            object = record.networkStateLock;
            synchronized (object) {
                if (record.lastNetworkUpdatedProcStateSeq >= procStateSeq) {
                    return;
                }
                record.lastNetworkUpdatedProcStateSeq = procStateSeq;
                if (record.curProcStateSeq > procStateSeq) {
                    return;
                }
                if (record.waitingForNetwork) {
                    record.networkStateLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setVr2dDisplayId(int vr2dDisplayId) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.mVr2dDisplayId = vr2dDisplayId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveANRState(String reason) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                StringWriter sw = new StringWriter();
                FastPrintWriter pw = new FastPrintWriter(sw, false, 1024);
                pw.println("  ANR time: " + DateFormat.getDateTimeInstance().format(new Date()));
                if (reason != null) {
                    pw.println("  Reason: " + reason);
                }
                ((PrintWriter)pw).println();
                ActivityManagerService.this.mActivityStarter.dump(pw, "  ");
                ((PrintWriter)pw).println();
                pw.println("-------------------------------------------------------------------------------");
                ActivityManagerService.this.dumpActivitiesLocked(null, pw, null, 0, true, false, null, "");
                ((PrintWriter)pw).println();
                ((PrintWriter)pw).close();
                ActivityManagerService.this.mLastANRState = sw.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearSavedANRState() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.mLastANRState = null;
            }
        }
    }

    static final class MemItem {
        final boolean isProc;
        final String label;
        final String shortLabel;
        final long pss;
        final long swapPss;
        final int id;
        final boolean hasActivities;
        ArrayList<MemItem> subitems;

        public MemItem(String _label, String _shortLabel, long _pss, long _swapPss, int _id, boolean _hasActivities) {
            this.isProc = true;
            this.label = _label;
            this.shortLabel = _shortLabel;
            this.pss = _pss;
            this.swapPss = _swapPss;
            this.id = _id;
            this.hasActivities = _hasActivities;
        }

        public MemItem(String _label, String _shortLabel, long _pss, long _swapPss, int _id) {
            this.isProc = false;
            this.label = _label;
            this.shortLabel = _shortLabel;
            this.pss = _pss;
            this.swapPss = _swapPss;
            this.id = _id;
            this.hasActivities = false;
        }
    }

    static class ItemMatcher {
        ArrayList<ComponentName> components;
        ArrayList<String> strings;
        ArrayList<Integer> objects;
        boolean all = true;

        ItemMatcher() {
        }

        void build(String name) {
            ComponentName componentName = ComponentName.unflattenFromString(name);
            if (componentName != null) {
                if (this.components == null) {
                    this.components = new ArrayList();
                }
                this.components.add(componentName);
                this.all = false;
            } else {
                int objectId = 0;
                try {
                    objectId = Integer.parseInt(name, 16);
                    if (this.objects == null) {
                        this.objects = new ArrayList();
                    }
                    this.objects.add(objectId);
                    this.all = false;
                }
                catch (RuntimeException e) {
                    if (this.strings == null) {
                        this.strings = new ArrayList();
                    }
                    this.strings.add(name);
                    this.all = false;
                }
            }
        }

        int build(String[] args, int opti) {
            while (opti < args.length) {
                String name = args[opti];
                if ("--".equals(name)) {
                    return opti + 1;
                }
                this.build(name);
                ++opti;
            }
            return opti;
        }

        boolean match(Object object, ComponentName comp) {
            int i;
            if (this.all) {
                return true;
            }
            if (this.components != null) {
                for (i = 0; i < this.components.size(); ++i) {
                    if (!this.components.get(i).equals(comp)) continue;
                    return true;
                }
            }
            if (this.objects != null) {
                for (i = 0; i < this.objects.size(); ++i) {
                    if (System.identityHashCode(object) != this.objects.get(i)) continue;
                    return true;
                }
            }
            if (this.strings != null) {
                String flat = comp.flattenToString();
                for (int i2 = 0; i2 < this.strings.size(); ++i2) {
                    if (!flat.contains(this.strings.get(i2))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class NeededUriGrants
    extends ArrayList<GrantUri> {
        final String targetPkg;
        final int targetUid;
        final int flags;

        NeededUriGrants(String targetPkg, int targetUid, int flags) {
            this.targetPkg = targetPkg;
            this.targetUid = targetUid;
            this.flags = flags;
        }
    }

    class IntentFirewallInterface
    implements IntentFirewall.AMSInterface {
        IntentFirewallInterface() {
        }

        @Override
        public int checkComponentPermission(String permission2, int pid, int uid, int owningUid, boolean exported) {
            return ActivityManagerService.this.checkComponentPermission(permission2, pid, uid, owningUid, exported);
        }

        @Override
        public Object getAMSLock() {
            return ActivityManagerService.this;
        }
    }

    static class PermissionController
    extends IPermissionController.Stub {
        ActivityManagerService mActivityManagerService;

        PermissionController(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        public boolean checkPermission(String permission2, int pid, int uid) {
            return this.mActivityManagerService.checkPermission(permission2, pid, uid) == 0;
        }

        @Override
        public String[] getPackagesForUid(int uid) {
            return this.mActivityManagerService.mContext.getPackageManager().getPackagesForUid(uid);
        }

        @Override
        public boolean isRuntimePermission(String permission2) {
            try {
                PermissionInfo info = this.mActivityManagerService.mContext.getPackageManager().getPermissionInfo(permission2, 0);
                return (info.protectionLevel & 0xF) == 1;
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                Slog.e("ActivityManager", "No such permission: " + permission2, nnfe);
                return false;
            }
        }
    }

    static class ProcessInfoService
    extends IProcessInfoService.Stub {
        final ActivityManagerService mActivityManagerService;

        ProcessInfoService(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        public void getProcessStatesFromPids(int[] pids, int[] states) {
            this.mActivityManagerService.getProcessStatesAndOomScoresForPIDs(pids, states, null);
        }

        @Override
        public void getProcessStatesAndOomScoresFromPids(int[] pids, int[] states, int[] scores) {
            this.mActivityManagerService.getProcessStatesAndOomScoresForPIDs(pids, states, scores);
        }
    }

    public static class DumpStackFileObserver
    extends FileObserver {
        private static final int TRACE_DUMP_TIMEOUT_MS = 10000;
        static final int NATIVE_DUMP_TIMEOUT_MS = 2000;
        private final String mTracesPath;
        private boolean mClosed;

        public DumpStackFileObserver(String tracesPath) {
            super(tracesPath, 8);
            this.mTracesPath = tracesPath;
        }

        @Override
        public synchronized void onEvent(int event, String path) {
            this.mClosed = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long dumpWithTimeout(int pid, long timeout) {
            android.os.Process.sendSignal(pid, 3);
            long start = SystemClock.elapsedRealtime();
            long waitTime = Math.min(timeout, 10000L);
            DumpStackFileObserver dumpStackFileObserver = this;
            synchronized (dumpStackFileObserver) {
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException e) {
                    Slog.wtf("ActivityManager", e);
                }
            }
            long timeWaited = SystemClock.elapsedRealtime() - start;
            if (timeWaited >= timeout) {
                return timeWaited;
            }
            if (!this.mClosed) {
                Slog.w("ActivityManager", "Didn't see close of " + this.mTracesPath + " for pid " + pid + ". Attempting native stack collection.");
                long nativeDumpTimeoutMs = Math.min(2000L, timeout - timeWaited);
                Debug.dumpNativeBacktraceToFileTimeout(pid, this.mTracesPath, (int)(nativeDumpTimeoutMs / 1000L));
            }
            long end = SystemClock.elapsedRealtime();
            this.mClosed = false;
            return end - start;
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private final ActivityManagerService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new ActivityManagerService(context);
        }

        @Override
        public void onStart() {
            this.mService.start();
        }

        public ActivityManagerService getService() {
            return this.mService;
        }
    }

    static class CpuBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        CpuBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mActivityManagerService.mContext, "cpuinfo", pw)) {
                return;
            }
            ProcessCpuTracker processCpuTracker = this.mActivityManagerService.mProcessCpuTracker;
            synchronized (processCpuTracker) {
                pw.print(this.mActivityManagerService.mProcessCpuTracker.printCurrentLoad());
                pw.print(this.mActivityManagerService.mProcessCpuTracker.printCurrentState(SystemClock.uptimeMillis()));
            }
        }
    }

    static class DbBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        DbBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mActivityManagerService.mContext, "dbinfo", pw)) {
                return;
            }
            this.mActivityManagerService.dumpDbInfo(fd, pw, args);
        }
    }

    static class GraphicsBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        GraphicsBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mActivityManagerService.mContext, "gfxinfo", pw)) {
                return;
            }
            this.mActivityManagerService.dumpGraphicsHardwareUsage(fd, pw, args);
        }
    }

    static class MemBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        MemBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mActivityManagerService.mContext, "meminfo", pw)) {
                return;
            }
            this.mActivityManagerService.dumpApplicationMemoryUsage(fd, pw, "  ", args, false, null);
        }
    }

    final class MainHandler
    extends Handler {
        public MainHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 4: {
                    ContentResolver resolver = ActivityManagerService.this.mContext.getContentResolver();
                    Settings.System.putConfigurationForUser(resolver, (Configuration)msg.obj, msg.arg1);
                    break;
                }
                case 5: {
                    ActivityManagerService resolver = ActivityManagerService.this;
                    synchronized (resolver) {
                        ActivityManagerService.this.performAppGcsIfAppropriateLocked();
                        break;
                    }
                }
                case 12: {
                    if (ActivityManagerService.this.mDidDexOpt) {
                        ActivityManagerService.this.mDidDexOpt = false;
                        Message nmsg = ActivityManagerService.this.mHandler.obtainMessage(12);
                        nmsg.obj = msg.obj;
                        ActivityManagerService.this.mHandler.sendMessageDelayed(nmsg, 20000L);
                        return;
                    }
                    ActivityManagerService.this.mServices.serviceTimeout((ProcessRecord)msg.obj);
                    break;
                }
                case 66: {
                    ActivityManagerService.this.mServices.serviceForegroundTimeout((ServiceRecord)msg.obj);
                    break;
                }
                case 69: {
                    ActivityManagerService.this.mServices.serviceForegroundCrash((ProcessRecord)msg.obj);
                    break;
                }
                case 67: {
                    RemoteCallbackList callbacks = (RemoteCallbackList)msg.obj;
                    int N = callbacks.beginBroadcast();
                    for (int i = 0; i < N; ++i) {
                        try {
                            ((IResultReceiver)callbacks.getBroadcastItem(i)).send(0, null);
                            continue;
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    callbacks.finishBroadcast();
                    break;
                }
                case 13: {
                    ActivityManagerService callbacks = ActivityManagerService.this;
                    synchronized (callbacks) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.updateTimeZone();
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w("ActivityManager", "Failed to update time zone for: " + r.info.processName);
                            }
                        }
                        break;
                    }
                }
                case 28: {
                    ActivityManagerService callbacks = ActivityManagerService.this;
                    synchronized (callbacks) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.clearDnsCache();
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w("ActivityManager", "Failed to clear dns cache for: " + r.info.processName);
                            }
                        }
                        break;
                    }
                }
                case 29: {
                    ProxyInfo proxy = (ProxyInfo)msg.obj;
                    String host = "";
                    String port = "";
                    String exclList = "";
                    Uri pacFileUrl = Uri.EMPTY;
                    if (proxy != null) {
                        host = proxy.getHost();
                        port = Integer.toString(proxy.getPort());
                        exclList = proxy.getExclusionListAsString();
                        pacFileUrl = proxy.getPacFileUrl();
                    }
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.setHttpProxy(host, port, exclList, pacFileUrl);
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w("ActivityManager", "Failed to update http proxy for: " + r.info.processName);
                            }
                        }
                        break;
                    }
                }
                case 20: {
                    if (ActivityManagerService.this.mDidDexOpt) {
                        ActivityManagerService.this.mDidDexOpt = false;
                        Message nmsg = ActivityManagerService.this.mHandler.obtainMessage(20);
                        nmsg.obj = msg.obj;
                        ActivityManagerService.this.mHandler.sendMessageDelayed(nmsg, 10000L);
                        return;
                    }
                    ProcessRecord app = (ProcessRecord)msg.obj;
                    ActivityManagerService host = ActivityManagerService.this;
                    synchronized (host) {
                        ActivityManagerService.this.processStartTimedOutLocked(app);
                        break;
                    }
                }
                case 57: {
                    ProcessRecord app = (ProcessRecord)msg.obj;
                    ActivityManagerService host = ActivityManagerService.this;
                    synchronized (host) {
                        ActivityManagerService.this.processContentProviderPublishTimedOutLocked(app);
                        break;
                    }
                }
                case 21: {
                    ActivityManagerService app = ActivityManagerService.this;
                    synchronized (app) {
                        ActivityManagerService.this.mActivityStarter.doPendingActivityLaunchesLocked(true);
                        break;
                    }
                }
                case 22: {
                    ActivityManagerService app = ActivityManagerService.this;
                    synchronized (app) {
                        int appId = msg.arg1;
                        int userId = msg.arg2;
                        Bundle bundle = (Bundle)msg.obj;
                        String pkg = bundle.getString("pkg");
                        String reason = bundle.getString("reason");
                        ActivityManagerService.this.forceStopPackageLocked(pkg, appId, false, false, true, false, false, userId, reason);
                        break;
                    }
                }
                case 23: {
                    ((PendingIntentRecord)msg.obj).completeFinalize();
                    break;
                }
                case 24: {
                    INotificationManager inm = NotificationManager.getService();
                    if (inm == null) {
                        return;
                    }
                    ActivityRecord root = (ActivityRecord)msg.obj;
                    ProcessRecord process = root.app;
                    if (process == null) {
                        return;
                    }
                    try {
                        Context context = ActivityManagerService.this.mContext.createPackageContext(process.info.packageName, 0);
                        String text = ActivityManagerService.this.mContext.getString(17039938, context.getApplicationInfo().loadLabel(context.getPackageManager()));
                        Notification notification = new Notification.Builder(context, SystemNotificationChannels.DEVELOPER).setSmallIcon(17303300).setWhen(0L).setOngoing(true).setTicker(text).setColor(ActivityManagerService.this.mContext.getColor(17170761)).setContentTitle(text).setContentText(ActivityManagerService.this.mContext.getText(17039939)).setContentIntent(PendingIntent.getActivityAsUser(ActivityManagerService.this.mContext, 0, root.intent, 0x10000000, null, new UserHandle(root.userId))).build();
                        try {
                            inm.enqueueNotificationWithTag("android", "android", null, 11, notification, root.userId);
                        }
                        catch (RuntimeException e) {
                            Slog.w("ActivityManager", "Error showing notification for heavy-weight app", e);
                        }
                        catch (RemoteException e) {
                        }
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.w("ActivityManager", "Unable to create context for heavy notification", e);
                    }
                    break;
                }
                case 25: {
                    INotificationManager inm = NotificationManager.getService();
                    if (inm == null) {
                        return;
                    }
                    try {
                        inm.cancelNotificationWithTag("android", null, 11, msg.arg1);
                    }
                    catch (RuntimeException e) {
                        Slog.w("ActivityManager", "Error canceling notification for service", e);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 27: {
                    ActivityManagerService inm = ActivityManagerService.this;
                    synchronized (inm) {
                        ActivityManagerService.this.checkExcessivePowerUsageLocked(true);
                        this.removeMessages(27);
                        Message nmsg = this.obtainMessage(27);
                        this.sendMessageDelayed(nmsg, ActivityManagerService.this.mConstants.POWER_CHECK_DELAY);
                        break;
                    }
                }
                case 33: {
                    final ArrayList memInfos = (ArrayList)msg.obj;
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            ActivityManagerService.this.reportMemUsage(memInfos);
                        }
                    };
                    thread.start();
                    break;
                }
                case 712: {
                    ActivityManagerService.this.mUserController.startUserInForeground(msg.arg1);
                    break;
                }
                case 34: {
                    ActivityManagerService.this.mUserController.dispatchUserSwitch((UserState)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 35: {
                    ActivityManagerService.this.mUserController.continueUserSwitch((UserState)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 36: {
                    ActivityManagerService.this.mUserController.timeoutUserSwitch((UserState)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 37: {
                    boolean nextState;
                    boolean bl = nextState = msg.arg1 != 0;
                    if (ActivityManagerService.this.mUpdateLock.isHeld() == nextState) break;
                    if (nextState) {
                        ActivityManagerService.this.mUpdateLock.acquire();
                        break;
                    }
                    ActivityManagerService.this.mUpdateLock.release();
                    break;
                }
                case 38: {
                    ActivityManagerService.this.writeGrantedUriPermissions();
                    break;
                }
                case 39: {
                    ActivityManagerService nextState = ActivityManagerService.this;
                    synchronized (nextState) {
                        ActivityManagerService.this.requestPssAllProcsLocked(SystemClock.uptimeMillis(), true, false);
                        break;
                    }
                }
                case 40: {
                    ActivityManagerService nextState = ActivityManagerService.this;
                    synchronized (nextState) {
                        ActivityManagerService.this.mUserController.startProfilesLocked();
                        break;
                    }
                }
                case 41: {
                    ActivityManagerService nextState = ActivityManagerService.this;
                    synchronized (nextState) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r2 = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r2.thread == null) continue;
                            try {
                                r2.thread.updateTimePrefs(msg.arg1);
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w("ActivityManager", "Failed to update preferences for: " + r2.info.processName);
                            }
                        }
                        break;
                    }
                }
                case 42: {
                    ActivityManagerService.this.mBatteryStatsService.noteEvent(32775, Integer.toString(msg.arg1), msg.arg1);
                    ActivityManagerService.this.mSystemServiceManager.startUser(msg.arg1);
                    break;
                }
                case 59: {
                    int userId = msg.arg1;
                    ActivityManagerService.this.mSystemServiceManager.unlockUser(userId);
                    ActivityManagerService i = ActivityManagerService.this;
                    synchronized (i) {
                        ActivityManagerService.this.mRecentTasks.loadUserRecentsLocked(userId);
                    }
                    if (userId == 0) {
                        ActivityManagerService.this.startPersistentApps(262144);
                    }
                    ActivityManagerService.this.installEncryptionUnawareProviders(userId);
                    ActivityManagerService.this.mUserController.finishUserUnlocked((UserState)msg.obj);
                    break;
                }
                case 43: {
                    ActivityManagerService.this.mBatteryStatsService.noteEvent(16392, Integer.toString(msg.arg2), msg.arg2);
                    ActivityManagerService.this.mBatteryStatsService.noteEvent(32776, Integer.toString(msg.arg1), msg.arg1);
                    ActivityManagerService.this.mSystemServiceManager.switchUser(msg.arg1);
                    break;
                }
                case 44: {
                    ActivityManagerService userId = ActivityManagerService.this;
                    synchronized (userId) {
                        ActivityRecord r = ActivityRecord.forTokenLocked((IBinder)msg.obj);
                        if (r != null && r.app != null && r.app.thread != null) {
                            try {
                                r.app.thread.scheduleEnterAnimationComplete(r.appToken);
                            }
                            catch (RemoteException r2) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                }
                case 45: {
                    if (msg.arg1 != 0) {
                        Trace.traceBegin(64L, "FinishBooting");
                        ActivityManagerService.this.finishBooting();
                        Trace.traceEnd(64L);
                    }
                    if (msg.arg2 == 0) break;
                    ActivityManagerService.this.enableScreenAfterBoot();
                    break;
                }
                case 47: {
                    try {
                        Locale l = (Locale)msg.obj;
                        IBinder service = ServiceManager.getService("mount");
                        IStorageManager storageManager = IStorageManager.Stub.asInterface(service);
                        Log.d("ActivityManager", "Storing locale " + l.toLanguageTag() + " for decryption UI");
                        storageManager.setField("SystemLocale", l.toLanguageTag());
                    }
                    catch (RemoteException e) {
                        Log.e("ActivityManager", "Error storing locale for decryption UI", e);
                    }
                    break;
                }
                case 49: {
                    int uid = msg.arg1;
                    byte[] firstPacket = (byte[])msg.obj;
                    SparseArray<ProcessRecord> storageManager = ActivityManagerService.this.mPidsSelfLocked;
                    synchronized (storageManager) {
                        for (int i = 0; i < ActivityManagerService.this.mPidsSelfLocked.size(); ++i) {
                            ProcessRecord p = ActivityManagerService.this.mPidsSelfLocked.valueAt(i);
                            if (p.uid != uid) continue;
                            try {
                                p.thread.notifyCleartextNetwork(firstPacket);
                                continue;
                            }
                            catch (RemoteException notification) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                }
                case 50: {
                    String reportPackage;
                    long memLimit;
                    int uid;
                    String procName;
                    ActivityManagerService notification = ActivityManagerService.this;
                    synchronized (notification) {
                        procName = ActivityManagerService.this.mMemWatchDumpProcName;
                        uid = ActivityManagerService.this.mMemWatchDumpUid;
                        Pair<Long, String> val = ActivityManagerService.this.mMemWatchProcesses.get(procName, uid);
                        if (val == null) {
                            val = ActivityManagerService.this.mMemWatchProcesses.get(procName, 0);
                        }
                        if (val != null) {
                            memLimit = (Long)val.first;
                            reportPackage = (String)val.second;
                        } else {
                            memLimit = 0L;
                            reportPackage = null;
                        }
                    }
                    if (procName == null) {
                        return;
                    }
                    INotificationManager inm = NotificationManager.getService();
                    if (inm == null) {
                        return;
                    }
                    String text = ActivityManagerService.this.mContext.getString(17039773, procName);
                    Intent deleteIntent = new Intent();
                    deleteIntent.setAction("com.android.server.am.DELETE_DUMPHEAP");
                    Intent intent = new Intent();
                    intent.setClassName("android", DumpHeapActivity.class.getName());
                    intent.putExtra("process", procName);
                    intent.putExtra("size", memLimit);
                    if (reportPackage != null) {
                        intent.putExtra("direct_launch", reportPackage);
                    }
                    int userId = UserHandle.getUserId(uid);
                    Notification notification2 = new Notification.Builder(ActivityManagerService.this.mContext, SystemNotificationChannels.DEVELOPER).setSmallIcon(17303300).setWhen(0L).setOngoing(true).setAutoCancel(true).setTicker(text).setColor(ActivityManagerService.this.mContext.getColor(17170761)).setContentTitle(text).setContentText(ActivityManagerService.this.mContext.getText(17039774)).setContentIntent(PendingIntent.getActivityAsUser(ActivityManagerService.this.mContext, 0, intent, 0x10000000, null, new UserHandle(userId))).setDeleteIntent(PendingIntent.getBroadcastAsUser(ActivityManagerService.this.mContext, 0, deleteIntent, 0, UserHandle.SYSTEM)).build();
                    try {
                        inm.enqueueNotificationWithTag("android", "android", null, 12, notification2, userId);
                    }
                    catch (RuntimeException e) {
                        Slog.w("ActivityManager", "Error showing notification for dump heap", e);
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                case 51: {
                    ActivityManagerService.this.revokeUriPermission(ActivityThread.currentActivityThread().getApplicationThread(), null, DumpHeapActivity.JAVA_URI, 3, UserHandle.myUserId());
                    ActivityManagerService procName = ActivityManagerService.this;
                    synchronized (procName) {
                        ActivityManagerService.this.mMemWatchDumpFile = null;
                        ActivityManagerService.this.mMemWatchDumpProcName = null;
                        ActivityManagerService.this.mMemWatchDumpPid = -1;
                        ActivityManagerService.this.mMemWatchDumpUid = -1;
                        break;
                    }
                }
                case 52: {
                    ActivityManagerService.this.mUserController.dispatchForegroundProfileChanged(msg.arg1);
                    break;
                }
                case 54: {
                    AppTimeTracker tracker = (AppTimeTracker)msg.obj;
                    tracker.deliverResult(ActivityManagerService.this.mContext);
                    break;
                }
                case 55: {
                    ActivityManagerService.this.mUserController.dispatchUserSwitchComplete(msg.arg1);
                    break;
                }
                case 64: {
                    ActivityManagerService.this.mUserController.dispatchLockedBootComplete(msg.arg1);
                    break;
                }
                case 56: {
                    IUiAutomationConnection connection = (IUiAutomationConnection)msg.obj;
                    try {
                        connection.shutdown();
                    }
                    catch (RemoteException e) {
                        Slog.w("ActivityManager", "Error shutting down UiAutomationConnection");
                    }
                    ActivityManagerService.this.mUserIsMonkey = false;
                    break;
                }
                case 58: {
                    ActivityManagerService.this.idleUids();
                    break;
                }
                case 61: {
                    if (!ActivityManagerService.this.mVrController.onVrModeChanged((ActivityRecord)msg.obj)) {
                        return;
                    }
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        PinnedActivityStack pinnedStack;
                        boolean disableNonVrUi = ActivityManagerService.this.mVrController.shouldDisableNonVrUiLocked();
                        ActivityManagerService.this.mWindowManager.disableNonVrUi(disableNonVrUi);
                        if (disableNonVrUi && (pinnedStack = (PinnedActivityStack)ActivityManagerService.this.mStackSupervisor.getStack(4)) != null) {
                            ActivityManagerService.this.mStackSupervisor.removeStackLocked(4);
                        }
                        break;
                    }
                }
                case 65: {
                    ActivityManagerService.this.notifyVrManagerOfSleepState(msg.arg1 != 0);
                    break;
                }
                case 63: {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.handleTrustStorageUpdate();
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w("ActivityManager", "Failed to handle trust storage update for: " + r.info.processName);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    final class UiHandler
    extends Handler {
        public UiHandler() {
            super(UiThread.get().getLooper(), null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ActivityManagerService.this.mAppErrors.handleShowAppErrorUi(msg);
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 2: {
                    ActivityManagerService.this.mAppErrors.handleShowAnrUi(msg);
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 26: {
                    HashMap data = (HashMap)msg.obj;
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        ProcessRecord proc = (ProcessRecord)data.get("app");
                        if (proc == null) {
                            Slog.e("ActivityManager", "App not found when showing strict mode dialog.");
                            break;
                        }
                        if (proc.crashDialog != null) {
                            Slog.e("ActivityManager", "App already has strict mode dialog: " + proc);
                            return;
                        }
                        AppErrorResult res = (AppErrorResult)data.get("result");
                        if (ActivityManagerService.this.mShowDialogs && !ActivityManagerService.this.mSleeping && !ActivityManagerService.this.mShuttingDown) {
                            StrictModeViolationDialog d = new StrictModeViolationDialog(ActivityManagerService.this.mUiContext, ActivityManagerService.this, res, proc);
                            d.show();
                            proc.crashDialog = d;
                        } else {
                            res.set(0);
                        }
                    }
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 3: {
                    FactoryErrorDialog d = new FactoryErrorDialog(ActivityManagerService.this.mUiContext, msg.getData().getCharSequence("msg"));
                    d.show();
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 6: {
                    ActivityManagerService d = ActivityManagerService.this;
                    synchronized (d) {
                        ProcessRecord app = (ProcessRecord)msg.obj;
                        if (msg.arg1 != 0) {
                            if (!app.waitedForDebugger) {
                                AppWaitingForDebuggerDialog d2 = new AppWaitingForDebuggerDialog(ActivityManagerService.this, ActivityManagerService.this.mUiContext, app);
                                app.waitDialog = d2;
                                app.waitedForDebugger = true;
                                d2.show();
                            }
                        } else if (app.waitDialog != null) {
                            app.waitDialog.dismiss();
                            app.waitDialog = null;
                        }
                        break;
                    }
                }
                case 14: {
                    if (!ActivityManagerService.this.mShowDialogs) break;
                    BaseErrorDialog d = new BaseErrorDialog(ActivityManagerService.this.mUiContext);
                    d.getWindow().setType(2010);
                    d.setCancelable(false);
                    d.setTitle(ActivityManagerService.this.mUiContext.getText(17039465));
                    d.setMessage(ActivityManagerService.this.mUiContext.getText(17040866));
                    d.setButton(-1, ActivityManagerService.this.mUiContext.getText(17039370), this.obtainMessage(48, d));
                    d.show();
                    break;
                }
                case 15: {
                    if (!ActivityManagerService.this.mShowDialogs) break;
                    BaseErrorDialog d = new BaseErrorDialog(ActivityManagerService.this.mUiContext);
                    d.getWindow().setType(2010);
                    d.setCancelable(false);
                    d.setTitle(ActivityManagerService.this.mUiContext.getText(17039465));
                    d.setMessage(ActivityManagerService.this.mUiContext.getText(17040865));
                    d.setButton(-1, ActivityManagerService.this.mUiContext.getText(17039370), this.obtainMessage(48, d));
                    d.show();
                    break;
                }
                case 30: {
                    ActivityManagerService d = ActivityManagerService.this;
                    synchronized (d) {
                        ActivityRecord ar = (ActivityRecord)msg.obj;
                        if (ActivityManagerService.this.mCompatModeDialog != null) {
                            if (ActivityManagerService.this.mCompatModeDialog.mAppInfo.packageName.equals(ar.info.applicationInfo.packageName)) {
                                return;
                            }
                            ActivityManagerService.this.mCompatModeDialog.dismiss();
                            ActivityManagerService.this.mCompatModeDialog = null;
                        }
                        if (ar != null) {
                            // empty if block
                        }
                        break;
                    }
                }
                case 62: {
                    ActivityManagerService d = ActivityManagerService.this;
                    synchronized (d) {
                        ActivityRecord ar = (ActivityRecord)msg.obj;
                        if (ActivityManagerService.this.mUnsupportedDisplaySizeDialog != null) {
                            ActivityManagerService.this.mUnsupportedDisplaySizeDialog.dismiss();
                            ActivityManagerService.this.mUnsupportedDisplaySizeDialog = null;
                        }
                        if (ar != null && ActivityManagerService.this.mCompatModePackages.getPackageNotifyUnsupportedZoomLocked(ar.packageName)) {
                            ActivityManagerService.this.mUnsupportedDisplaySizeDialog = new UnsupportedDisplaySizeDialog(ActivityManagerService.this, ActivityManagerService.this.mUiContext, ar.info.applicationInfo);
                            ActivityManagerService.this.mUnsupportedDisplaySizeDialog.show();
                        }
                        break;
                    }
                }
                case 46: {
                    ActivityManagerService.this.mUserController.showUserSwitchDialog((Pair)msg.obj);
                    break;
                }
                case 48: {
                    Dialog d = (Dialog)msg.obj;
                    d.dismiss();
                    break;
                }
                case 31: {
                    ActivityManagerService.this.dispatchProcessesChanged();
                    break;
                }
                case 32: {
                    int pid = msg.arg1;
                    int uid = msg.arg2;
                    ActivityManagerService.this.dispatchProcessDied(pid, uid);
                    break;
                }
                case 53: {
                    ActivityManagerService.this.dispatchUidsChanged();
                    break;
                }
                case 68: {
                    ActivityManagerService.this.pushTempWhitelist();
                }
            }
        }
    }

    final class KillHandler
    extends Handler {
        static final int KILL_PROCESS_GROUP_MSG = 4000;

        public KillHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 4000: {
                    Trace.traceBegin(64L, "killProcessGroup");
                    android.os.Process.killProcessGroup(msg.arg1, msg.arg2);
                    Trace.traceEnd(64L);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    private final class AppDeathRecipient
    implements IBinder.DeathRecipient {
        final ProcessRecord mApp;
        final int mPid;
        final IApplicationThread mAppThread;

        AppDeathRecipient(ProcessRecord app, int pid, IApplicationThread thread) {
            this.mApp = app;
            this.mPid = pid;
            this.mAppThread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.appDiedLocked(this.mApp, this.mPid, this.mAppThread, true);
            }
        }
    }

    static final class UidObserverRegistration {
        final int uid;
        final String pkg;
        final int which;
        final int cutpoint;
        final SparseIntArray lastProcStates;

        UidObserverRegistration(int _uid, String _pkg, int _which, int _cutpoint) {
            this.uid = _uid;
            this.pkg = _pkg;
            this.which = _which;
            this.cutpoint = _cutpoint;
            this.lastProcStates = this.cutpoint >= 0 ? new SparseIntArray() : null;
        }
    }

    static final class ProcessChangeItem {
        static final int CHANGE_ACTIVITIES = 1;
        int changes;
        int uid;
        int pid;
        int processState;
        boolean foregroundActivities;

        ProcessChangeItem() {
        }
    }

    private static final class UpdateConfigurationResult {
        int changes;
        boolean activityRelaunched;

        private UpdateConfigurationResult() {
        }

        void reset() {
            this.changes = 0;
            this.activityRelaunched = false;
        }
    }

    static final class PendingTempWhitelist {
        final int targetUid;
        final long duration;
        final String tag;

        PendingTempWhitelist(int _targetUid, long _duration, String _tag) {
            this.targetUid = _targetUid;
            this.duration = _duration;
            this.tag = _tag;
        }
    }

    private class Identity {
        public final IBinder token;
        public final int pid;
        public final int uid;

        Identity(IBinder _token, int _pid, int _uid) {
            this.token = _token;
            this.pid = _pid;
            this.uid = _uid;
        }
    }

    private final class FontScaleSettingObserver
    extends ContentObserver {
        private final Uri mFontScaleUri;

        public FontScaleSettingObserver() {
            super(ActivityManagerService.this.mHandler);
            this.mFontScaleUri = Settings.System.getUriFor("font_scale");
            ContentResolver resolver = ActivityManagerService.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.mFontScaleUri, false, this, -1);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            if (this.mFontScaleUri.equals(uri)) {
                ActivityManagerService.this.updateFontScaleIfNeeded(userId);
            }
        }
    }

    public static class GrantUri {
        public final int sourceUserId;
        public final Uri uri;
        public boolean prefix;

        public GrantUri(int sourceUserId, Uri uri, boolean prefix) {
            this.sourceUserId = sourceUserId;
            this.uri = uri;
            this.prefix = prefix;
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = 31 * hashCode + this.sourceUserId;
            hashCode = 31 * hashCode + this.uri.hashCode();
            hashCode = 31 * hashCode + (this.prefix ? 1231 : 1237);
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof GrantUri) {
                GrantUri other = (GrantUri)o;
                return this.uri.equals(other.uri) && this.sourceUserId == other.sourceUserId && this.prefix == other.prefix;
            }
            return false;
        }

        public String toString() {
            String result = this.uri.toString() + " [user " + this.sourceUserId + "]";
            if (this.prefix) {
                result = result + " [prefix]";
            }
            return result;
        }

        public String toSafeString() {
            String result = this.uri.toSafeString() + " [user " + this.sourceUserId + "]";
            if (this.prefix) {
                result = result + " [prefix]";
            }
            return result;
        }

        public static GrantUri resolve(int defaultSourceUserHandle, Uri uri) {
            return new GrantUri(ContentProvider.getUserIdFromUri(uri, defaultSourceUserHandle), ContentProvider.getUriWithoutUserId(uri), false);
        }
    }

    static final class Association {
        final int mSourceUid;
        final String mSourceProcess;
        final int mTargetUid;
        final ComponentName mTargetComponent;
        final String mTargetProcess;
        int mCount;
        long mTime;
        int mNesting;
        long mStartTime;
        int mLastState = 19;
        long mLastStateUptime;
        long[] mStateTimes = new long[19];

        Association(int sourceUid, String sourceProcess, int targetUid, ComponentName targetComponent, String targetProcess) {
            this.mSourceUid = sourceUid;
            this.mSourceProcess = sourceProcess;
            this.mTargetUid = targetUid;
            this.mTargetComponent = targetComponent;
            this.mTargetProcess = targetProcess;
        }
    }

    abstract class ImportanceToken
    implements IBinder.DeathRecipient {
        final int pid;
        final IBinder token;
        final String reason;

        ImportanceToken(int _pid, IBinder _token, String _reason) {
            this.pid = _pid;
            this.token = _token;
            this.reason = _reason;
        }

        public String toString() {
            return "ImportanceToken { " + Integer.toHexString(System.identityHashCode(this)) + " " + this.reason + " " + this.pid + " " + this.token + " }";
        }
    }

    public class PendingAssistExtras
    extends Binder
    implements Runnable {
        public final ActivityRecord activity;
        public boolean isHome;
        public final Bundle extras;
        public final Intent intent;
        public final String hint;
        public final IResultReceiver receiver;
        public final int userHandle;
        public boolean haveResult = false;
        public Bundle result = null;
        public AssistStructure structure = null;
        public AssistContent content = null;
        public Bundle receiverExtras;

        public PendingAssistExtras(ActivityRecord _activity, Bundle _extras, Intent _intent, String _hint, IResultReceiver _receiver, Bundle _receiverExtras, int _userHandle) {
            this.activity = _activity;
            this.extras = _extras;
            this.intent = _intent;
            this.hint = _hint;
            this.receiver = _receiver;
            this.receiverExtras = _receiverExtras;
            this.userHandle = _userHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Slog.w("ActivityManager", "getAssistContextExtras failed: timeout retrieving from " + this.activity);
            PendingAssistExtras pendingAssistExtras = this;
            synchronized (pendingAssistExtras) {
                this.haveResult = true;
                this.notifyAll();
            }
            ActivityManagerService.this.pendingAssistExtrasTimedOut(this);
        }
    }
}

